/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util.translit.japanese;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class JapaneseMapper {
    private static final Map<String, String> KATAKANA = new HashMap<String, String>();
    private static final Map<Character, String> LONG_SOUND_LETTER = new HashMap<Character, String>();
    private static final Map<Character, BigDecimal> NUMBER = new HashMap<Character, BigDecimal>();
    private static final Map<Character, BigDecimal> CARDINAL = new HashMap<Character, BigDecimal>();
    private static final Map<Character, String> DELIMITER = new HashMap<Character, String>();
    private static final Map<Character, String> DECIMAL = new HashMap<Character, String>();

    private static void initKanaMap() {
        KATAKANA.put("\u30a2", "a");
        KATAKANA.put("\u30a4", "i");
        KATAKANA.put("\u30a6", "u");
        KATAKANA.put("\u30a8", "e");
        KATAKANA.put("\u30aa", "o");
        KATAKANA.put("\u30ab", "ka");
        KATAKANA.put("\u30ad", "ki");
        KATAKANA.put("\u30af", "ku");
        KATAKANA.put("\u30b1", "ke");
        KATAKANA.put("\u30b3", "ko");
        KATAKANA.put("\u30b5", "sa");
        KATAKANA.put("\u30b7", "shi");
        KATAKANA.put("\u30b9", "su");
        KATAKANA.put("\u30bb", "se");
        KATAKANA.put("\u30bd", "so");
        KATAKANA.put("\u30bf", "ta");
        KATAKANA.put("\u30c1", "chi");
        KATAKANA.put("\u30c4", "tsu");
        KATAKANA.put("\u30c6", "te");
        KATAKANA.put("\u30c8", "to");
        KATAKANA.put("\u30ca", "na");
        KATAKANA.put("\u30cb", "ni");
        KATAKANA.put("\u30cc", "nu");
        KATAKANA.put("\u30cd", "ne");
        KATAKANA.put("\u30ce", "no");
        KATAKANA.put("\u30cf", "ha");
        KATAKANA.put("\u30d2", "hi");
        KATAKANA.put("\u30d5", "fu");
        KATAKANA.put("\u30d8", "he");
        KATAKANA.put("\u30db", "ho");
        KATAKANA.put("\u30de", "ma");
        KATAKANA.put("\u30df", "mi");
        KATAKANA.put("\u30e0", "mu");
        KATAKANA.put("\u30e1", "me");
        KATAKANA.put("\u30e2", "mo");
        KATAKANA.put("\u30e4", "ya");
        KATAKANA.put("\u30e6", "yu");
        KATAKANA.put("\u30e8", "yo");
        KATAKANA.put("\u30e9", "ra");
        KATAKANA.put("\u30ea", "ri");
        KATAKANA.put("\u30eb", "ru");
        KATAKANA.put("\u30ec", "re");
        KATAKANA.put("\u30ed", "ro");
        KATAKANA.put("\u30ef", "wa");
        KATAKANA.put("\u30f2", "wo");
        KATAKANA.put("\u30f3", "n");
        KATAKANA.put("\u30ac", "ga");
        KATAKANA.put("\u30ae", "gi");
        KATAKANA.put("\u30b0", "gu");
        KATAKANA.put("\u30b2", "ge");
        KATAKANA.put("\u30b4", "go");
        KATAKANA.put("\u30b6", "za");
        KATAKANA.put("\u30b8", "ji");
        KATAKANA.put("\u30ba", "zu");
        KATAKANA.put("\u30bc", "ze");
        KATAKANA.put("\u30be", "zo");
        KATAKANA.put("\u30c0", "da");
        KATAKANA.put("\u30c2", "ji");
        KATAKANA.put("\u30c5", "zu");
        KATAKANA.put("\u30c7", "de");
        KATAKANA.put("\u30c9", "do");
        KATAKANA.put("\u30d0", "ba");
        KATAKANA.put("\u30d3", "bi");
        KATAKANA.put("\u30d6", "bu");
        KATAKANA.put("\u30d9", "be");
        KATAKANA.put("\u30dc", "bo");
        KATAKANA.put("\u30d1", "pa");
        KATAKANA.put("\u30d4", "pi");
        KATAKANA.put("\u30d7", "pu");
        KATAKANA.put("\u30da", "pe");
        KATAKANA.put("\u30dd", "po");
        KATAKANA.put("\u30ad\u30e3", "kya");
        KATAKANA.put("\u30ad\u30e5", "kyu");
        KATAKANA.put("\u30ad\u30e7", "kyo");
        KATAKANA.put("\u30b7\u30e3", "sha");
        KATAKANA.put("\u30b7\u30e5", "shu");
        KATAKANA.put("\u30b7\u30e7", "sho");
        KATAKANA.put("\u30c1\u30e3", "cha");
        KATAKANA.put("\u30c1\u30e5", "chu");
        KATAKANA.put("\u30c1\u30e7", "cho");
        KATAKANA.put("\u30cb\u30e3", "nya");
        KATAKANA.put("\u30cb\u30e5", "nyu");
        KATAKANA.put("\u30cb\u30e7", "nyo");
        KATAKANA.put("\u30d2\u30e3", "hya");
        KATAKANA.put("\u30d2\u30e5", "hyu");
        KATAKANA.put("\u30d2\u30e7", "hyo");
        KATAKANA.put("\u30ea\u30e3", "rya");
        KATAKANA.put("\u30ea\u30e5", "ryu");
        KATAKANA.put("\u30ea\u30e7", "ryo");
        KATAKANA.put("\u30ae\u30e3", "gya");
        KATAKANA.put("\u30ae\u30e5", "gyu");
        KATAKANA.put("\u30ae\u30e7", "gyo");
        KATAKANA.put("\u30b8\u30e3", "ja");
        KATAKANA.put("\u30b8\u30e5", "ju");
        KATAKANA.put("\u30b8\u30e7", "jo");
        KATAKANA.put("\u30c6\u30a3", "ti");
        KATAKANA.put("\u30c7\u30a3", "di");
        KATAKANA.put("\u30c4\u30a3", "tsi");
        KATAKANA.put("\u30c2\u30e3", "dya");
        KATAKANA.put("\u30c2\u30e5", "dyu");
        KATAKANA.put("\u30c2\u30e7", "dyo");
        KATAKANA.put("\u30d3\u30e3", "bya");
        KATAKANA.put("\u30d3\u30e5", "byu");
        KATAKANA.put("\u30d3\u30e7", "byo");
        KATAKANA.put("\u30d4\u30e3", "pya");
        KATAKANA.put("\u30d4\u30e5", "pyu");
        KATAKANA.put("\u30d4\u30e7", "pyo");
        KATAKANA.put("\u30c1\u30a7", "che");
        KATAKANA.put("\u30d5\u30a3", "fi");
        KATAKANA.put("\u30d5\u30a7", "fe");
        KATAKANA.put("\u30a6\u30a3", "wi");
        KATAKANA.put("\u30a6\u30a7", "we");
        KATAKANA.put("\u30f4\u30a3", "\u2174i");
        KATAKANA.put("\u30f4\u30a7", "ve");
        KATAKANA.put("\u30fc", "-");
        KATAKANA.put("\u300c", "\"");
        KATAKANA.put("\u300d", "\"");
        KATAKANA.put("\u3002", ".");
    }

    private static void initLongSoundMap() {
        LONG_SOUND_LETTER.put(Character.valueOf('a'), "\u0101");
        LONG_SOUND_LETTER.put(Character.valueOf('i'), "\u012b");
        LONG_SOUND_LETTER.put(Character.valueOf('u'), "\u016b");
        LONG_SOUND_LETTER.put(Character.valueOf('e'), "\u0113");
        LONG_SOUND_LETTER.put(Character.valueOf('o'), "\u014d");
    }

    private static void initNumberMap() {
        NUMBER.put(Character.valueOf('0'), BigDecimal.valueOf(0L));
        NUMBER.put(Character.valueOf('1'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('2'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('3'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('4'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('5'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('6'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('7'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('8'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('9'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\uff10'), BigDecimal.valueOf(0L));
        NUMBER.put(Character.valueOf('\uff11'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('\uff12'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('\uff13'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('\uff14'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('\uff15'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('\uff16'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('\uff17'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('\uff18'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('\uff19'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\u3007'), BigDecimal.valueOf(0L));
        NUMBER.put(Character.valueOf('\u4e00'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('\u4e8c'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('\u4e09'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('\u56db'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('\u4e94'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('\u516d'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('\u4e03'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('\u516b'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('\u4e5d'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\u96f6'), BigDecimal.valueOf(0L));
        NUMBER.put(Character.valueOf('\u58f1'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('\u5f10'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('\u53c2'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('\u8086'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('\u4f0d'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('\u9678'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('\u6f06'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('\u634c'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('\u7396'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\u2160'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('\u2161'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('\u2162'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('\u2163'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('\u2164'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('\u2165'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('\u2166'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('\u2167'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('\u2168'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\u2169'), BigDecimal.valueOf(10L));
        NUMBER.put(Character.valueOf('\u216a'), BigDecimal.valueOf(11L));
        NUMBER.put(Character.valueOf('\u216b'), BigDecimal.valueOf(12L));
        NUMBER.put(Character.valueOf('\u2170'), BigDecimal.valueOf(1L));
        NUMBER.put(Character.valueOf('\u2171'), BigDecimal.valueOf(2L));
        NUMBER.put(Character.valueOf('\u2172'), BigDecimal.valueOf(3L));
        NUMBER.put(Character.valueOf('\u2173'), BigDecimal.valueOf(4L));
        NUMBER.put(Character.valueOf('\u2174'), BigDecimal.valueOf(5L));
        NUMBER.put(Character.valueOf('\u2175'), BigDecimal.valueOf(6L));
        NUMBER.put(Character.valueOf('\u2176'), BigDecimal.valueOf(7L));
        NUMBER.put(Character.valueOf('\u2177'), BigDecimal.valueOf(8L));
        NUMBER.put(Character.valueOf('\u2178'), BigDecimal.valueOf(9L));
        NUMBER.put(Character.valueOf('\u2179'), BigDecimal.valueOf(10L));
        NUMBER.put(Character.valueOf('\u217a'), BigDecimal.valueOf(11L));
        NUMBER.put(Character.valueOf('\u217b'), BigDecimal.valueOf(12L));
    }

    private static void initCardinalMap() {
        CARDINAL.put(Character.valueOf('\u5341'), BigDecimal.valueOf(10L));
        CARDINAL.put(Character.valueOf('\u767e'), BigDecimal.valueOf(100L));
        CARDINAL.put(Character.valueOf('\u5343'), BigDecimal.valueOf(1000L));
        CARDINAL.put(Character.valueOf('\u4e07'), BigDecimal.valueOf(10000L));
        CARDINAL.put(Character.valueOf('\u5104'), BigDecimal.valueOf(100000000L));
        CARDINAL.put(Character.valueOf('\u5146'), BigDecimal.valueOf(1000000000000L));
        CARDINAL.put(Character.valueOf('\u4eac'), BigDecimal.valueOf(10000000000000000L));
        CARDINAL.put(Character.valueOf('\u62fe'), BigDecimal.valueOf(10L));
        CARDINAL.put(Character.valueOf('\u964c'), BigDecimal.valueOf(100L));
        CARDINAL.put(Character.valueOf('\u4f70'), BigDecimal.valueOf(100L));
        CARDINAL.put(Character.valueOf('\u9621'), BigDecimal.valueOf(1000L));
        CARDINAL.put(Character.valueOf('\u4edf'), BigDecimal.valueOf(1000L));
        CARDINAL.put(Character.valueOf('\u842c'), BigDecimal.valueOf(10000L));
        CARDINAL.put(Character.valueOf('\u5272'), BigDecimal.valueOf(0.1));
        CARDINAL.put(Character.valueOf('\u5206'), BigDecimal.valueOf(0.01));
        CARDINAL.put(Character.valueOf('\u5398'), BigDecimal.valueOf(0.001));
        CARDINAL.put(Character.valueOf('\u6bdb'), BigDecimal.valueOf(1.0E-4));
    }

    private static void initDelimiterMap() {
        DELIMITER.put(Character.valueOf(','), "Comma");
    }

    private static void initDecimalMap() {
        DECIMAL.put(Character.valueOf('.'), "Full Stop");
    }

    private JapaneseMapper() {
        throw new AssertionError();
    }

    public static boolean isDelimiter(Character c) {
        return DELIMITER.containsKey(c);
    }

    public static boolean isDecimalPoint(Character c) {
        return DECIMAL.containsKey(c);
    }

    public static BigDecimal getNumber(Character c) {
        return NUMBER.get(c);
    }

    public static BigDecimal getCardinal(Character c) {
        return CARDINAL.get(c);
    }

    public static boolean isKatakana(String c) {
        return KATAKANA.containsKey(c);
    }

    public static String getRomaji(String c) {
        return KATAKANA.get(c);
    }

    public static boolean isLongSoundLetter(Character c) {
        return LONG_SOUND_LETTER.containsKey(c);
    }

    public static String getLetterWithDiacritic(Character c) {
        return LONG_SOUND_LETTER.get(c);
    }

    static {
        JapaneseMapper.initKanaMap();
        JapaneseMapper.initLongSoundMap();
        JapaneseMapper.initNumberMap();
        JapaneseMapper.initCardinalMap();
        JapaneseMapper.initDelimiterMap();
        JapaneseMapper.initDecimalMap();
    }
}

