/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import net.osmand.IProgress;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.OsmDbCreator;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;

public class OsmDbAccessor
implements OsmDbAccessorContext {
    protected PreparedStatement pselectNode;
    protected PreparedStatement pselectWay;
    protected PreparedStatement pselectRelation;
    private int allRelations;
    private int allWays;
    private int allNodes;
    private int allBoundaries;
    private boolean realCounts = false;
    protected Connection dbConn;
    protected DBDialect dialect;
    private PreparedStatement iterateNodes;
    private PreparedStatement iterateWays;
    private PreparedStatement iterateRelations;
    private PreparedStatement iterateWayBoundaries;
    private OsmDbCreator dbCreator;
    private OsmDbTagsPreparation tagsPrepration;

    public void initDatabase() throws SQLException {
        this.pselectNode = this.dbConn.prepareStatement("select n.latitude, n.longitude, n.tags from node n where n.id = ?");
        this.pselectWay = this.dbConn.prepareStatement("select w.node, w.ord, w.tags, n.latitude, n.longitude, n.tags from ways w left join node n on w.node = n.id where w.id = ? order by w.ord");
        this.pselectRelation = this.dbConn.prepareStatement("select r.member, r.type, r.role, r.ord, r.tags from relations r where r.id = ? order by r.ord");
        this.iterateNodes = this.dbConn.prepareStatement("select n.id, n.latitude, n.longitude, n.tags from node n where length(n.tags) > 0 or n.propagate = 1");
        this.iterateWays = this.dbConn.prepareStatement("select w.id, w.node, w.ord, w.tags, n.latitude, n.longitude, n.tags from ways w left join node n on w.node = n.id order by w.id, w.ord");
        this.iterateWayBoundaries = this.dbConn.prepareStatement("select w.id, w.node, w.ord, w.tags, n.latitude, n.longitude, n.tags from ways w left join node n on w.node = n.id  where w.boundary > 0 order by w.id, w.ord");
        this.iterateRelations = this.dbConn.prepareStatement("select r.id, r.tags from relations r where length(r.tags) > 0");
    }

    public void updateCounts(OsmDbCreator dbCreator) {
        if (dbCreator != null) {
            this.allNodes += dbCreator.getAllNodes();
            this.allRelations += dbCreator.getAllRelations();
            this.allWays += dbCreator.getAllWays();
        }
    }

    public void setTagsPrepration(OsmDbTagsPreparation tagsPrepration) {
        this.tagsPrepration = tagsPrepration;
    }

    public Connection getDbConn() {
        return this.dbConn;
    }

    public int getAllNodes() {
        return this.allNodes;
    }

    public int getAllRelations() {
        return this.allRelations;
    }

    public int getAllWays() {
        return this.allWays;
    }

    @Override
    public void loadEntityWay(Way e) throws SQLException {
        if (e.getEntityIds().isEmpty()) {
            this.pselectWay.setLong(1, e.getId());
            if (this.pselectWay.execute()) {
                ResultSet rs = this.pselectWay.getResultSet();
                while (rs.next()) {
                    int ord = rs.getInt(2);
                    if (ord == 0) {
                        this.readTags((Entity)e, rs.getBytes(3));
                    }
                    if (rs.getObject(5) != null) {
                        Node n = new Node(rs.getDouble(4), rs.getDouble(5), rs.getLong(1));
                        e.addNode(n);
                        this.readTags((Entity)n, rs.getBytes(6));
                        continue;
                    }
                    e.addNode(rs.getLong(1));
                }
                rs.close();
            }
        }
    }

    @Override
    public void loadEntityRelation(Relation e) throws SQLException {
        this.loadEntityRelation(e, 1);
    }

    @Override
    public Map<Long, Node> retrieveAllRelationNodes(Relation e) throws SQLException {
        HashMap<Long, Node> allNodes = new HashMap<Long, Node>();
        this.retrieveAllRelationNodes(e, allNodes);
        return allNodes;
    }

    private void retrieveAllRelationNodes(Relation e, Map<Long, Node> allNodes) throws SQLException {
        this.loadEntityRelation(e);
        for (Relation.RelationMember member : e.getMembers()) {
            Entity entity = member.getEntity();
            if (entity instanceof Relation) {
                Relation relation = (Relation)entity;
                this.retrieveAllRelationNodes(relation, allNodes);
            }
            if (entity instanceof Way) {
                Way way = (Way)entity;
                for (Node node : way.getNodes()) {
                    allNodes.put(node.getId(), node);
                }
            }
            if (!(entity instanceof Node)) continue;
            Node node = (Node)entity;
            allNodes.put(node.getId(), node);
        }
    }

    public void loadEntityRelation(Relation e, int level) throws SQLException {
        if (e.isDataLoaded()) {
            return;
        }
        LinkedHashMap<Entity.EntityId, Object> map = new LinkedHashMap<Entity.EntityId, Object>();
        if (e.getMembers().isEmpty()) {
            this.pselectRelation.setLong(1, e.getId());
            if (this.pselectRelation.execute()) {
                ResultSet rs = this.pselectRelation.getResultSet();
                while (rs.next()) {
                    int ord = rs.getInt(4);
                    if (ord == 0) {
                        this.readTags((Entity)e, rs.getBytes(5));
                    }
                    e.addMember(Long.valueOf(rs.getLong(1)), Entity.EntityType.values()[rs.getInt(2)], rs.getString(3));
                }
                rs.close();
            }
        }
        List ids = e.getMembers();
        if (level > 0) {
            for (Relation.RelationMember i : ids) {
                if (i.getEntityId().getType() == Entity.EntityType.NODE) {
                    this.pselectNode.setLong(1, i.getEntityId().getId());
                    if (!this.pselectNode.execute()) continue;
                    ResultSet rs = this.pselectNode.getResultSet();
                    Node n = null;
                    while (rs.next()) {
                        if (n != null) continue;
                        n = new Node(rs.getDouble(1), rs.getDouble(2), i.getEntityId().getId().longValue());
                        this.readTags((Entity)n, rs.getBytes(3));
                    }
                    map.put(i.getEntityId(), n);
                    rs.close();
                    continue;
                }
                if (i.getEntityId().getType() == Entity.EntityType.WAY) {
                    Way way = new Way(i.getEntityId().getId().longValue());
                    this.loadEntityWay(way);
                    map.put(i.getEntityId(), way);
                    continue;
                }
                if (i.getEntityId().getType() != Entity.EntityType.RELATION) continue;
                Relation rel = new Relation(i.getEntityId().getId().longValue());
                this.loadEntityRelation(rel, level - 1);
                map.put(i.getEntityId(), rel);
            }
            e.initializeLinks(map);
            e.entityDataLoaded();
        }
    }

    public void setCreator(OsmDbCreator dbCreator) {
        this.dbCreator = dbCreator;
    }

    @Override
    public long convertId(Entity e) {
        return this.dbCreator == null ? e.getId() : this.dbCreator.convertId(e);
    }

    public void readTags(Entity e, byte[] tags) {
        if (tags != null) {
            try {
                int i;
                int prev = 0;
                ArrayList<String> vs = new ArrayList<String>();
                for (i = 0; i < tags.length; ++i) {
                    if (tags[i] != 0) continue;
                    vs.add(new String(tags, prev, i - prev, "UTF-8"));
                    prev = i + 1;
                }
                for (i = 0; i < vs.size(); i += 2) {
                    e.putTag((String)vs.get(i), (String)vs.get(i + 1));
                }
                if (this.tagsPrepration != null) {
                    this.tagsPrepration.processTags(e);
                }
            }
            catch (UnsupportedEncodingException e1) {
                throw new RuntimeException(e1);
            }
        }
    }

    public int iterateOverEntities(IProgress progress, Entity.EntityType type, OsmDbVisitor visitor) throws SQLException, InterruptedException {
        return this.iterateOverEntities(progress, type, visitor, true);
    }

    public int iterateOverEntities(IProgress progress, Entity.EntityType type, OsmDbVisitor visitor, boolean realCounts) throws SQLException, InterruptedException {
        PreparedStatement select;
        int count = 0;
        if (realCounts) {
            this.computeRealCounts();
        }
        ArrayBlockingQueue<Entity> toProcess = new ArrayBlockingQueue<Entity>(100000);
        EntityProducer entityProducer = null;
        if (type == Entity.EntityType.NODE) {
            select = this.iterateNodes;
            count = this.allNodes;
        } else if (type == Entity.EntityType.WAY) {
            select = this.iterateWays;
            count = this.allWays;
        } else if (type == Entity.EntityType.WAY_BOUNDARY) {
            select = this.iterateWayBoundaries;
            count = this.allBoundaries;
        } else {
            select = this.iterateRelations;
            count = this.allRelations;
        }
        entityProducer = new EntityProducer(toProcess, type, select);
        progress.startWork(count);
        entityProducer.start();
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Entity entityToProcess = null;
        Entity endEntity = entityProducer.getEndingEntity();
        while ((entityToProcess = (Entity)toProcess.take()) != endEntity) {
            if (progress != null) {
                progress.progress(1);
            }
            visitor.iterateEntity(entityToProcess, this);
        }
        return count;
    }

    private void computeRealCounts() throws SQLException {
        if (!this.realCounts) {
            Statement statement = this.dbConn.createStatement();
            this.realCounts = true;
            this.allNodes = statement.executeQuery("select count(distinct n.id) from node n where length(n.tags) > 0").getInt(1);
            this.allWays = statement.executeQuery("select count(*) from ways w where w.ord = 0").getInt(1);
            this.allRelations = statement.executeQuery("select count(distinct r.id) from relations r").getInt(1);
            this.allBoundaries = statement.executeQuery("select count(*) from ways w where w.ord = 0 and w.boundary > 0").getInt(1);
            statement.close();
        }
    }

    public void closeReadingConnection() throws SQLException {
        if (this.pselectNode != null) {
            this.pselectNode.close();
        }
        if (this.pselectWay != null) {
            this.pselectWay.close();
        }
        if (this.pselectRelation != null) {
            this.pselectRelation.close();
        }
        if (this.iterateNodes != null) {
            this.iterateNodes.close();
        }
        if (this.iterateRelations != null) {
            this.iterateRelations.close();
        }
        if (this.iterateWays != null) {
            this.iterateWays.close();
        }
        if (this.iterateWayBoundaries != null) {
            this.iterateWayBoundaries.close();
        }
    }

    public void setDbConn(Connection dbConnection, DBDialect dialect) {
        this.dbConn = dbConnection;
        this.dialect = dialect;
    }

    public static interface OsmDbTagsPreparation {
        public void processTags(Entity var1);
    }

    public static interface OsmDbVisitor {
        public void iterateEntity(Entity var1, OsmDbAccessorContext var2) throws SQLException;
    }

    public class EntityProducer
    extends AbstractProducer {
        private final BlockingQueue<Entity> toProcess;
        private final PreparedStatement select;
        private final Entity.EntityType type;
        private final boolean putEndingEntity;

        public EntityProducer(BlockingQueue<Entity> toProcess, Entity.EntityType type, PreparedStatement select) {
            this(toProcess, type, select, true);
        }

        public EntityProducer(BlockingQueue<Entity> toProcess, Entity.EntityType type, PreparedStatement select, boolean putEndingEntity) {
            this.toProcess = toProcess;
            this.type = type;
            this.select = select;
            this.putEndingEntity = putEndingEntity;
            this.setDaemon(true);
            this.setName("EntityProducer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.select.execute();
                ResultSet rs = this.select.getResultSet();
                Node prevEntity = null;
                long prevId = Long.MIN_VALUE;
                while (rs.next()) {
                    long curId = rs.getLong(1);
                    boolean newEntity = curId != prevId;
                    Node e = prevEntity;
                    if (this.type == Entity.EntityType.NODE) {
                        e = new Node(rs.getDouble(2), rs.getDouble(3), curId);
                        OsmDbAccessor.this.readTags((Entity)e, rs.getBytes(4));
                    } else if (this.type == Entity.EntityType.WAY || this.type == Entity.EntityType.WAY_BOUNDARY) {
                        int ord;
                        if (newEntity) {
                            e = new Way(curId);
                        }
                        if ((ord = rs.getInt(3)) == 0) {
                            OsmDbAccessor.this.readTags((Entity)e, rs.getBytes(4));
                        }
                        if (rs.getObject(6) == null) {
                            ((Way)e).addNode(rs.getLong(2));
                        } else {
                            Node n = new Node(rs.getDouble(5), rs.getDouble(6), rs.getLong(2));
                            OsmDbAccessor.this.readTags((Entity)n, rs.getBytes(7));
                            ((Way)e).addNode(n);
                        }
                    } else {
                        e = new Relation(curId);
                        OsmDbAccessor.this.readTags((Entity)e, rs.getBytes(2));
                    }
                    if (newEntity) {
                        if (prevEntity != null) {
                            this.toProcess.put((Entity)prevEntity);
                        }
                        prevEntity = e;
                    }
                    prevId = curId;
                }
                if (prevEntity != null) {
                    this.toProcess.put((Entity)prevEntity);
                }
                rs.close();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                if (this.putEndingEntity) {
                    try {
                        this.toProcess.put(this.getEndingEntity());
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    public class AbstractProducer
    extends Thread {
        private final Entity endingEntity = new Node(0.0, 0.0, 0L);

        public Entity getEndingEntity() {
            return this.endingEntity;
        }
    }
}

