/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import gnu.trove.TIntCollection;
import gnu.trove.iterator.TIntIterator;
import gnu.trove.iterator.TIntObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import gnu.trove.set.hash.TIntHashSet;
import gnu.trove.set.hash.TLongHashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import net.osmand.IProgress;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.OsmandOdb;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.obf.preparation.AbstractIndexPartCreator;
import net.osmand.obf.preparation.BinaryFileReference;
import net.osmand.obf.preparation.BinaryMapIndexWriter;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.ImproveRoadConnectivity;
import net.osmand.obf.preparation.IndexCreationContext;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.obf.preparation.OsmDbAccessorContext;
import net.osmand.obf.preparation.PropagateToNodes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.MapRoutingTypes;
import net.osmand.osm.RelationTagsPropagation;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import rtree.Element;
import rtree.IllegalValueException;
import rtree.LeafElement;
import rtree.RTree;
import rtree.RTreeException;
import rtree.RTreeInsertException;
import rtree.Rect;

public class IndexRouteCreator
extends AbstractIndexPartCreator {
    private Connection mapConnection;
    private final Log logMapDataWarn;
    private static final int CLUSTER_ZOOM = 15;
    private static final String CONFLICT_NAME = "#CONFLICT";
    private RTree routeTree = null;
    private RTree baserouteTree = null;
    private MapRoutingTypes routeTypes;
    RelationTagsPropagation tagsTransformer = new RelationTagsPropagation();
    private static final float DOUGLAS_PEUKER_DISTANCE = 15.0f;
    private QuadTree<Multipolygon> lowEmissionZones = new QuadTree(new QuadRect(-180.0, 90.0, 180.0, -90.0), 8, 0.55f);
    private TLongObjectHashMap<List<RouteDataObject.RestrictionInfo>> highwayRestrictions = new TLongObjectHashMap();
    private TLongObjectHashMap<WayNodeId> basemapRemovedNodes = new TLongObjectHashMap();
    private TLongObjectHashMap<RouteMissingPoints> basemapNodesToReinsert = new TLongObjectHashMap();
    TIntArrayList outTypes = new TIntArrayList();
    TLongObjectHashMap<TIntArrayList> pointTypes = new TLongObjectHashMap();
    TLongObjectHashMap<TIntObjectHashMap<String>> pointNames = new TLongObjectHashMap();
    Map<MapRoutingTypes.MapRouteType, String> names = IndexRouteCreator.createTreeMap();
    TLongObjectHashMap<GeneralizedCluster> generalClusters = new TLongObjectHashMap();
    private PreparedStatement mapRouteInsertStat;
    private PreparedStatement basemapRouteInsertStat;
    private MapRenderingTypesEncoder renderingTypes;
    private IndexCreatorSettings settings;
    private PropagateToNodes propagateToNodes;
    private static final char SPECIAL_CHAR = '\u0000';
    private static final String TABLE_ROUTE = "route_objects";
    private static final String TABLE_BASEROUTE = "baseroute_objects";
    private static final String CREATETABLE = "(id bigint primary key, types binary, pointTypes binary, pointIds binary, pointCoordinates binary, name varchar(4096), pointNames binary)";
    private static final String CREATE_IND = "_ind on route_objects (id)";
    private static final String SELECT_STAT = "SELECT types, pointTypes, pointIds, pointCoordinates, name, pointNames FROM route_objects WHERE id = ?";
    private static final String SELECT_BASE_STAT = "SELECT types, pointTypes, pointIds, pointCoordinates, name, pointNames FROM baseroute_objects WHERE id = ?";
    private static final String INSERT_STAT = "(id, types, pointTypes, pointIds, pointCoordinates, name, pointNames) values(?, ?, ?, ?, ?, ?, ?)";
    private static final String COPY_BASE = "INSERT INTO baseroute_objects SELECT id, types, pointTypes, pointIds, pointCoordinates, name, pointNames FROM route_objects WHERE id = ?";
    private String[] baseOrderValues = new String[]{"trunk", "motorway", "ferry", "primary", "secondary", "tertiary", "residential", "road", "cycleway", "living_street"};

    static TreeMap<MapRoutingTypes.MapRouteType, String> createTreeMap() {
        return new TreeMap<MapRoutingTypes.MapRouteType, String>(new Comparator<MapRoutingTypes.MapRouteType>(){

            @Override
            public int compare(MapRoutingTypes.MapRouteType o1, MapRoutingTypes.MapRouteType o2) {
                int y;
                int x = this.value(o1);
                return x < (y = this.value(o2)) ? -1 : (x == y ? o1.getTag().compareTo(o2.getTag()) : 1);
            }

            private int value(MapRoutingTypes.MapRouteType o1) {
                if (o1.getTag().endsWith(":en")) {
                    return 1;
                }
                if (o1.getTag().contains(":")) {
                    return 2;
                }
                return 0;
            }
        });
    }

    public IndexRouteCreator(MapRenderingTypesEncoder renderingTypes, Log logMapDataWarn, IndexCreatorSettings settings, PropagateToNodes propagateToNodes) {
        this.renderingTypes = renderingTypes;
        this.logMapDataWarn = logMapDataWarn;
        this.settings = settings;
        this.routeTypes = new MapRoutingTypes(renderingTypes);
        this.propagateToNodes = propagateToNodes;
    }

    public void indexExtraRelations(OsmBaseStorage reader) {
        for (Entity e : reader.getRegisteredEntities().values()) {
            if (!(e instanceof Relation) || !"low_emission_zone".equals(e.getTags().get("boundary"))) continue;
            e.initializeLinks(reader.getRegisteredEntities());
            this.addLowEmissonZoneRelation((Relation)e);
        }
    }

    public void indexRelations(Entity e, OsmDbAccessorContext ctx) throws SQLException {
        this.indexHighwayRestrictions(e, ctx);
        if (e instanceof Relation) {
            this.tagsTransformer.handleRelationPropogatedTags((Relation)e, this.renderingTypes, ctx, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING);
            Map<String, String> tags = this.renderingTypes.transformTags(e.getTags(), Entity.EntityType.RELATION, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING);
            if ("enforcement".equals(tags.get("type")) && "maxspeed".equals(tags.get("enforcement"))) {
                ctx.loadEntityRelation((Relation)e);
                Iterator from = ((Relation)e).getMembers("from").iterator();
                while (from.hasNext()) {
                    Entity n = ((Relation.RelationMember)from.next()).getEntity();
                    if (!(n instanceof Node)) continue;
                    RelationTagsPropagation.PropagateEntityTags pt = this.tagsTransformer.getPropogateTagForEntity(new Entity.EntityId(Entity.EntityType.NODE, Long.valueOf(n.getId())));
                    pt.putThroughTags.put("highway", "speed_camera");
                }
            }
        }
    }

    public void indexLowEmissionZones(Entity e, OsmDbAccessorContext ctx) throws SQLException {
        if ("low_emission_zone".equals(e.getTags().get("boundary"))) {
            if (e instanceof Relation) {
                ctx.loadEntityRelation((Relation)e);
                this.addLowEmissonZoneRelation((Relation)e);
            }
            if (e instanceof Way) {
                this.addLowEmissonZoneWay((Way)e);
            }
        }
    }

    private void addLowEmissonZoneRelation(Relation e) {
        MultipolygonBuilder multipolygonBuilder = new MultipolygonBuilder();
        multipolygonBuilder.setId(e.getId());
        multipolygonBuilder.createInnerAndOuterWays((Entity)e);
        Multipolygon lowEmissionZone = multipolygonBuilder.build();
        if (lowEmissionZone != null) {
            QuadRect bbox = lowEmissionZone.getLatLonBbox();
            QuadRect flippedBbox = this.flipBbox(bbox);
            this.lowEmissionZones.insert((Object)lowEmissionZone, flippedBbox);
        }
    }

    private void addLowEmissonZoneWay(Way e) {
        ArrayList<Way> outer = new ArrayList<Way>();
        ArrayList inner = new ArrayList();
        outer.add(e);
        MultipolygonBuilder multipolygonBuilder = new MultipolygonBuilder(outer, inner);
        multipolygonBuilder.setId(e.getId());
        Multipolygon lowEmissionZone = multipolygonBuilder.build();
        if (lowEmissionZone != null) {
            QuadRect bbox = lowEmissionZone.getLatLonBbox();
            QuadRect flippedBbox = this.flipBbox(bbox);
            this.lowEmissionZones.insert((Object)lowEmissionZone, flippedBbox);
        }
    }

    private QuadRect flipBbox(QuadRect bbox) {
        return new QuadRect(bbox.left, bbox.bottom, bbox.right, bbox.top);
    }

    private Map<String, String> addLowEmissionZoneTag(Way e, Map<String, String> tags) {
        Node n = null;
        for (int i = 0; i < e.getNodes().size() && n == null; ++i) {
            n = (Node)e.getNodes().get(i);
        }
        if (n == null) {
            return tags;
        }
        List results = this.lowEmissionZones.queryInBox(new QuadRect(n.getLongitude(), n.getLatitude(), n.getLongitude(), n.getLatitude()), new ArrayList(0));
        for (Multipolygon m : results) {
            if (!m.containsPoint(n.getLatitude(), n.getLongitude())) continue;
            tags = new LinkedHashMap<String, String>(tags);
            tags.put("low_emission_zone", "true");
            break;
        }
        return tags;
    }

    public void iterateMainEntity(Entity es, OsmDbAccessorContext ctx) throws SQLException {
        this.iterateMainEntity(es, ctx, null);
    }

    public void iterateMainEntity(Entity es, OsmDbAccessorContext ctx, IndexCreationContext icc) throws SQLException {
        if (es instanceof Way) {
            boolean encoded;
            Way e = (Way)es;
            if (this.settings.addRegionTag) {
                icc.calcRegionTag((Entity)e, true);
            }
            Map<String, String> tags = e.getTags();
            tags = this.addLowEmissionZoneTag(e, tags);
            tags = this.tagsTransformer.addPropogatedTags(this.renderingTypes, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING, (Entity)e, tags);
            boolean bl = encoded = this.routeTypes.encodeEntity(tags = this.renderingTypes.transformTags(tags, Entity.EntityType.WAY, MapRenderingTypesEncoder.EntityConvertApplyType.ROUTING), this.outTypes, this.names) && e.getNodes().size() >= 2;
            if (encoded) {
                ctx.loadEntityWay(e);
                if (this.propagateToNodes != null) {
                    this.propagateToNodes.propagateTagsToWayNodesNoBorderRule(e);
                }
                this.routeTypes.encodePointTypes(e, this.pointTypes, this.pointNames, this.tagsTransformer, this.renderingTypes, false);
                this.addWayToIndex(e.getId(), e.getNodes(), this.mapRouteInsertStat, this.routeTree, this.outTypes, this.pointTypes, this.pointNames, this.names);
            }
            if (this.settings.generateLowLevel) {
                boolean bl2 = encoded = this.routeTypes.encodeBaseEntity(tags, this.outTypes, this.names) && e.getNodes().size() >= 2;
                if (encoded) {
                    List source = e.getNodes();
                    long id = e.getId();
                    List<Node> result = this.simplifyRouteForBaseSection(source, id);
                    this.routeTypes.encodePointTypes(e, this.pointTypes, this.pointNames, this.tagsTransformer, this.renderingTypes, true);
                    this.addWayToIndex(e.getId(), result, this.basemapRouteInsertStat, this.baserouteTree, this.outTypes, this.pointTypes, this.pointNames, this.names);
                }
            }
            if (icc != null) {
                Map<String, String> ntags = this.renderingTypes.transformTags(e.getModifiableTags(), Entity.EntityType.WAY, MapRenderingTypesEncoder.EntityConvertApplyType.MAP);
                if (e.getModifiableTags() != ntags) {
                    e.getModifiableTags().putAll(ntags);
                }
            }
        }
    }

    private List<Node> simplifyRouteForBaseSection(List<Node> source, long id) {
        ArrayList<Node> result = new ArrayList<Node>();
        boolean[] kept = OsmMapUtils.simplifyDouglasPeucker(source, (int)20, (int)3, result, (boolean)false);
        int indexToInsertAt = 0;
        int originalInd = 0;
        for (int i = 0; i < kept.length; ++i) {
            Node n = source.get(i);
            if (n == null) continue;
            long y31 = MapUtils.get31TileNumberY((double)n.getLatitude());
            long x31 = MapUtils.get31TileNumberX((double)n.getLongitude());
            long point = (x31 << 31) + y31;
            boolean forceKeep = this.registerBaseIntersectionPoint(point, !kept[i], id, indexToInsertAt, originalInd);
            ++originalInd;
            if (!kept[i] && forceKeep) {
                kept[i] = true;
                result.add(indexToInsertAt, n);
            }
            if (!kept[i]) continue;
            ++indexToInsertAt;
        }
        return result;
    }

    private boolean registerBaseIntersectionPoint(long pointLoc, boolean register, long wayId, int insertAt, int originalInd) {
        if (this.basemapRemovedNodes.containsKey(pointLoc)) {
            WayNodeId exNode = (WayNodeId)this.basemapRemovedNodes.get(pointLoc);
            if (exNode != null) {
                if (!this.basemapNodesToReinsert.containsKey(exNode.wayId)) {
                    this.basemapNodesToReinsert.put(exNode.wayId, (Object)new RouteMissingPoints());
                }
                RouteMissingPoints mp = (RouteMissingPoints)this.basemapNodesToReinsert.get(exNode.wayId);
                mp.addPoint(exNode.originalInd, exNode.insertAt, pointLoc);
                this.basemapRemovedNodes.put(pointLoc, null);
            }
            return true;
        }
        WayNodeId genKey = register ? new WayNodeId(wayId, originalInd, insertAt) : null;
        this.basemapRemovedNodes.put(pointLoc, (Object)genKey);
        return false;
    }

    private void addWayToIndex(long id, List<Node> nodes, PreparedStatement insertStat, RTree rTree, TIntArrayList outTypes, TLongObjectHashMap<TIntArrayList> pointTypes, TLongObjectHashMap<TIntObjectHashMap<String>> pointNamesRaw, Map<MapRoutingTypes.MapRouteType, String> names) throws SQLException {
        boolean init = false;
        int minX = Integer.MAX_VALUE;
        int maxX = 0;
        int minY = Integer.MAX_VALUE;
        int maxY = 0;
        ByteArrayOutputStream bcoordinates = new ByteArrayOutputStream();
        ByteArrayOutputStream bpointIds = new ByteArrayOutputStream();
        ByteArrayOutputStream bpointTypes = new ByteArrayOutputStream();
        ByteArrayOutputStream btypes = new ByteArrayOutputStream();
        ArrayList<MapRoutingTypes.MapPointName> pointNamesEmp = new ArrayList<MapRoutingTypes.MapPointName>();
        try {
            for (int j = 0; j < outTypes.size(); ++j) {
                Algorithms.writeSmallInt((OutputStream)btypes, (int)outTypes.get(j));
            }
            int pointIndex = 0;
            for (Node n : nodes) {
                TIntObjectHashMap namesP;
                if (n == null || n.getId() > 0x2000000000000L) continue;
                Algorithms.writeLongInt((OutputStream)bpointIds, (long)n.getId());
                TIntArrayList types = (TIntArrayList)pointTypes.get(n.getId());
                if (types != null) {
                    for (int j = 0; j < types.size(); ++j) {
                        Algorithms.writeSmallInt((OutputStream)bpointTypes, (int)types.get(j));
                    }
                }
                if ((namesP = (TIntObjectHashMap)pointNamesRaw.get(n.getId())) != null) {
                    TIntObjectIterator it = namesP.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        MapRoutingTypes.MapPointName obj = new MapRoutingTypes.MapPointName(it.key(), pointIndex, (String)it.value());
                        pointNamesEmp.add(obj);
                    }
                }
                Algorithms.writeSmallInt((OutputStream)bpointTypes, (int)0);
                int y = MapUtils.get31TileNumberY((double)n.getLatitude());
                int x = MapUtils.get31TileNumberX((double)n.getLongitude());
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                init = true;
                Algorithms.writeInt((OutputStream)bcoordinates, (int)x);
                Algorithms.writeInt((OutputStream)bcoordinates, (int)y);
                ++pointIndex;
            }
        }
        catch (IOException est) {
            throw new IllegalStateException(est);
        }
        if (init) {
            insertStat.setLong(1, id);
            insertStat.setBytes(2, btypes.toByteArray());
            insertStat.setBytes(3, bpointTypes.toByteArray());
            insertStat.setBytes(4, bpointIds.toByteArray());
            insertStat.setBytes(5, bcoordinates.toByteArray());
            insertStat.setString(6, this.encodeNames(names));
            insertStat.setString(7, this.encodeListNames(pointNamesEmp));
            this.addBatch(insertStat, false);
            try {
                rTree.insert(new LeafElement(new Rect(minX, minY, maxX, maxY), id));
            }
            catch (RTreeInsertException e1) {
                throw new IllegalArgumentException(e1);
            }
            catch (IllegalValueException e1) {
                throw new IllegalArgumentException(e1);
            }
        }
    }

    private static long getBaseId(int x31, int y31) {
        long x = x31;
        long y = y31;
        return (x << 31) + y;
    }

    private GeneralizedCluster getCluster(GeneralizedWay gw, int ind, GeneralizedCluster helper) {
        int x31 = gw.px.get(ind);
        int y31 = gw.py.get(ind);
        int xc = x31 >> 16;
        int yc = y31 >> 16;
        if (helper != null && helper.x == xc && helper.y == yc) {
            return helper;
        }
        long l = ((long)xc << 16) + (long)yc;
        if (!this.generalClusters.containsKey(l)) {
            this.generalClusters.put(l, (Object)new GeneralizedCluster(xc, yc, 15));
        }
        return (GeneralizedCluster)this.generalClusters.get(l);
    }

    public void generalizeWay(Way e) throws SQLException {
        List ns = e.getNodes();
        GeneralizedWay w = new GeneralizedWay(e.getId());
        TIntArrayList px = w.px;
        TIntArrayList py = w.py;
        GeneralizedCluster cluster = null;
        for (Node n : ns) {
            if (n == null) continue;
            int x31 = MapUtils.get31TileNumberX((double)n.getLongitude());
            int y31 = MapUtils.get31TileNumberY((double)n.getLatitude());
            px.add(x31);
            py.add(y31);
        }
        if (w.size() < 2) {
            return;
        }
        for (int i = 0; i < w.size(); ++i) {
            GeneralizedCluster ncluster = this.getCluster(w, i, cluster);
            if (ncluster != cluster) {
                cluster = ncluster;
            }
            ncluster.addWayFromLocation(w, i);
        }
        int mt = this.getMainType((TIntCollection)this.outTypes);
        this.outTypes.remove(mt);
        w.mainType = mt;
        w.addtypes.addAll((TIntCollection)this.outTypes);
        w.names.putAll(this.names);
    }

    protected String encodeNames(Map<MapRoutingTypes.MapRouteType, String> tempNames) {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<MapRoutingTypes.MapRouteType, String> e : tempNames.entrySet()) {
            if (e.getValue() == null) continue;
            b.append('\u0000').append((char)e.getKey().getInternalId()).append(e.getValue());
        }
        return b.toString();
    }

    protected String encodeListNames(List<MapRoutingTypes.MapPointName> tempNames) {
        StringBuilder b = new StringBuilder();
        for (MapRoutingTypes.MapPointName e : tempNames) {
            b.append('\u0000').append((char)e.nameTypeInternalId).append((char)e.pointIndex).append(e.name);
        }
        return b.toString();
    }

    public Rect calcBounds(rtree.Node n) {
        Rect r = null;
        Element[] e = n.getAllElements();
        for (int i = 0; i < n.getTotalElements(); ++i) {
            Rect re = e[i].getRect();
            if (r == null) {
                try {
                    r = new Rect(re.getMinX(), re.getMinY(), re.getMaxX(), re.getMaxY());
                }
                catch (IllegalValueException illegalValueException) {}
                continue;
            }
            r.expandToInclude(re);
        }
        return r;
    }

    public void createDatabaseStructure(Connection mapConnection, DBDialect dialect, String rtreeMapIndexNonPackFileName) throws SQLException, IOException {
        this.mapConnection = mapConnection;
        Statement stat = mapConnection.createStatement();
        stat.executeUpdate("create table route_objects(id bigint primary key, types binary, pointTypes binary, pointIds binary, pointCoordinates binary, name varchar(4096), pointNames binary)");
        stat.executeUpdate("create table baseroute_objects(id bigint primary key, types binary, pointTypes binary, pointIds binary, pointCoordinates binary, name varchar(4096), pointNames binary)");
        stat.executeUpdate("create index route_objects_ind on route_objects (id)");
        stat.executeUpdate("create index baseroute_objects_ind on route_objects (id)");
        stat.close();
        this.mapRouteInsertStat = this.createStatementRouteObjInsert(mapConnection, false);
        try {
            this.routeTree = new RTree(rtreeMapIndexNonPackFileName);
        }
        catch (RTreeException e) {
            throw new IOException(e);
        }
        this.pStatements.put(this.mapRouteInsertStat, 0);
        if (this.settings.generateLowLevel) {
            this.basemapRouteInsertStat = this.createStatementRouteObjInsert(mapConnection, true);
            try {
                this.baserouteTree = new RTree(rtreeMapIndexNonPackFileName + "b");
            }
            catch (RTreeException e) {
                throw new IOException(e);
            }
            this.pStatements.put(this.basemapRouteInsertStat, 0);
        }
    }

    private PreparedStatement createStatementRouteObjInsert(Connection conn, boolean basemap) throws SQLException {
        return conn.prepareStatement("insert into " + (basemap ? TABLE_BASEROUTE : TABLE_ROUTE) + INSERT_STAT);
    }

    public void commitAndCloseFiles(String rTreeMapIndexNonPackFileName, String rTreeMapIndexPackFileName, boolean deleteDatabaseIndexes) throws IOException, SQLException {
        this.deleteRouteTreeFiles(rTreeMapIndexNonPackFileName, rTreeMapIndexPackFileName, deleteDatabaseIndexes, this.routeTree);
        if (this.settings.generateLowLevel) {
            this.deleteRouteTreeFiles(rTreeMapIndexNonPackFileName + "b", rTreeMapIndexPackFileName + "b", deleteDatabaseIndexes, this.baserouteTree);
        }
        this.closeAllPreparedStatements();
    }

    private void deleteRouteTreeFiles(String rTreeMapIndexNonPackFileName, String rTreeMapIndexPackFileName, boolean deleteDatabaseIndexes, RTree rte) throws IOException {
        File f;
        if (rte != null) {
            RandomAccessFile file = rte.getFileHdr().getFile();
            file.close();
        }
        if (rTreeMapIndexNonPackFileName != null && (f = new File(rTreeMapIndexNonPackFileName)).exists() && deleteDatabaseIndexes) {
            f.delete();
        }
        if (rTreeMapIndexPackFileName != null && (f = new File(rTreeMapIndexPackFileName)).exists() && deleteDatabaseIndexes) {
            f.delete();
        }
    }

    private void indexHighwayRestrictions(Entity e, OsmDbAccessorContext ctx) throws SQLException {
        String val;
        if (e instanceof Relation && "restriction".equals(e.getTag(OSMSettings.OSMTagKey.TYPE)) && (val = e.getTag("restriction")) != null) {
            Relation r = (Relation)e;
            if ("no_u_turn".equalsIgnoreCase(val)) {
                List lfrom = r.getMembers("from");
                List lto = r.getMembers("to");
                if (lfrom.size() == 1 && lto.size() == 1 && ((Relation.RelationMember)lfrom.get(0)).getEntityId().equals((Object)((Relation.RelationMember)lto.get(0)).getEntityId())) {
                    return;
                }
            }
            boolean allowMultipleFrom = false;
            boolean allowMultipleTo = false;
            int type = -1;
            if ("no_right_turn".equalsIgnoreCase(val)) {
                type = 1;
            } else if ("no_left_turn".equalsIgnoreCase(val)) {
                type = 2;
            } else if ("no_u_turn".equalsIgnoreCase(val)) {
                type = 3;
            } else if ("no_straight_on".equalsIgnoreCase(val)) {
                type = 4;
            } else if ("no_entry".equalsIgnoreCase(val)) {
                type = 4;
                allowMultipleFrom = true;
            } else if ("no_exit".equalsIgnoreCase(val)) {
                type = 4;
                allowMultipleTo = true;
            } else if ("only_right_turn".equalsIgnoreCase(val)) {
                type = 5;
            } else if ("only_left_turn".equalsIgnoreCase(val)) {
                type = 6;
            } else if ("only_straight_on".equalsIgnoreCase(val)) {
                type = 7;
            }
            if (type != -1) {
                ctx.loadEntityRelation(r);
                List fromL = r.getMembers("from");
                List toL = r.getMembers("to");
                List viaL = r.getMembers("via");
                if (!toL.isEmpty()) {
                    for (Relation.RelationMember from : fromL) {
                        if (from.getEntityId().getType() != Entity.EntityType.WAY) continue;
                        if (!this.highwayRestrictions.containsKey(from.getEntityId().getId().longValue())) {
                            this.highwayRestrictions.put(from.getEntityId().getId().longValue(), new ArrayList());
                        }
                        List rdList = (List)this.highwayRestrictions.get(from.getEntityId().getId().longValue());
                        for (Relation.RelationMember to : toL) {
                            Relation.RelationMember via;
                            RouteDataObject.RestrictionInfo rd = new RouteDataObject.RestrictionInfo();
                            rd.toWay = to.getEntityId().getId();
                            rd.type = type;
                            if (!viaL.isEmpty() && (via = (Relation.RelationMember)viaL.iterator().next()).getEntityId().getType() == Entity.EntityType.WAY) {
                                rd.viaWay = via.getEntityId().getId();
                            }
                            rdList.add(rd);
                            if (allowMultipleTo) continue;
                            break;
                        }
                        if (allowMultipleFrom) continue;
                        break;
                    }
                }
            }
        }
    }

    public void createRTreeFiles(String rTreeRouteIndexPackFileName) throws RTreeException {
        this.routeTree = new RTree(rTreeRouteIndexPackFileName);
        if (this.settings.generateLowLevel) {
            this.baserouteTree = new RTree(rTreeRouteIndexPackFileName + "b");
        }
    }

    public void packRtreeFiles(String rTreeRouteIndexNonPackFileName, String rTreeRouteIndexPackFileName) throws IOException {
        this.routeTree = IndexRouteCreator.packRtreeFile(this.routeTree, rTreeRouteIndexNonPackFileName, rTreeRouteIndexPackFileName);
        if (this.settings.generateLowLevel) {
            this.baserouteTree = IndexRouteCreator.packRtreeFile(this.baserouteTree, rTreeRouteIndexNonPackFileName + "b", rTreeRouteIndexPackFileName + "b");
        }
    }

    public void writeBinaryRouteIndex(File fl, BinaryMapIndexWriter writer, String regionName, boolean generateLowLevel) throws IOException, SQLException {
        this.closePreparedStatements(this.mapRouteInsertStat);
        if (this.basemapRouteInsertStat != null) {
            this.closePreparedStatements(this.basemapRouteInsertStat);
        }
        this.mapConnection.commit();
        try {
            writer.startWriteRouteIndex(regionName);
            writer.writeRouteEncodingRules(this.routeTypes.getEncodingRuleTypes());
            RandomAccessFile raf = writer.getRaf();
            writer.flush();
            long fp = raf.getFilePointer();
            this.writeRouteSections(writer);
            String fname = null;
            if (this.baserouteTree != null) {
                writer.simulateWriteEndRouteIndex();
                writer.preclose();
                writer.flush();
                raf.seek(0L);
                this.appendMissingRoadsForBaseMap(this.mapConnection, new BinaryMapIndexReader(raf, fl));
                fname = this.baserouteTree.getFileName();
                this.baserouteTree = IndexRouteCreator.packRtreeFile(this.baserouteTree, fname, fname + "p");
                raf.seek(fp);
                raf.getChannel().truncate(fp);
                this.writeRouteSections(writer);
            }
            writer.endWriteRouteIndex();
            writer.flush();
            if (generateLowLevel) {
                this.baserouteTree = null;
                new File(fname + "p").delete();
            }
        }
        catch (RTreeException e) {
            throw new IllegalStateException(e);
        }
    }

    private TLongObjectHashMap<BinaryFileReference> writeRouteSections(BinaryMapIndexWriter writer) throws IOException, SQLException, RTreeException {
        TLongObjectHashMap<BinaryFileReference> route = this.writeBinaryRouteIndexHeader(writer, this.routeTree, false);
        TLongObjectHashMap<BinaryFileReference> base = null;
        if (this.baserouteTree != null) {
            base = this.writeBinaryRouteIndexHeader(writer, this.baserouteTree, true);
        }
        this.writeBinaryRouteIndexBlocks(writer, this.routeTree, false, route);
        if (this.baserouteTree != null) {
            this.writeBinaryRouteIndexBlocks(writer, this.baserouteTree, true, base);
        }
        return base;
    }

    private void appendMissingRoadsForBaseMap(Connection conn, BinaryMapIndexReader reader) throws IOException, SQLException {
        TLongObjectHashMap<RouteDataObject> map = new ImproveRoadConnectivity().collectDisconnectedRoads(reader);
        PreparedStatement ps = conn.prepareStatement(COPY_BASE);
        for (RouteDataObject rdo : map.valueCollection()) {
            int minX = Integer.MAX_VALUE;
            int maxX = 0;
            int minY = Integer.MAX_VALUE;
            int maxY = 0;
            long id = rdo.getId();
            for (int i = 0; i < rdo.getPointsLength(); ++i) {
                int x = rdo.getPoint31XTile(i);
                int y = rdo.getPoint31YTile(i);
                minX = Math.min(minX, x);
                maxX = Math.max(maxX, x);
                minY = Math.min(minY, y);
                maxY = Math.max(maxY, y);
                long point = (x << 31) + y;
                this.registerBaseIntersectionPoint(point, false, id, i, i);
            }
            ps.setLong(1, id);
            ps.execute();
            try {
                this.baserouteTree.insert(new LeafElement(new Rect(minX, minY, maxX, maxY), id));
            }
            catch (RTreeInsertException e1) {
                throw new IllegalArgumentException(e1);
            }
            catch (IllegalValueException e1) {
                throw new IllegalArgumentException(e1);
            }
        }
        ps.close();
    }

    private Node convertBaseToNode(long s) {
        long x = s >> 31;
        long y = s - (x << 31);
        return new Node(MapUtils.get31LatitudeY((int)((int)y)), MapUtils.get31LongitudeX((int)((int)x)), -1L);
    }

    private int getBaseOrderForType(int intType) {
        int i;
        if (intType == -1) {
            return Integer.MAX_VALUE;
        }
        MapRoutingTypes.MapRouteType rt = this.routeTypes.getTypeByInternalId(intType);
        for (i = 0; i < this.baseOrderValues.length; ++i) {
            if (!rt.getValue().startsWith(this.baseOrderValues[i])) continue;
            return i;
        }
        return i;
    }

    private int getMainType(TIntCollection types) {
        if (types.isEmpty()) {
            return -1;
        }
        TIntIterator tit = types.iterator();
        int main = tit.next();
        while (tit.hasNext()) {
            int rt = tit.next();
            if (this.getBaseOrderForType(rt) >= this.getBaseOrderForType(main)) continue;
            main = rt;
        }
        return main;
    }

    public void getAdjacentRoads(GeneralizedCluster gcluster, GeneralizedWay gw, int i, Collection<GeneralizedWay> collection) {
        gcluster = this.getCluster(gw, i, gcluster);
        Object o = gcluster.map.get(gw.getLocation(i));
        if (o instanceof LinkedList) {
            for (GeneralizedWay next : (LinkedList)o) {
                if (next.id == gw.id) continue;
                collection.add(next);
            }
        }
    }

    public int countAdjacentRoads(GeneralizedCluster gcluster, GeneralizedWay gw, int i) {
        gcluster = this.getCluster(gw, i, gcluster);
        Object o = gcluster.map.get(gw.getLocation(i));
        if (o instanceof LinkedList) {
            Iterator it = ((LinkedList)o).iterator();
            int cnt = 0;
            while (it.hasNext()) {
                GeneralizedWay next = (GeneralizedWay)it.next();
                if (next.id == gw.id) continue;
                ++cnt;
            }
            return cnt;
        }
        if (o instanceof GeneralizedWay && gw.id != ((GeneralizedWay)o).id) {
            return 1;
        }
        return 0;
    }

    public void processingLowLevelWays(IProgress progress) {
        if (!this.settings.generateLowLevel) {
            return;
        }
        this.pointTypes.clear();
        this.pointNames.clear();
        ArrayList<GeneralizedCluster> clusters = new ArrayList<GeneralizedCluster>(this.generalClusters.valueCollection());
        this.processRoundabouts(clusters);
        for (GeneralizedCluster cluster : clusters) {
            ArrayList<GeneralizedWay> copy = new ArrayList<GeneralizedWay>(cluster.ways);
            for (GeneralizedWay gw : copy) {
                if (!cluster.ways.contains(gw)) continue;
                this.attachWays(gw, true);
                this.attachWays(gw, false);
            }
        }
        this.douglasPeukerSimplificationStep(clusters);
        TLongHashSet ids = new TLongHashSet();
        for (GeneralizedCluster cluster : clusters) {
            for (GeneralizedWay gw : cluster.ways) {
                if (ids.contains(gw.id)) continue;
                ids.add(gw.id);
                this.names.clear();
                for (Map.Entry<MapRoutingTypes.MapRouteType, String> e : gw.names.entrySet()) {
                    if (e.getValue() == null || e.getValue().equals(CONFLICT_NAME)) continue;
                    this.names.put(e.getKey(), e.getValue());
                }
                ArrayList<Node> nodes = new ArrayList<Node>();
                if (gw.size() == 0) {
                    System.err.println(gw.id + " empty ? ");
                    continue;
                }
                long prev = 0L;
                for (int i = 0; i < gw.size(); ++i) {
                    long loc = gw.getLocation(i);
                    if (loc == prev) continue;
                    Node c = this.convertBaseToNode(loc);
                    prev = loc;
                    nodes.add(c);
                }
                this.outTypes.clear();
                this.outTypes.add(gw.mainType);
                this.outTypes.addAll((TIntCollection)gw.addtypes);
                try {
                    this.addWayToIndex(gw.id, nodes, this.basemapRouteInsertStat, this.baserouteTree, this.outTypes, this.pointTypes, this.pointNames, this.names);
                }
                catch (SQLException e) {
                    throw new IllegalStateException(e);
                }
            }
        }
    }

    private static double scalarMultiplication(double xA, double yA, double xB, double yB, double xC, double yC) {
        double multiple = (xB - xA) * (xC - xA) + (yB - yA) * (yC - yA);
        return multiple;
    }

    public static LatLon getProjection(float y31, float x31, float fromy31, float fromx31, float toy31, float tox31) {
        float prlon;
        float prlat;
        float mDist = (fromy31 - toy31) * (fromy31 - toy31) + (fromx31 - tox31) * (fromx31 - tox31);
        float projection = (float)IndexRouteCreator.scalarMultiplication(fromy31, fromx31, toy31, tox31, y31, x31);
        if (projection < 0.0f) {
            prlat = fromy31;
            prlon = fromx31;
        } else if (projection >= mDist) {
            prlat = toy31;
            prlon = tox31;
        } else {
            prlat = fromy31 + (toy31 - fromy31) * (projection / mDist);
            prlon = fromx31 + (tox31 - fromx31) * (projection / mDist);
        }
        return new LatLon((double)prlat, (double)prlon);
    }

    private void simplifyDouglasPeucker(GeneralizedWay gw, float epsilon, Collection<Integer> ints, int start, int end) {
        double dmax = -1.0;
        int index = -1;
        for (int i = start + 1; i <= end - 1; ++i) {
            double d = this.orthogonalDistance(gw, start, end, gw.px.get(i), gw.py.get(i), false);
            if (!(d > dmax)) continue;
            dmax = d;
            index = i;
        }
        if (dmax >= (double)epsilon) {
            this.simplifyDouglasPeucker(gw, epsilon, ints, start, index);
            this.simplifyDouglasPeucker(gw, epsilon, ints, index, end);
        } else {
            ints.add(end);
        }
    }

    private double orthogonalDistance(GeneralizedWay gn, int st, int end, int px, int py, boolean returnNanIfNoProjection) {
        int fromy31 = gn.py.get(st);
        int fromx31 = gn.px.get(st);
        int toy31 = gn.py.get(end);
        int tox31 = gn.px.get(end);
        double mDist = ((double)fromy31 - (double)toy31) * ((double)fromy31 - (double)toy31) + ((double)fromx31 - (double)tox31) * ((double)fromx31 - (double)tox31);
        double projection = IndexRouteCreator.scalarMultiplication(fromy31, fromx31, toy31, tox31, py, px);
        if (returnNanIfNoProjection && (projection < 0.0 || projection > mDist)) {
            return Double.NaN;
        }
        double A = MapUtils.squareRootDist31((int)px, (int)py, (int)fromx31, (int)py);
        double B = MapUtils.squareRootDist31((int)px, (int)py, (int)px, (int)fromy31);
        double C = MapUtils.squareRootDist31((int)tox31, (int)toy31, (int)fromx31, (int)toy31);
        double D = MapUtils.squareRootDist31((int)tox31, (int)toy31, (int)tox31, (int)fromy31);
        return Math.abs(A * D - C * B) / Math.sqrt(C * C + D * D);
    }

    private void douglasPeukerSimplificationStep(Collection<GeneralizedCluster> clusters) {
        for (GeneralizedCluster cluster : clusters) {
            ArrayList<GeneralizedWay> copy = new ArrayList<GeneralizedWay>(cluster.ways);
            for (GeneralizedWay gw : copy) {
                HashSet<Integer> res = new HashSet<Integer>();
                this.simplifyDouglasPeucker(gw, 15.0f, res, 0, gw.size() - 1);
                int ind = 1;
                int len = gw.size() - 1;
                for (int j = 1; j < len; ++j) {
                    if (!res.contains(j) && this.countAdjacentRoads(cluster, gw, ind) == 0) {
                        GeneralizedCluster gcluster = this.getCluster(gw, ind, cluster);
                        gcluster.removeWayFromLocation(gw, ind);
                        gw.px.removeAt(ind);
                        gw.py.removeAt(ind);
                        continue;
                    }
                    ++ind;
                }
            }
        }
    }

    public int checkDistanceToLine(GeneralizedWay line, int start, boolean directionPlus, int px, int py, double distThreshold) {
        int next;
        int j = start;
        int n = next = directionPlus ? j + 1 : j - 1;
        while (next >= 0 && next < line.size()) {
            double od = this.orthogonalDistance(line, j, next, px, py, false);
            if (od < distThreshold) {
                return j;
            }
            j = next;
            next = directionPlus ? j + 1 : j - 1;
        }
        return -1;
    }

    private void processRoundabouts(Collection<GeneralizedCluster> clusters) {
        for (GeneralizedCluster cluster : clusters) {
            ArrayList<GeneralizedWay> copy = new ArrayList<GeneralizedWay>(cluster.ways);
            for (GeneralizedWay gw : copy) {
                GeneralizedCluster gcluster = cluster;
                if (gw.getLocation(gw.size() - 1) != gw.getLocation(0) || !cluster.ways.contains(gw)) continue;
                this.removeWayAndSubstituteWithPoint(gw, gcluster);
            }
        }
    }

    private void removeGeneratedWay(GeneralizedWay gw, GeneralizedCluster gcluster) {
        for (int i = 0; i < gw.size(); ++i) {
            gcluster = this.getCluster(gw, i, gcluster);
            gcluster.removeWayFromLocation(gw, i, true);
        }
    }

    private void removeWayAndSubstituteWithPoint(GeneralizedWay gw, GeneralizedCluster gcluster) {
        int i;
        long pxc = 0L;
        long pyc = 0L;
        for (i = 0; i < gw.size(); ++i) {
            pxc += (long)gw.px.get(i);
            pyc += (long)gw.py.get(i);
        }
        pxc /= (long)gw.size();
        pyc /= (long)gw.size();
        for (i = 0; i < gw.size(); ++i) {
            gcluster = this.getCluster(gw, i, gcluster);
            Object o = gcluster.map.get(gw.getLocation(i));
            if (o instanceof LinkedList) {
                for (GeneralizedWay next : (LinkedList)o) {
                    this.replacePointWithAnotherPoint(gcluster, gw, (int)pxc, (int)pyc, i, next);
                }
                continue;
            }
            if (!(o instanceof GeneralizedWay)) continue;
            this.replacePointWithAnotherPoint(gcluster, gw, (int)pxc, (int)pyc, i, (GeneralizedWay)o);
        }
        this.removeGeneratedWay(gw, gcluster);
    }

    private void replacePointWithAnotherPoint(GeneralizedCluster gcluster, GeneralizedWay gw, int pxc, int pyc, int i, GeneralizedWay next) {
        if (next.id != gw.id) {
            for (int j = 0; j < next.size(); ++j) {
                if (next.getLocation(j) != gw.getLocation(i)) continue;
                if (j == next.size() - 1) {
                    next.px.add(pxc);
                    next.py.add(pyc);
                    gcluster = this.getCluster(next, next.size() - 1, gcluster);
                    gcluster.addWayFromLocation(next, next.size() - 1);
                    break;
                }
                next.px.insert(j, pxc);
                next.py.insert(j, pyc);
                gcluster = this.getCluster(next, j, gcluster);
                gcluster.addWayFromLocation(next, j);
                break;
            }
        }
    }

    private boolean compareRefs(GeneralizedWay gw, GeneralizedWay gn) {
        String ref1 = gw.names.get(this.routeTypes.getRefRuleType());
        String ref2 = gn.names.get(this.routeTypes.getRefRuleType());
        String name1 = gw.names.get(this.routeTypes.getNameRuleType());
        String name2 = gn.names.get(this.routeTypes.getNameRuleType());
        return this.equalsIfNotEmpty(ref1, ref2) && this.equalsIfNotEmpty(name1, name2);
    }

    private boolean equalsIfNotEmpty(String s1, String s2) {
        if (Algorithms.isEmpty((CharSequence)s1) || Algorithms.isEmpty((CharSequence)s2)) {
            return true;
        }
        return s1.equalsIgnoreCase(s2);
    }

    private void mergeName(MapRoutingTypes.MapRouteType rt, GeneralizedWay from, GeneralizedWay to) {
        String rfFrom = from.names.get(rt);
        String rfTo = to.names.get(rt);
        if (rfFrom != null) {
            if (!rfFrom.equalsIgnoreCase(rfTo) && !Algorithms.isEmpty((CharSequence)rfTo)) {
                to.names.put(rt, CONFLICT_NAME);
            } else {
                to.names.put(rt, from.names.get(rt));
            }
        }
    }

    private void mergeAddTypes(GeneralizedWay from, GeneralizedWay to) {
        TIntIterator it = to.addtypes.iterator();
        while (it.hasNext()) {
            int n = it.next();
            if (from.addtypes.contains(n)) continue;
            it.remove();
        }
    }

    private GeneralizedWay selectBestWay(GeneralizedCluster cluster, GeneralizedWay gw, int ind) {
        long loc = gw.getLocation(ind);
        Object o = cluster.map.get(loc);
        GeneralizedWay res = null;
        if (o instanceof GeneralizedWay) {
            if (o != gw) {
                GeneralizedWay m = (GeneralizedWay)o;
                if (m.id != gw.id && m.mainType == gw.mainType && this.compareRefs(gw, m)) {
                    return m;
                }
            }
        } else if (o instanceof LinkedList) {
            LinkedList l = (LinkedList)o;
            double bestDiff = 1.5707963267948966;
            for (GeneralizedWay m : l) {
                double angleDiff;
                double dir;
                if (m.id == gw.id || m.mainType != gw.mainType || !this.compareRefs(gw, m)) continue;
                double init = gw.directionRoute(ind, ind == 0);
                if (m.getLocation(0) == loc) {
                    dir = m.directionRoute(0, true);
                } else if (m.getLocation(m.size() - 1) == loc) {
                    dir = m.directionRoute(m.size() - 1, false);
                } else {
                    return null;
                }
                if (!((angleDiff = Math.abs(MapUtils.alignAngleDifference((double)(Math.PI + dir - init)))) < bestDiff)) continue;
                bestDiff = angleDiff;
                res = m;
            }
        }
        return res;
    }

    private void attachWays(GeneralizedWay gw, boolean first) {
        int ind;
        GeneralizedWay prev;
        GeneralizedCluster cluster = null;
        while ((prev = this.selectBestWay(cluster = this.getCluster(gw, ind = first ? 0 : gw.size() - 1, cluster), gw, ind)) != null) {
            TIntArrayList by;
            for (int i = 0; i < prev.size(); ++i) {
                cluster = this.getCluster(prev, i, cluster);
                cluster.replaceWayFromLocation(prev, i, gw);
            }
            this.mergeAddTypes(prev, gw);
            for (MapRoutingTypes.MapRouteType rt : new ArrayList<MapRoutingTypes.MapRouteType>(gw.names.keySet())) {
                this.mergeName(rt, prev, gw);
            }
            for (MapRoutingTypes.MapRouteType rt : new ArrayList<MapRoutingTypes.MapRouteType>(prev.names.keySet())) {
                if (gw.names.containsKey(rt)) continue;
                this.mergeName(rt, prev, gw);
            }
            TIntArrayList ax = first ? prev.px : gw.px;
            TIntArrayList ay = first ? prev.py : gw.py;
            TIntArrayList bx = !first ? prev.px : gw.px;
            TIntArrayList tIntArrayList = by = !first ? prev.py : gw.py;
            if (first) {
                if (gw.getLocation(0) == prev.getLocation(0)) {
                    ax.reverse();
                    ay.reverse();
                }
            } else if (gw.getLocation(ind) == prev.getLocation(prev.size() - 1)) {
                bx.reverse();
                by.reverse();
            }
            bx.removeAt(0);
            by.removeAt(0);
            ax.addAll((TIntCollection)bx);
            ay.addAll((TIntCollection)by);
            gw.px = ax;
            gw.py = ay;
        }
    }

    private void writeBinaryRouteIndexBlocks(BinaryMapIndexWriter writer, RTree rte, boolean basemap, TLongObjectHashMap<BinaryFileReference> treeHeader) throws IOException, SQLException, RTreeException {
        long rootIndex = rte.getFileHdr().getRootIndex();
        rtree.Node root = rte.getReadNode(rootIndex);
        Rect rootBounds = this.calcBounds(root);
        if (rootBounds != null) {
            PreparedStatement selectData = this.mapConnection.prepareStatement(basemap ? SELECT_BASE_STAT : SELECT_STAT);
            RouteWriteContext wc = new RouteWriteContext(this.logMapDataWarn, treeHeader, this.routeTypes, selectData);
            wc.highwayRestrictions = this.highwayRestrictions;
            if (basemap) {
                wc.basemapNodesToReinsert = this.basemapNodesToReinsert;
            }
            IndexRouteCreator.writeBinaryMapBlock(root, rootBounds, rte, writer, wc, basemap);
            selectData.close();
        }
    }

    private TLongObjectHashMap<BinaryFileReference> writeBinaryRouteIndexHeader(BinaryMapIndexWriter writer, RTree rte, boolean basemap) throws IOException, SQLException, RTreeException {
        TLongObjectHashMap treeHeader = new TLongObjectHashMap();
        long rootIndex = rte.getFileHdr().getRootIndex();
        rtree.Node root = rte.getReadNode(rootIndex);
        Rect rootBounds = this.calcBounds(root);
        if (rootBounds != null) {
            IndexRouteCreator.writeBinaryRouteTree(root, rootBounds, rte, writer, (TLongObjectHashMap<BinaryFileReference>)treeHeader, basemap);
        }
        return treeHeader;
    }

    public static void writeBinaryMapBlock(rtree.Node parent, Rect parentBounds, RTree r, BinaryMapIndexWriter writer, RouteWriteContext wc, boolean basemap) throws IOException, RTreeException, SQLException {
        int i;
        Element[] e = parent.getAllElements();
        OsmandOdb.OsmAndRoutingIndex.RouteDataBlock.Builder dataBlock = null;
        BinaryFileReference ref = (BinaryFileReference)wc.treeHeader.get(parent.getNodeIndex());
        wc.wayMapIds.clear();
        wc.wayMapIdsCache.clear();
        wc.pointMapIds.clear();
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() != 1) continue;
            long id = e[i].getPtr();
            boolean retrieveObject = wc.retrieveObject(id);
            if (retrieveObject) {
                OsmandOdb.RouteData routeData;
                if (dataBlock == null) {
                    dataBlock = OsmandOdb.OsmAndRoutingIndex.RouteDataBlock.newBuilder();
                    wc.stringTable.clear();
                    wc.wayMapIds.clear();
                    wc.wayMapIdsCache.clear();
                    wc.pointMapIds.clear();
                }
                int cid = wc.registerWayMapId(id);
                List restrictions = (List)wc.highwayRestrictions.get(id);
                if (!basemap && restrictions != null) {
                    for (int li = 0; li < restrictions.size(); ++li) {
                        RouteDataObject.RestrictionInfo rd = (RouteDataObject.RestrictionInfo)restrictions.get(li);
                        OsmandOdb.RestrictionData.Builder restriction = OsmandOdb.RestrictionData.newBuilder();
                        restriction.setFrom(cid);
                        int toId = wc.registerWayMapId(rd.toWay);
                        restriction.setTo(toId);
                        restriction.setType(rd.type);
                        if (rd.viaWay != 0L) {
                            int viaId = wc.registerWayMapId(rd.viaWay);
                            restriction.setVia(viaId);
                        }
                        dataBlock.addRestrictions(restriction.build());
                    }
                }
                if ((routeData = writer.writeRouteData(cid, parentBounds.getMinX(), parentBounds.getMinY(), wc.wayTypes, wc.points.toArray(new BinaryMapIndexWriter.RoutePointToWrite[wc.points.size()]), wc.wayNames, wc.stringTable, wc.pointNames, dataBlock, true, false)) == null) continue;
                dataBlock.addDataObjects(routeData);
                continue;
            }
            if (wc.logMapDataWarn != null) {
                wc.logMapDataWarn.error((Object)("Something goes wrong with id = " + id));
                continue;
            }
            System.err.println("Something goes wrong with id = " + id);
        }
        if (dataBlock != null) {
            OsmandOdb.IdTable.Builder idTable = OsmandOdb.IdTable.newBuilder();
            long prev = 0L;
            for (int i2 = 0; i2 < wc.wayMapIds.size(); ++i2) {
                idTable.addRouteId(wc.wayMapIds.getQuick(i2) - prev);
                prev = wc.wayMapIds.getQuick(i2);
            }
            dataBlock.setIdTable(idTable.build());
            writer.writeRouteDataBlock(dataBlock, wc.stringTable, ref);
        }
        for (i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            long ptr = e[i].getPtr();
            rtree.Node ns = r.getReadNode(ptr);
            IndexRouteCreator.writeBinaryMapBlock(ns, e[i].getRect(), r, writer, wc, basemap);
        }
    }

    public static void writeBinaryRouteTree(rtree.Node parent, Rect re, RTree r, BinaryMapIndexWriter writer, TLongObjectHashMap<BinaryFileReference> bounds, boolean basemap) throws IOException, RTreeException {
        Element[] e = parent.getAllElements();
        boolean containsLeaf = false;
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() != 1) continue;
            containsLeaf = true;
        }
        BinaryFileReference ref = writer.startRouteTreeElement(re.getMinX(), re.getMaxX(), re.getMinY(), re.getMaxY(), containsLeaf, basemap);
        if (ref != null) {
            bounds.put(parent.getNodeIndex(), (Object)ref);
        }
        for (int i = 0; i < parent.getTotalElements(); ++i) {
            if (e[i].getElementType() == 1) continue;
            rtree.Node chNode = r.getReadNode(e[i].getPtr());
            IndexRouteCreator.writeBinaryRouteTree(chNode, e[i].getRect(), r, writer, bounds, basemap);
        }
        writer.endRouteTreeElement();
    }

    private static class WayNodeId {
        long wayId;
        int originalInd;
        int insertAt;

        public WayNodeId(long wayId, int originalInd, int insertAt) {
            this.wayId = wayId;
            this.originalInd = originalInd;
            this.insertAt = insertAt;
        }
    }

    private class RouteMissingPoints {
        List<Map<Integer, Long>> pointsMap = new ArrayList<Map<Integer, Long>>();

        private RouteMissingPoints() {
        }

        private void addPoint(int originalInd, int insertAt, long loc) {
            while (this.pointsMap.size() <= insertAt) {
                this.pointsMap.add(null);
            }
            if (this.pointsMap.get(insertAt) == null) {
                this.pointsMap.set(insertAt, new TreeMap());
            }
            this.pointsMap.get(insertAt).put(originalInd, loc);
        }
    }

    static class GeneralizedWay {
        private long id;
        private int mainType;
        private TIntHashSet addtypes = new TIntHashSet();
        private TIntArrayList px = new TIntArrayList();
        private TIntArrayList py = new TIntArrayList();
        private Map<MapRoutingTypes.MapRouteType, String> names = new HashMap<MapRoutingTypes.MapRouteType, String>();

        public GeneralizedWay(long id) {
            this.id = id;
        }

        public double getDistance() {
            double dx = 0.0;
            for (int i = 1; i < this.px.size(); ++i) {
                dx += MapUtils.getDistance((double)MapUtils.get31LatitudeY((int)this.py.get(i - 1)), (double)MapUtils.get31LongitudeX((int)this.px.get(i - 1)), (double)MapUtils.get31LatitudeY((int)this.py.get(i)), (double)MapUtils.get31LongitudeX((int)this.px.get(i)));
            }
            return dx;
        }

        public long getLocation(int ind) {
            return IndexRouteCreator.getBaseId(this.px.get(ind), this.py.get(ind));
        }

        public int size() {
            return this.px.size();
        }

        public double directionRoute(int startPoint, boolean plus) {
            float dist = 5.0f;
            int x = this.px.get(startPoint);
            int y = this.py.get(startPoint);
            int nx = startPoint;
            int px = x;
            int py = y;
            double total = 0.0;
            while (!(plus ? ++nx >= this.size() : --nx < 0)) {
                px = this.px.get(nx);
                py = this.py.get(nx);
                if ((total += (double)Math.abs(px - x) * 0.011 + (double)Math.abs(py - y) * 0.01863) < (double)dist) continue;
            }
            return -Math.atan2(x - px, y - py);
        }
    }

    static class GeneralizedCluster {
        public final int x;
        public final int y;
        public final int zoom;
        public final Set<GeneralizedWay> ways = new HashSet<GeneralizedWay>();
        public final TLongObjectHashMap<Object> map = new TLongObjectHashMap();

        public GeneralizedCluster(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.zoom = z;
        }

        public void replaceWayFromLocation(GeneralizedWay delete, int ind, GeneralizedWay toReplace) {
            this.ways.remove(delete);
            long loc = delete.getLocation(ind);
            Object o = this.map.get(loc);
            if (o instanceof GeneralizedWay) {
                if (delete == o) {
                    this.map.put(loc, (Object)toReplace);
                } else if (toReplace != o) {
                    this.addWay(toReplace, loc);
                }
            } else if (o instanceof LinkedList) {
                ((LinkedList)o).remove(delete);
                if (!((LinkedList)o).contains(toReplace)) {
                    ((LinkedList)o).add(toReplace);
                }
            } else {
                this.map.put(loc, (Object)toReplace);
            }
        }

        public void removeWayFromLocation(GeneralizedWay delete, int ind) {
            this.removeWayFromLocation(delete, ind, false);
        }

        public void removeWayFromLocation(GeneralizedWay delete, int ind, boolean deleteAll) {
            Object o;
            long loc = delete.getLocation(ind);
            boolean ex = false;
            if (!deleteAll) {
                for (int t = 0; t < delete.size(); ++t) {
                    if (t == ind || !this.map.containsKey(delete.getLocation(t))) continue;
                    ex = true;
                    break;
                }
            }
            if (!ex || deleteAll) {
                this.ways.remove(delete);
            }
            if ((o = this.map.get(loc)) instanceof GeneralizedWay) {
                if (delete == o) {
                    this.map.remove(loc);
                }
            } else if (o instanceof LinkedList) {
                ((LinkedList)o).remove(delete);
                if (((LinkedList)o).size() == 1) {
                    this.map.put(loc, ((LinkedList)o).iterator().next());
                } else if (((LinkedList)o).size() == 0) {
                    this.map.remove(loc);
                }
            }
        }

        public void addWayFromLocation(GeneralizedWay w, int i) {
            this.ways.add(w);
            long loc = w.getLocation(i);
            this.addWay(w, loc);
        }

        private void addWay(GeneralizedWay w, long loc) {
            if (this.map.containsKey(loc)) {
                Object o = this.map.get(loc);
                if (o instanceof LinkedList) {
                    if (!((LinkedList)o).contains(w)) {
                        ((LinkedList)o).add(w);
                    }
                } else if (o != w) {
                    LinkedList<GeneralizedWay> list = new LinkedList<GeneralizedWay>();
                    list.add((GeneralizedWay)o);
                    list.add(w);
                    this.map.put(loc, list);
                }
            } else {
                this.map.put(loc, (Object)w);
            }
        }
    }

    public static class RouteWriteContext {
        PreparedStatement selectData;
        TLongObjectHashMap<RouteDataObject> objects;
        TLongObjectHashMap<BinaryFileReference> treeHeader;
        Log logMapDataWarn;
        private MapRoutingTypes routeTypes;
        TLongObjectHashMap<List<RouteDataObject.RestrictionInfo>> highwayRestrictions = new TLongObjectHashMap();
        TLongObjectHashMap<RouteMissingPoints> basemapNodesToReinsert = new TLongObjectHashMap();
        Map<String, Integer> stringTable = new LinkedHashMap<String, Integer>();
        Map<MapRoutingTypes.MapRouteType, String> wayNames = IndexRouteCreator.createTreeMap();
        List<MapRoutingTypes.MapPointName> pointNames = new ArrayList<MapRoutingTypes.MapPointName>();
        TLongArrayList wayMapIds = new TLongArrayList();
        TLongObjectHashMap<Integer> wayMapIdsCache = new TLongObjectHashMap();
        TLongArrayList pointMapIds = new TLongArrayList();
        int[] wayTypes;
        private ArrayList<BinaryMapIndexWriter.RoutePointToWrite> points;

        public RouteWriteContext(Log logMapDataWarn, TLongObjectHashMap<BinaryFileReference> treeHeader, MapRoutingTypes routeTypes, PreparedStatement selectData) {
            this.logMapDataWarn = logMapDataWarn;
            this.treeHeader = treeHeader;
            this.routeTypes = routeTypes;
            this.selectData = selectData;
        }

        public RouteWriteContext(Log logMapDataWarn, TLongObjectHashMap<BinaryFileReference> treeHeader, MapRoutingTypes routeTypes, TLongObjectHashMap<RouteDataObject> objects) {
            this.logMapDataWarn = logMapDataWarn;
            this.treeHeader = treeHeader;
            this.routeTypes = routeTypes;
            this.objects = objects;
            for (RouteDataObject o : objects.valueCollection()) {
                ArrayList<RouteDataObject.RestrictionInfo> list = new ArrayList<RouteDataObject.RestrictionInfo>();
                for (int k = 0; k < o.getRestrictionLength(); ++k) {
                    list.add(o.getRestrictionInfo(k));
                }
                this.highwayRestrictions.put(o.getId(), list);
            }
        }

        protected void decodeNames(String name, Map<MapRoutingTypes.MapRouteType, String> tempNames) {
            int i = name.indexOf(0);
            while (i != -1) {
                int n = name.indexOf(0, i + 2);
                short ch = (short)name.charAt(i + 1);
                MapRoutingTypes.MapRouteType rt = this.routeTypes.getTypeByInternalId(ch);
                if (n == -1) {
                    tempNames.put(rt, name.substring(i + 2));
                } else {
                    tempNames.put(rt, name.substring(i + 2, n));
                }
                i = n;
            }
        }

        protected void decodeListNames(String name, List<MapRoutingTypes.MapPointName> tempNames) {
            int i = name.indexOf(0);
            while (i != -1) {
                int n = name.indexOf(0, i + 3);
                short ch = (short)name.charAt(i + 1);
                short index = (short)name.charAt(i + 2);
                String pointName = n == -1 ? name.substring(i + 3) : name.substring(i + 3, n);
                MapRoutingTypes.MapPointName pn = new MapRoutingTypes.MapPointName(ch, index, pointName);
                pn.nameTypeTargetId = this.routeTypes.getTypeByInternalId(ch).getTargetId();
                tempNames.add(pn);
                i = n;
            }
        }

        public int registerWayMapId(long id) {
            if (!this.wayMapIdsCache.contains(id)) {
                this.wayMapIdsCache.put(id, (Object)this.wayMapIdsCache.size());
                this.wayMapIds.add(id);
            }
            int newId = (Integer)this.wayMapIdsCache.get(id);
            return newId;
        }

        public boolean retrieveObject(long id) throws SQLException {
            if (this.selectData != null) {
                this.selectData.setLong(1, id);
                ResultSet rs = this.selectData.executeQuery();
                boolean next = rs.next();
                if (next) {
                    this.wayNames.clear();
                    this.decodeNames(rs.getString(5), this.wayNames);
                    byte[] types = rs.getBytes(1);
                    this.wayTypes = new int[types.length / 2];
                    for (int j = 0; j < types.length; j += 2) {
                        int ids = Algorithms.parseSmallIntFromBytes((byte[])types, (int)j);
                        this.wayTypes[j / 2] = this.routeTypes.getTypeByInternalId(ids).getTargetId();
                    }
                    byte[] pointTypes = rs.getBytes(2);
                    byte[] pointCoordinates = rs.getBytes(4);
                    String pointNamesString = rs.getString(6);
                    this.pointNames.clear();
                    this.decodeListNames(pointNamesString, this.pointNames);
                    int pointsLength = pointCoordinates.length / 8;
                    RouteMissingPoints missingPoints = null;
                    if (this.basemapNodesToReinsert != null && this.basemapNodesToReinsert.containsKey(id)) {
                        missingPoints = (RouteMissingPoints)this.basemapNodesToReinsert.get(id);
                    }
                    int typeInd = 0;
                    this.points = new ArrayList(pointsLength);
                    for (int j = 0; j < pointsLength; ++j) {
                        if (missingPoints != null && j < missingPoints.pointsMap.size() && missingPoints.pointsMap.get(j) != null) {
                            for (Long loc : missingPoints.pointsMap.get(j).values()) {
                                BinaryMapIndexWriter.RoutePointToWrite point = new BinaryMapIndexWriter.RoutePointToWrite();
                                point.x = (int)(loc >> 31);
                                point.y = (int)(loc - (long)(point.x << 31));
                                this.points.add(point);
                            }
                        }
                        BinaryMapIndexWriter.RoutePointToWrite point = new BinaryMapIndexWriter.RoutePointToWrite();
                        this.points.add(point);
                        point.x = Algorithms.parseIntFromBytes((byte[])pointCoordinates, (int)(j * 8));
                        point.y = Algorithms.parseIntFromBytes((byte[])pointCoordinates, (int)(j * 8 + 4));
                        int type = 0;
                        do {
                            type = Algorithms.parseSmallIntFromBytes((byte[])pointTypes, (int)typeInd);
                            typeInd += 2;
                            if (type == 0) continue;
                            point.types.add(this.routeTypes.getTypeByInternalId(type).getTargetId());
                        } while (type != 0);
                    }
                }
                return next;
            }
            RouteDataObject rdo = (RouteDataObject)this.objects.get(id);
            if (rdo != null) {
                this.wayTypes = rdo.types;
                this.pointNames.clear();
                if (rdo.pointNames != null) {
                    for (int i = 0; i < rdo.pointNames.length; ++i) {
                        if (rdo.pointNames[i] == null) continue;
                        for (int j = 0; j < rdo.pointNames[i].length; ++j) {
                            MapRoutingTypes.MapPointName mpn = new MapRoutingTypes.MapPointName(rdo.pointNameTypes[i][j], i, rdo.pointNames[i][j]);
                            this.pointNames.add(mpn);
                        }
                    }
                }
                this.wayNames.clear();
                if (rdo.names != null) {
                    TIntObjectIterator it = rdo.names.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        int vl = it.key();
                        String value = (String)it.value();
                        BinaryMapRouteReaderAdapter.RouteTypeRule rtr = rdo.region.quickGetEncodingRule(vl);
                        MapRoutingTypes.MapRouteType mrt = new MapRoutingTypes.MapRouteType(vl, rtr.getTag(), rtr.getValue());
                        this.wayNames.put(mrt, value);
                    }
                }
                this.points = new ArrayList(rdo.pointsX.length);
                for (int i = 0; i < rdo.pointsX.length; ++i) {
                    BinaryMapIndexWriter.RoutePointToWrite rw = new BinaryMapIndexWriter.RoutePointToWrite();
                    rw.x = rdo.pointsX[i];
                    rw.y = rdo.pointsY[i];
                    if (rdo.pointTypes != null && i < rdo.pointTypes.length && rdo.pointTypes[i] != null) {
                        rw.types.addAll(rdo.pointTypes[i]);
                    }
                    this.points.add(rw);
                }
                return true;
            }
            return false;
        }
    }
}

