/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.model;

import info.bliki.wiki.model.InterWiki;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nullable;

public class InterWikiMap {
    private static final String GLOBAL_PREFIX = "__global:";
    private static final String SITES_PREFIX = "__sites:";
    private static final String LIST_PREFIX = "__list:";
    private Map<String, InterWiki> wikis;
    private final Map<String, String> sites = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private final String wikiId;

    public InterWikiMap(Map<String, String> map, String wikiId) {
        this.wikiId = wikiId;
        this.wikis = new TreeMap<String, InterWiki>(String.CASE_INSENSITIVE_ORDER);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith(SITES_PREFIX)) {
                String[] parts = key.split(":", 2);
                if (parts.length != 2) {
                    throw new RuntimeException("Invalid site descriptor: " + value);
                }
                this.sites.put(parts[1], value);
                continue;
            }
            if (key.startsWith(LIST_PREFIX) || value.isEmpty()) continue;
            this.wikis.put(key, this.parseInterWiki(value));
        }
    }

    @Nullable
    public InterWiki getInterWiki(String prefix) {
        String site = this.sites.get(this.wikiId);
        InterWiki interWiki = this.wikis.get(this.wikiId + ":" + prefix);
        if (interWiki == null && site != null) {
            interWiki = this.wikis.get("_" + site + ":" + prefix);
        }
        if (interWiki == null) {
            interWiki = this.wikis.get(GLOBAL_PREFIX + prefix);
        }
        return interWiki;
    }

    private InterWiki parseInterWiki(String value) {
        String[] parts = value.split(" ", 2);
        if (parts.length != 2) {
            throw new RuntimeException("invalid entry: " + value);
        }
        boolean local = "1".equals(parts[0]);
        String pattern = parts[1];
        return new InterWiki(pattern, local);
    }
}

