/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlinx.coroutines.AwaitKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Dispatchers;
import net.osmand.shared.api.SQLiteAPI;
import net.osmand.shared.data.StringIntPair;
import net.osmand.shared.extensions.ClockExtensionsKt;
import net.osmand.shared.extensions.StringExtensionsKt;
import net.osmand.shared.gpx.ColoringPurpose;
import net.osmand.shared.gpx.DataItem;
import net.osmand.shared.gpx.GpxDataItem;
import net.osmand.shared.gpx.GpxDbUtils;
import net.osmand.shared.gpx.GpxDirItem;
import net.osmand.shared.gpx.GpxParameter;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.GradientScaleType;
import net.osmand.shared.io.KFile;
import net.osmand.shared.routing.ColoringType;
import net.osmand.shared.util.DbUtils;
import net.osmand.shared.util.Logger;
import net.osmand.shared.util.LoggerFactory;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u000b\u0018\u0000 H2\u00020\u0001:\u0001HB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ \u0010\u000b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001J&\u0010\u000f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0002J<\u0010\u000f\u001a\u00020\u00072\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0002JD\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\r\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00112\u0014\u0010\u0015\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u0011H\u0002J\u0016\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0019J\u0014\u0010\u001b\u001a\u00020\u00072\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u001eJ\u000e\u0010\u001f\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0002J0\u0010'\u001a\u00020!2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010$\u001a\u00020%2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\r0)2\b\u0010*\u001a\u0004\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020-2\u0006\u0010$\u001a\u00020%H\u0002J\u0006\u0010.\u001a\u00020/J\u000e\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u00020\rJ,\u00102\u001a\b\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020\u00142\u0006\u00105\u001a\u00020\u00072\u0006\u00106\u001a\u00020\u00072\u0006\u00107\u001a\u00020\u0007J\u0016\u00102\u001a\b\u0012\u0004\u0012\u0002030)2\u0006\u00108\u001a\u00020\u0014H\u0002J\f\u00109\u001a\b\u0012\u0004\u0012\u00020#0)J\f\u0010:\u001a\b\u0012\u0004\u0012\u00020#0)J\u0014\u0010;\u001a\b\u0012\u0004\u0012\u00020#0)H\u0086@\u00a2\u0006\u0002\u0010<J\b\u0010=\u001a\u00020>H\u0002J&\u0010?\u001a\b\u0012\u0004\u0012\u00020#0)2\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010@\u001a\u00020>2\u0006\u0010A\u001a\u00020>H\u0002J\f\u0010B\u001a\b\u0012\u0004\u0012\u00020-0)J\u0010\u0010C\u001a\u0004\u0018\u00010#2\u0006\u0010\u001c\u001a\u00020\u0019J\u0010\u0010D\u001a\u0004\u0018\u00010-2\u0006\u0010\u001c\u001a\u00020\u0019J\u0012\u0010E\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002J\u0018\u0010E\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0005J\u0016\u0010F\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u0005J\u0010\u0010G\u001a\u00020!2\u0006\u0010\t\u001a\u00020#H\u0002\u00a8\u0006I"}, d2={"Lnet/osmand/shared/gpx/GpxDatabase;", "", "<init>", "()V", "openConnection", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteConnection;", "readonly", "", "updateDataItem", "item", "Lnet/osmand/shared/gpx/DataItem;", "updateDataItemParameter", "gpxParameter", "Lnet/osmand/shared/gpx/GpxParameter;", "value", "updateGpxParameters", "map", "", "rowsToUpdate", "tableName", "", "rowsToSearch", "db", "rename", "currentFile", "Lnet/osmand/shared/io/KFile;", "newFile", "remove", "file", "files", "", "add", "insertItem", "", "readGpxDataItem", "Lnet/osmand/shared/gpx/GpxDataItem;", "query", "Lnet/osmand/shared/api/SQLiteAPI$SQLiteCursor;", "readItemFile", "processItemParameters", "parameters", "", "analysis", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "readGpxDirItem", "Lnet/osmand/shared/gpx/GpxDirItem;", "getTracksMinCreateDate", "", "getColumnMaxValue", "parameter", "getStringIntItemsCollection", "Lnet/osmand/shared/data/StringIntPair;", "columnName", "includeEmptyValues", "sortByName", "sortDescending", "dataQuery", "getGpxDataItemsSync", "getGpxDataItemsBlocking", "getGpxDataItems", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getGpxDirItemsCount", "", "fetchBatchData", "offset", "batchSize", "getGpxDirItems", "getGpxDataItem", "getGpxDirItem", "getDataItem", "isDataItemExists", "updateAppearanceTimestamp", "Companion", "OsmAnd-shared"})
@SourceDebugExtension(value={"SMAP\nGpxDatabase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GpxDatabase.kt\nnet/osmand/shared/gpx/GpxDatabase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,554:1\n1#2:555\n1485#3:556\n1510#3,3:557\n1513#3,3:567\n1863#3:571\n1368#3:572\n1454#3,5:573\n1864#3:580\n381#4,7:560\n216#5:570\n217#5:581\n37#6,2:578\n37#6,2:582\n*S KotlinDebug\n*F\n+ 1 GpxDatabase.kt\nnet/osmand/shared/gpx/GpxDatabase\n*L\n158#1:556\n158#1:557,3\n158#1:567,3\n160#1:571\n162#1:572\n162#1:573,5\n160#1:580\n158#1:560,7\n159#1:570\n159#1:581\n162#1:578,2\n193#1:582,2\n*E\n"})
public final class GpxDatabase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger log = LoggerFactory.INSTANCE.getLogger("GpxDatabase");
    public static final int DB_VERSION = 32;
    @NotNull
    public static final String DB_NAME = "gpx_database";
    @NotNull
    public static final String GPX_TABLE_NAME = "gpxTable";
    @NotNull
    public static final String GPX_DIR_TABLE_NAME = "gpxDirTable";
    @NotNull
    public static final String TMP_NAME_COLUMN_COUNT = "itemsCount";
    public static final long UNKNOWN_TIME_THRESHOLD = 10L;
    @NotNull
    private static final String GPX_UPDATE_PARAMETERS_START = "UPDATE gpxTable SET ";
    @NotNull
    private static final String GPX_FIND_BY_NAME_AND_DIR = " WHERE " + GpxParameter.FILE_NAME.getColumnName() + " = ? AND " + GpxParameter.FILE_DIR.getColumnName() + " = ?";
    @NotNull
    private static final String GPX_NAME_AND_DIR = GpxParameter.FILE_NAME.getColumnName() + " = ? AND " + GpxParameter.FILE_DIR.getColumnName() + " = ?";
    @NotNull
    private static final String GPX_MIN_CREATE_DATE = "SELECT MIN(" + GpxParameter.FILE_CREATION_TIME.getColumnName() + ") FROM gpxTable WHERE " + GpxParameter.FILE_CREATION_TIME.getColumnName() + " > 10";
    @NotNull
    private static final String GPX_MAX_COLUMN_VALUE = "SELECT MAX(%s) FROM gpxTable";
    @NotNull
    private static final String CHANGE_NULL_TO_EMPTY_STRING_QUERY_PART = "case when %1$s is null then '' else %1$s end as %1$s";
    @NotNull
    private static final String CHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART = "case when %1$s is null then '' else %1$s end";
    @NotNull
    private static final String INCLUDE_NON_NULL_COLUMN_CONDITION = " WHERE %1$s NOT NULL AND %1$s <> '' ";
    @NotNull
    private static final String GET_ITEM_COUNT_COLLECTION_BASE = "SELECT %s, count (*) as itemsCount FROM gpxTable%s group by %s ORDER BY %s %s";
    private static final int BATCH_SIZE = 100;

    public GpxDatabase() {
        block0: {
            SQLiteAPI.SQLiteConnection db;
            SQLiteAPI.SQLiteConnection sQLiteConnection = db = this.openConnection(false);
            if (sQLiteConnection == null) break block0;
            sQLiteConnection.close();
        }
    }

    @Nullable
    public final SQLiteAPI.SQLiteConnection openConnection(boolean readonly) {
        SQLiteAPI.SQLiteConnection conn = PlatformUtil.INSTANCE.getSQLiteAPI().getOrCreateDatabase(DB_NAME, readonly);
        if (conn == null) {
            return null;
        }
        if (conn.getVersion() < 32) {
            if (readonly) {
                conn.close();
                conn = PlatformUtil.INSTANCE.getSQLiteAPI().getOrCreateDatabase(DB_NAME, false);
            }
            if (conn == null) {
                return null;
            }
            int version = conn.getVersion();
            conn.setVersion(32);
            if (version == 0) {
                GpxDbUtils.INSTANCE.onCreate(conn);
            } else {
                GpxDbUtils.INSTANCE.onUpgrade(this, conn, version, 32);
            }
        }
        return conn;
    }

    public final boolean updateDataItem(@NotNull DataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return this.updateGpxParameters(item, GpxDbUtils.INSTANCE.getItemParameters(item));
    }

    public final boolean updateDataItemParameter(@NotNull DataItem item, @NotNull GpxParameter gpxParameter, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)((Object)gpxParameter), (String)"gpxParameter");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)gpxParameter), (Object)value)};
        return this.updateGpxParameters(item, MapsKt.linkedMapOf((Pair[])pairArray));
    }

    private final boolean updateGpxParameters(DataItem item, Map<GpxParameter, ? extends Object> map) {
        KFile file = item.getFile();
        String tableName = GpxDbUtils.INSTANCE.getTableName(file);
        boolean success = this.updateGpxParameters(map, tableName, GpxDbUtils.INSTANCE.getItemRowsToSearch(file));
        if (success && item instanceof GpxDataItem) {
            this.updateAppearanceTimestamp((GpxDataItem)item);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean updateGpxParameters(Map<GpxParameter, ? extends Object> rowsToUpdate, String tableName, Map<String, ? extends Object> rowsToSearch) {
        SQLiteAPI.SQLiteConnection db = null;
        try {
            boolean bl;
            SQLiteAPI.SQLiteConnection sQLiteConnection = db = this.openConnection(false);
            if (sQLiteConnection != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection;
                boolean bl2 = false;
                bl = this.updateGpxParameters(it, tableName, rowsToUpdate, rowsToSearch);
            } else {
                bl = false;
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            block5: {
                SQLiteAPI.SQLiteConnection sQLiteConnection = db;
                if (sQLiteConnection == null) break block5;
                sQLiteConnection.close();
            }
        }
    }

    private final boolean updateGpxParameters(SQLiteAPI.SQLiteConnection db, String tableName, Map<GpxParameter, ? extends Object> rowsToUpdate, Map<String, ? extends Object> rowsToSearch) {
        Map<String, Object> map = GpxDbUtils.INSTANCE.convertGpxParameters(rowsToUpdate);
        Pair<String, Object[]> pair = DbUtils.INSTANCE.createDbUpdateQuery(tableName, map, rowsToSearch);
        db.execSQL((String)pair.getFirst(), (Object[])pair.getSecond());
        return true;
    }

    public final boolean rename(@NotNull KFile currentFile, @NotNull KFile newFile) {
        Intrinsics.checkNotNullParameter((Object)currentFile, (String)"currentFile");
        Intrinsics.checkNotNullParameter((Object)newFile, (String)"newFile");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)GpxParameter.FILE_NAME), (Object)newFile.name()), TuplesKt.to((Object)((Object)GpxParameter.FILE_DIR), (Object)GpxDbUtils.INSTANCE.getGpxFileDir(newFile))};
        LinkedHashMap map = MapsKt.linkedMapOf((Pair[])pairArray);
        String tableName = GpxDbUtils.INSTANCE.getTableName(currentFile);
        return this.updateGpxParameters(map, tableName, GpxDbUtils.INSTANCE.getItemRowsToSearch(currentFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean remove(@NotNull KFile file) {
        SQLiteAPI.SQLiteConnection db;
        block5: {
            SQLiteAPI.SQLiteConnection sQLiteConnection;
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            db = null;
            try {
                SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
                if (sQLiteConnection2 == null) break block5;
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl2 = false;
                String fileName = file.name();
                String fileDir = GpxDbUtils.INSTANCE.getGpxFileDir(file);
                String tableName = GpxDbUtils.INSTANCE.getTableName(file);
                Object[] objectArray = new Object[]{fileName, fileDir};
                db.execSQL("DELETE FROM " + tableName + " " + GPX_FIND_BY_NAME_AND_DIR, objectArray);
                bl = true;
                sQLiteConnection = db;
            }
            catch (Throwable throwable) {
                block6: {
                    SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
                    if (sQLiteConnection3 == null) break block6;
                    sQLiteConnection3.close();
                }
                throw throwable;
            }
            if (sQLiteConnection != null) {
                sQLiteConnection.close();
            }
            return bl;
        }
        boolean bl = false;
        SQLiteAPI.SQLiteConnection sQLiteConnection = db;
        if (sQLiteConnection != null) {
            sQLiteConnection.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final boolean remove(@NotNull Collection<KFile> files) {
        SQLiteAPI.SQLiteConnection db;
        block12: {
            SQLiteAPI.SQLiteConnection sQLiteConnection;
            boolean bl;
            Intrinsics.checkNotNullParameter(files, (String)"files");
            if (files.isEmpty()) {
                return false;
            }
            long time = ClockExtensionsKt.currentTimeMillis();
            db = null;
            try {
                Map fileDeletionMap;
                void $this$groupByTo$iv$iv;
                SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
                if (sQLiteConnection2 == null) break block12;
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl2 = false;
                Iterable $this$groupBy$iv = files;
                boolean $i$f$groupBy = false;
                Object object = $this$groupBy$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$groupByTo = false;
                for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                    Object object2;
                    KFile it2 = (KFile)element$iv$iv;
                    boolean bl3 = false;
                    String key$iv$iv = GpxDbUtils.INSTANCE.getTableName(it2);
                    Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                    boolean $i$f$getOrPut = false;
                    Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                    if (value$iv$iv$iv == null) {
                        boolean bl4 = false;
                        List answer$iv$iv$iv = new ArrayList();
                        $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                        object2 = answer$iv$iv$iv;
                    } else {
                        object2 = value$iv$iv$iv;
                    }
                    List list$iv$iv = (List)object2;
                    list$iv$iv.add(element$iv$iv);
                }
                Map $this$forEach$iv = fileDeletionMap = destination$iv$iv;
                boolean $i$f$forEach = false;
                object = $this$forEach$iv.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = (Map.Entry)object.next();
                    boolean bl5 = false;
                    String tableName = (String)entry.getKey();
                    List files2 = (List)entry.getValue();
                    Iterable $this$forEach$iv2 = CollectionsKt.chunked((Iterable)files2, (int)BATCH_SIZE);
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv2 : $this$forEach$iv2) {
                        void $this$toTypedArray$iv;
                        void $this$flatMapTo$iv$iv;
                        List batch = (List)element$iv2;
                        boolean bl6 = false;
                        String deleteConditions = CollectionsKt.joinToString$default((Iterable)batch, (CharSequence)" OR ", null, null, (int)0, null, GpxDatabase::remove$lambda$7$lambda$6$lambda$5$lambda$3, (int)30, null);
                        Iterable $this$flatMap$iv = batch;
                        boolean $i$f$flatMap = false;
                        Iterable iterable = $this$flatMap$iv;
                        Collection destination$iv$iv2 = new ArrayList();
                        boolean $i$f$flatMapTo = false;
                        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                            KFile it3 = (KFile)element$iv$iv;
                            boolean bl7 = false;
                            Object[] objectArray = new String[]{it3.name(), GpxDbUtils.INSTANCE.getGpxFileDir(it3)};
                            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray);
                            CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
                        }
                        $this$flatMap$iv = (List)destination$iv$iv2;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        Object[] args = thisCollection$iv.toArray(new Object[0]);
                        db.execSQL("DELETE FROM " + tableName + " WHERE " + deleteConditions, args);
                    }
                }
                log.info("Remove gpx files from db count=" + files.size() + " in " + (ClockExtensionsKt.currentTimeMillis() - time) + " ms");
                bl = true;
                sQLiteConnection = db;
            }
            catch (Throwable throwable) {
                block13: {
                    SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
                    if (sQLiteConnection3 == null) break block13;
                    sQLiteConnection3.close();
                }
                throw throwable;
            }
            if (sQLiteConnection != null) {
                sQLiteConnection.close();
            }
            return bl;
        }
        boolean bl = false;
        SQLiteAPI.SQLiteConnection sQLiteConnection = db;
        if (sQLiteConnection != null) {
            sQLiteConnection.close();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean add(@NotNull DataItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        SQLiteAPI.SQLiteConnection db = null;
        try {
            boolean bl;
            SQLiteAPI.SQLiteConnection sQLiteConnection = db = this.openConnection(false);
            if (sQLiteConnection != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection;
                boolean bl2 = false;
                this.insertItem(item, it);
                bl = true;
            } else {
                bl = false;
            }
            boolean bl3 = bl;
            return bl3;
        }
        finally {
            block5: {
                SQLiteAPI.SQLiteConnection sQLiteConnection = db;
                if (sQLiteConnection == null) break block5;
                sQLiteConnection.close();
            }
        }
    }

    public final void insertItem(@NotNull DataItem item, @NotNull SQLiteAPI.SQLiteConnection db) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        KFile file = item.getFile();
        String tableName = GpxDbUtils.INSTANCE.getTableName(file);
        Map<String, Object> map = GpxDbUtils.INSTANCE.convertGpxParameters(GpxDbUtils.INSTANCE.getItemParameters(item));
        String query = DbUtils.INSTANCE.createDbInsertQuery(tableName, map.keySet());
        Collection<Object> $this$toTypedArray$iv = map.values();
        boolean $i$f$toTypedArray = false;
        Collection<Object> thisCollection$iv = $this$toTypedArray$iv;
        db.execSQL(query, thisCollection$iv.toArray(new Object[0]));
    }

    private final GpxDataItem readGpxDataItem(SQLiteAPI.SQLiteCursor query) {
        KFile file = this.readItemFile(query);
        GpxDataItem item = new GpxDataItem(file);
        GpxTrackAnalysis analysis = new GpxTrackAnalysis();
        this.processItemParameters(item, query, (List)GpxParameter.getEntries(), analysis);
        item.setAnalysis(analysis);
        return item;
    }

    private final KFile readItemFile(SQLiteAPI.SQLiteCursor query) {
        String fileDir = query.getString(query.getColumnIndex(GpxParameter.FILE_DIR.getColumnName()));
        String fileName = query.getString(query.getColumnIndex(GpxParameter.FILE_NAME.getColumnName()));
        KFile appDir = PlatformUtil.INSTANCE.getOsmAndContext().getAppDir();
        KFile gpxDir = PlatformUtil.INSTANCE.getOsmAndContext().getGpxDir();
        if (Intrinsics.areEqual((Object)fileName, (Object)gpxDir.name())) {
            return gpxDir;
        }
        fileDir = StringsKt.replace$default((String)fileDir, (String)gpxDir.toString(), (String)"", (boolean)false, (int)4, null);
        KFile dir = ((CharSequence)(fileDir = StringsKt.replace$default((String)fileDir, (String)appDir.toString(), (String)"", (boolean)false, (int)4, null))).length() == 0 ? gpxDir : new KFile(gpxDir, fileDir);
        return new KFile(dir, fileName);
    }

    private final void processItemParameters(DataItem item, SQLiteAPI.SQLiteCursor query, List<? extends GpxParameter> parameters, GpxTrackAnalysis analysis) {
        for (GpxParameter gpxParameter : parameters) {
            Object value = GpxDbUtils.INSTANCE.queryColumnValue(query, gpxParameter);
            if (value == null && !gpxParameter.isAppearanceParameter()) {
                value = gpxParameter.getDefaultValue();
            }
            if (gpxParameter.getAnalysisParameter()) {
                GpxTrackAnalysis gpxTrackAnalysis = analysis;
                if (gpxTrackAnalysis != null) {
                    gpxTrackAnalysis.setGpxParameter(gpxParameter, value);
                }
                continue;
            }
            if (gpxParameter == GpxParameter.COLOR) {
                value = GpxUtilities.INSTANCE.parseColor((String)value);
            } else if (gpxParameter == GpxParameter.COLORING_TYPE) {
                String type = (String)value;
                ColoringType coloringType = ColoringType.Companion.valueOf(ColoringPurpose.TRACK, type);
                GradientScaleType scaleType = GradientScaleType.Companion.getGradientTypeByName(type);
                if (coloringType == null && scaleType != null) {
                    ColoringType coloringType2 = coloringType = ColoringType.Companion.valueOf(scaleType);
                    value = coloringType2 != null ? coloringType2.getName(null) : null;
                }
            }
            item.setParameter(gpxParameter, value);
        }
    }

    private final GpxDirItem readGpxDirItem(SQLiteAPI.SQLiteCursor query) {
        KFile file = this.readItemFile(query);
        GpxDirItem item = new GpxDirItem(file);
        this.processItemParameters(item, query, GpxParameter.Companion.getGpxDirParameters(), null);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final long getTracksMinCreateDate() {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        long minDate = 0L;
        minDate = -1L;
        SQLiteAPI.SQLiteConnection db = null;
        try {
            SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
            if (sQLiteConnection2 != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery(GPX_MIN_CREATE_DATE, null);
                    if (query != null && query.moveToFirst()) {
                        minDate = query.getLong(0);
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = query;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            sQLiteConnection = db;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
            if (sQLiteConnection3 == null) throw throwable;
            sQLiteConnection3.close();
            throw throwable;
        }
        if (sQLiteConnection == null) return minDate;
        sQLiteConnection.close();
        return minDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public final String getColumnMaxValue(@NotNull GpxParameter parameter) {
        String maxValue;
        block12: {
            Intrinsics.checkNotNullParameter((Object)((Object)parameter), (String)"parameter");
            maxValue = "";
            SQLiteAPI.SQLiteConnection db = null;
            try {
                SQLiteAPI.SQLiteCursor sQLiteCursor;
                db = this.openConnection(false);
                if (db == null) break block12;
                Object[] objectArray = new Object[]{parameter.getColumnName()};
                String queryString = StringExtensionsKt.format(GPX_MAX_COLUMN_VALUE, objectArray);
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery(queryString, null);
                    if (query != null && query.moveToFirst()) {
                        maxValue = query.getString(0);
                    }
                    sQLiteCursor = query;
                }
                catch (Throwable throwable) {
                    SQLiteAPI.SQLiteCursor sQLiteCursor2 = query;
                    if (sQLiteCursor2 != null) {
                        sQLiteCursor2.close();
                    }
                    break block12;
                    catch (Throwable throwable2) {
                        SQLiteAPI.SQLiteCursor sQLiteCursor3 = query;
                        if (sQLiteCursor3 != null) {
                            sQLiteCursor3.close();
                        }
                        throw throwable2;
                    }
                }
                if (sQLiteCursor != null) {
                    sQLiteCursor.close();
                }
            }
            finally {
                SQLiteAPI.SQLiteConnection sQLiteConnection = db;
                if (sQLiteConnection != null) {
                    sQLiteConnection.close();
                }
            }
        }
        return maxValue;
    }

    @NotNull
    public final List<StringIntPair> getStringIntItemsCollection(@NotNull String columnName, boolean includeEmptyValues, boolean sortByName, boolean sortDescending) {
        String string;
        String group;
        String column1;
        Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
        if (includeEmptyValues) {
            Object[] objectArray = new Object[]{columnName};
            v0 = StringExtensionsKt.format(CHANGE_NULL_TO_EMPTY_STRING_QUERY_PART, objectArray);
        } else {
            v0 = column1 = columnName;
        }
        if (includeEmptyValues) {
            Object[] objectArray = new Object[]{columnName};
            v1 = StringExtensionsKt.format(CHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART, objectArray);
        } else {
            v1 = group = columnName;
        }
        if (includeEmptyValues) {
            string = "";
        } else {
            Object[] objectArray = new Object[]{columnName};
            string = StringExtensionsKt.format(INCLUDE_NON_NULL_COLUMN_CONDITION, objectArray);
        }
        String includeEmptyValuesPart = string;
        String orderBy = sortByName ? columnName : TMP_NAME_COLUMN_COUNT;
        String sortDirection = sortDescending ? "DESC" : "ASC";
        Object[] objectArray = new Object[]{column1, includeEmptyValuesPart, group, orderBy, sortDirection};
        String query = StringExtensionsKt.format(GET_ITEM_COUNT_COLLECTION_BASE, objectArray);
        return this.getStringIntItemsCollection(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final List<StringIntPair> getStringIntItemsCollection(String dataQuery) {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        List folderCollection = new ArrayList();
        SQLiteAPI.SQLiteConnection db = null;
        try {
            SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
            if (sQLiteConnection2 != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery(dataQuery, null);
                    if (query != null && query.moveToFirst()) {
                        do {
                            folderCollection.add(new StringIntPair(query.getString(0), query.getInt(1)));
                        } while (query.moveToNext());
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = query;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            sQLiteConnection = db;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
            if (sQLiteConnection3 == null) throw throwable;
            sQLiteConnection3.close();
            throw throwable;
        }
        if (sQLiteConnection == null) return folderCollection;
        sQLiteConnection.close();
        return folderCollection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final List<GpxDataItem> getGpxDataItemsSync() {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        Set items = new LinkedHashSet();
        SQLiteAPI.SQLiteConnection db = null;
        try {
            SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
            if (sQLiteConnection2 != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery(GpxDbUtils.INSTANCE.getSelectGpxQuery(), null);
                    if (query != null && query.moveToFirst()) {
                        do {
                            items.add(this.readGpxDataItem(query));
                        } while (query.moveToNext());
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = query;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            sQLiteConnection = db;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
            if (sQLiteConnection3 == null) throw throwable;
            sQLiteConnection3.close();
            throw throwable;
        }
        if (sQLiteConnection == null) return CollectionsKt.toList((Iterable)items);
        sQLiteConnection.close();
        return CollectionsKt.toList((Iterable)items);
    }

    @NotNull
    public final List<GpxDataItem> getGpxDataItemsBlocking() {
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends GpxDataItem>>, Object>(this, null){
            int label;
            final /* synthetic */ GpxDatabase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = this.this$0.getGpxDataItems((Continuation<? super List<GpxDataItem>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<GpxDataItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    @Nullable
    public final Object getGpxDataItems(@NotNull Continuation<? super List<GpxDataItem>> $completion) {
        return CoroutineScopeKt.coroutineScope((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends GpxDataItem>>, Object>(this, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ GpxDatabase this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var13_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        $this$coroutineScope = (CoroutineScope)this.L$0;
                        items = new ArrayList<E>();
                        deferredResults = new ArrayList<E>();
                        itemsCount = GpxDatabase.access$getGpxDirItemsCount(this.this$0);
                        for (offset = 0; offset < itemsCount; offset += GpxDatabase.Companion.getBATCH_SIZE()) {
                            currentOffset = offset;
                            deferredBatch = BuildersKt.async$default((CoroutineScope)$this$coroutineScope, (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends GpxDataItem>>, Object>(this.this$0, currentOffset, null){
                                int label;
                                final /* synthetic */ GpxDatabase this$0;
                                final /* synthetic */ int $currentOffset;
                                {
                                    this.this$0 = $receiver;
                                    this.$currentOffset = $currentOffset;
                                    super(2, $completion);
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 * WARNING - void declaration
                                 */
                                public final Object invokeSuspend(Object object) {
                                    IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            SQLiteAPI.SQLiteConnection sQLiteConnection;
                                            List list;
                                            ResultKt.throwOnFailure((Object)object);
                                            SQLiteAPI.SQLiteConnection db = null;
                                            try {
                                                db = this.this$0.openConnection(true);
                                                list = db != null ? GpxDatabase.access$fetchBatchData(this.this$0, db, this.$currentOffset, GpxDatabase.Companion.getBATCH_SIZE()) : CollectionsKt.emptyList();
                                                sQLiteConnection = db;
                                            }
                                            catch (Throwable throwable) {
                                                void var2_2;
                                                void v1 = var2_2;
                                                if (v1 != null) {
                                                    v1.close();
                                                }
                                                throw throwable;
                                            }
                                            if (sQLiteConnection != null) {
                                                sQLiteConnection.close();
                                            }
                                            return list;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                public final Object invoke(CoroutineScope p1, Continuation<? super List<GpxDataItem>> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)2, null);
                            deferredResults.add(deferredBatch);
                        }
                        this.L$0 = items;
                        this.label = 1;
                        v0 = AwaitKt.awaitAll((Collection)deferredResults, (Continuation)((Continuation)this));
                        if (v0 == var13_2) {
                            return var13_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        items = (List)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl25:
                        // 2 sources

                        $this$forEach$iv = (Iterable)v0;
                        $i$f$forEach = false;
                        for (T element$iv : $this$forEach$iv) {
                            batchItems = (List)element$iv;
                            $i$a$-forEach-GpxDatabase$getGpxDataItems$2$1 = false;
                            items.addAll(batchItems);
                        }
                        return CollectionsKt.toList((Iterable)items);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super List<GpxDataItem>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final int getGpxDirItemsCount() {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        int res = 0;
        SQLiteAPI.SQLiteConnection db = null;
        try {
            SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(true);
            if (sQLiteConnection2 != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery("SELECT COUNT(*) FROM gpxTable", null);
                    if (query != null && query.moveToFirst()) {
                        res = query.getInt(0);
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = query;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            sQLiteConnection = db;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
            if (sQLiteConnection3 == null) throw throwable;
            sQLiteConnection3.close();
            throw throwable;
        }
        if (sQLiteConnection == null) return res;
        sQLiteConnection.close();
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<GpxDataItem> fetchBatchData(SQLiteAPI.SQLiteConnection db, int offset, int batchSize) {
        long time = ClockExtensionsKt.currentTimeMillis();
        List batchItems = new ArrayList();
        SQLiteAPI.SQLiteCursor query = null;
        try {
            String paginatedQuery = GpxDbUtils.INSTANCE.getSelectGpxQuery() + " ORDER BY " + GpxParameter.FILE_NAME.getColumnName() + " LIMIT " + batchSize + " OFFSET " + offset;
            query = db.rawQuery(paginatedQuery, null);
            if (query != null && query.moveToFirst()) {
                do {
                    batchItems.add(this.readGpxDataItem(query));
                } while (query.moveToNext());
            }
        }
        finally {
            SQLiteAPI.SQLiteCursor sQLiteCursor = query;
            if (sQLiteCursor != null) {
                sQLiteCursor.close();
            }
        }
        log.info("loadGpxItems fetchBatchData offset=" + offset + " batchItems=" + batchItems.size() + " in " + (ClockExtensionsKt.currentTimeMillis() - time) + " ms");
        return batchItems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final List<GpxDirItem> getGpxDirItems() {
        SQLiteAPI.SQLiteConnection sQLiteConnection;
        Set items = new LinkedHashSet();
        SQLiteAPI.SQLiteConnection db = null;
        try {
            SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
            if (sQLiteConnection2 != null) {
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor query = null;
                try {
                    query = db.rawQuery(GpxDbUtils.INSTANCE.getSelectGpxDirQuery(), null);
                    if (query != null && query.moveToFirst()) {
                        do {
                            items.add(this.readGpxDirItem(query));
                        } while (query.moveToNext());
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = query;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            sQLiteConnection = db;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
            if (sQLiteConnection3 == null) throw throwable;
            sQLiteConnection3.close();
            throw throwable;
        }
        if (sQLiteConnection == null) return CollectionsKt.toList((Iterable)items);
        sQLiteConnection.close();
        return CollectionsKt.toList((Iterable)items);
    }

    @Nullable
    public final GpxDataItem getGpxDataItem(@NotNull KFile file) {
        DataItem dataItem;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return GpxDbUtils.INSTANCE.isGpxFile(file) ? ((dataItem = this.getDataItem(file)) instanceof GpxDataItem ? (GpxDataItem)dataItem : null) : null;
    }

    @Nullable
    public final GpxDirItem getGpxDirItem(@NotNull KFile file) {
        DataItem dataItem;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return file.isDirectory() ? ((dataItem = this.getDataItem(file)) instanceof GpxDirItem ? (GpxDirItem)dataItem : null) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DataItem getDataItem(KFile file) {
        SQLiteAPI.SQLiteConnection db;
        block5: {
            SQLiteAPI.SQLiteConnection sQLiteConnection;
            DataItem dataItem;
            db = null;
            try {
                SQLiteAPI.SQLiteConnection sQLiteConnection2 = db = this.openConnection(false);
                if (sQLiteConnection2 == null) break block5;
                SQLiteAPI.SQLiteConnection it = sQLiteConnection2;
                boolean bl = false;
                dataItem = this.getDataItem(file, db);
                sQLiteConnection = db;
            }
            catch (Throwable throwable) {
                block6: {
                    SQLiteAPI.SQLiteConnection sQLiteConnection3 = db;
                    if (sQLiteConnection3 == null) break block6;
                    sQLiteConnection3.close();
                }
                throw throwable;
            }
            if (sQLiteConnection != null) {
                sQLiteConnection.close();
            }
            return dataItem;
        }
        DataItem dataItem = null;
        SQLiteAPI.SQLiteConnection sQLiteConnection = db;
        if (sQLiteConnection != null) {
            sQLiteConnection.close();
        }
        return dataItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DataItem getDataItem(@NotNull KFile file, @NotNull SQLiteAPI.SQLiteConnection db) {
        SQLiteAPI.SQLiteCursor sQLiteCursor;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        String name = file.name();
        String dir = GpxDbUtils.INSTANCE.getGpxFileDir(file);
        boolean gpxFile = GpxDbUtils.INSTANCE.isGpxFile(file);
        String selectQuery = gpxFile ? GpxDbUtils.INSTANCE.getSelectGpxQuery() : GpxDbUtils.INSTANCE.getSelectGpxDirQuery();
        SQLiteAPI.SQLiteCursor query = null;
        try {
            Object object = new String[]{name, dir};
            query = db.rawQuery(selectQuery + " " + GPX_FIND_BY_NAME_AND_DIR, (String[])object);
            if (query != null && query.moveToFirst()) {
                object = gpxFile ? (DataItem)this.readGpxDataItem(query) : (DataItem)this.readGpxDirItem(query);
                query.close();
                return object;
            }
            sQLiteCursor = query;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteCursor sQLiteCursor2 = query;
            if (sQLiteCursor2 != null) {
                sQLiteCursor2.close();
            }
            throw throwable;
        }
        if (sQLiteCursor != null) {
            sQLiteCursor.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isDataItemExists(@NotNull KFile file, @NotNull SQLiteAPI.SQLiteConnection db) {
        SQLiteAPI.SQLiteCursor sQLiteCursor;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        String name = file.name();
        String dir = GpxDbUtils.INSTANCE.getGpxFileDir(file);
        boolean gpxFile = GpxDbUtils.INSTANCE.isGpxFile(file);
        String selectQuery = gpxFile ? GpxDbUtils.INSTANCE.getSelectGpxQuery(GpxParameter.FILE_NAME) : GpxDbUtils.INSTANCE.getSelectGpxDirQuery(GpxParameter.FILE_NAME);
        SQLiteAPI.SQLiteCursor query = null;
        try {
            String[] stringArray = new String[]{name, dir};
            query = db.rawQuery(selectQuery + " " + GPX_FIND_BY_NAME_AND_DIR, stringArray);
            if (query != null && query.moveToFirst()) {
                boolean bl = true;
                query.close();
                return bl;
            }
            sQLiteCursor = query;
        }
        catch (Throwable throwable) {
            SQLiteAPI.SQLiteCursor sQLiteCursor2 = query;
            if (sQLiteCursor2 != null) {
                sQLiteCursor2.close();
            }
            throw throwable;
        }
        if (sQLiteCursor != null) {
            sQLiteCursor.close();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateAppearanceTimestamp(GpxDataItem item) {
        block9: {
            SQLiteAPI.SQLiteConnection db = null;
            try {
                SQLiteAPI.SQLiteConnection sQLiteConnection = db = this.openConnection(true);
                if (sQLiteConnection == null) break block9;
                SQLiteAPI.SQLiteConnection it = sQLiteConnection;
                boolean bl = false;
                SQLiteAPI.SQLiteCursor cursor = null;
                try {
                    String fileName = item.getFile().name();
                    String fileDir = GpxDbUtils.INSTANCE.getGpxFileDir(item.getFile());
                    String query = GpxDbUtils.INSTANCE.getSelectGpxQuery(GpxParameter.APPEARANCE_LAST_MODIFIED_TIME) + " " + GPX_FIND_BY_NAME_AND_DIR;
                    String[] stringArray = new String[]{fileName, fileDir};
                    cursor = it.rawQuery(query, stringArray);
                    if (cursor != null && cursor.moveToFirst()) {
                        long timestamp = cursor.getLong(0);
                        item.setParameter(GpxParameter.APPEARANCE_LAST_MODIFIED_TIME, timestamp);
                    }
                }
                finally {
                    SQLiteAPI.SQLiteCursor sQLiteCursor = cursor;
                    if (sQLiteCursor != null) {
                        sQLiteCursor.close();
                    }
                }
            }
            finally {
                SQLiteAPI.SQLiteConnection sQLiteConnection = db;
                if (sQLiteConnection != null) {
                    sQLiteConnection.close();
                }
            }
        }
    }

    private static final CharSequence remove$lambda$7$lambda$6$lambda$5$lambda$3(KFile it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "(" + GPX_NAME_AND_DIR + ")";
    }

    public static final /* synthetic */ int access$getGpxDirItemsCount(GpxDatabase $this) {
        return $this.getGpxDirItemsCount();
    }

    public static final /* synthetic */ List access$fetchBatchData(GpxDatabase $this, SQLiteAPI.SQLiteConnection db, int offset, int batchSize) {
        return $this.fetchBatchData(db, offset, batchSize);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0017\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0013R\u0014\u0010\u001e\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0014\u0010 \u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0013R\u0014\u0010\"\u001a\u00020\u000bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u0014\u0010$\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006'"}, d2={"Lnet/osmand/shared/gpx/GpxDatabase$Companion;", "", "<init>", "()V", "log", "Lnet/osmand/shared/util/Logger;", "getLog", "()Lnet/osmand/shared/util/Logger;", "DB_VERSION", "", "DB_NAME", "", "GPX_TABLE_NAME", "GPX_DIR_TABLE_NAME", "TMP_NAME_COLUMN_COUNT", "UNKNOWN_TIME_THRESHOLD", "", "GPX_UPDATE_PARAMETERS_START", "getGPX_UPDATE_PARAMETERS_START", "()Ljava/lang/String;", "GPX_FIND_BY_NAME_AND_DIR", "getGPX_FIND_BY_NAME_AND_DIR", "GPX_NAME_AND_DIR", "getGPX_NAME_AND_DIR", "GPX_MIN_CREATE_DATE", "getGPX_MIN_CREATE_DATE", "GPX_MAX_COLUMN_VALUE", "getGPX_MAX_COLUMN_VALUE", "CHANGE_NULL_TO_EMPTY_STRING_QUERY_PART", "getCHANGE_NULL_TO_EMPTY_STRING_QUERY_PART", "CHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART", "getCHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART", "INCLUDE_NON_NULL_COLUMN_CONDITION", "getINCLUDE_NON_NULL_COLUMN_CONDITION", "GET_ITEM_COUNT_COLLECTION_BASE", "getGET_ITEM_COUNT_COLLECTION_BASE", "BATCH_SIZE", "getBATCH_SIZE", "()I", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLog() {
            return log;
        }

        @NotNull
        public final String getGPX_UPDATE_PARAMETERS_START() {
            return GPX_UPDATE_PARAMETERS_START;
        }

        @NotNull
        public final String getGPX_FIND_BY_NAME_AND_DIR() {
            return GPX_FIND_BY_NAME_AND_DIR;
        }

        @NotNull
        public final String getGPX_NAME_AND_DIR() {
            return GPX_NAME_AND_DIR;
        }

        @NotNull
        public final String getGPX_MIN_CREATE_DATE() {
            return GPX_MIN_CREATE_DATE;
        }

        @NotNull
        public final String getGPX_MAX_COLUMN_VALUE() {
            return GPX_MAX_COLUMN_VALUE;
        }

        @NotNull
        public final String getCHANGE_NULL_TO_EMPTY_STRING_QUERY_PART() {
            return CHANGE_NULL_TO_EMPTY_STRING_QUERY_PART;
        }

        @NotNull
        public final String getCHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART() {
            return CHANGE_NULL_TO_EMPTY_GROUP_CONDITION_STRING_QUERY_PART;
        }

        @NotNull
        public final String getINCLUDE_NON_NULL_COLUMN_CONDITION() {
            return INCLUDE_NON_NULL_COLUMN_CONDITION;
        }

        @NotNull
        public final String getGET_ITEM_COUNT_COLLECTION_BASE() {
            return GET_ITEM_COUNT_COLLECTION_BASE;
        }

        public final int getBATCH_SIZE() {
            return BATCH_SIZE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

