/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.osmand.CallbackWithObject;
import net.osmand.CollatorStringMatcher;
import net.osmand.Location;
import net.osmand.NativeLibrary;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.BaseDetailsObject;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.TransportStop;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.edit.Entity;
import net.osmand.search.core.AmenityIndexRepository;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class AmenitySearcher {
    protected final Map<String, AmenityIndexRepository> amenityRepositories = new ConcurrentHashMap<String, AmenityIndexRepository>();
    private ThreadPoolExecutor singleThreadedExecutor;
    private LinkedBlockingQueue<Runnable> taskQueue;
    private static final int AMENITY_SEARCH_RADIUS = 50;
    private static final int AMENITY_SEARCH_RADIUS_FOR_RELATION = 500;
    private final MapPoiTypes mapPoiTypes;

    public AmenitySearcher(MapPoiTypes mapPoiTypes) {
        this.mapPoiTypes = mapPoiTypes;
        this.taskQueue = new LinkedBlockingQueue();
        this.singleThreadedExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, this.taskQueue);
    }

    public List<AmenityIndexRepository> getAmenityRepositories(boolean includeTravel, Predicate<String> travelFileVisibility) {
        ArrayList<String> fileNames = new ArrayList<String>(this.amenityRepositories.keySet());
        ArrayList<AmenityIndexRepository> travelMaps = new ArrayList<AmenityIndexRepository>();
        ArrayList<AmenityIndexRepository> baseMaps = new ArrayList<AmenityIndexRepository>();
        ArrayList<AmenityIndexRepository> result = new ArrayList<AmenityIndexRepository>();
        fileNames.sort(Algorithms.getStringVersionComparator());
        for (String fileName : fileNames) {
            AmenityIndexRepository r = this.amenityRepositories.get(fileName);
            if (r != null && fileName.endsWith(".travel.obf")) {
                if (!includeTravel || travelFileVisibility != null && !travelFileVisibility.test(fileName)) continue;
                travelMaps.add(r);
                continue;
            }
            if (r != null && r.isWorldMap()) {
                baseMaps.add(r);
                continue;
            }
            if (r == null) continue;
            result.add(r);
        }
        result.addAll(baseMaps);
        result.addAll(travelMaps);
        return result;
    }

    public List<Amenity> searchAmenities(BinaryMapIndexReader.SearchPoiTypeFilter filter, QuadRect rect, boolean includeTravel, Predicate<String> travelFileVisibility) {
        return this.searchAmenities(filter, null, rect.top, rect.left, rect.bottom, rect.right, -1, includeTravel, travelFileVisibility, null);
    }

    public List<Amenity> searchAmenities(BinaryMapIndexReader.SearchPoiTypeFilter filter, BinaryMapIndexReader.SearchPoiAdditionalFilter additionalFilter, double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, int zoom, boolean includeTravel, Predicate<String> travelFileVisibility, ResultMatcher<Amenity> matcher) {
        HashSet<Long> openAmenities = new HashSet<Long>();
        HashSet<Long> closedAmenities = new HashSet<Long>();
        ArrayList<Amenity> actualAmenities = new ArrayList<Amenity>();
        boolean isEmpty = filter.isEmpty();
        if (isEmpty && additionalFilter != null) {
            filter = null;
        }
        if (!isEmpty || additionalFilter != null) {
            int top31 = MapUtils.get31TileNumberY(topLatitude);
            int left31 = MapUtils.get31TileNumberX(leftLongitude);
            int bottom31 = MapUtils.get31TileNumberY(bottomLatitude);
            int right31 = MapUtils.get31TileNumberX(rightLongitude);
            List<AmenityIndexRepository> repos = this.getAmenityRepositories(includeTravel, travelFileVisibility);
            for (AmenityIndexRepository repo : repos) {
                List<Amenity> foundAmenities;
                if (matcher != null && matcher.isCancelled()) break;
                if (!repo.checkContainsInt(top31, left31, bottom31, right31) || (foundAmenities = repo.searchAmenities(top31, left31, bottom31, right31, zoom, filter, additionalFilter, matcher)) == null) continue;
                for (Amenity amenity : foundAmenities) {
                    Long id = amenity.getId();
                    if (amenity.isClosed()) {
                        closedAmenities.add(id);
                        continue;
                    }
                    if (closedAmenities.contains(id) || !openAmenities.add(id)) continue;
                    actualAmenities.add(amenity);
                }
            }
        }
        return actualAmenities;
    }

    public Amenity searchDetailedAmenity(Request request, Settings settings) {
        BaseDetailsObject detailed = this.searchDetailedObject(request, settings);
        return detailed != null ? detailed.getSyntheticAmenity() : null;
    }

    public BaseDetailsObject searchDetailedObject(Object object, Settings settings) {
        Request request = null;
        if (object instanceof MapObject) {
            MapObject mapObject = (MapObject)object;
            request = new Request(mapObject);
        } else if (object instanceof BaseDetailsObject) {
            BaseDetailsObject detailsObject = (BaseDetailsObject)object;
            if (detailsObject.isObjectFull()) {
                this.completeGeometry(detailsObject, detailsObject.getObjects().get(0));
                return detailsObject;
            }
            if (!detailsObject.getObjects().isEmpty()) {
                Object obj = detailsObject.getObjects().get(0);
                return this.searchDetailedObject(obj, settings);
            }
        }
        BaseDetailsObject detailsObject = null;
        if (request != null) {
            detailsObject = this.searchDetailedObject(request, settings);
        }
        this.completeGeometry(detailsObject, object);
        return detailsObject;
    }

    public BaseDetailsObject searchDetailedObject(Request request, Settings settings) {
        Amenity amenity;
        LatLon latLon = request.latLon;
        Long osmId = request.osmId;
        String wikidata = request.wikidata;
        Collection<String> names = request.names;
        if (latLon == null) {
            return null;
        }
        int searchRadius = request.type == Entity.EntityType.RELATION ? 500 : 50;
        QuadRect rect = MapUtils.calculateLatLonBbox(latLon.getLatitude(), latLon.getLongitude(), searchRadius);
        List<Amenity> amenities = this.searchAmenities(BinaryMapIndexReader.ACCEPT_ALL_POI_TYPE_FILTER, rect, true, settings.fileVisibility);
        List<Object> filtered = new ArrayList();
        if (osmId > 0L || wikidata != null) {
            filtered = this.filterByOsmIdOrWikidata(amenities, osmId, latLon, wikidata);
        }
        if (Algorithms.isEmpty(filtered) && !Algorithms.isEmpty(names) && (amenity = this.findByName(amenities, names, latLon, settings)) != null) {
            filtered = this.filterByOsmIdOrWikidata(amenities, amenity.getOsmId(), amenity.getLocation(), amenity.getWikidata());
        }
        if (!Algorithms.isEmpty(filtered)) {
            return new BaseDetailsObject(filtered, settings.language().get());
        }
        return null;
    }

    private List<Amenity> filterByOsmIdOrWikidata(Collection<Amenity> amenities, long id, LatLon point, String wikidata) {
        ArrayList<Amenity> result = new ArrayList<Amenity>();
        double minDist = 2000.0;
        for (Amenity amenity : amenities) {
            boolean idEqual;
            Long initAmenityId = amenity.getId();
            if (initAmenityId == null) continue;
            String wiki = amenity.getWikidata();
            boolean wikiEqual = wiki != null && wiki.equals(wikidata);
            boolean bl = idEqual = amenity.getOsmId() != null && amenity.getOsmId() == id;
            if (!idEqual && !wikiEqual || amenity.isClosed()) continue;
            double dist = MapUtils.getDistance(amenity.getLocation(), point);
            if (dist < minDist) {
                result.add(0, amenity);
                minDist = dist;
                continue;
            }
            result.add(amenity);
        }
        return result;
    }

    private Amenity findByName(Collection<Amenity> amenities, Collection<String> names, LatLon searchLatLon, Settings settings) {
        if (!Algorithms.isEmpty(names) && !Algorithms.isEmpty(amenities)) {
            return amenities.stream().sorted(Comparator.comparingDouble(a -> MapUtils.getDistance(a.getLocation(), searchLatLon))).filter(amenity -> !amenity.isClosed()).filter(amenity -> this.namesMatcher((Amenity)amenity, names, settings, false)).findAny().orElseGet(() -> amenities.stream().filter(amenity -> !amenity.isClosed()).filter(amenity -> amenity.isRoutePoint()).filter(amenity -> amenity.getName().isEmpty()).filter(amenity -> {
                String travelRouteId = amenity.getAdditionalInfo("route_id");
                return travelRouteId != null && names.contains(travelRouteId);
            }).findAny().orElseGet(() -> amenities.stream().filter(amenity -> this.namesMatcher((Amenity)amenity, names, settings, true)).findAny().orElse(null)));
        }
        return null;
    }

    private boolean namesMatcher(Amenity amenity, Collection<String> matchList, Settings settings, boolean matchAllLanguagesAndAltNames) {
        boolean transliterate;
        String lang = settings.language.get();
        String poiSimpleFormat = Amenity.getPoiStringWithoutType(amenity, lang, transliterate = settings.transliterate.get().booleanValue());
        if (matchList.contains(poiSimpleFormat)) {
            return true;
        }
        String amenityName = amenity.getName(lang, transliterate);
        if (!Algorithms.isEmpty(amenityName)) {
            for (String match : matchList) {
                if (!match.endsWith(amenityName)) continue;
                return true;
            }
        }
        if (this.mapPoiTypes != null) {
            String poiTypeName;
            AbstractPoiType st = this.mapPoiTypes.getAnyPoiTypeByKey(amenity.getSubType());
            String string = poiTypeName = st != null ? st.getTranslation() : amenity.getSubType();
            if (matchList.contains(poiTypeName)) {
                return true;
            }
        }
        if (matchAllLanguagesAndAltNames) {
            HashSet<String> allAmenityNames = new HashSet<String>();
            allAmenityNames.addAll(amenity.getAltNamesMap().values());
            allAmenityNames.addAll(amenity.getNamesMap(true).values());
            String typeName = amenity.getSubTypeStr();
            if (!Algorithms.isEmpty(typeName)) {
                HashSet<CallSite> withPoiTypes = new HashSet<CallSite>();
                for (String name : allAmenityNames) {
                    withPoiTypes.add((CallSite)((Object)(typeName + " " + name)));
                }
                allAmenityNames.addAll(withPoiTypes);
            }
            for (String match : matchList) {
                if (!allAmenityNames.contains(match)) continue;
                return true;
            }
        }
        return false;
    }

    public void addAmenityRepository(String fileName, AmenityIndexRepository repository) {
        this.amenityRepositories.put(fileName, repository);
    }

    public Collection<AmenityIndexRepository> getAmenityRepositories() {
        return this.amenityRepositories.values();
    }

    public AmenityIndexRepository getAmenityRepository(String fileName) {
        return this.amenityRepositories.get(fileName);
    }

    public void removeAmenityRepository(String fileName) {
        this.amenityRepositories.remove(fileName);
    }

    public void clearAmenityRepositories() {
        this.amenityRepositories.clear();
    }

    public List<Amenity> searchAmenitiesOnThePath(List<Location> locations, double radius, BinaryMapIndexReader.SearchPoiTypeFilter filter, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        if (locations != null && !locations.isEmpty()) {
            ArrayList<AmenityIndexRepository> repos = new ArrayList<AmenityIndexRepository>();
            double topLatitude = locations.get(0).getLatitude();
            double bottomLatitude = locations.get(0).getLatitude();
            double leftLongitude = locations.get(0).getLongitude();
            double rightLongitude = locations.get(0).getLongitude();
            for (Location l : locations) {
                topLatitude = Math.max(topLatitude, l.getLatitude());
                bottomLatitude = Math.min(bottomLatitude, l.getLatitude());
                leftLongitude = Math.min(leftLongitude, l.getLongitude());
                rightLongitude = Math.max(rightLongitude, l.getLongitude());
            }
            if (!filter.isEmpty()) {
                for (AmenityIndexRepository index : this.getAmenityRepositories()) {
                    if (!index.checkContainsInt(MapUtils.get31TileNumberY(topLatitude), MapUtils.get31TileNumberX(leftLongitude), MapUtils.get31TileNumberY(bottomLatitude), MapUtils.get31TileNumberX(rightLongitude))) continue;
                    repos.add(index);
                }
                if (!repos.isEmpty()) {
                    for (AmenityIndexRepository r : repos) {
                        List<Amenity> res = r.searchAmenitiesOnThePath(locations, radius, filter, matcher);
                        if (res == null) continue;
                        amenities.addAll(res);
                    }
                }
            }
        }
        return amenities;
    }

    private List<Amenity> searchRouteByName(String multipleSearch, CollatorStringMatcher.StringMatcherMode mode, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> result = new ArrayList<Amenity>();
        BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest(0, 0, multipleSearch, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, matcher);
        req.setMatcherMode(mode);
        for (AmenityIndexRepository index : this.getAmenityRepositories(false, null)) {
            List<Amenity> amenities = index.searchPoiByName(req);
            if (Algorithms.isEmpty(amenities)) continue;
            result.addAll(amenities);
        }
        return result;
    }

    public List<Amenity> searchRoutePartOf(final String routeId) {
        ResultMatcher<Amenity> matcher = new ResultMatcher<Amenity>(){

            @Override
            public boolean publish(Amenity amenity) {
                String members = amenity.getAdditionalInfo("route_members_ids");
                if (members != null) {
                    HashSet ids = new HashSet();
                    Collections.addAll(ids, members.split(" "));
                    return ids.contains(routeId);
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        return this.searchRouteByName(routeId, CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE, matcher);
    }

    public Map<String, List<Amenity>> searchRouteMembers(String multipleSearch) {
        final HashSet ids = new HashSet();
        Collections.addAll(ids, multipleSearch.split(" "));
        ResultMatcher<Amenity> matcher = new ResultMatcher<Amenity>(){

            @Override
            public boolean publish(Amenity amenity) {
                String routeId = amenity.getAdditionalInfo("route_id");
                return routeId != null && ids.contains(routeId);
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        HashMap<String, List<Amenity>> map = new HashMap<String, List<Amenity>>();
        List<Amenity> result = this.searchRouteByName(multipleSearch, CollatorStringMatcher.StringMatcherMode.MULTISEARCH, matcher);
        for (Amenity am : result) {
            String routeId = am.getAdditionalInfo("route_id");
            List amenities = map.computeIfAbsent(routeId, l -> new ArrayList());
            amenities.add(am);
        }
        for (String id : ids) {
            if (map.containsKey(id)) continue;
            map.put(id, null);
        }
        return map;
    }

    public List<Amenity> searchAmenitiesByName(String searchQuery, double topLatitude, double leftLongitude, double bottomLatitude, double rightLongitude, double lat, double lon, ResultMatcher<Amenity> matcher) {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        ArrayList<AmenityIndexRepository> list = new ArrayList<AmenityIndexRepository>();
        int left = MapUtils.get31TileNumberX(leftLongitude);
        int top = MapUtils.get31TileNumberY(topLatitude);
        int right = MapUtils.get31TileNumberX(rightLongitude);
        int bottom = MapUtils.get31TileNumberY(bottomLatitude);
        for (AmenityIndexRepository index : this.getAmenityRepositories(false, null)) {
            if (matcher != null && matcher.isCancelled()) break;
            if (!index.checkContainsInt(top, left, bottom, right)) continue;
            if (index.checkContains(lat, lon)) {
                list.add(0, index);
                continue;
            }
            list.add(index);
        }
        for (AmenityIndexRepository index : list) {
            if (matcher != null && matcher.isCancelled()) break;
            List<Amenity> result = index.searchAmenitiesByName(MapUtils.get31TileNumberX(lon), MapUtils.get31TileNumberY(lat), left, top, right, bottom, searchQuery, matcher);
            amenities.addAll(result);
        }
        return amenities;
    }

    private List<BinaryMapDataObject> searchBinaryMapDataForAmenity(Amenity amenity, int limit) {
        final long osmId = ObfConstants.getOsmObjectId(amenity);
        final boolean checkId = osmId > 0L;
        final String wikidata = amenity.getWikidata();
        final boolean checkWikidata = !Algorithms.isEmpty(wikidata);
        ResultMatcher<BinaryMapDataObject> matcher = new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (checkId && osmId == ObfConstants.getOsmObjectId(object)) {
                    return true;
                }
                if (checkWikidata) {
                    TIntObjectHashMap<String> names = object.getObjectNames();
                    return names != null && !names.isEmpty() && names.containsValue((Object)wikidata);
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return false;
            }
        };
        return this.searchBinaryMapDataObjects(amenity.getLocation(), matcher, limit);
    }

    private List<BinaryMapDataObject> searchBinaryMapDataObjects(LatLon latLon, final ResultMatcher<BinaryMapDataObject> matcher, final int limit) {
        final ArrayList<BinaryMapDataObject> list = new ArrayList<BinaryMapDataObject>();
        int y = MapUtils.get31TileNumberY(latLon.getLatitude());
        int x = MapUtils.get31TileNumberX(latLon.getLongitude());
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> request = BinaryMapIndexReader.buildSearchRequest(x, x + 1, y, y + 1, 15, null, new ResultMatcher<BinaryMapDataObject>(){

            @Override
            public boolean publish(BinaryMapDataObject object) {
                if (matcher == null || matcher.publish(object)) {
                    list.add(object);
                    return true;
                }
                return false;
            }

            @Override
            public boolean isCancelled() {
                return matcher != null && matcher.isCancelled() || limit != -1 && list.size() == limit;
            }
        });
        for (AmenityIndexRepository repository : this.getAmenityRepositories(false, null)) {
            if (matcher != null && matcher.isCancelled()) break;
            if (!repository.isPoiSectionIntersects(request)) continue;
            repository.searchMapIndex(request);
        }
        return list;
    }

    public void searchDetailedAmenityAsync(Request request, Settings settings, CallbackWithObject<Amenity> callbackWithAmenity) {
        this.singleThreadedExecutor.submit(() -> {
            Amenity amenity = this.searchDetailedAmenity(request, settings);
            callbackWithAmenity.processResult(amenity);
        });
    }

    public void searchBaseDetailedObjectAsync(NativeLibrary.RenderedObject renderedObject, Settings settings, CallbackWithObject<BaseDetailsObject> callback) {
        LatLon latLon = renderedObject.getLatLon();
        if (latLon == null) {
            callback.processResult(null);
            return;
        }
        this.singleThreadedExecutor.submit(() -> {
            Request request = new Request(renderedObject);
            BaseDetailsObject detailsObject = this.searchDetailedObject(request, settings);
            if (detailsObject != null) {
                detailsObject.addObject(renderedObject);
                Amenity amenity = detailsObject.getSyntheticAmenity();
                if (detailsObject.getPointsLength() < renderedObject.getX().size()) {
                    amenity.setX(renderedObject.getX());
                    amenity.setY(renderedObject.getY());
                }
            }
            callback.processResult(detailsObject);
        });
    }

    public void searchDetailedObjectAsync(Object object, Settings settings, CallbackWithObject<Object> callback) {
        this.singleThreadedExecutor.submit(() -> {
            BaseDetailsObject fetched = this.searchDetailedObject(object, settings);
            callback.processResult(fetched == null ? object : fetched);
        });
    }

    private void completeGeometry(BaseDetailsObject detailsObject, Object object) {
        if (detailsObject == null) {
            return;
        }
        TIntArrayList xx = null;
        TIntArrayList yy = null;
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            xx = amenity.getX();
            yy = amenity.getY();
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            xx = renderedObject.getX();
            yy = renderedObject.getY();
        }
        if (object instanceof BaseDetailsObject) {
            BaseDetailsObject base = (BaseDetailsObject)object;
            xx = base.getSyntheticAmenity().getX();
            yy = base.getSyntheticAmenity().getY();
        }
        if (xx != null && yy != null && !xx.isEmpty()) {
            detailsObject.setX(xx);
            detailsObject.setY(yy);
        } else {
            List<BinaryMapDataObject> dataObjects = this.searchBinaryMapDataForAmenity(detailsObject.getSyntheticAmenity(), 1);
            for (BinaryMapDataObject dataObject : dataObjects) {
                if (this.copyCoordinates(detailsObject, dataObject)) break;
            }
        }
    }

    private boolean copyCoordinates(BaseDetailsObject detailsObject, BinaryMapDataObject mapObject) {
        int pointsLength = mapObject.getPointsLength();
        if (detailsObject.getPointsLength() < pointsLength) {
            detailsObject.clearGeometry();
            for (int i = 0; i < pointsLength; ++i) {
                detailsObject.addX(mapObject.getPoint31XTile(i));
                detailsObject.addY(mapObject.getPoint31YTile(i));
            }
        }
        return pointsLength > 0;
    }

    public static class Request {
        private final LatLon latLon;
        private final Long osmId;
        private final Entity.EntityType type;
        private final String wikidata;
        private Collection<String> names;

        public Request(MapObject mapObject) {
            this.osmId = ObfConstants.getOsmObjectId(mapObject);
            this.type = ObfConstants.getOsmEntityType(mapObject);
            if (mapObject instanceof Amenity) {
                Amenity amenity = (Amenity)mapObject;
                this.latLon = mapObject.getLocation();
                this.wikidata = amenity.getWikidata();
                this.names = amenity.getOtherNames();
                this.names.add(amenity.getName());
            } else if (mapObject instanceof NativeLibrary.RenderedObject) {
                NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)mapObject;
                this.latLon = renderedObject.getLatLon();
                this.names = renderedObject.getOriginalNames();
                this.wikidata = renderedObject.getTagValue("wikidata");
            } else if (mapObject instanceof TransportStop) {
                TransportStop stop = (TransportStop)mapObject;
                this.latLon = mapObject.getLocation();
                this.names = stop.getOtherNames();
                this.wikidata = null;
                this.names.add(stop.getName());
            } else {
                this.latLon = mapObject.getLocation();
                this.wikidata = null;
                this.names = mapObject.getOtherNames();
            }
        }

        public Request(MapObject mapObject, List<String> names) {
            this(mapObject);
            this.names = names;
        }
    }

    public record Settings(Supplier<String> language, Supplier<Boolean> transliterate, Predicate<String> fileVisibility) {
    }
}

