/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.set.hash.TIntHashSet;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.render.RenderingRuleSearchRequest;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.RoadSplitStructure;
import net.osmand.router.RoundaboutTurn;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RouteStatisticsHelper;
import net.osmand.router.RoutingContext;
import net.osmand.router.TurnType;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

public class RouteResultPreparation {
    public static boolean PRINT_TO_CONSOLE_ROUTE_INFORMATION = true;
    public static boolean PRINT_TO_CONSOLE_ROUTE_INFORMATION_TO_TEST = false;
    public static String PRINT_TO_GPX_FILE = null;
    private static final float TURN_DEGREE_MIN = 45.0f;
    private static final float UNMATCHED_TURN_DEGREE_MINIMUM = 45.0f;
    private static final float SPLIT_TURN_DEGREE_NOT_STRAIGHT = 100.0f;
    private static final float TURN_SLIGHT_DEGREE = 5.0f;
    public static final int SHIFT_ID = 6;
    protected static final Log LOG = PlatformUtil.getLog(RouteResultPreparation.class);
    public static final String UNMATCHED_HIGHWAY_TYPE = "unmatched";
    private static final double SLOW_DOWN_SPEED_THRESHOLD = 15.0;
    private static final double SLOW_DOWN_SPEED = 2.0;
    private static final int MAX_SPEAK_PRIORITY = 5;

    private void combineWayPointsForAreaRouting(RoutingContext ctx, List<RouteSegmentResult> result) {
        for (int i = 0; i < result.size(); ++i) {
            RouteSegmentResult rsr = result.get(i);
            RouteDataObject obj = rsr.getObject();
            boolean area = false;
            if (obj.getPoint31XTile(0) == obj.getPoint31XTile(obj.getPointsLength() - 1) && obj.getPoint31YTile(0) == obj.getPoint31YTile(obj.getPointsLength() - 1)) {
                area = true;
            }
            if (!area || !ctx.getRouter().isArea(obj)) continue;
            ArrayList<CombineAreaRoutePoint> originalWay = new ArrayList<CombineAreaRoutePoint>();
            ArrayList<CombineAreaRoutePoint> routeWay = new ArrayList<CombineAreaRoutePoint>();
            for (int j = 0; j < obj.getPointsLength(); ++j) {
                CombineAreaRoutePoint pnt = new CombineAreaRoutePoint();
                pnt.x31 = obj.getPoint31XTile(j);
                pnt.y31 = obj.getPoint31YTile(j);
                pnt.originalIndex = j;
                originalWay.add(pnt);
                if (j >= rsr.getStartPointIndex() && j <= rsr.getEndPointIndex()) {
                    routeWay.add(pnt);
                    continue;
                }
                if (j > rsr.getStartPointIndex() || j < rsr.getEndPointIndex()) continue;
                routeWay.add(0, pnt);
            }
            int originalSize = routeWay.size();
            this.simplifyAreaRouteWay(routeWay, originalWay);
            int newsize = routeWay.size();
            if (routeWay.size() == originalSize) continue;
            RouteDataObject nobj = new RouteDataObject(obj);
            nobj.pointsX = new int[newsize];
            nobj.pointsY = new int[newsize];
            for (int k = 0; k < newsize; ++k) {
                nobj.pointsX[k] = ((CombineAreaRoutePoint)routeWay.get((int)k)).x31;
                nobj.pointsY[k] = ((CombineAreaRoutePoint)routeWay.get((int)k)).y31;
            }
            nobj.restrictions = null;
            nobj.restrictionsVia = null;
            nobj.pointTypes = null;
            nobj.pointNames = null;
            nobj.pointNameTypes = null;
            RouteSegmentResult nrsr = new RouteSegmentResult(nobj, 0, newsize - 1);
            result.set(i, nrsr);
        }
    }

    private void simplifyAreaRouteWay(List<CombineAreaRoutePoint> routeWay, List<CombineAreaRoutePoint> originalWay) {
        boolean changed = true;
        while (changed) {
            changed = false;
            int connectStart = -1;
            int connectLen = 0;
            double dist = 0.0;
            for (int length = routeWay.size() - 1; length > 0 && connectLen == 0; --length) {
                for (int i = 0; i < routeWay.size() - length; ++i) {
                    double ndist;
                    CombineAreaRoutePoint n;
                    CombineAreaRoutePoint p = routeWay.get(i);
                    if (!this.segmentLineBelongsToPolygon(p, n = routeWay.get(i + length), originalWay) || !((ndist = BinaryRoutePlanner.squareRootDist(p.x31, p.y31, n.x31, n.y31)) > dist)) continue;
                    ndist = dist;
                    connectStart = i;
                    connectLen = length;
                }
            }
            while (connectLen > 1) {
                routeWay.remove(connectStart + 1);
                --connectLen;
                changed = true;
            }
        }
    }

    private boolean segmentLineBelongsToPolygon(CombineAreaRoutePoint p, CombineAreaRoutePoint n, List<CombineAreaRoutePoint> originalWay) {
        int intersections = 0;
        int mx = p.x31 / 2 + n.x31 / 2;
        int my = p.y31 / 2 + n.y31 / 2;
        for (int i = 1; i < originalWay.size(); ++i) {
            CombineAreaRoutePoint p2 = originalWay.get(i - 1);
            CombineAreaRoutePoint n2 = originalWay.get(i);
            if (p.originalIndex != i && p.originalIndex != i - 1 && n.originalIndex != i && n.originalIndex != i - 1 && MapAlgorithms.linesIntersect(p.x31, p.y31, n.x31, n.y31, p2.x31, p2.y31, n2.x31, n2.y31)) {
                return false;
            }
            int fx = MapAlgorithms.ray_intersect_x(p2.x31, p2.y31, n2.x31, n2.y31, my);
            if (Integer.MIN_VALUE == fx || mx < fx) continue;
            ++intersections;
        }
        return intersections % 2 == 1;
    }

    public RouteCalcResult prepareResult(RoutingContext ctx, List<RouteSegmentResult> result) throws IOException {
        int i;
        for (i = 0; i < result.size(); ++i) {
            RouteDataObject road = result.get(i).getObject();
            this.checkAndInitRouteRegion(ctx, road);
            if (road.region == null) continue;
            road.region.findOrCreateRouteType("osmand_dp", "osmand_delete_point");
        }
        this.combineWayPointsForAreaRouting(ctx, result);
        this.validateAllPointsConnected(result);
        this.splitRoadsAndAttachRoadSegments(ctx, result);
        for (i = 0; i < result.size(); ++i) {
            this.filterMinorStops(result.get(i));
        }
        RouteResultPreparation.calculateTimeSpeed(ctx, result);
        this.prepareTurnResults(ctx, result);
        RouteCalcResult res = new RouteCalcResult(result);
        return res;
    }

    public RouteSegmentResult filterMinorStops(RouteSegmentResult seg) {
        ArrayList<Integer> stops = null;
        boolean plus = seg.getStartPointIndex() < seg.getEndPointIndex();
        int i = seg.getStartPointIndex();
        while (i != seg.getEndPointIndex()) {
            int next = plus ? i + 1 : i - 1;
            int[] pointTypes = seg.getObject().getPointTypes(i);
            if (pointTypes != null) {
                for (int j = 0; j < pointTypes.length; ++j) {
                    if (pointTypes[j] != seg.getObject().region.stopMinor) continue;
                    if (stops == null) {
                        stops = new ArrayList<Integer>();
                    }
                    stops.add(i);
                }
            }
            i = next;
        }
        if (stops != null) {
            Iterator iterator = stops.iterator();
            block2: while (iterator.hasNext()) {
                int stop = (Integer)iterator.next();
                List<RouteSegmentResult> attachedRoutes = seg.getAttachedRoutes(stop);
                for (RouteSegmentResult attached : attachedRoutes) {
                    int attStopPriority = this.highwaySpeakPriority(attached.getObject().getHighway());
                    int segStopPriority = this.highwaySpeakPriority(seg.getObject().getHighway());
                    if (segStopPriority >= attStopPriority) continue;
                    seg.getObject().removePointType(stop, seg.getObject().region.stopSign);
                    continue block2;
                }
            }
        }
        return seg;
    }

    public void prepareTurnResults(RoutingContext ctx, List<RouteSegmentResult> result) {
        for (int i = 0; i < result.size(); ++i) {
            TurnType turnType = this.getTurnInfo(result, i, ctx.leftSideNavigation);
            result.get(i).setTurnType(turnType);
        }
        this.determineTurnsToMerge(ctx.leftSideNavigation, result);
        this.ignorePrecedingStraightsOnSameIntersection(ctx.leftSideNavigation, result);
        this.justifyUTurns(ctx.leftSideNavigation, result);
        this.avoidKeepForThroughMoving(result);
        this.muteAndRemoveTurns(result, ctx);
        this.addTurnInfoDescriptions(result);
    }

    protected void ignorePrecedingStraightsOnSameIntersection(boolean leftside, List<RouteSegmentResult> result) {
        RouteSegmentResult nextSegment = null;
        double distanceToNextTurn = 999999.0;
        for (int i = result.size() - 1; i >= 0; --i) {
            RouteSegmentResult currentSegment;
            if (nextSegment != null && nextSegment.getTurnType() != null && nextSegment.getTurnType().getValue() != 1 && !this.isMotorway(nextSegment) && distanceToNextTurn == 999999.0) {
                distanceToNextTurn = 0.0;
            }
            if ((currentSegment = result.get(i)) == null) continue;
            distanceToNextTurn += (double)currentSegment.getDistance();
            if (currentSegment.getTurnType() != null && currentSegment.getTurnType().getValue() == 1 && distanceToNextTurn <= 200.0) {
                currentSegment.getTurnType().setSkipToSpeak(true);
                continue;
            }
            nextSegment = currentSegment;
            if (currentSegment.getTurnType() == null) continue;
            distanceToNextTurn = 999999.0;
        }
    }

    private void justifyUTurns(boolean leftSide, List<RouteSegmentResult> result) {
        int i = 1;
        while (i < result.size() - 1) {
            TurnType jt;
            int next = i + 1;
            TurnType t = result.get(i).getTurnType();
            if (t != null && (jt = this.justifyUTurn(leftSide, result, i, t)) != null) {
                result.get(i).setTurnType(jt);
                next = i + 2;
            }
            i = next;
        }
    }

    public static void calculateTimeSpeed(RoutingContext ctx, List<RouteSegmentResult> result) {
        for (int i = 0; i < result.size(); ++i) {
            RouteSegmentResult rr = result.get(i);
            RouteResultPreparation.calculateTimeSpeed(ctx, rr);
        }
    }

    public static void calculateTimeSpeed(RoutingContext ctx, RouteSegmentResult rr) {
        boolean useNaismithRule = false;
        double scarfSeconds = 0.0;
        GeneralRouter currentRouter = (GeneralRouter)ctx.getRouter();
        if (currentRouter.getProfile() == GeneralRouter.GeneralRouterProfile.PEDESTRIAN) {
            scarfSeconds = 7.92f / currentRouter.getDefaultSpeed();
            useNaismithRule = true;
        } else if (currentRouter.getProfile() == GeneralRouter.GeneralRouterProfile.BICYCLE) {
            scarfSeconds = 8.2f / currentRouter.getDefaultSpeed();
            useNaismithRule = true;
        }
        RouteDataObject road = rr.getObject();
        double distOnRoadToPass = 0.0;
        double speed = ctx.getRouter().defineVehicleSpeed(road, rr.isForwardDirection());
        if (speed == 0.0) {
            speed = ctx.getRouter().getDefaultSpeed();
        } else if (speed > 15.0) {
            speed -= (speed / 15.0 - 1.0) * 2.0;
        }
        boolean plus = rr.getStartPointIndex() < rr.getEndPointIndex();
        double distance = 0.0;
        float[] heightDistanceArray = null;
        if (useNaismithRule) {
            road.calculateHeightArray();
            heightDistanceArray = road.heightDistanceArray;
        }
        int j = rr.getStartPointIndex();
        while (j != rr.getEndPointIndex()) {
            int next = plus ? j + 1 : j - 1;
            double d = RouteResultPreparation.measuredDist(road.getPoint31XTile(j), road.getPoint31YTile(j), road.getPoint31XTile(next), road.getPoint31YTile(next));
            distance += d;
            double obstacle = ctx.getRouter().defineObstacle(road, j, plus);
            if (obstacle < 0.0) {
                obstacle = 0.0;
            }
            distOnRoadToPass += d / speed + obstacle;
            if (useNaismithRule) {
                float heightDiff;
                int heightIndex = 2 * j + 1;
                int nextHeightIndex = 2 * next + 1;
                if (heightDistanceArray != null && heightIndex < heightDistanceArray.length && nextHeightIndex < heightDistanceArray.length && (heightDiff = heightDistanceArray[nextHeightIndex] - heightDistanceArray[heightIndex]) > 0.0f) {
                    distOnRoadToPass += (double)heightDiff * scarfSeconds;
                }
            }
            j = next;
        }
        rr.setDistance((float)distance);
        rr.setSegmentTime((float)distOnRoadToPass);
        if (distOnRoadToPass != 0.0) {
            rr.setSegmentSpeed((float)(distance / distOnRoadToPass));
        } else {
            rr.setSegmentSpeed((float)speed);
        }
    }

    public static void recalculateTimeDistance(List<RouteSegmentResult> result) {
        for (int i = 0; i < result.size(); ++i) {
            RouteSegmentResult rr = result.get(i);
            RouteDataObject road = rr.getObject();
            double distOnRoadToPass = 0.0;
            double speed = rr.getSegmentSpeed();
            if (speed == 0.0) continue;
            boolean plus = rr.getStartPointIndex() < rr.getEndPointIndex();
            double distance = 0.0;
            int j = rr.getStartPointIndex();
            while (j != rr.getEndPointIndex()) {
                int next = plus ? j + 1 : j - 1;
                double d = RouteResultPreparation.measuredDist(road.getPoint31XTile(j), road.getPoint31YTile(j), road.getPoint31XTile(next), road.getPoint31YTile(next));
                distance += d;
                distOnRoadToPass += d / speed;
                j = next;
            }
            rr.setSegmentTime((float)distOnRoadToPass);
            rr.setSegmentSpeed((float)speed);
            rr.setDistance((float)distance);
        }
    }

    private void splitRoadsAndAttachRoadSegments(RoutingContext ctx, List<RouteSegmentResult> result) throws IOException {
        for (int i = 0; i < result.size(); ++i) {
            RouteSegmentResult rr;
            if (ctx.checkIfMemoryLimitCritical(ctx.config.memoryLimitation)) {
                ctx.unloadUnusedTiles(ctx.config.memoryLimitation);
            }
            boolean plus = (rr = result.get(i)).getStartPointIndex() < rr.getEndPointIndex();
            boolean unmatched = UNMATCHED_HIGHWAY_TYPE.equals(rr.getObject().getHighway());
            int j = rr.getStartPointIndex();
            while (j != rr.getEndPointIndex()) {
                boolean tryToSplit;
                int next;
                int n = next = plus ? j + 1 : j - 1;
                if (j == rr.getStartPointIndex()) {
                    this.attachRoadSegments(ctx, result, i, j, plus);
                }
                if (next != rr.getEndPointIndex()) {
                    this.attachRoadSegments(ctx, result, i, next, plus);
                }
                List<RouteSegmentResult> attachedRoutes = rr.getAttachedRoutes(next);
                boolean bl = tryToSplit = next != rr.getEndPointIndex() && !rr.getObject().roundabout() && attachedRoutes != null;
                if (rr.getDistance(next, plus) == 0.0f) {
                    tryToSplit = false;
                }
                if (tryToSplit) {
                    float distBearing = unmatched ? 50.0f : 15.0f;
                    float before = rr.getBearingEnd(next, distBearing);
                    float after = rr.getBearingBegin(next, distBearing);
                    if (rr.getDistance(next, plus) < distBearing) {
                        after = before;
                    } else {
                        boolean bl2 = !plus;
                        if (rr.getDistance(next, bl2) < distBearing) {
                            before = after;
                        }
                    }
                    double contAngle = Math.abs(MapUtils.degreesDiff(before, after));
                    boolean straight = contAngle < 45.0;
                    boolean isSplit = false;
                    if (unmatched && Math.abs(contAngle) >= 45.0) {
                        isSplit = true;
                    }
                    for (RouteSegmentResult rs : attachedRoutes) {
                        double diff = MapUtils.degreesDiff(before, rs.getBearingBegin());
                        if (Math.abs(diff) <= 45.0) {
                            isSplit = true;
                            continue;
                        }
                        if (straight || !(Math.abs(diff) < 100.0)) continue;
                        isSplit = true;
                    }
                    if (isSplit) {
                        int endPointIndex = rr.getEndPointIndex();
                        RouteSegmentResult split = new RouteSegmentResult(rr.getObject(), next, endPointIndex);
                        split.copyPreattachedRoutes(rr, Math.abs(next - rr.getStartPointIndex()));
                        rr.setEndPointIndex(next);
                        result.add(i + 1, split);
                        ++i;
                        rr = split;
                    }
                }
                j = next;
            }
        }
    }

    private void checkAndInitRouteRegion(RoutingContext ctx, RouteDataObject road) throws IOException {
        BinaryMapIndexReader reader = ctx.reverseMap.get(road.region);
        if (reader != null) {
            reader.initRouteRegion(road.region);
        }
    }

    public void validateAllPointsConnected(List<RouteSegmentResult> result) {
        for (int i = 1; i < result.size(); ++i) {
            RouteSegmentResult rr = result.get(i);
            RouteSegmentResult pr = result.get(i - 1);
            double d = MapUtils.getDistance(pr.getPoint(pr.getEndPointIndex()), rr.getPoint(rr.getStartPointIndex()));
            if (!(d > 0.0)) continue;
            System.out.printf("Points are not connected: %d-%d of %d %s (%d) -> %s (%d) by %.2f meters\n", i - 1, i, result.size() - 1, pr.getObject(), pr.getEndPointIndex(), rr.getObject(), rr.getStartPointIndex(), d);
        }
    }

    public List<RouteSegmentResult> convertFinalSegmentToResults(RoutingContext ctx, BinaryRoutePlanner.FinalRouteSegment finalSegment) {
        ArrayList<RouteSegmentResult> result = new ArrayList<RouteSegmentResult>();
        if (finalSegment != null) {
            float parentRoutingTime;
            RouteSegmentResult res;
            BinaryRoutePlanner.RouteSegment segment;
            ctx.routingTime += finalSegment.distanceFromStart;
            float correctionTime = finalSegment.opposite == null ? 0.0f : finalSegment.distanceFromStart - this.distanceFromStart(finalSegment.opposite) - this.distanceFromStart(finalSegment.parentRoute);
            BinaryRoutePlanner.RouteSegment thisSegment = finalSegment.opposite == null ? finalSegment : finalSegment.parentRoute;
            BinaryRoutePlanner.RouteSegment routeSegment = segment = finalSegment.reverseWaySearch ? thisSegment : finalSegment.opposite;
            while (segment != null) {
                res = new RouteSegmentResult(segment.road, segment.getSegmentEnd(), segment.getSegmentStart());
                parentRoutingTime = segment.getParentRoute() != null ? segment.getParentRoute().distanceFromStart : 0.0f;
                res.setRoutingTime(segment.distanceFromStart - parentRoutingTime + correctionTime);
                correctionTime = 0.0f;
                segment = segment.getParentRoute();
                this.addRouteSegmentToResult(ctx, result, res, false);
            }
            Collections.reverse(result);
            BinaryRoutePlanner.RouteSegment routeSegment2 = segment = finalSegment.reverseWaySearch ? finalSegment.opposite : thisSegment;
            while (segment != null) {
                res = new RouteSegmentResult(segment.road, segment.getSegmentStart(), segment.getSegmentEnd());
                parentRoutingTime = segment.getParentRoute() != null ? segment.getParentRoute().distanceFromStart : 0.0f;
                res.setRoutingTime(segment.distanceFromStart - parentRoutingTime + correctionTime);
                correctionTime = 0.0f;
                segment = segment.getParentRoute();
                this.addRouteSegmentToResult(ctx, result, res, true);
            }
            Collections.reverse(result);
            this.checkTotalRoutingTime(result, finalSegment.distanceFromStart);
        }
        return result;
    }

    private float distanceFromStart(BinaryRoutePlanner.RouteSegment s) {
        return s == null ? 0.0f : s.distanceFromStart;
    }

    protected void checkTotalRoutingTime(List<RouteSegmentResult> result, float cmp) {
        float totalRoutingTime = 0.0f;
        for (RouteSegmentResult r : result) {
            totalRoutingTime += r.getRoutingTime();
        }
        if ((double)Math.abs(totalRoutingTime - cmp) > 0.1) {
            RouteResultPreparation.println("Total sum routing time ! " + totalRoutingTime + " == " + cmp);
        }
    }

    private void addRouteSegmentToResult(RoutingContext ctx, List<RouteSegmentResult> result, RouteSegmentResult res, boolean reverse) {
        if (res.getStartPointIndex() != res.getEndPointIndex()) {
            if (result.size() > 0) {
                RouteSegmentResult last = result.get(result.size() - 1);
                if (last.getObject().id == res.getObject().id && ctx.calculationMode != RoutePlannerFrontEnd.RouteCalculationMode.BASE && this.combineTwoSegmentResult(res, last, reverse)) {
                    return;
                }
            }
            result.add(res);
        }
    }

    private boolean combineTwoSegmentResult(RouteSegmentResult toAdd, RouteSegmentResult previous, boolean reverse) {
        boolean rd;
        boolean ld = previous.getEndPointIndex() > previous.getStartPointIndex();
        boolean bl = rd = toAdd.getEndPointIndex() > toAdd.getStartPointIndex();
        if (rd == ld) {
            if (toAdd.getStartPointIndex() == previous.getEndPointIndex() && !reverse) {
                previous.setEndPointIndex(toAdd.getEndPointIndex());
                previous.setRoutingTime(previous.getRoutingTime() + toAdd.getRoutingTime());
                return true;
            }
            if (toAdd.getEndPointIndex() == previous.getStartPointIndex() && reverse) {
                previous.setStartPointIndex(toAdd.getStartPointIndex());
                previous.setRoutingTime(previous.getRoutingTime() + toAdd.getRoutingTime());
                return true;
            }
        }
        return false;
    }

    public static void printResults(RoutingContext ctx, LatLon start, LatLon end, List<RouteSegmentResult> result) {
        LinkedHashMap<String, Object> info = new LinkedHashMap<String, Object>();
        LinkedHashMap<String, Object> route = new LinkedHashMap<String, Object>();
        info.put("route", route);
        route.put("routing_time", String.format("%.1f", Float.valueOf(ctx.routingTime)));
        route.put("vehicle", ctx.config.routerName);
        route.put("base", ctx.calculationMode == RoutePlannerFrontEnd.RouteCalculationMode.BASE);
        route.put("start_lat", String.format("%.5f", start.getLatitude()));
        route.put("start_lon", String.format("%.5f", start.getLongitude()));
        route.put("target_lat", String.format("%.5f", end.getLatitude()));
        route.put("target_lon", String.format("%.5f", end.getLongitude()));
        if (result != null) {
            float completeTime = 0.0f;
            float completeDistance = 0.0f;
            for (RouteSegmentResult r : result) {
                completeTime += r.getSegmentTime();
                completeDistance += r.getDistance();
            }
            route.put("complete_distance", String.format("%.1f", Float.valueOf(completeDistance)));
            route.put("complete_time", String.format("%.1f", Float.valueOf(completeTime)));
        }
        route.put("native", ctx.nativeLib != null);
        if (ctx.calculationProgress != null && ctx.calculationProgress.timeToCalculate > 0L) {
            info.putAll(ctx.calculationProgress.getInfo(ctx.calculationProgressFirstPhase));
        }
        String alerts = String.format("Alerts during routing: %d fastRoads, %d slowSegmentsEearlier", ctx.alertFasterRoadToVisitedSegments, ctx.alertSlowerSegmentedWasVisitedEarlier);
        if (ctx.alertFasterRoadToVisitedSegments + ctx.alertSlowerSegmentedWasVisitedEarlier == 0) {
            alerts = "No alerts";
        }
        RouteResultPreparation.println("ROUTE. " + alerts);
        ArrayList<String> routeInfo = new ArrayList<String>();
        StringBuilder extraInfo = RouteResultPreparation.buildRouteMessagesFromInfo(info, routeInfo);
        if (PRINT_TO_CONSOLE_ROUTE_INFORMATION_TO_TEST && result != null) {
            RouteResultPreparation.println(String.format("<test %s>", extraInfo.toString()));
            RouteResultPreparation.printRouteInfoSegments(result);
            RouteResultPreparation.println("</test>");
            if (ctx.calculationProgressFirstPhase != null) {
                RouteResultPreparation.println("<<<1st Phase>>>>");
                ArrayList<String> baseRouteInfo = new ArrayList<String>();
                RouteResultPreparation.buildRouteMessagesFromInfo(ctx.calculationProgressFirstPhase.getInfo(null), baseRouteInfo);
                for (String msg : baseRouteInfo) {
                    RouteResultPreparation.println(msg);
                }
                RouteResultPreparation.println("<<<2nd Phase>>>>");
            }
        }
        for (String msg : routeInfo) {
            RouteResultPreparation.println(msg);
        }
    }

    private static StringBuilder buildRouteMessagesFromInfo(Map<String, Object> info, List<String> routeMessages) {
        StringBuilder extraInfo = new StringBuilder();
        for (String key : info.keySet()) {
            if (!(info.get(key) instanceof Map)) continue;
            Map mp = (Map)info.get(key);
            StringBuilder msg = new StringBuilder("Route <" + key + ">");
            int i = 0;
            for (String mkey : mp.keySet()) {
                msg.append(i++ == 0 ? ": " : ", ");
                Object obj = mp.get(mkey);
                String valueString = obj.toString();
                if (obj instanceof Double || obj instanceof Float) {
                    valueString = String.format("%.1f", ((Number)obj).doubleValue());
                }
                msg.append(mkey).append("=").append(valueString);
                extraInfo.append(" ").append(key + "_" + mkey).append("=\"").append(valueString).append("\"");
            }
            if (routeMessages == null) continue;
            routeMessages.add(msg.toString());
        }
        return extraInfo;
    }

    private static void printRouteInfoSegments(List<RouteSegmentResult> result) {
        XmlSerializer serializer = null;
        if (PRINT_TO_GPX_FILE != null) {
            serializer = PlatformUtil.newSerializer();
            try {
                serializer.setOutput((Writer)new FileWriter(PRINT_TO_GPX_FILE));
                serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
                serializer.startDocument("UTF-8", Boolean.valueOf(true));
                serializer.startTag("", "gpx");
                serializer.attribute("", "version", "1.1");
                serializer.attribute("", "xmlns", "http://www.topografix.com/GPX/1/1");
                serializer.attribute("", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
                serializer.attribute("", "xmlns:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
                serializer.startTag("", "trk");
                serializer.startTag("", "trkseg");
            }
            catch (IOException e) {
                e.printStackTrace();
                serializer = null;
            }
        }
        double lastHeight = -180.0;
        for (RouteSegmentResult res : result) {
            Object name = res.getObject().getName();
            String ref = res.getObject().getRef("", false, res.isForwardDirection());
            if (name == null) {
                name = "";
            }
            if (ref != null) {
                name = (String)name + " (" + ref + ") ";
            }
            StringBuilder additional = new StringBuilder();
            additional.append("time = \"").append((float)((int)res.getSegmentTime() * 100) / 100.0f).append("\" ");
            if (res.getRoutingTime() > 0.0f) {
                additional.append(String.format("rtime = \"%.1f\" ", Float.valueOf(res.getRoutingTime())));
            }
            additional.append("name = \"").append((String)name).append("\" ");
            float ms = res.getObject().getMaximumSpeed(res.isForwardDirection());
            if (ms > 0.0f) {
                additional.append("maxspeed = \"").append(Math.round(ms * 3.6f)).append("\" ");
            }
            additional.append("distance = \"").append((float)((int)res.getDistance() * 100) / 100.0f).append("\" ");
            additional.append(res.getObject().getHighway()).append(" ");
            if (res.getTurnType() != null) {
                additional.append("turn = \"").append(res.getTurnType()).append("\" ");
                additional.append("turn_angle = \"").append(res.getTurnType().getTurnAngle()).append("\" ");
                if (res.getTurnType().getLanes() != null) {
                    additional.append("lanes = \"").append(Arrays.toString(res.getTurnType().getLanes())).append("\" ");
                }
            }
            additional.append("start_bearing = \"").append(res.getBearingBegin()).append("\" ");
            additional.append("end_bearing = \"").append(res.getBearingEnd()).append("\" ");
            additional.append("height = \"").append(Arrays.toString(res.getHeightValues())).append("\" ");
            additional.append("description = \"").append(res.getDescription(false)).append("\" ");
            RouteResultPreparation.println(MessageFormat.format("\t<segment id=\"{0}\" oid=\"{1}\" start=\"{2}\" end=\"{3}\" {4}/>", "" + (res.getObject().getId() >> 6), "" + res.getObject().getId(), "" + res.getStartPointIndex(), "" + res.getEndPointIndex(), additional.toString()));
            int inc = res.getStartPointIndex() < res.getEndPointIndex() ? 1 : -1;
            int indexnext = res.getStartPointIndex();
            LatLon prev = null;
            int index = res.getStartPointIndex();
            while (index != res.getEndPointIndex()) {
                index = indexnext;
                indexnext += inc;
                if (serializer == null) continue;
                try {
                    double dist;
                    LatLon l = res.getPoint(index);
                    serializer.startTag("", "trkpt");
                    serializer.attribute("", "lat", "" + l.getLatitude());
                    serializer.attribute("", "lon", "" + l.getLongitude());
                    float[] vls = res.getObject().heightDistanceArray;
                    double d = dist = prev == null ? 0.0 : MapUtils.getDistance(prev, l);
                    if (index * 2 + 1 < vls.length) {
                        double h = vls[2 * index + 1];
                        serializer.startTag("", "ele");
                        serializer.text("" + h);
                        serializer.endTag("", "ele");
                        if (lastHeight != -180.0 && dist > 0.0) {
                            serializer.startTag("", "cmt");
                            serializer.text((float)((h - lastHeight) / dist * 100.0) + "%  degree " + (double)((float)Math.atan((h - lastHeight) / dist)) / Math.PI * 180.0 + " asc " + (float)(h - lastHeight) + " dist " + (float)dist);
                            serializer.endTag("", "cmt");
                            serializer.startTag("", "slope");
                            serializer.text("" + (h - lastHeight) / dist * 100.0);
                            serializer.endTag("", "slope");
                        }
                        serializer.startTag("", "desc");
                        serializer.text((res.getObject().getId() >> 6) + " " + index);
                        serializer.endTag("", "desc");
                        lastHeight = h;
                    } else if (lastHeight != -180.0) {
                        // empty if block
                    }
                    serializer.endTag("", "trkpt");
                    prev = l;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            RouteResultPreparation.printAdditionalPointInfo(res);
        }
        if (serializer != null) {
            try {
                serializer.endTag("", "trkseg");
                serializer.endTag("", "trk");
                serializer.endTag("", "gpx");
                serializer.endDocument();
                serializer.flush();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void calculateStatistics(List<RouteSegmentResult> result) {
        InputStream is = RenderingRulesStorage.class.getResourceAsStream("default.render.xml");
        LinkedHashMap<String, String> renderingConstants = new LinkedHashMap<String, String>();
        try {
            try (InputStream pis = RenderingRulesStorage.class.getResourceAsStream("default.render.xml");){
                int tok;
                XmlPullParser parser = PlatformUtil.newXMLPullParser();
                parser.setInput(pis, "UTF-8");
                while ((tok = parser.next()) != 1) {
                    String tagName;
                    if (tok != 2 || !(tagName = parser.getName()).equals("renderingConstant") || renderingConstants.containsKey(parser.getAttributeValue("", "name"))) continue;
                    renderingConstants.put(parser.getAttributeValue("", "name"), parser.getAttributeValue("", "value"));
                }
            }
            RenderingRulesStorage rrs = new RenderingRulesStorage("default", renderingConstants);
            rrs.parseRulesFromXmlInputStream(is, new RenderingRulesStorage.RenderingRulesStorageResolver(){

                @Override
                public RenderingRulesStorage resolve(String name, RenderingRulesStorage.RenderingRulesStorageResolver ref) throws XmlPullParserException, IOException {
                    throw new UnsupportedOperationException();
                }
            }, false);
            RenderingRuleSearchRequest req = new RenderingRuleSearchRequest(rrs);
            List<RouteStatisticsHelper.RouteStatistics> rsr = RouteStatisticsHelper.calculateRouteStatistic(result, null, rrs, null, req);
            for (RouteStatisticsHelper.RouteStatistics r : rsr) {
                System.out.println(r);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static void printAdditionalPointInfo(RouteSegmentResult res) {
        boolean plus = res.getStartPointIndex() < res.getEndPointIndex();
        StringBuilder bld = new StringBuilder();
        int k = res.getStartPointIndex();
        while (k != res.getEndPointIndex()) {
            int[] tp = res.getObject().getPointTypes(k);
            String[] pointNames = res.getObject().getPointNames(k);
            int[] pointNameTypes = res.getObject().getPointNameTypes(k);
            if (tp != null || pointNameTypes != null) {
                BinaryMapRouteReaderAdapter.RouteTypeRule rr;
                int t;
                bld.append("<point " + k);
                if (tp != null) {
                    for (t = 0; t < tp.length; ++t) {
                        rr = res.getObject().region.quickGetEncodingRule(tp[t]);
                        bld.append(" " + rr.getTag() + "=\"" + rr.getValue() + "\"");
                    }
                }
                if (pointNameTypes != null) {
                    for (t = 0; t < pointNameTypes.length; ++t) {
                        rr = res.getObject().region.quickGetEncodingRule(pointNameTypes[t]);
                        bld.append(" " + rr.getTag() + "=\"" + pointNames[t] + "\"");
                    }
                }
                bld.append("/> ");
            }
            if (plus) {
                ++k;
                continue;
            }
            --k;
        }
        if (bld.length() > 0) {
            RouteResultPreparation.println("\t" + bld.toString());
        }
    }

    public void addTurnInfoDescriptions(List<RouteSegmentResult> result) {
        int prevSegment = -1;
        float dist = 0.0f;
        for (int i = 0; i <= result.size(); ++i) {
            if (i == result.size() || result.get(i).getTurnType() != null) {
                if (prevSegment >= 0) {
                    RouteSegmentResult turnInfo = result.get(prevSegment);
                    String turn = turnInfo.getTurnType().toString();
                    String mute = turnInfo.getTurnType().isSkipToSpeak() ? "[MUTE] " : "";
                    Object streetName = "";
                    if (prevSegment < result.size() - 1) {
                        String to;
                        String ref;
                        String nm = result.get(prevSegment + 1).getStreetName("", false, result, prevSegment + 1);
                        if (nm == null) {
                            nm = "";
                        }
                        if ((ref = result.get(prevSegment + 1).getRef("", false)) == null) {
                            ref = "";
                        }
                        if (!Algorithms.isEmpty(nm) || !Algorithms.isEmpty(ref)) {
                            streetName = String.format("onto %s %s ", nm, ref);
                        }
                        if (!Algorithms.isEmpty(to = result.get(prevSegment + 1).getDestinationName("", false, result, prevSegment + 1, true))) {
                            streetName = "to " + to;
                        }
                    }
                    turnInfo.setDescription(String.format("%s %s and go %.1f km", mute, turn, (double)dist / 1000.0), String.format("%s %s %s and go %.1f km", mute, turn, streetName, (double)dist / 1000.0));
                }
                prevSegment = i;
                dist = 0.0f;
            }
            if (i >= result.size()) continue;
            dist += result.get(i).getDistance();
        }
    }

    protected TurnType justifyUTurn(boolean leftside, List<RouteSegmentResult> result, int i, TurnType t) {
        TurnType tnext;
        boolean tl = TurnType.isLeftTurnNoUTurn(t.getValue());
        boolean tr = TurnType.isRightTurnNoUTurn(t.getValue());
        if ((tl || tr) && (tnext = result.get(i + 1).getTurnType()) != null && result.get(i).getDistance() < 50.0f) {
            double uTurn;
            boolean ut = true;
            if (i > 0 && Math.abs(uTurn = MapUtils.degreesDiff(result.get(i - 1).getBearingEnd(), result.get(i + 1).getBearingBegin())) < 120.0) {
                ut = false;
            }
            if (result.get(i - 1).getObject().getOneway() == 0 || result.get(i + 1).getObject().getOneway() == 0) {
                ut = false;
            }
            if (!Algorithms.objectEquals(this.getStreetName(result, i - 1, false), this.getStreetName(result, i + 1, true))) {
                ut = false;
            }
            if (ut) {
                tnext.setSkipToSpeak(true);
                if (tl && TurnType.isLeftTurnNoUTurn(tnext.getValue())) {
                    TurnType tt = TurnType.valueOf(10, false);
                    tt.setLanes(t.getLanes());
                    return tt;
                }
                if (tr && TurnType.isRightTurnNoUTurn(tnext.getValue())) {
                    TurnType tt = TurnType.valueOf(10, true);
                    tt.setLanes(t.getLanes());
                    return tt;
                }
            }
        }
        return null;
    }

    private String getStreetName(List<RouteSegmentResult> result, int i, boolean dir) {
        String nm = result.get(i).getObject().getName();
        if (Algorithms.isEmpty(nm)) {
            if (!dir) {
                if (i > 0) {
                    nm = result.get(i - 1).getObject().getName();
                }
            } else if (i < result.size() - 1) {
                nm = result.get(i + 1).getObject().getName();
            }
        }
        return nm;
    }

    private void determineTurnsToMerge(boolean leftside, List<RouteSegmentResult> result) {
        RouteSegmentResult nextSegment = null;
        double dist = 0.0;
        for (int i = result.size() - 1; i >= 0; --i) {
            RouteSegmentResult currentSegment = result.get(i);
            TurnType currentTurn = currentSegment.getTurnType();
            dist += (double)currentSegment.getDistance();
            if (currentTurn == null || currentTurn.getLanes() == null) continue;
            boolean merged = false;
            if (nextSegment != null) {
                String hw = currentSegment.getObject().getHighway();
                double mergeDistance = 200.0;
                if (hw != null && (hw.startsWith("trunk") || hw.startsWith("motorway"))) {
                    mergeDistance = 400.0;
                }
                if (dist < mergeDistance) {
                    this.mergeTurnLanes(leftside, currentSegment, nextSegment);
                    this.inferCommonActiveLane(currentSegment.getTurnType(), nextSegment.getTurnType());
                    merged = true;
                    this.replaceConfusingKeepTurnsWithLaneTurn(currentSegment, leftside);
                }
            }
            if (!merged) {
                TurnType tt = currentSegment.getTurnType();
                this.inferActiveTurnLanesFromTurn(tt, tt.getValue());
            }
            nextSegment = currentSegment;
            dist = 0.0;
        }
    }

    private void replaceConfusingKeepTurnsWithLaneTurn(RouteSegmentResult currentSegment, boolean leftSide) {
        if (currentSegment.getTurnType() == null) {
            return;
        }
        int currentTurn = currentSegment.getTurnType().getValue();
        int activeTurn = currentSegment.getTurnType().getActiveCommonLaneTurn();
        boolean changeToActive = false;
        if (TurnType.isKeepDirectionTurn(currentTurn) && !TurnType.isKeepDirectionTurn(activeTurn)) {
            if (TurnType.isLeftTurn(currentTurn) && !TurnType.isLeftTurn(activeTurn)) {
                changeToActive = true;
            }
            if (TurnType.isRightTurn(currentTurn) && !TurnType.isRightTurn(activeTurn)) {
                changeToActive = true;
            }
        }
        if (changeToActive) {
            TurnType turn = TurnType.valueOf(activeTurn, leftSide);
            turn.setLanes(currentSegment.getTurnType().getLanes());
            currentSegment.setTurnType(turn);
        }
    }

    private void inferActiveTurnLanesFromTurn(TurnType tt, int type) {
        int turn;
        int it;
        boolean found = false;
        if (tt.getValue() == type && tt.getLanes() != null) {
            for (it = 0; it < tt.getLanes().length; ++it) {
                turn = tt.getLanes()[it];
                if (TurnType.getPrimaryTurn(turn) != type && TurnType.getSecondaryTurn(turn) != type && TurnType.getTertiaryTurn(turn) != type) continue;
                found = true;
                break;
            }
        }
        if (found) {
            for (it = 0; it < tt.getLanes().length; ++it) {
                turn = tt.getLanes()[it];
                if (TurnType.getPrimaryTurn(turn) != type) {
                    int st;
                    if (TurnType.getSecondaryTurn(turn) == type) {
                        st = TurnType.getSecondaryTurn(turn);
                        TurnType.setSecondaryTurn(tt.getLanes(), it, TurnType.getPrimaryTurn(turn));
                        TurnType.setPrimaryTurn(tt.getLanes(), it, st);
                        continue;
                    }
                    if (TurnType.getTertiaryTurn(turn) == type) {
                        st = TurnType.getTertiaryTurn(turn);
                        TurnType.setTertiaryTurn(tt.getLanes(), it, TurnType.getPrimaryTurn(turn));
                        TurnType.setPrimaryTurn(tt.getLanes(), it, st);
                        continue;
                    }
                    tt.getLanes()[it] = turn & 0xFFFFFFFE;
                    continue;
                }
                tt.getLanes()[it] = turn | 1;
            }
        }
    }

    private boolean mergeTurnLanes(boolean leftSide, RouteSegmentResult currentSegment, RouteSegmentResult nextSegment) {
        MergeTurnLaneTurn active = new MergeTurnLaneTurn(currentSegment);
        MergeTurnLaneTurn target = new MergeTurnLaneTurn(nextSegment);
        if (active.activeLen < 2) {
            return false;
        }
        if (target.activeStartIndex == -1) {
            return false;
        }
        boolean changed = false;
        if (target.isActiveTurnMostLeft()) {
            if (target.activeLen < active.activeLen) {
                active.activeEndIndex -= active.activeLen - target.activeLen;
                changed = true;
            }
        } else if (target.isActiveTurnMostRight()) {
            if (target.activeLen < active.activeLen) {
                active.activeStartIndex += active.activeLen - target.activeLen;
                changed = true;
            }
        } else if (target.activeLen < active.activeLen) {
            if (target.originalLanes.length == active.activeLen) {
                active.activeEndIndex = active.activeStartIndex + target.activeEndIndex;
                active.activeStartIndex += target.activeStartIndex;
                changed = true;
            } else {
                int straightActiveLen = 0;
                int straightActiveBegin = -1;
                for (int i = active.activeStartIndex; i <= active.activeEndIndex; ++i) {
                    if (!TurnType.hasAnyTurnLane(active.originalLanes[i], 1)) continue;
                    ++straightActiveLen;
                    if (straightActiveBegin != -1) continue;
                    straightActiveBegin = i;
                }
                if (straightActiveBegin != -1 && straightActiveLen <= target.activeLen) {
                    active.activeStartIndex = straightActiveBegin;
                    active.activeEndIndex = straightActiveBegin + straightActiveLen - 1;
                    changed = true;
                } else {
                    float ratio;
                    if (active.activeStartIndex == 0) {
                        ++active.activeStartIndex;
                        --active.activeLen;
                    }
                    if (active.activeEndIndex == active.originalLanes.length - 1) {
                        --active.activeEndIndex;
                        --active.activeLen;
                    }
                    if ((ratio = (float)(active.activeLen - target.activeLen) / 2.0f) > 0.0f) {
                        active.activeEndIndex = (int)Math.ceil((float)active.activeEndIndex - ratio);
                        active.activeStartIndex = (int)Math.floor((float)active.activeStartIndex + ratio);
                    }
                    changed = true;
                }
            }
        }
        if (!changed) {
            return false;
        }
        for (int i = 0; i < active.disabledLanes.length; ++i) {
            if (i < active.activeStartIndex || i > active.activeEndIndex || active.originalLanes[i] % 2 != 1) continue;
            int n = i;
            active.disabledLanes[n] = active.disabledLanes[n] | 1;
        }
        TurnType currentTurn = currentSegment.getTurnType();
        currentTurn.setLanes(active.disabledLanes);
        return true;
    }

    private void inferCommonActiveLane(TurnType currentTurn, TurnType nextTurn) {
        int[] lanes = currentTurn.getLanes();
        TIntHashSet turnSet = new TIntHashSet();
        for (int i = 0; i < lanes.length; ++i) {
            if (lanes[i] % 2 != 1) continue;
            int singleTurn = TurnType.getPrimaryTurn(lanes[i]);
            turnSet.add(singleTurn);
            if (TurnType.getSecondaryTurn(lanes[i]) != 0) {
                turnSet.add(TurnType.getSecondaryTurn(lanes[i]));
            }
            if (TurnType.getTertiaryTurn(lanes[i]) == 0) continue;
            turnSet.add(TurnType.getTertiaryTurn(lanes[i]));
        }
        int singleTurn = 0;
        if (turnSet.size() == 1) {
            singleTurn = turnSet.iterator().next();
        } else if ((currentTurn.goAhead() || currentTurn.keepLeft() || currentTurn.keepRight()) && turnSet.contains(nextTurn.getValue())) {
            int nextTurnLane = nextTurn.getActiveCommonLaneTurn();
            if (currentTurn.isPossibleLeftTurn() && TurnType.isLeftTurn(nextTurn.getValue())) {
                singleTurn = nextTurn.getValue();
            } else if (currentTurn.isPossibleLeftTurn() && TurnType.isLeftTurn(nextTurnLane)) {
                singleTurn = nextTurnLane;
            } else if (currentTurn.isPossibleRightTurn() && TurnType.isRightTurn(nextTurn.getValue())) {
                singleTurn = nextTurn.getValue();
            } else if (currentTurn.isPossibleRightTurn() && TurnType.isRightTurn(nextTurnLane)) {
                singleTurn = nextTurnLane;
            } else if ((currentTurn.goAhead() || currentTurn.keepLeft() || currentTurn.keepRight()) && TurnType.isKeepDirectionTurn(nextTurnLane)) {
                singleTurn = nextTurnLane;
            }
        }
        if (singleTurn == 0 && ((singleTurn = currentTurn.getValue()) == 8 || singleTurn == 9)) {
            return;
        }
        for (int i = 0; i < lanes.length; ++i) {
            if (lanes[i] % 2 != 1 || TurnType.getPrimaryTurn(lanes[i]) == singleTurn) continue;
            if (TurnType.getSecondaryTurn(lanes[i]) == singleTurn) {
                TurnType.setSecondaryTurn(lanes, i, TurnType.getPrimaryTurn(lanes[i]));
                TurnType.setPrimaryTurn(lanes, i, singleTurn);
                continue;
            }
            if (TurnType.getTertiaryTurn(lanes[i]) == singleTurn) {
                TurnType.setTertiaryTurn(lanes, i, TurnType.getPrimaryTurn(lanes[i]));
                TurnType.setPrimaryTurn(lanes, i, singleTurn);
                continue;
            }
            if (lanes.length == 1) {
                return;
            }
            lanes[i] = lanes[i] - 1;
        }
    }

    private int highwaySpeakPriority(String highway) {
        if (highway == null || highway.endsWith("track") || highway.endsWith("services") || highway.endsWith("service") || highway.endsWith("path")) {
            return 5;
        }
        if (highway.endsWith("_link") || highway.endsWith("unclassified") || highway.endsWith("road") || highway.endsWith("living_street") || highway.endsWith("residential")) {
            return 3;
        }
        if (highway.endsWith("tertiary")) {
            return 2;
        }
        if (highway.endsWith("secondary")) {
            return 1;
        }
        return 0;
    }

    private TurnType getTurnInfo(List<RouteSegmentResult> result, int i, boolean leftSide) {
        if (i == 0) {
            return TurnType.valueOf(1, false);
        }
        RoundaboutTurn roundaboutTurn = new RoundaboutTurn(result, i, leftSide);
        if (roundaboutTurn.isRoundaboutExist()) {
            return roundaboutTurn.getRoundaboutType();
        }
        RouteSegmentResult prev = result.get(i - 1);
        RouteSegmentResult rr = result.get(i);
        TurnType t = null;
        if (prev != null) {
            float bearingDist = 15.0f;
            if (UNMATCHED_HIGHWAY_TYPE.equals(rr.getObject().getHighway())) {
                bearingDist = 50.0f;
            }
            double mpi = MapUtils.degreesDiff(prev.getBearingEnd(prev.getEndPointIndex(), Math.min(prev.getDistance(), bearingDist)), rr.getBearingBegin(rr.getStartPointIndex(), Math.min(rr.getDistance(), bearingDist)));
            String turnTag = this.getTurnString(rr);
            boolean twiceRoadPresent = this.twiceRoadPresent(result, i);
            if (turnTag != null) {
                int fromTag = TurnType.convertType(turnTag);
                if (!TurnType.isSlightTurn(fromTag)) {
                    t = TurnType.valueOf(fromTag, leftSide);
                    int[] lanes = this.getTurnLanesInfo(prev, rr, t.getValue());
                    t = this.getActiveTurnType(lanes, leftSide, t);
                    t.setLanes(lanes);
                } else if (fromTag != 1 && (t = this.attachKeepLeftInfoAndLanes(leftSide, prev, rr, twiceRoadPresent)) != null) {
                    TurnType mainTurnType = TurnType.valueOf(fromTag, leftSide);
                    int[] lanes = t.getLanes();
                    t = this.getActiveTurnType(t.getLanes(), leftSide, mainTurnType);
                    t.setLanes(lanes);
                }
                if (t != null) {
                    t.setTurnAngle((float)(-mpi));
                    return t;
                }
            }
            if (mpi >= 45.0) {
                t = mpi < 45.0 ? TurnType.valueOf(3, leftSide) : (mpi < 120.0 ? TurnType.valueOf(2, leftSide) : (mpi < 150.0 || leftSide ? TurnType.valueOf(4, leftSide) : TurnType.valueOf(10, leftSide)));
                int[] lanes = this.getTurnLanesInfo(prev, rr, t.getValue());
                t = this.getActiveTurnType(lanes, leftSide, t);
                t.setLanes(lanes);
            } else if (mpi < -45.0) {
                t = mpi > -45.0 ? TurnType.valueOf(6, leftSide) : (mpi > -120.0 ? TurnType.valueOf(5, leftSide) : (mpi > -150.0 || !leftSide ? TurnType.valueOf(7, leftSide) : TurnType.valueOf(11, leftSide)));
                int[] lanes = this.getTurnLanesInfo(prev, rr, t.getValue());
                t = this.getActiveTurnType(lanes, leftSide, t);
                t.setLanes(lanes);
            } else {
                t = this.attachKeepLeftInfoAndLanes(leftSide, prev, rr, twiceRoadPresent);
            }
            if (t != null) {
                t.setTurnAngle((float)(-mpi));
            }
        }
        return t;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int[] getTurnLanesInfo(RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, int mainTurnType) {
        int[] lanesArray;
        String turnLanes = RouteResultPreparation.getTurnLanesString(prevSegm);
        if (turnLanes == null) {
            if (prevSegm.getTurnType() == null || prevSegm.getTurnType().getLanes() == null || !(prevSegm.getDistance() < 60.0f)) return null;
            int[] lns = prevSegm.getTurnType().getLanes();
            TIntArrayList lst = new TIntArrayList();
            for (int i = 0; i < lns.length; ++i) {
                if (lns[i] % 2 != 1) continue;
                lst.add(lns[i] >> 1 << 1);
            }
            if (lst.isEmpty()) {
                return null;
            }
            lanesArray = lst.toArray();
        } else {
            lanesArray = RouteResultPreparation.calculateRawTurnLanes(turnLanes, mainTurnType);
        }
        boolean isSet = false;
        int[] act = this.findActiveIndex(prevSegm, currentSegm, lanesArray, null, turnLanes);
        int startIndex = act[0];
        int endIndex = act[1];
        if (startIndex != -1 && endIndex != -1 && this.hasAllowedLanes(mainTurnType, lanesArray, startIndex, endIndex)) {
            for (int k = startIndex; k <= endIndex; ++k) {
                int[] oneActiveLane = new int[]{lanesArray[k]};
                if (!this.hasAllowedLanes(mainTurnType, oneActiveLane, 0, 0)) continue;
                int n = k;
                lanesArray[n] = lanesArray[n] | 1;
            }
            isSet = true;
        }
        if (isSet) return lanesArray;
        isSet = this.setAllowedLanes(mainTurnType, lanesArray);
        return lanesArray;
    }

    protected boolean setAllowedLanes(int mainTurnType, int[] lanesArray) {
        boolean turnSet = false;
        for (int i = 0; i < lanesArray.length; ++i) {
            if (TurnType.getPrimaryTurn(lanesArray[i]) != mainTurnType) continue;
            int n = i;
            lanesArray[n] = lanesArray[n] | 1;
            turnSet = true;
        }
        return turnSet;
    }

    private TurnType attachKeepLeftInfoAndLanes(boolean leftSide, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, boolean twiceRoadPresent) {
        List<RouteSegmentResult> attachedRoutes = currentSegm.getAttachedRoutes(currentSegm.getStartPointIndex());
        if (attachedRoutes == null || attachedRoutes.isEmpty()) {
            return null;
        }
        String turnLanesPrevSegm = twiceRoadPresent ? null : RouteResultPreparation.getTurnLanesString(prevSegm);
        RoadSplitStructure rs = this.calculateRoadSplitStructure(prevSegm, currentSegm, attachedRoutes, turnLanesPrevSegm);
        if (rs.roadsOnLeft + rs.roadsOnRight == 0) {
            return null;
        }
        if (turnLanesPrevSegm != null) {
            return this.createKeepLeftRightTurnBasedOnTurnTypes(rs, prevSegm, currentSegm, turnLanesPrevSegm, leftSide);
        }
        if (rs.keepLeft || rs.keepRight) {
            return this.createSimpleKeepLeftRightTurn(leftSide, prevSegm, currentSegm, rs);
        }
        return null;
    }

    protected TurnType createKeepLeftRightTurnBasedOnTurnTypes(RoadSplitStructure rs, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, String turnLanes, boolean leftSide) {
        boolean leftOrRightKeep;
        TurnType t = TurnType.valueOf(1, leftSide);
        int[] rawLanes = RouteResultPreparation.calculateRawTurnLanes(turnLanes, 1);
        boolean possiblyLeftTurn = rs.roadsOnLeft == 0;
        boolean possiblyRightTurn = rs.roadsOnRight == 0;
        for (int k = 0; k < rawLanes.length; ++k) {
            int turn = TurnType.getPrimaryTurn(rawLanes[k]);
            int sturn = TurnType.getSecondaryTurn(rawLanes[k]);
            int tturn = TurnType.getTertiaryTurn(rawLanes[k]);
            if (turn == 10 || sturn == 10 || tturn == 10) {
                possiblyLeftTurn = true;
            }
            if (turn != 11 && sturn != 11 && tturn != 11) continue;
            possiblyRightTurn = true;
        }
        int[] act = this.findActiveIndex(prevSegm, currentSegm, rawLanes, rs, turnLanes);
        int activeBeginIndex = act[0];
        int activeEndIndex = act[1];
        int activeTurn = act[2];
        if (activeBeginIndex == -1 || activeEndIndex == -1 || activeBeginIndex > activeEndIndex) {
            return this.createSimpleKeepLeftRightTurn(leftSide, prevSegm, currentSegm, rs);
        }
        boolean bl = leftOrRightKeep = rs.keepLeft && !rs.keepRight || !rs.keepLeft && rs.keepRight;
        if (leftOrRightKeep) {
            this.setActiveLanesRange(rawLanes, activeBeginIndex, activeEndIndex, activeTurn);
            int tp = this.inferSlightTurnFromActiveLanes(rawLanes, rs.keepLeft, rs.keepRight);
            if (tp != 0) {
                for (int i = 0; i < rawLanes.length; ++i) {
                    if (TurnType.getSecondaryTurn(rawLanes[i]) == tp) {
                        TurnType.setSecondaryToPrimary(rawLanes, i);
                        int n = i;
                        rawLanes[n] = rawLanes[n] | 1;
                        continue;
                    }
                    if (TurnType.getPrimaryTurn(rawLanes[i]) != tp) continue;
                    int n = i;
                    rawLanes[n] = rawLanes[n] | 1;
                }
            }
            if (tp != t.getValue() && tp != 0) {
                t = TurnType.valueOf(tp, leftSide);
            } else if (rs.keepRight && !rs.keepLeft) {
                t = this.getTurnByCurrentTurns(rs.leftLanesInfo, rawLanes, 9, leftSide);
            } else if (rs.keepLeft && !rs.keepRight) {
                t = this.getTurnByCurrentTurns(rs.rightLanesInfo, rawLanes, 8, leftSide);
            }
        } else {
            this.setActiveLanesRange(rawLanes, activeBeginIndex, activeEndIndex, activeTurn);
            t = this.getActiveTurnType(rawLanes, leftSide, t);
        }
        t.setLanes(rawLanes);
        t.setPossibleLeftTurn(possiblyLeftTurn);
        t.setPossibleRightTurn(possiblyRightTurn);
        return t;
    }

    private void setActiveLanesRange(int[] rawLanes, int activeBeginIndex, int activeEndIndex, int activeTurn) {
        int k;
        TreeSet possibleTurns = new TreeSet();
        TreeSet<Integer> upossibleTurns = new TreeSet<Integer>();
        for (k = activeBeginIndex; k < rawLanes.length && k <= activeEndIndex; ++k) {
            int n = k;
            rawLanes[n] = rawLanes[n] | 1;
            upossibleTurns.clear();
            upossibleTurns.add(TurnType.getPrimaryTurn(rawLanes[k]));
            if (TurnType.getSecondaryTurn(rawLanes[k]) != 0) {
                upossibleTurns.add(TurnType.getSecondaryTurn(rawLanes[k]));
            }
            if (TurnType.getTertiaryTurn(rawLanes[k]) != 0) {
                upossibleTurns.add(TurnType.getTertiaryTurn(rawLanes[k]));
            }
            if (k == activeBeginIndex) {
                possibleTurns.addAll(upossibleTurns);
                continue;
            }
            possibleTurns.retainAll(upossibleTurns);
        }
        for (k = activeBeginIndex; k < rawLanes.length && k <= activeEndIndex; ++k) {
            if (TurnType.getPrimaryTurn(rawLanes[k]) == activeTurn) continue;
            if (TurnType.getSecondaryTurn(rawLanes[k]) == activeTurn) {
                TurnType.setSecondaryToPrimary(rawLanes, k);
                continue;
            }
            if (TurnType.getTertiaryTurn(rawLanes[k]) != activeTurn) continue;
            TurnType.setTertiaryToPrimary(rawLanes, k);
        }
    }

    private TurnType getTurnByCurrentTurns(List<RoadSplitStructure.AttachedRoadInfo> otherSideLanesInfo, int[] rawLanes, int keepTurnType, boolean leftSide) {
        LinkedHashSet<Integer> otherSideTurns = new LinkedHashSet<Integer>();
        if (otherSideLanesInfo != null) {
            for (RoadSplitStructure.AttachedRoadInfo attachedRoadInfo : otherSideLanesInfo) {
                if (attachedRoadInfo.parsedLanes == null) continue;
                int[] nArray = attachedRoadInfo.parsedLanes;
                int n = nArray.length;
                for (int i = 0; i < n; ++i) {
                    int i2 = nArray[i];
                    TurnType.collectTurnTypes(i2, otherSideTurns);
                }
            }
        }
        LinkedHashSet<Integer> currentTurns = new LinkedHashSet<Integer>();
        for (int ln : rawLanes) {
            TurnType.collectTurnTypes(ln, currentTurns);
        }
        LinkedList linkedList = new LinkedList(currentTurns);
        if (linkedList.size() > 1) {
            if (keepTurnType == 8) {
                linkedList.remove(0);
            } else if (keepTurnType == 9) {
                linkedList.remove(linkedList.size() - 1);
            }
            if (linkedList.containsAll(otherSideTurns)) {
                currentTurns.removeAll(otherSideTurns);
                if (currentTurns.size() == 1) {
                    return TurnType.valueOf((Integer)currentTurns.iterator().next(), leftSide);
                }
            } else {
                LinkedList<Integer> linkedList2 = new LinkedList<Integer>(currentTurns);
                if (keepTurnType == 8 && linkedList2.get(0) == 1) {
                    return TurnType.valueOf(1, leftSide);
                }
                if (keepTurnType == 9 && linkedList2.get(linkedList2.size() - 1) == 1) {
                    return TurnType.valueOf(1, leftSide);
                }
            }
        }
        return TurnType.valueOf(keepTurnType, leftSide);
    }

    protected RoadSplitStructure calculateRoadSplitStructure(RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, List<RouteSegmentResult> attachedRoutes, String turnLanesPrevSegm) {
        RoadSplitStructure rs = new RoadSplitStructure();
        int speakPriority = Math.max(this.highwaySpeakPriority(prevSegm.getObject().getHighway()), this.highwaySpeakPriority(currentSegm.getObject().getHighway()));
        double currentAngle = MapUtils.normalizeDegrees360(currentSegm.getBearingBegin());
        double prevAngle = MapUtils.normalizeDegrees360(prevSegm.getBearingBegin() - 180.0f);
        boolean hasSharpOrReverseLane = this.hasSharpOrReverseTurnLane(turnLanesPrevSegm);
        boolean hasSameTurnLanes = this.hasSameTurnLanes(prevSegm, currentSegm);
        for (RouteSegmentResult attached : attachedRoutes) {
            boolean restricted = false;
            for (int k = 0; k < prevSegm.getObject().getRestrictionLength(); ++k) {
                if (prevSegm.getObject().getRestrictionId(k) != attached.getObject().getId() || prevSegm.getObject().getRestrictionType(k) > 4) continue;
                restricted = true;
                break;
            }
            if (restricted) continue;
            double ex = MapUtils.degreesDiff(attached.getBearingBegin(), currentSegm.getBearingBegin());
            double deviation = MapUtils.degreesDiff(prevSegm.getBearingEnd(), attached.getBearingBegin());
            double mpi = Math.abs(deviation);
            int lanes = this.countLanesMinOne(attached);
            boolean smallStraightVariation = mpi < 45.0;
            boolean smallTargetVariation = Math.abs(ex) < 45.0;
            boolean verySharpTurn = Math.abs(ex) > 150.0;
            RoadSplitStructure.AttachedRoadInfo ai = new RoadSplitStructure.AttachedRoadInfo();
            ai.speakPriority = this.highwaySpeakPriority(attached.getObject().getHighway());
            ai.attachedOnTheRight = ex >= 0.0;
            ai.attachedAngle = deviation;
            ai.parsedLanes = RouteResultPreparation.parseTurnLanes(attached.getObject(), (double)attached.getBearingBegin() * Math.PI / 180.0);
            ai.lanes = lanes;
            if (!verySharpTurn || hasSharpOrReverseLane) {
                boolean rightSide;
                double attachedAngle = MapUtils.normalizeDegrees360(attached.getBearingBegin());
                if (prevAngle > currentAngle) {
                    rightSide = attachedAngle > currentAngle && attachedAngle < prevAngle;
                } else {
                    boolean leftSide = attachedAngle > prevAngle && attachedAngle < currentAngle;
                    boolean bl = rightSide = !leftSide;
                }
                if (hasSameTurnLanes && !smallTargetVariation && !smallStraightVariation && (rightSide && !this.hasTurn(turnLanesPrevSegm, 5) || !this.hasTurn(turnLanesPrevSegm, 2))) continue;
                if (rightSide) {
                    ++rs.roadsOnRight;
                } else {
                    ++rs.roadsOnLeft;
                }
            }
            if (turnLanesPrevSegm == null && ai.speakPriority == 5 && speakPriority != 5 || !smallTargetVariation && !smallStraightVariation) continue;
            if (ai.attachedOnTheRight) {
                rs.keepLeft = true;
                rs.rightLanes += lanes;
                rs.rightMaxPrio = Math.max(rs.rightMaxPrio, this.highwaySpeakPriority(attached.getObject().getHighway()));
                rs.rightLanesInfo.add(ai);
            } else {
                rs.keepRight = true;
                rs.leftLanes += lanes;
                rs.leftMaxPrio = Math.max(rs.leftMaxPrio, this.highwaySpeakPriority(attached.getObject().getHighway()));
                rs.leftLanesInfo.add(ai);
            }
            rs.speak = rs.speak || ai.speakPriority <= speakPriority;
        }
        return rs;
    }

    protected TurnType createSimpleKeepLeftRightTurn(boolean leftSide, RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, RoadSplitStructure rs) {
        int[] lanes;
        boolean oneLane;
        double deviation = MapUtils.degreesDiff(prevSegm.getBearingEnd(), currentSegm.getBearingBegin());
        boolean makeSlightTurn = Math.abs(deviation) > 5.0;
        TurnType t = null;
        int mainLaneType = 1;
        if (rs.keepLeft || rs.keepRight) {
            if (deviation < -5.0 && makeSlightTurn) {
                t = TurnType.valueOf(6, leftSide);
                mainLaneType = 6;
            } else if (deviation > 5.0 && makeSlightTurn) {
                t = TurnType.valueOf(3, leftSide);
                mainLaneType = 3;
            } else {
                t = rs.keepLeft && rs.keepRight ? TurnType.valueOf(1, leftSide) : TurnType.valueOf(rs.keepLeft ? 8 : 9, leftSide);
            }
        } else {
            return null;
        }
        int currentLanesCount = this.countLanesMinOne(currentSegm);
        int prevLanesCount = this.countLanesMinOne(prevSegm);
        boolean bl = oneLane = currentLanesCount == 1 && prevLanesCount == 1;
        if (oneLane) {
            lanes = this.createCombinedTurnTypeForSingleLane(rs, deviation);
            t.setLanes(lanes);
            int active = t.getActiveCommonLaneTurn();
            if (!(active <= 0 || TurnType.isKeepDirectionTurn(active) && TurnType.isKeepDirectionTurn(t.getValue()))) {
                t = TurnType.valueOf(active, leftSide);
            }
        } else {
            int k;
            lanes = new int[prevLanesCount];
            boolean ltr = rs.leftLanes < rs.rightLanes;
            ArrayList<RoadSplitStructure.AttachedRoadInfo> roads = new ArrayList<RoadSplitStructure.AttachedRoadInfo>();
            RoadSplitStructure.AttachedRoadInfo mainType = new RoadSplitStructure.AttachedRoadInfo();
            mainType.lanes = currentLanesCount;
            mainType.speakPriority = this.highwaySpeakPriority(currentSegm.getObject().getHighway());
            mainType.turnType = mainLaneType;
            roads.add(mainType);
            this.synteticAssignTurnTypes(rs, mainLaneType, roads, true);
            this.synteticAssignTurnTypes(rs, mainLaneType, roads, false);
            Collections.sort(roads, new Comparator<RoadSplitStructure.AttachedRoadInfo>(){

                @Override
                public int compare(RoadSplitStructure.AttachedRoadInfo o1, RoadSplitStructure.AttachedRoadInfo o2) {
                    if (o1.speakPriority == o2.speakPriority) {
                        return -Integer.compare(o1.lanes, o2.lanes);
                    }
                    return -Integer.compare(o1.speakPriority, o2.speakPriority);
                }
            });
            for (RoadSplitStructure.AttachedRoadInfo i : roads) {
                int sumLanes = 0;
                for (RoadSplitStructure.AttachedRoadInfo l : roads) {
                    sumLanes += l.lanes;
                }
                if (sumLanes < 2 * lanes.length) break;
                i.lanes = 1;
            }
            int startActive = Math.max(0, ltr ? 0 : lanes.length - mainType.lanes);
            int endActive = Math.min(lanes.length, startActive + mainType.lanes) - 1;
            for (int i = startActive; i <= endActive; ++i) {
                lanes[i] = (mainType.turnType << 1) + 1;
            }
            int ind = 0;
            for (RoadSplitStructure.AttachedRoadInfo i : rs.leftLanesInfo) {
                for (k = 0; k < i.lanes && ind <= startActive; ++k, ++ind) {
                    if (lanes[ind] == 0) {
                        lanes[ind] = i.turnType << 1;
                        continue;
                    }
                    if (TurnType.getSecondaryTurn(lanes[ind]) == 0) {
                        TurnType.setSecondaryTurn(lanes, ind, i.turnType);
                        continue;
                    }
                    TurnType.setTertiaryTurn(lanes, ind, i.turnType);
                }
            }
            ind = lanes.length - 1;
            for (RoadSplitStructure.AttachedRoadInfo i : rs.rightLanesInfo) {
                for (k = 0; k < i.lanes && ind >= endActive; ++k, --ind) {
                    if (lanes[ind] == 0) {
                        lanes[ind] = i.turnType << 1;
                        continue;
                    }
                    if (TurnType.getSecondaryTurn(lanes[ind]) == 0) {
                        TurnType.setSecondaryTurn(lanes, ind, i.turnType);
                        continue;
                    }
                    TurnType.setTertiaryTurn(lanes, ind, i.turnType);
                }
            }
            for (int i = 0; i < lanes.length; ++i) {
                if (lanes[i] != 0) continue;
                lanes[i] = 2;
            }
        }
        t.setSkipToSpeak(!rs.speak);
        t.setLanes(lanes);
        return t;
    }

    private void synteticAssignTurnTypes(RoadSplitStructure rs, int mainLaneType, List<RoadSplitStructure.AttachedRoadInfo> roads, final boolean left) {
        Comparator<RoadSplitStructure.AttachedRoadInfo> comparatorByAngle = new Comparator<RoadSplitStructure.AttachedRoadInfo>(){

            @Override
            public int compare(RoadSplitStructure.AttachedRoadInfo o1, RoadSplitStructure.AttachedRoadInfo o2) {
                return (left ? 1 : -1) * Double.compare(o1.attachedAngle, o2.attachedAngle);
            }
        };
        List<RoadSplitStructure.AttachedRoadInfo> col = left ? rs.leftLanesInfo : rs.rightLanesInfo;
        Collections.sort(col, comparatorByAngle);
        int type = mainLaneType;
        for (int i = col.size() - 1; i >= 0; --i) {
            RoadSplitStructure.AttachedRoadInfo info = col.get(i);
            int turnByAngle = this.getTurnByAngle(info.attachedAngle);
            type = left && turnByAngle >= type ? TurnType.getPrev(type) : (!left && turnByAngle <= type ? TurnType.getNext(type) : turnByAngle);
            info.turnType = type;
            roads.add(info);
        }
    }

    private int[] createCombinedTurnTypeForSingleLane(RoadSplitStructure rs, double currentDeviation) {
        ArrayList<Double> attachedAngles = new ArrayList<Double>();
        attachedAngles.add(currentDeviation);
        for (RoadSplitStructure.AttachedRoadInfo l : rs.leftLanesInfo) {
            attachedAngles.add(l.attachedAngle);
        }
        for (RoadSplitStructure.AttachedRoadInfo l : rs.rightLanesInfo) {
            attachedAngles.add(l.attachedAngle);
        }
        Collections.sort(attachedAngles, new Comparator<Double>(){

            @Override
            public int compare(Double c1, Double c2) {
                return Double.compare(c2, c1);
            }
        });
        int size = attachedAngles.size();
        boolean allStraight = rs.allAreStraight();
        int[] lanes = new int[1];
        int extraLanes = 0;
        double prevAngle = Double.NaN;
        int prevTurn = 0;
        for (int i = 0; i < size; ++i) {
            int turn;
            double angle = (Double)attachedAngles.get(i);
            if (!Double.isNaN(prevAngle) && angle == prevAngle) continue;
            prevAngle = angle;
            if (allStraight) {
                turn = i == 0 ? 8 : (i == size - 1 ? 9 : 1);
            } else {
                turn = this.getTurnByAngle(angle);
                if (prevTurn > 0 && prevTurn == turn) {
                    turn = TurnType.getNext(turn);
                }
            }
            prevTurn = turn;
            if (angle == currentDeviation) {
                TurnType.setPrimaryTurn(lanes, 0, turn);
                continue;
            }
            if (extraLanes++ == 0) {
                TurnType.setSecondaryTurn(lanes, 0, turn);
                continue;
            }
            TurnType.setTertiaryTurn(lanes, 0, turn);
        }
        lanes[0] = lanes[0] | 1;
        return lanes;
    }

    private int getTurnByAngle(double angle) {
        int turnType = 1;
        turnType = angle < -150.0 ? 11 : (angle < -120.0 ? 7 : (angle < -45.0 ? 5 : (angle <= -5.0 ? 6 : (angle > -5.0 && angle < 5.0 ? 1 : (angle < 45.0 ? 3 : (angle < 120.0 ? 2 : (angle < 150.0 ? 4 : 10)))))));
        return turnType;
    }

    protected int countLanesMinOne(RouteSegmentResult attached) {
        String tls;
        boolean oneway = attached.getObject().getOneway() != 0;
        int lns = attached.getObject().getLanes();
        if (lns == 0 && (tls = RouteResultPreparation.getTurnLanesString(attached)) != null) {
            return Math.max(1, this.countOccurrences(tls, '|'));
        }
        if (oneway) {
            return Math.max(1, lns);
        }
        try {
            if (attached.isForwardDirection() && attached.getObject().getValue("lanes:forward") != null) {
                return Integer.parseInt(attached.getObject().getValue("lanes:forward"));
            }
            if (!attached.isForwardDirection() && attached.getObject().getValue("lanes:backward") != null) {
                return Integer.parseInt(attached.getObject().getValue("lanes:backward"));
            }
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return Math.max(1, (lns + 1) / 2);
    }

    protected static String getTurnLanesString(RouteSegmentResult segment) {
        if (segment.getObject().getOneway() == 0) {
            if (segment.isForwardDirection()) {
                return segment.getObject().getValue("turn:lanes:forward");
            }
            return segment.getObject().getValue("turn:lanes:backward");
        }
        return segment.getObject().getValue("turn:lanes");
    }

    private String getTurnString(RouteSegmentResult segment) {
        return segment.getObject().getValue("turn");
    }

    private int countOccurrences(String haystack, char needle) {
        int count = 0;
        for (int i = 0; i < haystack.length(); ++i) {
            if (haystack.charAt(i) != needle) continue;
            ++count;
        }
        return count;
    }

    public static int[] parseTurnLanes(RouteDataObject ro, double dirToNorthEastPi) {
        double cmp;
        String turnLanes = null;
        turnLanes = ro.getOneway() == 0 ? (Math.abs(MapUtils.alignAngleDifference(dirToNorthEastPi - (cmp = ro.directionRoute(0, true)))) < 1.5707963267948966 ? ro.getValue("turn:lanes:forward") : ro.getValue("turn:lanes:backward")) : ro.getValue("turn:lanes");
        if (turnLanes == null) {
            return null;
        }
        return RouteResultPreparation.calculateRawTurnLanes(turnLanes, 0);
    }

    public static int[] parseLanes(RouteDataObject ro, double dirToNorthEastPi) {
        int lns = 0;
        try {
            if (ro.getOneway() == 0) {
                double cmp = ro.directionRoute(0, true);
                if (Math.abs(MapUtils.alignAngleDifference(dirToNorthEastPi - cmp)) < 1.5707963267948966) {
                    if (ro.getValue("lanes:forward") != null) {
                        lns = Integer.parseInt(ro.getValue("lanes:forward"));
                    }
                } else if (ro.getValue("lanes:backward") != null) {
                    lns = Integer.parseInt(ro.getValue("lanes:backward"));
                }
                if (lns == 0 && ro.getValue("lanes") != null) {
                    lns = Integer.parseInt(ro.getValue("lanes")) / 2;
                }
            } else {
                lns = Integer.parseInt(ro.getValue("lanes"));
            }
            if (lns > 0) {
                return new int[lns];
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static int[] calculateRawTurnLanes(String turnLanes, int calcTurnType) {
        String[] splitLaneOptions = turnLanes.split("\\|", -1);
        int[] lanes = new int[splitLaneOptions.length];
        for (int i = 0; i < splitLaneOptions.length; ++i) {
            String[] laneOptions = splitLaneOptions[i].split(";");
            for (int j = 0; j < laneOptions.length; ++j) {
                int turn = TurnType.convertType(laneOptions[j]);
                int primary = TurnType.getPrimaryTurn(lanes[i]);
                if (primary == 0) {
                    TurnType.setPrimaryTurnAndReset(lanes, i, turn);
                    continue;
                }
                if (turn == calcTurnType || TurnType.isRightTurn(calcTurnType) && TurnType.isRightTurn(turn) || TurnType.isLeftTurn(calcTurnType) && TurnType.isLeftTurn(turn)) {
                    TurnType.setPrimaryTurnShiftOthers(lanes, i, turn);
                    continue;
                }
                if (TurnType.getSecondaryTurn(lanes[i]) == 0) {
                    TurnType.setSecondaryTurn(lanes, i, turn);
                    continue;
                }
                if (TurnType.getTertiaryTurn(lanes[i]) != 0) continue;
                TurnType.setTertiaryTurn(lanes, i, turn);
            }
        }
        return lanes;
    }

    private int inferSlightTurnFromActiveLanes(int[] oLanes, boolean mostLeft, boolean mostRight) {
        Integer[] possibleTurns = this.getPossibleTurns(oLanes, false, false);
        if (possibleTurns.length == 0) {
            return 0;
        }
        int infer = 0;
        if (possibleTurns.length == 1) {
            infer = possibleTurns[0];
        } else if (possibleTurns.length == 2) {
            infer = mostLeft && !mostRight ? possibleTurns[0] : (mostRight && !mostLeft ? possibleTurns[possibleTurns.length - 1].intValue() : possibleTurns[1].intValue());
        }
        return infer;
    }

    private Integer[] getPossibleTurns(int[] oLanes, boolean onlyPrimary, boolean uniqueFromActive) {
        int i;
        LinkedHashSet possibleTurns = new LinkedHashSet();
        LinkedHashSet<Integer> upossibleTurns = new LinkedHashSet<Integer>();
        for (i = 0; i < oLanes.length; ++i) {
            upossibleTurns.clear();
            upossibleTurns.add(TurnType.getPrimaryTurn(oLanes[i]));
            if (!onlyPrimary && TurnType.getSecondaryTurn(oLanes[i]) != 0) {
                upossibleTurns.add(TurnType.getSecondaryTurn(oLanes[i]));
            }
            if (!onlyPrimary && TurnType.getTertiaryTurn(oLanes[i]) != 0) {
                upossibleTurns.add(TurnType.getTertiaryTurn(oLanes[i]));
            }
            if (!uniqueFromActive) {
                possibleTurns.addAll(upossibleTurns);
                continue;
            }
            if ((oLanes[i] & 1) != 1) continue;
            if (!possibleTurns.isEmpty()) {
                possibleTurns.retainAll(upossibleTurns);
                if (!possibleTurns.isEmpty()) continue;
                break;
            }
            possibleTurns.addAll(upossibleTurns);
        }
        if (uniqueFromActive) {
            for (i = 0; i < oLanes.length; ++i) {
                if ((oLanes[i] & 1) != 0) continue;
                possibleTurns.remove(TurnType.getPrimaryTurn(oLanes[i]));
                if (TurnType.getSecondaryTurn(oLanes[i]) != 0) {
                    possibleTurns.remove(TurnType.getSecondaryTurn(oLanes[i]));
                }
                if (TurnType.getTertiaryTurn(oLanes[i]) == 0) continue;
                possibleTurns.remove(TurnType.getTertiaryTurn(oLanes[i]));
            }
        }
        Integer[] array = possibleTurns.toArray(new Integer[0]);
        Arrays.sort(array, new Comparator<Integer>(){

            @Override
            public int compare(Integer o1, Integer o2) {
                return Integer.compare(TurnType.orderFromLeftToRight(o1), TurnType.orderFromLeftToRight(o2));
            }
        });
        return array;
    }

    private boolean isMotorway(RouteSegmentResult s) {
        String h = s.getObject().getHighway();
        return "motorway".equals(h) || "motorway_link".equals(h) || "trunk".equals(h) || "trunk_link".equals(h);
    }

    private void attachRoadSegments(RoutingContext ctx, List<RouteSegmentResult> result, int routeInd, int pointInd, boolean plus) throws IOException {
        Iterator<BinaryRoutePlanner.RouteSegment> it;
        RouteSegmentResult rr = result.get(routeInd);
        RouteDataObject road = rr.getObject();
        long nextL = pointInd < road.getPointsLength() - 1 ? this.getPoint(road, pointInd + 1) : 0L;
        long prevL = pointInd > 0 ? this.getPoint(road, pointInd - 1) : 0L;
        RouteSegmentResult previousResult = null;
        long previousRoadId = road.getId();
        if (pointInd == rr.getStartPointIndex() && routeInd > 0 && (previousRoadId = (previousResult = result.get(routeInd - 1)).getObject().getId()) != road.getId()) {
            if (previousResult.getStartPointIndex() < previousResult.getEndPointIndex() && previousResult.getEndPointIndex() < previousResult.getObject().getPointsLength() - 1) {
                rr.attachRoute(pointInd, new RouteSegmentResult(previousResult.getObject(), previousResult.getEndPointIndex(), previousResult.getObject().getPointsLength() - 1));
            } else if (previousResult.getStartPointIndex() > previousResult.getEndPointIndex() && previousResult.getEndPointIndex() > 0) {
                rr.attachRoute(pointInd, new RouteSegmentResult(previousResult.getObject(), previousResult.getEndPointIndex(), 0));
            }
        }
        if (rr.getPreAttachedRoutes(pointInd) != null) {
            final RouteSegmentResult[] list = rr.getPreAttachedRoutes(pointInd);
            it = new Iterator<BinaryRoutePlanner.RouteSegment>(){
                int i = 0;

                @Override
                public boolean hasNext() {
                    return this.i < list.length;
                }

                @Override
                public BinaryRoutePlanner.RouteSegment next() {
                    RouteSegmentResult r = list[this.i++];
                    return new BinaryRoutePlanner.RouteSegment(r.getObject(), r.getStartPointIndex(), r.getEndPointIndex());
                }

                @Override
                public void remove() {
                }
            };
        } else {
            BinaryRoutePlanner.RouteSegment rt;
            it = ctx.nativeLib == null ? ((rt = ctx.loadRouteSegment(road.getPoint31XTile(pointInd), road.getPoint31YTile(pointInd), ctx.config.memoryLimitation)) == null ? null : rt.getIterator()) : null;
        }
        while (it != null && it.hasNext()) {
            long pointL;
            BinaryRoutePlanner.RouteSegment routeSegment = (BinaryRoutePlanner.RouteSegment)it.next();
            if (routeSegment.road.getId() == road.getId() || routeSegment.road.getId() == previousRoadId) continue;
            RouteDataObject addRoad = routeSegment.road;
            this.checkAndInitRouteRegion(ctx, addRoad);
            int oneWay = ctx.getRouter().isOneWay(addRoad);
            if (oneWay >= 0 && routeSegment.getSegmentStart() < addRoad.getPointsLength() - 1 && (pointL = this.getPoint(addRoad, routeSegment.getSegmentStart() + 1)) != nextL && pointL != prevL) {
                rr.attachRoute(pointInd, new RouteSegmentResult(addRoad, routeSegment.getSegmentStart(), addRoad.getPointsLength() - 1));
            }
            if (oneWay > 0 || routeSegment.getSegmentStart() <= 0 || (pointL = this.getPoint(addRoad, routeSegment.getSegmentStart() - 1)) == nextL || pointL == prevL) continue;
            rr.attachRoute(pointInd, new RouteSegmentResult(addRoad, routeSegment.getSegmentStart(), 0));
        }
    }

    private static void println(String logMsg) {
        System.out.println(logMsg);
    }

    private long getPoint(RouteDataObject road, int pointInd) {
        return ((long)road.getPoint31XTile(pointInd) << 31) + (long)road.getPoint31YTile(pointInd);
    }

    private static double measuredDist(int x1, int y1, int x2, int y2) {
        return MapUtils.getDistance(MapUtils.get31LatitudeY(y1), MapUtils.get31LongitudeX(x1), MapUtils.get31LatitudeY(y2), MapUtils.get31LongitudeX(x2));
    }

    private void avoidKeepForThroughMoving(List<RouteSegmentResult> result) {
        for (int i = 1; i < result.size(); ++i) {
            RouteSegmentResult curr = result.get(i);
            TurnType turnType = curr.getTurnType();
            if (turnType == null || !turnType.keepLeft() && !turnType.keepRight() || this.isSwitchToLink(curr, result.get(i - 1)) || this.isKeepTurn(turnType) && this.isHighSpeakPriority(curr) || this.isForkByLanes(curr, result.get(i - 1))) continue;
            int cnt = turnType.countTurnTypeDirections(1, true);
            int cntAll = turnType.countTurnTypeDirections(1, false);
            if (cnt <= 0 || cnt != cntAll) continue;
            TurnType newTurnType = new TurnType(1, turnType.getExitOut(), turnType.getTurnAngle(), turnType.isSkipToSpeak(), turnType.getLanes(), turnType.isPossibleLeftTurn(), turnType.isPossibleRightTurn());
            curr.setTurnType(newTurnType);
        }
    }

    private void muteAndRemoveTurns(List<RouteSegmentResult> result, RoutingContext ctx) {
        for (int i = 0; i < result.size(); ++i) {
            int uniqDirections;
            int active;
            RouteSegmentResult curr = result.get(i);
            TurnType turnType = curr.getTurnType();
            if (turnType == null || turnType.getLanes() == null || !TurnType.isKeepDirectionTurn(active = turnType.getActiveCommonLaneTurn()) || i > 0 && this.isSwitchToLink(curr, result.get(i - 1)) || this.isKeepTurn(turnType) && this.isHighSpeakPriority(curr)) continue;
            turnType.setSkipToSpeak(true);
            if (ctx.config.showMinorTurns || !turnType.goAhead() || (uniqDirections = turnType.countDirections()) >= 3) continue;
            int cnt = turnType.countTurnTypeDirections(1, true);
            int cntAll = turnType.countTurnTypeDirections(1, false);
            int lanesCnt = turnType.getLanes().length;
            if (cnt != cntAll || cnt < 2 || lanesCnt - cnt > 1) continue;
            curr.setTurnType(null);
        }
    }

    private int[] getUniqTurnTypes(String turnLanes) {
        LinkedHashSet<Integer> turnTypes = new LinkedHashSet<Integer>();
        String[] splitLaneOptions = turnLanes.split("\\|", -1);
        for (int i = 0; i < splitLaneOptions.length; ++i) {
            String[] laneOptions = splitLaneOptions[i].split(";");
            for (int j = 0; j < laneOptions.length; ++j) {
                int turn = TurnType.convertType(laneOptions[j]);
                turnTypes.add(turn);
            }
        }
        Iterator it = turnTypes.iterator();
        int[] r = new int[turnTypes.size()];
        int i = 0;
        while (it.hasNext()) {
            r[i++] = (Integer)it.next();
        }
        return r;
    }

    private int[] findActiveIndex(RouteSegmentResult prevSegm, RouteSegmentResult currentSegm, int[] rawLanes, RoadSplitStructure rs, String turnLanes) {
        List<RouteSegmentResult> attachedRoutes;
        int[] pair = new int[]{-1, -1, 0};
        if (turnLanes == null) {
            return pair;
        }
        if (rs == null && !Algorithms.isEmpty(attachedRoutes = currentSegm.getAttachedRoutes(currentSegm.getStartPointIndex()))) {
            rs = this.calculateRoadSplitStructure(prevSegm, currentSegm, attachedRoutes, turnLanes);
        }
        if (rs == null) {
            return pair;
        }
        int[] directions = this.getUniqTurnTypes(turnLanes);
        if (rs.roadsOnLeft + rs.roadsOnRight < directions.length) {
            int t;
            int s;
            int p;
            int i;
            int startDirection = directions[rs.roadsOnLeft];
            int endDirection = directions[directions.length - rs.roadsOnRight - 1];
            for (i = 0; i < rawLanes.length; ++i) {
                p = TurnType.getPrimaryTurn(rawLanes[i]);
                s = TurnType.getSecondaryTurn(rawLanes[i]);
                t = TurnType.getTertiaryTurn(rawLanes[i]);
                if (p != startDirection && s != startDirection && t != startDirection) continue;
                pair[0] = i;
                pair[2] = startDirection;
                break;
            }
            for (i = rawLanes.length - 1; i >= 0; --i) {
                p = TurnType.getPrimaryTurn(rawLanes[i]);
                s = TurnType.getSecondaryTurn(rawLanes[i]);
                t = TurnType.getTertiaryTurn(rawLanes[i]);
                if (p != endDirection && s != endDirection && t != endDirection) continue;
                pair[1] = i;
                break;
            }
        }
        return pair;
    }

    private boolean hasTurn(String turnLanes, int turnType) {
        int[] uniqTurnTypes;
        if (turnLanes == null) {
            return false;
        }
        for (int lane : uniqTurnTypes = this.getUniqTurnTypes(turnLanes)) {
            if (lane != turnType) continue;
            return true;
        }
        return false;
    }

    private boolean hasSharpOrReverseTurnLane(String turnLanesPrevSegm) {
        int[] uniqTurnTypes;
        if (turnLanesPrevSegm == null) {
            return false;
        }
        for (int lane : uniqTurnTypes = this.getUniqTurnTypes(turnLanesPrevSegm)) {
            if (!TurnType.isSharpOrReverse(lane)) continue;
            return true;
        }
        return false;
    }

    private boolean hasSameTurnLanes(RouteSegmentResult prevSegm, RouteSegmentResult currentSegm) {
        int[] uniqCurr;
        String turnLanesPrevSegm = RouteResultPreparation.getTurnLanesString(prevSegm);
        String turnLanesCurrSegm = RouteResultPreparation.getTurnLanesString(currentSegm);
        if (turnLanesPrevSegm == null || turnLanesCurrSegm == null) {
            return false;
        }
        int[] uniqPrev = this.getUniqTurnTypes(turnLanesPrevSegm);
        if (uniqPrev.length != (uniqCurr = this.getUniqTurnTypes(turnLanesCurrSegm)).length) {
            return false;
        }
        for (int i = 0; i < uniqCurr.length; ++i) {
            if (uniqPrev[i] == uniqCurr[i]) continue;
            return false;
        }
        return true;
    }

    private boolean hasAllowedLanes(int mainTurnType, int[] lanesArray, int startActiveIndex, int endActiveIndex) {
        if (lanesArray.length == 0 || startActiveIndex > endActiveIndex) {
            return false;
        }
        int[] activeLines = new int[endActiveIndex - startActiveIndex + 1];
        int i = startActiveIndex;
        int j = 0;
        while (i <= endActiveIndex) {
            activeLines[j] = lanesArray[i];
            ++i;
            ++j;
        }
        boolean possibleSharpLeftOrUTurn = startActiveIndex == 0;
        boolean possibleSharpRightOrUTurn = endActiveIndex == lanesArray.length - 1;
        for (int i2 = 0; i2 < activeLines.length; ++i2) {
            int turnType = TurnType.getPrimaryTurn(activeLines[i2]);
            if (turnType == mainTurnType) {
                return true;
            }
            if (TurnType.isLeftTurnNoUTurn(mainTurnType) && TurnType.isLeftTurnNoUTurn(turnType)) {
                return true;
            }
            if (TurnType.isRightTurnNoUTurn(mainTurnType) && TurnType.isRightTurnNoUTurn(turnType)) {
                return true;
            }
            if (mainTurnType == 1 && TurnType.isSlightTurn(turnType)) {
                return true;
            }
            if (possibleSharpLeftOrUTurn && TurnType.isSharpLeftOrUTurn(mainTurnType) && TurnType.isSharpLeftOrUTurn(turnType)) {
                return true;
            }
            if (!possibleSharpRightOrUTurn || !TurnType.isSharpRightOrUTurn(mainTurnType) || !TurnType.isSharpRightOrUTurn(turnType)) continue;
            return true;
        }
        return false;
    }

    private TurnType getActiveTurnType(int[] lanes, boolean leftSide, TurnType oldTurnType) {
        if (lanes == null || lanes.length == 0) {
            return oldTurnType;
        }
        int tp = oldTurnType.getValue();
        int cnt = 0;
        for (int k = 0; k < lanes.length; ++k) {
            int ln = lanes[k];
            if ((ln & 1) <= 0) continue;
            int[] oneActiveLane = new int[]{lanes[k]};
            if (this.hasAllowedLanes(oldTurnType.getValue(), oneActiveLane, 0, 0)) {
                tp = TurnType.getPrimaryTurn(lanes[k]);
            }
            ++cnt;
        }
        TurnType t = TurnType.valueOf(tp, leftSide);
        if (cnt >= 3 && TurnType.isSlightTurn(t.getValue())) {
            t.setSkipToSpeak(true);
        }
        return t;
    }

    private boolean isHighSpeakPriority(RouteSegmentResult curr) {
        List<RouteSegmentResult> attachedRoutes = curr.getAttachedRoutes(curr.getStartPointIndex());
        String h = curr.getObject().getHighway();
        for (RouteSegmentResult attach : attachedRoutes) {
            String c = attach.getObject().getHighway();
            if (this.highwaySpeakPriority(h) < this.highwaySpeakPriority(c)) continue;
            return true;
        }
        return false;
    }

    private boolean isForkByLanes(RouteSegmentResult curr, RouteSegmentResult prev) {
        List<RouteSegmentResult> attachedRoutes;
        if (this.countLanesMinOne(curr) < this.countLanesMinOne(prev) && (attachedRoutes = curr.getAttachedRoutes(curr.getStartPointIndex())).size() == 1) {
            return this.countLanesMinOne(attachedRoutes.get(0)) >= 2;
        }
        return false;
    }

    private boolean isKeepTurn(TurnType t) {
        return t.keepRight() || t.keepLeft();
    }

    private boolean isSwitchToLink(RouteSegmentResult curr, RouteSegmentResult prev) {
        String c = curr.getObject().getHighway();
        String p = prev.getObject().getHighway();
        return c != null && c.contains("_link") && p != null && !p.contains("_link");
    }

    private boolean twiceRoadPresent(List<RouteSegmentResult> result, int i) {
        if (i > 0 && i < result.size() - 1) {
            RouteSegmentResult prev = result.get(i - 1);
            String turnLanes = RouteResultPreparation.getTurnLanesString(prev);
            if (turnLanes == null) {
                return false;
            }
            RouteSegmentResult curr = result.get(i);
            RouteSegmentResult next = result.get(i + 1);
            if (prev.getObject().getId() == curr.getObject().getId()) {
                List<RouteSegmentResult> attachedRoutes = next.getAttachedRoutes(next.getStartPointIndex());
                return !Algorithms.isEmpty(attachedRoutes);
            }
            List<RouteSegmentResult> attachedRoutes = curr.getAttachedRoutes(curr.getStartPointIndex());
            for (RouteSegmentResult attach : attachedRoutes) {
                if (attach.getObject().getId() != prev.getObject().getId()) continue;
                return true;
            }
        }
        return false;
    }

    private static class CombineAreaRoutePoint {
        int x31;
        int y31;
        int originalIndex;

        private CombineAreaRoutePoint() {
        }
    }

    public static class RouteCalcResult {
        List<RouteSegmentResult> detailed = new ArrayList<RouteSegmentResult>();
        String error = null;

        public RouteCalcResult(List<RouteSegmentResult> list) {
            if (list == null) {
                this.error = "Result is empty";
            } else {
                this.detailed = list;
            }
        }

        public RouteCalcResult(String error) {
            this.error = error;
        }

        public List<RouteSegmentResult> getList() {
            return this.detailed;
        }

        public String getError() {
            return this.error;
        }

        public boolean isCorrect() {
            return this.error == null && !this.detailed.isEmpty();
        }
    }

    private class MergeTurnLaneTurn {
        TurnType turn;
        int[] originalLanes;
        int[] disabledLanes;
        int activeStartIndex = -1;
        int activeEndIndex = -1;
        int activeLen = 0;

        public MergeTurnLaneTurn(RouteSegmentResult segment) {
            this.turn = segment.getTurnType();
            if (this.turn != null) {
                this.originalLanes = this.turn.getLanes();
            }
            if (this.originalLanes != null) {
                this.disabledLanes = new int[this.originalLanes.length];
                for (int i = 0; i < this.originalLanes.length; ++i) {
                    int ln = this.originalLanes[i];
                    this.disabledLanes[i] = ln & 0xFFFFFFFE;
                    if ((ln & 1) <= 0) continue;
                    if (this.activeStartIndex == -1) {
                        this.activeStartIndex = i;
                    }
                    this.activeEndIndex = i;
                    ++this.activeLen;
                }
            }
        }

        public boolean isActiveTurnMostLeft() {
            return this.activeStartIndex == 0;
        }

        public boolean isActiveTurnMostRight() {
            return this.activeEndIndex == this.originalLanes.length - 1;
        }
    }
}

