/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.osmand.CollatorStringMatcher;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.CommonWords;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.Street;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class GeocodingUtilities {
    private static final Log log = PlatformUtil.getLog(GeocodingUtilities.class);
    public static final float THRESHOLD_MULTIPLIER_SKIP_STREETS_AFTER = 5.0f;
    public static final float STOP_SEARCHING_STREET_WITH_MULTIPLIER_RADIUS = 250.0f;
    public static final float STOP_SEARCHING_STREET_WITHOUT_MULTIPLIER_RADIUS = 400.0f;
    public static final int DISTANCE_STREET_NAME_PROXIMITY_BY_NAME = 45000;
    public static final float DISTANCE_STREET_FROM_CLOSEST_WITH_SAME_NAME = 1000.0f;
    public static final float THRESHOLD_MULTIPLIER_SKIP_BUILDINGS_AFTER = 1.5f;
    public static final float DISTANCE_BUILDING_PROXIMITY = 100.0f;
    public static final Comparator<GeocodingResult> DISTANCE_COMPARATOR = new Comparator<GeocodingResult>(){

        @Override
        public int compare(GeocodingResult o1, GeocodingResult o2) {
            if ((int)o1.getDistance() == (int)o2.getDistance()) {
                return Double.compare(o1.getCityDistance(), o2.getCityDistance());
            }
            return Double.compare(o1.getDistance(), o2.getDistance());
        }
    };

    public List<GeocodingResult> reverseGeocodingSearch(RoutingContext ctx, double lat, double lon, boolean allowEmptyNames) throws IOException {
        RoutePlannerFrontEnd rp = new RoutePlannerFrontEnd();
        ArrayList<GeocodingResult> lst = new ArrayList<GeocodingResult>();
        ArrayList<BinaryRoutePlanner.RouteSegmentPoint> listR = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
        rp.findRouteSegment(lat, lon, ctx, listR, false, true);
        double distSquare = 0.0;
        HashMap streetNames = new HashMap();
        for (BinaryRoutePlanner.RouteSegmentPoint p : listR) {
            String name;
            RouteDataObject road = p.getRoad();
            String string = name = Algorithms.isEmpty(road.getName()) ? road.getRef("", false, true) : road.getName();
            if (allowEmptyNames || !Algorithms.isEmpty(name)) {
                if (distSquare == 0.0 || distSquare > p.distToProj) {
                    distSquare = p.distToProj;
                }
                GeocodingResult sr = new GeocodingResult();
                sr.searchPoint = new LatLon(lat, lon);
                sr.streetName = name == null ? "" : name;
                sr.point = p;
                sr.connectionPoint = new LatLon(MapUtils.get31LatitudeY(p.preciseY), MapUtils.get31LongitudeX(p.preciseX));
                sr.regionFP = road.region.getFilePointer();
                sr.regionLen = road.region.getLength();
                ArrayList<BinaryMapRouteReaderAdapter.RouteRegion> plst = (ArrayList<BinaryMapRouteReaderAdapter.RouteRegion>)streetNames.get(sr.streetName);
                if (plst == null) {
                    plst = new ArrayList<BinaryMapRouteReaderAdapter.RouteRegion>();
                    streetNames.put(sr.streetName, plst);
                }
                if (!plst.contains(road.region)) {
                    plst.add(road.region);
                    lst.add(sr);
                }
            }
            if (!(p.distToProj > 62500.0 && distSquare != 0.0 && p.distToProj > 5.0 * distSquare) && !(p.distToProj > 160000.0)) continue;
            break;
        }
        Collections.sort(lst, DISTANCE_COMPARATOR);
        return lst;
    }

    public List<String> prepareStreetName(String s, boolean addCommonWords) {
        ArrayList<String> ls = new ArrayList<String>();
        int beginning = 0;
        block0: for (int i = 1; i < s.length(); ++i) {
            if (Character.isWhitespace(s.charAt(i)) || s.charAt(i) == '-') {
                this.addWord(ls, s.substring(beginning, i), addCommonWords);
                beginning = i + 1;
                continue;
            }
            if (s.charAt(i) != '(') continue;
            this.addWord(ls, s.substring(beginning, i), addCommonWords);
            while (i < s.length()) {
                char c = s.charAt(i);
                beginning = ++i;
                if (c != ')') continue;
                continue block0;
            }
        }
        if (beginning < s.length()) {
            String lastWord = s.substring(beginning, s.length());
            this.addWord(ls, lastWord, addCommonWords);
        }
        Collections.sort(ls, Collator.getInstance());
        return ls;
    }

    private void addWord(List<String> ls, String word, boolean addCommonWords) {
        String w = word.trim().toLowerCase();
        if (!Algorithms.isEmpty(w)) {
            if (!addCommonWords && CommonWords.getCommonGeocoding(w) != -1) {
                return;
            }
            ls.add(w);
        }
    }

    public List<GeocodingResult> justifyReverseGeocodingSearch(final GeocodingResult road, BinaryMapIndexReader reader, double knownMinBuildingDistance, final ResultMatcher<GeocodingResult> result) throws IOException {
        final ArrayList streetsList = new ArrayList();
        boolean addCommonWords = false;
        List<String> streetNamesUsed = this.prepareStreetName(road.streetName, addCommonWords);
        if (streetNamesUsed.size() == 0) {
            addCommonWords = true;
            streetNamesUsed = this.prepareStreetName(road.streetName, addCommonWords);
        }
        final boolean addCommonWordsFinal = addCommonWords;
        final List<String> streetNamesUsedFinal = streetNamesUsed;
        if (streetNamesUsedFinal.size() > 0) {
            String mainWord = "";
            for (int i = 0; i < streetNamesUsedFinal.size(); ++i) {
                String s = streetNamesUsedFinal.get(i);
                if (s.length() <= mainWord.length()) continue;
                mainWord = s;
            }
            BinaryMapIndexReader.SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(new ResultMatcher<MapObject>(){

                @Override
                public boolean publish(MapObject object) {
                    if (object instanceof Street && GeocodingUtilities.this.prepareStreetName(object.getName(), addCommonWordsFinal).equals(streetNamesUsedFinal)) {
                        double d = MapUtils.getDistance(object.getLocation(), road.searchPoint.getLatitude(), road.searchPoint.getLongitude());
                        if (d < 45000.0) {
                            GeocodingResult rs = new GeocodingResult(road);
                            rs.street = (Street)object;
                            rs.connectionPoint = rs.street.getLocation();
                            rs.city = rs.street.getCity();
                            rs.dist = d;
                            streetsList.add(rs);
                            return true;
                        }
                        return false;
                    }
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return result != null && result.isCancelled();
                }
            }, mainWord, CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE);
            req.setBBoxRadius(road.getLocation().getLatitude(), road.getLocation().getLongitude(), 45000);
            reader.searchAddressDataByName(req);
        }
        ArrayList<GeocodingResult> res = new ArrayList<GeocodingResult>();
        if (streetsList.size() == 0) {
            res.add(road);
        } else {
            Collections.sort(streetsList, DISTANCE_COMPARATOR);
            double streetDistance = 0.0;
            boolean isBuildingFound = knownMinBuildingDistance > 0.0;
            for (GeocodingResult street : streetsList) {
                if (streetDistance == 0.0) {
                    streetDistance = street.getDistance();
                } else if (isBuildingFound && street.getDistance() > streetDistance + 1000.0) continue;
                street.resetDistance();
                street.connectionPoint = road.connectionPoint;
                List<GeocodingResult> streetBuildings = this.loadStreetBuildings(road, reader, street);
                Collections.sort(streetBuildings, DISTANCE_COMPARATOR);
                if (streetBuildings.size() > 0) {
                    GeocodingResult nextBld;
                    Iterator<GeocodingResult> it = streetBuildings.iterator();
                    if (knownMinBuildingDistance == 0.0) {
                        GeocodingResult firstBld = it.next();
                        knownMinBuildingDistance = firstBld.getDistance();
                        isBuildingFound = true;
                        res.add(firstBld);
                    }
                    while (it.hasNext() && !((nextBld = it.next()).getDistance() > knownMinBuildingDistance * 1.5)) {
                        res.add(nextBld);
                    }
                }
                res.add(street);
            }
        }
        Collections.sort(res, DISTANCE_COMPARATOR);
        return res;
    }

    public void filterDuplicateRegionResults(List<GeocodingResult> res) {
        Collections.sort(res, DISTANCE_COMPARATOR);
        int i = 0;
        while (i < res.size() - 1) {
            int cmp = this.cmpResult(res.get(i), res.get(i + 1));
            if (cmp > 0) {
                res.remove(i);
                continue;
            }
            if (cmp < 0) {
                res.remove(i + 1);
                continue;
            }
            ++i;
        }
    }

    private int cmpResult(GeocodingResult gr1, GeocodingResult gr2) {
        boolean eqStreet = Algorithms.stringsEqual(gr1.streetName, gr2.streetName);
        if (eqStreet) {
            boolean sameObj = false;
            if (gr1.city != null && gr2.city != null) {
                if (gr1.building != null && gr2.building != null) {
                    if (Algorithms.stringsEqual(gr1.building.getName(), gr2.building.getName())) {
                        sameObj = true;
                    }
                } else if (gr1.building == null && gr2.building == null) {
                    sameObj = true;
                }
            }
            if (sameObj) {
                double cityDist2;
                double cityDist1 = MapUtils.getDistance(gr1.searchPoint, gr1.city.getLocation());
                if (cityDist1 < (cityDist2 = MapUtils.getDistance(gr2.searchPoint, gr2.city.getLocation()))) {
                    return -1;
                }
                return 1;
            }
        }
        return 0;
    }

    private List<GeocodingResult> loadStreetBuildings(GeocodingResult road, BinaryMapIndexReader reader, GeocodingResult street) throws IOException {
        ArrayList<GeocodingResult> streetBuildings = new ArrayList<GeocodingResult>();
        reader.preloadBuildings(street.street, null);
        for (Building b : street.street.getBuildings()) {
            if (b.getLatLon2() != null) {
                double plon;
                double slat = b.getLocation().getLatitude();
                double slon = b.getLocation().getLongitude();
                double tolat = b.getLatLon2().getLatitude();
                double tolon = b.getLatLon2().getLongitude();
                double coeff = MapUtils.getProjectionCoeff(road.searchPoint.getLatitude(), road.searchPoint.getLongitude(), slat, slon, tolat, tolon);
                double plat = slat + (tolat - slat) * coeff;
                if (!(MapUtils.getDistance(road.searchPoint, plat, plon = slon + (tolon - slon) * coeff) < 100.0)) continue;
                GeocodingResult bld = new GeocodingResult(street);
                bld.building = b;
                bld.connectionPoint = new LatLon(plat, plon);
                streetBuildings.add(bld);
                String nm = b.getInterpolationName(coeff);
                if (Algorithms.isEmpty(nm)) continue;
                bld.buildingInterpolation = nm;
                continue;
            }
            if (!(MapUtils.getDistance(b.getLocation(), road.searchPoint) < 100.0)) continue;
            GeocodingResult bld = new GeocodingResult(street);
            bld.building = b;
            bld.connectionPoint = b.getLocation();
            streetBuildings.add(bld);
        }
        return streetBuildings;
    }

    public List<GeocodingResult> sortGeocodingResults(List<BinaryMapIndexReader> list, List<GeocodingResult> res) throws IOException {
        ArrayList<GeocodingResult> complete = new ArrayList<GeocodingResult>();
        double minBuildingDistance = 0.0;
        for (GeocodingResult r : res) {
            BinaryMapIndexReader reader = null;
            for (BinaryMapIndexReader b : list) {
                for (BinaryMapRouteReaderAdapter.RouteRegion rb : b.getRoutingIndexes()) {
                    if (r.regionFP != rb.getFilePointer() || r.regionLen != rb.getLength()) continue;
                    reader = b;
                    break;
                }
                if (reader == null) continue;
                break;
            }
            if (reader != null) {
                List<GeocodingResult> justified = this.justifyReverseGeocodingSearch(r, reader, minBuildingDistance, null);
                if (justified.isEmpty()) continue;
                double md = justified.get(0).getDistance();
                minBuildingDistance = minBuildingDistance == 0.0 ? md : Math.min(md, minBuildingDistance);
                justified.get((int)0).dist = -1.0;
                complete.addAll(justified);
                continue;
            }
            complete.add(r);
        }
        this.filterDuplicateRegionResults(complete);
        Iterator it = complete.iterator();
        while (it.hasNext()) {
            GeocodingResult r;
            r = (GeocodingResult)it.next();
            if (r.building == null || !(r.getDistance() > minBuildingDistance * 1.5)) continue;
            it.remove();
        }
        Collections.sort(complete, DISTANCE_COMPARATOR);
        return complete;
    }

    public static class GeocodingResult {
        public LatLon searchPoint;
        public LatLon connectionPoint;
        public long regionFP;
        public long regionLen;
        public BinaryRoutePlanner.RouteSegmentPoint point;
        public String streetName;
        public Building building;
        public String buildingInterpolation;
        public Street street;
        public City city;
        private double dist = -1.0;
        private double cityDist = -1.0;

        public GeocodingResult() {
        }

        public GeocodingResult(GeocodingResult r) {
            this.searchPoint = r.searchPoint;
            this.regionFP = r.regionFP;
            this.regionLen = r.regionLen;
            this.connectionPoint = r.connectionPoint;
            this.streetName = r.streetName;
            this.point = r.point;
            this.building = r.building;
            this.city = r.city;
            this.street = r.street;
        }

        public LatLon getLocation() {
            return this.connectionPoint;
        }

        public double getSortDistance() {
            double dist = this.getDistance();
            if (dist > 0.0 && this.building == null) {
                return dist + 50.0;
            }
            return dist;
        }

        public double getDistance() {
            if (this.dist == -1.0 && this.searchPoint != null) {
                if (this.building == null && this.point != null) {
                    this.dist = Math.sqrt(this.point.distToProj);
                } else if (this.connectionPoint != null) {
                    this.dist = MapUtils.getDistance(this.connectionPoint, this.searchPoint);
                }
            }
            return this.dist;
        }

        public void resetDistance() {
            this.dist = -1.0;
            this.getDistance();
        }

        public double getCityDistance() {
            if (this.cityDist == -1.0 && this.city != null && this.searchPoint != null) {
                this.cityDist = MapUtils.getDistance(this.city.getLocation(), this.searchPoint);
            }
            return this.cityDist;
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            if (this.building != null) {
                if (this.buildingInterpolation != null) {
                    bld.append(this.buildingInterpolation);
                } else {
                    bld.append(this.building.getName());
                }
            }
            if (this.street != null) {
                bld.append(" str. ").append(this.street.getName()).append(" city ").append(this.city.getName());
            } else if (this.streetName != null) {
                bld.append(" str. ").append(this.streetName);
            } else if (this.city != null) {
                bld.append(" city ").append(this.city.getName());
            }
            if (this.getDistance() > 0.0) {
                bld.append(" dist=").append((int)this.getDistance());
            }
            return bld.toString();
        }
    }
}

