/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.util;

import java.util.ArrayList;

public class DictionaryEntryLineParser {
    private static final char QUOTE = '\"';
    private static final char COMMA = ',';
    private static final String QUOTE_ESCAPED = "\"\"";

    public static String[] parseLine(String line) {
        boolean insideQuote = false;
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        int quoteCount = 0;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (c == '\"') {
                insideQuote = !insideQuote;
                ++quoteCount;
            }
            if (c == ',' && !insideQuote) {
                String value = builder.toString();
                value = DictionaryEntryLineParser.unescape(value);
                result.add(value);
                builder = new StringBuilder();
                continue;
            }
            builder.append(c);
        }
        result.add(builder.toString());
        if (quoteCount % 2 != 0) {
            throw new RuntimeException("Unmatched quote in entry: " + line);
        }
        return result.toArray(new String[result.size()]);
    }

    public static String unescape(String text) {
        StringBuilder builder = new StringBuilder();
        boolean foundQuote = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (i == 0 && c == '\"' || i == text.length() - 1 && c == '\"') continue;
            if (c == '\"') {
                if (foundQuote) {
                    builder.append('\"');
                    foundQuote = false;
                    continue;
                }
                foundQuote = true;
                continue;
            }
            foundQuote = false;
            builder.append(c);
        }
        return builder.toString();
    }

    public static String escape(String text) {
        boolean hasComma;
        boolean hasQuote = text.indexOf(34) >= 0;
        boolean bl = hasComma = text.indexOf(44) >= 0;
        if (!hasQuote && !hasComma) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        if (hasQuote) {
            for (int i = 0; i < text.length(); ++i) {
                char c = text.charAt(i);
                if (c == '\"') {
                    builder.append(QUOTE_ESCAPED);
                    continue;
                }
                builder.append(c);
            }
        } else {
            builder.append(text);
        }
        if (hasComma) {
            builder.insert(0, '\"');
            builder.append('\"');
        }
        return builder.toString();
    }
}

