/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.dict;

import com.atilika.kuromoji.dict.Dictionary;
import com.atilika.kuromoji.trie.PatriciaTrie;
import com.atilika.kuromoji.util.DictionaryEntryLineParser;
import com.atilika.kuromoji.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserDictionary
implements Dictionary {
    private static final String DEFAULT_FEATURE = "*";
    private static final String FEATURE_SEPARATOR = ",";
    private static final int CUSTOM_DICTIONARY_WORD_ID_OFFSET = 100000000;
    private static final int WORD_COST = -100000;
    private static final int LEFT_ID = 5;
    private static final int RIGHT_ID = 5;
    private int wordId = 100000000;
    private PatriciaTrie<int[]> entries = new PatriciaTrie();
    private Map<Integer, String> readings = new HashMap<Integer, String>();
    private Map<Integer, String> partOfSpeech = new HashMap<Integer, String>();
    private final int readingFeature;
    private final int partOfSpeechFeature;
    private final int totalFeatures;

    public UserDictionary(InputStream inputStream, int totalFeatures, int readingFeature, int partOfSpeechFeature) throws IOException {
        this.totalFeatures = totalFeatures;
        this.readingFeature = readingFeature;
        this.partOfSpeechFeature = partOfSpeechFeature;
        this.read(inputStream);
    }

    public List<UserDictionaryMatch> findUserDictionaryMatches(String text) {
        ArrayList<UserDictionaryMatch> matchInfos = new ArrayList<UserDictionaryMatch>();
        for (int startIndex = 0; startIndex < text.length(); ++startIndex) {
            String match;
            int[] details;
            int matchLength = 0;
            while (startIndex + matchLength < text.length() && this.entries.containsKeyPrefix(text.substring(startIndex, startIndex + matchLength + 1))) {
                ++matchLength;
            }
            if (matchLength <= 0 || (details = this.entries.get(match = text.substring(startIndex, startIndex + matchLength))) == null) continue;
            matchInfos.addAll(this.makeMatchDetails(startIndex, details));
        }
        return matchInfos;
    }

    private List<UserDictionaryMatch> makeMatchDetails(int matchStartIndex, int[] details) {
        ArrayList<UserDictionaryMatch> matchDetails = new ArrayList<UserDictionaryMatch>(details.length - 1);
        int wordId = details[0];
        int startIndex = 0;
        for (int i = 1; i < details.length; ++i) {
            int matchLength = details[i];
            matchDetails.add(new UserDictionaryMatch(wordId, matchStartIndex + startIndex, matchLength));
            startIndex += matchLength;
            ++wordId;
        }
        return matchDetails;
    }

    @Override
    public int getLeftId(int wordId) {
        return 5;
    }

    @Override
    public int getRightId(int wordId) {
        return 5;
    }

    @Override
    public int getWordCost(int wordId) {
        return -100000;
    }

    @Override
    public String[] getAllFeaturesArray(int wordId) {
        String[] features = new String[this.totalFeatures];
        for (int i = 0; i < this.totalFeatures; ++i) {
            features[i] = this.getFeature(wordId, i);
        }
        return features;
    }

    @Override
    public String getAllFeatures(int wordId) {
        return StringUtils.join(this.getAllFeaturesArray(wordId), FEATURE_SEPARATOR);
    }

    @Override
    public String getFeature(int wordId, int ... fields) {
        if (fields.length == 0 || fields.length == this.totalFeatures) {
            return this.getAllFeatures(wordId);
        }
        String[] features = new String[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            int featureNumber = fields[i];
            features[i] = featureNumber == this.readingFeature ? this.readings.get(wordId) : (featureNumber == this.partOfSpeechFeature ? this.partOfSpeech.get(wordId) : DEFAULT_FEATURE);
        }
        return StringUtils.join(features, FEATURE_SEPARATOR);
    }

    public void read(InputStream input) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("#.*$", "");
            if ((line = line.trim()).isEmpty()) continue;
            this.addEntry(line);
        }
    }

    public void addEntry(String entry) {
        String[] readings;
        String[] segmentation;
        String[] values = DictionaryEntryLineParser.parseLine(entry);
        String surface = values[0];
        String segmentationValue = values[1];
        String readingsValue = values[2];
        String partOfSpeech = values[3];
        if (this.isCustomSegmentation(surface, segmentationValue)) {
            segmentation = this.split(segmentationValue);
            readings = this.split(readingsValue);
        } else {
            segmentation = new String[]{segmentationValue};
            readings = new String[]{readingsValue};
        }
        if (segmentation.length != readings.length) {
            throw new RuntimeException("User dictionary entry not properly formatted: " + entry);
        }
        int[] wordIdAndLengths = new int[segmentation.length + 1];
        wordIdAndLengths[0] = this.wordId;
        for (int i = 0; i < segmentation.length; ++i) {
            wordIdAndLengths[i + 1] = segmentation[i].length();
            this.readings.put(this.wordId, readings[i]);
            this.partOfSpeech.put(this.wordId, partOfSpeech);
            ++this.wordId;
        }
        this.entries.put(surface, wordIdAndLengths);
    }

    private boolean isCustomSegmentation(String surface, String segmentation) {
        return !surface.equals(segmentation);
    }

    private String[] split(String input) {
        return input.split("\\s+");
    }

    public static class UserDictionaryMatch {
        private final int wordId;
        private final int matchStartIndex;
        private final int matchLength;

        public UserDictionaryMatch(int wordId, int matchStartIndex, int matchLength) {
            this.wordId = wordId;
            this.matchStartIndex = matchStartIndex;
            this.matchLength = matchLength;
        }

        public int getWordId() {
            return this.wordId;
        }

        public int getMatchStartIndex() {
            return this.matchStartIndex;
        }

        public int getMatchLength() {
            return this.matchLength;
        }
    }
}

