/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.compile;

import com.atilika.kuromoji.compile.Compiler;
import com.atilika.kuromoji.io.IntegerArrayIO;
import java.io.IOException;
import java.io.OutputStream;

public class WordIdMapCompiler
implements Compiler {
    private int[][] wordIds = new int[1][];
    private int[] indices;
    private GrowableIntArray wordIdArray = new GrowableIntArray();

    public void addMapping(int sourceId, int wordId) {
        int[] current;
        if (this.wordIds.length <= sourceId) {
            int[][] newArray = new int[sourceId + 1][];
            System.arraycopy(this.wordIds, 0, newArray, 0, this.wordIds.length);
            this.wordIds = newArray;
        }
        if ((current = this.wordIds[sourceId]) == null) {
            current = new int[1];
        } else {
            int[] newArray = new int[current.length + 1];
            System.arraycopy(current, 0, newArray, 0, current.length);
            current = newArray;
        }
        this.wordIds[sourceId] = current;
        int[] targets = this.wordIds[sourceId];
        targets[targets.length - 1] = wordId;
    }

    public void write(OutputStream output) throws IOException {
        this.compile();
        IntegerArrayIO.writeArray(output, this.indices);
        IntegerArrayIO.writeArray(output, this.wordIdArray.getArray());
    }

    @Override
    public void compile() {
        this.indices = new int[this.wordIds.length];
        int wordIdIndex = 0;
        for (int i = 0; i < this.wordIds.length; ++i) {
            int[] inner = this.wordIds[i];
            if (inner == null) {
                this.indices[i] = -1;
                continue;
            }
            this.indices[i] = wordIdIndex;
            this.wordIdArray.set(wordIdIndex++, inner.length);
            for (int j = 0; j < inner.length; ++j) {
                this.wordIdArray.set(wordIdIndex++, inner[j]);
            }
        }
    }

    public static class GrowableIntArray {
        private static final float ARRAY_GROWTH_RATE = 1.25f;
        private static final int ARRAY_INITIAL_SIZE = 1024;
        private int maxIndex;
        private int[] array;

        public GrowableIntArray(int size) {
            this.array = new int[size];
            this.maxIndex = 0;
        }

        public GrowableIntArray() {
            this(1024);
        }

        public int[] getArray() {
            int length = this.maxIndex + 1;
            int[] a = new int[length];
            System.arraycopy(this.array, 0, a, 0, length);
            return a;
        }

        public void set(int index, int value) {
            if (index >= this.array.length) {
                this.grow(this.getNewLength(index));
            }
            if (index > this.maxIndex) {
                this.maxIndex = index;
            }
            this.array[index] = value;
        }

        private void grow(int newLength) {
            int[] tmp = new int[newLength];
            System.arraycopy(this.array, 0, tmp, 0, this.maxIndex + 1);
            this.array = tmp;
        }

        private int getNewLength(int index) {
            return (int)Math.max((float)(index + 1), (float)this.array.length * 1.25f);
        }
    }
}

