/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.PlatformUtil;
import net.osmand.osm.io.NetworkUtils;
import net.osmand.util.Algorithms;
import net.osmand.wiki.Metadata;
import net.osmand.wiki.WikiImage;
import org.apache.commons.logging.Log;

public class WikiCoreHelper {
    public static final boolean USE_OSMAND_WIKI_API = true;
    private static final Log LOG = PlatformUtil.getLog(WikiCoreHelper.class);
    private static final String WIKIMEDIA_API_ENDPOINT = "https://commons.wikimedia.org/w/api.php";
    private static final String WIKIDATA_API_ENDPOINT = "https://www.wikidata.org/w/api.php";
    private static final String WIKIDATA_ACTION = "?action=wbgetclaims&property=P18&entity=";
    private static final String WIKIMEDIA_ACTION = "?action=query&list=categorymembers&cmtitle=";
    private static final String CM_LIMIT = "&cmlimit=100";
    private static final String FORMAT_JSON = "&format=json";
    private static final String IMAGE_BASE_URL = "https://commons.wikimedia.org/wiki/Special:FilePath/";
    public static final String WIKIMEDIA_FILE = "File:";
    public static final String WIKIMEDIA_CATEGORY = "Category:";
    private static final int THUMB_SIZE = 480;
    public static final String OSMAND_API_ENDPOINT = "https://osmand.net/api/wiki_place?";
    private static final int DEPT_CAT_LIMIT = 1;
    private static final List<String> IMAGE_EXTENSIONS = new ArrayList<String>(Arrays.asList(".jpeg", ".jpg", ".png", ".gif"));

    public static List<WikiImage> getWikiImageList(Map<String, String> tags) {
        int urlInd;
        ArrayList<WikiImage> wikiImages = new ArrayList<WikiImage>();
        String wikidataId = tags.getOrDefault("wikidata", "");
        String wikimediaCommons = tags.get("wikimedia_commons");
        Object wikiTitle = tags.get("wikipedia");
        String wikiCategory = "";
        int n = urlInd = wikiTitle == null ? 0 : ((String)wikiTitle).indexOf(".wikipedia.org/wiki/");
        if (urlInd > 0) {
            String prefix = ((String)wikiTitle).substring(0, urlInd);
            String lang = prefix.substring(prefix.lastIndexOf("/") + 1, prefix.length());
            String title = ((String)wikiTitle).substring(urlInd + ".wikipedia.org/wiki/".length());
            wikiTitle = lang + ":" + title;
        }
        if (!Algorithms.isEmpty(wikimediaCommons)) {
            if (wikimediaCommons.startsWith(WIKIMEDIA_FILE)) {
                WikiCoreHelper.addFile(wikiImages, wikimediaCommons);
            } else if (wikimediaCommons.startsWith(WIKIMEDIA_CATEGORY)) {
                wikiCategory = wikimediaCommons.replace(WIKIMEDIA_CATEGORY, "");
            }
        }
        if (Algorithms.isEmpty((CharSequence)wikiTitle)) {
            for (String tag : tags.keySet()) {
                if (!tag.startsWith("wikipedia:")) continue;
                wikiTitle = tag.substring("wikipedia:".length()) + ":" + tags.get(tag);
            }
        }
        Object url = "";
        try {
            if (!Algorithms.isEmpty(wikidataId)) {
                url = (String)url + (((String)url).length() == 0 ? OSMAND_API_ENDPOINT : "&") + "article=" + URLEncoder.encode(wikidataId, "UTF-8");
            }
            if (!Algorithms.isEmpty(wikiCategory)) {
                url = (String)url + (((String)url).length() == 0 ? OSMAND_API_ENDPOINT : "&") + "category=" + URLEncoder.encode(wikiCategory, "UTF-8");
            }
            if (!Algorithms.isEmpty((CharSequence)wikiTitle)) {
                url = (String)url + (((String)url).length() == 0 ? OSMAND_API_ENDPOINT : "&") + "wiki=" + URLEncoder.encode((String)wikiTitle, "UTF-8");
            }
            if (!Algorithms.isEmpty(wikidataId)) {
                url = (String)url + (((String)url).length() == 0 ? OSMAND_API_ENDPOINT : "&") + "addMetaData=" + URLEncoder.encode("true", "UTF-8");
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (((String)url).length() > 0) {
            WikiCoreHelper.getImagesOsmAndAPIRequestV2((String)url, wikiImages);
        }
        return wikiImages;
    }

    private static void addFile(List<WikiImage> wikiImages, String wikimediaCommons) {
        String imageFileName = wikimediaCommons.replace(WIKIMEDIA_FILE, "");
        WikiImage wikiImage = WikiCoreHelper.getImageData(imageFileName);
        wikiImages.add(wikiImage);
    }

    private static List<WikiImage> getWikimediaImageCategory(String categoryName, List<WikiImage> wikiImages, int depth) {
        String url = "https://commons.wikimedia.org/w/api.php?action=query&list=categorymembers&cmtitle=Category:" + categoryName + "&cmlimit=100&format=json";
        WikimediaResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, WikimediaResponse.class);
        if (response != null) {
            ArrayList<String> subCategories = new ArrayList<String>();
            for (Categorymember cm : response.query.categorymembers) {
                String memberTitle = cm.title;
                if (memberTitle == null) continue;
                if (memberTitle.startsWith(WIKIMEDIA_CATEGORY)) {
                    subCategories.add(memberTitle);
                    continue;
                }
                if (!memberTitle.startsWith(WIKIMEDIA_FILE)) continue;
                WikiCoreHelper.addFile(wikiImages, memberTitle);
            }
            if (depth < 1) {
                for (String subCategory : subCategories) {
                    WikiCoreHelper.getWikimediaImageCategory(subCategory, wikiImages, depth + 1);
                }
            }
        }
        return wikiImages;
    }

    protected static List<WikiImage> getWikidataImageWikidata(String wikidataId, List<WikiImage> wikiImages) {
        String url = "https://www.wikidata.org/w/api.php?action=wbgetclaims&property=P18&entity=" + wikidataId + FORMAT_JSON;
        WikidataResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, WikidataResponse.class);
        if (response != null && response.claims != null && response.claims.p18 != null) {
            for (P18 p18 : response.claims.p18) {
                WikiImage wikiImage;
                String imageFileName = p18.mainsnak.datavalue.value;
                if (imageFileName == null || (wikiImage = WikiCoreHelper.getImageData(imageFileName)) == null) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private static List<WikiImage> getImagesOsmAndAPIRequestV2(String url, List<WikiImage> wikiImages) {
        OsmandAPIResponseV2 response = WikiCoreHelper.sendWikipediaApiRequest(url, OsmandAPIResponseV2.class);
        if (response != null && !Algorithms.isEmpty(response.images)) {
            for (Map<String, Object> image : response.images) {
                WikiImage wikiImage = WikiCoreHelper.parseImageDataWithMetaData(image);
                if (wikiImage == null || !WikiCoreHelper.isUrlFileImage(wikiImage)) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private static boolean isUrlFileImage(WikiImage wikiImage) {
        String path = wikiImage.getImageHiResUrl();
        int lastIndexOfDot = path.lastIndexOf(46);
        if (lastIndexOfDot != -1) {
            return IMAGE_EXTENSIONS.contains(path.substring(lastIndexOfDot).toLowerCase());
        }
        return false;
    }

    private static List<WikiImage> getImagesOsmAndAPIRequest(String url, List<WikiImage> wikiImages) {
        OsmandAPIResponse response = WikiCoreHelper.sendWikipediaApiRequest(url, OsmandAPIResponse.class);
        if (response != null && !Algorithms.isEmpty(response.images)) {
            for (String imageUrl : response.images) {
                WikiImage wikiImage;
                if (imageUrl == null || (wikiImage = WikiCoreHelper.parseImageDataFromFile(imageUrl)) == null) continue;
                wikiImages.add(wikiImage);
            }
        }
        return wikiImages;
    }

    private static WikiImage parseImageDataWithMetaData(Map<String, Object> image) {
        WikiImage wikiImage;
        String imageUrl = (String)image.get("image");
        if (!Algorithms.isEmpty(image) && (wikiImage = WikiCoreHelper.parseImageDataFromFile(imageUrl)) != null) {
            Metadata metadata = wikiImage.getMetadata();
            String date = (String)image.get("date");
            if (date != null) {
                metadata.setDate(date);
            }
            String author = (String)image.get("author");
            if (date != null) {
                metadata.setAuthor(author);
            }
            String license = (String)image.get("license");
            if (date != null) {
                metadata.setLicense(license);
            }
            return wikiImage;
        }
        return null;
    }

    private static WikiImage parseImageDataFromFile(String imageUrl) {
        try {
            imageUrl = URLDecoder.decode(imageUrl, "UTF-8");
            String imageHiResUrl = imageUrl.replace(" ", "_");
            String imageFileName = Algorithms.getFileWithoutDirs(imageUrl);
            String imageName = Algorithms.getFileNameWithoutExtension(imageUrl);
            String imageStubUrl = imageHiResUrl + "?width=480";
            return new WikiImage(imageFileName, imageName, imageStubUrl, imageHiResUrl);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
    }

    public static WikiImage getImageData(String imageFileName) {
        try {
            String imageName = URLDecoder.decode(imageFileName, "UTF-8");
            imageFileName = imageName.replace(" ", "_");
            imageName = imageName.substring(0, imageName.lastIndexOf("."));
            String imageHiResUrl = IMAGE_BASE_URL + imageFileName;
            String imageStubUrl = IMAGE_BASE_URL + imageFileName + "?width=480";
            return new WikiImage(imageFileName, imageName, imageStubUrl, imageHiResUrl);
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)e.getLocalizedMessage());
            return null;
        }
    }

    private static <T> T sendWikipediaApiRequest(String url, Class<T> responseClass) {
        StringBuilder rawResponse = new StringBuilder();
        String errorMessage = NetworkUtils.sendGetRequest(url, null, rawResponse);
        if (errorMessage == null) {
            try {
                return (T)new Gson().fromJson(rawResponse.toString(), responseClass);
            }
            catch (JsonSyntaxException e) {
                errorMessage = e.getLocalizedMessage();
            }
        }
        LOG.error((Object)errorMessage);
        return null;
    }

    public static class WikimediaResponse {
        @SerializedName(value="query")
        @Expose
        private Query query;
    }

    public static class Query {
        @SerializedName(value="categorymembers")
        @Expose
        private List<Categorymember> categorymembers;
    }

    public static class Categorymember {
        @SerializedName(value="title")
        @Expose
        private String title;
    }

    public static class WikidataResponse {
        @SerializedName(value="claims")
        @Expose
        private Claims claims;
    }

    public static class Claims {
        @SerializedName(value="P18")
        @Expose
        private final List<P18> p18 = null;
    }

    public static class P18 {
        @SerializedName(value="mainsnak")
        @Expose
        private Mainsnak mainsnak;
    }

    public static class Mainsnak {
        @SerializedName(value="datavalue")
        @Expose
        private Datavalue datavalue;
        @SerializedName(value="datatype")
        @Expose
        private String datatype;
    }

    public static class Datavalue {
        @SerializedName(value="value")
        @Expose
        private String value;
        @SerializedName(value="type")
        @Expose
        private String type;
    }

    public static class OsmandAPIResponseV2 {
        @SerializedName(value="features-v2")
        @Expose
        private final Set<Map<String, Object>> images = null;
    }

    public static class OsmandAPIResponse {
        @SerializedName(value="features")
        @Expose
        private final List<String> images = null;
    }
}

