/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.network;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.set.hash.TLongHashSet;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.NativeLibrary;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.QuadRect;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXUtilities;
import net.osmand.osm.OsmRouteType;
import net.osmand.router.network.NetworkRouteContext;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.TransliterationHelper;

public class NetworkRouteSelector {
    public static final String ROUTE_KEY_VALUE_SEPARATOR = "__";
    public static final String NETWORK_ROUTE_TYPE = "type";
    private static final boolean GROW_ALGORITHM = false;
    private static final int MAX_ITERATIONS = 16000;
    private static final double MAX_RADIUS_HOLE = 30.0;
    private static final int CONNECT_POINTS_DISTANCE_STEP = 50;
    private static final int CONNECT_POINTS_DISTANCE_MAX = 1000;
    private final NetworkRouteContext rCtx;
    private final INetworkRouteSelection callback;

    public NetworkRouteSelector(BinaryMapIndexReader[] files, NetworkRouteSelectorFilter filter, INetworkRouteSelection callback) {
        this(files, filter, callback, true);
    }

    public NetworkRouteSelector(BinaryMapIndexReader[] files, NetworkRouteSelectorFilter filter, INetworkRouteSelection callback, boolean routing) {
        if (filter == null) {
            filter = new NetworkRouteSelectorFilter();
        }
        this.rCtx = new NetworkRouteContext(files, filter, routing);
        this.callback = callback;
    }

    public NetworkRouteContext getNetworkRouteContext() {
        return this.rCtx;
    }

    public boolean isCancelled() {
        return this.callback != null && this.callback.isCancelled();
    }

    public Map<RouteKey, GPXFile> getRoutes(NativeLibrary.RenderedObject renderedObject) throws IOException {
        int x = renderedObject.getX().get(0);
        int y = renderedObject.getY().get(0);
        return this.getRoutes(x, y, true);
    }

    public Map<RouteKey, GPXFile> getRoutes(NativeLibrary.RenderedObject renderedObject, boolean loadRoutes) throws IOException {
        int x = renderedObject.getX().get(0);
        int y = renderedObject.getY().get(0);
        return this.getRoutes(x, y, loadRoutes);
    }

    public Map<RouteKey, GPXFile> getRoutes(int x, int y, boolean loadRoutes) throws IOException {
        LinkedHashMap<RouteKey, GPXFile> res = new LinkedHashMap<RouteKey, GPXFile>();
        for (NetworkRouteContext.NetworkRouteSegment segment : this.rCtx.loadRouteSegment(x, y)) {
            if (res.containsKey(segment.routeKey)) continue;
            if (loadRoutes) {
                this.connectAlgorithm(segment, res);
                continue;
            }
            res.put(segment.routeKey, null);
        }
        return res;
    }

    public Map<RouteKey, GPXFile> getRoutes(QuadRect bBox, boolean loadRoutes, RouteKey selected) throws IOException {
        int y31T = MapUtils.get31TileNumberY(Math.max(bBox.bottom, bBox.top));
        int y31B = MapUtils.get31TileNumberY(Math.min(bBox.bottom, bBox.top));
        int x31L = MapUtils.get31TileNumberX(bBox.left);
        int x31R = MapUtils.get31TileNumberX(bBox.right);
        Map<RouteKey, List<NetworkRouteContext.NetworkRouteSegment>> routeSegmentTile = this.rCtx.loadRouteSegmentsBbox(x31L, y31T, x31R, y31B, null);
        LinkedHashMap<RouteKey, GPXFile> gpxFileMap = new LinkedHashMap<RouteKey, GPXFile>();
        for (RouteKey routeKey : routeSegmentTile.keySet()) {
            List<NetworkRouteContext.NetworkRouteSegment> routeSegments;
            if (selected != null && !selected.equals(routeKey) || (routeSegments = routeSegmentTile.get(routeKey)).size() <= 0) continue;
            if (!loadRoutes) {
                gpxFileMap.put(routeKey, null);
                continue;
            }
            NetworkRouteContext.NetworkRouteSegment firstSegment = routeSegments.get(0);
            this.connectAlgorithm(firstSegment, gpxFileMap);
        }
        return gpxFileMap;
    }

    private List<NetworkRouteSegmentChain> getByPoint(Map<Long, List<NetworkRouteSegmentChain>> chains, long pnt, int radius, NetworkRouteSegmentChain exclude) {
        List<NetworkRouteSegmentChain> list = null;
        if (radius == 0) {
            list = chains.get(pnt);
            if (list != null) {
                if (!list.contains(exclude)) {
                    return new ArrayList<NetworkRouteSegmentChain>(list);
                }
                if (list.size() == 1) {
                    list = null;
                } else {
                    list = new ArrayList<NetworkRouteSegmentChain>(list);
                    list.remove(exclude);
                }
            }
        } else {
            int x = NetworkRouteContext.getXFromLong(pnt);
            int y = NetworkRouteContext.getYFromLong(pnt);
            for (Map.Entry<Long, List<NetworkRouteSegmentChain>> e : chains.entrySet()) {
                int y2;
                int x2 = NetworkRouteContext.getXFromLong(e.getKey());
                if (!(MapUtils.squareRootDist31(x, y, x2, y2 = NetworkRouteContext.getYFromLong(e.getKey())) < (double)radius)) continue;
                if (list == null) {
                    list = new ArrayList<NetworkRouteSegmentChain>();
                }
                for (NetworkRouteSegmentChain c : e.getValue()) {
                    if (c == exclude) continue;
                    list.add(c);
                }
            }
        }
        if (list == null) {
            return Collections.emptyList();
        }
        return list;
    }

    private void connectAlgorithm(NetworkRouteContext.NetworkRouteSegment segment, Map<RouteKey, GPXFile> res) throws IOException {
        RouteKey rkey = segment.routeKey;
        ArrayList<NetworkRouteContext.NetworkRouteSegment> loaded = new ArrayList<NetworkRouteContext.NetworkRouteSegment>();
        this.debug("START ", null, segment);
        this.loadData(segment, rkey, loaded);
        List<NetworkRouteSegmentChain> lst = this.getNetworkRouteSegmentChains(segment.routeKey, res, loaded);
        this.debug("FINISH " + lst.size(), null, segment);
    }

    List<NetworkRouteSegmentChain> getNetworkRouteSegmentChains(RouteKey routeKey, Map<RouteKey, GPXFile> res, List<NetworkRouteContext.NetworkRouteSegment> loaded) {
        System.out.println("About to merge: " + loaded.size());
        Map<Long, List<NetworkRouteSegmentChain>> chains = this.createChainStructure(loaded);
        Map<Long, List<NetworkRouteSegmentChain>> endChains = this.prepareEndChain(chains);
        this.connectSimpleMerge(chains, endChains, 0, 0);
        this.connectSimpleMerge(chains, endChains, 0, 50);
        for (int s = 0; s < 1000; s += 50) {
            this.connectSimpleMerge(chains, endChains, s, s + 50);
        }
        this.connectToLongestChain(chains, endChains, 50);
        this.connectSimpleMerge(chains, endChains, 0, 50);
        this.connectSimpleMerge(chains, endChains, 500, 1000);
        List<NetworkRouteSegmentChain> lst = this.flattenChainStructure(chains);
        GPXFile gpxFile = this.createGpxFile(lst, routeKey);
        res.put(routeKey, gpxFile);
        return lst;
    }

    private int connectToLongestChain(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, int rad) {
        ArrayList<NetworkRouteSegmentChain> chainsFlat = new ArrayList<NetworkRouteSegmentChain>();
        for (List<NetworkRouteSegmentChain> ch : chains.values()) {
            chainsFlat.addAll(ch);
        }
        Collections.sort(chainsFlat, new Comparator<NetworkRouteSegmentChain>(){

            @Override
            public int compare(NetworkRouteSegmentChain o1, NetworkRouteSegmentChain o2) {
                return -Integer.compare(o1.getSize(), o2.getSize());
            }
        });
        int mergedCount = 0;
        int i = 0;
        while (i < chainsFlat.size()) {
            NetworkRouteSegmentChain first = (NetworkRouteSegmentChain)chainsFlat.get(i);
            boolean merged = false;
            for (int j = i + 1; j < chainsFlat.size() && !merged && !this.isCancelled(); ++j) {
                NetworkRouteSegmentChain second = (NetworkRouteSegmentChain)chainsFlat.get(j);
                if (MapUtils.squareRootDist31(first.getEndPointX(), first.getEndPointY(), second.getEndPointX(), second.getEndPointY()) < (double)rad) {
                    NetworkRouteSegmentChain secondReversed = this.chainReverse(chains, endChains, second);
                    this.chainAdd(chains, endChains, first, secondReversed);
                    chainsFlat.remove(j);
                    merged = true;
                    continue;
                }
                if (MapUtils.squareRootDist31(first.start.getStartPointX(), first.start.getStartPointY(), second.start.getStartPointX(), second.start.getStartPointY()) < (double)rad) {
                    NetworkRouteSegmentChain firstReversed = this.chainReverse(chains, endChains, first);
                    this.chainAdd(chains, endChains, firstReversed, second);
                    chainsFlat.remove(j);
                    chainsFlat.set(i, firstReversed);
                    merged = true;
                    continue;
                }
                if (MapUtils.squareRootDist31(first.getEndPointX(), first.getEndPointY(), second.start.getStartPointX(), second.start.getStartPointY()) < (double)rad) {
                    this.chainAdd(chains, endChains, first, second);
                    chainsFlat.remove(j);
                    merged = true;
                    continue;
                }
                if (!(MapUtils.squareRootDist31(second.getEndPointX(), second.getEndPointY(), first.start.getStartPointX(), first.start.getStartPointY()) < (double)rad)) continue;
                this.chainAdd(chains, endChains, second, first);
                chainsFlat.remove(i);
                merged = true;
            }
            if (!merged) {
                ++i;
                continue;
            }
            i = 0;
            ++mergedCount;
        }
        System.out.println(String.format("Connect longest alternative chains: %d (radius %d)", mergedCount, rad));
        return mergedCount;
    }

    private int connectSimpleMerge(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, int rad, int radE) {
        int merged = 1;
        while (merged > 0 && !this.isCancelled()) {
            int rs = this.reverseToConnectMore(chains, endChains, rad, radE);
            merged = this.connectSimpleStraight(chains, endChains, rad, radE);
            System.out.println(String.format("Simple merged: %d, reversed: %d (radius %d %d)", merged, rs, rad, radE));
        }
        return merged;
    }

    private int reverseToConnectMore(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, int rad, int radE) {
        int reversed = 0;
        ArrayList<Long> longPoints = new ArrayList<Long>(chains.keySet());
        block0: for (Long startPnt : longPoints) {
            List<NetworkRouteSegmentChain> vls = chains.get(startPnt);
            for (int i = 0; vls != null && i < vls.size(); ++i) {
                NetworkRouteSegmentChain it = vls.get(i);
                long pnt = NetworkRouteContext.convertPointToLong(it.getEndPointX(), it.getEndPointY());
                List<NetworkRouteSegmentChain> startLst = this.getByPoint(chains, pnt, radE, null);
                boolean noStartFromEnd = this.filterChains(startLst, it, rad, true).size() == 0;
                boolean reverse = noStartFromEnd && vls.size() > 0;
                List<NetworkRouteSegmentChain> endLst = this.getByPoint(endChains, pnt, radE, null);
                if (!(reverse |= i == 0 && this.filterChains(endLst, it, rad, false).size() > 1 && noStartFromEnd)) continue;
                this.chainReverse(chains, endChains, it);
                ++reversed;
                continue block0;
            }
        }
        return reversed;
    }

    private List<NetworkRouteSegmentChain> filterChains(List<NetworkRouteSegmentChain> lst, NetworkRouteSegmentChain ch, int rad, boolean start) {
        if (lst.size() == 0) {
            return lst;
        }
        Iterator<NetworkRouteSegmentChain> it = lst.iterator();
        while (it.hasNext()) {
            NetworkRouteSegmentChain chain = it.next();
            double min = rad + 1;
            NetworkRouteContext.NetworkRouteSegment s = start ? chain.start : chain.getLast();
            NetworkRouteContext.NetworkRouteSegment last = ch.getLast();
            for (int i = 0; i < s.getPointsLength(); ++i) {
                for (int j = 0; j < last.getPointsLength(); ++j) {
                    double m = MapUtils.squareRootDist31(last.getPoint31XTile(j), last.getPoint31YTile(j), s.getPoint31XTile(i), s.getPoint31YTile(i));
                    if (!(m < min)) continue;
                    min = m;
                }
            }
            if (!(min > (double)rad)) continue;
            it.remove();
        }
        return lst;
    }

    private int connectSimpleStraight(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, int rad, int radE) {
        int merged = 0;
        boolean changed = true;
        block0: while (changed && !this.isCancelled()) {
            changed = false;
            for (List<NetworkRouteSegmentChain> lst : chains.values()) {
                for (NetworkRouteSegmentChain it : lst) {
                    long pnt = NetworkRouteContext.convertPointToLong(it.getEndPointX(), it.getEndPointY());
                    List<NetworkRouteSegmentChain> connectNextLst = this.getByPoint(chains, pnt, radE, it);
                    connectNextLst = this.filterChains(connectNextLst, it, rad, true);
                    List<NetworkRouteSegmentChain> connectToEndLst = this.getByPoint(endChains, pnt, radE, it);
                    if ((connectToEndLst = this.filterChains(connectToEndLst, it, rad, false)).size() > 0) {
                        connectToEndLst.removeAll(connectNextLst);
                    }
                    if (connectNextLst.size() != 1 || connectToEndLst.size() != 0) continue;
                    this.chainAdd(chains, endChains, it, connectNextLst.get(0));
                    changed = true;
                    ++merged;
                    continue block0;
                }
            }
        }
        return merged;
    }

    private NetworkRouteSegmentChain chainReverse(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, NetworkRouteSegmentChain it) {
        long startPnt = NetworkRouteContext.convertPointToLong(it.start.getStartPointX(), it.start.getStartPointY());
        long pnt = NetworkRouteContext.convertPointToLong(it.getEndPointX(), it.getEndPointY());
        ArrayList<NetworkRouteContext.NetworkRouteSegment> lst = new ArrayList<NetworkRouteContext.NetworkRouteSegment>();
        lst.add(0, it.start.inverse());
        if (it.connected != null) {
            for (NetworkRouteContext.NetworkRouteSegment s : it.connected) {
                lst.add(0, s.inverse());
            }
        }
        this.remove(chains, startPnt, it);
        this.remove(endChains, pnt, it);
        NetworkRouteSegmentChain newChain = new NetworkRouteSegmentChain();
        newChain.start = (NetworkRouteContext.NetworkRouteSegment)lst.remove(0);
        newChain.connected = lst;
        this.add(chains, NetworkRouteContext.convertPointToLong(newChain.start.getStartPointX(), newChain.start.getStartPointY()), newChain);
        this.add(endChains, NetworkRouteContext.convertPointToLong(newChain.getEndPointX(), newChain.getEndPointY()), newChain);
        return newChain;
    }

    private void chainAdd(Map<Long, List<NetworkRouteSegmentChain>> chains, Map<Long, List<NetworkRouteSegmentChain>> endChains, NetworkRouteSegmentChain it, NetworkRouteSegmentChain toAdd) {
        double minStartDist;
        if (it == toAdd) {
            throw new IllegalStateException();
        }
        this.remove(chains, NetworkRouteContext.convertPointToLong(toAdd.start.getStartPointX(), toAdd.start.getStartPointY()), toAdd);
        this.remove(endChains, NetworkRouteContext.convertPointToLong(toAdd.getEndPointX(), toAdd.getEndPointY()), toAdd);
        this.remove(endChains, NetworkRouteContext.convertPointToLong(it.getEndPointX(), it.getEndPointY()), it);
        double minLastDist = minStartDist = MapUtils.squareRootDist31(it.getEndPointX(), it.getEndPointY(), toAdd.start.getStartPointX(), toAdd.start.getStartPointY());
        int minStartInd = toAdd.start.start;
        for (int i = 0; i < toAdd.start.getPointsLength(); ++i) {
            double m = MapUtils.squareRootDist31(it.getEndPointX(), it.getEndPointY(), toAdd.start.getPoint31XTile(i), toAdd.start.getPoint31YTile(i));
            if (!(m < minStartDist) || minStartInd == i) continue;
            minStartInd = i;
            minStartDist = m;
        }
        NetworkRouteContext.NetworkRouteSegment lastIt = it.getLast();
        int minLastInd = lastIt.end;
        for (int i = 0; i < lastIt.getPointsLength(); ++i) {
            double m = MapUtils.squareRootDist31(lastIt.getPoint31XTile(i), lastIt.getPoint31YTile(i), toAdd.start.getStartPointX(), toAdd.start.getStartPointY());
            if (!(m < minLastDist) || minLastInd == i) continue;
            minLastInd = i;
            minLastDist = m;
        }
        if (minLastDist > minStartDist) {
            if (minStartInd != toAdd.start.start) {
                toAdd.setStart(new NetworkRouteContext.NetworkRouteSegment(toAdd.start, minStartInd, toAdd.start.end));
            }
        } else if (minLastInd != lastIt.end) {
            it.setEnd(new NetworkRouteContext.NetworkRouteSegment(lastIt, lastIt.start, minLastInd));
        }
        it.addChain(toAdd);
        this.add(endChains, NetworkRouteContext.convertPointToLong(it.getEndPointX(), it.getEndPointY()), it);
    }

    private void add(Map<Long, List<NetworkRouteSegmentChain>> chains, long pnt, NetworkRouteSegmentChain chain) {
        List<NetworkRouteSegmentChain> lst = chains.get(pnt);
        if (lst == null) {
            lst = new ArrayList<NetworkRouteSegmentChain>();
            chains.put(pnt, lst);
        }
        lst.add(chain);
    }

    private void remove(Map<Long, List<NetworkRouteSegmentChain>> chains, long pnt, NetworkRouteSegmentChain toRemove) {
        List<NetworkRouteSegmentChain> lch = chains.get(pnt);
        if (lch == null) {
            throw new IllegalStateException();
        }
        if (!lch.remove(toRemove)) {
            throw new IllegalStateException();
        }
        if (lch.isEmpty()) {
            chains.remove(pnt);
        }
    }

    private List<NetworkRouteSegmentChain> flattenChainStructure(Map<Long, List<NetworkRouteSegmentChain>> chains) {
        ArrayList<NetworkRouteSegmentChain> chainsFlat = new ArrayList<NetworkRouteSegmentChain>();
        for (List<NetworkRouteSegmentChain> ch : chains.values()) {
            chainsFlat.addAll(ch);
        }
        Collections.sort(chainsFlat, new Comparator<NetworkRouteSegmentChain>(){

            @Override
            public int compare(NetworkRouteSegmentChain o1, NetworkRouteSegmentChain o2) {
                return -Integer.compare(o1.getSize(), o2.getSize());
            }
        });
        return chainsFlat;
    }

    private Map<Long, List<NetworkRouteSegmentChain>> prepareEndChain(Map<Long, List<NetworkRouteSegmentChain>> chains) {
        LinkedHashMap<Long, List<NetworkRouteSegmentChain>> endChains = new LinkedHashMap<Long, List<NetworkRouteSegmentChain>>();
        for (List<NetworkRouteSegmentChain> ch : chains.values()) {
            for (NetworkRouteSegmentChain chain : ch) {
                this.add(endChains, NetworkRouteContext.convertPointToLong(chain.getEndPointX(), chain.getEndPointY()), chain);
            }
        }
        return endChains;
    }

    private Map<Long, List<NetworkRouteSegmentChain>> createChainStructure(List<NetworkRouteContext.NetworkRouteSegment> lst) {
        LinkedHashMap<Long, List<NetworkRouteSegmentChain>> chains = new LinkedHashMap<Long, List<NetworkRouteSegmentChain>>();
        for (NetworkRouteContext.NetworkRouteSegment s : lst) {
            NetworkRouteSegmentChain chain = new NetworkRouteSegmentChain();
            chain.start = s;
            long pnt = NetworkRouteContext.convertPointToLong(s.getStartPointX(), s.getStartPointY());
            this.add(chains, pnt, chain);
        }
        return chains;
    }

    private void loadData(NetworkRouteContext.NetworkRouteSegment segment, RouteKey rkey, List<NetworkRouteContext.NetworkRouteSegment> lst) throws IOException {
        TLongArrayList queue = new TLongArrayList();
        HashSet<Long> visitedTiles = new HashSet<Long>();
        HashSet<Long> objIds = new HashSet<Long>();
        long start = NetworkRouteContext.getTileId(segment.getStartPointX(), segment.getStartPointY());
        long end = NetworkRouteContext.getTileId(segment.getEndPointX(), segment.getEndPointY());
        queue.add(start);
        queue.add(end);
        while (!queue.isEmpty() && !this.isCancelled()) {
            int yTile;
            int xTile;
            Map<RouteKey, List<NetworkRouteContext.NetworkRouteSegment>> tiles;
            List<NetworkRouteContext.NetworkRouteSegment> loaded;
            long tileID = queue.get(queue.size() - 1);
            queue.remove(queue.size() - 1, 1);
            if (!visitedTiles.add(tileID) || (loaded = (tiles = this.rCtx.loadRouteSegmentIntersectingTile(xTile = NetworkRouteContext.getXFromTileId(tileID), yTile = NetworkRouteContext.getYFromTileId(tileID), rkey, new HashMap<RouteKey, List<NetworkRouteContext.NetworkRouteSegment>>())).get(rkey)) == null) continue;
            for (NetworkRouteContext.NetworkRouteSegment loadedSegment : loaded) {
                if (!objIds.add(loadedSegment.getId())) continue;
                lst.add(loadedSegment);
            }
            this.addEnclosedTiles(queue, tileID);
        }
    }

    private void addEnclosedTiles(TLongArrayList queue, long tile) {
        int x = NetworkRouteContext.getXFromTileId(tile);
        int y = NetworkRouteContext.getYFromTileId(tile);
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                if (dy == 0 && dx == 0) continue;
                queue.add(NetworkRouteContext.getTileId(x + dx, y + dy, 0));
            }
        }
    }

    private void growAlgorithm(NetworkRouteContext.NetworkRouteSegment segment, Map<RouteKey, GPXFile> res) throws IOException {
        ArrayList<NetworkRouteContext.NetworkRouteSegment> lst = new ArrayList<NetworkRouteContext.NetworkRouteSegment>();
        TLongHashSet visitedIds = new TLongHashSet();
        visitedIds.add(segment.getId());
        lst.add(segment.inverse());
        this.debug("START ", null, segment);
        int it = 0;
        while (it++ < 16000) {
            if (this.grow(lst, visitedIds, true, false) || this.grow(lst, visitedIds, true, true)) continue;
            it = 0;
            break;
        }
        Collections.reverse(lst);
        for (int i = 0; i < lst.size(); ++i) {
            lst.set(i, ((NetworkRouteContext.NetworkRouteSegment)lst.get(i)).inverse());
        }
        while (it++ < 16000) {
            if (this.grow(lst, visitedIds, false, false) || this.grow(lst, visitedIds, false, true)) continue;
            it = 0;
            break;
        }
        RouteKey routeKey = segment.routeKey;
        if (it != 0) {
            TIntArrayList ids = new TIntArrayList();
            for (int i = lst.size() - 1; i > 0 && i > lst.size() - 50; --i) {
                ids.add((int)(((NetworkRouteContext.NetworkRouteSegment)lst.get(i)).getId() >> 7));
            }
            String msg = "Route likely has a loop: " + routeKey + " iterations " + it + " ids " + ids;
            System.err.println(msg);
        }
        NetworkRouteSegmentChain ch = new NetworkRouteSegmentChain();
        ch.start = (NetworkRouteContext.NetworkRouteSegment)lst.get(0);
        ch.connected = lst.subList(1, lst.size());
        res.put(routeKey, this.createGpxFile(Collections.singletonList(ch), routeKey));
        this.debug("FINISH " + lst.size(), null, segment);
    }

    private void debug(String msg, Boolean reverse, NetworkRouteContext.NetworkRouteSegment ld) {
        System.out.println(msg + (Serializable)(reverse == null ? "" : Character.valueOf(reverse != false ? (char)'-' : '+')) + " " + ld);
    }

    private boolean grow(List<NetworkRouteContext.NetworkRouteSegment> lst, TLongHashSet visitedIds, boolean reverse, boolean approximate) throws IOException {
        int lastInd = lst.size() - 1;
        NetworkRouteContext.NetworkRouteSegment obj = lst.get(lastInd);
        List<NetworkRouteContext.NetworkRouteSegment> objs = approximate ? this.rCtx.loadNearRouteSegment(obj.getEndPointX(), obj.getEndPointY(), 30.0) : this.rCtx.loadRouteSegment(obj.getEndPointX(), obj.getEndPointY());
        for (NetworkRouteContext.NetworkRouteSegment ld : objs) {
            this.debug("  CHECK", reverse, ld);
            if (!ld.routeKey.equals(obj.routeKey) || visitedIds.contains(ld.getId())) continue;
            if (visitedIds.add(ld.getId())) {
                this.debug(">ACCEPT", reverse, ld);
                lst.add(ld);
                return true;
            }
            return false;
        }
        return false;
    }

    private GPXFile createGpxFile(List<NetworkRouteSegmentChain> chains, RouteKey routeKey) {
        GPXFile gpxFile = new GPXFile(null, null, null);
        GPXUtilities.Track track = new GPXUtilities.Track();
        ArrayList<Integer> sizes = new ArrayList<Integer>();
        for (NetworkRouteSegmentChain c : chains) {
            ArrayList<NetworkRouteContext.NetworkRouteSegment> segmentList = new ArrayList<NetworkRouteContext.NetworkRouteSegment>();
            segmentList.add(c.start);
            if (c.connected != null) {
                segmentList.addAll(c.connected);
            }
            GPXUtilities.TrkSegment trkSegment = new GPXUtilities.TrkSegment();
            track.segments.add(trkSegment);
            int l = 0;
            GPXUtilities.WptPt prev = null;
            block1: for (NetworkRouteContext.NetworkRouteSegment segment : segmentList) {
                float[] heightArray = null;
                if (segment.robj != null) {
                    heightArray = segment.robj.calculateHeightArray();
                }
                int inc = segment.start < segment.end ? 1 : -1;
                int i = segment.start;
                while (true) {
                    GPXUtilities.WptPt point = new GPXUtilities.WptPt();
                    point.lat = MapUtils.get31LatitudeY(segment.getPoint31YTile(i));
                    point.lon = MapUtils.get31LongitudeX(segment.getPoint31XTile(i));
                    if (heightArray != null && heightArray.length > i * 2 + 1) {
                        point.ele = heightArray[i * 2 + 1];
                    }
                    trkSegment.points.add(point);
                    if (prev != null) {
                        l = (int)((double)l + MapUtils.getDistance(prev.lat, prev.lon, point.lat, point.lon));
                    }
                    prev = point;
                    if (i == segment.end) continue block1;
                    i += inc;
                }
            }
            sizes.add(l);
        }
        System.out.println(String.format("Segments size %d: %s", track.segments.size(), ((Object)sizes).toString()));
        gpxFile.tracks.add(track);
        gpxFile.addRouteKeyTags(routeKey.tagsToGpx());
        return gpxFile;
    }

    public static class NetworkRouteSelectorFilter {
        public Set<RouteKey> keyFilter = null;
        public Set<OsmRouteType> typeFilter = null;

        public List<RouteKey> convert(BinaryMapDataObject obj) {
            return this.filterKeys(OsmRouteType.getRouteKeys(obj));
        }

        public List<RouteKey> convert(RouteDataObject obj) {
            return this.filterKeys(OsmRouteType.getRouteKeys(obj));
        }

        private List<RouteKey> filterKeys(List<RouteKey> keys) {
            if (this.keyFilter == null && this.typeFilter == null) {
                return keys;
            }
            Iterator<RouteKey> it = keys.iterator();
            while (it.hasNext()) {
                RouteKey key = it.next();
                if (this.keyFilter != null && !this.keyFilter.contains(key)) {
                    it.remove();
                    continue;
                }
                if (this.typeFilter == null || this.typeFilter.contains(key.type)) continue;
                it.remove();
            }
            return keys;
        }
    }

    public static interface INetworkRouteSelection {
        public boolean isCancelled();
    }

    public static class RouteKey {
        public final OsmRouteType type;
        public final Set<String> tags = new TreeSet<String>();

        public RouteKey(OsmRouteType routeType) {
            this.type = routeType;
        }

        public String getValue(String key) {
            key = NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + (String)key + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR;
            for (String tag : this.tags) {
                int i = tag.indexOf((String)key);
                if (i <= 0) continue;
                return tag.substring(i + ((String)key).length());
            }
            return "";
        }

        public String getKeyFromTag(String tag) {
            String prefix = "route_" + this.type.getName() + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR;
            if (tag.startsWith(prefix) && tag.length() > prefix.length()) {
                int endIdx = tag.indexOf(NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR, prefix.length());
                return tag.substring(prefix.length(), endIdx);
            }
            return "";
        }

        public void addTag(String key, String value) {
            value = Algorithms.isEmpty((CharSequence)value) ? "" : NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + (String)value;
            this.tags.add("route_" + this.type.getName() + NetworkRouteSelector.ROUTE_KEY_VALUE_SEPARATOR + key + (String)value);
        }

        public String getRouteName() {
            return this.getRouteName(null);
        }

        public String getRouteName(String localeId) {
            return this.getRouteName(localeId, false);
        }

        public String getRouteName(String localeId, boolean transliteration) {
            String name;
            if (localeId != null && !(name = this.getValue("name:" + localeId)).isEmpty()) {
                return name;
            }
            name = this.getValue("name");
            if (!name.isEmpty()) {
                return transliteration ? TransliterationHelper.transliterate(name) : name;
            }
            name = this.getValue("ref");
            return !name.isEmpty() ? name : this.getRelationID();
        }

        public String getRelationID() {
            return this.getValue("relation_id");
        }

        public String getNetwork() {
            return this.getValue("network");
        }

        public String getOperator() {
            return this.getValue("operator");
        }

        public String getSymbol() {
            return this.getValue("symbol");
        }

        public String getWebsite() {
            return this.getValue("website");
        }

        public String getWikipedia() {
            return this.getValue("wikipedia");
        }

        public static RouteKey fromGpx(Map<String, String> networkRouteKeyTags) {
            OsmRouteType routeType;
            String type = networkRouteKeyTags.get(NetworkRouteSelector.NETWORK_ROUTE_TYPE);
            if (!Algorithms.isEmpty(type) && (routeType = OsmRouteType.getByTag(type)) != null) {
                RouteKey routeKey = new RouteKey(routeType);
                for (Map.Entry<String, String> tag : networkRouteKeyTags.entrySet()) {
                    routeKey.addTag(tag.getKey(), tag.getValue());
                }
                return routeKey;
            }
            return null;
        }

        public Map<String, String> tagsToGpx() {
            HashMap<String, String> networkRouteKey = new HashMap<String, String>();
            networkRouteKey.put(NetworkRouteSelector.NETWORK_ROUTE_TYPE, this.type.getName());
            for (String tag : this.tags) {
                String key = this.getKeyFromTag(tag);
                String value = this.getValue(key);
                if (Algorithms.isEmpty(value)) continue;
                networkRouteKey.put(key, value);
            }
            return networkRouteKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.tags.hashCode();
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RouteKey other = (RouteKey)obj;
            if (!this.tags.equals(other.tags)) {
                return false;
            }
            return this.type == other.type;
        }

        public String toString() {
            return "Route [type=" + this.type + ", set=" + this.tags + "]";
        }
    }

    public static class NetworkRouteSegmentChain {
        NetworkRouteContext.NetworkRouteSegment start;
        List<NetworkRouteContext.NetworkRouteSegment> connected;

        public int getSize() {
            return 1 + (this.connected == null ? 0 : this.connected.size());
        }

        public NetworkRouteContext.NetworkRouteSegment getLast() {
            if (this.connected != null && this.connected.size() > 0) {
                return this.connected.get(this.connected.size() - 1);
            }
            return this.start;
        }

        public int getEndPointX() {
            return this.getLast().getEndPointX();
        }

        public int getEndPointY() {
            return this.getLast().getEndPointY();
        }

        public void addChain(NetworkRouteSegmentChain toAdd) {
            if (this.connected == null) {
                this.connected = new ArrayList<NetworkRouteContext.NetworkRouteSegment>();
            }
            this.connected.add(toAdd.start);
            if (toAdd.connected != null) {
                this.connected.addAll(toAdd.connected);
            }
        }

        public void setStart(NetworkRouteContext.NetworkRouteSegment newStart) {
            this.start = newStart;
        }

        public void setEnd(NetworkRouteContext.NetworkRouteSegment newEnd) {
            if (this.connected != null && this.connected.size() > 0) {
                this.connected.remove(this.connected.size() - 1);
                this.connected.add(newEnd);
            } else {
                this.start = newEnd;
            }
        }
    }
}

