/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.network;

import gnu.trove.list.array.TIntArrayList;
import gnu.trove.map.TLongObjectMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.network.NetworkRouteSelector;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class NetworkRouteContext {
    public static final int ZOOM_TO_LOAD_TILES = 15;
    public static final int ZOOM_TO_LOAD_TILES_SHIFT_L = 16;
    public static final int ZOOM_TO_LOAD_TILES_SHIFT_R = 16;
    private final TLongObjectHashMap<NetworkRoutesTile> indexedTiles = new TLongObjectHashMap();
    private final NetworkRouteSelector.NetworkRouteSelectorFilter filter;
    private final Map<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> readers = new LinkedHashMap<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>>();
    private final Map<BinaryMapRouteReaderAdapter.RouteSubregion, List<RouteDataObject>> loadedSubregions = new HashMap<BinaryMapRouteReaderAdapter.RouteSubregion, List<RouteDataObject>>();
    private final boolean routing;
    private NetworkRouteContextStats stats;

    public NetworkRouteContext(BinaryMapIndexReader[] readers, NetworkRouteSelector.NetworkRouteSelectorFilter filter, boolean routing) {
        this.filter = filter;
        this.routing = routing;
        this.stats = new NetworkRouteContextStats();
        for (BinaryMapIndexReader r : readers) {
            if (!routing) {
                this.readers.put(r, null);
                continue;
            }
            ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = new ArrayList<BinaryMapRouteReaderAdapter.RouteSubregion>();
            for (BinaryMapRouteReaderAdapter.RouteRegion rInd : r.getRoutingIndexes()) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregs = rInd.getSubregions();
                for (BinaryMapRouteReaderAdapter.RouteSubregion rs : subregs) {
                    subregions.add(new BinaryMapRouteReaderAdapter.RouteSubregion(rs));
                }
            }
            this.readers.put(r, subregions);
        }
    }

    public static long convertPointToLong(int x31, int y31) {
        return ((long)x31 << 32) + (long)y31;
    }

    public static int getXFromLong(long l) {
        return (int)(l >> 32);
    }

    public static int getYFromLong(long l) {
        return (int)(l - (l >> 32 << 32));
    }

    Map<NetworkRouteSelector.RouteKey, List<NetworkRouteSegment>> loadRouteSegmentsBbox(int x31L, int y31T, int x31R, int y31B, NetworkRouteSelector.RouteKey rKey) throws IOException {
        LinkedHashMap<NetworkRouteSelector.RouteKey, List<NetworkRouteSegment>> map = new LinkedHashMap<NetworkRouteSelector.RouteKey, List<NetworkRouteSegment>>();
        int left = x31L >> 16;
        int right = x31R >> 16;
        int top = y31T >> 16;
        int bottom = y31B >> 16;
        for (int x = left; x <= right; ++x) {
            for (int y = top; y <= bottom; ++y) {
                this.loadRouteSegmentIntersectingTile(x, y, rKey, map);
            }
        }
        return map;
    }

    Map<NetworkRouteSelector.RouteKey, List<NetworkRouteSegment>> loadRouteSegmentIntersectingTile(int x, int y, NetworkRouteSelector.RouteKey routeKey, Map<NetworkRouteSelector.RouteKey, List<NetworkRouteSegment>> map) throws IOException {
        NetworkRoutesTile osmcRoutesTile = this.getMapRouteTile(x << 16, y << 16);
        for (NetworkRouteSegment segment : osmcRoutesTile.uniqueSegments.values()) {
            if (this.loadOnlyRouteWithKey(routeKey) && !segment.routeKey.equals(routeKey)) continue;
            List<NetworkRouteSegment> routeSegments = map.get(segment.routeKey);
            if (routeSegments == null) {
                routeSegments = new ArrayList<NetworkRouteSegment>();
                map.put(segment.routeKey, routeSegments);
            }
            routeSegments.add(segment);
        }
        return map;
    }

    boolean loadOnlyRouteWithKey(NetworkRouteSelector.RouteKey rKey) {
        return rKey != null;
    }

    public List<NetworkRouteSegment> loadNearRouteSegment(int x31, int y31, double radius) throws IOException {
        ArrayList<NetworkRoutePoint> nearPoints = new ArrayList<NetworkRoutePoint>();
        NetworkRoutesTile osmcRoutesTile = this.getMapRouteTile(x31, y31);
        double sqrRadius = radius * radius;
        for (NetworkRoutePoint pnt : osmcRoutesTile.getRoutes().valueCollection()) {
            double dist = MapUtils.squareDist31TileMetric(pnt.x31, pnt.y31, x31, y31);
            if (!(dist < sqrRadius)) continue;
            pnt.localVar = dist;
            nearPoints.add(pnt);
        }
        Collections.sort(nearPoints, new Comparator<NetworkRoutePoint>(){

            @Override
            public int compare(NetworkRoutePoint o1, NetworkRoutePoint o2) {
                return Double.compare(o1.localVar, o2.localVar);
            }
        });
        if (nearPoints.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<NetworkRouteSegment> objs = new ArrayList<NetworkRouteSegment>();
        for (NetworkRoutePoint pnt : nearPoints) {
            objs.addAll(pnt.objects);
        }
        return objs;
    }

    public List<NetworkRouteSegment> loadRouteSegment(int x31, int y31) throws IOException {
        NetworkRoutesTile osmcRoutesTile = this.getMapRouteTile(x31, y31);
        NetworkRoutePoint point = osmcRoutesTile.getRouteSegment(x31, y31);
        if (point == null) {
            return Collections.emptyList();
        }
        return point.objects;
    }

    public NetworkRoutePoint getClosestNetworkRoutePoint(int sx31, int sy31) throws IOException {
        NetworkRoutesTile osmcRoutesTile = this.getMapRouteTile(sx31, sy31);
        double minDistance = Double.MAX_VALUE;
        NetworkRoutePoint nearPoint = null;
        for (NetworkRoutePoint pt : osmcRoutesTile.routes.valueCollection()) {
            double distance = MapUtils.squareRootDist31(sx31, sy31, pt.x31, pt.y31);
            if (!(distance < minDistance)) continue;
            nearPoint = pt;
            minDistance = distance;
        }
        return nearPoint;
    }

    private NetworkRoutesTile getMapRouteTile(int x31, int y31) throws IOException {
        long tileId = NetworkRouteContext.getTileId(x31, y31);
        NetworkRoutesTile tile = (NetworkRoutesTile)this.indexedTiles.get(tileId);
        if (tile == null) {
            tile = this.loadTile(x31 >> 16, y31 >> 16, tileId);
            this.indexedTiles.put(tileId, (Object)tile);
        }
        return tile;
    }

    public boolean isRouting() {
        return this.routing;
    }

    private NetworkRoutesTile loadTile(int x, int y, long tileId) throws IOException {
        ++this.stats.loadedTiles;
        if (this.routing) {
            BinaryMapIndexReader.SearchRequest<RouteDataObject> req = BinaryMapIndexReader.buildSearchRouteRequest(x << 16, x + 1 << 16, y << 16, y + 1 << 16, null);
            req.log = false;
            return this.loadRoutingDataTile(req, tileId);
        }
        BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req = BinaryMapIndexReader.buildSearchRequest(x << 16, x + 1 << 16, y << 16, y + 1 << 16, 15, new BinaryMapIndexReader.SearchFilter(){

            @Override
            public boolean accept(TIntArrayList types, BinaryMapIndexReader.MapIndex index) {
                return true;
            }
        }, null);
        req.log = false;
        return this.loadMapDataTile(req, tileId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkRoutesTile loadRoutingDataTile(BinaryMapIndexReader.SearchRequest<RouteDataObject> req, long tileId) throws IOException {
        NetworkRoutesTile osmcRoutesTile = new NetworkRoutesTile(tileId);
        HashSet<Long> deletedIds = new HashSet<Long>();
        HashMap<Long, BinaryMapRouteReaderAdapter.RouteRegion> usedIds = new HashMap<Long, BinaryMapRouteReaderAdapter.RouteRegion>();
        for (Map.Entry<BinaryMapIndexReader, List<BinaryMapRouteReaderAdapter.RouteSubregion>> readerSubregions : this.readers.entrySet()) {
            BinaryMapIndexReader reader;
            req.clearSearchResults();
            long nt = System.nanoTime();
            BinaryMapIndexReader binaryMapIndexReader = reader = readerSubregions.getKey();
            synchronized (binaryMapIndexReader) {
                List<BinaryMapRouteReaderAdapter.RouteSubregion> routeSubregions = readerSubregions.getValue();
                List<BinaryMapRouteReaderAdapter.RouteSubregion> subregions = reader.searchRouteIndexTree(req, routeSubregions);
                this.stats.loadTimeNs += System.nanoTime() - nt;
                for (BinaryMapRouteReaderAdapter.RouteSubregion sub : subregions) {
                    List<RouteDataObject> objects = this.loadedSubregions.get(sub);
                    if (objects == null) {
                        nt = System.nanoTime();
                        objects = reader.loadRouteIndexData(sub);
                        this.loadedSubregions.put(sub, objects);
                        this.stats.loadTimeNs += System.nanoTime() - nt;
                    }
                    for (RouteDataObject obj : objects) {
                        if (obj == null || deletedIds.contains(obj.id)) continue;
                        if (obj.isRoadDeleted()) {
                            deletedIds.add(obj.id);
                            continue;
                        }
                        if (usedIds.containsKey(obj.id) && usedIds.get(obj.id) != obj.region) continue;
                        ++this.stats.loadedObjects;
                        List<NetworkRouteSelector.RouteKey> keys = this.filter.convert(obj);
                        for (NetworkRouteSelector.RouteKey rk : keys) {
                            ++this.stats.loadedRoutes;
                            osmcRoutesTile.add(obj, rk);
                        }
                        usedIds.put(obj.id, obj.region);
                    }
                }
            }
        }
        return osmcRoutesTile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NetworkRoutesTile loadMapDataTile(BinaryMapIndexReader.SearchRequest<BinaryMapDataObject> req, long tileId) throws IOException {
        NetworkRoutesTile osmcRoutesTile = new NetworkRoutesTile(tileId);
        for (BinaryMapIndexReader reader : this.readers.keySet()) {
            req.clearSearchResults();
            long nt = System.nanoTime();
            BinaryMapIndexReader binaryMapIndexReader = reader;
            synchronized (binaryMapIndexReader) {
                List<BinaryMapDataObject> objects = reader.searchMapIndex(req);
                this.stats.loadTimeNs += System.nanoTime() - nt;
                for (BinaryMapDataObject obj : objects) {
                    ++this.stats.loadedObjects;
                    List<NetworkRouteSelector.RouteKey> keys = this.filter.convert(obj);
                    for (NetworkRouteSelector.RouteKey rk : keys) {
                        ++this.stats.loadedRoutes;
                        osmcRoutesTile.add(obj, rk);
                    }
                }
            }
        }
        return osmcRoutesTile;
    }

    public static int getXFromTileId(long tileId) {
        return (int)(tileId >> 16);
    }

    public static int getYFromTileId(long tileId) {
        long xShifted = tileId >> 16;
        return (int)(tileId - (xShifted << 16));
    }

    public static long getTileId(int x31, int y31) {
        return NetworkRouteContext.getTileId(x31, y31, 16);
    }

    public static long getTileId(int x, int y, int shiftR) {
        return ((long)x >> shiftR << 16) + (long)(y >> shiftR);
    }

    public NetworkRouteContextStats getStats() {
        return this.stats;
    }

    public void clearData() {
        this.indexedTiles.clear();
        this.loadedSubregions.clear();
        this.stats = new NetworkRouteContextStats();
    }

    public void clearStats() {
        this.stats = new NetworkRouteContextStats();
    }

    public static class NetworkRouteContextStats {
        public int loadedTiles;
        public int loadedObjects;
        public int loadedRoutes;
        public long loadTimeNs;
    }

    private static class NetworkRoutesTile {
        private final TLongObjectMap<NetworkRoutePoint> routes = new TLongObjectHashMap();
        private final Map<String, NetworkRouteSegment> uniqueSegments = new HashMap<String, NetworkRouteSegment>();
        private final long tileId;

        public NetworkRoutesTile(long tileId) {
            this.tileId = tileId;
        }

        public void add(BinaryMapDataObject obj, NetworkRouteSelector.RouteKey rk) {
            int len = obj.getPointsLength();
            boolean intersects = false;
            int px = 0;
            int py = 0;
            for (int i = 0; i < len; ++i) {
                int x31 = obj.getPoint31XTile(i);
                int y31 = obj.getPoint31YTile(i);
                boolean bl = intersects = intersects || i > 0 && this.intersects(x31, y31, px, py);
                if (NetworkRouteContext.getTileId(x31, y31) != this.tileId) {
                    px = x31;
                    py = y31;
                    continue;
                }
                intersects = true;
                long id = NetworkRouteContext.convertPointToLong(x31, y31);
                NetworkRoutePoint point = (NetworkRoutePoint)this.routes.get(id);
                if (point == null) {
                    point = new NetworkRoutePoint(x31, y31, id);
                    this.routes.put(id, (Object)point);
                }
                if (i > 0) {
                    point.addObject(new NetworkRouteSegment(obj, rk, i, 0));
                }
                if (i >= len - 1) continue;
                point.addObject(new NetworkRouteSegment(obj, rk, i, len - 1));
            }
            if (intersects) {
                this.addUnique(new NetworkRouteSegment(obj, rk, 0, len - 1));
            }
        }

        private void addUnique(NetworkRouteSegment networkRouteSegment) {
            this.uniqueSegments.put(networkRouteSegment.routeKey + "_" + networkRouteSegment.getId(), networkRouteSegment);
        }

        public void add(RouteDataObject obj, NetworkRouteSelector.RouteKey rk) {
            int len = obj.getPointsLength();
            boolean intersects = false;
            int px = 0;
            int py = 0;
            for (int i = 0; i < len; ++i) {
                int x31 = obj.getPoint31XTile(i);
                int y31 = obj.getPoint31YTile(i);
                boolean bl = intersects = intersects || i > 0 && this.intersects(x31, y31, px, py);
                if (NetworkRouteContext.getTileId(x31, y31) != this.tileId) {
                    px = x31;
                    py = y31;
                    continue;
                }
                long id = NetworkRouteContext.convertPointToLong(x31, y31);
                NetworkRoutePoint point = (NetworkRoutePoint)this.routes.get(id);
                if (point == null) {
                    point = new NetworkRoutePoint(x31, y31, id);
                    this.routes.put(id, (Object)point);
                }
                if (i > 0) {
                    point.addObject(new NetworkRouteSegment(obj, rk, i, 0));
                }
                if (i < len - 1) {
                    point.addObject(new NetworkRouteSegment(obj, rk, i, len - 1));
                }
                px = x31;
                py = y31;
            }
            if (intersects) {
                this.addUnique(new NetworkRouteSegment(obj, rk, 0, len - 1));
            }
        }

        private boolean intersects(int x31, int y31, int px, int py) {
            long currentTile = NetworkRouteContext.getTileId(x31, y31);
            long previousTile = NetworkRouteContext.getTileId(px, py);
            if (currentTile == this.tileId || previousTile == this.tileId) {
                return true;
            }
            if (currentTile == previousTile) {
                return false;
            }
            int xprevTile = NetworkRouteContext.getXFromTileId(previousTile);
            int yprevTile = NetworkRouteContext.getYFromTileId(previousTile);
            int xcurrTile = NetworkRouteContext.getXFromTileId(currentTile);
            int ycurrTile = NetworkRouteContext.getYFromTileId(currentTile);
            if (ycurrTile == yprevTile && Math.abs(xcurrTile - xprevTile) <= 1 || xcurrTile == xprevTile && Math.abs(ycurrTile - yprevTile) <= 1) {
                return false;
            }
            if (Math.abs(x31 - px) <= 2 && Math.abs(y31 - py) <= 2) {
                return false;
            }
            if (this.intersects(x31, y31, x31 / 2 + px / 2, y31 / 2 + py / 2)) {
                return true;
            }
            return this.intersects(px, py, x31 / 2 + px / 2, y31 / 2 + py / 2);
        }

        public TLongObjectMap<NetworkRoutePoint> getRoutes() {
            return this.routes;
        }

        public NetworkRoutePoint getRouteSegment(int x31, int y31) {
            if (NetworkRouteContext.getTileId(x31, y31) != this.tileId) {
                System.err.println(String.format("Wrong tile id !!! %d != %d", NetworkRouteContext.getTileId(x31, y31), this.tileId));
            }
            return (NetworkRoutePoint)this.routes.get(NetworkRouteContext.convertPointToLong(x31, y31));
        }
    }

    public static class NetworkRouteSegment {
        public final int start;
        public final int end;
        public final BinaryMapDataObject obj;
        public final RouteDataObject robj;
        public final NetworkRouteSelector.RouteKey routeKey;

        public NetworkRouteSegment(BinaryMapDataObject obj, NetworkRouteSelector.RouteKey routeKey, int start, int end) {
            this.robj = null;
            this.obj = obj;
            this.start = start;
            this.end = end;
            this.routeKey = routeKey;
        }

        public NetworkRouteSegment(NetworkRouteSegment segment, int start, int end) {
            this.robj = segment.robj;
            this.obj = segment.obj;
            this.start = start;
            this.end = end;
            this.routeKey = segment.routeKey;
        }

        public NetworkRouteSegment(RouteDataObject obj, NetworkRouteSelector.RouteKey routeKey, int start, int end) {
            this.robj = obj;
            this.obj = null;
            this.start = start;
            this.end = end;
            this.routeKey = routeKey;
        }

        public boolean direction() {
            return this.end > this.start;
        }

        public long getId() {
            if (this.robj != null) {
                return this.robj.getId();
            }
            return this.obj.getId();
        }

        public int getPointsLength() {
            if (this.robj != null) {
                return this.robj.getPointsLength();
            }
            return this.obj.getPointsLength();
        }

        public int getPoint31XTile(int i) {
            if (this.robj != null) {
                return this.robj.getPoint31XTile(i);
            }
            return this.obj.getPoint31XTile(i);
        }

        public int getPoint31YTile(int i) {
            if (this.robj != null) {
                return this.robj.getPoint31YTile(i);
            }
            return this.obj.getPoint31YTile(i);
        }

        public String getRouteName() {
            String name = this.routeKey.getValue("name");
            if (name.isEmpty()) {
                name = this.routeKey.getValue("ref");
            }
            if (!name.isEmpty()) {
                return name;
            }
            if (this.robj != null) {
                return this.robj.getName();
            }
            return this.obj.getName();
        }

        public int getStartPointX() {
            return this.getPoint31XTile(this.start);
        }

        public int getStartPointY() {
            return this.getPoint31YTile(this.start);
        }

        public int getEndPointX() {
            return this.getPoint31XTile(this.end);
        }

        public int getEndPointY() {
            return this.getPoint31YTile(this.end);
        }

        public String toString() {
            return "NetworkRouteObject [start=" + this.start + ", end=" + this.end + ", obj=" + (this.robj != null ? this.robj : this.obj) + ", routeKey=" + this.routeKey + "]";
        }

        public NetworkRouteSegment inverse() {
            return new NetworkRouteSegment(this, this.end, this.start);
        }
    }

    public static class NetworkRoutePoint {
        public final int x31;
        public final int y31;
        public final long id;
        public final List<NetworkRouteSegment> objects = new ArrayList<NetworkRouteSegment>();
        public double localVar;

        public NetworkRoutePoint(int x31, int y31, long id) {
            this.x31 = x31;
            this.y31 = y31;
            this.id = id;
        }

        public void addObject(NetworkRouteSegment obj) {
            if (obj.getId() > 0L) {
                for (NetworkRouteSegment obj2 : this.objects) {
                    if (obj.getId() != obj2.getId() || obj.direction() != obj2.direction() || !Algorithms.objectEquals(obj.routeKey, obj2.routeKey)) continue;
                    return;
                }
            }
            this.objects.add(obj);
        }
    }
}

