/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.LocationsHolder;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPointDouble;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GeneralRouter;
import net.osmand.router.GpxRouteApproximation;
import net.osmand.router.HHRouteDataStructure;
import net.osmand.router.HHRoutePlanner;
import net.osmand.router.MissingMapsCalculator;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.router.TurnType;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RoutePlannerFrontEnd {
    protected static final Log log = PlatformUtil.getLog(RoutePlannerFrontEnd.class);
    protected static final double GPS_POSSIBLE_ERROR = 7.0;
    public static boolean CALCULATE_MISSING_MAPS = true;
    static boolean TRACE_ROUTING = false;
    private boolean useSmartRouteRecalculation = true;
    private boolean useGeometryBasedApproximation = false;
    private boolean useNativeApproximation = true;
    private boolean useOnlyHHRouting = false;
    private HHRouteDataStructure.HHRoutingConfig hhRoutingConfig = null;
    private HHRoutingType hhRoutingType = HHRoutingType.JAVA;

    public static HHRouteDataStructure.HHRoutingConfig defaultHHConfig() {
        return HHRouteDataStructure.HHRoutingConfig.astar(0).calcDetailed(3);
    }

    public void setHHRouteCpp(boolean cpp) {
        this.hhRoutingType = cpp ? HHRoutingType.CPP : HHRoutingType.JAVA;
    }

    public RoutingContext buildRoutingContext(RoutingConfiguration config, NativeLibrary nativeLibrary, BinaryMapIndexReader[] map, RouteCalculationMode rm) {
        if (rm == null) {
            rm = config.router.getProfile() == GeneralRouter.GeneralRouterProfile.CAR ? RouteCalculationMode.COMPLEX : RouteCalculationMode.NORMAL;
        }
        return new RoutingContext(config, nativeLibrary, map, rm);
    }

    public RoutingContext buildRoutingContext(RoutingConfiguration config, NativeLibrary nativeLibrary, BinaryMapIndexReader[] map) {
        return this.buildRoutingContext(config, nativeLibrary, map, null);
    }

    public static double squareDist(int x1, int y1, int x2, int y2) {
        return MapUtils.squareDist31TileMetric(x1, y1, x2, y2);
    }

    public BinaryRoutePlanner.RouteSegmentPoint findRouteSegment(double lat, double lon, RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> list) throws IOException {
        return this.findRouteSegment(lat, lon, ctx, list, false);
    }

    public BinaryRoutePlanner.RouteSegmentPoint findRouteSegment(double lat, double lon, RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> list, boolean transportStop) throws IOException {
        return this.findRouteSegment(lat, lon, ctx, list, false, false);
    }

    public BinaryRoutePlanner.RouteSegmentPoint findRouteSegment(double lat, double lon, RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> list, boolean transportStop, boolean allowDuplications) throws IOException {
        long now = System.nanoTime();
        int px = MapUtils.get31TileNumberX(lon);
        int py = MapUtils.get31TileNumberY(lat);
        ArrayList<RouteDataObject> dataObjects = new ArrayList<RouteDataObject>();
        ctx.loadTileData(px, py, 17, dataObjects, allowDuplications);
        if (dataObjects.isEmpty()) {
            ctx.loadTileData(px, py, 15, dataObjects, allowDuplications);
        }
        if (dataObjects.isEmpty()) {
            ctx.loadTileData(px, py, 14, dataObjects, allowDuplications);
        }
        if (list == null) {
            list = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
        }
        for (RouteDataObject r : dataObjects) {
            if (r.getPointsLength() <= 1) continue;
            BinaryRoutePlanner.RouteSegmentPoint road = null;
            for (int j = 1; j < r.getPointsLength(); ++j) {
                QuadPointDouble pr = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(j - 1), r.getPoint31YTile(j - 1), r.getPoint31XTile(j), r.getPoint31YTile(j));
                double currentsDistSquare = RoutePlannerFrontEnd.squareDist((int)pr.x, (int)pr.y, px, py);
                if (road != null && !(currentsDistSquare < road.distToProj)) continue;
                RouteDataObject ro = new RouteDataObject(r);
                road = new BinaryRoutePlanner.RouteSegmentPoint(ro, j - 1, j, currentsDistSquare);
                road.preciseX = (int)pr.x;
                road.preciseY = (int)pr.y;
            }
            if (road == null) continue;
            if (!transportStop) {
                float prio = ctx.getRouter().defineDestinationPriority(road.road);
                if (!(prio > 0.0f)) continue;
                road.distToProj = (road.distToProj + 49.0) / (double)(prio * prio);
                list.add(road);
                continue;
            }
            list.add(road);
        }
        Collections.sort(list, new Comparator<BinaryRoutePlanner.RouteSegmentPoint>(){

            @Override
            public int compare(BinaryRoutePlanner.RouteSegmentPoint o1, BinaryRoutePlanner.RouteSegmentPoint o2) {
                return Double.compare(o1.distToProj, o2.distToProj);
            }
        });
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.timeToFindInitialSegments += System.nanoTime() - now;
        }
        if (list.size() > 0) {
            BinaryRoutePlanner.RouteSegmentPoint ps = null;
            if (ctx.publicTransport) {
                for (BinaryRoutePlanner.RouteSegmentPoint p : list) {
                    if (transportStop && p.distToProj > 49.0) break;
                    boolean platform = p.road.platform();
                    if (transportStop && platform) {
                        ps = p;
                        break;
                    }
                    if (transportStop || platform) continue;
                    ps = p;
                    break;
                }
            }
            if (ps == null) {
                ps = list.get(0);
            }
            list.remove(ps);
            ps.others = list;
            return ps;
        }
        return null;
    }

    public RouteResultPreparation.RouteCalcResult searchRoute(RoutingContext ctx, LatLon start, LatLon end, List<LatLon> intermediates) throws IOException, InterruptedException {
        return this.searchRoute(ctx, start, end, intermediates, null);
    }

    public RoutePlannerFrontEnd setUseFastRecalculation(boolean use) {
        this.useSmartRouteRecalculation = use;
        return this;
    }

    public RoutePlannerFrontEnd setHHRoutingConfig(HHRouteDataStructure.HHRoutingConfig hhRoutingConfig) {
        this.hhRoutingConfig = hhRoutingConfig;
        return this;
    }

    public RoutePlannerFrontEnd disableHHRoutingConfig() {
        this.hhRoutingConfig = null;
        return this;
    }

    public boolean isHHRoutingConfigured() {
        return this.hhRoutingConfig != null;
    }

    public void setDefaultHHRoutingConfig() {
        this.hhRoutingConfig = RoutePlannerFrontEnd.defaultHHConfig();
    }

    public RoutePlannerFrontEnd setUseOnlyHHRouting(boolean useOnlyHHRouting) {
        this.useOnlyHHRouting = useOnlyHHRouting;
        if (useOnlyHHRouting && this.hhRoutingConfig == null) {
            this.hhRoutingConfig = RoutePlannerFrontEnd.defaultHHConfig();
        }
        return this;
    }

    public RoutePlannerFrontEnd setUseNativeApproximation(boolean useNativeApproximation) {
        this.useNativeApproximation = useNativeApproximation;
        return this;
    }

    public RoutePlannerFrontEnd setUseGeometryBasedApproximation(boolean enabled) {
        this.useGeometryBasedApproximation = enabled;
        return this;
    }

    public boolean isUseNativeApproximation() {
        return this.useNativeApproximation;
    }

    public boolean isUseGeometryBasedApproximation() {
        return this.useGeometryBasedApproximation;
    }

    public GpxRouteApproximation searchGpxRoute(GpxRouteApproximation gctx, List<GpxPoint> gpxPoints, ResultMatcher<GpxRouteApproximation> resultMatcher, boolean useExternalTimestamps) throws IOException, InterruptedException {
        if (!this.isUseNativeApproximation()) {
            gctx.ctx.nativeLib = null;
        }
        return gctx.searchGpxRouteInternal(this, gpxPoints, resultMatcher, useExternalTimestamps);
    }

    public static RouteSegmentResult generateStraightLineSegment(float averageSpeed, List<LatLon> points) {
        BinaryMapRouteReaderAdapter.RouteRegion reg = new BinaryMapRouteReaderAdapter.RouteRegion();
        reg.initRouteEncodingRule(0, "highway", "unmatched");
        RouteDataObject rdo = new RouteDataObject(reg);
        int size = points.size();
        TIntArrayList x = new TIntArrayList(size);
        TIntArrayList y = new TIntArrayList(size);
        double distance = 0.0;
        double distOnRoadToPass = 0.0;
        LatLon prev = null;
        for (int i = 0; i < size; ++i) {
            LatLon l = points.get(i);
            if (l != null) {
                x.add(MapUtils.get31TileNumberX(l.getLongitude()));
                y.add(MapUtils.get31TileNumberY(l.getLatitude()));
                if (prev != null) {
                    double d = MapUtils.getDistance(l, prev);
                    distance += d;
                    distOnRoadToPass += d / (double)averageSpeed;
                }
            }
            prev = l;
        }
        rdo.pointsX = x.toArray();
        rdo.pointsY = y.toArray();
        rdo.types = new int[]{0};
        rdo.id = -1L;
        RouteSegmentResult segment = new RouteSegmentResult(rdo, 0, rdo.getPointsLength() - 1);
        segment.setSegmentTime((float)distOnRoadToPass);
        segment.setSegmentSpeed(averageSpeed);
        segment.setDistance((float)distance);
        segment.setTurnType(TurnType.straight());
        return segment;
    }

    public List<GpxPoint> generateGpxPoints(GpxRouteApproximation gctx, LocationsHolder locationsHolder) {
        ArrayList<GpxPoint> gpxPoints = new ArrayList<GpxPoint>(locationsHolder.getSize());
        GpxPoint prev = null;
        ArrayList<LatLon> points = new ArrayList<LatLon>();
        for (int i = 0; i < locationsHolder.getSize(); ++i) {
            points.add(locationsHolder.getLatLon(i));
        }
        RouteDataObject o = RoutePlannerFrontEnd.generateStraightLineSegment(0.0f, points).getObject();
        for (int i = 0; i < points.size(); ++i) {
            GpxPoint p = new GpxPoint();
            p.ind = i;
            p.time = locationsHolder.getTime(i);
            p.loc = locationsHolder.getLatLon(i);
            p.object = o;
            if (prev != null) {
                p.cumDist = MapUtils.getDistance(p.loc, prev.loc) + prev.cumDist;
            }
            gpxPoints.add(p);
            gctx.routeDistance = (int)p.cumDist;
            prev = p;
        }
        return gpxPoints;
    }

    private boolean needRequestPrivateAccessRouting(RoutingContext ctx, List<LatLon> points) throws IOException {
        boolean res = false;
        if (ctx.nativeLib != null) {
            int size = points.size();
            int[] y31Coordinates = new int[size];
            int[] x31Coordinates = new int[size];
            for (int i = 0; i < size; ++i) {
                y31Coordinates[i] = MapUtils.get31TileNumberY(points.get(i).getLatitude());
                x31Coordinates[i] = MapUtils.get31TileNumberX(points.get(i).getLongitude());
            }
            res = ctx.nativeLib.needRequestPrivateAccessRouting(ctx, x31Coordinates, y31Coordinates);
        } else {
            GeneralRouter router = (GeneralRouter)ctx.getRouter();
            if (router == null) {
                return false;
            }
            Map<String, GeneralRouter.RoutingParameter> parameters = router.getParameters();
            String allowPrivateKey = null;
            if (parameters.containsKey("allow_private")) {
                allowPrivateKey = "allow_private";
            } else if (parameters.containsKey("allow_private_for_truck")) {
                allowPrivateKey = "allow_private";
            }
            if (!router.isAllowPrivate() && allowPrivateKey != null) {
                ctx.unloadAllData();
                LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
                mp.put(allowPrivateKey, "true");
                mp.put("check_allow_private_needed", "true");
                ctx.setRouter(new GeneralRouter(router.getProfile(), mp));
                for (LatLon latLon : points) {
                    BinaryRoutePlanner.RouteSegmentPoint rp = this.findRouteSegment(latLon.getLatitude(), latLon.getLongitude(), ctx, null);
                    if (rp == null || rp.road == null || !rp.road.hasPrivateAccess(ctx.config.router.getProfile())) continue;
                    res = true;
                    break;
                }
                ctx.unloadAllData();
                ctx.setRouter(router);
            }
        }
        return res;
    }

    public RouteResultPreparation.RouteCalcResult searchRoute(RoutingContext ctx, LatLon start, LatLon end, List<LatLon> intermediates, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        RouteResultPreparation.RouteCalcResult res;
        MissingMapsCalculator calculator;
        long timeToCalculate = System.nanoTime();
        if (ctx.calculationProgress == null) {
            ctx.calculationProgress = new RouteCalculationProgress();
        }
        boolean intermediatesEmpty = intermediates == null || intermediates.isEmpty();
        ArrayList<LatLon> targets = new ArrayList<LatLon>();
        if (!intermediatesEmpty) {
            targets.addAll(intermediates);
        }
        targets.add(end);
        if (CALCULATE_MISSING_MAPS && (calculator = new MissingMapsCalculator(PlatformUtil.getOsmandRegions())).checkIfThereAreMissingMaps(ctx, start, targets, this.hhRoutingConfig != null)) {
            return new RouteResultPreparation.RouteCalcResult(ctx.calculationProgress.missingMapsCalculationResult.getErrorMessage());
        }
        if (this.needRequestPrivateAccessRouting(ctx, targets)) {
            ctx.calculationProgress.requestPrivateAccessRouting = true;
        }
        if (this.hhRoutingConfig != null && ctx.calculationMode != RouteCalculationMode.BASE) {
            if (ctx.nativeLib == null || this.hhRoutingType == HHRoutingType.JAVA) {
                r = this.runHHRoute(ctx, start, targets);
                if (r != null && r.isCorrect() || this.useOnlyHHRouting) {
                    return r;
                }
            } else {
                this.setStartEndToCtx(ctx, start, end, intermediates);
                ctx.calculationProgress.nextIteration();
                r = this.runNativeRouting(ctx, null, this.hhRoutingConfig);
                ctx.calculationProgress.timeToCalculate = System.nanoTime() - timeToCalculate;
                RouteResultPreparation.printResults(ctx, start, end, r.detailed);
                if (!r.detailed.isEmpty() && r.isCorrect() || this.useOnlyHHRouting) {
                    this.makeStartEndPointsPrecise(ctx, r, start, end, intermediates);
                    return r;
                }
            }
        }
        double maxDistance = MapUtils.getDistance(start, end);
        if (!intermediatesEmpty) {
            LatLon b = start;
            for (LatLon l : intermediates) {
                maxDistance = Math.max(MapUtils.getDistance(b, l), maxDistance);
                b = l;
            }
        }
        if (ctx.calculationMode == RouteCalculationMode.COMPLEX && routeDirection == null && maxDistance > 18000.0) {
            ++ctx.calculationProgress.totalIterations;
            RoutingContext nctx = this.buildRoutingContext(ctx.config, ctx.nativeLib, ctx.getMaps(), RouteCalculationMode.BASE);
            nctx.calculationProgress = ctx.calculationProgress;
            RouteResultPreparation.RouteCalcResult baseRes = this.searchRoute(nctx, start, end, intermediates);
            if (baseRes == null || !baseRes.isCorrect()) {
                return baseRes;
            }
            routeDirection = PrecalculatedRouteDirection.build(baseRes.detailed, 3000.0f, ctx.getRouter().getMaxSpeed());
            ctx.calculationProgressFirstPhase = RouteCalculationProgress.capture(ctx.calculationProgress);
        }
        if (intermediatesEmpty && ctx.nativeLib != null) {
            this.setStartEndToCtx(ctx, start, end, intermediates);
            BinaryRoutePlanner.RouteSegmentPoint recalculationEnd = this.getRecalculationEnd(ctx);
            if (recalculationEnd != null) {
                ctx.initTargetPoint(recalculationEnd);
            }
            if (routeDirection != null) {
                ctx.precalculatedRouteDirection = routeDirection.adopt(ctx);
            }
            ctx.calculationProgress.nextIteration();
            res = this.runNativeRouting(ctx, recalculationEnd, null);
            this.makeStartEndPointsPrecise(ctx, res, start, end, intermediates);
        } else {
            int indexNotFound = 0;
            ArrayList<BinaryRoutePlanner.RouteSegmentPoint> points = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
            if (!this.addSegment(start, ctx, indexNotFound++, points, ctx.startTransportStop)) {
                return new RouteResultPreparation.RouteCalcResult("Start point is not located");
            }
            if (intermediates != null) {
                for (LatLon l : intermediates) {
                    if (this.addSegment(l, ctx, indexNotFound++, points, false)) continue;
                    System.out.println(((BinaryRoutePlanner.RouteSegmentPoint)points.get(points.size() - 1)).getRoad().toString());
                    return new RouteResultPreparation.RouteCalcResult("Intermediate point is not located");
                }
            }
            if (!this.addSegment(end, ctx, indexNotFound++, points, ctx.targetTransportStop)) {
                return new RouteResultPreparation.RouteCalcResult("End point is not located");
            }
            ctx.calculationProgress.nextIteration();
            res = this.searchRouteImpl(ctx, points, routeDirection);
        }
        ctx.calculationProgress.timeToCalculate = System.nanoTime() - timeToCalculate;
        RouteResultPreparation.printResults(ctx, start, end, res.detailed);
        return res;
    }

    private void setStartEndToCtx(RoutingContext ctx, LatLon start, LatLon end, List<LatLon> intermediates) {
        boolean intermediatesEmpty = intermediates == null || intermediates.isEmpty();
        ctx.startX = MapUtils.get31TileNumberX(start.getLongitude());
        ctx.startY = MapUtils.get31TileNumberY(start.getLatitude());
        ctx.targetX = MapUtils.get31TileNumberX(end.getLongitude());
        ctx.targetY = MapUtils.get31TileNumberY(end.getLatitude());
        if (!intermediatesEmpty) {
            ctx.intermediatesX = new int[intermediates.size()];
            ctx.intermediatesY = new int[intermediates.size()];
            for (int i = 0; i < intermediates.size(); ++i) {
                LatLon l = intermediates.get(i);
                ctx.intermediatesX[i] = MapUtils.get31TileNumberX(l.getLongitude());
                ctx.intermediatesY[i] = MapUtils.get31TileNumberY(l.getLatitude());
            }
        } else {
            ctx.intermediatesX = new int[0];
            ctx.intermediatesY = new int[0];
        }
    }

    private HHRouteDataStructure.HHNetworkRouteRes runHHRoute(RoutingContext ctx, LatLon start, List<LatLon> targets) throws IOException, InterruptedException {
        HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint> routePlanner = HHRoutePlanner.create(ctx);
        HHRouteDataStructure.HHNetworkRouteRes r = null;
        Double dir = ctx.config.initialDirection;
        for (int i = 0; i < targets.size(); ++i) {
            double initialPenalty = ctx.config.penaltyForReverseDirection;
            if (i > 0) {
                ctx.config.penaltyForReverseDirection /= 2.0;
            }
            ctx.calculationProgress.hhTargetsProgress(i, targets.size());
            HHRouteDataStructure.HHNetworkRouteRes res = this.calculateHHRoute(routePlanner, ctx, i == 0 ? start : targets.get(i - 1), targets.get(i), dir);
            ctx.config.penaltyForReverseDirection = initialPenalty;
            if (r == null) {
                r = res;
            } else {
                r.append(res);
            }
            if (r == null || !r.isCorrect()) break;
            if (r.detailed.size() <= 0) continue;
            dir = (double)((RouteSegmentResult)r.detailed.get(r.detailed.size() - 1)).getBearingEnd() / 180.0 * Math.PI;
        }
        ctx.unloadAllData();
        ctx.routingTime = r != null ? (float)r.getHHRoutingDetailed() : 0.0f;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HHRouteDataStructure.HHNetworkRouteRes calculateHHRoute(HHRoutePlanner<HHRouteDataStructure.NetworkDBPoint> routePlanner, RoutingContext ctx, LatLon start, LatLon end, Double dir) throws InterruptedException, IOException {
        NativeLibrary nativeLib = ctx.nativeLib;
        ctx.nativeLib = null;
        try {
            HHRouteDataStructure.HHRoutingConfig cfg = HHRoutePlanner.prepareDefaultRoutingConfig(this.hhRoutingConfig);
            cfg.INITIAL_DIRECTION = dir;
            HHRouteDataStructure.HHNetworkRouteRes res = routePlanner.runRouting(start, end, cfg);
            if (res != null && res.error == null) {
                ctx.calculationProgress.hhIteration(RouteCalculationProgress.HHIteration.DONE);
                this.makeStartEndPointsPrecise(ctx, res, start, end, new ArrayList<LatLon>());
                HHRouteDataStructure.HHNetworkRouteRes hHNetworkRouteRes = res;
                return hHNetworkRouteRes;
            }
            ctx.calculationProgress.hhIteration(RouteCalculationProgress.HHIteration.HH_NOT_STARTED);
        }
        catch (SQLException e) {
            throw new IOException(e.getMessage(), e);
        }
        catch (IOException | RuntimeException e) {
            e.printStackTrace();
            if (this.useOnlyHHRouting) {
                HHRouteDataStructure.HHNetworkRouteRes hHNetworkRouteRes = new HHRouteDataStructure.HHNetworkRouteRes("Error during routing calculation : " + e.getMessage());
                return hHNetworkRouteRes;
            }
        }
        finally {
            ctx.nativeLib = nativeLib;
        }
        return null;
    }

    protected void makeStartEndPointsPrecise(RoutingContext ctx, RouteResultPreparation.RouteCalcResult res, LatLon start, LatLon end, List<LatLon> intermediates) {
        if (res.detailed.size() > 0) {
            this.makeSegmentPointPrecise(ctx, res.detailed.get(0), start, true);
            this.makeSegmentPointPrecise(ctx, res.detailed.get(res.detailed.size() - 1), end, false);
        }
    }

    protected double projectDistance(List<RouteSegmentResult> res, int k, int px, int py) {
        RouteSegmentResult sr = res.get(k);
        RouteDataObject r = sr.getObject();
        QuadPointDouble pp = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(sr.getStartPointIndex()), r.getPoint31YTile(sr.getStartPointIndex()), r.getPoint31XTile(sr.getEndPointIndex()), r.getPoint31YTile(sr.getEndPointIndex()));
        double currentsDist = RoutePlannerFrontEnd.squareDist((int)pp.x, (int)pp.y, px, py);
        return currentsDist;
    }

    public void makeSegmentPointPrecise(RoutingContext ctx, RouteSegmentResult routeSegmentResult, LatLon point, boolean st) {
        int px = MapUtils.get31TileNumberX(point.getLongitude());
        int py = MapUtils.get31TileNumberY(point.getLatitude());
        int pind = st ? routeSegmentResult.getStartPointIndex() : routeSegmentResult.getEndPointIndex();
        RouteDataObject r = new RouteDataObject(routeSegmentResult.getObject());
        routeSegmentResult.setObject(r);
        QuadPointDouble before = null;
        QuadPointDouble after = null;
        if (pind > 0) {
            before = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(pind - 1), r.getPoint31YTile(pind - 1), r.getPoint31XTile(pind), r.getPoint31YTile(pind));
        }
        if (pind < r.getPointsLength() - 1) {
            after = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(pind + 1), r.getPoint31YTile(pind + 1), r.getPoint31XTile(pind), r.getPoint31YTile(pind));
        }
        int insert = 0;
        double dd = MapUtils.getDistance(point, MapUtils.get31LatitudeY(r.getPoint31YTile(pind)), MapUtils.get31LongitudeX(r.getPoint31XTile(pind)));
        double ddBefore = Double.POSITIVE_INFINITY;
        double ddAfter = Double.POSITIVE_INFINITY;
        QuadPointDouble i = null;
        if (before != null && (ddBefore = MapUtils.getDistance(point, MapUtils.get31LatitudeY((int)before.y), MapUtils.get31LongitudeX((int)before.x))) < dd) {
            insert = -1;
            i = before;
        }
        if (after != null && (ddAfter = MapUtils.getDistance(point, MapUtils.get31LatitudeY((int)after.y), MapUtils.get31LongitudeX((int)after.x))) < dd && ddAfter < ddBefore) {
            insert = 1;
            i = after;
        }
        if (insert != 0) {
            if (st && routeSegmentResult.getStartPointIndex() < routeSegmentResult.getEndPointIndex()) {
                routeSegmentResult.setEndPointIndex(routeSegmentResult.getEndPointIndex() + 1);
            }
            if (!st && routeSegmentResult.getStartPointIndex() > routeSegmentResult.getEndPointIndex()) {
                routeSegmentResult.setStartPointIndex(routeSegmentResult.getStartPointIndex() + 1);
            }
            if (insert > 0) {
                r.insert(pind + 1, (int)i.x, (int)i.y);
                if (st) {
                    routeSegmentResult.setStartPointIndex(routeSegmentResult.getStartPointIndex() + 1);
                }
                if (!st) {
                    routeSegmentResult.setEndPointIndex(routeSegmentResult.getEndPointIndex() + 1);
                }
            } else {
                r.insert(pind, (int)i.x, (int)i.y);
            }
            RouteResultPreparation.calculateTimeSpeed(ctx, routeSegmentResult);
        }
    }

    private boolean addSegment(LatLon s, RoutingContext ctx, int indexNotFound, List<BinaryRoutePlanner.RouteSegmentPoint> res, boolean transportStop) throws IOException {
        BinaryRoutePlanner.RouteSegmentPoint f = this.findRouteSegment(s.getLatitude(), s.getLongitude(), ctx, null, transportStop);
        if (f == null) {
            ctx.calculationProgress.segmentNotFound = indexNotFound;
            return false;
        }
        log.info((Object)("Route segment found " + f.road));
        res.add(f);
        return true;
    }

    public RouteResultPreparation.RouteCalcResult searchRouteInternalPrepare(RoutingContext ctx, BinaryRoutePlanner.RouteSegmentPoint start, BinaryRoutePlanner.RouteSegmentPoint end, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        BinaryRoutePlanner.RouteSegmentPoint recalculationEnd = this.getRecalculationEnd(ctx);
        if (recalculationEnd != null) {
            ctx.initStartAndTargetPoints(start, recalculationEnd);
        } else {
            ctx.initStartAndTargetPoints(start, end);
        }
        if (routeDirection != null) {
            ctx.precalculatedRouteDirection = routeDirection.adopt(ctx);
        }
        if (ctx.nativeLib != null) {
            ctx.startX = start.preciseX;
            ctx.startY = start.preciseY;
            ctx.startRoadId = start.road.id;
            ctx.startSegmentInd = start.segStart;
            ctx.targetX = end.preciseX;
            ctx.targetY = end.preciseY;
            ctx.targetRoadId = end.road.id;
            ctx.targetSegmentInd = end.segStart;
            return this.runNativeRouting(ctx, recalculationEnd, null);
        }
        this.refreshProgressDistance(ctx);
        ctx.finalRouteSegment = new BinaryRoutePlanner().searchRouteInternal(ctx, start, recalculationEnd != null ? recalculationEnd : end, null);
        RouteResultPreparation rrp = new RouteResultPreparation();
        List<RouteSegmentResult> result = rrp.convertFinalSegmentToResults(ctx, ctx.finalRouteSegment);
        this.addPrecalculatedToResult(recalculationEnd, result);
        return rrp.prepareResult(ctx, result);
    }

    public BinaryRoutePlanner.RouteSegmentPoint getRecalculationEnd(RoutingContext ctx) {
        boolean runRecalculation;
        BinaryRoutePlanner.RouteSegmentPoint recalculationEnd = null;
        boolean bl = runRecalculation = ctx.previouslyCalculatedRoute != null && !ctx.previouslyCalculatedRoute.isEmpty() && ctx.config.recalculateDistance != 0.0f;
        if (runRecalculation) {
            ArrayList<RouteSegmentResult> rlist = new ArrayList<RouteSegmentResult>();
            float distanceThreshold = ctx.config.recalculateDistance;
            float threshold = 0.0f;
            for (RouteSegmentResult rr : ctx.previouslyCalculatedRoute) {
                if (!((threshold += rr.getDistance()) > distanceThreshold)) continue;
                rlist.add(rr);
            }
            if (!rlist.isEmpty()) {
                BinaryRoutePlanner.RouteSegment previous = null;
                for (int i = 0; i < rlist.size(); ++i) {
                    BinaryRoutePlanner.RouteSegment segment;
                    RouteSegmentResult rr = (RouteSegmentResult)rlist.get(i);
                    if (previous != null) {
                        segment = new BinaryRoutePlanner.RouteSegment(rr.getObject(), rr.getStartPointIndex(), rr.getEndPointIndex());
                        previous.setParentRoute(segment);
                        previous = segment;
                        continue;
                    }
                    recalculationEnd = new BinaryRoutePlanner.RouteSegmentPoint(rr.getObject(), rr.getStartPointIndex(), 0.0);
                    if (Math.abs(rr.getEndPointIndex() - rr.getStartPointIndex()) > 1) {
                        segment = new BinaryRoutePlanner.RouteSegment(rr.getObject(), recalculationEnd.segEnd, rr.getEndPointIndex());
                        recalculationEnd.setParentRoute(segment);
                        previous = segment;
                        continue;
                    }
                    previous = recalculationEnd;
                }
            }
        }
        return recalculationEnd;
    }

    private void refreshProgressDistance(RoutingContext ctx) {
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.distanceFromBegin = 0.0f;
            ctx.calculationProgress.distanceFromEnd = 0.0f;
            ctx.calculationProgress.reverseSegmentQueueSize = 0;
            ctx.calculationProgress.directSegmentQueueSize = 0;
            float rd = (float)MapUtils.squareRootDist31(ctx.startX, ctx.startY, ctx.targetX, ctx.targetY);
            float speed = 0.9f * ctx.config.router.getMaxSpeed();
            ctx.calculationProgress.totalEstimatedDistance = rd / speed;
        }
    }

    private RouteResultPreparation.RouteCalcResult runNativeRouting(RoutingContext ctx, BinaryRoutePlanner.RouteSegment recalculationEnd, HHRouteDataStructure.HHRoutingConfig hhConfig) throws IOException {
        this.refreshProgressDistance(ctx);
        if (recalculationEnd != null && TRACE_ROUTING) {
            log.info((Object)("RecalculationEnd = " + recalculationEnd.road + " ind=" + recalculationEnd.getSegmentStart() + "->" + recalculationEnd.getSegmentEnd()));
        }
        BinaryMapRouteReaderAdapter.RouteRegion[] regions = ctx.reverseMap.keySet().toArray(new BinaryMapRouteReaderAdapter.RouteRegion[0]);
        if (ctx.intermediatesX == null || ctx.intermediatesY == null) {
            ctx.intermediatesX = new int[0];
            ctx.intermediatesY = new int[0];
        }
        RouteSegmentResult[] res = ctx.nativeLib.runNativeRouting(ctx, hhConfig, regions, ctx.calculationMode == RouteCalculationMode.BASE);
        if (TRACE_ROUTING) {
            log.info((Object)"Native routing result!");
            for (RouteSegmentResult r : res) {
                log.info((Object)("Road = " + r.getObject().id / 64L + " " + r.getStartPointIndex() + "->" + r.getEndPointIndex()));
            }
        }
        ArrayList<RouteSegmentResult> result = new ArrayList<RouteSegmentResult>(Arrays.asList(res));
        if (TRACE_ROUTING) {
            log.info((Object)"RecalculationEnd result!");
        }
        this.addPrecalculatedToResult(recalculationEnd, result);
        ctx.routingTime += ctx.calculationProgress.routingCalculatedTime;
        return new RouteResultPreparation().prepareResult(ctx, result);
    }

    private void addPrecalculatedToResult(BinaryRoutePlanner.RouteSegment recalculationEnd, List<RouteSegmentResult> result) {
        if (recalculationEnd != null) {
            log.info((Object)"Native routing use precalculated route");
            BinaryRoutePlanner.RouteSegment current = recalculationEnd;
            if (!this.hasSegment(result, current)) {
                if (TRACE_ROUTING) {
                    log.info((Object)("Add recalculationEnd to result = " + current.getRoad() + " " + current.getSegmentStart() + "->" + current.getSegmentEnd()));
                }
                result.add(new RouteSegmentResult(current.getRoad(), current.getSegmentStart(), current.getSegmentEnd()));
            }
            while (current.getParentRoute() != null) {
                BinaryRoutePlanner.RouteSegment pr = current.getParentRoute();
                result.add(new RouteSegmentResult(pr.getRoad(), pr.getSegmentStart(), pr.getSegmentEnd()));
                if (TRACE_ROUTING) {
                    log.info((Object)("Road = " + pr.getRoad() + " " + pr.getSegmentStart() + "->" + pr.getSegmentEnd()));
                }
                current = pr;
            }
        }
    }

    private boolean hasSegment(List<RouteSegmentResult> result, BinaryRoutePlanner.RouteSegment current) {
        for (RouteSegmentResult r : result) {
            long currentId = r.getObject().id;
            if (currentId != current.getRoad().id || r.getStartPointIndex() != current.getSegmentStart() || r.getEndPointIndex() != current.getSegmentEnd()) continue;
            return true;
        }
        return false;
    }

    private RouteResultPreparation.RouteCalcResult searchRouteImpl(RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> points, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        if (points.size() <= 2) {
            if (!this.useSmartRouteRecalculation) {
                ctx.previouslyCalculatedRoute = null;
            }
            this.pringGC(ctx, true);
            RouteResultPreparation.RouteCalcResult res = this.searchRouteInternalPrepare(ctx, points.get(0), points.get(1), routeDirection);
            this.pringGC(ctx, false);
            this.makeStartEndPointsPrecise(ctx, res, points.get(0).getPreciseLatLon(), points.get(1).getPreciseLatLon(), null);
            return res;
        }
        ArrayList<RouteSegmentResult> firstPartRecalculatedRoute = null;
        ArrayList<RouteSegmentResult> restPartRecalculatedRoute = null;
        if (ctx.previouslyCalculatedRoute != null) {
            List<RouteSegmentResult> prev = ctx.previouslyCalculatedRoute;
            long id = points.get((int)1).getRoad().id;
            short ss = points.get(1).getSegmentStart();
            int px = points.get(1).getRoad().getPoint31XTile(ss);
            int py = points.get(1).getRoad().getPoint31YTile(ss);
            for (int i = 0; i < prev.size(); ++i) {
                RouteSegmentResult rsr = prev.get(i);
                if (id != rsr.getObject().getId() || !(MapUtils.getDistance(rsr.getPoint(rsr.getEndPointIndex()), MapUtils.get31LatitudeY(py), MapUtils.get31LongitudeX(px)) < 50.0)) continue;
                firstPartRecalculatedRoute = new ArrayList<RouteSegmentResult>(i + 1);
                restPartRecalculatedRoute = new ArrayList<RouteSegmentResult>(prev.size() - i);
                for (int k = 0; k < prev.size(); ++k) {
                    if (k <= i) {
                        firstPartRecalculatedRoute.add(prev.get(k));
                        continue;
                    }
                    restPartRecalculatedRoute.add(prev.get(k));
                }
                System.out.println("Recalculate only first part of the route");
                break;
            }
        }
        RouteResultPreparation.RouteCalcResult results = new RouteResultPreparation.RouteCalcResult(new ArrayList<RouteSegmentResult>());
        for (int i = 0; i < points.size() - 1; ++i) {
            RoutingContext local = new RoutingContext(ctx);
            if (i == 0 && ctx.nativeLib == null && this.useSmartRouteRecalculation) {
                local.previouslyCalculatedRoute = firstPartRecalculatedRoute;
            }
            RouteResultPreparation.RouteCalcResult res = this.searchRouteInternalPrepare(local, points.get(i), points.get(i + 1), routeDirection);
            this.makeStartEndPointsPrecise(local, res, points.get(i).getPreciseLatLon(), points.get(i + 1).getPreciseLatLon(), null);
            results.detailed.addAll(res.detailed);
            ctx.routingTime += local.routingTime;
            if (restPartRecalculatedRoute == null) continue;
            results.detailed.addAll(restPartRecalculatedRoute);
            break;
        }
        ctx.unloadAllData();
        return results;
    }

    private void pringGC(RoutingContext ctx, boolean before) {
        if (RoutingContext.SHOW_GC_SIZE && before) {
            long h1 = RoutingContext.runGCUsedMemory();
            float mb = 1048576.0f;
            log.warn((Object)("Used before routing " + (float)h1 / mb + " actual"));
        } else if (RoutingContext.SHOW_GC_SIZE && !before) {
            int sz = ctx.global.size;
            log.warn((Object)("Subregion size " + ctx.subregionTiles.size() + "  tiles " + ctx.indexedSubregions.size()));
            long h1 = RoutingContext.runGCUsedMemory();
            ctx.unloadAllData();
            long h2 = RoutingContext.runGCUsedMemory();
            float mb = 1048576.0f;
            log.warn((Object)("Unload context :  estimated " + (float)sz / mb + " ?= " + (float)(h1 - h2) / mb + " actual"));
        }
    }

    private static enum HHRoutingType {
        JAVA,
        CPP;

    }

    public static enum RouteCalculationMode {
        BASE,
        NORMAL,
        COMPLEX;

    }

    public static class GpxPoint {
        public int ind;
        public LatLon loc;
        public int x31;
        public int y31;
        public long time = 0L;
        public double cumDist;
        public BinaryRoutePlanner.RouteSegmentPoint pnt;
        public List<RouteSegmentResult> routeToTarget;
        public List<RouteSegmentResult> stepBackRoute;
        public int targetInd = -1;
        public boolean straightLine = false;
        public RouteDataObject object;

        public GpxPoint() {
        }

        public RouteSegmentResult getFirstRouteRes() {
            if (this.routeToTarget == null || this.routeToTarget.isEmpty()) {
                return null;
            }
            return this.routeToTarget.get(0);
        }

        public RouteSegmentResult getLastRouteRes() {
            if (this.routeToTarget == null || this.routeToTarget.isEmpty()) {
                return null;
            }
            return this.routeToTarget.get(this.routeToTarget.size() - 1);
        }

        public GpxPoint(GpxPoint point) {
            this.ind = point.ind;
            this.loc = point.loc;
            this.object = point.object;
            this.cumDist = point.cumDist;
        }
    }
}

