/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.osmand.Location;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataBundle;
import net.osmand.binary.StringBundle;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXUtilities;
import net.osmand.router.RouteDataResources;
import net.osmand.router.RouteSegmentResult;
import net.osmand.util.Algorithms;

public class RouteExporter {
    public static final String OSMAND_ROUTER_V2 = "OsmAndRouterV2";
    private final String name;
    private final List<RouteSegmentResult> route;
    private final List<Location> locations;
    private final List<Integer> routePointIndexes;
    private final List<GPXUtilities.WptPt> points;

    public RouteExporter(String name, List<RouteSegmentResult> route, List<Location> locations, List<Integer> routePointIndexes, List<GPXUtilities.WptPt> points) {
        this.name = name;
        this.route = route;
        this.locations = locations;
        this.routePointIndexes = routePointIndexes == null ? new ArrayList() : routePointIndexes;
        this.points = points;
    }

    public GPXFile exportRoute() {
        GPXFile gpx = new GPXFile(OSMAND_ROUTER_V2);
        GPXUtilities.Track track = new GPXUtilities.Track();
        track.name = this.name;
        gpx.tracks.add(track);
        track.segments.add(this.generateRouteSegment());
        if (this.points != null) {
            for (GPXUtilities.WptPt pt : this.points) {
                gpx.addPoint(pt);
            }
        }
        return gpx;
    }

    public static GPXFile exportRoute(String name, List<GPXUtilities.TrkSegment> trkSegments, List<GPXUtilities.WptPt> points, List<List<GPXUtilities.WptPt>> routePoints) {
        GPXFile gpx = new GPXFile(OSMAND_ROUTER_V2);
        GPXUtilities.Track track = new GPXUtilities.Track();
        track.name = name;
        gpx.tracks.add(track);
        track.segments.addAll(trkSegments);
        if (points != null) {
            for (GPXUtilities.WptPt wptPt : points) {
                gpx.addPoint(wptPt);
            }
        }
        if (routePoints != null) {
            for (List list : routePoints) {
                gpx.addRoutePoints(list, true);
            }
        }
        return gpx;
    }

    public GPXUtilities.TrkSegment generateRouteSegment() {
        RouteDataResources resources = new RouteDataResources(this.locations, this.routePointIndexes);
        ArrayList<Object> routeItems = new ArrayList<Object>();
        if (!Algorithms.isEmpty(this.route)) {
            for (RouteSegmentResult sr : this.route) {
                sr.collectTypes(resources);
            }
            for (RouteSegmentResult sr : this.route) {
                sr.collectNames(resources);
            }
            for (RouteSegmentResult sr : this.route) {
                RouteDataBundle itemBundle = new RouteDataBundle(resources);
                sr.writeToBundle(itemBundle);
                routeItems.add(itemBundle);
            }
        }
        ArrayList<RouteDataBundle> typeList = new ArrayList<RouteDataBundle>();
        Map<BinaryMapRouteReaderAdapter.RouteTypeRule, Integer> rules = resources.getRules();
        for (BinaryMapRouteReaderAdapter.RouteTypeRule rule : rules.keySet()) {
            RouteDataBundle typeBundle = new RouteDataBundle(resources);
            rule.writeToBundle(typeBundle);
            typeList.add(typeBundle);
        }
        GPXUtilities.TrkSegment trkSegment = new GPXUtilities.TrkSegment();
        if (this.locations == null || this.locations.isEmpty()) {
            return trkSegment;
        }
        for (int i = 0; i < this.locations.size(); ++i) {
            Location loc = this.locations.get(i);
            GPXUtilities.WptPt wptPt = new GPXUtilities.WptPt();
            wptPt.lat = loc.getLatitude();
            wptPt.lon = loc.getLongitude();
            if (loc.hasSpeed()) {
                wptPt.speed = loc.getSpeed();
            }
            if (loc.hasAltitude()) {
                wptPt.ele = loc.getAltitude();
            }
            if (loc.hasAccuracy()) {
                wptPt.hdop = loc.getAccuracy();
            }
            trkSegment.points.add(wptPt);
        }
        ArrayList<GPXUtilities.RouteSegment> routeSegments = new ArrayList<GPXUtilities.RouteSegment>();
        for (StringBundle stringBundle : routeItems) {
            routeSegments.add(GPXUtilities.RouteSegment.fromStringBundle(stringBundle));
        }
        trkSegment.routeSegments = routeSegments;
        ArrayList<GPXUtilities.RouteType> routeTypes = new ArrayList<GPXUtilities.RouteType>();
        for (StringBundle stringBundle : typeList) {
            routeTypes.add(GPXUtilities.RouteType.fromStringBundle(stringBundle));
        }
        trkSegment.routeTypes = routeTypes;
        return trkSegment;
    }
}

