/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.osmand.data.LatLon;
import net.osmand.map.OsmandRegions;
import net.osmand.map.WorldRegion;
import net.osmand.router.RoutingContext;
import net.osmand.util.Algorithms;

public class MissingMapsCalculationResult {
    private final RoutingContext missingMapsRoutingContext;
    private final List<LatLon> missingMapsPoints;
    Set<String> usedMaps = new LinkedHashSet<String>();
    Set<String> mapsToDownload = new LinkedHashSet<String>();
    Set<String> missingMaps = new LinkedHashSet<String>();
    Set<String> mapsToUpdate = new LinkedHashSet<String>();
    private List<WorldRegion> regionsToDownload;
    private List<WorldRegion> missingRegions;
    private List<WorldRegion> regionsToUpdate;
    private List<WorldRegion> usedRegions;

    public MissingMapsCalculationResult(RoutingContext missingMapsRoutingContext, List<LatLon> missingMapsPoints) {
        this.missingMapsRoutingContext = missingMapsRoutingContext;
        this.missingMapsPoints = missingMapsPoints;
    }

    public void addMissingMaps(String region) {
        this.missingMaps.add(region);
        this.mapsToDownload.add(region);
    }

    public void addUsedMaps(String region) {
        this.usedMaps.add(region);
    }

    public void addMapToUpdate(String region) {
        this.mapsToUpdate.add(region);
        this.mapsToDownload.add(region);
    }

    public boolean hasMissingMaps() {
        return !Algorithms.isEmpty(this.mapsToDownload);
    }

    private List<WorldRegion> convert(OsmandRegions or, Set<String> maps) {
        if (maps.isEmpty()) {
            return null;
        }
        ArrayList<WorldRegion> l = new ArrayList<WorldRegion>();
        for (String m : maps) {
            WorldRegion wr = or.getRegionDataByDownloadName(m);
            if (wr == null) continue;
            l.add(wr);
        }
        return l;
    }

    public List<WorldRegion> getMapsToDownload() {
        return this.regionsToDownload;
    }

    public List<WorldRegion> getMissingMaps() {
        return this.missingRegions;
    }

    public List<WorldRegion> getMapsToUpdate() {
        return this.regionsToUpdate;
    }

    public List<WorldRegion> getUsedMaps() {
        return this.usedRegions;
    }

    public RoutingContext getMissingMapsRoutingContext() {
        return this.missingMapsRoutingContext;
    }

    public List<LatLon> getMissingMapsPoints() {
        return this.missingMapsPoints;
    }

    public String getErrorMessage() {
        Object msg = "";
        if (this.mapsToUpdate != null) {
            msg = this.mapsToUpdate + " need to be updated";
        }
        if (this.missingMaps != null) {
            if (((String)msg).length() > 0) {
                msg = (String)msg + " and ";
            }
            msg = this.missingMaps + " need to be downloaded";
        }
        msg = "To calculate the route maps " + (String)msg;
        return msg;
    }

    public MissingMapsCalculationResult prepare(OsmandRegions or) {
        this.regionsToDownload = this.convert(or, this.mapsToDownload);
        this.missingRegions = this.convert(or, this.missingMaps);
        this.regionsToUpdate = this.convert(or, this.mapsToUpdate);
        this.usedRegions = this.convert(or, this.usedMaps);
        return this;
    }
}

