/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import gnu.trove.list.array.TIntArrayList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.osmand.NativeLibrary;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPointDouble;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.GpxMultiSegmentsApproximation;
import net.osmand.router.GpxPointsMatchApproximation;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class GpxRouteApproximation {
    public static final int GPX_OSM_POINTS_MATCH_ALGORITHM = 1;
    public static final int GPX_OSM_MULTISEGMENT_SCAN_ALGORITHM = 2;
    public static int GPX_SEGMENT_ALGORITHM = 2;
    public List<RoutePlannerFrontEnd.GpxPoint> finalPoints = new ArrayList<RoutePlannerFrontEnd.GpxPoint>();
    public List<RouteSegmentResult> fullRoute = new ArrayList<RouteSegmentResult>();
    public final RoutingContext ctx;
    private RoutePlannerFrontEnd router;
    private int routeCalculations = 0;
    public int routePointsSearched = 0;
    private int routeDistCalculations = 0;
    public int routeDistance;
    private int routeDistanceUnmatched;
    private final Log log = PlatformUtil.getLog(RoutePlannerFrontEnd.class);

    public GpxRouteApproximation(RoutingContext ctx) {
        this.ctx = ctx;
    }

    public String toString() {
        return String.format(">> GPX approximation (%d of %d m route calcs, %d route points searched) for %d m: %d m unmatched", this.routeCalculations, this.routeDistCalculations, this.routePointsSearched, this.routeDistance, this.routeDistanceUnmatched);
    }

    public GpxRouteApproximation searchGpxRouteInternal(RoutePlannerFrontEnd router, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, ResultMatcher<GpxRouteApproximation> resultMatcher, boolean useExternalTimestamps) throws IOException, InterruptedException {
        this.router = router;
        GpxRouteApproximation result = router.isUseGeometryBasedApproximation() ? this.searchGpxSegments(this, gpxPoints) : this.searchGpxRouteByRouting(this, gpxPoints);
        result.reconstructFinalPointsFromFullRoute();
        if (useExternalTimestamps) {
            result.applyExternalTimestamps(gpxPoints);
        }
        if (resultMatcher != null) {
            resultMatcher.publish(this.ctx.calculationProgress.isCancelled ? null : this);
        }
        return result;
    }

    public List<RouteSegmentResult> collectFinalPointsAsRoute() {
        ArrayList<RouteSegmentResult> route = new ArrayList<RouteSegmentResult>();
        for (RoutePlannerFrontEnd.GpxPoint gp : this.finalPoints) {
            route.addAll(gp.routeToTarget);
        }
        return Collections.unmodifiableList(route);
    }

    private double distFromLastPoint(LatLon pnt) {
        if (this.fullRoute.size() > 0) {
            return MapUtils.getDistance(this.getLastPoint(), pnt);
        }
        return 0.0;
    }

    private LatLon getLastPoint() {
        if (this.fullRoute.size() > 0) {
            return this.fullRoute.get(this.fullRoute.size() - 1).getEndPoint();
        }
        return null;
    }

    private void applyExternalTimestamps(List<RoutePlannerFrontEnd.GpxPoint> sourcePoints) {
        if (!this.validateExternalTimestamps(sourcePoints)) {
            this.log.warn((Object)"applyExternalTimestamps() got invalid sourcePoints");
            return;
        }
        for (RoutePlannerFrontEnd.GpxPoint gp : this.finalPoints) {
            for (RouteSegmentResult seg : gp.routeToTarget) {
                seg.setSegmentSpeed(this.calcSegmentSpeedByExternalTimestamps(gp, seg, sourcePoints));
            }
            RouteResultPreparation.recalculateTimeDistance(gp.routeToTarget);
        }
    }

    private float calcSegmentSpeedByExternalTimestamps(RoutePlannerFrontEnd.GpxPoint gp, RouteSegmentResult seg, List<RoutePlannerFrontEnd.GpxPoint> sourcePoints) {
        long time;
        float speed = seg.getSegmentSpeed();
        int indexStart = gp.ind;
        int indexEnd = gp.targetInd;
        if (indexEnd == -1 && indexStart >= 0 && indexStart + 1 < sourcePoints.size()) {
            indexEnd = indexStart + 1;
        }
        if (indexStart >= 0 && indexEnd > 0 && indexStart < indexEnd && (time = sourcePoints.get((int)indexEnd).time - sourcePoints.get((int)indexStart).time) > 0L) {
            double distance = 0.0;
            for (int i = indexStart; i < indexEnd; ++i) {
                distance += MapUtils.getDistance(sourcePoints.get((int)i).loc, sourcePoints.get((int)(i + 1)).loc);
            }
            if (distance > 0.0) {
                speed = (float)distance / ((float)time / 1000.0f);
            }
        }
        return speed;
    }

    private boolean validateExternalTimestamps(List<RoutePlannerFrontEnd.GpxPoint> points) {
        if (points == null || points.isEmpty()) {
            return false;
        }
        long last = 0L;
        for (RoutePlannerFrontEnd.GpxPoint p : points) {
            if (p.time == 0L || p.time < last) {
                return false;
            }
            last = p.time;
        }
        return true;
    }

    private void reconstructFinalPointsFromFullRoute() {
        HashMap<Integer, Integer> gpxIndexFinalIndex = new HashMap<Integer, Integer>();
        for (int i = 0; i < this.finalPoints.size(); ++i) {
            gpxIndexFinalIndex.put(this.finalPoints.get((int)i).ind, i);
            this.finalPoints.get((int)i).routeToTarget.clear();
        }
        int lastIndex = 0;
        for (RouteSegmentResult seg : this.fullRoute) {
            int index = seg.getGpxPointIndex();
            if (index == -1) {
                index = lastIndex;
            } else {
                lastIndex = index;
            }
            this.finalPoints.get((int)((Integer)gpxIndexFinalIndex.get((Object)Integer.valueOf((int)index))).intValue()).routeToTarget.add(seg);
        }
        ArrayList<RoutePlannerFrontEnd.GpxPoint> emptyFinalPoints = new ArrayList<RoutePlannerFrontEnd.GpxPoint>();
        for (RoutePlannerFrontEnd.GpxPoint gp : this.finalPoints) {
            if (gp.routeToTarget == null || gp.routeToTarget.size() != 0) continue;
            emptyFinalPoints.add(gp);
        }
        if (emptyFinalPoints.size() > 0) {
            this.finalPoints.removeAll(emptyFinalPoints);
        }
    }

    private GpxRouteApproximation searchGpxSegments(GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) throws IOException, InterruptedException {
        NativeLibrary nativeLib = gctx.ctx.nativeLib;
        if (nativeLib != null && this.router.isUseNativeApproximation()) {
            gctx = nativeLib.runNativeSearchGpxRoute(gctx, gpxPoints, true);
        } else {
            if (gctx.ctx.calculationProgress == null) {
                gctx.ctx.calculationProgress = new RouteCalculationProgress();
            }
            if (GPX_SEGMENT_ALGORITHM == 1) {
                GpxPointsMatchApproximation app = new GpxPointsMatchApproximation();
                app.gpxApproximation(this.router, gctx, gpxPoints);
            } else if (GPX_SEGMENT_ALGORITHM == 2) {
                GpxMultiSegmentsApproximation app = new GpxMultiSegmentsApproximation(this.router, gctx, gpxPoints);
                app.gpxApproximation();
            }
            this.calculateGpxRouteResult(gctx, gpxPoints);
            if (!gctx.fullRoute.isEmpty() && !gctx.ctx.calculationProgress.isCancelled) {
                RouteResultPreparation.printResults(gctx.ctx, gpxPoints.get((int)0).loc, gpxPoints.get((int)(gpxPoints.size() - 1)).loc, gctx.fullRoute);
                this.log.info((Object)gctx);
            }
        }
        return gctx;
    }

    private GpxRouteApproximation searchGpxRouteByRouting(GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) throws IOException, InterruptedException {
        long timeToCalculate = System.nanoTime();
        NativeLibrary nativeLib = gctx.ctx.nativeLib;
        if (nativeLib != null && this.router.isUseNativeApproximation()) {
            gctx = nativeLib.runNativeSearchGpxRoute(gctx, gpxPoints, false);
        } else {
            gctx.ctx.keepNativeRoutingContext = true;
            if (gctx.ctx.calculationProgress == null) {
                gctx.ctx.calculationProgress = new RouteCalculationProgress();
            }
            RoutePlannerFrontEnd.GpxPoint start = null;
            RoutePlannerFrontEnd.GpxPoint prev = null;
            if (gpxPoints.size() > 0) {
                gctx.ctx.calculationProgress.totalApproximateDistance = (float)gpxPoints.get((int)(gpxPoints.size() - 1)).cumDist;
                start = gpxPoints.get(0);
            }
            float minPointApproximation = gctx.ctx.config.minPointApproximation;
            while (start != null && !gctx.ctx.calculationProgress.isCancelled) {
                double routeDist = gctx.ctx.config.maxStepApproximation;
                RoutePlannerFrontEnd.GpxPoint next = this.findNextGpxPointWithin(gpxPoints, start, routeDist);
                boolean routeFound = false;
                if (next != null && this.initRoutingPoint(start, gctx, minPointApproximation)) {
                    while (routeDist >= (double)gctx.ctx.config.minStepApproximation && !routeFound) {
                        routeFound = this.initRoutingPoint(next, gctx, minPointApproximation);
                        if (routeFound) {
                            routeFound = this.findGpxRouteSegment(gctx, gpxPoints, start, next, prev != null);
                            if (routeFound && !(routeFound = this.isRouteCloseToGpxPoints(minPointApproximation, gpxPoints, start, next))) {
                                start.routeToTarget = null;
                            }
                            if (routeFound && next.ind < gpxPoints.size() - 1) {
                                boolean stepBack = this.stepBackAndFindPrevPointInRoute(gctx, gpxPoints, start, next);
                                if (!stepBack) {
                                    this.log.info((Object)("Consider to increase routing.xml maxStepApproximation to: " + routeDist * 2.0));
                                    start.routeToTarget = null;
                                    routeFound = false;
                                } else if (gctx.ctx.getVisitor() != null) {
                                    gctx.ctx.getVisitor().visitApproximatedSegments(start.routeToTarget, start, next);
                                }
                            }
                        }
                        if (routeFound) continue;
                        if ((routeDist /= 2.0) < (double)gctx.ctx.config.minStepApproximation && routeDist > (double)(gctx.ctx.config.minStepApproximation / 2.0f + 1.0f)) {
                            routeDist = gctx.ctx.config.minStepApproximation;
                        }
                        if ((next = this.findNextGpxPointWithin(gpxPoints, start, routeDist)) == null) continue;
                        routeDist = Math.min(next.cumDist - start.cumDist, routeDist);
                    }
                }
                if (!routeFound && next != null) {
                    next = this.findNextGpxPointWithin(gpxPoints, start, gctx.ctx.config.minStepApproximation);
                    if (prev != null) {
                        prev.routeToTarget.addAll(prev.stepBackRoute);
                        if (next != null) {
                            this.log.warn((Object)("NOT found route from: " + start.pnt.getRoad() + " at " + start.pnt.getSegmentStart()));
                        }
                    }
                    prev = null;
                } else {
                    prev = start;
                }
                start = next;
                if (gctx.ctx.calculationProgress == null || start == null) continue;
                gctx.ctx.calculationProgress.approximatedDistance = (float)start.cumDist;
            }
            if (gctx.ctx.calculationProgress != null) {
                gctx.ctx.calculationProgress.timeToCalculate = System.nanoTime() - timeToCalculate;
            }
            gctx.ctx.deleteNativeRoutingContext();
            this.calculateGpxRouteResult(gctx, gpxPoints);
            if (!gctx.fullRoute.isEmpty() && !gctx.ctx.calculationProgress.isCancelled) {
                RouteResultPreparation.printResults(gctx.ctx, gpxPoints.get((int)0).loc, gpxPoints.get((int)(gpxPoints.size() - 1)).loc, gctx.fullRoute);
                this.log.info((Object)gctx);
            }
        }
        return gctx;
    }

    private boolean stepBackAndFindPrevPointInRoute(GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, RoutePlannerFrontEnd.GpxPoint start, RoutePlannerFrontEnd.GpxPoint next) throws IOException {
        int segmendInd;
        double STEP_BACK_DIST = Math.max(gctx.ctx.config.minPointApproximation, gctx.ctx.config.minStepApproximation);
        double d = 0.0;
        boolean search = true;
        start.stepBackRoute = new ArrayList<RouteSegmentResult>();
        block0: for (segmendInd = start.routeToTarget.size() - 1; segmendInd >= 0 && search; --segmendInd) {
            RouteSegmentResult rr = start.routeToTarget.get(segmendInd);
            boolean minus = rr.getStartPointIndex() < rr.getEndPointIndex();
            int j = rr.getEndPointIndex();
            while (j != rr.getStartPointIndex()) {
                int nextInd = minus ? j - 1 : j + 1;
                if ((d += MapUtils.getDistance(rr.getPoint(j), rr.getPoint(nextInd))) > STEP_BACK_DIST) {
                    if (nextInd == rr.getStartPointIndex()) {
                        --segmendInd;
                    } else {
                        RouteSegmentResult seg = new RouteSegmentResult(rr.getObject(), nextInd, rr.getEndPointIndex());
                        seg.setGpxPointIndex(start.ind);
                        start.stepBackRoute.add(seg);
                        rr.setEndPointIndex(nextInd);
                    }
                    search = false;
                    break block0;
                }
                j = nextInd;
            }
        }
        if (segmendInd == -1) {
            return false;
        }
        while (start.routeToTarget.size() > segmendInd + 1) {
            RouteSegmentResult removed = start.routeToTarget.remove(segmendInd + 1);
            start.stepBackRoute.add(removed);
        }
        RouteSegmentResult res = start.routeToTarget.get(segmendInd);
        int end = res.getEndPointIndex();
        int beforeEnd = res.isForwardDirection() ? end - 1 : end + 1;
        next.pnt = new BinaryRoutePlanner.RouteSegmentPoint(res.getObject(), beforeEnd, end, 0.0);
        next.pnt.preciseX = next.pnt.getEndPointX();
        next.pnt.preciseY = next.pnt.getEndPointY();
        return true;
    }

    private void calculateGpxRouteResult(GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints) throws IOException {
        BinaryMapRouteReaderAdapter.RouteRegion reg = new BinaryMapRouteReaderAdapter.RouteRegion();
        reg.initRouteEncodingRule(0, "highway", "unmatched");
        ArrayList<LatLon> lastStraightLine = null;
        RoutePlannerFrontEnd.GpxPoint straightPointStart = null;
        int i = 0;
        while (i < gpxPoints.size() && !gctx.ctx.calculationProgress.isCancelled) {
            RoutePlannerFrontEnd.GpxPoint pnt = gpxPoints.get(i);
            if (pnt.routeToTarget != null && !pnt.routeToTarget.isEmpty()) {
                LatLon startPoint = pnt.getFirstRouteRes().getStartPoint();
                if (lastStraightLine != null) {
                    this.router.makeSegmentPointPrecise(gctx.ctx, pnt.getFirstRouteRes(), pnt.loc, true);
                    startPoint = pnt.getFirstRouteRes().getStartPoint();
                    lastStraightLine.add(startPoint);
                    this.addStraightLine(gctx, lastStraightLine, straightPointStart, reg);
                    lastStraightLine = null;
                }
                if (gctx.distFromLastPoint(startPoint) > 1.0) {
                    System.out.println(String.format("?? gap of route point = %f, gap of actual gpxPoint = %f, %s ", gctx.distFromLastPoint(startPoint), gctx.distFromLastPoint(pnt.loc), pnt.loc));
                }
                gctx.finalPoints.add(pnt);
                gctx.fullRoute.addAll(pnt.routeToTarget);
                i = pnt.targetInd;
                continue;
            }
            if (lastStraightLine == null) {
                lastStraightLine = new ArrayList<LatLon>();
                if (gctx.getLastPoint() != null && gctx.finalPoints.size() > 0) {
                    RoutePlannerFrontEnd.GpxPoint prev = gctx.finalPoints.get(gctx.finalPoints.size() - 1);
                    this.router.makeSegmentPointPrecise(gctx.ctx, prev.getLastRouteRes(), pnt.loc, false);
                    lastStraightLine.add(gctx.getLastPoint());
                }
                straightPointStart = pnt;
            }
            lastStraightLine.add(pnt.loc);
            ++i;
        }
        if (lastStraightLine != null) {
            this.addStraightLine(gctx, lastStraightLine, straightPointStart, reg);
            lastStraightLine = null;
        }
        if (this.router.isUseGeometryBasedApproximation()) {
            new RouteResultPreparation().prepareResult(gctx.ctx, gctx.fullRoute);
        } else {
            this.cleanDoubleJoints(gctx);
        }
        this.cleanupResultAndAddTurns(gctx);
    }

    private void cleanupResultAndAddTurns(GpxRouteApproximation gctx) {
        RouteResultPreparation preparation = new RouteResultPreparation();
        preparation.validateAllPointsConnected(gctx.fullRoute);
        for (RouteSegmentResult r : gctx.fullRoute) {
            r.setTurnType(null);
            r.clearDescription();
        }
        if (!gctx.ctx.calculationProgress.isCancelled) {
            preparation.prepareTurnResults(gctx.ctx, gctx.fullRoute);
        }
        for (RouteSegmentResult r : gctx.fullRoute) {
            r.clearAttachedRoutes();
            r.clearPreattachedRoutes();
        }
    }

    private void cleanDoubleJoints(GpxRouteApproximation gctx) {
        int LOOK_AHEAD = 4;
        block0: for (int i = 0; i < gctx.fullRoute.size() && !gctx.ctx.calculationProgress.isCancelled; ++i) {
            RouteSegmentResult s = gctx.fullRoute.get(i);
            for (int j = i + 2; j <= i + LOOK_AHEAD && j < gctx.fullRoute.size(); ++j) {
                RouteSegmentResult e = gctx.fullRoute.get(j);
                if (!e.getStartPoint().equals(s.getEndPoint())) continue;
                while (--j != i) {
                    gctx.fullRoute.remove(j);
                }
                continue block0;
            }
        }
    }

    private void addStraightLine(GpxRouteApproximation gctx, List<LatLon> lastStraightLine, RoutePlannerFrontEnd.GpxPoint strPnt, BinaryMapRouteReaderAdapter.RouteRegion reg) {
        RouteDataObject rdo = new RouteDataObject(reg);
        if (gctx.ctx.config.smoothenPointsNoRoute > 0.0f) {
            this.simplifyDouglasPeucker(lastStraightLine, gctx.ctx.config.smoothenPointsNoRoute, 0, lastStraightLine.size() - 1);
        }
        int s = lastStraightLine.size();
        TIntArrayList x = new TIntArrayList(s);
        TIntArrayList y = new TIntArrayList(s);
        for (int i = 0; i < s; ++i) {
            if (lastStraightLine.get(i) == null) continue;
            LatLon l = lastStraightLine.get(i);
            int t = x.size() - 1;
            x.add(MapUtils.get31TileNumberX(l.getLongitude()));
            y.add(MapUtils.get31TileNumberY(l.getLatitude()));
            if (t < 0) continue;
            double dist = MapUtils.squareRootDist31(x.get(t), y.get(t), x.get(t + 1), y.get(t + 1));
            gctx.routeDistanceUnmatched = (int)((double)gctx.routeDistanceUnmatched + dist);
        }
        rdo.pointsX = x.toArray();
        rdo.pointsY = y.toArray();
        rdo.types = new int[]{0};
        rdo.id = -1L;
        strPnt.routeToTarget = new ArrayList<RouteSegmentResult>();
        strPnt.straightLine = true;
        RouteSegmentResult line = new RouteSegmentResult(rdo, 0, rdo.getPointsLength() - 1);
        line.setGpxPointIndex(strPnt.ind);
        strPnt.routeToTarget.add(line);
        RouteResultPreparation preparation = new RouteResultPreparation();
        try {
            preparation.prepareResult(gctx.ctx, strPnt.routeToTarget);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        gctx.finalPoints.add(strPnt);
        gctx.fullRoute.addAll(strPnt.routeToTarget);
    }

    private void simplifyDouglasPeucker(List<LatLon> l, double eps, int start, int end) {
        int i;
        double dmax = -1.0;
        int index = -1;
        LatLon s = l.get(start);
        LatLon e = l.get(end);
        for (i = start + 1; i <= end - 1; ++i) {
            LatLon ip = l.get(i);
            double dist = MapUtils.getOrthogonalDistance(ip.getLatitude(), ip.getLongitude(), s.getLatitude(), s.getLongitude(), e.getLatitude(), e.getLongitude());
            if (!(dist > dmax)) continue;
            dmax = dist;
            index = i;
        }
        if (dmax >= eps) {
            this.simplifyDouglasPeucker(l, eps, start, index);
            this.simplifyDouglasPeucker(l, eps, index, end);
        } else {
            for (i = start + 1; i < end; ++i) {
                l.set(i, null);
            }
        }
    }

    private boolean initRoutingPoint(RoutePlannerFrontEnd.GpxPoint start, GpxRouteApproximation gctx, double distThreshold) throws IOException {
        if (start != null && start.pnt == null) {
            ++gctx.routePointsSearched;
            BinaryRoutePlanner.RouteSegmentPoint rsp = this.router.findRouteSegment(start.loc.getLatitude(), start.loc.getLongitude(), gctx.ctx, null, false);
            if (rsp != null && MapUtils.getDistance(rsp.getPreciseLatLon(), start.loc) < distThreshold) {
                start.pnt = rsp;
            }
        }
        return start != null && start.pnt != null;
    }

    private RoutePlannerFrontEnd.GpxPoint findNextGpxPointWithin(List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, RoutePlannerFrontEnd.GpxPoint start, double dist) {
        int plus = dist > 0.0 ? 1 : -1;
        RoutePlannerFrontEnd.GpxPoint target = null;
        for (int targetInd = start.ind + plus; targetInd < gpxPoints.size() && targetInd >= 0; targetInd += plus) {
            target = gpxPoints.get(targetInd);
            if (Math.abs(target.cumDist - start.cumDist) > Math.abs(dist)) break;
        }
        return target;
    }

    private boolean findGpxRouteSegment(GpxRouteApproximation gctx, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, RoutePlannerFrontEnd.GpxPoint start, RoutePlannerFrontEnd.GpxPoint target, boolean prevRouteCalculated) throws IOException, InterruptedException {
        RouteResultPreparation.RouteCalcResult res = null;
        boolean routeIsCorrect = false;
        if (start.pnt != null && target.pnt != null) {
            start.pnt = new BinaryRoutePlanner.RouteSegmentPoint(start.pnt);
            target.pnt = new BinaryRoutePlanner.RouteSegmentPoint(target.pnt);
            gctx.routeDistCalculations = (int)((double)gctx.routeDistCalculations + (target.cumDist - start.cumDist));
            ++gctx.routeCalculations;
            RoutingContext local = new RoutingContext(gctx.ctx);
            res = this.router.searchRouteInternalPrepare(local, start.pnt, target.pnt, null);
            routeIsCorrect = res != null && res.isCorrect();
            for (int k = start.ind + 1; routeIsCorrect && k < target.ind; ++k) {
                RoutePlannerFrontEnd.GpxPoint ipoint = gpxPoints.get(k);
                if (this.pointCloseEnough(gctx, ipoint, res)) continue;
                routeIsCorrect = false;
            }
            if (routeIsCorrect) {
                RouteSegmentResult firstSegment = res.detailed.get(0);
                if (prevRouteCalculated) {
                    if (firstSegment.getObject().getId() == start.pnt.getRoad().getId()) {
                        firstSegment.setStartPointIndex(start.pnt.getSegmentEnd());
                        if (firstSegment.getObject().getPointsLength() != start.pnt.getRoad().getPointsLength()) {
                            firstSegment.setObject(start.pnt.road);
                        }
                        if (firstSegment.getStartPointIndex() == firstSegment.getEndPointIndex()) {
                            res.detailed.remove(0);
                        }
                    } else {
                        System.out.println("??? not found " + start.pnt.getRoad().getId() + " instead " + firstSegment.getObject().getId());
                    }
                }
                for (RouteSegmentResult seg : res.detailed) {
                    seg.setGpxPointIndex(start.ind);
                }
                start.routeToTarget = res.detailed;
                start.targetInd = target.ind;
            }
            if (gctx.ctx.getVisitor() != null) {
                gctx.ctx.getVisitor().visitApproximatedSegments(res.detailed, start, target);
            }
        }
        return routeIsCorrect;
    }

    private boolean isRouteCloseToGpxPoints(float minPointApproximation, List<RoutePlannerFrontEnd.GpxPoint> gpxPoints, RoutePlannerFrontEnd.GpxPoint start, RoutePlannerFrontEnd.GpxPoint next) {
        boolean routeIsClose = true;
        block0: for (RouteSegmentResult r : start.routeToTarget) {
            int end = r.getEndPointIndex();
            for (int st = r.getStartPointIndex(); st != end; st += st < end ? 1 : -1) {
                LatLon point = r.getPoint(st);
                boolean pointIsClosed = false;
                int delta = 5;
                int startInd = Math.max(0, start.ind - delta);
                int nextInd = Math.min(gpxPoints.size() - 1, next.ind + delta);
                for (int k = startInd; !pointIsClosed && k < nextInd; ++k) {
                    pointIsClosed = this.pointCloseEnough(minPointApproximation, point, gpxPoints.get(k), gpxPoints.get(k + 1));
                }
                if (pointIsClosed) continue;
                routeIsClose = false;
                continue block0;
            }
        }
        return routeIsClose;
    }

    private boolean pointCloseEnough(float minPointApproximation, LatLon point, RoutePlannerFrontEnd.GpxPoint gpxPoint, RoutePlannerFrontEnd.GpxPoint gpxPointNext) {
        LatLon gpxPointLL = gpxPoint.pnt != null ? gpxPoint.pnt.getPreciseLatLon() : gpxPoint.loc;
        LatLon gpxPointNextLL = gpxPointNext.pnt != null ? gpxPointNext.pnt.getPreciseLatLon() : gpxPointNext.loc;
        double orthogonalDistance = MapUtils.getOrthogonalDistance(point.getLatitude(), point.getLongitude(), gpxPointLL.getLatitude(), gpxPointLL.getLongitude(), gpxPointNextLL.getLatitude(), gpxPointNextLL.getLongitude());
        return orthogonalDistance <= (double)minPointApproximation;
    }

    private boolean pointCloseEnough(GpxRouteApproximation gctx, RoutePlannerFrontEnd.GpxPoint ipoint, RouteResultPreparation.RouteCalcResult res) {
        int px = MapUtils.get31TileNumberX(ipoint.loc.getLongitude());
        int py = MapUtils.get31TileNumberY(ipoint.loc.getLatitude());
        double SQR = gctx.ctx.config.minPointApproximation;
        SQR *= SQR;
        for (RouteSegmentResult sr : res.detailed) {
            int start = sr.getStartPointIndex();
            int end = sr.getEndPointIndex();
            if (sr.getStartPointIndex() > sr.getEndPointIndex()) {
                start = sr.getEndPointIndex();
                end = sr.getStartPointIndex();
            }
            for (int i = start; i < end; ++i) {
                RouteDataObject r = sr.getObject();
                QuadPointDouble pp = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(i), r.getPoint31YTile(i), r.getPoint31XTile(i + 1), r.getPoint31YTile(i + 1));
                double currentsDist = RoutePlannerFrontEnd.squareDist((int)pp.x, (int)pp.y, px, py);
                if (!(currentsDist <= SQR)) continue;
                return true;
            }
        }
        return false;
    }
}

