/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.render;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.render.RenderingRuleProperty;
import net.osmand.render.RenderingRulesStorage;
import net.osmand.util.Algorithms;

public class RenderingRule {
    private RenderingRuleProperty[] properties;
    private int[] intProperties;
    private RenderingRule[] attributesRef;
    private float[] floatProperties;
    private List<RenderingRule> ifElseChildren;
    private List<RenderingRule> ifChildren;
    private final boolean isGroup;
    private final RenderingRulesStorage storage;
    private Map<String, String> attributes;

    public RenderingRule(Map<String, String> attributes, boolean isGroup, RenderingRulesStorage storage) {
        this.isGroup = isGroup;
        this.storage = storage;
        this.init(attributes);
    }

    public void storeAttributes(Map<String, String> attributes) {
        this.attributes = new HashMap<String, String>(attributes);
    }

    public Map<String, String> getAttributes() {
        return this.attributes == null ? Collections.EMPTY_MAP : this.attributes;
    }

    public boolean hasAttributes(Map<String, String> attributes) {
        for (Map.Entry<String, String> tagValue : attributes.entrySet()) {
            if (tagValue.getValue().equals(this.attributes.get(tagValue.getKey()))) continue;
            return false;
        }
        return true;
    }

    public void init(Map<String, String> attributes) {
        ArrayList<RenderingRuleProperty> props = new ArrayList<RenderingRuleProperty>(attributes.size());
        this.intProperties = new int[attributes.size()];
        this.floatProperties = new float[attributes.size()];
        this.attributesRef = null;
        int i = 0;
        for (Map.Entry<String, String> e : attributes.entrySet()) {
            RenderingRuleProperty property = this.storage.PROPS.get(e.getKey());
            if (property == null) continue;
            props.add(property);
            String vl = e.getValue();
            if (vl.startsWith("$")) {
                if (this.attributesRef == null) {
                    this.attributesRef = new RenderingRule[attributes.size()];
                }
                this.attributesRef[i] = this.storage.getRenderingAttributeRule(vl.substring(1));
                if (this.attributesRef[i] == null) {
                    this.attributesRef[i] = this.storage.getRenderingAssociationRule(vl.substring(1));
                }
            } else if (property.isString()) {
                this.intProperties[i] = this.storage.getDictionaryValue(vl);
            } else {
                float floatVal;
                this.floatProperties[i] = floatVal = property.parseFloatValue(vl);
                this.intProperties[i] = property.parseIntValue(vl);
            }
            ++i;
        }
        this.properties = props.toArray(new RenderingRuleProperty[0]);
    }

    private int getPropertyIndex(String property) {
        for (int i = 0; i < this.properties.length; ++i) {
            RenderingRuleProperty prop = this.properties[i];
            if (!prop.getAttrName().equals(property)) continue;
            return i;
        }
        return -1;
    }

    public String getStringPropertyValue(String property) {
        int i = this.getPropertyIndex(property);
        if (i >= 0) {
            return this.storage.getStringValue(this.intProperties[i]);
        }
        return null;
    }

    public float getFloatPropertyValue(String property) {
        int i = this.getPropertyIndex(property);
        if (i >= 0) {
            return this.floatProperties[i];
        }
        return 0.0f;
    }

    public String getColorPropertyValue(String property) {
        int i = this.getPropertyIndex(property);
        if (i >= 0) {
            return Algorithms.colorToString(this.intProperties[i]);
        }
        return null;
    }

    public int getIntPropertyValue(String property) {
        int i = this.getPropertyIndex(property);
        if (i >= 0) {
            return this.intProperties[i];
        }
        return -1;
    }

    protected int getIntProp(int ind) {
        return this.intProperties[ind];
    }

    protected RenderingRule getAttrProp(int ind) {
        if (this.attributesRef == null) {
            return null;
        }
        return this.attributesRef[ind];
    }

    protected float getFloatProp(int ind) {
        return this.floatProperties[ind];
    }

    public RenderingRuleProperty[] getProperties() {
        return this.properties;
    }

    public List<RenderingRule> getIfChildren() {
        return this.ifChildren != null ? this.ifChildren : Collections.EMPTY_LIST;
    }

    public List<RenderingRule> getIfElseChildren() {
        return this.ifElseChildren != null ? this.ifElseChildren : Collections.EMPTY_LIST;
    }

    public void addIfChildren(RenderingRule rr) {
        if (this.ifChildren == null) {
            this.ifChildren = new ArrayList<RenderingRule>();
        }
        this.ifChildren.add(rr);
    }

    public void addIfElseChildren(RenderingRule rr) {
        if (this.ifElseChildren == null) {
            this.ifElseChildren = new ArrayList<RenderingRule>();
        }
        this.ifElseChildren.add(rr);
    }

    public void addToBeginIfElseChildren(RenderingRule rr) {
        if (this.ifElseChildren == null) {
            this.ifElseChildren = new ArrayList<RenderingRule>();
        }
        this.ifElseChildren.add(0, rr);
    }

    public boolean isGroup() {
        return this.isGroup;
    }

    public void removeIfChildren(RenderingRule rule) {
        if (this.ifChildren != null) {
            ArrayList<RenderingRule> children = new ArrayList<RenderingRule>(this.ifChildren);
            children.remove(rule);
            this.ifChildren = children;
        }
    }

    public void removeIfElseChildren(RenderingRule rule) {
        if (this.ifElseChildren != null) {
            ArrayList<RenderingRule> children = new ArrayList<RenderingRule>(this.ifElseChildren);
            children.remove(rule);
            this.ifElseChildren = children;
        }
    }

    public String toString() {
        StringBuilder bls = new StringBuilder();
        this.toString("", bls);
        return bls.toString();
    }

    public StringBuilder toString(String indent, StringBuilder bls) {
        String cindent;
        if (this.isGroup) {
            bls.append("switch test [");
        } else {
            bls.append(" test [");
        }
        this.printAttrs(bls, true);
        bls.append("]");
        bls.append(" set [");
        this.printAttrs(bls, false);
        bls.append("]");
        for (RenderingRule rc : this.getIfElseChildren()) {
            cindent = indent + "* case ";
            bls.append("\n").append(cindent);
            rc.toString(indent + "*    ", bls);
        }
        for (RenderingRule rc : this.getIfChildren()) {
            cindent = indent + "* apply ";
            bls.append("\n").append(cindent);
            rc.toString(indent + "*    ", bls);
        }
        return bls;
    }

    protected void printAttrs(StringBuilder bls, boolean in) {
        for (RenderingRuleProperty p : this.getProperties()) {
            if (p.isInputProperty() != in) continue;
            bls.append(" ").append(p.getAttrName()).append("= ");
            if (this.attributesRef != null && this.attributesRef[this.getPropertyIndex(p.getAttrName())] != null) {
                bls.append(this.attributesRef[this.getPropertyIndex(p.getAttrName())]);
                continue;
            }
            if (p.isString()) {
                bls.append("\"").append(this.getStringPropertyValue(p.getAttrName())).append("\"");
                continue;
            }
            if (p.isFloat()) {
                bls.append(this.getFloatPropertyValue(p.getAttrName()));
                continue;
            }
            if (p.isColor()) {
                bls.append(this.getColorPropertyValue(p.getAttrName()));
                continue;
            }
            if (!p.isIntParse()) continue;
            bls.append(this.getIntPropertyValue(p.getAttrName()));
        }
    }
}

