/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.osmand.data.LatLon;
import net.osmand.data.Multipolygon;
import net.osmand.data.MultipolygonBuilder;
import net.osmand.data.Ring;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;
import net.osmand.util.MapAlgorithms;
import net.osmand.util.MapUtils;

public class OsmMapUtils {
    private static final double POLY_CENTER_PRECISION = 1.0E-6;
    private static final int LOOP_LIMITATION = 10000000;

    public static double getDistance(Node e1, Node e2) {
        return MapUtils.getDistance(e1.getLatitude(), e1.getLongitude(), e2.getLatitude(), e2.getLongitude());
    }

    public static double getDistance(Node e1, double latitude, double longitude) {
        return MapUtils.getDistance(e1.getLatitude(), e1.getLongitude(), latitude, longitude);
    }

    public static double getDistance(Node e1, LatLon point) {
        return MapUtils.getDistance(e1.getLatitude(), e1.getLongitude(), point.getLatitude(), point.getLongitude());
    }

    public static boolean isMultipolygon(Map<String, String> tags) {
        return "multipolygon".equals(tags.get(OSMSettings.OSMTagKey.TYPE.getValue())) || "protected_area".equals(tags.get(OSMSettings.OSMTagKey.BOUNDARY.getValue())) || "low_emission_zone".equals(tags.get(OSMSettings.OSMTagKey.BOUNDARY.getValue())) || "national_park".equals(tags.get(OSMSettings.OSMTagKey.BOUNDARY.getValue())) || "danger_area".equals(tags.get(OSMSettings.OSMTagKey.MILITARY.getValue()));
    }

    public static LatLon getCenter(Entity e) {
        if (e instanceof Node) {
            return ((Node)e).getLatLon();
        }
        if (e instanceof Way) {
            return OsmMapUtils.getWeightCenterForWay((Way)e);
        }
        if (e instanceof Relation) {
            ArrayList<LatLon> list = new ArrayList<LatLon>();
            if (OsmMapUtils.isMultipolygon(e.getTags())) {
                MultipolygonBuilder original = new MultipolygonBuilder();
                original.setId(e.getId());
                for (Relation.RelationMember es : ((Relation)e).getMembers()) {
                    if (!(es.getEntity() instanceof Way)) continue;
                    boolean inner = "inner".equals(es.getRole());
                    if (inner) {
                        original.addInnerWay((Way)es.getEntity());
                        continue;
                    }
                    if (!"outer".equals(es.getRole())) continue;
                    original.addOuterWay((Way)es.getEntity());
                }
                List<Multipolygon> multipolygons = original.splitPerOuterRing(null);
                if (!Algorithms.isEmpty(multipolygons)) {
                    Multipolygon m = multipolygons.get(0);
                    List<Node> out = m.getOuterRings().get(0).getBorder();
                    ArrayList<List<Node>> inner = new ArrayList<List<Node>>();
                    if (!Algorithms.isEmpty(out)) {
                        for (Ring r : m.getInnerRings()) {
                            inner.add(r.getBorder());
                        }
                    }
                    if (!Algorithms.isEmpty(out)) {
                        return OsmMapUtils.getComplexPolyCenter(out, inner);
                    }
                }
            }
            for (Relation.RelationMember fe : ((Relation)e).getMembers()) {
                LatLon c = null;
                if (!(fe.getEntity() instanceof Relation) && fe.getEntity() != null) {
                    c = OsmMapUtils.getCenter(fe.getEntity());
                }
                if (c == null) continue;
                list.add(c);
            }
            return OsmMapUtils.getWeightCenter(list);
        }
        return null;
    }

    public static LatLon getComplexPolyCenter(Collection<Node> outer, List<List<Node>> inner) {
        if (outer.size() > 3 && outer.size() <= 5 && inner == null) {
            ArrayList<Node> sub = new ArrayList<Node>(outer);
            return OsmMapUtils.getWeightCenterForNodes(sub.subList(0, sub.size() - 1));
        }
        ArrayList<List<LatLon>> rings = new ArrayList<List<LatLon>>();
        ArrayList<LatLon> outerRing = new ArrayList<LatLon>();
        for (Node node : outer) {
            outerRing.add(new LatLon(node.getLatitude(), node.getLongitude()));
        }
        rings.add(outerRing);
        if (!Algorithms.isEmpty(inner)) {
            for (List list : inner) {
                if (Algorithms.isEmpty(list)) continue;
                ArrayList<LatLon> ringll = new ArrayList<LatLon>();
                for (Node n : list) {
                    ringll.add(n.getLatLon());
                }
                rings.add(ringll);
            }
        }
        return OsmMapUtils.getPolylabelPoint(rings);
    }

    public static LatLon getWeightCenter(Collection<LatLon> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        double longitude = 0.0;
        double latitude = 0.0;
        for (LatLon n : nodes) {
            longitude += n.getLongitude();
            latitude += n.getLatitude();
        }
        return new LatLon(latitude / (double)nodes.size(), longitude / (double)nodes.size());
    }

    public static LatLon getWeightCenterForNodes(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        double longitude = 0.0;
        double latitude = 0.0;
        int count = 0;
        for (Node n : nodes) {
            if (n == null) continue;
            ++count;
            longitude += n.getLongitude();
            latitude += n.getLatitude();
        }
        if (count == 0) {
            return null;
        }
        return new LatLon(latitude / (double)count, longitude / (double)count);
    }

    public static LatLon getWeightCenterForWay(Way w) {
        LatLon ll;
        boolean area;
        List<Node> nodes = w.getNodes();
        if (nodes.isEmpty()) {
            return null;
        }
        boolean bl = area = w.getFirstNodeId() == w.getLastNodeId();
        if (area) {
            Node fn = w.getFirstNode();
            Node ln = w.getLastNode();
            area = fn != null && fn != null && MapUtils.getDistance(fn.getLatLon(), ln.getLatLon()) < 50.0;
        }
        LatLon latLon = ll = area ? OsmMapUtils.getComplexPolyCenter(nodes, null) : OsmMapUtils.getWeightCenterForNodes(nodes);
        if (ll == null) {
            return null;
        }
        double flat = ll.getLatitude();
        double flon = ll.getLongitude();
        if (!area || !MapAlgorithms.containsPoint(nodes, ll.getLatitude(), ll.getLongitude())) {
            double minDistance = Double.MAX_VALUE;
            for (Node n : nodes) {
                double d;
                if (n == null || !((d = MapUtils.getDistance(n.getLatitude(), n.getLongitude(), ll.getLatitude(), ll.getLongitude())) < minDistance)) continue;
                flat = n.getLatitude();
                flon = n.getLongitude();
                minDistance = d;
            }
        }
        return new LatLon(flat, flon);
    }

    public static LatLon getMathWeightCenterForNodes(Collection<Node> nodes) {
        if (nodes.isEmpty()) {
            return null;
        }
        double longitude = 0.0;
        double latitude = 0.0;
        double sumDist = 0.0;
        Node prev = null;
        for (Node n : nodes) {
            if (n == null) continue;
            if (prev == null) {
                prev = n;
                continue;
            }
            double dist = OsmMapUtils.getDistance(prev, n);
            sumDist += dist;
            longitude += (prev.getLongitude() + n.getLongitude()) * dist / 2.0;
            latitude += (n.getLatitude() + n.getLatitude()) * dist / 2.0;
            prev = n;
        }
        if (sumDist == 0.0) {
            if (prev == null) {
                return null;
            }
            return prev.getLatLon();
        }
        return new LatLon(latitude / sumDist, longitude / sumDist);
    }

    public static void sortListOfEntities(List<? extends Entity> list, final double lat, final double lon) {
        Collections.sort(list, new Comparator<Entity>(){

            @Override
            public int compare(Entity o1, Entity o2) {
                return Double.compare(MapUtils.getDistance(o1.getLatLon(), lat, lon), MapUtils.getDistance(o2.getLatLon(), lat, lon));
            }
        });
    }

    public static void addIdsToList(Collection<? extends Entity> source, List<Long> ids) {
        for (Entity entity : source) {
            ids.add(entity.getId());
        }
    }

    public static boolean ccw(Node A, Node B, Node C) {
        return (C.getLatitude() - A.getLatitude()) * (B.getLongitude() - A.getLongitude()) > (B.getLatitude() - A.getLatitude()) * (C.getLongitude() - A.getLongitude());
    }

    public static boolean intersect2Segments(Node A, Node B, Node C, Node D) {
        return OsmMapUtils.ccw(A, C, D) != OsmMapUtils.ccw(B, C, D) && OsmMapUtils.ccw(A, B, C) != OsmMapUtils.ccw(A, B, D);
    }

    public static boolean[] simplifyDouglasPeucker(List<Node> n, int zoom, int epsilon, List<Node> result, boolean avoidNooses) {
        int last;
        int first;
        if (zoom > 31) {
            zoom = 31;
        }
        boolean[] kept = new boolean[n.size()];
        int nsize = n.size();
        for (first = 0; first < nsize && n.get(first) == null; ++first) {
        }
        for (last = nsize - 1; last >= 0 && n.get(last) == null; --last) {
        }
        if (last - first < 1) {
            return kept;
        }
        boolean checkCycle = true;
        boolean cycle = false;
        while (checkCycle && last > first) {
            checkCycle = false;
            double x1 = MapUtils.getTileNumberX(zoom, n.get(first).getLongitude());
            double y1 = MapUtils.getTileNumberY(zoom, n.get(first).getLatitude());
            double x2 = MapUtils.getTileNumberX(zoom, n.get(last).getLongitude());
            double y2 = MapUtils.getTileNumberY(zoom, n.get(last).getLatitude());
            if (!(Math.abs(x1 - x2) + Math.abs(y1 - y2) < 0.001)) continue;
            --last;
            cycle = true;
            checkCycle = true;
        }
        if (last - first < 1) {
            return kept;
        }
        OsmMapUtils.simplifyDouglasPeucker(n, zoom, epsilon, kept, first, last, avoidNooses);
        result.add(n.get(first));
        for (int i = 0; i < kept.length; ++i) {
            if (!kept[i]) continue;
            result.add(n.get(i));
        }
        if (cycle) {
            result.add(n.get(first));
        }
        kept[first] = true;
        return kept;
    }

    private static void simplifyDouglasPeucker(List<Node> n, int zoom, int epsilon, boolean[] kept, int start, int end, boolean avoidNooses) {
        double dmax = -1.0;
        int index = -1;
        for (int i = start + 1; i <= end - 1; ++i) {
            double d;
            if (n.get(i) == null || !((d = OsmMapUtils.orthogonalDistance(zoom, n.get(start), n.get(end), n.get(i))) > dmax)) continue;
            dmax = d;
            index = i;
        }
        boolean nooseFound = false;
        if (avoidNooses && index >= 0) {
            Node st = n.get(start);
            Node e = n.get(end);
            for (int i = 0; i < n.size() - 1; ++i) {
                if (i == start - 1) {
                    i = end;
                    continue;
                }
                Node np = n.get(i);
                Node np2 = n.get(i + 1);
                if (np == null || np2 == null || !OsmMapUtils.intersect2Segments(st, e, np, np2)) continue;
                nooseFound = true;
                break;
            }
        }
        if (dmax >= (double)epsilon || nooseFound) {
            OsmMapUtils.simplifyDouglasPeucker(n, zoom, epsilon, kept, start, index, avoidNooses);
            OsmMapUtils.simplifyDouglasPeucker(n, zoom, epsilon, kept, index, end, avoidNooses);
        } else {
            kept[end] = true;
        }
    }

    public static void simplifyDouglasPeucker(List<Node> nodes, int start, int end, List<Node> survivedNodes, double epsilon) {
        double dmax = Double.NEGATIVE_INFINITY;
        int index = -1;
        Node startPt = nodes.get(start);
        Node endPt = nodes.get(end);
        for (int i = start + 1; i < end; ++i) {
            Node pt = nodes.get(i);
            double d = MapUtils.getOrthogonalDistance(pt.getLatitude(), pt.getLongitude(), startPt.getLatitude(), startPt.getLongitude(), endPt.getLatitude(), endPt.getLongitude());
            if (!(d > dmax)) continue;
            dmax = d;
            index = i;
        }
        if (dmax > epsilon) {
            OsmMapUtils.simplifyDouglasPeucker(nodes, start, index, survivedNodes, epsilon);
            OsmMapUtils.simplifyDouglasPeucker(nodes, index, end, survivedNodes, epsilon);
        } else {
            survivedNodes.add(nodes.get(end));
        }
    }

    private static double orthogonalDistance(int zoom, Node nodeLineStart, Node nodeLineEnd, Node node) {
        LatLon p = MapUtils.getProjection(node.getLatitude(), node.getLongitude(), nodeLineStart.getLatitude(), nodeLineStart.getLongitude(), nodeLineEnd.getLatitude(), nodeLineEnd.getLongitude());
        double x1 = MapUtils.getTileNumberX(zoom, p.getLongitude());
        double y1 = MapUtils.getTileNumberY(zoom, p.getLatitude());
        double x2 = MapUtils.getTileNumberX(zoom, node.getLongitude());
        double y2 = MapUtils.getTileNumberY(zoom, node.getLatitude());
        double C = x2 - x1;
        double D = y2 - y1;
        return Math.sqrt(C * C + D * D);
    }

    public static boolean isClockwiseWay(Way w) {
        return OsmMapUtils.isClockwiseWay(Collections.singletonList(w));
    }

    public static boolean isClockwiseWay(List<Way> ways) {
        if (ways.isEmpty()) {
            return true;
        }
        LatLon latLon = ways.get(0).getLatLon();
        double lat = latLon.getLatitude();
        double lon = 180.0;
        double firstLon = -360.0;
        boolean firstDirectionUp = false;
        double previousLon = -360.0;
        double clockwiseSum = 0.0;
        Node prev = null;
        boolean firstWay = true;
        for (Way w : ways) {
            List<Node> ns = w.getNodes();
            int startInd = 0;
            int nssize = ns.size();
            if (firstWay && nssize > 0) {
                prev = ns.get(0);
                startInd = 1;
                firstWay = false;
            }
            for (int i = startInd; i < nssize; ++i) {
                Node next = ns.get(i);
                double rlon = OsmMapUtils.ray_intersect_lon(prev, next, lat, lon);
                if (rlon != -360.0) {
                    boolean directionUp;
                    boolean skipSameSide;
                    boolean bl = skipSameSide = prev.getLatitude() <= lat == next.getLatitude() <= lat;
                    if (skipSameSide) continue;
                    boolean bl2 = directionUp = prev.getLatitude() <= lat;
                    if (firstLon == -360.0) {
                        firstDirectionUp = directionUp;
                        firstLon = rlon;
                    } else {
                        boolean clockwise;
                        boolean bl3 = clockwise = !directionUp == previousLon < rlon;
                        clockwiseSum = clockwise ? (clockwiseSum += Math.abs(previousLon - rlon)) : (clockwiseSum -= Math.abs(previousLon - rlon));
                    }
                    previousLon = rlon;
                }
                prev = next;
            }
        }
        if (firstLon != -360.0) {
            boolean clockwise;
            boolean bl = clockwise = !firstDirectionUp == previousLon < firstLon;
            clockwiseSum = clockwise ? (clockwiseSum += Math.abs(previousLon - firstLon)) : (clockwiseSum -= Math.abs(previousLon - firstLon));
        }
        return clockwiseSum >= 0.0;
    }

    public static double ray_intersect_lon(Node node, Node node2, double latitude, double longitude) {
        Node b;
        Node a = node.getLatitude() < node2.getLatitude() ? node : node2;
        Node node3 = b = a == node2 ? node : node2;
        if (latitude == a.getLatitude() || latitude == b.getLatitude()) {
            latitude += 1.0E-8;
        }
        if (latitude < a.getLatitude() || latitude > b.getLatitude()) {
            return -360.0;
        }
        if (longitude < Math.min(a.getLongitude(), b.getLongitude())) {
            return -360.0;
        }
        if (a.getLongitude() == b.getLongitude() && longitude == a.getLongitude()) {
            return longitude;
        }
        double lon = b.getLongitude() - (b.getLatitude() - latitude) * (b.getLongitude() - a.getLongitude()) / (b.getLatitude() - a.getLatitude());
        if (lon <= longitude) {
            return lon;
        }
        return -360.0;
    }

    public static double polygonAreaPixels(List<Node> nodes, int zoom) {
        double area = 0.0;
        double mult = 1.0 / MapUtils.getPowZoom(Math.max(31 - (zoom + 8), 0));
        int j = nodes.size() - 1;
        int i = 0;
        while (i < nodes.size()) {
            Node x = nodes.get(i);
            Node y = nodes.get(j);
            if (x != null && y != null) {
                area += ((double)MapUtils.get31TileNumberX(y.getLongitude()) + (double)MapUtils.get31TileNumberX(x.getLongitude())) * ((double)MapUtils.get31TileNumberY(y.getLatitude()) - (double)MapUtils.get31TileNumberY(x.getLatitude()));
            }
            j = i++;
        }
        return Math.abs(area) * mult * mult * 0.5;
    }

    public static double getArea(List<Node> nodes) {
        double refX = 500.0;
        double refY = 500.0;
        for (Node n : nodes) {
            if (n.getLatitude() < refY) {
                refY = n.getLatitude();
            }
            if (!(n.getLongitude() < refX)) continue;
            refX = n.getLongitude();
        }
        ArrayList<Double> xVal = new ArrayList<Double>();
        ArrayList<Double> yVal = new ArrayList<Double>();
        for (Node n : nodes) {
            double xDist = MapUtils.getDistance(refY, refX, refY, n.getLongitude());
            double yDist = MapUtils.getDistance(refY, refX, n.getLatitude(), refX);
            xVal.add(xDist);
            yVal.add(yDist);
        }
        double area = 0.0;
        for (int i = 1; i < xVal.size(); ++i) {
            area += (Double)xVal.get(i - 1) * (Double)yVal.get(i) - (Double)xVal.get(i) * (Double)yVal.get(i - 1);
        }
        return Math.abs(area) / 2.0;
    }

    public static LatLon getPolylabelPoint(List<List<LatLon>> rings) {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        List<LatLon> outerRingCoordinates = rings.get(0);
        for (LatLon p : outerRingCoordinates) {
            double lat = p.getLatitude();
            double lon = p.getLongitude();
            minX = StrictMath.min(minX, lon);
            minY = StrictMath.min(minY, lat);
            maxX = StrictMath.max(maxX, lon);
            maxY = StrictMath.max(maxY, lat);
        }
        double width = maxX - minX;
        double height = maxY - minY;
        double cellSize = Math.min(width, height);
        double h = cellSize / 2.0;
        if (cellSize == 0.0) {
            return new LatLon(minX, minY);
        }
        PriorityQueue<Cell> cellQueue = new PriorityQueue<Cell>(new CellComparator());
        for (double x = minX; x < maxX; x += cellSize) {
            for (double y = minY; y < maxY; y += cellSize) {
                cellQueue.add(new Cell(x + h, y + h, h, rings));
            }
        }
        Cell bestCell = OsmMapUtils.getCentroidCell(rings);
        if (bestCell == null) {
            return new LatLon(minX, minY);
        }
        Cell bboxCell = new Cell(minX + width / 2.0, minY + height / 2.0, 0.0, rings);
        if (bboxCell.d > bestCell.d) {
            bestCell = bboxCell;
        }
        int count = 0;
        while (!cellQueue.isEmpty()) {
            if (count > 10000000) {
                System.err.println("Error loop limitation: 10000000");
                break;
            }
            Cell cell = cellQueue.poll();
            if (cell.d > bestCell.d) {
                bestCell = cell;
            }
            if (cell.max - bestCell.d <= 1.0E-6) continue;
            h = cell.h / 2.0;
            cellQueue.add(new Cell(cell.x - h, cell.y - h, h, rings));
            cellQueue.add(new Cell(cell.x + h, cell.y - h, h, rings));
            cellQueue.add(new Cell(cell.x - h, cell.y + h, h, rings));
            cellQueue.add(new Cell(cell.x + h, cell.y + h, h, rings));
            ++count;
        }
        return new LatLon(bestCell.y, bestCell.x);
    }

    private static Cell getCentroidCell(List<List<LatLon>> rings) {
        double area = 0.0;
        double x = 0.0;
        double y = 0.0;
        List<LatLon> points = rings.get(0);
        int i = 0;
        int len = points.size();
        int j = len - 1;
        while (i < len) {
            LatLon a = points.get(i);
            LatLon b = points.get(j);
            double aLon = a.getLongitude();
            double aLat = a.getLatitude();
            double bLon = b.getLongitude();
            double bLat = b.getLatitude();
            double f = aLon * bLat - bLon * aLat;
            x += (aLon + bLon) * f;
            y += (aLat + bLat) * f;
            area += f * 3.0;
            j = i++;
        }
        if (area == 0.0) {
            if (points.size() == 0) {
                return null;
            }
            LatLon p = points.get(0);
            return new Cell(p.getLatitude(), p.getLongitude(), 0.0, rings);
        }
        return new Cell(x / area, y / area, 0.0, rings);
    }

    private static class CellComparator
    implements Comparator<Cell> {
        private CellComparator() {
        }

        @Override
        public int compare(Cell o1, Cell o2) {
            return Double.compare(o2.max, o1.max);
        }
    }

    private static class Cell {
        private final double x;
        private final double y;
        private final double h;
        private final double d;
        private final double max;

        private Cell(double x, double y, double h, List<List<LatLon>> rings) {
            this.x = x;
            this.y = y;
            this.h = h;
            this.d = this.pointToPolygonDist(x, y, rings);
            this.max = this.d + this.h * Math.sqrt(2.0);
        }

        private double pointToPolygonDist(double x, double y, List<List<LatLon>> rings) {
            boolean inside = false;
            double minDistSq = Double.MAX_VALUE;
            for (List<LatLon> ring : rings) {
                int i = 0;
                int len = ring.size();
                int j = len - 1;
                while (i < len) {
                    double bLat;
                    LatLon a = ring.get(i);
                    LatLon b = ring.get(j);
                    double aLon = a.getLongitude();
                    double aLat = a.getLatitude();
                    double bLon = b.getLongitude();
                    if (aLat > y != (bLat = b.getLatitude()) > y && x < (bLon - aLon) * (y - aLat) / (bLat - aLat) + aLon) {
                        inside = !inside;
                    }
                    minDistSq = Math.min(minDistSq, this.getSegmentDistanceSqared(x, y, a, b));
                    j = i++;
                }
            }
            return (double)(inside ? 1 : -1) * Math.sqrt(minDistSq);
        }

        private double getSegmentDistanceSqared(double px, double py, LatLon a, LatLon b) {
            double x = a.getLongitude();
            double y = a.getLatitude();
            double dx = b.getLongitude() - x;
            double dy = b.getLatitude() - y;
            if (dx != 0.0 || dy != 0.0) {
                double t = ((px - x) * dx + (py - y) * dy) / (dx * dx + dy * dy);
                if (t > 1.0) {
                    x = b.getLongitude();
                    y = b.getLatitude();
                } else if (t > 0.0) {
                    x += dx * t;
                    y += dy * t;
                }
            }
            dx = px - x;
            dy = py - y;
            return dx * dx + dy * dy;
        }
    }
}

