/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.edit;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.osmand.data.LatLon;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.Algorithms;

public abstract class Entity
implements Serializable {
    private Map<String, String> tags = null;
    private Set<String> changedTags;
    private final long id;
    private boolean dataLoaded;
    private int modify;
    private int version;
    private double latitude;
    private double longitude;
    public static final int MODIFY_UNKNOWN = 0;
    public static final int MODIFY_DELETED = -1;
    public static final int MODIFY_MODIFIED = 1;
    public static final int MODIFY_CREATED = 2;
    public static final String POI_TYPE_TAG = "poi_type_tag";
    public static final String REMOVE_TAG_PREFIX = "----";

    public Entity(long id) {
        this.id = id;
    }

    public Entity(long id, double latitude, double longitude) {
        this.id = id;
        this.latitude = latitude;
        this.longitude = longitude;
    }

    public Entity(Entity copy, long id) {
        this.id = id;
        this.copyTags(copy);
        this.dataLoaded = copy.dataLoaded;
        this.latitude = copy.latitude;
        this.longitude = copy.longitude;
    }

    public void copyTags(Entity copy) {
        for (String t : copy.getTagKeySet()) {
            this.putTagNoLC(t, copy.getTag(t));
        }
    }

    public Set<String> getChangedTags() {
        return this.changedTags;
    }

    public void setChangedTags(Set<String> changedTags) {
        this.changedTags = changedTags;
    }

    public int getModify() {
        return this.modify;
    }

    public void setModify(int modify) {
        this.modify = modify;
    }

    public long getId() {
        return this.id;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public String removeTag(String key) {
        if (this.tags != null) {
            return this.tags.remove(key);
        }
        return null;
    }

    public void removeTags(String ... keys) {
        if (this.tags != null) {
            for (String key : keys) {
                this.tags.remove(key);
            }
        }
    }

    public String putTag(String key, String value) {
        return this.putTagNoLC(key.toLowerCase(), value);
    }

    public String putTagNoLC(String key, String value) {
        if (this.tags == null) {
            this.tags = new LinkedHashMap<String, String>();
        }
        return this.tags.put(key, value);
    }

    public void replaceTags(Map<String, String> toPut) {
        this.tags = new LinkedHashMap<String, String>(toPut);
    }

    public String getTag(OSMSettings.OSMTagKey key) {
        return this.getTag(key.getValue());
    }

    public String getTag(String key) {
        if (this.tags == null) {
            return null;
        }
        return this.tags.get(key);
    }

    public Map<String, String> getNameTags() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (Map.Entry<String, String> e : this.tags.entrySet()) {
            if (!e.getKey().startsWith("name:")) continue;
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public Map<String, String> getTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return Collections.unmodifiableMap(this.tags);
    }

    public boolean isNotValid(String tag) {
        String val = this.getTag(tag);
        return val == null || val.length() == 0 || tag.length() == 0 || tag.startsWith(REMOVE_TAG_PREFIX) || tag.equals(POI_TYPE_TAG);
    }

    public Collection<String> getTagKeySet() {
        if (this.tags == null) {
            return Collections.emptyList();
        }
        return this.tags.keySet();
    }

    public abstract void initializeLinks(Map<EntityId, Entity> var1);

    public abstract LatLon getLatLon();

    public boolean isVirtual() {
        return this.id < 0L;
    }

    public String getOsmUrl() {
        return EntityId.valueOf(this).getOsmUrl();
    }

    public String toString() {
        return EntityId.valueOf(this).toString();
    }

    public int hashCode() {
        if (this.id < 0L) {
            return System.identityHashCode(this);
        }
        return (int)this.id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (this.id != other.id) {
            return false;
        }
        return this.id >= 0L;
    }

    public Set<String> getIsInNames() {
        String values = this.getTag(OSMSettings.OSMTagKey.IS_IN);
        if (values == null) {
            String city = this.getTag(OSMSettings.OSMTagKey.ADDR_CITY);
            String place = this.getTag(OSMSettings.OSMTagKey.ADDR_PLACE);
            if (!Algorithms.isEmpty(city)) {
                return Collections.singleton(city.trim());
            }
            if (!Algorithms.isEmpty(place)) {
                return Collections.singleton(place.trim());
            }
            return Collections.emptySet();
        }
        if (values.indexOf(59) != -1) {
            String[] splitted = values.split(";");
            HashSet<String> set = new HashSet<String>(splitted.length);
            for (int i = 0; i < splitted.length; ++i) {
                set.add(splitted[i].trim());
            }
            return set;
        }
        return Collections.singleton(values.trim());
    }

    public void entityDataLoaded() {
        this.dataLoaded = true;
    }

    public boolean isDataLoaded() {
        return this.dataLoaded;
    }

    public Map<String, String> getModifiableTags() {
        if (this.tags == null) {
            return Collections.emptyMap();
        }
        return this.tags;
    }

    public boolean compareEntity(Entity thatObj) {
        if (this == thatObj) {
            return true;
        }
        return this.id == thatObj.id && Math.abs(this.latitude - thatObj.latitude) < 1.0E-5 && Math.abs(this.longitude - thatObj.longitude) < 1.0E-5 && Algorithms.objectEquals(this.tags, thatObj.tags);
    }

    public static class EntityId {
        private final EntityType type;
        private final Long id;

        public EntityId(EntityType type, Long id) {
            this.type = type;
            this.id = id;
        }

        public static EntityId valueOf(Entity e) {
            return new EntityId(EntityType.valueOf(e), e.getId());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public String toString() {
            return this.type + " " + this.id;
        }

        public EntityType getType() {
            return this.type;
        }

        public Long getId() {
            return this.id;
        }

        public String getOsmUrl() {
            String browseUrl = "https://www.openstreetmap.org/browse/";
            if (this.type == EntityType.NODE) {
                return "https://www.openstreetmap.org/browse/node/" + this.id;
            }
            if (this.type == EntityType.WAY) {
                return "https://www.openstreetmap.org/browse/way/" + this.id;
            }
            return null;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            EntityId other = (EntityId)obj;
            if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals((Object)other.type));
        }
    }

    public static enum EntityType {
        NODE,
        WAY,
        RELATION,
        WAY_BOUNDARY;


        public static EntityType valueOf(Entity e) {
            if (e instanceof Node) {
                return NODE;
            }
            if (e instanceof Way) {
                return WAY;
            }
            if (e instanceof Relation) {
                return RELATION;
            }
            return null;
        }
    }
}

