/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;

public class PoiFilter
extends AbstractPoiType {
    private PoiCategory pc;
    private List<PoiType> poiTypes = new ArrayList<PoiType>();
    private Map<String, PoiType> map = new LinkedHashMap<String, PoiType>();
    private final String iconKeyName;

    public PoiFilter(MapPoiTypes registry, PoiCategory pc, String keyName, String iconKeyName) {
        super(keyName, registry);
        this.iconKeyName = iconKeyName;
        this.pc = pc;
    }

    public PoiCategory getPoiCategory() {
        return this.pc;
    }

    public PoiType getPoiTypeByKeyName(String kn) {
        return this.map.get(kn);
    }

    public void addExtraPoiTypes(Map<String, PoiType> poiTypesToAdd) {
        ArrayList<PoiType> npoiTypes = null;
        LinkedHashMap<String, PoiType> nmap = null;
        for (PoiType poiType : poiTypesToAdd.values()) {
            String keyName = poiType.getKeyName();
            if (this.map.containsKey(keyName) || this.registry.isTypeForbidden(keyName)) continue;
            if (npoiTypes == null) {
                npoiTypes = new ArrayList<PoiType>(this.poiTypes);
                nmap = new LinkedHashMap<String, PoiType>(this.map);
            }
            npoiTypes.add(poiType);
            nmap.put(keyName, poiType);
        }
        if (npoiTypes != null) {
            this.poiTypes = npoiTypes;
            this.map = nmap;
        }
    }

    public void addPoiType(PoiType type) {
        if (this.registry.isTypeForbidden(type.keyName)) {
            return;
        }
        if (!this.map.containsKey(type.getKeyName())) {
            this.poiTypes.add(type);
            this.map.put(type.getKeyName(), type);
        } else {
            PoiType prev = this.map.get(type.getKeyName());
            if (prev.isReference()) {
                this.poiTypes.remove(prev);
                this.poiTypes.add(type);
                this.map.put(type.getKeyName(), type);
            }
        }
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        if (!acceptedTypes.containsKey(this.pc)) {
            acceptedTypes.put(this.pc, new LinkedHashSet());
        }
        LinkedHashSet<String> set = acceptedTypes.get(this.pc);
        for (PoiType pt : this.poiTypes) {
            set.add(pt.getKeyName());
        }
        this.addReferenceTypes(acceptedTypes);
        return acceptedTypes;
    }

    protected void addReferenceTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        for (PoiType pt : this.getPoiTypes()) {
            LinkedHashSet<String> ls;
            if (!pt.isReference()) continue;
            PoiCategory refCat = pt.getReferenceType().getCategory();
            if (!acceptedTypes.containsKey(refCat)) {
                acceptedTypes.put(refCat, new LinkedHashSet());
            }
            if ((ls = acceptedTypes.get(refCat)) == null) continue;
            ls.add(pt.getKeyName());
        }
    }

    @Override
    public String getIconKeyName() {
        return this.formatKeyName(this.iconKeyName != null ? this.iconKeyName : this.getKeyName());
    }

    public List<PoiType> getPoiTypes() {
        return this.poiTypes;
    }
}

