/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;

public class PoiCategory
extends PoiFilter {
    private List<PoiFilter> poiFilters = new ArrayList<PoiFilter>();
    private Set<PoiType> basemapPoi = null;
    private int regId;
    private String defaultTag;

    public PoiCategory(MapPoiTypes registry, String keyName, int regId) {
        super(registry, null, keyName, null);
        this.regId = regId;
    }

    public void addPoiType(PoiFilter poi) {
        this.poiFilters.add(poi);
    }

    public List<PoiFilter> getPoiFilters() {
        return this.poiFilters;
    }

    public PoiFilter getPoiFilterByName(String keyName) {
        for (PoiFilter f : this.poiFilters) {
            if (!f.getKeyName().equals(keyName)) continue;
            return f;
        }
        return null;
    }

    public String getDefaultTag() {
        if (this.defaultTag == null) {
            return this.keyName;
        }
        return this.defaultTag;
    }

    public void setDefaultTag(String defaultTag) {
        this.defaultTag = defaultTag;
    }

    @Override
    public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
        acceptedTypes.put(this, null);
        this.addReferenceTypes(acceptedTypes);
        return acceptedTypes;
    }

    public boolean isWiki() {
        return this.keyName.equals("osmwiki");
    }

    public boolean isRoutes() {
        return this.keyName.equals("routes");
    }

    public int ordinal() {
        return this.regId;
    }

    public void addBasemapPoi(PoiType pt) {
        if (this.basemapPoi == null) {
            this.basemapPoi = new HashSet<PoiType>();
        }
        this.basemapPoi.add(pt);
    }

    public boolean containsBasemapPoi(PoiType pt) {
        if (this.basemapPoi == null) {
            return false;
        }
        return this.basemapPoi.contains(pt);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PoiCategory other = (PoiCategory)obj;
        return this.regId == other.regId && Objects.equals(this.keyName, other.keyName) && Objects.equals(this.defaultTag, other.defaultTag);
    }

    public int hashCode() {
        int result = 8;
        result = 88 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
        result = 88 * result + this.regId;
        result = 88 * result + (this.defaultTag != null ? this.defaultTag.hashCode() : 0);
        return result;
    }
}

