/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.osmand.binary.BinaryMapDataObject;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.network.NetworkRouteSelector;
import net.osmand.util.Algorithms;

public class OsmRouteType {
    private static final List<OsmRouteType> values = new ArrayList<OsmRouteType>();
    public static final String DEFAULT_ICON = "special_marker";
    public static final String DEFAULT_COLOR = "orange";
    public static final OsmRouteType WATER = OsmRouteType.createType("water").color("yellow").icon("special_kayak").renderingPropertyAttr("whiteWaterSports").reg();
    public static final OsmRouteType WINTER = OsmRouteType.createType("winter").color("yellow").icon("special_skiing").reg();
    public static final OsmRouteType SNOWMOBILE = OsmRouteType.createType("snowmobile").color("yellow").icon("special_snowmobile").reg();
    public static final OsmRouteType RIDING = OsmRouteType.createType("riding").color("yellow").icon("special_horse").reg();
    public static final OsmRouteType RACING = OsmRouteType.createType("racing").color("yellow").icon("raceway").reg();
    public static final OsmRouteType MOUNTAINBIKE = OsmRouteType.createType("mountainbike").color("blue").icon("sport_cycling").reg();
    public static final OsmRouteType BICYCLE = OsmRouteType.createType("bicycle").renderingPropertyAttr("showCycleRoutes").reg();
    public static final OsmRouteType DIRTBIKE = OsmRouteType.createType("dirtbike").renderingPropertyAttr("showDirtbikeTrails").reg();
    public static final OsmRouteType MTB = OsmRouteType.createType("mtb").renderingPropertyAttr("showMtbRoutes").reg();
    public static final OsmRouteType CYCLING = OsmRouteType.createType("cycling").color("blue").icon("special_bicycle").reg();
    public static final OsmRouteType HIKING = OsmRouteType.createType("hiking").color("orange").icon("special_trekking").renderingPropertyAttr("hikingRoutesOSMC").reg();
    public static final OsmRouteType RUNNING = OsmRouteType.createType("running").color("orange").icon("running").renderingPropertyAttr("showRunningRoutes").reg();
    public static final OsmRouteType WALKING = OsmRouteType.createType("walking").color("orange").icon("special_walking").reg();
    public static final OsmRouteType OFFROAD = OsmRouteType.createType("offroad").color("yellow").icon("special_offroad").reg();
    public static final OsmRouteType MOTORBIKE = OsmRouteType.createType("motorbike").color("green").icon("special_motorcycle").reg();
    public static final OsmRouteType CAR = OsmRouteType.createType("car").color("green").icon("shop_car").reg();
    public static final OsmRouteType HORSE = OsmRouteType.createType("horse").renderingPropertyAttr("horseRoutes").reg();
    public static final OsmRouteType ROAD = OsmRouteType.createType("road").reg();
    public static final OsmRouteType DETOUR = OsmRouteType.createType("detour").reg();
    public static final OsmRouteType BUS = OsmRouteType.createType("bus").reg();
    public static final OsmRouteType CANOE = OsmRouteType.createType("canoe").reg();
    public static final OsmRouteType FERRY = OsmRouteType.createType("ferry").reg();
    public static final OsmRouteType FOOT = OsmRouteType.createType("foot").reg();
    public static final OsmRouteType LIGHT_RAIL = OsmRouteType.createType("light_rail").reg();
    public static final OsmRouteType PISTE = OsmRouteType.createType("piste").reg();
    public static final OsmRouteType RAILWAY = OsmRouteType.createType("railway").reg();
    public static final OsmRouteType SKI = OsmRouteType.createType("ski").renderingPropertyAttr("pisteRoutes").reg();
    public static final OsmRouteType ALPINE = OsmRouteType.createType("alpine").renderingPropertyAttr("alpineHiking").reg();
    public static final OsmRouteType FITNESS = OsmRouteType.createType("fitness").renderingPropertyAttr("showFitnessTrails").reg();
    public static final OsmRouteType INLINE_SKATES = OsmRouteType.createType("inline_skates").reg();
    public static final OsmRouteType SUBWAY = OsmRouteType.createType("subway").reg();
    public static final OsmRouteType TRAIN = OsmRouteType.createType("train").reg();
    public static final OsmRouteType TRACKS = OsmRouteType.createType("tracks").reg();
    public static final OsmRouteType TRAM = OsmRouteType.createType("tram").reg();
    public static final OsmRouteType TROLLEYBUS = OsmRouteType.createType("trolleybus").reg();
    private final String name;
    private final String tagPrefix;
    private String color;
    private String icon;
    private String renderingPropertyAttr;

    OsmRouteType(String name) {
        this.name = name;
        this.tagPrefix = "route_" + name + "_";
    }

    public String getName() {
        return this.name;
    }

    public String getColor() {
        return this.color;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getRenderingPropertyAttr() {
        return this.renderingPropertyAttr;
    }

    public static OsmRouteType getOrCreateTypeFromName(String name) {
        for (OsmRouteType rat : values) {
            if (!rat.name.equalsIgnoreCase(name)) continue;
            return rat;
        }
        return OsmRouteType.createType(name.toLowerCase()).color(DEFAULT_COLOR).icon(DEFAULT_ICON).reg();
    }

    private static RouteActivityTypeBuilder createType(String name) {
        RouteActivityTypeBuilder builder = new RouteActivityTypeBuilder();
        builder.osmRouteType = new OsmRouteType(name);
        return builder;
    }

    public static OsmRouteType getTypeFromTags(String[] tags) {
        OsmRouteType activityType = null;
        for (String tg : tags) {
            OsmRouteType rat = OsmRouteType.convertFromOsmGPXTag(tg);
            if (rat == null || activityType != null && values.indexOf(activityType) <= values.indexOf(rat)) continue;
            activityType = rat;
        }
        return activityType;
    }

    public static OsmRouteType getTypeFromOSMTags(Map<String, String> tags) {
        String rt = tags.get("route");
        if (rt != null) {
            return OsmRouteType.convertFromOsmGPXTag(rt);
        }
        return null;
    }

    public static OsmRouteType convertFromOsmGPXTag(String tg) {
        String t = tg.toLowerCase();
        if ("mountain hiking".equalsIgnoreCase(t)) {
            return HIKING;
        }
        if ("motorcar".equalsIgnoreCase(t)) {
            return CAR;
        }
        if ("laufen".equalsIgnoreCase(t)) {
            return RUNNING;
        }
        if ("pedestrian".equalsIgnoreCase(t)) {
            return WALKING;
        }
        switch (t) {
            case "mountainbiking": 
            case "mtb": 
            case "mountainbike": 
            case "mountain bike": 
            case "mountain biking": 
            case "mountbarker": 
            case "mtb-tour": 
            case "ciclismo-mtb-gravel": 
            case "vtt": 
            case "btt": 
            case "vth": 
            case "mtb ride": {
                return MOUNTAINBIKE;
            }
            case "hiking": 
            case "route=hiking": 
            case "mountain hiking": 
            case "hiking trail": 
            case "wandern": 
            case "hike": 
            case "randonn\u00e9e": 
            case "trekking": 
            case "climbing": {
                return HIKING;
            }
            case "bike": 
            case "biking": 
            case "bicycling": 
            case "bicycle": 
            case "cycling": 
            case "cycle": 
            case "cycleway": 
            case "cykel": 
            case "handcycle": 
            case "cyclotourisme": 
            case "route=bicycle": 
            case "cyclotourism": 
            case "fietsen": 
            case "\u0432\u0435\u043b\u043e": 
            case "\u0432\u0435\u043b\u043e\u0441\u0438\u043f\u0435\u0434": 
            case "rower": 
            case "trasa rowerem": 
            case "v\u00e9lo": 
            case "velo": 
            case "radtour": 
            case "bici": 
            case "fiets": 
            case "fahrrad": 
            case "ncn": 
            case "icn": 
            case "lcn": 
            case "network=ncn": 
            case "network=icn": 
            case "network=lcn": {
                return CYCLING;
            }
            case "car": 
            case "motorcar": 
            case "by car": 
            case "auto": 
            case "\u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u044c": 
            case "automobile": 
            case "aut\u00f3s": 
            case "driving": 
            case "drive": 
            case "van": 
            case "\u0430\u0432\u0442\u043e": 
            case "\u043d\u0430 \u0430\u0432\u0442\u043e\u043c\u043e\u0431\u0438\u043b\u0435": 
            case "bus": 
            case "truck": 
            case "taxi": {
                return CAR;
            }
            case "running": 
            case "run": 
            case "rungis": 
            case "trail running": 
            case "trailrunning": 
            case "\u0431\u0435\u0433": 
            case "laufen": 
            case "langlauf": 
            case "lauf": 
            case "course": 
            case "jogging": 
            case "fitotrack": {
                return RUNNING;
            }
            case "wanderung": 
            case "walking": 
            case "walk": 
            case "nightwalk": 
            case "walkway": 
            case "\u043f\u0435\u0448\u043a\u043e\u043c": 
            case "\u043f\u0435\u0448\u0438\u0439": 
            case "p\u011b\u0161ky": 
            case "marche": 
            case "pedestrian": 
            case "foot": 
            case "footing": 
            case "on_foot": 
            case "byfoot": 
            case "onfoot": 
            case "sightseeing": 
            case "geocaching": 
            case "etnanatura": 
            case "etna": 
            case "iwn": 
            case "lwn": 
            case "rwn": 
            case "network=iwn": 
            case "network=lwn": 
            case "network=rwn": {
                return WALKING;
            }
            case "ling-moto": 
            case "motorbiking": 
            case "motorcycle": 
            case "motorrad": 
            case "motorbike": 
            case "motor bike": 
            case "fvbike": {
                return MOTORBIKE;
            }
            case "offroad": 
            case "off-road": 
            case "off road": 
            case "4x4": 
            case "terrain": 
            case "quad": 
            case "enduro": 
            case "feldwege": 
            case "feldweg": 
            case "rally": {
                return OFFROAD;
            }
            case "boat": 
            case "water": 
            case "boating": 
            case "kayak": 
            case "river": 
            case "lake": 
            case "lakes": 
            case "canal": {
                return WATER;
            }
            case "ski": 
            case "skiing": 
            case "skating": 
            case "skitour": 
            case "winter": 
            case "wintersports": 
            case "snowboard": 
            case "\u043b\u044b\u0436\u0438": 
            case "\u043b\u044b\u0436\u043d\u044f": 
            case "nordic": 
            case "piste": {
                return WINTER;
            }
            case "snowmobile=designated": 
            case "snowmobile=permissive": 
            case "snowmobile=yes": 
            case "snowmobile": {
                return SNOWMOBILE;
            }
            case "ride": 
            case "horse": 
            case "horse trail": {
                return RIDING;
            }
            case "racing": {
                return RACING;
            }
        }
        return null;
    }

    public static OsmRouteType getByTag(String tag) {
        for (OsmRouteType routeType : values) {
            if (!routeType.name.equals(tag)) continue;
            return routeType;
        }
        return null;
    }

    public static OsmRouteType getByRenderingProperty(String renderingProperty) {
        for (OsmRouteType routeType : values) {
            if (routeType.renderingPropertyAttr == null || !routeType.renderingPropertyAttr.equals(renderingProperty)) continue;
            return routeType;
        }
        return null;
    }

    public static List<NetworkRouteSelector.RouteKey> getRouteKeys(RouteDataObject obj) {
        int i;
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (i = 0; obj.nameIds != null && i < obj.nameIds.length; ++i) {
            int nameId = obj.nameIds[i];
            String value = (String)obj.names.get(nameId);
            BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(nameId);
            if (rt == null) continue;
            tags.put(rt.getTag(), value);
        }
        for (i = 0; obj.types != null && i < obj.types.length; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rt = obj.region.quickGetEncodingRule(obj.types[i]);
            if (rt == null) continue;
            tags.put(rt.getTag(), rt.getValue());
        }
        return OsmRouteType.getRouteKeys(tags);
    }

    public static List<NetworkRouteSelector.RouteKey> getRouteKeys(BinaryMapDataObject bMdo) {
        int i;
        BinaryMapIndexReader.TagValuePair tp;
        TreeMap<String, String> tags = new TreeMap<String, String>();
        for (int i2 = 0; i2 < bMdo.getObjectNames().keys().length; ++i2) {
            int keyInd = bMdo.getObjectNames().keys()[i2];
            tp = bMdo.getMapIndex().decodeType(keyInd);
            String value = (String)bMdo.getObjectNames().get(keyInd);
            if (tp == null) continue;
            tags.put(tp.tag, value);
        }
        int[] tps = bMdo.getAdditionalTypes();
        for (i = 0; i < tps.length; ++i) {
            tp = bMdo.getMapIndex().decodeType(tps[i]);
            if (tp == null) continue;
            tags.put(tp.tag, tp.value);
        }
        tps = bMdo.getTypes();
        for (i = 0; i < tps.length; ++i) {
            tp = bMdo.getMapIndex().decodeType(tps[i]);
            if (tp == null) continue;
            tags.put(tp.tag, tp.value);
        }
        return OsmRouteType.getRouteKeys(tags);
    }

    private static int getRouteQuantity(Map<String, String> tags, OsmRouteType rType) {
        int q = 0;
        for (String tag : tags.keySet()) {
            int num;
            if (!tag.startsWith(rType.tagPrefix) || (num = Algorithms.extractIntegerNumber(tag)) <= 0 || !tag.equals(rType.tagPrefix + num)) continue;
            q = Math.max(q, num);
        }
        return q;
    }

    public static List<NetworkRouteSelector.RouteKey> getRouteKeys(Map<String, String> tags) {
        ArrayList<NetworkRouteSelector.RouteKey> lst = new ArrayList<NetworkRouteSelector.RouteKey>();
        for (OsmRouteType routeType : values) {
            int rq = OsmRouteType.getRouteQuantity(tags, routeType);
            for (int routeIdx = 1; routeIdx <= rq; ++routeIdx) {
                String prefix = routeType.tagPrefix + routeIdx;
                NetworkRouteSelector.RouteKey routeKey = new NetworkRouteSelector.RouteKey(routeType);
                for (Map.Entry<String, String> e : tags.entrySet()) {
                    String tag = e.getKey();
                    if (!tag.startsWith(prefix) || tag.length() <= prefix.length()) continue;
                    String key = tag.substring(prefix.length() + 1);
                    routeKey.addTag(key, e.getValue());
                }
                lst.add(routeKey);
            }
        }
        return lst;
    }

    protected static class RenderingPropertyAttr {
        static final String HIKING_ROUTES = "hikingRoutesOSMC";
        static final String CYCLE_ROUTES = "showCycleRoutes";
        static final String MTB_ROUTES = "showMtbRoutes";
        static final String ALPINE_HIKING = "alpineHiking";
        static final String HORSE_ROUTES = "horseRoutes";
        static final String PISTE_ROUTES = "pisteRoutes";
        static final String WHITE_WATER_SPORTS = "whiteWaterSports";
        static final String RUNNING_ROUTES = "showRunningRoutes";
        static final String FITNESS_TRAILS = "showFitnessTrails";
        static final String DIRTBIKE_ROUTES = "showDirtbikeTrails";

        protected RenderingPropertyAttr() {
        }
    }

    public static class RouteActivityTypeBuilder {
        private OsmRouteType osmRouteType;

        public RouteActivityTypeBuilder color(String color) {
            this.osmRouteType.color = color;
            return this;
        }

        public RouteActivityTypeBuilder icon(String icon) {
            this.osmRouteType.icon = icon;
            return this;
        }

        public RouteActivityTypeBuilder renderingPropertyAttr(String renderingPropertyAttr) {
            this.osmRouteType.renderingPropertyAttr = renderingPropertyAttr;
            return this;
        }

        private OsmRouteType reg() {
            values.add(this.osmRouteType);
            return this.osmRouteType;
        }
    }
}

