/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public abstract class MapRenderingTypes {
    private static final Log log = PlatformUtil.getLog(MapRenderingTypes.class);
    public static final String[] langs = new String[]{"af", "als", "ar", "az", "be", "bg", "bn", "bpy", "br", "bs", "ca", "ceb", "ckb", "cs", "cy", "da", "de", "el", "eo", "es", "et", "eu", "fa", "fi", "fr", "fy", "ga", "gl", "he", "hi", "hsb", "hr", "ht", "hu", "hy", "id", "is", "it", "ja", "ka", "kk", "kn", "ko", "ku", "la", "lb", "lo", "lt", "lv", "mk", "ml", "mr", "ms", "nds", "new", "nl", "nn", "no", "nv", "oc", "os", "pl", "pms", "pt", "ro", "ru", "sat", "sc", "sh", "sk", "sl", "sq", "sr", "sr-latn", "sv", "sw", "ta", "te", "th", "tl", "tr", "uk", "vi", "vo", "zh", "zh-hans", "zh-hant"};
    public static final byte RESTRICTION_NO_RIGHT_TURN = 1;
    public static final byte RESTRICTION_NO_LEFT_TURN = 2;
    public static final byte RESTRICTION_NO_U_TURN = 3;
    public static final byte RESTRICTION_NO_STRAIGHT_ON = 4;
    public static final byte RESTRICTION_ONLY_RIGHT_TURN = 5;
    public static final byte RESTRICTION_ONLY_LEFT_TURN = 6;
    public static final byte RESTRICTION_ONLY_STRAIGHT_ON = 7;
    private static char TAG_DELIMETER = (char)47;
    private String resourceName = null;
    protected Map<String, MapRulType> types = null;
    protected List<MapRulType> typeList = new ArrayList<MapRulType>();
    protected MapRulType nameRuleType;
    protected MapRulType nameEnRuleType;

    public MapRenderingTypes(String fileName) {
        this.resourceName = fileName;
    }

    public Map<String, MapRulType> getEncodingRuleTypes() {
        this.checkIfInitNeeded();
        return this.types;
    }

    protected void checkIfInitNeeded() {
        if (this.types == null) {
            this.types = new LinkedHashMap<String, MapRulType>();
            this.typeList.clear();
            this.nameRuleType = MapRulType.createText("name");
            this.nameRuleType.order = 40;
            this.registerRuleType(this.nameRuleType);
            this.nameEnRuleType = MapRulType.createText("name:en");
            this.nameEnRuleType.order = 45;
            this.registerRuleType(this.nameEnRuleType);
            this.init();
        }
    }

    public static Collection<Map<String, String>> splitTagsIntoDifferentObjects(Map<String, String> tags) {
        boolean split = MapRenderingTypes.splitIsNeeded(tags);
        if (!split) {
            return Collections.singleton(tags);
        }
        return MapRenderingTypes.splitOpenSeaMapsTags(tags);
    }

    protected static boolean splitIsNeeded(Map<String, String> tags) {
        boolean seamark = false;
        for (String s : tags.keySet()) {
            if (!s.startsWith("seamark:")) continue;
            seamark = true;
            break;
        }
        return seamark;
    }

    private static Collection<Map<String, String>> splitOpenSeaMapsTags(Map<String, String> tags) {
        HashMap groupByOpenSeamaps = new HashMap();
        HashMap<String, String> common = new HashMap<String, String>();
        String ATTACHED_KEY = "seamark:attached";
        String type = "";
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            String s = entry.getKey();
            String value = entry.getValue();
            if (s.equals("seamark:type")) {
                type = value;
                common.put(ATTACHED_KEY, MapRenderingTypes.openSeaType(value));
                continue;
            }
            if (s.startsWith("seamark:")) {
                String stype = s.substring("seamark:".length());
                int ind = stype.indexOf(58);
                if (ind == -1) {
                    common.put(s, value);
                    continue;
                }
                String group = MapRenderingTypes.openSeaType(stype.substring(0, ind));
                String add = stype.substring(ind + 1);
                if (!groupByOpenSeamaps.containsKey(group)) {
                    groupByOpenSeamaps.put(group, new HashMap());
                }
                ((Map)groupByOpenSeamaps.get(group)).put("seamark:" + add, value);
                continue;
            }
            common.put(s, value);
        }
        ArrayList<Map<String, String>> res = new ArrayList<Map<String, String>>();
        for (Map.Entry g : groupByOpenSeamaps.entrySet()) {
            ((Map)g.getValue()).putAll(common);
            ((Map)g.getValue()).put("seamark", (String)g.getKey());
            if (MapRenderingTypes.openSeaType(type).equals(g.getKey())) {
                ((Map)g.getValue()).remove(ATTACHED_KEY);
                ((Map)g.getValue()).put("seamark", type);
                res.add(0, (Map)g.getValue());
                continue;
            }
            res.add((Map)g.getValue());
        }
        return res;
    }

    private static String openSeaType(String value) {
        if (value.equals("light_major") || value.equals("light_minor")) {
            return "light";
        }
        return value;
    }

    public MapRulType getTypeByInternalId(int id) {
        return this.typeList.get(id);
    }

    private String lc(String a) {
        if (a != null) {
            return a.toLowerCase();
        }
        return a;
    }

    protected MapRulType checkOrCreateTextRule(String targetTag, MapRulType ref) {
        MapRulType mt = this.types.get(MapRenderingTypes.constructRuleKey(targetTag, null));
        if (mt == null) {
            MapRulType ct = MapRulType.createText(targetTag, ref);
            mt = this.registerRuleType(ct);
        }
        return mt;
    }

    protected MapRulType checkOrMainRule(String tag, String value, int minzoom) {
        MapRulType mt = this.types.get(MapRenderingTypes.constructRuleKey(tag, value));
        if (mt == null) {
            mt = this.registerRuleType(MapRulType.createMainEntity(tag, value));
            mt.minzoom = minzoom;
            mt.maxzoom = 21;
        }
        return mt;
    }

    protected MapRulType checkOrCreateAdditional(String tag, String value, MapRulType ref) {
        MapRulType mt = this.types.get(MapRenderingTypes.constructRuleKey(tag, value));
        if (mt == null) {
            MapRulType ct = MapRulType.createAdditional(tag, value, ref);
            mt = this.registerRuleType(ct);
        }
        return mt;
    }

    protected MapRulType getRuleType(String tag, String val, boolean poi, boolean map) {
        Map<String, MapRulType> types = this.getEncodingRuleTypes();
        MapRulType rType = types.get(MapRenderingTypes.constructRuleKey(tag = this.lc(tag), val = this.lc(val)));
        if (rType == null || !rType.isPOI() && poi || !rType.isMap() && map) {
            rType = types.get(MapRenderingTypes.constructRuleKey(tag, null));
        }
        if (rType == null || !rType.isPOI() && poi || !rType.isMap() && map) {
            return null;
        }
        if (rType.isAdditional() && rType.tagValuePattern.value == null) {
            MapRulType parent = rType;
            rType = MapRulType.createAdditional(tag, val);
            rType.additional = true;
            rType.order = parent.order;
            rType.map = parent.map;
            rType.poi = parent.poi;
            rType.onlyPoint = parent.onlyPoint;
            rType = this.registerRuleType(rType);
        }
        return rType;
    }

    public MapRulType getNameRuleType() {
        this.getEncodingRuleTypes();
        return this.nameRuleType;
    }

    public MapRulType getNameEnRuleType() {
        this.getEncodingRuleTypes();
        return this.nameEnRuleType;
    }

    protected void init() {
        try {
            int tok;
            InputStream is = this.resourceName == null ? MapRenderingTypes.class.getResourceAsStream("rendering_types.xml") : new FileInputStream(this.resourceName);
            long time = System.currentTimeMillis();
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            MapRulType parentCategory = null;
            MapRulType parentType = null;
            while ((tok = parser.next()) != 1) {
                if (tok != 2) continue;
                String name = parser.getName();
                if (name.equals("category")) {
                    parentCategory = this.parseCategoryFromXml(parser);
                    continue;
                }
                if (name.equals("type")) {
                    parentType = this.parseAndRegisterTypeFromXML(parser, parentCategory);
                    continue;
                }
                if (name.equals("propagate")) {
                    this.parsePropagate(parser, parentType);
                    continue;
                }
                if (name.equals("routing_type")) {
                    this.parseRouteTagFromXML(parser);
                    continue;
                }
                if (!name.equals("entity_convert")) continue;
                this.parseEntityConvertXML(parser);
            }
            log.info((Object)("Time to init " + (System.currentTimeMillis() - time)));
            is.close();
        }
        catch (IOException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        catch (XmlPullParserException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    protected abstract void parseEntityConvertXML(XmlPullParser var1);

    protected abstract void parseRouteTagFromXML(XmlPullParser var1);

    protected abstract void parsePropagate(XmlPullParser var1, MapRulType var2);

    protected abstract MapRulType parseAndRegisterTypeFromXML(XmlPullParser var1, MapRulType var2);

    protected PropagateToNode parsePropagateType(XmlPullParser parser) {
        String propagateToNodes = parser.getAttributeValue("", "propagateToNodes");
        if (propagateToNodes != null) {
            PropagateToNode rtype = new PropagateToNode();
            if ("true".equals(propagateToNodes) || "yes".equals(propagateToNodes) || "all".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.ALL;
            } else if ("start".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.START;
            } else if ("end".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.END;
            } else if ("center".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.CENTER;
            } else if ("border".equals(propagateToNodes) || "borderin".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.BORDERIN;
            } else if ("borderout".equals(propagateToNodes)) {
                rtype.propagateToNodes = PropagateToNodesType.BORDEROUT;
            }
            String propagateToNodesPrefix = parser.getAttributeValue("", "propagateToNodesPrefix");
            if (propagateToNodesPrefix != null) {
                rtype.propagateToNodesPrefix = propagateToNodesPrefix;
            }
            rtype.propagateIf = this.parseMultiTagValue(parser, "propagateIf");
            rtype.propagateNetworkIf = this.parseMultiTagValue(parser, "propagateNetworkIf");
            return rtype;
        }
        return null;
    }

    protected MapRulType parseBaseRuleType(XmlPullParser parser, MapRulType parentCategory, String tag) {
        String order;
        String value = this.lc(parser.getAttributeValue("", "value"));
        String additional = parser.getAttributeValue("", "additional");
        if (value != null && value.length() == 0) {
            value = null;
        }
        MapRulType rtype = MapRulType.createMainEntity(tag, value);
        if ("true".equals(additional)) {
            rtype = MapRulType.createAdditional(tag, value);
        } else if ("text".equals(additional)) {
            rtype = MapRulType.createText(tag);
        }
        rtype.map = "true".equals(parser.getAttributeValue("", "map")) || "yes".equals(parser.getAttributeValue("", "map")) || parser.getAttributeValue("", "map") == null;
        rtype.poi = "true".equals(parser.getAttributeValue("", "poi")) || "yes".equals(parser.getAttributeValue("", "poi")) || parser.getAttributeValue("", "poi") == null;
        PropagateToNode ptype = this.parsePropagateType(parser);
        if (ptype != null) {
            rtype.propagateToNodes.add(ptype);
        }
        if (!Algorithms.isEmpty(order = parser.getAttributeValue("", "order"))) {
            rtype.order = Integer.parseInt(order);
        } else if (parentCategory != null) {
            rtype.order = parentCategory.order;
        }
        rtype.category = parentCategory == null ? null : parentCategory.category;
        rtype.onlyPoint = Boolean.parseBoolean(parser.getAttributeValue("", "point"));
        rtype.relation = Boolean.parseBoolean(parser.getAttributeValue("", "relation"));
        rtype.relationGroup = Boolean.parseBoolean(parser.getAttributeValue("", "relationGroup"));
        if (rtype.isMain()) {
            String rnmts;
            String nmts;
            String groupSort;
            if (rtype.relationGroup) {
                MapRulType mrt = MapRulType.createMainEntity(tag + "_" + value, null);
                mrt.order = rtype.order;
                mrt.category = rtype.category;
                mrt.poi = rtype.poi;
                mrt.map = rtype.map;
                this.registerMapRule(parser, mrt);
            }
            if ((groupSort = parser.getAttributeValue("", "relationGroupSort")) != null) {
                String[] ls;
                rtype.relationSortTags = new LinkedHashMap<String, List<String>>();
                for (String l : ls = groupSort.split(";")) {
                    int sp = l.indexOf(61);
                    String key = l;
                    String[] values = new String[]{};
                    if (sp >= 0) {
                        key = l.substring(0, sp);
                        values = l.substring(sp + 1).split(",");
                    }
                    rtype.relationSortTags.put(key, Arrays.asList(values));
                }
            }
            String additionalTags = parser.getAttributeValue("", "additionalTags");
            String additionalPrefix = parser.getAttributeValue("", "additionalPrefix");
            if (additionalTags != null) {
                rtype.additionalTags = new LinkedHashMap<String, String>();
                for (String tg : additionalTags.split(",")) {
                    Object targetTag = tg;
                    if (!Algorithms.isEmpty(additionalPrefix)) {
                        targetTag = additionalPrefix + tg;
                    }
                    rtype.additionalTags.put(tg, (String)targetTag);
                }
            }
            rtype.relationGroupPrefix = parser.getAttributeValue("", "relationGroupPrefix");
            String relationGroupAdditionalTags = parser.getAttributeValue("", "relationGroupAdditionalTags");
            if (relationGroupAdditionalTags != null) {
                rtype.relationGroupAdditionalTags = new LinkedHashMap<String, String>();
                for (String tg : relationGroupAdditionalTags.split(",")) {
                    rtype.relationGroupAdditionalTags.put(tg, tg);
                }
            }
            if ((nmts = parser.getAttributeValue("", "nameTags")) != null) {
                if (rtype.relation || rtype.relationGroup) {
                    String namePrefix = parser.getAttributeValue("", "namePrefix");
                    if (namePrefix == null) {
                        namePrefix = "";
                    }
                    rtype.relationNames = new LinkedHashMap<String, String>();
                    this.putNameTags(nmts, rtype.relationNames, namePrefix);
                } else {
                    String[] nameSplit;
                    for (String nameTag : nameSplit = nmts.split(",")) {
                        this.checkOrCreateTextRule(nameTag, null);
                    }
                }
            }
            if ((rnmts = parser.getAttributeValue("", "relationGroupNameTags")) != null) {
                rtype.relationGroupNameTags = new LinkedHashMap<String, String>();
                this.putNameTags(rnmts, rtype.relationGroupNameTags, "");
            }
        }
        return rtype;
    }

    private void putNameTags(String namesList, Map<String, String> names, String namePrefix) {
        if (namesList != null) {
            String[] nameSplit = namesList.split(",");
            for (int i = 0; i < nameSplit.length; ++i) {
                String tagName = nameSplit[i];
                Object tagTargetName = tagName;
                if (namePrefix.length() > 0) {
                    tagTargetName = namePrefix + tagName;
                }
                names.put(tagName, (String)tagTargetName);
                for (String lng : langs) {
                    names.put(tagName + ":" + lng, (String)tagTargetName + ":" + lng);
                }
            }
        }
    }

    protected void registerMapRule(XmlPullParser parser, MapRulType rtype) {
        String val = parser.getAttributeValue("", "minzoom");
        if (rtype.isMain()) {
            rtype.minzoom = 15;
        }
        if (val != null) {
            rtype.minzoom = Integer.parseInt(val);
        }
        val = parser.getAttributeValue("", "maxzoom");
        rtype.maxzoom = 31;
        if (val != null) {
            rtype.maxzoom = Integer.parseInt(val);
        }
        this.registerRuleType(rtype);
    }

    protected MapRulType registerRuleType(MapRulType rt) {
        String tag = rt.tagValuePattern.tag;
        String val = rt.tagValuePattern.value;
        String keyVal = MapRenderingTypes.constructRuleKey(tag, val);
        if (this.types.containsKey(keyVal)) {
            MapRulType mapRulType = this.types.get(keyVal);
            if (mapRulType.isAdditional() || mapRulType.isText()) {
                rt.id = mapRulType.id;
                if (rt.isMain()) {
                    mapRulType.main = true;
                    mapRulType.order = rt.order;
                    if (rt.minzoom != 0) {
                        mapRulType.minzoom = Math.max(rt.minzoom, mapRulType.minzoom);
                    }
                    if (rt.maxzoom != 0) {
                        mapRulType.maxzoom = Math.min(rt.maxzoom, mapRulType.maxzoom);
                    }
                }
                return mapRulType;
            }
            throw new RuntimeException("Duplicate " + keyVal);
        }
        rt.id = this.types.size();
        this.types.put(keyVal, rt);
        this.typeList.add(rt);
        return rt;
    }

    protected MapRulType parseCategoryFromXml(XmlPullParser parser) {
        MapRulType rtype = new MapRulType();
        rtype.category = parser.getAttributeValue("", "name");
        if (!Algorithms.isEmpty(parser.getAttributeValue("", "order"))) {
            rtype.order = Integer.parseInt(parser.getAttributeValue("", "order"));
        }
        return rtype;
    }

    protected static String constructRuleKey(String tag, String val) {
        if (val == null || val.length() == 0) {
            return tag;
        }
        return tag + TAG_DELIMETER + val;
    }

    protected static String getTagKey(String tagValue) {
        int i = tagValue.indexOf(TAG_DELIMETER);
        if (i >= 0) {
            return tagValue.substring(0, i);
        }
        return tagValue;
    }

    protected static String getValueKey(String tagValue) {
        int i = tagValue.indexOf(TAG_DELIMETER);
        if (i >= 0) {
            return tagValue.substring(i + 1);
        }
        return null;
    }

    public static String getRestrictionValue(int i) {
        switch (i) {
            case 1: {
                return "NO_RIGHT_TURN".toLowerCase();
            }
            case 2: {
                return "NO_LEFT_TURN".toLowerCase();
            }
            case 3: {
                return "NO_U_TURN".toLowerCase();
            }
            case 4: {
                return "NO_STRAIGHT_ON".toLowerCase();
            }
            case 5: {
                return "ONLY_RIGHT_TURN".toLowerCase();
            }
            case 6: {
                return "ONLY_LEFT_TURN".toLowerCase();
            }
            case 7: {
                return "ONLY_STRAIGHT_ON".toLowerCase();
            }
        }
        return "unkonwn";
    }

    private Map<String, String> parseMultiTagValue(XmlPullParser parser, String attrPrefix) {
        int cnt = parser.getAttributeCount();
        HashMap<Integer, String> tags = new HashMap<Integer, String>();
        HashMap<Integer, String> values = new HashMap<Integer, String>();
        attrPrefix = attrPrefix.toLowerCase();
        for (int i = 0; i < cnt; ++i) {
            int num;
            String numStr;
            String name = parser.getAttributeName(i).toLowerCase();
            String value = parser.getAttributeValue(i).toLowerCase();
            if (name.startsWith(attrPrefix + "tag")) {
                numStr = name.replace(attrPrefix + "tag", "");
                num = numStr.isEmpty() ? 0 : Integer.parseInt(numStr);
                tags.put(num, value);
            }
            if (!name.startsWith(attrPrefix + "value")) continue;
            numStr = name.replace(attrPrefix + "value", "");
            num = numStr.isEmpty() ? 0 : Integer.parseInt(numStr);
            values.put(num, value);
        }
        if (tags.size() == 0) {
            return null;
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry entry : tags.entrySet()) {
            int index = (Integer)entry.getKey();
            result.put((String)entry.getValue(), (String)values.get(index));
        }
        return result;
    }

    public static class MapRulType {
        protected Map<String, String> relationNames;
        protected Map<String, String> additionalTags;
        protected Map<String, List<String>> relationSortTags;
        protected String relationGroupPrefix;
        protected Map<String, String> relationGroupNameTags;
        protected Map<String, String> relationGroupAdditionalTags;
        protected List<PropagateToNode> propagateToNodes = new ArrayList<PropagateToNode>();
        protected TagValuePattern tagValuePattern;
        protected boolean additional;
        protected boolean additionalText;
        protected boolean main;
        protected int order = 50;
        protected String category = null;
        protected boolean relation;
        protected boolean relationGroup;
        protected boolean map = true;
        protected boolean poi = true;
        protected int minzoom;
        protected int maxzoom;
        protected boolean onlyPoint;
        protected int id = -1;
        protected int freq;
        protected int targetId;
        protected int targetPoiId = -1;

        private MapRulType() {
        }

        private void copyMetadata(MapRulType ref) {
            this.minzoom = ref.minzoom;
            this.maxzoom = ref.maxzoom;
            this.order = ref.order;
            this.category = ref.category;
            this.onlyPoint = ref.onlyPoint;
        }

        public boolean isPOI() {
            return this.poi;
        }

        public boolean isMap() {
            return this.map;
        }

        public int getOrder() {
            return this.order;
        }

        public static MapRulType createMainEntity(String tag, String value) {
            MapRulType rt = new MapRulType();
            rt.tagValuePattern = new TagValuePattern(tag, value);
            rt.main = true;
            return rt;
        }

        public static MapRulType createText(String tag, MapRulType ref) {
            MapRulType rt = new MapRulType();
            rt.minzoom = 2;
            rt.maxzoom = 31;
            if (ref != null) {
                rt.copyMetadata(ref);
            }
            rt.additionalText = true;
            rt.tagValuePattern = new TagValuePattern(tag, null);
            return rt;
        }

        public static MapRulType createAdditional(String tag, String value, MapRulType ref) {
            MapRulType rt = new MapRulType();
            rt.minzoom = 2;
            rt.maxzoom = 31;
            if (ref != null) {
                rt.copyMetadata(ref);
            }
            rt.additional = true;
            rt.tagValuePattern = new TagValuePattern(tag, value);
            return rt;
        }

        public static MapRulType createText(String tag) {
            return MapRulType.createText(tag, null);
        }

        public static MapRulType createAdditional(String tag, String value) {
            return MapRulType.createAdditional(tag, value, null);
        }

        public String getTag() {
            return this.tagValuePattern.tag;
        }

        public int getTargetId() {
            return this.targetId;
        }

        public int getTargetPoiId() {
            return this.targetPoiId;
        }

        public void setTargetPoiId(int catId, int valueId) {
            if (catId <= 31) {
                this.targetPoiId = valueId << 6 | catId << 1;
            } else {
                if (catId > 32768) {
                    throw new IllegalArgumentException("Refer source code");
                }
                this.targetPoiId = valueId << 16 | catId << 1 | 1;
            }
        }

        public int getInternalId() {
            return this.id;
        }

        public void setTargetId(int targetId) {
            this.targetId = targetId;
        }

        public String getValue() {
            return this.tagValuePattern.value;
        }

        public int getMinzoom() {
            return this.minzoom;
        }

        public boolean isAdditional() {
            return this.additional;
        }

        public boolean isAdditionalOrText() {
            return this.additional || this.additionalText;
        }

        public boolean isMain() {
            return this.main;
        }

        public boolean isText() {
            return this.additionalText;
        }

        public boolean isOnlyPoint() {
            return this.onlyPoint;
        }

        public int getFreq() {
            return this.freq;
        }

        public int updateFreq() {
            return ++this.freq;
        }

        public String toString() {
            return this.getTag() + " " + this.getValue();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.id;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MapRulType other = (MapRulType)obj;
            return this.id == other.id && this.id >= 0;
        }

        public List<PropagateToNode> getPropagateToNodes() {
            return this.propagateToNodes;
        }
    }

    protected static class TagValuePattern {
        protected String tag;
        protected String value;
        protected String tagPrefix;
        protected int substrSt = 0;
        protected int substrEnd = 0;

        protected TagValuePattern(String t, String v) {
            this.tag = t;
            this.value = v;
            if (this.tag == null && this.value == null) {
                throw new IllegalStateException("Tag/value null should be handled differently");
            }
            if (this.tag == null) {
                throw new UnsupportedOperationException();
            }
        }

        public boolean isApplicable(Map<String, String> e) {
            if (this.value == null) {
                return e.get(this.tag) != null;
            }
            return this.value.equals(e.get(this.tag));
        }

        public String toString() {
            return "tag=" + this.tag + " val=" + this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TagValuePattern other = (TagValuePattern)obj;
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            return !(this.value == null ? other.value != null : !this.value.equals(other.value));
        }
    }

    public static class PropagateToNode {
        public PropagateToNodesType propagateToNodes;
        public String propagateToNodesPrefix;
        public Map<String, String> propagateIf;
        public Map<String, String> propagateNetworkIf;
    }

    public static enum PropagateToNodesType {
        ALL,
        START,
        END,
        CENTER,
        BORDERIN,
        BORDEROUT;


        public boolean isBorder() {
            return this == BORDERIN || this == BORDEROUT;
        }
    }
}

