/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.StringMatcher;
import net.osmand.data.Amenity;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class MapPoiTypes {
    private static final String OTHER_MAP_CATEGORY = "Other";
    private static MapPoiTypes DEFAULT_INSTANCE = null;
    private static final Log log = PlatformUtil.getLog(MapRenderingTypes.class);
    private String resourceName;
    private List<PoiCategory> categories = new ArrayList<PoiCategory>();
    private Set<String> forbiddenTypes = new HashSet<String>();
    private PoiCategory otherCategory;
    public static final String WIKI_LANG = "wiki_lang";
    public static final String WIKI_PLACE = "wiki_place";
    public static final String OSM_WIKI_CATEGORY = "osmwiki";
    public static final String SPEED_CAMERA = "speed_camera";
    public static final String ROUTES = "routes";
    public static final String ROUTE_ARTICLE = "route_article";
    public static final String ROUTE_ARTICLE_POINT = "route_article_point";
    public static final String CATEGORY = "category";
    public static final String ROUTE_TRACK = "route_track";
    public static final String ROUTE_TRACK_POINT = "route_track_point";
    private PoiTranslator poiTranslator = null;
    private boolean init;
    Map<String, PoiType> poiTypesByTag = new LinkedHashMap<String, PoiType>();
    Map<String, String> deprecatedTags = new LinkedHashMap<String, String>();
    Map<String, String> poiAdditionalCategoryIconNames = new LinkedHashMap<String, String>();
    List<PoiType> textPoiAdditionals = new ArrayList<PoiType>();
    public Map<String, PoiType> topIndexPoiAdditional = new LinkedHashMap<String, PoiType>();
    public static final String TOP_INDEX_ADDITIONAL_PREFIX = "top_index_";

    public MapPoiTypes(String fileName) {
        this.resourceName = fileName;
    }

    public static MapPoiTypes getDefaultNoInit() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new MapPoiTypes(null);
        }
        return DEFAULT_INSTANCE;
    }

    public static void setDefault(MapPoiTypes types) {
        DEFAULT_INSTANCE = types;
        DEFAULT_INSTANCE.init();
    }

    public static MapPoiTypes getDefault() {
        if (DEFAULT_INSTANCE == null) {
            DEFAULT_INSTANCE = new MapPoiTypes(null);
            DEFAULT_INSTANCE.init();
        }
        return DEFAULT_INSTANCE;
    }

    public boolean isInit() {
        return this.init;
    }

    public boolean isOtherCategory(PoiCategory poiCategory) {
        return Objects.equals(this.otherCategory, poiCategory);
    }

    public PoiCategory getOtherPoiCategory() {
        return this.otherCategory;
    }

    public PoiCategory getOtherMapCategory() {
        return this.getPoiCategoryByName(OTHER_MAP_CATEGORY, true);
    }

    public String getPoiAdditionalCategoryIconName(String category) {
        return this.poiAdditionalCategoryIconNames.get(category);
    }

    public List<PoiType> getTextPoiAdditionals() {
        return this.textPoiAdditionals;
    }

    public List<AbstractPoiType> getTopVisibleFilters() {
        ArrayList<AbstractPoiType> lf = new ArrayList<AbstractPoiType>();
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            if (pc.isTopVisible()) {
                lf.add(pc);
            }
            for (PoiFilter poiFilter : pc.getPoiFilters()) {
                if (!poiFilter.isTopVisible()) continue;
                lf.add(poiFilter);
            }
            for (PoiType poiType : pc.getPoiTypes()) {
                if (!poiType.isTopVisible()) continue;
                lf.add(poiType);
            }
        }
        this.sortList(lf);
        return lf;
    }

    public PoiCategory getOsmwiki() {
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory category = this.categories.get(i);
            if (!category.isWiki()) continue;
            return category;
        }
        return null;
    }

    public PoiCategory getRoutes() {
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory category = this.categories.get(i);
            if (!category.isRoutes()) continue;
            return category;
        }
        return null;
    }

    public List<String> getAllAvailableWikiLocales() {
        ArrayList<String> availableWikiLocales = new ArrayList<String>();
        for (PoiType type : this.getOsmwiki().getPoiTypeByKeyName(WIKI_PLACE).getPoiAdditionals()) {
            String name = type.getKeyName();
            String wikiLang = "wiki_lang:";
            if (name == null || !name.startsWith(wikiLang)) continue;
            String locale = name.substring(wikiLang.length());
            availableWikiLocales.add(locale);
        }
        return availableWikiLocales;
    }

    private void sortList(List<? extends AbstractPoiType> lf) {
        final Collator instance = Collator.getInstance();
        Collections.sort(lf, new Comparator<AbstractPoiType>(){

            @Override
            public int compare(AbstractPoiType object1, AbstractPoiType object2) {
                return instance.compare(object1.getTranslation(), object2.getTranslation());
            }
        });
    }

    public PoiCategory getUserDefinedCategory() {
        return this.otherCategory;
    }

    public PoiType getPoiTypeByKey(String name) {
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            PoiType pt = pc.getPoiTypeByKeyName(name);
            if (pt == null || pt.isReference()) continue;
            return pt;
        }
        return null;
    }

    public PoiType getPoiTypeByKeyInCategory(PoiCategory category, String keyName) {
        if (category != null) {
            return category.getPoiTypeByKeyName(keyName);
        }
        return null;
    }

    public AbstractPoiType getAnyPoiTypeByKey(String name) {
        return this.getAnyPoiTypeByKey(name, true);
    }

    public AbstractPoiType getAnyPoiTypeByKey(String name, boolean skipAdditional) {
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            if (pc.getKeyName().equals(name)) {
                return pc;
            }
            for (PoiFilter pf : pc.getPoiFilters()) {
                if (pf.getKeyName().equals(name)) {
                    return pf;
                }
                if (skipAdditional) continue;
                for (PoiType type : pf.getPoiTypes()) {
                    if (type.getKeyName().equals(name)) {
                        return type;
                    }
                    AbstractPoiType foundType = this.findInAdds(type.getPoiAdditionals(), name);
                    if (foundType == null) continue;
                    return foundType;
                }
            }
            PoiType pt = pc.getPoiTypeByKeyName(name);
            if (pt == null || pt.isReference()) continue;
            return pt;
        }
        return null;
    }

    private AbstractPoiType findInAdds(List<PoiType> adds, String name) {
        for (PoiType additional : adds) {
            if (additional.getKeyName().equals(name)) {
                return additional;
            }
            AbstractPoiType foundType = this.findInAdds(additional.getPoiAdditionals(), name);
            if (foundType == null) continue;
            return foundType;
        }
        return null;
    }

    public Map<String, PoiType> getAllTranslatedNames(boolean skipNonEditable) {
        HashMap<String, PoiType> translation = new HashMap<String, PoiType>();
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            if (skipNonEditable && pc.isNotEditableOsm()) continue;
            this.addPoiTypesTranslation(skipNonEditable, translation, pc);
        }
        return translation;
    }

    private void addPoiTypesTranslation(boolean skipNonEditable, Map<String, PoiType> translation, PoiFilter pf) {
        for (PoiType pt : pf.getPoiTypes()) {
            if (pt.isReference() || pt.getBaseLangType() != null || skipNonEditable && pt.isNotEditableOsm()) continue;
            translation.put(pt.getKeyName().replace('_', ' ').toLowerCase(), pt);
            translation.put(pt.getTranslation().toLowerCase(), pt);
        }
    }

    public List<AbstractPoiType> getAllTypesTranslatedNames(StringMatcher matcher) {
        ArrayList<AbstractPoiType> tm = new ArrayList<AbstractPoiType>();
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            if (pc == this.getOtherMapCategory()) continue;
            this.addIf(tm, pc, matcher);
            for (PoiFilter poiFilter : pc.getPoiFilters()) {
                this.addIf(tm, poiFilter, matcher);
            }
            for (PoiType poiType : pc.getPoiTypes()) {
                if (poiType.isReference()) continue;
                this.addIf(tm, poiType, matcher);
            }
        }
        return tm;
    }

    private void addIf(List<AbstractPoiType> tm, AbstractPoiType pc, StringMatcher matcher) {
        List<PoiType> additionals;
        if (matcher.matches(pc.getTranslation()) || matcher.matches(pc.getKeyName().replace('_', ' '))) {
            tm.add(pc);
        }
        if ((additionals = pc.getPoiAdditionals()) != null) {
            for (PoiType a : additionals) {
                this.addIf(tm, a, matcher);
            }
        }
    }

    public Map<String, PoiType> getAllTranslatedNames(PoiCategory pc, boolean onlyTranslation) {
        TreeMap<String, PoiType> translation = new TreeMap<String, PoiType>();
        for (PoiType pt : pc.getPoiTypes()) {
            translation.put(pt.getTranslation(), pt);
            if (onlyTranslation) continue;
            translation.put(Algorithms.capitalizeFirstLetterAndLowercase(pt.getKeyName().replace('_', ' ')), pt);
        }
        return translation;
    }

    public PoiCategory getPoiCategoryByName(String name) {
        return this.getPoiCategoryByName(name, false);
    }

    public PoiCategory getPoiCategoryByName(String name, boolean create) {
        if (name.equals("leisure") && !create) {
            name = "entertainment";
        }
        if (name.equals("historic") && !create) {
            name = "tourism";
        }
        for (PoiCategory p : this.categories) {
            if (!p.getKeyName().equalsIgnoreCase(name)) continue;
            return p;
        }
        if (create) {
            PoiCategory lastCategory = new PoiCategory(this, name, this.categories.size());
            if (!lastCategory.getKeyName().equals(OTHER_MAP_CATEGORY)) {
                lastCategory.setTopVisible(true);
            }
            this.addCategory(lastCategory);
            return lastCategory;
        }
        return this.otherCategory;
    }

    private void addCategory(PoiCategory category) {
        ArrayList<PoiCategory> categories = new ArrayList<PoiCategory>(this.categories);
        categories.add(category);
        this.categories = categories;
    }

    public List<PoiCategory> getCategories() {
        return this.categories;
    }

    public PoiTranslator getPoiTranslator() {
        return this.poiTranslator;
    }

    public void setPoiTranslator(PoiTranslator poiTranslator) {
        this.poiTranslator = poiTranslator;
        ArrayList<PoiCategory> categories = new ArrayList<PoiCategory>(this.categories);
        this.sortList(categories);
        this.categories = categories;
    }

    public void init() {
        this.init(null);
    }

    public void init(String resourceName) {
        if (resourceName != null) {
            this.resourceName = resourceName;
        }
        try {
            InputStream is = this.resourceName == null ? MapPoiTypes.class.getResourceAsStream("poi_types.xml") : new FileInputStream(this.resourceName);
            this.initFromInputStream(is);
        }
        catch (IOException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
    }

    public void initFromInputStream(InputStream is) {
        long time = System.currentTimeMillis();
        ArrayList<PoiType> referenceTypes = new ArrayList<PoiType>();
        LinkedHashMap<String, PoiType> allTypes = new LinkedHashMap<String, PoiType>();
        LinkedHashMap<String, List> categoryPoiAdditionalMap = new LinkedHashMap<String, List>();
        LinkedHashMap abstractTypeAdditionalCategories = new LinkedHashMap();
        LinkedHashMap<String, PoiType> poiTypesByTag = new LinkedHashMap<String, PoiType>();
        LinkedHashMap<String, String> deprecatedTags = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> poiAdditionalCategoryIconNames = new LinkedHashMap<String, String>();
        ArrayList<PoiType> textPoiAdditionals = new ArrayList<PoiType>();
        ArrayList<PoiCategory> categoriesList = new ArrayList<PoiCategory>();
        try {
            int n;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(is, "UTF-8");
            PoiCategory lastCategory = null;
            TreeSet lastCategoryPoiAdditionalsCategories = new TreeSet();
            PoiFilter lastFilter = null;
            TreeSet lastFilterPoiAdditionalsCategories = new TreeSet();
            PoiType lastType = null;
            TreeSet lastTypePoiAdditionalsCategories = new TreeSet();
            String lastPoiAdditionalCategory = null;
            PoiCategory localOtherMapCategory = new PoiCategory(this, OTHER_MAP_CATEGORY, categoriesList.size());
            categoriesList.add(localOtherMapCategory);
            block31: while ((n = parser.next()) != 1) {
                String name;
                if (n == 2) {
                    switch (name = parser.getName()) {
                        case "poi_category": {
                            lastCategory = new PoiCategory(this, parser.getAttributeValue("", "name"), categoriesList.size());
                            lastCategory.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
                            lastCategory.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
                            lastCategory.setDefaultTag(parser.getAttributeValue("", "default_tag"));
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "poi_additional_category"))) {
                                Collections.addAll(lastCategoryPoiAdditionalsCategories, parser.getAttributeValue("", "poi_additional_category").split(","));
                            }
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "excluded_poi_additional_category"))) {
                                lastCategory.addExcludedPoiAdditionalCategories(parser.getAttributeValue("", "excluded_poi_additional_category").split(","));
                                lastCategory.getExcludedPoiAdditionalCategories().forEach(lastCategoryPoiAdditionalsCategories::remove);
                            }
                            categoriesList.add(lastCategory);
                            break;
                        }
                        case "poi_filter": {
                            String keyName = parser.getAttributeValue("", "name");
                            String iconName = parser.getAttributeValue("", "icon");
                            PoiFilter tp = new PoiFilter(this, lastCategory, keyName, iconName);
                            tp.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
                            lastFilter = tp;
                            lastFilterPoiAdditionalsCategories.addAll(lastCategoryPoiAdditionalsCategories);
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "poi_additional_category"))) {
                                Collections.addAll(lastFilterPoiAdditionalsCategories, parser.getAttributeValue("", "poi_additional_category").split(","));
                            }
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "excluded_poi_additional_category"))) {
                                lastFilter.addExcludedPoiAdditionalCategories(parser.getAttributeValue("", "excluded_poi_additional_category").split(","));
                                lastFilter.getExcludedPoiAdditionalCategories().forEach(lastFilterPoiAdditionalsCategories::remove);
                            }
                            if (lastCategory == null) continue block31;
                            lastCategory.addPoiType(tp);
                            break;
                        }
                        case "poi_reference": {
                            PoiType tp = new PoiType(this, lastCategory, lastFilter, parser.getAttributeValue("", "name"));
                            referenceTypes.add(tp);
                            tp.setReferenceType(tp);
                            if (lastFilter != null) {
                                lastFilter.addPoiType(tp);
                            }
                            if (lastCategory == null) continue block31;
                            lastCategory.addPoiType(tp);
                            break;
                        }
                        case "poi_additional": {
                            if (lastCategory == null) {
                                lastCategory = localOtherMapCategory;
                            }
                            PoiType baseType = this.parsePoiAdditional(parser, lastCategory, lastFilter, lastType, null, null, lastPoiAdditionalCategory, textPoiAdditionals);
                            if ("true".equals(parser.getAttributeValue("", "lang"))) {
                                for (String lng : MapRenderingTypes.langs) {
                                    this.parsePoiAdditional(parser, lastCategory, lastFilter, lastType, lng, baseType, lastPoiAdditionalCategory, textPoiAdditionals);
                                    if (!baseType.isTopIndex()) continue;
                                    this.topIndexPoiAdditional.put(TOP_INDEX_ADDITIONAL_PREFIX + baseType.getKeyName() + ":" + lng, baseType);
                                }
                                this.parsePoiAdditional(parser, lastCategory, lastFilter, lastType, "en", baseType, lastPoiAdditionalCategory, textPoiAdditionals);
                                if (baseType.isTopIndex()) {
                                    this.topIndexPoiAdditional.put(TOP_INDEX_ADDITIONAL_PREFIX + baseType.getKeyName() + ":en", baseType);
                                }
                            }
                            if (lastPoiAdditionalCategory != null) {
                                List categoryAdditionals = categoryPoiAdditionalMap.computeIfAbsent(lastPoiAdditionalCategory, k -> new ArrayList());
                                categoryAdditionals.add(baseType);
                            }
                            if (!baseType.isTopIndex()) continue block31;
                            this.topIndexPoiAdditional.put(TOP_INDEX_ADDITIONAL_PREFIX + baseType.getKeyName(), baseType);
                            break;
                        }
                        case "poi_additional_category": {
                            if (lastPoiAdditionalCategory != null) continue block31;
                            lastPoiAdditionalCategory = parser.getAttributeValue("", "name");
                            String icon = parser.getAttributeValue("", "icon");
                            if (Algorithms.isEmpty(icon)) continue block31;
                            poiAdditionalCategoryIconNames.put(lastPoiAdditionalCategory, icon);
                            break;
                        }
                        case "poi_type": {
                            if (lastCategory == null) {
                                lastCategory = localOtherMapCategory;
                            }
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "deprecated_of"))) {
                                String vl = parser.getAttributeValue("", "name");
                                String target = parser.getAttributeValue("", "deprecated_of");
                                deprecatedTags.put(vl, target);
                                break;
                            }
                            lastType = this.parsePoiType(allTypes, parser, lastCategory, lastFilter, null, null);
                            if ("true".equals(parser.getAttributeValue("", "lang"))) {
                                for (String lng : MapRenderingTypes.langs) {
                                    this.parsePoiType(allTypes, parser, lastCategory, lastFilter, lng, lastType);
                                }
                            }
                            lastTypePoiAdditionalsCategories.addAll(lastCategoryPoiAdditionalsCategories);
                            lastTypePoiAdditionalsCategories.addAll(lastFilterPoiAdditionalsCategories);
                            if (!Algorithms.isEmpty(parser.getAttributeValue("", "poi_additional_category"))) {
                                Collections.addAll(lastTypePoiAdditionalsCategories, parser.getAttributeValue("", "poi_additional_category").split(","));
                            }
                            if (Algorithms.isEmpty(parser.getAttributeValue("", "excluded_poi_additional_category"))) continue block31;
                            lastType.addExcludedPoiAdditionalCategories(parser.getAttributeValue("", "excluded_poi_additional_category").split(","));
                            lastType.getExcludedPoiAdditionalCategories().forEach(lastTypePoiAdditionalsCategories::remove);
                            break;
                        }
                        default: {
                            log.warn((Object)("Unknown start tag encountered: " + name));
                        }
                    }
                    continue;
                }
                if (n != 3) continue;
                switch (name = parser.getName()) {
                    case "poi_filter": {
                        if (!lastFilterPoiAdditionalsCategories.isEmpty()) {
                            abstractTypeAdditionalCategories.put(lastFilter, lastFilterPoiAdditionalsCategories);
                            lastFilterPoiAdditionalsCategories = new TreeSet();
                        }
                        lastFilter = null;
                        continue block31;
                    }
                    case "poi_type": {
                        if (!lastTypePoiAdditionalsCategories.isEmpty()) {
                            abstractTypeAdditionalCategories.put(lastType, lastTypePoiAdditionalsCategories);
                            lastTypePoiAdditionalsCategories = new TreeSet();
                        }
                        lastType = null;
                        continue block31;
                    }
                    case "poi_category": {
                        if (!lastCategoryPoiAdditionalsCategories.isEmpty()) {
                            abstractTypeAdditionalCategories.put(lastCategory, lastCategoryPoiAdditionalsCategories);
                            lastCategoryPoiAdditionalsCategories = new TreeSet();
                        }
                        lastCategory = null;
                        continue block31;
                    }
                    case "poi_additional_category": {
                        lastPoiAdditionalCategory = null;
                        continue block31;
                    }
                }
                if (name.equals("poi_additional") || name.equals("poi_reference") || name.equals("poi_types")) continue;
                log.warn((Object)("Unknown end tag encountered: " + name));
            }
            is.close();
        }
        catch (IOException | XmlPullParserException e) {
            log.error((Object)"Unexpected error", e);
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            log.error((Object)"Unexpected error", (Throwable)e);
            e.printStackTrace();
            throw e;
        }
        for (PoiType poiType : referenceTypes) {
            PoiType pt = (PoiType)allTypes.get(poiType.getKeyName());
            if (pt == null || pt.getOsmTag() == null) {
                throw new IllegalStateException("Can't find poi type for poi reference '" + poiType.keyName + "'");
            }
            poiType.setReferenceType(pt);
        }
        for (Map.Entry entry : abstractTypeAdditionalCategories.entrySet()) {
            for (String category : (Set)entry.getValue()) {
                List poiAdditionals = (List)categoryPoiAdditionalMap.get(category);
                if (poiAdditionals == null) continue;
                for (PoiType poiType : poiAdditionals) {
                    this.buildPoiAdditionalReference(poiType, (AbstractPoiType)entry.getKey(), textPoiAdditionals);
                }
            }
        }
        this.categories = categoriesList;
        this.poiTypesByTag = poiTypesByTag;
        this.deprecatedTags = deprecatedTags;
        this.poiAdditionalCategoryIconNames = poiAdditionalCategoryIconNames;
        this.textPoiAdditionals = textPoiAdditionals;
        this.otherCategory = this.getPoiCategoryByName("user_defined_other");
        if (this.otherCategory == null) {
            throw new IllegalArgumentException("No poi category other");
        }
        this.init = true;
        log.info((Object)("Time to init poi types " + (System.currentTimeMillis() - time)));
    }

    private PoiType buildPoiAdditionalReference(PoiType poiAdditional, AbstractPoiType parent, List<PoiType> textPoiAdditionals) {
        PoiCategory lastCategory = null;
        PoiFilter lastFilter = null;
        PoiType lastType = null;
        PoiType ref = null;
        if (parent instanceof PoiCategory) {
            lastCategory = (PoiCategory)parent;
            ref = new PoiType(this, lastCategory, null, poiAdditional.getKeyName());
        } else if (parent instanceof PoiFilter) {
            lastFilter = (PoiFilter)parent;
            ref = new PoiType(this, lastFilter.getPoiCategory(), lastFilter, poiAdditional.getKeyName());
        } else if (parent instanceof PoiType) {
            lastType = (PoiType)parent;
            ref = new PoiType(this, lastType.getCategory(), lastType.getFilter(), poiAdditional.getKeyName());
        }
        if (ref == null) {
            return null;
        }
        if (poiAdditional.isReference()) {
            ref.setReferenceType(poiAdditional.getReferenceType());
        } else {
            ref.setReferenceType(poiAdditional);
        }
        ref.setBaseLangType(poiAdditional.getBaseLangType());
        ref.setLang(poiAdditional.getLang());
        ref.setAdditional(lastType != null ? lastType : (lastFilter != null ? lastFilter : lastCategory));
        ref.setTopVisible(poiAdditional.isTopVisible());
        ref.setText(poiAdditional.isText());
        ref.setOrder(poiAdditional.getOrder());
        ref.setOsmTag(poiAdditional.getOsmTag());
        ref.setNotEditableOsm(poiAdditional.isNotEditableOsm());
        ref.setOsmValue(poiAdditional.getOsmValue());
        ref.setOsmTag2(poiAdditional.getOsmTag2());
        ref.setOsmValue2(poiAdditional.getOsmValue2());
        ref.setPoiAdditionalCategory(poiAdditional.getPoiAdditionalCategory());
        ref.setFilterOnly(poiAdditional.isFilterOnly());
        if (lastType != null) {
            lastType.addPoiAdditional(ref);
        } else if (lastFilter != null) {
            lastFilter.addPoiAdditional(ref);
        } else if (lastCategory != null) {
            lastCategory.addPoiAdditional(ref);
        }
        if (ref.isText()) {
            textPoiAdditionals.add(ref);
        }
        return ref;
    }

    private PoiType parsePoiAdditional(XmlPullParser parser, PoiCategory lastCategory, PoiFilter lastFilter, PoiType lastType, String lang, PoiType langBaseType, String poiAdditionalCategory, List<PoiType> textPoiAdditionals) {
        String minCount;
        Object oname = parser.getAttributeValue("", "name");
        if (lang != null) {
            oname = (String)oname + ":" + lang;
        }
        Object otag = parser.getAttributeValue("", "tag");
        if (lang != null) {
            otag = (String)otag + ":" + lang;
        }
        PoiType tp = new PoiType(this, lastCategory, lastFilter, (String)oname);
        tp.setBaseLangType(langBaseType);
        tp.setLang(lang);
        tp.setAdditional(lastType != null ? lastType : (lastFilter != null ? lastFilter : lastCategory));
        tp.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
        tp.setText("text".equals(parser.getAttributeValue("", "type")));
        String orderStr = parser.getAttributeValue("", "order");
        if (!Algorithms.isEmpty(orderStr)) {
            tp.setOrder(Integer.parseInt(orderStr));
        }
        tp.setOsmTag((String)otag);
        tp.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
        tp.setOsmValue(parser.getAttributeValue("", "value"));
        tp.setOsmTag2(parser.getAttributeValue("", "tag2"));
        tp.setOsmValue2(parser.getAttributeValue("", "value2"));
        tp.setPoiAdditionalCategory(poiAdditionalCategory);
        tp.setFilterOnly(Boolean.parseBoolean(parser.getAttributeValue("", "filter_only")));
        tp.setTopIndex(Boolean.parseBoolean(parser.getAttributeValue("", "top_index")));
        String maxPerMap = parser.getAttributeValue("", "max_per_map");
        if (!Algorithms.isEmpty(maxPerMap)) {
            tp.setMaxPerMap(Integer.parseInt(maxPerMap));
        }
        if (!Algorithms.isEmpty(minCount = parser.getAttributeValue("", "min_count"))) {
            tp.setMinCount(Integer.parseInt(minCount));
        }
        if (lastType != null) {
            lastType.addPoiAdditional(tp);
        } else if (lastFilter != null) {
            lastFilter.addPoiAdditional(tp);
        } else if (lastCategory != null) {
            lastCategory.addPoiAdditional(tp);
        }
        if (tp.isText()) {
            textPoiAdditionals.add(tp);
        }
        return tp;
    }

    private PoiType parsePoiType(Map<String, PoiType> allTypes, XmlPullParser parser, PoiCategory lastCategory, PoiFilter lastFilter, String lang, PoiType langBaseType) {
        Object oname = parser.getAttributeValue("", "name");
        if (lang != null) {
            oname = (String)oname + ":" + lang;
        }
        PoiType tp = new PoiType(this, lastCategory, lastFilter, (String)oname);
        Object otag = parser.getAttributeValue("", "tag");
        if (lang != null) {
            otag = (String)otag + ":" + lang;
        }
        tp.setBaseLangType(langBaseType);
        tp.setLang(lang);
        tp.setOsmTag((String)otag);
        tp.setOsmValue(parser.getAttributeValue("", "value"));
        tp.setOsmEditTagValue(parser.getAttributeValue("", "edit_tag"), parser.getAttributeValue("", "edit_value"));
        tp.setOsmEditTagValue2(parser.getAttributeValue("", "edit_tag2"), parser.getAttributeValue("", "edit_value2"));
        tp.setOsmTag2(parser.getAttributeValue("", "tag2"));
        tp.setOsmValue2(parser.getAttributeValue("", "value2"));
        tp.setText("text".equals(parser.getAttributeValue("", "type")));
        String orderStr = parser.getAttributeValue("", "order");
        if (!Algorithms.isEmpty(orderStr)) {
            tp.setOrder(Integer.parseInt(orderStr));
        }
        tp.setNameOnly("true".equals(parser.getAttributeValue("", "name_only")));
        tp.setNameTag(parser.getAttributeValue("", "name_tag"));
        tp.setRelation("true".equals(parser.getAttributeValue("", "relation")));
        tp.setNotEditableOsm("true".equals(parser.getAttributeValue("", "no_edit")));
        tp.setTopVisible(Boolean.parseBoolean(parser.getAttributeValue("", "top")));
        if (lastFilter != null) {
            lastFilter.addPoiType(tp);
        }
        allTypes.put(tp.getKeyName(), tp);
        lastCategory.addPoiType(tp);
        if ("true".equals(parser.getAttributeValue("", "basemap"))) {
            lastCategory.addBasemapPoi(tp);
        }
        return tp;
    }

    public List<PoiCategory> getCategories(boolean includeMapCategory) {
        ArrayList<PoiCategory> lst = new ArrayList<PoiCategory>(this.categories);
        if (!includeMapCategory) {
            lst.remove(this.getOtherMapCategory());
        }
        return lst;
    }

    private static void print(MapPoiTypes df) {
        List<PoiCategory> pc = df.getCategories(true);
        for (PoiCategory p : pc) {
            System.out.println("Category " + p.getKeyName());
            for (PoiFilter f : p.getPoiFilters()) {
                System.out.println(" Filter " + f.getKeyName());
                MapPoiTypes.print("  ", f);
            }
            MapPoiTypes.print(" ", p);
        }
    }

    private PoiType getPoiAdditionalByKey(AbstractPoiType p, String name) {
        List<PoiType> pp = p.getPoiAdditionals();
        if (pp != null) {
            for (PoiType pt : pp) {
                if (!pt.getKeyName().equals(name)) continue;
                return pt;
            }
        }
        return null;
    }

    public PoiType getTextPoiAdditionalByKey(String name) {
        for (PoiType pt : this.textPoiAdditionals) {
            if (!pt.getKeyName().equals(name)) continue;
            return pt;
        }
        return null;
    }

    public AbstractPoiType getAnyPoiAdditionalTypeByKey(String name) {
        PoiType add = null;
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory pc = this.categories.get(i);
            add = this.getPoiAdditionalByKey(pc, name);
            if (add != null) {
                return add;
            }
            for (PoiFilter pf : pc.getPoiFilters()) {
                add = this.getPoiAdditionalByKey(pf, name);
                if (add == null) continue;
                return add;
            }
            for (PoiType p : pc.getPoiTypes()) {
                add = this.getPoiAdditionalByKey(p, name);
                if (add == null) continue;
                return add;
            }
        }
        return null;
    }

    private static void print(String indent, PoiFilter f) {
        for (PoiType pt : f.getPoiTypes()) {
            System.out.println(indent + " Type " + pt.getKeyName() + (String)(pt.isReference() ? " -> " + pt.getReferenceType().getCategory().getKeyName() : ""));
        }
    }

    public static void main(String[] args) {
        DEFAULT_INSTANCE = new MapPoiTypes("/Users/victorshcherb/osmand/repos/resources/poi/poi_types.xml");
        DEFAULT_INSTANCE.init();
        List<AbstractPoiType> lf = DEFAULT_INSTANCE.getTopVisibleFilters();
        for (AbstractPoiType l : lf) {
            System.out.println("----------------- " + l.getKeyName());
            Map<PoiCategory, LinkedHashSet<String>> map = l.putTypes(new LinkedHashMap<PoiCategory, LinkedHashSet<String>>());
        }
    }

    public String getSynonyms(AbstractPoiType abstractPoiType) {
        String translation;
        if (this.poiTranslator != null && !Algorithms.isEmpty(translation = this.poiTranslator.getSynonyms(abstractPoiType))) {
            return translation;
        }
        return "";
    }

    public String getEnTranslation(AbstractPoiType abstractPoiType) {
        String translation;
        if (this.poiTranslator != null && !Algorithms.isEmpty(translation = this.poiTranslator.getEnTranslation(abstractPoiType))) {
            return translation;
        }
        return this.getBasePoiName(abstractPoiType);
    }

    public String getTranslation(AbstractPoiType abstractPoiType) {
        String translation;
        if (this.poiTranslator != null && !Algorithms.isEmpty(translation = this.poiTranslator.getTranslation(abstractPoiType))) {
            return translation;
        }
        return this.getBasePoiName(abstractPoiType);
    }

    public String getAllLanguagesTranslationSuffix() {
        if (this.poiTranslator != null) {
            return this.poiTranslator.getAllLanguagesTranslationSuffix();
        }
        return "all languages";
    }

    public String getBasePoiName(AbstractPoiType abstractPoiType) {
        String name = abstractPoiType.getKeyName();
        if (name.startsWith("osmand_")) {
            name = name.substring("osmand_".length());
        }
        if (name.startsWith("amenity_")) {
            name = name.substring("amenity_".length());
        }
        name = name.replace('_', ' ');
        return Algorithms.capitalizeFirstLetterAndLowercase(name);
    }

    public String getPoiTranslation(String keyName) {
        String translation;
        if (this.poiTranslator != null && !Algorithms.isEmpty(translation = this.poiTranslator.getTranslation(keyName))) {
            return translation;
        }
        String name = keyName;
        name = name.replace('_', ' ');
        return Algorithms.capitalizeFirstLetter(name);
    }

    public boolean isRegisteredType(PoiCategory t) {
        return this.getPoiCategoryByName(t.getKeyName()) != this.otherCategory;
    }

    public void initPoiTypesByTag() {
        if (!this.poiTypesByTag.isEmpty()) {
            return;
        }
        for (int i = 0; i < this.categories.size(); ++i) {
            PoiCategory poic = this.categories.get(i);
            for (PoiType p : poic.getPoiTypes()) {
                this.initPoiType(p);
                for (PoiType pts : p.getPoiAdditionals()) {
                    this.initPoiType(pts);
                }
            }
            for (PoiType p : poic.getPoiAdditionals()) {
                this.initPoiType(p);
            }
        }
    }

    private void initPoiType(PoiType p) {
        if (!p.isReference()) {
            Object key = null;
            key = p.isAdditional() ? (p.isText() ? p.getRawOsmTag() : p.getRawOsmTag() + "/" + p.getOsmValue()) : p.getRawOsmTag() + "/" + p.getOsmValue();
            if (this.poiTypesByTag.containsKey(key)) {
                throw new UnsupportedOperationException("!! Duplicate poi type " + (String)key);
            }
            this.poiTypesByTag.put((String)key, p);
        }
    }

    public String replaceDeprecatedSubtype(PoiCategory type, String subtype) {
        if (this.deprecatedTags.containsKey(subtype)) {
            return this.deprecatedTags.get(subtype);
        }
        return subtype;
    }

    public Amenity parseAmenity(String tag, String val, boolean relation, Map<String, String> otherTags) {
        boolean multy;
        boolean hasName;
        this.initPoiTypesByTag();
        PoiType pt = this.poiTypesByTag.get(tag + "/" + val);
        if (pt == null) {
            pt = this.poiTypesByTag.get(tag);
        }
        if (pt == null || pt.isAdditional()) {
            return null;
        }
        if (!Algorithms.isEmpty(pt.getOsmTag2()) && !Algorithms.objectEquals(otherTags.get(pt.getOsmTag2()), pt.getOsmValue2())) {
            return null;
        }
        if (pt.getCategory() == this.getOtherMapCategory()) {
            return null;
        }
        String nameValue = otherTags.get("name");
        if (pt.getNameTag() != null) {
            nameValue = otherTags.get(pt.getNameTag());
        }
        boolean bl = hasName = !Algorithms.isEmpty(nameValue);
        if (!hasName && pt.isNameOnly()) {
            return null;
        }
        boolean bl2 = multy = "multipolygon".equals(otherTags.get("type")) || "site".equals(otherTags.get("type"));
        if (!multy && relation && !pt.isRelation()) {
            return null;
        }
        Amenity a = new Amenity();
        a.setType(pt.getCategory());
        a.setSubType(pt.getKeyName());
        if (pt.getNameTag() != null) {
            a.setName(nameValue);
        }
        a.setOrder(pt.getOrder());
        for (Map.Entry<String, String> e : otherTags.entrySet()) {
            String otag = e.getKey();
            if (otag.equals(tag) || otag.equals("name")) continue;
            PoiType pat = this.poiTypesByTag.get(otag + "/" + e.getValue());
            if (pat == null) {
                for (String splValue : e.getValue().split(";")) {
                    PoiType ps = this.poiTypesByTag.get(otag + "/" + splValue.trim());
                    if (ps == null) continue;
                    a.setAdditionalInfo(ps.getKeyName(), splValue.trim());
                }
                pat = this.poiTypesByTag.get(otag);
            }
            if (pat == null) continue;
            a.setAdditionalInfo(pat.getKeyName(), e.getValue());
        }
        return a;
    }

    public boolean isTextAdditionalInfo(String key, String value) {
        if (key.startsWith("name:") || key.equals("name")) {
            return true;
        }
        PoiType pat = (PoiType)this.getAnyPoiAdditionalTypeByKey(key);
        if (pat == null) {
            return true;
        }
        return pat.isText();
    }

    public void setForbiddenTypes(Set<String> forbiddenTypes) {
        this.forbiddenTypes = forbiddenTypes;
    }

    public boolean isTypeForbidden(String typeName) {
        return this.forbiddenTypes.contains(typeName);
    }

    public static interface PoiTranslator {
        public String getTranslation(AbstractPoiType var1);

        public String getTranslation(String var1);

        public String getEnTranslation(AbstractPoiType var1);

        public String getEnTranslation(String var1);

        public String getSynonyms(AbstractPoiType var1);

        public String getSynonyms(String var1);

        public String getAllLanguagesTranslationSuffix();
    }
}

