/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import java.util.TimeZone;
import net.osmand.IProgress;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.binary.StringBundle;
import net.osmand.binary.StringBundleWriter;
import net.osmand.binary.StringBundleXmlReader;
import net.osmand.binary.StringBundleXmlWriter;
import net.osmand.data.Amenity;
import net.osmand.data.QuadRect;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXTrackAnalysis;
import net.osmand.gpx.SplitMetric;
import net.osmand.gpx.SplitSegment;
import net.osmand.router.RouteColorize;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

@Deprecated
public class GPXUtilities {
    public static final Log log = PlatformUtil.getLog(GPXUtilities.class);
    public static final String ICON_NAME_EXTENSION = "icon";
    public static final String BACKGROUND_TYPE_EXTENSION = "background";
    public static final String COLOR_NAME_EXTENSION = "color";
    public static final String PROFILE_TYPE_EXTENSION = "profile";
    public static final String ADDRESS_EXTENSION = "address";
    public static final String HIDDEN_EXTENSION = "hidden";
    public static final String POINT_TYPE_EXTENSION = "point_type";
    public static final String GPXTPX_PREFIX = "gpxtpx:";
    public static final String OSMAND_EXTENSIONS_PREFIX = "osmand:";
    public static final String OSM_PREFIX = "osm_tag_";
    public static final String AMENITY_PREFIX = "amenity_";
    public static final String AMENITY_ORIGIN_EXTENSION = "amenity_origin";
    public static final String GAP_PROFILE_TYPE = "gap";
    public static final String TRKPT_INDEX_EXTENSION = "trkpt_idx";
    public static final String DEFAULT_ICON_NAME = "special_star";
    public static final String POINT_ELEVATION = "ele";
    public static final String POINT_SPEED = "speed";
    public static final String POINT_BEARING = "bearing";
    public static final char TRAVEL_GPX_CONVERT_FIRST_LETTER = 'A';
    public static final int TRAVEL_GPX_CONVERT_FIRST_DIST = 5000;
    public static final int TRAVEL_GPX_CONVERT_MULT_1 = 2;
    public static final int TRAVEL_GPX_CONVERT_MULT_2 = 5;
    public static boolean GPX_TIME_OLD_FORMAT = false;
    private static final String GPX_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String GPX_TIME_NO_TIMEZONE_PATTERN = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String GPX_TIME_PATTERN_TZ = "yyyy-MM-dd'T'HH:mm:ssXXX";
    private static final Map<String, String> SUPPORTED_EXTENSION_TAGS = new HashMap<String, String>();
    private static final NumberFormat LAT_LON_FORMAT;
    public static final NumberFormat DECIMAL_FORMAT;
    public static final int RADIUS_DIVIDER = 5000;
    public static final double PRIME_MERIDIAN = 179.999991234;

    public static Integer parseColor(String colorString, Integer defColor) {
        Integer color = GPXUtilities.parseColor(colorString);
        return color != null ? color : defColor;
    }

    public static Integer parseColor(String colorString) {
        if (!Algorithms.isEmpty(colorString)) {
            if (colorString.charAt(0) == '#') {
                try {
                    return Algorithms.parseColor(colorString);
                }
                catch (IllegalArgumentException e) {
                    log.error((Object)e);
                }
            } else {
                GPXColor gpxColor = GPXColor.getColorFromName(colorString);
                if (gpxColor != null) {
                    return gpxColor.color;
                }
            }
        }
        return null;
    }

    private static List<GPXTrackAnalysis> convert(List<SplitSegment> splitSegments) {
        ArrayList<GPXTrackAnalysis> list = new ArrayList<GPXTrackAnalysis>();
        for (SplitSegment segment : splitSegments) {
            GPXTrackAnalysis analysis = new GPXTrackAnalysis();
            analysis.prepareInformation(0L, null, segment);
            list.add(analysis);
        }
        return list;
    }

    public static QuadRect calculateBounds(List<WptPt> pts) {
        QuadRect trackBounds = new QuadRect(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        GPXUtilities.updateBounds(trackBounds, pts, 0);
        return trackBounds;
    }

    public static QuadRect calculateTrackBounds(List<TrkSegment> segments) {
        QuadRect trackBounds = new QuadRect(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY);
        boolean updated = false;
        for (TrkSegment segment : segments) {
            if (segment.points.size() <= 0) continue;
            GPXUtilities.updateBounds(trackBounds, segment.points, 0);
            updated = true;
        }
        return updated ? trackBounds : new QuadRect();
    }

    public static void updateBounds(QuadRect trackBounds, List<WptPt> pts, int startIndex) {
        for (int i = startIndex; i < pts.size(); ++i) {
            WptPt pt = pts.get(i);
            trackBounds.right = Math.max(trackBounds.right, pt.lon);
            trackBounds.left = Math.min(trackBounds.left, pt.lon);
            trackBounds.top = Math.max(trackBounds.top, pt.lat);
            trackBounds.bottom = Math.min(trackBounds.bottom, pt.lat);
        }
    }

    public static int calculateTrackPoints(List<TrkSegment> segments) {
        int result = 0;
        for (TrkSegment segment : segments) {
            result += segment.points.size();
        }
        return result;
    }

    public static void updateQR(QuadRect q, WptPt p, double defLat, double defLon) {
        if (q.left == defLon && q.top == defLat && q.right == defLon && q.bottom == defLat) {
            q.left = p.getLongitude();
            q.right = p.getLongitude();
            q.top = p.getLatitude();
            q.bottom = p.getLatitude();
        } else {
            q.left = Math.min(q.left, p.getLongitude());
            q.right = Math.max(q.right, p.getLongitude());
            q.top = Math.max(q.top, p.getLatitude());
            q.bottom = Math.min(q.bottom, p.getLatitude());
        }
    }

    public static String asString(GPXFile file) {
        StringWriter writer = new StringWriter();
        GPXUtilities.writeGpx(writer, file, null);
        return ((Object)writer).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception writeGpxFile(File fout, GPXFile file) {
        OutputStreamWriter output = null;
        try {
            if (fout.getParentFile() != null) {
                fout.getParentFile().mkdirs();
            }
            output = new OutputStreamWriter((OutputStream)new FileOutputStream(fout), "UTF-8");
            if (Algorithms.isEmpty(file.path)) {
                file.path = fout.getAbsolutePath();
            }
            Exception exception = GPXUtilities.writeGpx(output, file, null);
            Algorithms.closeStream(output);
            return exception;
        }
        catch (Exception e) {
            log.error((Object)"Error saving gpx", (Throwable)e);
            Exception exception = e;
            return exception;
        }
        finally {
            Algorithms.closeStream(output);
        }
    }

    public static Exception writeGpx(Writer output, GPXFile file, IProgress progress) {
        if (progress != null) {
            progress.startWork(file.getItemsToWriteSize());
        }
        try {
            XmlSerializer serializer = PlatformUtil.newSerializer();
            serializer.setOutput(output);
            serializer.setFeature("http://xmlpull.org/v1/doc/features.html#indent-output", true);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, "gpx");
            serializer.attribute(null, "version", "1.1");
            if (file.author != null) {
                serializer.attribute(null, "creator", file.author);
            }
            serializer.attribute(null, "xmlns", "http://www.topografix.com/GPX/1/1");
            serializer.attribute(null, "xmlns:osmand", "https://osmand.net");
            serializer.attribute(null, "xmlns:gpxtpx", "http://www.garmin.com/xmlschemas/TrackPointExtension/v1");
            serializer.attribute(null, "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            serializer.attribute(null, "xsi:schemaLocation", "http://www.topografix.com/GPX/1/1 http://www.topografix.com/GPX/1/1/gpx.xsd");
            GPXUtilities.assignPointsGroupsExtensionWriter(file);
            GPXUtilities.assignNetworkRouteExtensionWriter(file);
            GPXUtilities.writeMetadata(serializer, file, progress);
            GPXUtilities.writePoints(serializer, file, progress);
            GPXUtilities.writeRoutes(serializer, file, progress);
            GPXUtilities.writeTracks(serializer, file, progress);
            GPXUtilities.writeExtensions(serializer, file, progress);
            serializer.endTag(null, "gpx");
            serializer.endDocument();
            serializer.flush();
        }
        catch (Exception e) {
            log.error((Object)"Error saving gpx", (Throwable)e);
            return e;
        }
        return null;
    }

    private static void assignNetworkRouteExtensionWriter(final GPXFile gpxFile) {
        if (!Algorithms.isEmpty(gpxFile.networkRouteKeyTags)) {
            gpxFile.setExtensionsWriter("network_route", new GPXExtensionsWriter(){

                @Override
                public void writeExtensions(XmlSerializer serializer) {
                    StringBundle bundle = new StringBundle();
                    StringBundle tagsBundle = new StringBundle();
                    tagsBundle.putString("type", gpxFile.networkRouteKeyTags.get("type"));
                    for (Map.Entry<String, String> tag : gpxFile.networkRouteKeyTags.entrySet()) {
                        tagsBundle.putString(tag.getKey(), tag.getValue());
                    }
                    ArrayList<StringBundle> routeKeyBundle = new ArrayList<StringBundle>();
                    routeKeyBundle.add(tagsBundle);
                    bundle.putBundleList("network_route", "osmand:route_key", routeKeyBundle);
                    StringBundleXmlWriter bundleWriter = new StringBundleXmlWriter(bundle, serializer);
                    ((StringBundleWriter)bundleWriter).writeBundle();
                }
            });
        } else {
            gpxFile.removeExtensionsWriter("network_route");
        }
    }

    private static void assignPointsGroupsExtensionWriter(final GPXFile gpxFile) {
        if (!Algorithms.isEmpty(gpxFile.pointsGroups)) {
            gpxFile.setExtensionsWriter("points_groups", new GPXExtensionsWriter(){

                @Override
                public void writeExtensions(XmlSerializer serializer) {
                    StringBundle bundle = new StringBundle();
                    ArrayList<StringBundle> categoriesBundle = new ArrayList<StringBundle>();
                    for (PointsGroup group : gpxFile.pointsGroups.values()) {
                        categoriesBundle.add(group.toStringBundle());
                    }
                    bundle.putBundleList("points_groups", "group", categoriesBundle);
                    StringBundleXmlWriter bundleWriter = new StringBundleXmlWriter(bundle, serializer);
                    ((StringBundleWriter)bundleWriter).writeBundle();
                }
            });
        } else {
            gpxFile.removeExtensionsWriter("points_groups");
        }
    }

    private static void writeMetadata(XmlSerializer serializer, GPXFile file, IProgress progress) throws IOException {
        String defName = file.metadata.name;
        String trackName = !Algorithms.isEmpty(defName) ? defName : GPXUtilities.getFilename(file.path);
        serializer.startTag(null, "metadata");
        GPXUtilities.writeNotNullText(serializer, "name", trackName);
        GPXUtilities.writeNotNullText(serializer, "desc", file.metadata.desc);
        if (file.metadata.author != null) {
            serializer.startTag(null, "author");
            GPXUtilities.writeAuthor(serializer, file.metadata.author);
            serializer.endTag(null, "author");
        }
        if (file.metadata.copyright != null) {
            serializer.startTag(null, "copyright");
            GPXUtilities.writeCopyright(serializer, file.metadata.copyright);
            serializer.endTag(null, "copyright");
        }
        GPXUtilities.writeNotNullTextWithAttribute(serializer, "link", "href", file.metadata.link);
        if (file.metadata.time != 0L) {
            GPXUtilities.writeNotNullText(serializer, "time", GPXUtilities.formatTime(file.metadata.time));
        }
        GPXUtilities.writeNotNullText(serializer, "keywords", file.metadata.keywords);
        if (file.metadata.bounds != null) {
            GPXUtilities.writeBounds(serializer, file.metadata.bounds);
        }
        GPXUtilities.writeExtensions(serializer, file.metadata, null);
        if (progress != null) {
            progress.progress(1);
        }
        serializer.endTag(null, "metadata");
    }

    private static void writePoints(XmlSerializer serializer, GPXFile file, IProgress progress) throws IOException {
        for (WptPt l : file.points) {
            serializer.startTag(null, "wpt");
            GPXUtilities.writeWpt(serializer, l, progress, file);
            serializer.endTag(null, "wpt");
        }
    }

    private static void writeRoutes(XmlSerializer serializer, GPXFile file, IProgress progress) throws IOException {
        for (Route route : file.routes) {
            serializer.startTag(null, "rte");
            GPXUtilities.writeNotNullText(serializer, "name", route.name);
            GPXUtilities.writeNotNullText(serializer, "desc", route.desc);
            for (WptPt p : route.points) {
                serializer.startTag(null, "rtept");
                GPXUtilities.writeWpt(serializer, p, progress, file);
                serializer.endTag(null, "rtept");
            }
            GPXUtilities.writeExtensions(serializer, route, null);
            serializer.endTag(null, "rte");
        }
    }

    private static void writeTracks(XmlSerializer serializer, GPXFile file, IProgress progress) throws IOException {
        for (Track track : file.tracks) {
            if (track.generalTrack) continue;
            serializer.startTag(null, "trk");
            GPXUtilities.writeNotNullText(serializer, "name", track.name);
            GPXUtilities.writeNotNullText(serializer, "desc", track.desc);
            for (TrkSegment segment : track.segments) {
                serializer.startTag(null, "trkseg");
                GPXUtilities.writeNotNullText(serializer, "name", segment.name);
                for (WptPt p : segment.points) {
                    serializer.startTag(null, "trkpt");
                    GPXUtilities.writeWpt(serializer, p, progress, file);
                    serializer.endTag(null, "trkpt");
                }
                GPXUtilities.assignRouteExtensionWriter(segment);
                GPXUtilities.writeExtensions(serializer, segment, null);
                serializer.endTag(null, "trkseg");
            }
            GPXUtilities.writeExtensions(serializer, track, null);
            serializer.endTag(null, "trk");
        }
    }

    private static void assignRouteExtensionWriter(final TrkSegment segment) {
        if (segment.hasRoute() && segment.getExtensionsWriter("route") == null) {
            segment.setExtensionsWriter("route", new GPXExtensionsWriter(){

                @Override
                public void writeExtensions(XmlSerializer serializer) {
                    StringBundle bundle = new StringBundle();
                    ArrayList<StringBundle> segmentsBundle = new ArrayList<StringBundle>();
                    for (RouteSegment routeSegment : segment.routeSegments) {
                        segmentsBundle.add(routeSegment.toStringBundle());
                    }
                    bundle.putBundleList("route", "segment", segmentsBundle);
                    ArrayList<StringBundle> typesBundle = new ArrayList<StringBundle>();
                    for (RouteType routeType : segment.routeTypes) {
                        typesBundle.add(routeType.toStringBundle());
                    }
                    bundle.putBundleList("types", "type", typesBundle);
                    StringBundleXmlWriter stringBundleXmlWriter = new StringBundleXmlWriter(bundle, serializer);
                    ((StringBundleWriter)stringBundleXmlWriter).writeBundle();
                }
            });
        }
    }

    private static String getFilename(String path) {
        if (path != null) {
            int i = path.lastIndexOf(47);
            if (i > 0) {
                path = path.substring(i + 1);
            }
            if ((i = path.lastIndexOf(46)) > 0) {
                path = path.substring(0, i);
            }
        }
        return path;
    }

    private static void writeNotNullTextWithAttribute(XmlSerializer serializer, String tag, String attribute, String value) throws IOException {
        if (value != null) {
            serializer.startTag(null, tag);
            serializer.attribute(null, attribute, value);
            serializer.endTag(null, tag);
        }
    }

    public static void writeNotNullText(XmlSerializer serializer, String tag, String value) throws IOException {
        if (value != null) {
            serializer.startTag(null, tag);
            serializer.text(value);
            serializer.endTag(null, tag);
        }
    }

    private static void writeExtensions(XmlSerializer serializer, GPXExtensions p, IProgress progress) throws IOException {
        GPXUtilities.writeExtensions(serializer, p.getExtensionsToRead(), p, progress);
    }

    private static void writeExtensions(XmlSerializer serializer, Map<String, String> extensions, GPXExtensions p, IProgress progress) throws IOException {
        boolean hasExtensionWriters;
        Map<String, GPXExtensionsWriter> extensionsWriters = p.getExtensionsWriters();
        boolean hasExtensions = !Algorithms.isEmpty(extensions);
        boolean bl = hasExtensionWriters = !Algorithms.isEmpty(extensionsWriters);
        if (hasExtensions || hasExtensionWriters) {
            serializer.startTag(null, "extensions");
            if (hasExtensions) {
                for (Map.Entry entry : extensions.entrySet()) {
                    GPXUtilities.writeNotNullText(serializer, GPXUtilities.getOsmandTagKey(entry), (String)entry.getValue());
                }
            }
            if (hasExtensionWriters) {
                for (GPXExtensionsWriter gPXExtensionsWriter : extensionsWriters.values()) {
                    gPXExtensionsWriter.writeExtensions(serializer);
                }
            }
            serializer.endTag(null, "extensions");
            if (progress != null) {
                progress.progress(1);
            }
        }
    }

    private static void writeWpt(XmlSerializer serializer, WptPt p, IProgress progress, GPXFile file) throws IOException {
        serializer.attribute(null, "lat", LAT_LON_FORMAT.format(p.lat));
        serializer.attribute(null, "lon", LAT_LON_FORMAT.format(p.lon));
        if (!Double.isNaN(p.ele)) {
            GPXUtilities.writeNotNullText(serializer, POINT_ELEVATION, DECIMAL_FORMAT.format(p.ele));
        }
        if (p.time != 0L) {
            GPXUtilities.writeNotNullText(serializer, "time", GPXUtilities.formatTime(p.time));
        }
        GPXUtilities.writeNotNullText(serializer, "name", p.name);
        GPXUtilities.writeNotNullText(serializer, "desc", p.desc);
        GPXUtilities.writeNotNullTextWithAttribute(serializer, "link", "href", p.link);
        GPXUtilities.writeNotNullText(serializer, "type", p.category);
        GPXUtilities.writeNotNullText(serializer, "cmt", p.comment);
        if (!Double.isNaN(p.hdop)) {
            GPXUtilities.writeNotNullText(serializer, "hdop", DECIMAL_FORMAT.format(p.hdop));
        }
        if (p.speed > 0.0) {
            p.getExtensionsToWrite().put(POINT_SPEED, DECIMAL_FORMAT.format(p.speed));
        }
        if (!Float.isNaN(p.heading)) {
            p.getExtensionsToWrite().put("heading", String.valueOf(Math.round(p.heading)));
        }
        Map<String, String> extensions = p.getExtensionsToRead();
        if (!"rtept".equals(serializer.getName())) {
            extensions.remove(PROFILE_TYPE_EXTENSION);
            extensions.remove(TRKPT_INDEX_EXTENSION);
        } else {
            String profile = extensions.get(PROFILE_TYPE_EXTENSION);
            if (GAP_PROFILE_TYPE.equals(profile)) {
                extensions.remove(PROFILE_TYPE_EXTENSION);
            }
        }
        if (p.category != null && file.pointsGroups.get(p.category) != null) {
            PointsGroup pointsGroup = file.pointsGroups.get(p.category);
            if (p.getColor() == pointsGroup.color) {
                extensions.remove(COLOR_NAME_EXTENSION);
            }
            if (Algorithms.stringsEqual(p.getIconName(), pointsGroup.iconName)) {
                extensions.remove(ICON_NAME_EXTENSION);
            }
            if (Algorithms.stringsEqual(p.getBackgroundType(), pointsGroup.backgroundType)) {
                extensions.remove(BACKGROUND_TYPE_EXTENSION);
            }
        }
        GPXUtilities.assignExtensionWriter(p, extensions);
        GPXUtilities.writeExtensions(serializer, null, p, null);
        if (progress != null) {
            progress.progress(1);
        }
    }

    public static void assignExtensionWriter(WptPt wptPt, Map<String, String> pluginsExtensions) {
        HashMap<String, String> regularExtensions = new HashMap<String, String>();
        HashMap<String, String> gpxtpxExtensions = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : pluginsExtensions.entrySet()) {
            if (entry.getKey().startsWith(GPXTPX_PREFIX)) {
                gpxtpxExtensions.put(entry.getKey(), entry.getValue());
                continue;
            }
            regularExtensions.put(entry.getKey(), entry.getValue());
        }
        if (!Algorithms.isEmpty(regularExtensions)) {
            wptPt.setExtensionsWriter("extensions", GPXUtilities.createExtensionsWriter(regularExtensions, true));
        }
        if (!Algorithms.isEmpty(gpxtpxExtensions)) {
            wptPt.setExtensionsWriter("gpxtpx:TrackPointExtension", GPXUtilities.createGpxTpxExtensionsWriter(gpxtpxExtensions, false));
        }
    }

    private static GPXExtensionsWriter createExtensionsWriter(final Map<String, String> extensions, final boolean addOsmandPrefix) {
        return new GPXExtensionsWriter(){

            @Override
            public void writeExtensions(XmlSerializer serializer) {
                GPXUtilities.writeExtensionsWithPrefix(serializer, extensions, addOsmandPrefix);
            }
        };
    }

    private static GPXExtensionsWriter createGpxTpxExtensionsWriter(final Map<String, String> extensions, final boolean addOsmandPrefix) {
        return new GPXExtensionsWriter(){

            @Override
            public void writeExtensions(XmlSerializer serializer) {
                try {
                    serializer.startTag(null, "gpxtpx:TrackPointExtension");
                    GPXUtilities.writeExtensionsWithPrefix(serializer, extensions, addOsmandPrefix);
                    serializer.endTag(null, "gpxtpx:TrackPointExtension");
                }
                catch (IOException e) {
                    log.error((Object)e);
                }
            }
        };
    }

    private static void writeExtensionsWithPrefix(XmlSerializer serializer, Map<String, String> extensions, boolean addOsmandPrefix) {
        for (Map.Entry<String, String> entry : extensions.entrySet()) {
            try {
                GPXUtilities.writeNotNullText(serializer, addOsmandPrefix ? GPXUtilities.getOsmandTagKey(entry) : entry.getKey(), entry.getValue());
            }
            catch (IOException e) {
                log.error((Object)e);
            }
        }
    }

    private static String getOsmandTagKey(Map.Entry<String, String> entry) {
        String key = entry.getKey();
        if (key.startsWith(OSMAND_EXTENSIONS_PREFIX)) {
            key = key.replace(OSMAND_EXTENSIONS_PREFIX, "");
        }
        key = key.replace(":", "_-_");
        return OSMAND_EXTENSIONS_PREFIX + key;
    }

    private static void writeAuthor(XmlSerializer serializer, Author author) throws IOException {
        String[] idAndDomain;
        GPXUtilities.writeNotNullText(serializer, "name", author.name);
        if (author.email != null && author.email.contains("@") && (idAndDomain = author.email.split("@")).length == 2 && !idAndDomain[0].isEmpty() && !idAndDomain[1].isEmpty()) {
            serializer.startTag(null, "email");
            serializer.attribute(null, "id", idAndDomain[0]);
            serializer.attribute(null, "domain", idAndDomain[1]);
            serializer.endTag(null, "email");
        }
        GPXUtilities.writeNotNullTextWithAttribute(serializer, "link", "href", author.link);
    }

    private static void writeCopyright(XmlSerializer serializer, Copyright copyright) throws IOException {
        if (copyright.author != null) {
            serializer.attribute(null, "author", copyright.author);
        }
        GPXUtilities.writeNotNullText(serializer, "year", copyright.year);
        GPXUtilities.writeNotNullText(serializer, "license", copyright.license);
    }

    private static void writeBounds(XmlSerializer serializer, Bounds bounds) throws IOException {
        serializer.startTag(null, "bounds");
        serializer.attribute(null, "minlat", LAT_LON_FORMAT.format(bounds.minlat));
        serializer.attribute(null, "minlon", LAT_LON_FORMAT.format(bounds.minlon));
        serializer.attribute(null, "maxlat", LAT_LON_FORMAT.format(bounds.maxlat));
        serializer.attribute(null, "maxlon", LAT_LON_FORMAT.format(bounds.maxlon));
        serializer.endTag(null, "bounds");
    }

    public static String readText(XmlPullParser parser, String key) throws XmlPullParserException, IOException {
        int tok;
        StringBuilder text = null;
        while (!((tok = parser.next()) == 1 || tok == 3 && parser.getName().equals(key))) {
            if (tok != 4) continue;
            if (text == null) {
                text = new StringBuilder(parser.getText());
                continue;
            }
            text.append(parser.getText());
        }
        return text == null ? null : text.toString();
    }

    public static Map<String, String> readTextMap(XmlPullParser parser, String key) throws XmlPullParserException, IOException {
        int tok;
        StringBuilder text = null;
        HashMap<String, String> result = new HashMap<String, String>();
        while ((tok = parser.next()) != 1) {
            if (tok == 3) {
                String tag = parser.getName();
                if (text != null && !Algorithms.isEmpty(text.toString().trim())) {
                    result.put(tag, text.toString());
                }
                if (tag.equals(key)) break;
                text = null;
                continue;
            }
            if (tok == 2) {
                text = null;
                continue;
            }
            if (tok != 4) continue;
            if (text == null) {
                text = new StringBuilder(parser.getText());
                continue;
            }
            text.append(parser.getText());
        }
        return result;
    }

    public static String formatTime(long time) {
        SimpleDateFormat format = GPXUtilities.getTimeFormatter();
        return format.format(new Date(time));
    }

    public static long parseTime(String text) {
        if (GPX_TIME_OLD_FORMAT) {
            return GPXUtilities.parseTime(text, GPXUtilities.getTimeFormatter());
        }
        return GPXUtilities.parseTime(text, GPXUtilities.getTimeFormatterTZ());
    }

    public static long parseTime(String text, SimpleDateFormat format) {
        long time = 0L;
        if (text != null) {
            try {
                time = GPXUtilities.flexibleGpxTimeParser(text, format);
            }
            catch (ParseException e1) {
                try {
                    time = GPXUtilities.getTimeNoTimeZoneFormatter().parse(text).getTime();
                }
                catch (ParseException e3) {
                    log.error((Object)("Failed to parse date " + text));
                }
            }
        }
        return time;
    }

    private static long flexibleGpxTimeParser(String text, SimpleDateFormat parser) throws ParseException {
        double ms = 0.0;
        int is = ((String)text).indexOf(46);
        if (is > 0) {
            int es;
            for (es = is + 1; es < ((String)text).length() && Algorithms.isDigit(((String)text).charAt(es)); ++es) {
            }
            ms = Double.parseDouble("0" + ((String)text).substring(is, es));
            text = ((String)text).substring(0, is) + ((String)text).substring(es);
        }
        return parser.parse((String)text).getTime() + (long)(ms * 1000.0);
    }

    public static long getCreationTime(GPXFile gpxFile) {
        long time = 0L;
        if (gpxFile != null && (time = gpxFile.metadata != null && gpxFile.metadata.time > 0L ? gpxFile.metadata.time : gpxFile.getLastPointTime()) == 0L) {
            time = gpxFile.modifiedTime;
        }
        if (time == 0L) {
            time = System.currentTimeMillis();
        }
        return time;
    }

    private static SimpleDateFormat getTimeFormatter() {
        SimpleDateFormat format = new SimpleDateFormat(GPX_TIME_PATTERN, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    private static SimpleDateFormat getTimeNoTimeZoneFormatter() {
        SimpleDateFormat format = new SimpleDateFormat(GPX_TIME_NO_TIMEZONE_PATTERN, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    private static SimpleDateFormat getTimeFormatterTZ() {
        SimpleDateFormat format = new SimpleDateFormat(GPX_TIME_PATTERN_TZ, Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static GPXFile loadGPXFile(File file) {
        return GPXUtilities.loadGPXFile(file, null, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GPXFile loadGPXFile(File file, GPXExtensionsReader extensionsReader, boolean addGeneralTrack) {
        GPXFile gPXFile;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            GPXFile gpxFile = GPXUtilities.loadGPXFile(fis, extensionsReader, addGeneralTrack);
            gpxFile.path = file.getAbsolutePath();
            gpxFile.pointsModifiedTime = gpxFile.modifiedTime = file.lastModified();
            Algorithms.closeStream(fis);
            if (gpxFile.error != null) {
                log.info((Object)("Error reading gpx " + gpxFile.path));
            }
            gPXFile = gpxFile;
        }
        catch (IOException e) {
            GPXFile gPXFile2;
            try {
                GPXFile gpxFile = new GPXFile(null);
                gpxFile.path = file.getAbsolutePath();
                log.error((Object)("Error reading gpx " + gpxFile.path), (Throwable)e);
                gpxFile.error = e;
                gPXFile2 = gpxFile;
            }
            catch (Throwable throwable) {
                Algorithms.closeStream(fis);
                throw throwable;
            }
            Algorithms.closeStream(fis);
            return gPXFile2;
        }
        Algorithms.closeStream(fis);
        return gPXFile;
    }

    public static GPXFile loadGPXFile(InputStream stream) {
        return GPXUtilities.loadGPXFile(stream, null, true);
    }

    public static GPXFile loadGPXFile(InputStream stream, GPXExtensionsReader extensionsReader, boolean addGeneralTrack) {
        GPXFile gpxFile = new GPXFile(null);
        gpxFile.metadata.time = 0L;
        try {
            int tok;
            XmlPullParser parser = PlatformUtil.newXMLPullParser();
            parser.setInput(GPXUtilities.getUTF8Reader(stream));
            Track routeTrack = new Track();
            TrkSegment routeTrackSegment = new TrkSegment();
            routeTrack.segments.add(routeTrackSegment);
            Stack<GPXExtensions> parserState = new Stack<GPXExtensions>();
            TrkSegment firstSegment = null;
            boolean extensionReadMode = false;
            boolean routePointExtension = false;
            ArrayList<RouteSegment> routeSegments = new ArrayList<RouteSegment>();
            ArrayList<RouteType> routeTypes = new ArrayList<RouteType>();
            ArrayList<PointsGroup> pointsGroups = new ArrayList<PointsGroup>();
            boolean routeExtension = false;
            boolean typesExtension = false;
            boolean pointsGroupsExtension = false;
            boolean networkRoute = false;
            parserState.push(gpxFile);
            block28: while ((tok = parser.next()) != 1) {
                Metadata pop;
                String tag;
                GPXExtensions parse;
                if (tok == 2) {
                    String text;
                    WptPt wptPt;
                    parse = (GPXExtensions)parserState.peek();
                    tag = parser.getName();
                    if (extensionReadMode && parse != null && !routePointExtension) {
                        String tagName = tag.toLowerCase();
                        if (routeExtension && tagName.equals("segment")) {
                            RouteSegment segment = GPXUtilities.parseRouteSegmentAttributes(parser);
                            routeSegments.add(segment);
                        } else if (typesExtension && tagName.equals("type")) {
                            RouteType type = GPXUtilities.parseRouteTypeAttributes(parser);
                            routeTypes.add(type);
                        } else if (pointsGroupsExtension && tagName.equals("group")) {
                            PointsGroup pointsGroup = PointsGroup.parsePointsGroupAttributes(parser);
                            pointsGroups.add(pointsGroup);
                        } else if (networkRoute && tagName.equals("route_key")) {
                            gpxFile.networkRouteKeyTags.putAll(GPXUtilities.parseRouteKeyAttributes(parser));
                        }
                        switch (tagName) {
                            case "routepointextension": {
                                routePointExtension = true;
                                if (!(parse instanceof WptPt)) continue block28;
                                parse.getExtensionsToWrite().put("offset", "" + routeTrackSegment.points.size());
                                break;
                            }
                            case "route": {
                                routeExtension = true;
                                break;
                            }
                            case "types": {
                                typesExtension = true;
                                break;
                            }
                            case "points_groups": {
                                pointsGroupsExtension = true;
                                break;
                            }
                            case "network_route": {
                                networkRoute = true;
                                break;
                            }
                            default: {
                                Map<String, String> values;
                                if (extensionsReader != null && extensionsReader.readExtensions(gpxFile, parser) || (values = GPXUtilities.readTextMap(parser, tag)).size() <= 0) continue block28;
                                for (Map.Entry<String, String> entry : values.entrySet()) {
                                    String t = entry.getKey().toLowerCase();
                                    String supportedTag = GPXUtilities.getExtensionsSupportedTag(t);
                                    String value = entry.getValue();
                                    parse.getExtensionsToWrite().put(supportedTag, value);
                                    if (!(parse instanceof WptPt)) continue;
                                    WptPt wptPt2 = (WptPt)parse;
                                    if (POINT_SPEED.equals(tag)) {
                                        try {
                                            wptPt2.speed = Float.parseFloat(value);
                                        }
                                        catch (NumberFormatException e) {
                                            log.debug((Object)e.getMessage(), (Throwable)e);
                                        }
                                        continue;
                                    }
                                    if (!POINT_BEARING.equals(tag)) continue;
                                    try {
                                        wptPt2.bearing = Float.parseFloat(value);
                                    }
                                    catch (NumberFormatException numberFormatException) {}
                                }
                                continue block28;
                            }
                        }
                        continue;
                    }
                    if (parse != null && tag.equals("extensions")) {
                        extensionReadMode = true;
                        continue;
                    }
                    if (routePointExtension) {
                        if (!tag.equals("rpt")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        routeTrackSegment.points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof GPXFile) {
                        if (tag.equals("gpx")) {
                            ((GPXFile)parse).author = parser.getAttributeValue("", "creator");
                        }
                        if (tag.equals("metadata")) {
                            Metadata metadata;
                            ((GPXFile)parse).metadata = metadata = new Metadata();
                            parserState.push(metadata);
                        }
                        if (tag.equals("trk")) {
                            Track track = new Track();
                            ((GPXFile)parse).tracks.add(track);
                            parserState.push(track);
                        }
                        if (tag.equals("rte")) {
                            Route route = new Route();
                            ((GPXFile)parse).routes.add(route);
                            parserState.push(route);
                        }
                        if (!tag.equals("wpt")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        ((GPXFile)parse).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof Metadata) {
                        Bounds bounds;
                        if (tag.equals("name")) {
                            ((Metadata)parse).name = GPXUtilities.readText(parser, "name");
                        }
                        if (tag.equals("desc")) {
                            ((Metadata)parse).desc = GPXUtilities.readText(parser, "desc");
                        }
                        if (tag.equals("author")) {
                            Author author = new Author();
                            author.name = parser.getText();
                            ((Metadata)parse).author = author;
                            parserState.push(author);
                        }
                        if (tag.equals("copyright")) {
                            Copyright copyright = new Copyright();
                            copyright.license = parser.getText();
                            copyright.author = parser.getAttributeValue("", "author");
                            ((Metadata)parse).copyright = copyright;
                            parserState.push(copyright);
                        }
                        if (tag.equals("link")) {
                            ((Metadata)parse).link = parser.getAttributeValue("", "href");
                        }
                        if (tag.equals("time")) {
                            text = GPXUtilities.readText(parser, "time");
                            ((Metadata)parse).time = GPXUtilities.parseTime(text);
                        }
                        if (tag.equals("keywords")) {
                            ((Metadata)parse).keywords = GPXUtilities.readText(parser, "keywords");
                        }
                        if (!tag.equals("bounds")) continue;
                        ((Metadata)parse).bounds = bounds = GPXUtilities.parseBoundsAttributes(parser);
                        parserState.push(bounds);
                        continue;
                    }
                    if (parse instanceof Author) {
                        if (tag.equals("name")) {
                            ((Author)parse).name = GPXUtilities.readText(parser, "name");
                        }
                        if (tag.equals("email")) {
                            String id = parser.getAttributeValue("", "id");
                            String domain = parser.getAttributeValue("", "domain");
                            if (!Algorithms.isEmpty(id) && !Algorithms.isEmpty(domain)) {
                                ((Author)parse).email = id + "@" + domain;
                            }
                        }
                        if (!tag.equals("link")) continue;
                        ((Author)parse).link = parser.getAttributeValue("", "href");
                        continue;
                    }
                    if (parse instanceof Copyright) {
                        if (tag.equals("year")) {
                            ((Copyright)parse).year = GPXUtilities.readText(parser, "year");
                        }
                        if (!tag.equals("license")) continue;
                        ((Copyright)parse).license = GPXUtilities.readText(parser, "license");
                        continue;
                    }
                    if (parse instanceof Route) {
                        if (tag.equals("name")) {
                            ((Route)parse).name = GPXUtilities.readText(parser, "name");
                        }
                        if (tag.equals("desc")) {
                            ((Route)parse).desc = GPXUtilities.readText(parser, "desc");
                        }
                        if (!tag.equals("rtept")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        ((Route)parse).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof Track) {
                        if (tag.equals("name")) {
                            ((Track)parse).name = GPXUtilities.readText(parser, "name");
                            continue;
                        }
                        if (tag.equals("desc")) {
                            ((Track)parse).desc = GPXUtilities.readText(parser, "desc");
                            continue;
                        }
                        if (tag.equals("trkseg")) {
                            TrkSegment trkSeg = new TrkSegment();
                            ((Track)parse).segments.add(trkSeg);
                            parserState.push(trkSeg);
                            continue;
                        }
                        if (!tag.equals("trkpt") && !tag.equals("rpt")) continue;
                        wptPt = GPXUtilities.parseWptAttributes(parser);
                        int size = ((Track)parse).segments.size();
                        if (size == 0) {
                            ((Track)parse).segments.add(new TrkSegment());
                            ++size;
                        }
                        ((Track)parse).segments.get((int)(size - 1)).points.add(wptPt);
                        parserState.push(wptPt);
                        continue;
                    }
                    if (parse instanceof TrkSegment) {
                        if (tag.equals("name")) {
                            ((TrkSegment)parse).name = GPXUtilities.readText(parser, "name");
                        } else if (tag.equals("trkpt") || tag.equals("rpt")) {
                            wptPt = GPXUtilities.parseWptAttributes(parser);
                            ((TrkSegment)parse).points.add(wptPt);
                            parserState.push(wptPt);
                        }
                        if (!tag.equals("csvattributes")) continue;
                        String segmentPoints = GPXUtilities.readText(parser, "csvattributes");
                        String[] pointsArr = segmentPoints.split("\n");
                        for (int i = 0; i < pointsArr.length; ++i) {
                            String[] pointAttrs = pointsArr[i].split(",");
                            try {
                                int arrLength = pointsArr.length;
                                if (arrLength <= 1) continue;
                                WptPt wptPt3 = new WptPt();
                                wptPt3.lon = Double.parseDouble(pointAttrs[0]);
                                wptPt3.lat = Double.parseDouble(pointAttrs[1]);
                                ((TrkSegment)parse).points.add(wptPt3);
                                if (arrLength <= 2) continue;
                                wptPt3.ele = Double.parseDouble(pointAttrs[2]);
                                continue;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                        continue;
                    }
                    if (!(parse instanceof WptPt)) continue;
                    if (tag.equals("name")) {
                        ((WptPt)parse).name = GPXUtilities.readText(parser, "name");
                        continue;
                    }
                    if (tag.equals("desc")) {
                        ((WptPt)parse).desc = GPXUtilities.readText(parser, "desc");
                        continue;
                    }
                    if (tag.equals("cmt")) {
                        ((WptPt)parse).comment = GPXUtilities.readText(parser, "cmt");
                        continue;
                    }
                    if (tag.equals(POINT_SPEED)) {
                        try {
                            String value = GPXUtilities.readText(parser, POINT_SPEED);
                            if (Algorithms.isEmpty(value)) continue;
                            ((WptPt)parse).speed = Float.parseFloat(value);
                            parse.getExtensionsToWrite().put(POINT_SPEED, value);
                        }
                        catch (NumberFormatException value) {}
                        continue;
                    }
                    if (tag.equals("link")) {
                        ((WptPt)parse).link = parser.getAttributeValue("", "href");
                        continue;
                    }
                    if (tag.equals("category")) {
                        ((WptPt)parse).category = GPXUtilities.readText(parser, "category");
                        continue;
                    }
                    if (tag.equals("type")) {
                        if (((WptPt)parse).category != null) continue;
                        ((WptPt)parse).category = GPXUtilities.readText(parser, "type");
                        continue;
                    }
                    if (tag.equals(POINT_ELEVATION)) {
                        text = GPXUtilities.readText(parser, POINT_ELEVATION);
                        if (text == null) continue;
                        try {
                            ((WptPt)parse).ele = Float.parseFloat(text);
                        }
                        catch (NumberFormatException pointsArr) {}
                        continue;
                    }
                    if (tag.equals("hdop")) {
                        text = GPXUtilities.readText(parser, "hdop");
                        if (text == null) continue;
                        try {
                            ((WptPt)parse).hdop = Float.parseFloat(text);
                        }
                        catch (NumberFormatException pointsArr) {}
                        continue;
                    }
                    if (!tag.equals("time")) continue;
                    text = GPXUtilities.readText(parser, "time");
                    ((WptPt)parse).time = GPXUtilities.parseTime(text);
                    continue;
                }
                if (tok != 3) continue;
                parse = parserState.peek();
                tag = parser.getName();
                if (tag.equalsIgnoreCase("routepointextension")) {
                    routePointExtension = false;
                }
                if (parse != null && tag.equals("extensions")) {
                    extensionReadMode = false;
                }
                if (extensionReadMode && tag.equals("route")) {
                    routeExtension = false;
                    continue;
                }
                if (extensionReadMode && tag.equals("types")) {
                    typesExtension = false;
                    continue;
                }
                if (extensionReadMode && tag.equals("network_route")) {
                    networkRoute = false;
                    continue;
                }
                if (tag.equals("metadata")) {
                    pop = (Metadata)parserState.pop();
                    pop.readDescription();
                    assert (pop instanceof Metadata);
                    continue;
                }
                if (tag.equals("author")) {
                    if (!(parse instanceof Author)) continue;
                    parserState.pop();
                    continue;
                }
                if (tag.equals("copyright")) {
                    if (!(parse instanceof Copyright)) continue;
                    parserState.pop();
                    continue;
                }
                if (tag.equals("bounds")) {
                    if (!(parse instanceof Bounds)) continue;
                    parserState.pop();
                    continue;
                }
                if (tag.equals("trkpt")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("wpt")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("rtept")) {
                    pop = parserState.pop();
                    assert (pop instanceof WptPt);
                    continue;
                }
                if (tag.equals("trk")) {
                    pop = parserState.pop();
                    assert (pop instanceof Track);
                    continue;
                }
                if (tag.equals("rte")) {
                    pop = parserState.pop();
                    assert (pop instanceof Route);
                    continue;
                }
                if (tag.equals("trkseg")) {
                    pop = parserState.pop();
                    if (pop instanceof TrkSegment) {
                        TrkSegment segment = (TrkSegment)((Object)pop);
                        segment.routeSegments = routeSegments;
                        segment.routeTypes = routeTypes;
                        routeSegments = new ArrayList();
                        routeTypes = new ArrayList();
                        if (firstSegment == null) {
                            firstSegment = segment;
                        }
                    }
                    assert (pop instanceof TrkSegment);
                    continue;
                }
                if (!tag.equals("rpt")) continue;
                pop = parserState.pop();
                assert (pop instanceof WptPt);
            }
            if (!routeTrackSegment.points.isEmpty()) {
                gpxFile.tracks.add(routeTrack);
            }
            if (!routeSegments.isEmpty() && !routeTypes.isEmpty() && firstSegment != null) {
                firstSegment.routeSegments = routeSegments;
                firstSegment.routeTypes = routeTypes;
            }
            if (!pointsGroups.isEmpty() || !gpxFile.points.isEmpty()) {
                gpxFile.pointsGroups.putAll(GPXUtilities.mergePointsGroups(pointsGroups, gpxFile.points));
            }
            if (addGeneralTrack) {
                gpxFile.addGeneralTrack();
            }
            if (gpxFile.metadata.time == 0L) {
                gpxFile.metadata.time = GPXUtilities.getCreationTime(gpxFile);
            }
        }
        catch (Exception e) {
            gpxFile.error = e;
            log.error((Object)("Error reading gpx. " + gpxFile.path), (Throwable)e);
        }
        return gpxFile;
    }

    private static String getExtensionsSupportedTag(String tag) {
        String supportedTag = SUPPORTED_EXTENSION_TAGS.get(tag);
        return supportedTag == null ? tag : supportedTag;
    }

    private static Map<String, String> parseRouteKeyAttributes(XmlPullParser parser) {
        LinkedHashMap<String, String> networkRouteKeyTags = new LinkedHashMap<String, String>();
        StringBundleXmlReader reader = new StringBundleXmlReader(parser);
        reader.readBundle();
        StringBundle bundle = reader.getBundle();
        if (!bundle.isEmpty()) {
            for (StringBundle.Item<?> item : bundle.getMap().values()) {
                if (item.getType() != StringBundle.ItemType.STRING) continue;
                networkRouteKeyTags.put(item.getName(), (String)item.getValue());
            }
        }
        return networkRouteKeyTags;
    }

    private static Map<String, PointsGroup> mergePointsGroups(List<PointsGroup> groups, List<WptPt> points) {
        LinkedHashMap<String, PointsGroup> pointsGroups = new LinkedHashMap<String, PointsGroup>();
        for (PointsGroup category : groups) {
            pointsGroups.put(category.name, category);
        }
        for (WptPt point : points) {
            String categoryName = point.category != null ? point.category : "";
            PointsGroup pointsGroup = (PointsGroup)pointsGroups.get(categoryName);
            if (pointsGroup == null) {
                pointsGroup = new PointsGroup(point);
                pointsGroups.put(categoryName, pointsGroup);
            }
            int color = point.getColor();
            if (pointsGroup.color == 0 && color != 0) {
                pointsGroup.color = color;
            } else if (pointsGroup.color != 0 && color == 0) {
                point.setColor(pointsGroup.color);
            }
            String iconName = point.getIconName();
            if (Algorithms.isEmpty(pointsGroup.iconName) && !Algorithms.isEmpty(iconName)) {
                pointsGroup.iconName = iconName;
            } else if (!Algorithms.isEmpty(pointsGroup.iconName) && Algorithms.isEmpty(iconName)) {
                point.setIconName(pointsGroup.iconName);
            }
            String backgroundType = point.getBackgroundType();
            if (Algorithms.isEmpty(pointsGroup.backgroundType) && !Algorithms.isEmpty(backgroundType)) {
                pointsGroup.backgroundType = backgroundType;
            } else if (!Algorithms.isEmpty(pointsGroup.backgroundType) && Algorithms.isEmpty(backgroundType)) {
                point.setBackgroundType(pointsGroup.backgroundType);
            }
            pointsGroup.points.add(point);
        }
        return pointsGroups;
    }

    private static Reader getUTF8Reader(InputStream f) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(f);
        assert (bis.markSupported());
        bis.mark(3);
        boolean reset = true;
        byte[] t = new byte[3];
        bis.read(t);
        if (t[0] == -17 && t[1] == -69 && t[2] == -65) {
            reset = false;
        }
        if (reset) {
            bis.reset();
        }
        return new InputStreamReader((InputStream)bis, "UTF-8");
    }

    private static WptPt parseWptAttributes(XmlPullParser parser) {
        WptPt wpt = new WptPt();
        try {
            wpt.lat = Double.parseDouble(parser.getAttributeValue("", "lat"));
            wpt.lon = Double.parseDouble(parser.getAttributeValue("", "lon"));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return wpt;
    }

    private static RouteSegment parseRouteSegmentAttributes(XmlPullParser parser) {
        RouteSegment segment = new RouteSegment();
        segment.id = parser.getAttributeValue("", "id");
        segment.length = parser.getAttributeValue("", "length");
        segment.startTrackPointIndex = parser.getAttributeValue("", "startTrkptIdx");
        segment.segmentTime = parser.getAttributeValue("", "segmentTime");
        segment.speed = parser.getAttributeValue("", POINT_SPEED);
        segment.turnType = parser.getAttributeValue("", "turnType");
        segment.turnLanes = parser.getAttributeValue("", "turnLanes");
        segment.turnAngle = parser.getAttributeValue("", "turnAngle");
        segment.skipTurn = parser.getAttributeValue("", "skipTurn");
        segment.types = parser.getAttributeValue("", "types");
        segment.pointTypes = parser.getAttributeValue("", "pointTypes");
        segment.names = parser.getAttributeValue("", "names");
        return segment;
    }

    private static RouteType parseRouteTypeAttributes(XmlPullParser parser) {
        RouteType type = new RouteType();
        type.tag = parser.getAttributeValue("", "t");
        type.value = parser.getAttributeValue("", "v");
        return type;
    }

    private static Bounds parseBoundsAttributes(XmlPullParser parser) {
        Bounds bounds = new Bounds();
        try {
            String minlat = parser.getAttributeValue("", "minlat");
            String minlon = parser.getAttributeValue("", "minlon");
            String maxlat = parser.getAttributeValue("", "maxlat");
            String maxlon = parser.getAttributeValue("", "maxlon");
            if (minlat == null) {
                minlat = parser.getAttributeValue("", "minLat");
            }
            if (minlon == null) {
                minlon = parser.getAttributeValue("", "minLon");
            }
            if (maxlat == null) {
                maxlat = parser.getAttributeValue("", "maxLat");
            }
            if (maxlon == null) {
                maxlon = parser.getAttributeValue("", "maxLon");
            }
            if (minlat != null) {
                bounds.minlat = Double.parseDouble(minlat);
            }
            if (minlon != null) {
                bounds.minlon = Double.parseDouble(minlon);
            }
            if (maxlat != null) {
                bounds.maxlat = Double.parseDouble(maxlat);
            }
            if (maxlon != null) {
                bounds.maxlon = Double.parseDouble(maxlon);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bounds;
    }

    public static void mergeGPXFileInto(GPXFile to, GPXFile from) {
        if (from == null) {
            return;
        }
        if (from.showCurrentTrack) {
            to.showCurrentTrack = true;
        }
        if (!Algorithms.isEmpty(from.points)) {
            to.addPoints(from.points);
        }
        if (from.tracks != null) {
            to.tracks.addAll(from.tracks);
        }
        if (from.routes != null) {
            to.routes.addAll(from.routes);
        }
        if (from.error != null) {
            to.error = from.error;
        }
    }

    public static WptPt projectionOnPrimeMeridian(WptPt previous, WptPt next) {
        double lat = MapUtils.getProjection(0.0, 0.0, previous.lat, previous.lon, next.lat, next.lon).getLatitude();
        double lon = previous.lon < 0.0 ? -179.999991234 : 179.999991234;
        double projectionCoeff = MapUtils.getProjectionCoeff(0.0, 0.0, previous.lat, previous.lon, next.lat, next.lon);
        long time = (long)((double)previous.time + (double)(next.time - previous.time) * projectionCoeff);
        double ele = Double.isNaN(previous.ele + next.ele) ? Double.NaN : previous.ele + (next.ele - previous.ele) * projectionCoeff;
        double speed = previous.speed + (next.speed - previous.speed) * projectionCoeff;
        return new WptPt(lat, lon, time, ele, speed, Double.NaN);
    }

    public static void interpolateEmptyElevationWpts(List<WptPt> pts) {
        int processedPoints;
        block0: for (int i = 0; i < pts.size(); i += processedPoints > 0 ? processedPoints : 1) {
            double ele;
            int j;
            processedPoints = 0;
            if (!Double.isNaN(pts.get((int)i).ele)) continue;
            int startIndex = i;
            int prevValidIndex = -1;
            int nextValidIndex = -1;
            double prevValidElevation = Double.NaN;
            double nextValidElevation = Double.NaN;
            for (j = startIndex - 1; j >= 0; --j) {
                ele = pts.get((int)j).ele;
                if (Double.isNaN(ele)) continue;
                prevValidElevation = ele;
                prevValidIndex = j;
                break;
            }
            for (j = startIndex + 1; j < pts.size(); ++j) {
                ele = pts.get((int)j).ele;
                if (Double.isNaN(ele)) continue;
                nextValidElevation = ele;
                nextValidIndex = j;
                break;
            }
            if (prevValidIndex == -1 && nextValidIndex == -1) {
                return;
            }
            if (prevValidIndex == -1 || nextValidIndex == -1) {
                for (j = startIndex; j < pts.size(); ++j) {
                    WptPt pt = pts.get(j);
                    if (!Double.isNaN(pt.ele)) continue block0;
                    pt.ele = startIndex == 0 ? nextValidElevation : prevValidElevation;
                    ++processedPoints;
                }
                continue;
            }
            double totalDistance = 0.0;
            double[] distanceArray = new double[nextValidIndex - prevValidIndex];
            for (int j2 = prevValidIndex; j2 < nextValidIndex; ++j2) {
                double distance;
                WptPt thisPt = pts.get(j2);
                WptPt nextPt = pts.get(j2 + 1);
                distanceArray[j2 - prevValidIndex] = distance = MapUtils.getDistance(thisPt.lat, thisPt.lon, nextPt.lat, nextPt.lon);
                totalDistance += distance;
            }
            double deltaElevation = pts.get((int)nextValidIndex).ele - pts.get((int)prevValidIndex).ele;
            for (int j3 = startIndex; totalDistance > 0.0 && j3 < nextValidIndex; ++j3) {
                double currentDistance = distanceArray[j3 - startIndex];
                double increaseElevation = deltaElevation * (currentDistance / totalDistance);
                pts.get((int)j3).ele = pts.get((int)(j3 - 1)).ele + increaseElevation;
                ++processedPoints;
            }
        }
    }

    static {
        SUPPORTED_EXTENSION_TAGS.put("heartrate", "gpxtpx:hr");
        SUPPORTED_EXTENSION_TAGS.put("osmand:hr", "gpxtpx:hr");
        SUPPORTED_EXTENSION_TAGS.put("hr", "gpxtpx:hr");
        SUPPORTED_EXTENSION_TAGS.put("speed_sensor", "osmand:speed_sensor");
        SUPPORTED_EXTENSION_TAGS.put("cad", "gpxtpx:cad");
        SUPPORTED_EXTENSION_TAGS.put("cadence", "gpxtpx:cad");
        SUPPORTED_EXTENSION_TAGS.put("temp", "gpxtpx:wtemp");
        SUPPORTED_EXTENSION_TAGS.put("wtemp", "gpxtpx:wtemp");
        SUPPORTED_EXTENSION_TAGS.put("atemp", "gpxtpx:atemp");
        LAT_LON_FORMAT = new DecimalFormat("0.00#####", new DecimalFormatSymbols(Locale.US));
        DECIMAL_FORMAT = new DecimalFormat("#.#", new DecimalFormatSymbols(Locale.US));
    }

    public static class RouteSegment {
        public static final String START_TRKPT_IDX_ATTR = "startTrkptIdx";
        public String id;
        public String length;
        public String startTrackPointIndex;
        public String segmentTime;
        public String speed;
        public String turnType;
        public String turnLanes;
        public String turnAngle;
        public String skipTurn;
        public String types;
        public String pointTypes;
        public String names;

        public static RouteSegment fromStringBundle(StringBundle bundle) {
            RouteSegment s = new RouteSegment();
            s.id = bundle.getString("id", null);
            s.length = bundle.getString("length", null);
            s.startTrackPointIndex = bundle.getString(START_TRKPT_IDX_ATTR, null);
            s.segmentTime = bundle.getString("segmentTime", null);
            s.speed = bundle.getString(GPXUtilities.POINT_SPEED, null);
            s.turnType = bundle.getString("turnType", null);
            s.turnLanes = bundle.getString("turnLanes", null);
            s.turnAngle = bundle.getString("turnAngle", null);
            s.skipTurn = bundle.getString("skipTurn", null);
            s.types = bundle.getString("types", null);
            s.pointTypes = bundle.getString("pointTypes", null);
            s.names = bundle.getString("names", null);
            return s;
        }

        public StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("id", this.id);
            bundle.putString("length", this.length);
            bundle.putString(START_TRKPT_IDX_ATTR, this.startTrackPointIndex);
            bundle.putString("segmentTime", this.segmentTime);
            bundle.putString(GPXUtilities.POINT_SPEED, this.speed);
            bundle.putString("turnType", this.turnType);
            bundle.putString("turnLanes", this.turnLanes);
            bundle.putString("turnAngle", this.turnAngle);
            bundle.putString("skipTurn", this.skipTurn);
            bundle.putString("types", this.types);
            bundle.putString("pointTypes", this.pointTypes);
            bundle.putString("names", this.names);
            return bundle;
        }
    }

    public static enum GPXColor {
        BLACK(-16777216),
        DARKGRAY(-12303292),
        GRAY(-7829368),
        LIGHTGRAY(-3355444),
        WHITE(-1),
        RED(-65536),
        DARKRED(-7667712),
        GREEN(-16711936),
        DARKGREEN(-16751616),
        BLUE(-16776961),
        DARKBLUE(-16777077),
        YELLOW(-256),
        DARKYELLOW(-6584564),
        CYAN(-16711681),
        DARKCYAN(-16741493),
        MAGENTA(-65281),
        DARKMAGENTA(-7667573),
        AQUA(-16711681),
        FUCHSIA(-65281),
        DARKGREY(-12303292),
        GREY(-7829368),
        LIGHTGREY(-3355444),
        LIME(-16711936),
        MAROON(-8388608),
        NAVY(-16777088),
        OLIVE(-8355840),
        PURPLE(-8388480),
        SILVER(-4144960),
        TEAL(-16744320);

        public final int color;

        private GPXColor(int color) {
            this.color = color;
        }

        public static GPXColor getColorFromName(String name) {
            for (GPXColor c : GPXColor.values()) {
                if (!c.name().equalsIgnoreCase(name)) continue;
                return c;
            }
            return null;
        }
    }

    public static class TrkSegment
    extends GPXExtensions {
        public String name = null;
        public boolean generalSegment = false;
        public List<WptPt> points = new ArrayList<WptPt>();
        public Object renderer;
        public List<RouteSegment> routeSegments = new ArrayList<RouteSegment>();
        public List<RouteType> routeTypes = new ArrayList<RouteType>();

        public boolean hasRoute() {
            return !this.routeSegments.isEmpty() && !this.routeTypes.isEmpty();
        }

        public List<GPXTrackAnalysis> splitByDistance(double meters, boolean joinSegments) {
            return this.split(new SplitMetric.DistanceSplitMetric(), new SplitMetric.TimeSplitMetric(), meters, joinSegments);
        }

        public List<GPXTrackAnalysis> splitByTime(int seconds, boolean joinSegments) {
            return this.split(new SplitMetric.TimeSplitMetric(), new SplitMetric.DistanceSplitMetric(), seconds, joinSegments);
        }

        private List<GPXTrackAnalysis> split(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit, boolean joinSegments) {
            ArrayList<SplitSegment> splitSegments = new ArrayList<SplitSegment>();
            SplitMetric.splitSegment(metric, secondaryMetric, metricLimit, splitSegments, this, joinSegments);
            return GPXUtilities.convert(splitSegments);
        }
    }

    public static class WptPt
    extends GPXExtensions {
        public boolean firstPoint = false;
        public boolean lastPoint = false;
        public double lat;
        public double lon;
        public String name = null;
        public String link = null;
        public String category = null;
        public String desc = null;
        public String comment = null;
        public long time = 0L;
        public double ele = Double.NaN;
        public double speed = 0.0;
        public double hdop = Double.NaN;
        public float heading = Float.NaN;
        public float bearing = Float.NaN;
        public boolean deleted = false;
        public int speedColor = 0;
        public int altitudeColor = 0;
        public int slopeColor = 0;
        public int colourARGB = 0;
        public double distance = 0.0;

        public WptPt() {
        }

        public WptPt(WptPt wptPt) {
            this.lat = wptPt.lat;
            this.lon = wptPt.lon;
            this.name = wptPt.name;
            this.link = wptPt.link;
            this.category = wptPt.category;
            this.desc = wptPt.desc;
            this.comment = wptPt.comment;
            this.time = wptPt.time;
            this.ele = wptPt.ele;
            this.speed = wptPt.speed;
            this.hdop = wptPt.hdop;
            this.heading = wptPt.heading;
            this.deleted = wptPt.deleted;
            this.speedColor = wptPt.speedColor;
            this.altitudeColor = wptPt.altitudeColor;
            this.slopeColor = wptPt.slopeColor;
            this.colourARGB = wptPt.colourARGB;
            this.distance = wptPt.distance;
            this.getExtensionsToWrite().putAll(wptPt.getExtensionsToWrite());
        }

        public void setDistance(double dist) {
            this.distance = dist;
        }

        public double getDistance() {
            return this.distance;
        }

        public int getColor() {
            return this.getColor(0);
        }

        public double getLatitude() {
            return this.lat;
        }

        public double getLongitude() {
            return this.lon;
        }

        public float getHeading() {
            return this.heading;
        }

        public WptPt(double lat, double lon) {
            this.lat = lat;
            this.lon = lon;
        }

        public WptPt(double lat, double lon, long time, double ele, double speed, double hdop) {
            this(lat, lon, time, ele, speed, hdop, Float.NaN);
        }

        public WptPt(double lat, double lon, long time, double ele, double speed, double hdop, float heading) {
            this.lat = lat;
            this.lon = lon;
            this.time = time;
            this.ele = ele;
            this.speed = speed;
            this.hdop = hdop;
            this.heading = heading;
        }

        public WptPt(double lat, double lon, String desc, String name, String category, String color, String icon, String background) {
            this.lat = lat;
            this.lon = lon;
            this.desc = desc;
            this.name = name;
            this.category = category;
            this.setColor(color);
            this.setIconName(icon);
            this.setBackgroundType(background);
        }

        public boolean isVisible() {
            return true;
        }

        public String getIconName() {
            return this.getExtensionsToRead().get(GPXUtilities.ICON_NAME_EXTENSION);
        }

        public String getIconNameOrDefault() {
            String iconName = this.getIconName();
            if (iconName == null) {
                iconName = GPXUtilities.DEFAULT_ICON_NAME;
            }
            return iconName;
        }

        public void setIconName(String iconName) {
            this.getExtensionsToWrite().put(GPXUtilities.ICON_NAME_EXTENSION, iconName);
        }

        public String getAmenityOriginName() {
            Map<String, String> extensionsToRead = this.getExtensionsToRead();
            String amenityOrigin = extensionsToRead.get(GPXUtilities.AMENITY_ORIGIN_EXTENSION);
            if (amenityOrigin == null && this.comment != null && this.comment.startsWith(Amenity.class.getSimpleName())) {
                amenityOrigin = this.comment;
            }
            return amenityOrigin;
        }

        public void setAmenityOriginName(String originName) {
            this.getExtensionsToWrite().put(GPXUtilities.AMENITY_ORIGIN_EXTENSION, originName);
        }

        public int getColor(RouteColorize.ColorizationType type) {
            if (type == RouteColorize.ColorizationType.SPEED) {
                return this.speedColor;
            }
            if (type == RouteColorize.ColorizationType.ELEVATION) {
                return this.altitudeColor;
            }
            return this.slopeColor;
        }

        public void setColor(RouteColorize.ColorizationType type, int color) {
            if (type == RouteColorize.ColorizationType.SPEED) {
                this.speedColor = color;
            } else if (type == RouteColorize.ColorizationType.ELEVATION) {
                this.altitudeColor = color;
            } else if (type == RouteColorize.ColorizationType.SLOPE) {
                this.slopeColor = color;
            }
        }

        public String getBackgroundType() {
            return this.getExtensionsToRead().get(GPXUtilities.BACKGROUND_TYPE_EXTENSION);
        }

        public void setBackgroundType(String type) {
            this.getExtensionsToWrite().put(GPXUtilities.BACKGROUND_TYPE_EXTENSION, type);
        }

        public String getSpecialPointType() {
            return this.getExtensionsToRead().get(GPXUtilities.POINT_TYPE_EXTENSION);
        }

        public void setSpecialPointType(String type) {
            this.getExtensionsToWrite().put(GPXUtilities.POINT_TYPE_EXTENSION, type);
        }

        public String getProfileType() {
            return this.getExtensionsToRead().get(GPXUtilities.PROFILE_TYPE_EXTENSION);
        }

        public String getAddress() {
            return this.getExtensionsToRead().get(GPXUtilities.ADDRESS_EXTENSION);
        }

        public void setAddress(String address) {
            if (Algorithms.isBlank(address)) {
                this.getExtensionsToWrite().remove(GPXUtilities.ADDRESS_EXTENSION);
            } else {
                this.getExtensionsToWrite().put(GPXUtilities.ADDRESS_EXTENSION, address);
            }
        }

        public void setHidden(String hidden) {
            this.getExtensionsToWrite().put(GPXUtilities.HIDDEN_EXTENSION, hidden);
        }

        public void setProfileType(String profileType) {
            this.getExtensionsToWrite().put(GPXUtilities.PROFILE_TYPE_EXTENSION, profileType);
        }

        public boolean hasProfile() {
            String profileType = this.getProfileType();
            return profileType != null && !GPXUtilities.GAP_PROFILE_TYPE.equals(profileType);
        }

        public boolean isGap() {
            String profileType = this.getProfileType();
            return GPXUtilities.GAP_PROFILE_TYPE.equals(profileType);
        }

        public void setGap() {
            this.setProfileType(GPXUtilities.GAP_PROFILE_TYPE);
        }

        public void removeProfileType() {
            this.getExtensionsToWrite().remove(GPXUtilities.PROFILE_TYPE_EXTENSION);
        }

        public int getTrkPtIndex() {
            try {
                return Integer.parseInt(this.getExtensionsToRead().get(GPXUtilities.TRKPT_INDEX_EXTENSION));
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }

        public void setTrkPtIndex(int index) {
            this.getExtensionsToWrite().put(GPXUtilities.TRKPT_INDEX_EXTENSION, String.valueOf(index));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            result = 31 * result + (this.category == null ? 0 : this.category.hashCode());
            result = 31 * result + (this.desc == null ? 0 : this.desc.hashCode());
            result = 31 * result + (this.comment == null ? 0 : this.comment.hashCode());
            result = 31 * result + (this.lat == 0.0 ? 0 : Double.valueOf(this.lat).hashCode());
            result = 31 * result + (this.lon == 0.0 ? 0 : Double.valueOf(this.lon).hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            WptPt other = (WptPt)obj;
            return Algorithms.objectEquals(other.name, this.name) && Algorithms.objectEquals(other.category, this.category) && Algorithms.objectEquals(other.lat, this.lat) && Algorithms.objectEquals(other.lon, this.lon) && Algorithms.objectEquals(other.desc, this.desc);
        }

        public boolean hasLocation() {
            return this.lat != 0.0 && this.lon != 0.0;
        }

        public static WptPt createAdjustedPoint(double lat, double lon, String description, String name, String category, int color, String iconName, String backgroundType, String amenityOriginName, Map<String, String> amenityExtensions) {
            double latAdjusted = Double.parseDouble(LAT_LON_FORMAT.format(lat));
            double lonAdjusted = Double.parseDouble(LAT_LON_FORMAT.format(lon));
            WptPt point = new WptPt(latAdjusted, lonAdjusted, System.currentTimeMillis(), Double.NaN, 0.0, Double.NaN);
            point.name = name;
            point.category = category;
            point.desc = description;
            if (color != 0) {
                point.setColor(color);
            }
            if (iconName != null) {
                point.setIconName(iconName);
            }
            if (backgroundType != null) {
                point.setBackgroundType(backgroundType);
            }
            if (amenityOriginName != null) {
                point.setAmenityOriginName(amenityOriginName);
            }
            if (amenityExtensions != null) {
                point.getExtensionsToWrite().putAll(amenityExtensions);
            }
            return point;
        }

        void updatePoint(WptPt pt) {
            String hidden;
            String address;
            String backgroundType;
            String iconName;
            this.lat = Double.parseDouble(LAT_LON_FORMAT.format(pt.lat));
            this.lon = Double.parseDouble(LAT_LON_FORMAT.format(pt.lon));
            this.time = System.currentTimeMillis();
            this.desc = pt.desc;
            this.name = pt.name;
            this.category = pt.category;
            Map<String, String> extensions = pt.getExtensionsToRead();
            String color = extensions.get(GPXUtilities.COLOR_NAME_EXTENSION);
            if (color != null) {
                this.setColor(color);
            }
            if ((iconName = extensions.get(GPXUtilities.ICON_NAME_EXTENSION)) != null) {
                this.setIconName(iconName);
            }
            if ((backgroundType = extensions.get(GPXUtilities.BACKGROUND_TYPE_EXTENSION)) != null) {
                this.setBackgroundType(backgroundType);
            }
            if ((address = extensions.get(GPXUtilities.ADDRESS_EXTENSION)) != null) {
                this.setAddress(address);
            }
            if ((hidden = extensions.get(GPXUtilities.HIDDEN_EXTENSION)) != null) {
                this.setHidden(hidden);
            }
        }
    }

    public static class GPXExtensions {
        public Map<String, String> extensions = null;
        public Map<String, GPXExtensionsWriter> extensionsWriters = null;

        public Map<String, String> getExtensionsToRead() {
            if (this.extensions == null) {
                return Collections.emptyMap();
            }
            return this.extensions;
        }

        public Map<String, String> getExtensionsToWrite() {
            if (this.extensions == null) {
                this.extensions = new LinkedHashMap<String, String>();
            }
            return this.extensions;
        }

        public Map<String, GPXExtensionsWriter> getExtensionsWriters() {
            if (this.extensionsWriters == null) {
                this.extensionsWriters = new LinkedHashMap<String, GPXExtensionsWriter>();
            }
            return this.extensionsWriters;
        }

        public void copyExtensions(GPXExtensions e) {
            Map<String, String> extensionsToRead = e.getExtensionsToRead();
            if (!extensionsToRead.isEmpty()) {
                this.getExtensionsToWrite().putAll(extensionsToRead);
            }
        }

        public GPXExtensionsWriter getExtensionsWriter(String key) {
            return this.getExtensionsWriters().get(key);
        }

        public void setExtensionsWriter(String key, GPXExtensionsWriter extensionsWriter) {
            this.getExtensionsWriters().put(key, extensionsWriter);
        }

        public void removeExtensionsWriter(String key) {
            this.getExtensionsWriters().remove(key);
        }

        public Integer getColor(Integer defColor) {
            String value = this.getColorValue();
            return GPXUtilities.parseColor(value, defColor);
        }

        public String getColorValue() {
            String value = null;
            if (this.extensions != null) {
                value = this.extensions.get(GPXUtilities.COLOR_NAME_EXTENSION);
                if (value == null) {
                    value = this.extensions.get("colour");
                }
                if (value == null) {
                    value = this.extensions.get("displaycolor");
                }
                if (value == null) {
                    value = this.extensions.get("displaycolour");
                }
            }
            return value;
        }

        public boolean hasColor() {
            return this.getColorValue() != null;
        }

        public void setColor(int color) {
            this.setColor(Algorithms.colorToString(color));
        }

        public void setColor(String color) {
            this.getExtensionsToWrite().put(GPXUtilities.COLOR_NAME_EXTENSION, color);
        }

        public void removeColor() {
            this.getExtensionsToWrite().remove(GPXUtilities.COLOR_NAME_EXTENSION);
        }
    }

    public static interface GPXExtensionsWriter {
        public void writeExtensions(XmlSerializer var1);
    }

    public static class Metadata
    extends GPXExtensions {
        public String name;
        public String desc;
        public String link;
        public String keywords;
        public long time = 0L;
        public Author author = null;
        public Copyright copyright = null;
        public Bounds bounds = null;

        public Metadata() {
        }

        public Metadata(Metadata source) {
            this.name = source.name;
            this.desc = source.desc;
            this.link = source.link;
            this.keywords = source.keywords;
            this.time = source.time;
            if (source.author != null) {
                this.author = new Author(source.author);
            }
            if (source.copyright != null) {
                this.copyright = new Copyright(source.copyright);
            }
            if (source.bounds != null) {
                this.bounds = new Bounds(source.bounds);
            }
            this.copyExtensions(source);
        }

        public String getArticleTitle() {
            return this.getExtensionsToRead().get("article_title");
        }

        public String getArticleLang() {
            return this.getExtensionsToRead().get("article_lang");
        }

        public String getDescription() {
            return this.desc;
        }

        public void readDescription() {
            String readDescription = this.getExtensionsToWrite().remove("desc");
            if (!Algorithms.isEmpty(readDescription)) {
                this.desc = Algorithms.isEmpty(this.desc) ? readDescription : this.desc + "; " + readDescription;
            }
        }
    }

    public static class Author
    extends GPXExtensions {
        public String name;
        public String email;
        public String link;

        public Author() {
        }

        public Author(Author author) {
            this.name = author.name;
            this.email = author.email;
            this.link = author.link;
            this.copyExtensions(author);
        }
    }

    public static class Copyright
    extends GPXExtensions {
        public String author;
        public String year;
        public String license;

        public Copyright() {
        }

        public Copyright(Copyright copyright) {
            this.author = copyright.author;
            this.year = copyright.year;
            this.license = copyright.license;
            this.copyExtensions(copyright);
        }
    }

    public static class Bounds
    extends GPXExtensions {
        public double minlat;
        public double minlon;
        public double maxlat;
        public double maxlon;

        public Bounds() {
        }

        public Bounds(Bounds source) {
            this.minlat = source.minlat;
            this.minlon = source.minlon;
            this.maxlat = source.maxlat;
            this.maxlon = source.maxlon;
            this.copyExtensions(source);
        }
    }

    public static class Route
    extends GPXExtensions {
        public String name = null;
        public String desc = null;
        public List<WptPt> points = new ArrayList<WptPt>();
    }

    public static class Track
    extends GPXExtensions {
        public String name = null;
        public String desc = null;
        public List<TrkSegment> segments = new ArrayList<TrkSegment>();
        public boolean generalTrack = false;
    }

    public static class PointsGroup {
        public static final String DEFAULT_WPT_GROUP_NAME = "";
        public String name;
        public String iconName;
        public String backgroundType;
        public List<WptPt> points = new ArrayList<WptPt>();
        public int color;
        public boolean hidden;

        public PointsGroup(String name) {
            this.name = name != null ? name : DEFAULT_WPT_GROUP_NAME;
        }

        public PointsGroup(String name, String iconName, String backgroundType, int color) {
            this(name);
            this.color = color;
            this.iconName = iconName;
            this.backgroundType = backgroundType;
        }

        public PointsGroup(WptPt point) {
            this(point.category);
            this.color = point.getColor();
            this.iconName = point.getIconName();
            this.backgroundType = point.getBackgroundType();
        }

        public void setName(String name) {
            this.name = name;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public void setHidden(boolean hidden) {
            this.hidden = hidden;
        }

        public int hashCode() {
            return Algorithms.hash(this.name, this.iconName, this.backgroundType, this.color, this.points, this.hidden);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PointsGroup that = (PointsGroup)o;
            return this.color == that.color && Algorithms.objectEquals(this.points, that.points) && Algorithms.stringsEqual(this.name, that.name) && Algorithms.stringsEqual(this.iconName, that.iconName) && Algorithms.stringsEqual(this.backgroundType, that.backgroundType) && Algorithms.objectEquals(this.hidden, that.hidden);
        }

        public StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("name", this.name != null ? this.name : DEFAULT_WPT_GROUP_NAME);
            if (this.color != 0) {
                bundle.putString(GPXUtilities.COLOR_NAME_EXTENSION, Algorithms.colorToString(this.color));
            }
            if (!Algorithms.isEmpty(this.iconName)) {
                bundle.putString(GPXUtilities.ICON_NAME_EXTENSION, this.iconName);
            }
            if (!Algorithms.isEmpty(this.backgroundType)) {
                bundle.putString(GPXUtilities.BACKGROUND_TYPE_EXTENSION, this.backgroundType);
            }
            if (this.isHidden()) {
                bundle.putBoolean(GPXUtilities.HIDDEN_EXTENSION, true);
            }
            return bundle;
        }

        private static PointsGroup parsePointsGroupAttributes(XmlPullParser parser) {
            String name = parser.getAttributeValue(DEFAULT_WPT_GROUP_NAME, "name");
            PointsGroup category = new PointsGroup(name != null ? name : DEFAULT_WPT_GROUP_NAME);
            category.color = GPXUtilities.parseColor(parser.getAttributeValue(DEFAULT_WPT_GROUP_NAME, GPXUtilities.COLOR_NAME_EXTENSION), 0);
            category.iconName = parser.getAttributeValue(DEFAULT_WPT_GROUP_NAME, GPXUtilities.ICON_NAME_EXTENSION);
            category.backgroundType = parser.getAttributeValue(DEFAULT_WPT_GROUP_NAME, GPXUtilities.BACKGROUND_TYPE_EXTENSION);
            category.hidden = Boolean.valueOf(parser.getAttributeValue(DEFAULT_WPT_GROUP_NAME, GPXUtilities.HIDDEN_EXTENSION));
            return category;
        }
    }

    public static interface GPXExtensionsReader {
        public boolean readExtensions(GPXFile var1, XmlPullParser var2) throws IOException, XmlPullParserException;
    }

    public static class RouteType {
        public String tag;
        public String value;

        public static RouteType fromStringBundle(StringBundle bundle) {
            RouteType t = new RouteType();
            t.tag = bundle.getString("t", null);
            t.value = bundle.getString("v", null);
            return t;
        }

        public StringBundle toStringBundle() {
            StringBundle bundle = new StringBundle();
            bundle.putString("t", this.tag);
            bundle.putString("v", this.value);
            return bundle;
        }
    }

    public static class GPXFileResult {
        public List<List<Location>> locations = new ArrayList<List<Location>>();
        public List<WptPt> wayPoints = new ArrayList<WptPt>();
        public boolean cloudMadeFile;
        public String error;

        public Location findFistLocation() {
            for (List<Location> l : this.locations) {
                for (Location ls : l) {
                    if (ls == null) continue;
                    return ls;
                }
            }
            return null;
        }
    }
}

