/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.osmand.Location;
import net.osmand.PlatformUtil;
import net.osmand.data.LatLon;
import net.osmand.gpx.ElevationApproximator;
import net.osmand.gpx.ElevationDiffsCalculator;
import net.osmand.gpx.GPXUtilities;
import net.osmand.gpx.GpxParameter;
import net.osmand.gpx.PointAttributes;
import net.osmand.gpx.SplitSegment;
import net.osmand.router.RouteColorize;
import net.osmand.util.Algorithms;
import net.osmand.util.CollectionUtils;
import org.apache.commons.logging.Log;

@Deprecated
public class GPXTrackAnalysis {
    public static final Log LOG = PlatformUtil.getLog(GPXTrackAnalysis.class);
    public static final int ANALYSIS_VERSION = 1;
    public String name;
    public float totalDistanceWithoutGaps = 0.0f;
    public long timeSpanWithoutGaps = 0L;
    public long expectedRouteDuration = 0L;
    public long timeMovingWithoutGaps = 0L;
    public float totalDistanceMovingWithoutGaps = 0.0f;
    private final Map<GpxParameter, Object> parameters = new HashMap<GpxParameter, Object>();
    public double minHdop = Double.NaN;
    public double maxHdop = Double.NaN;
    public double metricEnd;
    public double secondaryMetricEnd;
    public GPXUtilities.WptPt locationStart;
    public GPXUtilities.WptPt locationEnd;
    public double left = 0.0;
    public double right = 0.0;
    public double top = 0.0;
    public double bottom = 0.0;
    public List<PointAttributes> pointAttributes = new ArrayList<PointAttributes>();
    public Set<String> availableAttributes = new HashSet<String>();
    public boolean hasSpeedInTrack = false;

    public Object getGpxParameter(GpxParameter parameter) {
        Object value = parameter.getDefaultValue();
        if (this.parameters.containsKey((Object)parameter)) {
            value = this.parameters.get((Object)parameter);
        }
        return value;
    }

    public void setGpxParameter(GpxParameter parameter, Object value) {
        this.parameters.put(parameter, value);
    }

    public void setStartTime(long startTime) {
        this.setGpxParameter(GpxParameter.START_TIME, startTime);
    }

    public long getStartTime() {
        Object startTime = this.getGpxParameter(GpxParameter.START_TIME);
        return (Long)startTime;
    }

    public void setEndTime(long endTime) {
        this.setGpxParameter(GpxParameter.END_TIME, endTime);
    }

    public long getEndTime() {
        Object endTime = this.getGpxParameter(GpxParameter.END_TIME);
        return (Long)endTime;
    }

    public void setTimeSpan(long timeSpan) {
        this.setGpxParameter(GpxParameter.TIME_SPAN, timeSpan);
    }

    public long getTimeSpan() {
        Object timeSpan = this.getGpxParameter(GpxParameter.TIME_SPAN);
        return (Long)timeSpan;
    }

    public long getTimeMoving() {
        Object timeMoving = this.getGpxParameter(GpxParameter.TIME_MOVING);
        return (Long)timeMoving;
    }

    public void setTimeMoving(long timeMoving) {
        this.setGpxParameter(GpxParameter.TIME_MOVING, timeMoving);
    }

    public void setMaxElevation(double maxElevation) {
        this.setGpxParameter(GpxParameter.MAX_ELEVATION, maxElevation);
    }

    public double getMaxElevation() {
        Object maxElevation = this.getGpxParameter(GpxParameter.MAX_ELEVATION);
        return (Double)maxElevation;
    }

    public void setDiffElevationUp(double diffElevationUp) {
        this.setGpxParameter(GpxParameter.DIFF_ELEVATION_UP, diffElevationUp);
    }

    public double getDiffElevationUp() {
        Object diffElevationUp = this.getGpxParameter(GpxParameter.DIFF_ELEVATION_UP);
        return (Double)diffElevationUp;
    }

    public void setDiffElevationDown(double diffElevationDown) {
        this.setGpxParameter(GpxParameter.DIFF_ELEVATION_DOWN, diffElevationDown);
    }

    public double getDiffElevationDown() {
        Object diffElevationDown = this.getGpxParameter(GpxParameter.DIFF_ELEVATION_DOWN);
        return (Double)diffElevationDown;
    }

    public void setMinElevation(double minElevation) {
        this.setGpxParameter(GpxParameter.MIN_ELEVATION, minElevation);
    }

    public double getMinElevation() {
        Object minElevation = this.getGpxParameter(GpxParameter.MIN_ELEVATION);
        return (Double)minElevation;
    }

    public void setAvgElevation(double avgElevation) {
        this.setGpxParameter(GpxParameter.AVG_ELEVATION, avgElevation);
    }

    public double getAvgElevation() {
        return (Double)this.getGpxParameter(GpxParameter.AVG_ELEVATION);
    }

    public void setAvgSpeed(float avgSpeed) {
        this.setGpxParameter(GpxParameter.AVG_SPEED, avgSpeed);
    }

    public float getAvgSpeed() {
        Object avgSpeed = this.getGpxParameter(GpxParameter.AVG_SPEED);
        return ((Double)avgSpeed).floatValue();
    }

    public void setMinSpeed(float minSpeed) {
        this.setGpxParameter(GpxParameter.MIN_SPEED, minSpeed);
    }

    public float getMinSpeed() {
        Object minSpeed = this.getGpxParameter(GpxParameter.MIN_SPEED);
        return ((Double)minSpeed).floatValue();
    }

    public void setMaxSpeed(float maxSpeed) {
        this.setGpxParameter(GpxParameter.MAX_SPEED, maxSpeed);
    }

    public float getMaxSpeed() {
        Object maxSpeed = this.getGpxParameter(GpxParameter.MAX_SPEED);
        return ((Double)maxSpeed).floatValue();
    }

    public void setMaxSensorHr(int maxSensorHr) {
        this.setGpxParameter(GpxParameter.MAX_SENSOR_HEART_RATE, maxSensorHr);
    }

    public int getMaxSensorHr() {
        Object maxSensorHr = this.getGpxParameter(GpxParameter.MAX_SENSOR_HEART_RATE);
        return (Integer)maxSensorHr;
    }

    public void setPoints(int points) {
        this.setGpxParameter(GpxParameter.POINTS, points);
    }

    public int getPoints() {
        Object points = this.getGpxParameter(GpxParameter.POINTS);
        return (Integer)points;
    }

    public void setWptPoints(int wptPoints) {
        this.setGpxParameter(GpxParameter.WPT_POINTS, wptPoints);
    }

    public int getWptPoints() {
        Object wptPoints = this.getGpxParameter(GpxParameter.WPT_POINTS);
        return (Integer)wptPoints;
    }

    public void setMaxSensorTemperature(int maxSensorTemperature) {
        this.setGpxParameter(GpxParameter.MAX_SENSOR_TEMPERATURE, maxSensorTemperature);
    }

    public int getMaxSensorPower() {
        Object maxSensorPower = this.getGpxParameter(GpxParameter.MAX_SENSOR_POWER);
        return (Integer)maxSensorPower;
    }

    public void setMaxSensorPower(int maxSensorPower) {
        this.setGpxParameter(GpxParameter.MAX_SENSOR_POWER, maxSensorPower);
    }

    public int getTotalTracks() {
        Object totalTracks = this.getGpxParameter(GpxParameter.TOTAL_TRACKS);
        return (Integer)totalTracks;
    }

    public void setTotalTracks(int totalTracks) {
        this.setGpxParameter(GpxParameter.TOTAL_TRACKS, totalTracks);
    }

    public int getMaxSensorTemperature() {
        Object maxSensorTemperature = this.getGpxParameter(GpxParameter.MAX_SENSOR_TEMPERATURE);
        return (Integer)maxSensorTemperature;
    }

    public void setMaxSensorSpeed(float maxSensorSpeed) {
        this.setGpxParameter(GpxParameter.MAX_SENSOR_SPEED, maxSensorSpeed);
    }

    public float getMaxSensorSpeed() {
        Object maxSensorSpeed = this.getGpxParameter(GpxParameter.MAX_SENSOR_SPEED);
        return ((Double)maxSensorSpeed).floatValue();
    }

    public void setMaxSensorCadence(float maxSensorCadence) {
        this.setGpxParameter(GpxParameter.MAX_SENSOR_CADENCE, maxSensorCadence);
    }

    public float getMaxSensorCadence() {
        Object maxSensorCadence = this.getGpxParameter(GpxParameter.MAX_SENSOR_CADENCE);
        return ((Double)maxSensorCadence).floatValue();
    }

    public void setAvgSensorSpeed(float avgSensorSpeed) {
        this.setGpxParameter(GpxParameter.AVG_SENSOR_SPEED, avgSensorSpeed);
    }

    public float getAvgSensorSpeed() {
        Object avgSensorSpeed = this.getGpxParameter(GpxParameter.AVG_SENSOR_SPEED);
        return ((Double)avgSensorSpeed).floatValue();
    }

    public void setAvgSensorCadence(float avgSensorCadence) {
        this.setGpxParameter(GpxParameter.AVG_SENSOR_CADENCE, avgSensorCadence);
    }

    public float getAvgSensorCadence() {
        Object avgSensorCadence = this.getGpxParameter(GpxParameter.AVG_SENSOR_CADENCE);
        return ((Double)avgSensorCadence).floatValue();
    }

    public void setAvgSensorHr(float avgSensorHr) {
        this.setGpxParameter(GpxParameter.AVG_SENSOR_HEART_RATE, avgSensorHr);
    }

    public float getAvgSensorHr() {
        Object avgSensorHr = this.getGpxParameter(GpxParameter.AVG_SENSOR_HEART_RATE);
        return ((Double)avgSensorHr).floatValue();
    }

    public void setAvgSensorPower(float avgSensorPower) {
        this.setGpxParameter(GpxParameter.AVG_SENSOR_POWER, avgSensorPower);
    }

    public float getAvgSensorPower() {
        Object avgSensorPower = this.getGpxParameter(GpxParameter.AVG_SENSOR_POWER);
        return ((Double)avgSensorPower).floatValue();
    }

    public void setAvgSensorTemperature(float avgSensorTemperature) {
        this.setGpxParameter(GpxParameter.AVG_SENSOR_TEMPERATURE, avgSensorTemperature);
    }

    public float getAvgSensorTemperature() {
        Object avgSensorTemperature = this.getGpxParameter(GpxParameter.AVG_SENSOR_TEMPERATURE);
        return ((Double)avgSensorTemperature).floatValue();
    }

    public void setTotalDistanceMoving(float totalDistanceMoving) {
        this.setGpxParameter(GpxParameter.TOTAL_DISTANCE_MOVING, totalDistanceMoving);
    }

    public float getTotalDistanceMoving() {
        Object totalDistanceMoving = this.getGpxParameter(GpxParameter.TOTAL_DISTANCE_MOVING);
        return ((Double)totalDistanceMoving).floatValue();
    }

    public void setTotalDistance(float totalDistance) {
        this.setGpxParameter(GpxParameter.TOTAL_DISTANCE, totalDistance);
    }

    public float getTotalDistance() {
        Object totalDistance = this.getGpxParameter(GpxParameter.TOTAL_DISTANCE);
        return ((Double)totalDistance).floatValue();
    }

    public boolean isTimeSpecified() {
        return this.getStartTime() != Long.MAX_VALUE && this.getStartTime() != 0L;
    }

    public boolean isTimeMoving() {
        return this.getTimeMoving() != 0L;
    }

    public boolean isElevationSpecified() {
        return this.getMaxElevation() != -100.0;
    }

    public boolean hasSpeedInTrack() {
        return this.hasSpeedInTrack;
    }

    public boolean isBoundsCalculated() {
        return this.left != 0.0 && this.right != 0.0 && this.top != 0.0 && this.bottom != 0.0;
    }

    public boolean isSpeedSpecified() {
        return this.getAvgSpeed() > 0.0f;
    }

    public boolean isHdopSpecified() {
        return this.minHdop > 0.0;
    }

    public boolean isColorizationTypeAvailable(RouteColorize.ColorizationType colorizationType) {
        if (colorizationType == RouteColorize.ColorizationType.SPEED) {
            return this.isSpeedSpecified();
        }
        if (colorizationType == RouteColorize.ColorizationType.ELEVATION || colorizationType == RouteColorize.ColorizationType.SLOPE) {
            return this.isElevationSpecified();
        }
        return true;
    }

    public void setLatLonStart(double latitude, double longitude) {
        this.setGpxParameter(GpxParameter.START_LAT, latitude);
        this.setGpxParameter(GpxParameter.START_LON, longitude);
    }

    public LatLon getLatLonStart() {
        Object lat = this.getGpxParameter(GpxParameter.START_LAT);
        Object lon = this.getGpxParameter(GpxParameter.START_LON);
        if (lat != null && lon != null) {
            return new LatLon((Double)lat, (Double)lon);
        }
        return null;
    }

    public Object getLatStart() {
        return this.getGpxParameter(GpxParameter.START_LAT);
    }

    public Object getLonStart() {
        return this.getGpxParameter(GpxParameter.START_LON);
    }

    public boolean hasSpeedData() {
        return this.hasData("speed");
    }

    public boolean hasElevationData() {
        return this.hasData("ele");
    }

    public boolean hasData(String tag) {
        if (Objects.equals(tag, "temp_sensor")) {
            return CollectionUtils.containsAny(this.availableAttributes, "gpxtpx:wtemp", "gpxtpx:atemp");
        }
        return this.availableAttributes.contains(tag);
    }

    public void setHasData(String tag, boolean hasData) {
        if (hasData) {
            this.availableAttributes.add(tag);
        } else {
            this.availableAttributes.remove(tag);
        }
    }

    public void setWptCategoryNames(String wptCategoryNames) {
        this.setGpxParameter(GpxParameter.WPT_CATEGORY_NAMES, wptCategoryNames);
    }

    public void setWptCategoryNames(Set<String> wptCategoryNames) {
        this.setGpxParameter(GpxParameter.WPT_CATEGORY_NAMES, wptCategoryNames == null ? null : Algorithms.encodeCollection(wptCategoryNames));
    }

    public String getWptCategoryNames() {
        return (String)this.getGpxParameter(GpxParameter.WPT_CATEGORY_NAMES);
    }

    public Set<String> getWptCategoryNamesSet() {
        String wptCategoryNames = this.getWptCategoryNames();
        return wptCategoryNames == null ? null : Algorithms.decodeStringSet(wptCategoryNames);
    }

    public static GPXTrackAnalysis prepareInformation(long fileTimeStamp, TrackPointsAnalyser pointsAnalyzer, GPXUtilities.TrkSegment segment) {
        return new GPXTrackAnalysis().prepareInformation(fileTimeStamp, pointsAnalyzer, new SplitSegment(segment));
    }

    public GPXTrackAnalysis prepareInformation(long fileTimeStamp, TrackPointsAnalyser pointsAnalyser, SplitSegment ... splitSegments) {
        float[] calculations = new float[1];
        long startTimeOfSingleSegment = 0L;
        long endTimeOfSingleSegment = 0L;
        float distanceOfSingleSegment = 0.0f;
        float distanceMovingOfSingleSegment = 0.0f;
        long timeMovingOfSingleSegment = 0L;
        float totalElevation = 0.0f;
        int elevationPoints = 0;
        int speedCount = 0;
        long timeDiffMillis = 0L;
        int timeDiff = 0;
        double totalSpeedSum = 0.0;
        int sensorSpeedCount = 0;
        double totalSensorSpeedSum = 0.0;
        int sensorHrCount = 0;
        double totalSensorHrSum = 0.0;
        int sensorPowerCount = 0;
        double totalSensorPowerSum = 0.0;
        int sensorTemperatureCount = 0;
        double totalSensorTemperatureSum = 0.0;
        int sensorCadenceCount = 0;
        double totalSensorCadenceSum = 0.0;
        this.setPoints(0);
        this.pointAttributes = new ArrayList<PointAttributes>();
        this.availableAttributes = new HashSet<String>();
        for (SplitSegment s : splitSegments) {
            int numberOfPoints = s.getNumberOfPoints();
            float segmentDistance = 0.0f;
            this.metricEnd += s.metricEnd;
            this.secondaryMetricEnd += s.secondaryMetricEnd;
            this.setPoints(this.getPoints() + numberOfPoints);
            this.expectedRouteDuration += this.getExpectedRouteSegmentDuration(s);
            for (int j = 0; j < numberOfPoints; ++j) {
                float temperature;
                boolean isNaN;
                float elevation;
                long time;
                GPXUtilities.WptPt point = s.get(j);
                if (j == 0 && this.locationStart == null) {
                    this.locationStart = point;
                    this.setLatLonStart(point.lat, point.lon);
                }
                if (j == numberOfPoints - 1) {
                    this.locationEnd = point;
                }
                if ((time = point.time) != 0L) {
                    if (s.metricEnd == 0.0 && s.segment.generalSegment) {
                        if (point.firstPoint) {
                            startTimeOfSingleSegment = time;
                        } else if (point.lastPoint) {
                            endTimeOfSingleSegment = time;
                        }
                        if (startTimeOfSingleSegment != 0L && endTimeOfSingleSegment != 0L) {
                            this.timeSpanWithoutGaps += endTimeOfSingleSegment - startTimeOfSingleSegment;
                            startTimeOfSingleSegment = 0L;
                            endTimeOfSingleSegment = 0L;
                        }
                    }
                    this.setStartTime(Math.min(this.getStartTime(), time));
                    this.setEndTime(Math.max(this.getEndTime(), time));
                }
                this.updateBounds(point);
                float speed = (float)point.speed;
                if (speed > 0.0f) {
                    this.hasSpeedInTrack = true;
                }
                this.updateHdop(point);
                if (j > 0) {
                    boolean timeSpecified;
                    GPXUtilities.WptPt prev = s.get(j - 1);
                    Location.distanceBetween(prev.lat, prev.lon, point.lat, point.lon, calculations);
                    this.setTotalDistance(this.getTotalDistance() + calculations[0]);
                    point.distance = segmentDistance += calculations[0];
                    timeDiffMillis = Math.max(0L, point.time - prev.time);
                    timeDiff = (int)(timeDiffMillis / 1000L);
                    if (!this.hasSpeedInTrack && speed == 0.0f && timeDiff > 0) {
                        speed = calculations[0] / (float)timeDiff;
                    }
                    boolean bl = timeSpecified = point.time != 0L && prev.time != 0L;
                    if (speed > 0.0f && timeSpecified && calculations[0] > (float)timeDiffMillis / 10000.0f) {
                        this.setTimeMoving(this.getTimeMoving() + timeDiffMillis);
                        this.setTotalDistanceMoving(this.getTotalDistanceMoving() + calculations[0]);
                        if (s.segment.generalSegment && !point.firstPoint) {
                            timeMovingOfSingleSegment += timeDiffMillis;
                            distanceMovingOfSingleSegment += calculations[0];
                        }
                    }
                }
                this.setMinSpeed(Math.min(speed, this.getMinSpeed()));
                if (speed > 0.0f && !Float.isInfinite(speed)) {
                    totalSpeedSum += (double)speed;
                    this.setMaxSpeed(Math.max(speed, this.getMaxSpeed()));
                    ++speedCount;
                }
                float f = elevation = (isNaN = Double.isNaN(point.ele)) ? Float.NaN : (float)point.ele;
                if (!isNaN) {
                    totalElevation = (float)((double)totalElevation + point.ele);
                    ++elevationPoints;
                    this.setMinElevation(Math.min(point.ele, this.getMinElevation()));
                    this.setMaxElevation(Math.max(point.ele, this.getMaxElevation()));
                }
                boolean firstPoint = false;
                boolean lastPoint = false;
                if (s.segment.generalSegment) {
                    distanceOfSingleSegment += calculations[0];
                    if (point.firstPoint) {
                        firstPoint = j > 0;
                        distanceOfSingleSegment = 0.0f;
                        timeMovingOfSingleSegment = 0L;
                        distanceMovingOfSingleSegment = 0.0f;
                    }
                    if (point.lastPoint) {
                        lastPoint = j < numberOfPoints - 1;
                        this.totalDistanceWithoutGaps += distanceOfSingleSegment;
                        this.timeMovingWithoutGaps += timeMovingOfSingleSegment;
                        this.totalDistanceMovingWithoutGaps += distanceMovingOfSingleSegment;
                    }
                }
                float distance = j > 0 ? calculations[0] : 0.0f;
                PointAttributes attribute = new PointAttributes(distance, timeDiff, firstPoint, lastPoint);
                attribute.speed = speed;
                attribute.elevation = elevation;
                this.addWptAttribute(point, attribute, pointsAnalyser);
                if (attribute.sensorSpeed > 0.0f && !Float.isInfinite(attribute.sensorSpeed)) {
                    this.setMaxSensorSpeed(Math.max(attribute.sensorSpeed, this.getMaxSensorSpeed()));
                    ++sensorSpeedCount;
                    totalSensorSpeedSum += (double)attribute.sensorSpeed;
                }
                if (attribute.bikeCadence > 0.0f) {
                    this.setMaxSensorCadence(Math.max(attribute.bikeCadence, this.getMaxSensorCadence()));
                    ++sensorCadenceCount;
                    totalSensorCadenceSum += (double)attribute.bikeCadence;
                }
                if (attribute.heartRate > 0.0f) {
                    this.setMaxSensorHr(Math.max((int)attribute.heartRate, this.getMaxSensorHr()));
                    ++sensorHrCount;
                    totalSensorHrSum += (double)attribute.heartRate;
                }
                if ((temperature = attribute.getTemperature()) > 0.0f) {
                    this.setMaxSensorTemperature(Math.max((int)temperature, this.getMaxSensorTemperature()));
                    ++sensorTemperatureCount;
                    totalSensorTemperatureSum += (double)temperature;
                }
                if (!(attribute.bikePower > 0.0f)) continue;
                this.setMaxSensorPower(Math.max((int)attribute.bikePower, this.getMaxSensorPower()));
                ++sensorPowerCount;
                totalSensorPowerSum += (double)attribute.bikePower;
            }
            this.processElevationDiff(s);
        }
        this.checkUnspecifiedValues(fileTimeStamp);
        this.processAverageValues(totalElevation, elevationPoints, totalSpeedSum, speedCount);
        this.setAvgSensorSpeed(this.processAverageValue(totalSensorSpeedSum, sensorSpeedCount).floatValue());
        this.setAvgSensorCadence(this.processAverageValue(totalSensorCadenceSum, sensorCadenceCount).floatValue());
        this.setAvgSensorHr(this.processAverageValue(totalSensorHrSum, sensorHrCount).floatValue());
        this.setAvgSensorPower(this.processAverageValue(totalSensorPowerSum, sensorPowerCount).floatValue());
        this.setAvgSensorTemperature(this.processAverageValue(totalSensorTemperatureSum, sensorTemperatureCount).floatValue());
        return this;
    }

    private void addWptAttribute(GPXUtilities.WptPt point, PointAttributes attribute, TrackPointsAnalyser pointsAnalyser) {
        if (!this.hasSpeedData() && attribute.speed > 0.0f && this.getTotalDistance() > 0.0f) {
            this.setHasData("speed", true);
        }
        if (!this.hasElevationData() && !Float.isNaN(attribute.elevation) && this.getTotalDistance() > 0.0f) {
            this.setHasData("ele", true);
        }
        if (pointsAnalyser != null) {
            pointsAnalyser.onAnalysePoint(this, point, attribute);
        }
        this.pointAttributes.add(attribute);
    }

    private void updateBounds(GPXUtilities.WptPt point) {
        if (this.left == 0.0 && this.right == 0.0) {
            this.left = point.getLongitude();
            this.right = point.getLongitude();
            this.top = point.getLatitude();
            this.bottom = point.getLatitude();
        } else {
            this.left = Math.min(this.left, point.getLongitude());
            this.right = Math.max(this.right, point.getLongitude());
            this.top = Math.max(this.top, point.getLatitude());
            this.bottom = Math.min(this.bottom, point.getLatitude());
        }
    }

    private void updateHdop(GPXUtilities.WptPt point) {
        double hdop = point.hdop;
        if (hdop > 0.0) {
            if (Double.isNaN(this.minHdop) || hdop < this.minHdop) {
                this.minHdop = hdop;
            }
            if (Double.isNaN(this.maxHdop) || hdop > this.maxHdop) {
                this.maxHdop = hdop;
            }
        }
    }

    private void checkUnspecifiedValues(long fileTimeStamp) {
        if (this.getTotalDistance() < 0.0f) {
            this.availableAttributes.clear();
        }
        if (!this.isTimeSpecified()) {
            this.setStartTime(fileTimeStamp);
            this.setEndTime(fileTimeStamp);
        }
        if (this.getTimeSpan() == 0L) {
            this.setTimeSpan(this.getEndTime() - this.getStartTime());
        }
    }

    public long getDurationInMs() {
        return this.getTimeSpan() > 0L ? this.getTimeSpan() : this.expectedRouteDuration;
    }

    public int getDurationInSeconds() {
        return (int)((float)this.getDurationInMs() / 1000.0f + 0.5f);
    }

    private long getExpectedRouteSegmentDuration(SplitSegment segment) {
        List<GPXUtilities.RouteSegment> routeSegments = segment.segment.routeSegments;
        if (routeSegments != null && !segment.segment.generalSegment) {
            long result = 0L;
            for (GPXUtilities.RouteSegment routeSegment : routeSegments) {
                result += (long)(1000.0f * Algorithms.parseFloatSilently(routeSegment.segmentTime, 0.0f));
            }
            return result;
        }
        return 0L;
    }

    private void processAverageValues(float totalElevation, int elevationPoints, double totalSpeedSum, int speedCount) {
        if (elevationPoints > 0) {
            this.setAvgElevation(totalElevation / (float)elevationPoints);
        }
        if (speedCount > 0) {
            if (this.getTimeMoving() > 0L) {
                this.setAvgSpeed(this.getTotalDistanceMoving() / (float)this.getTimeMoving() * 1000.0f);
            } else {
                this.setAvgSpeed((float)totalSpeedSum / (float)speedCount);
            }
        } else {
            this.setAvgSpeed(-1.0f);
        }
    }

    private Float processAverageValue(Number totalSum, int valuesCount) {
        if (valuesCount > 0) {
            return Float.valueOf((float)((Double)totalSum / (double)valuesCount));
        }
        return Float.valueOf(-1.0f);
    }

    private void processElevationDiff(SplitSegment segment) {
        ElevationApproximator approximator = this.getElevationApproximator(segment);
        approximator.approximate();
        double[] distances = approximator.getDistances();
        double[] elevations = approximator.getElevations();
        if (distances != null && elevations != null) {
            ElevationDiffsCalculator elevationDiffsCalc = this.getElevationDiffsCalculator(distances, elevations);
            elevationDiffsCalc.calculateElevationDiffs();
            this.setDiffElevationUp(this.getDiffElevationUp() + elevationDiffsCalc.getDiffElevationUp());
            this.setDiffElevationDown(this.getDiffElevationDown() + elevationDiffsCalc.getDiffElevationDown());
        }
    }

    private ElevationApproximator getElevationApproximator(final SplitSegment segment) {
        return new ElevationApproximator(){

            @Override
            public double getPointLatitude(int index) {
                return segment.get((int)index).lat;
            }

            @Override
            public double getPointLongitude(int index) {
                return segment.get((int)index).lon;
            }

            @Override
            public double getPointElevation(int index) {
                return segment.get((int)index).ele;
            }

            @Override
            public int getPointsCount() {
                return segment.getNumberOfPoints();
            }
        };
    }

    private ElevationDiffsCalculator getElevationDiffsCalculator(final double[] distances, final double[] elevations) {
        return new ElevationDiffsCalculator(){

            @Override
            public double getPointDistance(int index) {
                return distances[index];
            }

            @Override
            public double getPointElevation(int index) {
                return elevations[index];
            }

            @Override
            public int getPointsCount() {
                return distances.length;
            }
        };
    }

    public static interface TrackPointsAnalyser {
        public void onAnalysePoint(GPXTrackAnalysis var1, GPXUtilities.WptPt var2, PointAttributes var3);
    }
}

