/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import gnu.trove.map.hash.TLongObjectHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.osmand.data.Multipolygon;
import net.osmand.data.Ring;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Way;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class MultipolygonBuilder {
    List<Way> outerWays = new ArrayList<Way>();
    List<Way> innerWays = new ArrayList<Way>();
    long id = -1L;
    private static long initialValue = -1000L;
    private static final long randomInterval = 5000L;

    public MultipolygonBuilder(List<Way> outers, List<Way> inners) {
        this();
        this.outerWays.addAll(outers);
        this.innerWays.addAll(inners);
    }

    public MultipolygonBuilder() {
    }

    public void setId(long newId) {
        this.id = newId;
    }

    public long getId() {
        return this.id;
    }

    public MultipolygonBuilder addInnerWay(Way w) {
        this.innerWays.add(w);
        return this;
    }

    public List<Way> getOuterWays() {
        return this.outerWays;
    }

    public List<Way> getInnerWays() {
        return this.innerWays;
    }

    public MultipolygonBuilder addOuterWay(Way w) {
        this.outerWays.add(w);
        return this;
    }

    public List<Multipolygon> splitPerOuterRing(Log log) {
        TreeSet<Ring> inners = new TreeSet<Ring>(this.combineToRings(this.innerWays));
        ArrayList<Ring> outers = this.combineToRings(this.outerWays);
        Collections.sort(outers, new Comparator<Ring>(){

            @Override
            public int compare(Ring o1, Ring o2) {
                return -Integer.compare(o1.getBorder().size(), o2.getBorder().size());
            }
        });
        ArrayList<Multipolygon> multipolygons = new ArrayList<Multipolygon>();
        for (Ring outer : outers) {
            ArrayList<Ring> innersInsideOuter = new ArrayList<Ring>();
            Iterator innerIt = inners.iterator();
            while (innerIt.hasNext()) {
                Ring inner = (Ring)innerIt.next();
                if (!inner.isIn(outer)) continue;
                innersInsideOuter.add(inner);
                innerIt.remove();
            }
            multipolygons.add(new Multipolygon(outer, innersInsideOuter, this.id, true));
        }
        if (inners.size() != 0 && log != null) {
            log.warn((Object)("Multipolygon " + this.getId() + " has a mismatch in outer and inner rings"));
        }
        return multipolygons;
    }

    public Multipolygon build() {
        return new Multipolygon(this.combineToRings(this.outerWays), this.combineToRings(this.innerWays), this.id);
    }

    public ArrayList<Ring> combineToRings(List<Way> ways) {
        TLongObjectHashMap multilineStartPoint = new TLongObjectHashMap();
        TLongObjectHashMap multilineEndPoint = new TLongObjectHashMap();
        for (Way way : ways) {
            Way newWay;
            if (way.getNodeIds().size() < 2) continue;
            Way changedWay = way;
            do {
                if ((newWay = this.merge((TLongObjectHashMap<List<Way>>)multilineStartPoint, this.getLastId(changedWay), changedWay, (TLongObjectHashMap<List<Way>>)multilineEndPoint, this.getFirstId(changedWay))) == null) {
                    newWay = this.merge((TLongObjectHashMap<List<Way>>)multilineEndPoint, this.getFirstId(changedWay), changedWay, (TLongObjectHashMap<List<Way>>)multilineStartPoint, this.getLastId(changedWay));
                }
                if (newWay == null) {
                    newWay = this.merge((TLongObjectHashMap<List<Way>>)multilineStartPoint, this.getFirstId(changedWay), changedWay, (TLongObjectHashMap<List<Way>>)multilineEndPoint, this.getLastId(changedWay));
                }
                if (newWay == null) {
                    newWay = this.merge((TLongObjectHashMap<List<Way>>)multilineEndPoint, this.getLastId(changedWay), changedWay, (TLongObjectHashMap<List<Way>>)multilineStartPoint, this.getFirstId(changedWay));
                }
                if (newWay == null) continue;
                changedWay = newWay;
            } while (newWay != null);
            this.addToMap((TLongObjectHashMap<List<Way>>)multilineStartPoint, this.getFirstId(changedWay), changedWay);
            this.addToMap((TLongObjectHashMap<List<Way>>)multilineEndPoint, this.getLastId(changedWay), changedWay);
        }
        ArrayList multiLines = new ArrayList();
        for (List lst : multilineStartPoint.valueCollection()) {
            multiLines.addAll(lst);
        }
        ArrayList<Ring> arrayList = new ArrayList<Ring>();
        for (Way multiLine : multiLines) {
            Ring r = new Ring(multiLine);
            arrayList.add(r);
        }
        return arrayList;
    }

    private Way merge(TLongObjectHashMap<List<Way>> endMap, long stNodeId, Way changedWay, TLongObjectHashMap<List<Way>> startMap, long endNodeId) {
        List lst = (List)endMap.get(stNodeId);
        if (lst != null && lst.size() > 0) {
            boolean removed2;
            Way candToMerge = (Way)lst.get(0);
            Way newWay = this.combineTwoWaysIfHasPoints(candToMerge, changedWay);
            List otherLst = (List)startMap.get(this.getLastId(candToMerge) == stNodeId ? this.getFirstId(candToMerge) : this.getLastId(candToMerge));
            boolean removed1 = lst.remove(candToMerge);
            boolean bl = removed2 = otherLst != null && otherLst.remove(candToMerge);
            if (newWay == null || !removed1 || !removed2) {
                throw new UnsupportedOperationException("Can't merge way: " + changedWay.getId() + " " + stNodeId + " -> " + endNodeId);
            }
            return newWay;
        }
        return null;
    }

    private void addToMap(TLongObjectHashMap<List<Way>> mp, long id, Way changedWay) {
        ArrayList<Way> lst = (ArrayList<Way>)mp.get(id);
        if (lst == null) {
            lst = new ArrayList<Way>();
            mp.put(id, lst);
        }
        lst.add(changedWay);
    }

    private long getId(Node n) {
        if (n == null) {
            return -MultipolygonBuilder.nextRandId();
        }
        long l = MapUtils.get31TileNumberY(n.getLatitude());
        l = l << 31 | (long)MapUtils.get31TileNumberX(n.getLongitude());
        return l;
    }

    private Way combineTwoWaysIfHasPoints(Way w1, Way w2) {
        boolean combine = true;
        boolean firstReverse = false;
        boolean secondReverse = false;
        long w1f = this.getFirstId(w1);
        long w2f = this.getFirstId(w2);
        long w1l = this.getLastId(w1);
        long w2l = this.getLastId(w2);
        if (w1f == w2f) {
            firstReverse = true;
            secondReverse = false;
        } else if (w1l == w2f) {
            firstReverse = false;
            secondReverse = false;
        } else if (w1l == w2l) {
            firstReverse = false;
            secondReverse = true;
        } else if (w1f == w2l) {
            firstReverse = true;
            secondReverse = true;
        } else {
            combine = false;
        }
        if (combine) {
            Way newWay = new Way(MultipolygonBuilder.nextRandId());
            boolean nodePresent = w1.getNodes() != null || w1.getNodes().size() != 0;
            int w1size = nodePresent ? w1.getNodes().size() : w1.getNodeIds().size();
            for (int i = 0; i < w1size; ++i) {
                int ind;
                int n = ind = firstReverse ? w1size - 1 - i : i;
                if (nodePresent) {
                    newWay.addNode(w1.getNodes().get(ind));
                    continue;
                }
                newWay.addNode(w1.getNodeIds().get(ind));
            }
            int w2size = nodePresent ? w2.getNodes().size() : w2.getNodeIds().size();
            for (int i = 1; i < w2size; ++i) {
                int ind;
                int n = ind = secondReverse ? w2size - 1 - i : i;
                if (nodePresent) {
                    newWay.addNode(w2.getNodes().get(ind));
                    continue;
                }
                newWay.addNode(w2.getNodeIds().get(ind));
            }
            return newWay;
        }
        return null;
    }

    private long getLastId(Way w1) {
        return w1.getLastNodeId() > 0L ? w1.getLastNodeId() : this.getId(w1.getLastNode());
    }

    private long getFirstId(Way w1) {
        return w1.getFirstNodeId() > 0L ? w1.getFirstNodeId() : this.getId(w1.getFirstNode());
    }

    private static long nextRandId() {
        long val;
        initialValue = val = initialValue - Math.round(Math.random() * 5000.0);
        return val;
    }
}

