/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.data.Ring;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.util.Algorithms;

public class Multipolygon {
    private List<Ring> innerRings;
    private List<Ring> outerRings;
    private Map<Ring, Set<Ring>> containedInnerInOuter = new LinkedHashMap<Ring, Set<Ring>>();
    private float maxLat = -90.0f;
    private float minLat = 90.0f;
    private float maxLon = -180.0f;
    private float minLon = 180.0f;
    private long id;

    public Multipolygon(List<Ring> outer, List<Ring> inner, long id) {
        this.outerRings = outer;
        this.innerRings = inner;
        this.id = id;
        this.updateRings();
    }

    public Multipolygon(Ring outer, List<Ring> inner, long id, boolean checkedIsIn) {
        this.outerRings = new ArrayList<Ring>();
        this.outerRings.add(outer);
        this.innerRings = inner;
        this.id = id;
        this.updateRings(checkedIsIn);
    }

    public MultiPolygon toMultiPolygon() {
        GeometryFactory geometryFactory = new GeometryFactory();
        MultiPolygon emptyMultiPolygon = geometryFactory.createMultiPolygon(new Polygon[0]);
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Ring outerRing : this.outerRings) {
            if (!outerRing.isClosed()) {
                return emptyMultiPolygon;
            }
            ArrayList<LinearRing> innerLinearRings = new ArrayList<LinearRing>();
            Set<Ring> innerRings = this.containedInnerInOuter.get(outerRing);
            if (!Algorithms.isEmpty(innerRings)) {
                for (Ring innerRing : innerRings) {
                    if (!innerRing.isClosed()) {
                        return emptyMultiPolygon;
                    }
                    innerLinearRings.add(innerRing.toLinearRing());
                }
            }
            polygons.add(geometryFactory.createPolygon(outerRing.toLinearRing(), innerLinearRings.toArray(new LinearRing[0])));
        }
        return geometryFactory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    public long getId() {
        return this.id;
    }

    private void updateRings() {
        this.updateRings(false);
    }

    private void updateRings(boolean checkedIsIn) {
        this.maxLat = -90.0f;
        this.minLat = 90.0f;
        this.maxLon = -180.0f;
        this.minLon = 180.0f;
        for (Ring r : this.outerRings) {
            for (Node n : r.getBorder()) {
                this.maxLat = (float)Math.max((double)this.maxLat, n.getLatitude());
                this.minLat = (float)Math.min((double)this.minLat, n.getLatitude());
                this.maxLon = (float)Math.max((double)this.maxLon, n.getLongitude());
                this.minLon = (float)Math.min((double)this.minLon, n.getLongitude());
            }
        }
        Collections.sort(this.outerRings);
        for (Ring inner : this.innerRings) {
            HashSet<Ring> outContainingRings = new HashSet<Ring>();
            if (checkedIsIn && this.outerRings.size() == 1) {
                outContainingRings.add(this.outerRings.get(0));
            } else {
                for (Ring out : this.outerRings) {
                    if (!inner.isIn(out)) continue;
                    outContainingRings.add(out);
                }
            }
            this.containedInnerInOuter.put(inner, outContainingRings);
        }
        Collections.sort(this.innerRings);
    }

    public boolean containsPoint(double latitude, double longitude) {
        if ((double)this.maxLat + 0.3 < latitude || (double)this.minLat - 0.3 > latitude || (double)this.maxLon + 0.3 < longitude || (double)this.minLon - 0.3 > longitude) {
            return false;
        }
        Ring containedInOuter = null;
        for (Ring ring : this.outerRings) {
            if (!ring.containsPoint(latitude, longitude)) continue;
            containedInOuter = ring;
            break;
        }
        if (containedInOuter == null) {
            return false;
        }
        Ring containedInInner = null;
        for (Ring inner : this.innerRings) {
            if (!inner.containsPoint(latitude, longitude)) continue;
            containedInInner = inner;
            break;
        }
        if (containedInInner == null) {
            return true;
        }
        if (this.outerRings.size() == 1) {
            return false;
        }
        Set<Ring> set = this.containedInnerInOuter.get(containedInInner);
        if (set == null) {
            throw new IllegalStateException();
        }
        return !set.contains(containedInOuter);
    }

    public boolean containsPoint(LatLon point) {
        return this.containsPoint(point.getLatitude(), point.getLongitude());
    }

    public int countOuterPolygons() {
        return this.zeroSizeIfNull(this.outerRings);
    }

    private int zeroSizeIfNull(Collection<?> l) {
        return l != null ? l.size() : 0;
    }

    public LatLon getCenterPoint() {
        ArrayList<Node> points = new ArrayList<Node>();
        for (Ring w : this.outerRings) {
            points.addAll(w.getBorder());
        }
        if (points.isEmpty()) {
            for (Ring w : this.innerRings) {
                points.addAll(w.getBorder());
            }
        }
        return OsmMapUtils.getWeightCenterForNodes(points);
    }

    public void mergeWith(Multipolygon multipolygon) {
        this.innerRings.addAll(multipolygon.innerRings);
        this.outerRings.addAll(multipolygon.outerRings);
        this.updateRings();
    }

    public boolean hasOpenedPolygons() {
        return !this.areRingsComplete();
    }

    public boolean areRingsComplete() {
        List<Ring> l = this.outerRings;
        for (Ring r : l) {
            if (r.isClosed()) continue;
            return false;
        }
        l = this.innerRings;
        for (Ring r : l) {
            if (r.isClosed()) continue;
            return false;
        }
        return true;
    }

    public QuadRect getLatLonBbox() {
        if (this.minLat == 90.0f) {
            return new QuadRect();
        }
        return new QuadRect(this.minLon, this.maxLat, this.maxLon, this.minLat);
    }

    public List<Ring> getInnerRings() {
        return this.innerRings;
    }

    public List<Ring> getOuterRings() {
        return this.outerRings;
    }
}

