/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.Location;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiType;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.json.JSONObject;

public class Amenity
extends MapObject {
    public static final String WEBSITE = "website";
    public static final String PHONE = "phone";
    public static final String MOBILE = "mobile";
    public static final String DESCRIPTION = "description";
    public static final String ROUTE = "route";
    public static final String OPENING_HOURS = "opening_hours";
    public static final String SERVICE_TIMES = "service_times";
    public static final String COLLECTION_TIMES = "collection_times";
    public static final String CONTENT = "content";
    public static final String CUISINE = "cuisine";
    public static final String WIKIPEDIA = "wikipedia";
    public static final String WIKIDATA = "wikidata";
    public static final String WIKIMEDIA_COMMONS = "wikimedia_commons";
    public static final String MAPILLARY = "mapillary";
    public static final String DISH = "dish";
    public static final String REF = "ref";
    public static final String OSM_DELETE_VALUE = "delete";
    public static final String OSM_DELETE_TAG = "osmand_change";
    public static final String PRIVATE_VALUE = "private";
    public static final String ACCESS_PRIVATE_TAG = "access_private";
    public static final String IMAGE_TITLE = "image_title";
    public static final String IS_PART = "is_part";
    public static final String IS_PARENT_OF = "is_parent_of";
    public static final String IS_AGGR_PART = "is_aggr_part";
    public static final String CONTENT_JSON = "content_json";
    public static final String ROUTE_ID = "route_id";
    public static final String ROUTE_SOURCE = "route_source";
    public static final String ROUTE_NAME = "route_name";
    public static final String COLOR = "color";
    public static final String LANG_YES = "lang_yes";
    public static final String GPX_ICON = "gpx_icon";
    public static final String TYPE = "type";
    public static final String SUBTYPE = "subtype";
    public static final String NAME = "name";
    public static final String SEPARATOR = ";";
    public static final String ALT_NAME_WITH_LANG_PREFIX = "alt_name:";
    public static final String COLLAPSABLE_PREFIX = "collapsable_";
    public static final List<String> HIDING_EXTENSIONS_AMENITY_TAGS = Arrays.asList("phone", "website");
    private String subType;
    private PoiCategory type;
    private String openingHours;
    private Map<String, String> additionalInfo;
    private AmenityRoutePoint routePoint;
    private TIntArrayList y;
    private TIntArrayList x;
    private String mapIconName;
    private int order;
    private Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups;
    private String regionName;

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public Map<Integer, List<BinaryMapIndexReader.TagValuePair>> getTagGroups() {
        return this.tagGroups;
    }

    public void addTagGroup(int id, List<BinaryMapIndexReader.TagValuePair> tagValues) {
        if (this.tagGroups == null) {
            this.tagGroups = new HashMap<Integer, List<BinaryMapIndexReader.TagValuePair>>();
        }
        this.tagGroups.put(id, tagValues);
    }

    public void setTagGroups(Map<Integer, List<BinaryMapIndexReader.TagValuePair>> tagGroups) {
        this.tagGroups = tagGroups;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getMapIconName() {
        return this.mapIconName;
    }

    public void setMapIconName(String mapIconName) {
        this.mapIconName = mapIconName;
    }

    public PoiCategory getType() {
        return this.type;
    }

    public String getSubType() {
        return this.subType;
    }

    public void setType(PoiCategory type) {
        this.type = type;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getSubTypeStr() {
        PoiCategory pc = this.getType();
        String[] subtypes = this.getSubType().split(SEPARATOR);
        Object typeStr = "";
        for (String subType : subtypes) {
            PoiType pt = pc.getPoiTypeByKeyName(subType);
            if (pt == null) continue;
            typeStr = !((String)typeStr).isEmpty() ? (String)typeStr + ", " + pt.getTranslation().toLowerCase() : pt.getTranslation();
        }
        if (((String)typeStr).isEmpty()) {
            typeStr = this.getSubType();
            typeStr = Algorithms.capitalizeFirstLetterAndLowercase(((String)typeStr).replace('_', ' '));
        }
        return typeStr;
    }

    public String getOpeningHours() {
        return this.openingHours;
    }

    public String getAdditionalInfo(String key) {
        if (this.additionalInfo == null) {
            return null;
        }
        String str = this.additionalInfo.get(key);
        str = Amenity.unzipContent(str);
        return str;
    }

    public boolean hasAdditionalInfo() {
        return !Algorithms.isEmpty(this.additionalInfo);
    }

    private Map<String, String> getInternalAdditionalInfoMap() {
        if (this.additionalInfo == null) {
            return Collections.emptyMap();
        }
        return this.additionalInfo;
    }

    public Collection<String> getAdditionalInfoValues(boolean excludeZipped) {
        if (this.additionalInfo == null) {
            return Collections.emptyList();
        }
        boolean zipped = false;
        for (String v : this.additionalInfo.values()) {
            if (!Amenity.isContentZipped(v)) continue;
            zipped = true;
            break;
        }
        if (zipped) {
            ArrayList<String> r = new ArrayList<String>(this.additionalInfo.size());
            for (String str : this.additionalInfo.values()) {
                if (excludeZipped && Amenity.isContentZipped(str)) continue;
                r.add(Amenity.unzipContent(str));
            }
            return r;
        }
        return this.additionalInfo.values();
    }

    public Collection<String> getAdditionalInfoKeys() {
        if (this.additionalInfo == null) {
            return Collections.emptyList();
        }
        return this.additionalInfo.keySet();
    }

    public void setAdditionalInfo(Map<String, String> additionalInfo) {
        this.additionalInfo = null;
        this.openingHours = null;
        if (additionalInfo != null) {
            for (Map.Entry<String, String> e : additionalInfo.entrySet()) {
                this.setAdditionalInfo(e.getKey(), e.getValue());
            }
        }
    }

    public void setRoutePoint(AmenityRoutePoint routePoint) {
        this.routePoint = routePoint;
    }

    public AmenityRoutePoint getRoutePoint() {
        return this.routePoint;
    }

    public void setAdditionalInfo(String tag, String value) {
        if (NAME.equals(tag)) {
            this.setName(value);
        } else if (tag.startsWith("name:")) {
            this.setName(tag.substring("name:".length()), value);
        } else {
            if (this.additionalInfo == null) {
                this.additionalInfo = new LinkedHashMap<String, String>();
            }
            this.additionalInfo.put(tag, value);
            if (OPENING_HOURS.equals(tag)) {
                this.openingHours = Amenity.unzipContent(value);
            }
        }
    }

    public StringBuilder printNamesAndAdditional() {
        StringBuilder s = new StringBuilder();
        HashMap<String, String> additionals = new HashMap<String, String>();
        HashMap<String, String> poi_type = new HashMap<String, String>();
        HashMap<String, String> text = new HashMap<String, String>();
        if (this.additionalInfo != null) {
            for (Map.Entry<String, String> e : this.additionalInfo.entrySet()) {
                String key = e.getKey();
                Object val = e.getValue();
                AbstractPoiType pt = MapPoiTypes.getDefault().getAnyPoiAdditionalTypeByKey(key);
                if (pt == null && !Algorithms.isEmpty((CharSequence)val) && ((String)val).length() < 50) {
                    pt = MapPoiTypes.getDefault().getAnyPoiAdditionalTypeByKey(key + "_" + (String)val);
                }
                if (pt != null) {
                    additionals.put(key, (String)val);
                    continue;
                }
                PoiType pt2 = MapPoiTypes.getDefault().getPoiTypeByKey(key);
                if (pt2 != null) {
                    String cat = pt2.getCategory().getKeyName();
                    if (poi_type.containsKey(cat)) {
                        val = (String)poi_type.get(cat) + SEPARATOR + (String)val;
                    }
                    poi_type.put(pt2.getCategory().getKeyName(), (String)val);
                    continue;
                }
                text.put(key, (String)val);
            }
        }
        if (poi_type.size() > 0) {
            s.append(" [ ");
            this.printNames("", poi_type, s);
            s.append(" ] ");
        }
        if (additionals.size() > 0) {
            s.append(" poi_additional:[ ");
            this.printNames("", additionals, s);
            s.append(" ] ");
        }
        if (text.size() > 0) {
            s.append(" non_default_poi_xml:[ ");
            this.printNames("", text, s);
            s.append(" ] ");
        }
        this.printNames(" name:", this.getNamesMap(true), s);
        return s;
    }

    private void printNames(String prefix, Map<String, String> stringMap, StringBuilder s) {
        for (Map.Entry<String, String> e : stringMap.entrySet()) {
            if (e.getValue().startsWith(" gz ")) {
                s.append(prefix).append(e.getKey()).append("='gzip ...'");
                continue;
            }
            s.append(prefix).append(e.getKey()).append("='").append(e.getValue()).append("' ");
        }
    }

    @Override
    public String toStringEn() {
        return super.toStringEn() + ": " + this.type.getKeyName() + ":" + this.subType;
    }

    @Override
    public String toString() {
        return this.type.getKeyName() + ": " + this.subType + " " + this.getName();
    }

    public String getSite() {
        return this.getAdditionalInfo(WEBSITE);
    }

    public void setSite(String site) {
        this.setAdditionalInfo(WEBSITE, site);
    }

    public String getPhone() {
        return this.getAdditionalInfo(PHONE);
    }

    public void setPhone(String phone) {
        this.setAdditionalInfo(PHONE, phone);
    }

    public String getColor() {
        return this.getAdditionalInfo(COLOR);
    }

    public String getGpxIcon() {
        return this.getAdditionalInfo(GPX_ICON);
    }

    public String getContentLanguage(String tag, String lang, String defLang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return lang;
        }
        String plainContent = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainContent)) {
            return defLang;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return "en";
        }
        int maxLen = 0;
        String lng = defLang;
        for (String nm : this.getAdditionalInfoKeys()) {
            String key;
            String cnt;
            if (!nm.startsWith(tag + ":") || Algorithms.isEmpty(cnt = this.getAdditionalInfo(tag + ":" + (key = nm.substring(tag.length() + 1)))) || cnt.length() <= maxLen) continue;
            maxLen = cnt.length();
            lng = key;
        }
        return lng;
    }

    public Set<String> getSupportedContentLocales() {
        TreeSet<String> supported = new TreeSet<String>();
        supported.addAll(this.getNames(CONTENT, "en"));
        supported.addAll(this.getNames(DESCRIPTION, "en"));
        return supported;
    }

    public List<String> getNames(String tag, String defTag) {
        ArrayList<String> l = new ArrayList<String>();
        for (String nm : this.getAdditionalInfoKeys()) {
            if (nm.startsWith(tag + ":")) {
                l.add(nm.substring(tag.length() + 1));
                continue;
            }
            if (!nm.equals(tag)) continue;
            l.add(defTag);
        }
        return l;
    }

    public Map<String, String> getAltNamesMap() {
        HashMap<String, String> names = new HashMap<String, String>();
        for (String nm : this.getAdditionalInfoKeys()) {
            String name = this.additionalInfo.get(nm);
            if (!nm.startsWith(ALT_NAME_WITH_LANG_PREFIX)) continue;
            names.put(nm.substring(ALT_NAME_WITH_LANG_PREFIX.length()), name);
        }
        return names;
    }

    public String getTagSuffix(String tagPrefix) {
        for (String infoTag : this.getAdditionalInfoKeys()) {
            if (!infoTag.startsWith(tagPrefix) || infoTag.length() <= tagPrefix.length()) continue;
            return infoTag.substring(tagPrefix.length());
        }
        return null;
    }

    public String getTagContent(String tag) {
        return this.getTagContent(tag, null);
    }

    public String getTagContent(String tag, String lang) {
        String translateName = this.getStrictTagContent(tag, lang);
        if (translateName != null) {
            return translateName;
        }
        for (String nm : this.getAdditionalInfoKeys()) {
            if (!nm.startsWith(tag + ":")) continue;
            return this.getAdditionalInfo(nm);
        }
        return null;
    }

    public String getRef() {
        return this.getAdditionalInfo(REF);
    }

    public String getRouteId() {
        return this.getAdditionalInfo(ROUTE_ID);
    }

    public String getStrictTagContent(String tag, String lang) {
        String translateName;
        if (lang != null && !Algorithms.isEmpty(translateName = this.getAdditionalInfo(tag + ":" + lang))) {
            return translateName;
        }
        String plainName = this.getAdditionalInfo(tag);
        if (!Algorithms.isEmpty(plainName)) {
            return plainName;
        }
        String enName = this.getAdditionalInfo(tag + ":en");
        if (!Algorithms.isEmpty(enName)) {
            return enName;
        }
        return null;
    }

    public String getDescription(String lang) {
        String info = this.getTagContent(DESCRIPTION, lang);
        if (!Algorithms.isEmpty(info)) {
            return info;
        }
        return this.getTagContent(CONTENT, lang);
    }

    public void setDescription(String description) {
        this.setAdditionalInfo(DESCRIPTION, description);
    }

    public void setOpeningHours(String openingHours) {
        this.setAdditionalInfo(OPENING_HOURS, openingHours);
    }

    public boolean comparePoi(Amenity thatObj) {
        return this.compareObject(thatObj) && Algorithms.objectEquals(this.type.getKeyName(), thatObj.type.getKeyName()) && Algorithms.objectEquals(this.subType, thatObj.subType) && Algorithms.objectEquals(this.additionalInfo, thatObj.additionalInfo);
    }

    public boolean strictEquals(Object object) {
        if (this.equals(object)) {
            if (this.x != null && ((Amenity)object).x != null && this.x.size() == ((Amenity)object).x.size()) {
                for (int i = 0; i < this.x.size(); ++i) {
                    if (this.x.get(i) == ((Amenity)object).x.get(i) && this.y.get(i) == ((Amenity)object).y.get(i)) continue;
                    return false;
                }
                return true;
            }
            return this.x == null && ((Amenity)object).x == null;
        }
        return false;
    }

    @Override
    public int compareTo(MapObject o) {
        int cmp = super.compareTo(o);
        if (cmp == 0 && o instanceof Amenity) {
            int kn = ((Amenity)o).getType().getKeyName().compareTo(this.getType().getKeyName());
            if (kn == 0) {
                kn = ((Amenity)o).getSubType().compareTo(this.getSubType());
            }
            return kn;
        }
        return cmp;
    }

    @Override
    public boolean equals(Object o) {
        boolean res = super.equals(o);
        if (res && o instanceof Amenity) {
            return Algorithms.stringsEqual(((Amenity)o).getType().getKeyName(), this.getType().getKeyName()) && Algorithms.stringsEqual(((Amenity)o).getSubType(), this.getSubType());
        }
        return res;
    }

    public TIntArrayList getY() {
        if (this.y == null) {
            this.y = new TIntArrayList();
        }
        return this.y;
    }

    public TIntArrayList getX() {
        if (this.x == null) {
            this.x = new TIntArrayList();
        }
        return this.x;
    }

    public boolean isClosed() {
        return OSM_DELETE_VALUE.equals(this.getAdditionalInfo(OSM_DELETE_TAG));
    }

    public boolean isPrivateAccess() {
        return PRIVATE_VALUE.equals(this.getTagContent(ACCESS_PRIVATE_TAG));
    }

    @Override
    public JSONObject toJSON() {
        JSONObject json = super.toJSON();
        json.put("subType", (Object)this.subType);
        json.put(TYPE, (Object)this.type.getKeyName());
        json.put("openingHours", (Object)this.openingHours);
        if (this.additionalInfo != null && this.additionalInfo.size() > 0) {
            JSONObject additionalInfoObj = new JSONObject();
            for (Map.Entry<String, String> e : this.additionalInfo.entrySet()) {
                additionalInfoObj.put(e.getKey(), (Object)e.getValue());
            }
            json.put("additionalInfo", (Object)additionalInfoObj);
        }
        return json;
    }

    public static Amenity parseJSON(JSONObject json) {
        Amenity a = new Amenity();
        MapObject.parseJSON(json, a);
        if (json.has("subType")) {
            a.subType = json.getString("subType");
        }
        if (json.has(TYPE)) {
            String categoryName = json.getString(TYPE);
            a.setType(MapPoiTypes.getDefault().getPoiCategoryByName(categoryName));
        } else {
            a.setType(MapPoiTypes.getDefault().getOtherPoiCategory());
        }
        if (json.has("openingHours")) {
            a.openingHours = json.getString("openingHours");
        }
        if (json.has("additionalInfo")) {
            JSONObject namesObj = json.getJSONObject("additionalInfo");
            a.additionalInfo = new HashMap<String, String>();
            Iterator iterator = namesObj.keys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                String value = namesObj.getString(key);
                a.additionalInfo.put(key, value);
            }
        }
        return a;
    }

    public Map<String, String> getAmenityExtensions() {
        return this.getAmenityExtensions(MapPoiTypes.getDefault(), true);
    }

    public Map<String, String> getAmenityExtensions(MapPoiTypes mapPoiTypes, boolean addPrefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        HashMap<String, List<PoiType>> categories = new HashMap<String, List<PoiType>>();
        if (this.name != null) {
            result.put(addPrefixes ? "amenity_name" : NAME, this.name);
        }
        if (this.subType != null) {
            result.put(addPrefixes ? "amenity_subtype" : SUBTYPE, this.subType);
        }
        if (this.type != null) {
            result.put(addPrefixes ? "amenity_type" : TYPE, this.type.getKeyName());
        }
        if (this.openingHours != null) {
            result.put(addPrefixes ? "amenity_opening_hours" : OPENING_HOURS, this.openingHours);
        }
        if (this.hasAdditionalInfo()) {
            result.putAll(this.getAdditionalInfoAndCollectCategories(mapPoiTypes, categories, addPrefixes));
            for (Map.Entry entry : categories.entrySet()) {
                String key = COLLAPSABLE_PREFIX + (String)entry.getKey();
                List categoryTypes = (List)entry.getValue();
                if (categoryTypes.isEmpty()) continue;
                StringBuilder builder = new StringBuilder();
                for (PoiType poiType : categoryTypes) {
                    if (builder.length() > 0) {
                        builder.append(SEPARATOR);
                    }
                    builder.append(poiType.getKeyName());
                }
                result.put(key, builder.toString());
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    public Map<String, String> getAdditionalInfoAndCollectCategories(MapPoiTypes mapPoiTypes, Map<String, List<PoiType>> categories, boolean addPrefixes) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String string : this.getAdditionalInfoKeys()) {
            void var6_6;
            String category;
            String value;
            PoiType poiType = this.getPoiType(mapPoiTypes, string, value = this.getAdditionalInfo(string));
            if (poiType != null && poiType.isFilterOnly()) continue;
            if (poiType != null && !poiType.isText() && categories != null && !Algorithms.isEmpty(category = poiType.getPoiAdditionalCategory())) {
                List<PoiType> types = categories.get(category);
                if (types == null) {
                    types = new ArrayList<PoiType>();
                    categories.put(category, types);
                }
                types.add(poiType);
                continue;
            }
            if (string.endsWith(OPENING_HOURS)) continue;
            if (!HIDING_EXTENSIONS_AMENITY_TAGS.contains(string) && addPrefixes) {
                String string2 = "osm_tag_" + string;
            }
            result.put((String)var6_6, value);
        }
        return result;
    }

    private PoiType getPoiType(MapPoiTypes mapPoiTypes, String key, String value) {
        AbstractPoiType abstractPoiType = mapPoiTypes.getAnyPoiAdditionalTypeByKey(key);
        if (abstractPoiType == null && !Amenity.isContentZipped(value)) {
            abstractPoiType = mapPoiTypes.getAnyPoiAdditionalTypeByKey(key + "_" + value);
        }
        if (abstractPoiType instanceof PoiType) {
            return (PoiType)abstractPoiType;
        }
        return null;
    }

    public String getTranslation(MapPoiTypes mapPoiTypes, String alternateName) {
        for (String key : this.getAdditionalInfoKeys()) {
            PoiType poiType;
            String value = this.getAdditionalInfo(key);
            if (!value.equals(alternateName) || (poiType = this.getPoiType(mapPoiTypes, key, value)) == null || poiType.isText()) continue;
            return poiType.getTranslation();
        }
        return alternateName;
    }

    public String getCityFromTagGroups(String lang) {
        if (this.tagGroups == null) {
            return null;
        }
        String result = null;
        for (Map.Entry<Integer, List<BinaryMapIndexReader.TagValuePair>> entry : this.tagGroups.entrySet()) {
            String translated = "";
            String nonTranslated = "";
            City.CityType type = null;
            for (BinaryMapIndexReader.TagValuePair tagValue : entry.getValue()) {
                if (tagValue.tag.endsWith("name:" + lang)) {
                    translated = tagValue.value;
                }
                if (tagValue.tag.endsWith(NAME)) {
                    nonTranslated = tagValue.value;
                }
                if (!tagValue.tag.equals("place")) continue;
                type = City.CityType.valueFromString(tagValue.value.toUpperCase());
            }
            String name = translated.isEmpty() ? nonTranslated : translated;
            if (name.isEmpty() || !this.isCityTypeAccept(type)) continue;
            result = result == null ? name : result + ", " + name;
        }
        return result;
    }

    private boolean isCityTypeAccept(City.CityType type) {
        if (type == null) {
            return false;
        }
        return type.storedAsSeparateAdminEntity();
    }

    public List<LatLon> getPolygon() {
        ArrayList<LatLon> res = new ArrayList<LatLon>();
        if (this.x == null) {
            return res;
        }
        for (int i = 0; i < this.getX().size(); ++i) {
            int x = this.getX().get(i);
            int y = this.getY().get(i);
            LatLon l = new LatLon(MapUtils.get31LatitudeY(y), MapUtils.get31LongitudeX(x));
            res.add(l);
        }
        return res;
    }

    public void setX(TIntArrayList x) {
        this.x = x;
    }

    public void setY(TIntArrayList y) {
        this.y = y;
    }

    public static class AmenityRoutePoint {
        public double deviateDistance;
        public boolean deviationDirectionRight;
        public Location pointA;
        public Location pointB;
    }
}

