/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Arrays;
import java.util.HashMap;
import net.osmand.Location;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.data.LatLon;
import net.osmand.router.GeneralRouter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.TransliterationHelper;

public class RouteDataObject {
    static final int RESTRICTION_SHIFT = 3;
    static final int RESTRICTION_MASK = 7;
    public static int HEIGHT_UNDEFINED = -80000;
    public final BinaryMapRouteReaderAdapter.RouteRegion region;
    public int[] types;
    public int[] pointsX;
    public int[] pointsY;
    public long[] restrictions;
    public long[] restrictionsVia;
    public int[][] pointTypes;
    public String[][] pointNames;
    public int[][] pointNameTypes;
    public long id;
    public TIntObjectHashMap<String> names;
    public static final float NONE_MAX_SPEED = 40.0f;
    public int[] nameIds;
    public float[] heightDistanceArray = null;
    public float heightByCurrentLocation = Float.NaN;

    public RouteDataObject(BinaryMapRouteReaderAdapter.RouteRegion region) {
        this.region = region;
    }

    public RouteDataObject(BinaryMapRouteReaderAdapter.RouteRegion region, int[] nameIds, String[] nameValues) {
        this.region = region;
        this.nameIds = nameIds;
        if (nameIds.length > 0) {
            this.names = new TIntObjectHashMap();
        }
        for (int i = 0; i < nameIds.length; ++i) {
            this.names.put(nameIds[i], (Object)nameValues[i]);
        }
    }

    public RouteDataObject(RouteDataObject copy) {
        this.region = copy.region;
        this.pointsX = copy.pointsX;
        this.pointsY = copy.pointsY;
        this.types = copy.types;
        this.names = copy.names;
        this.nameIds = copy.nameIds;
        this.restrictions = copy.restrictions;
        this.restrictionsVia = copy.restrictionsVia;
        this.pointTypes = copy.pointTypes;
        this.pointNames = copy.pointNames;
        this.pointNameTypes = copy.pointNameTypes;
        this.id = copy.id;
    }

    public boolean compareRoute(RouteDataObject thatObj) {
        if (this.id == thatObj.id && Arrays.equals(this.pointsX, thatObj.pointsX) && Arrays.equals(this.pointsY, thatObj.pointsY)) {
            String thatValue;
            String thatTag;
            String thisValue;
            String thisTag;
            String thatValue2;
            String thatTag2;
            String thisValue2;
            String thisTag2;
            int i;
            if (this.region == null) {
                throw new IllegalStateException("Illegal routing object: " + this.id);
            }
            if (thatObj.region == null) {
                throw new IllegalStateException("Illegal routing object: " + thatObj.id);
            }
            boolean equals = true;
            equals = equals && Arrays.equals(this.restrictions, thatObj.restrictions);
            boolean bl = equals = equals && Arrays.equals(this.restrictionsVia, thatObj.restrictionsVia);
            if (equals) {
                if (this.types == null || thatObj.types == null) {
                    equals = this.types == thatObj.types;
                } else if (this.types.length != thatObj.types.length) {
                    equals = false;
                } else {
                    for (i = 0; i < this.types.length && equals; ++i) {
                        thisTag2 = this.region.routeEncodingRules.get(this.types[i]).getTag();
                        thisValue2 = this.region.routeEncodingRules.get(this.types[i]).getValue();
                        thatTag2 = thatObj.region.routeEncodingRules.get(thatObj.types[i]).getTag();
                        thatValue2 = thatObj.region.routeEncodingRules.get(thatObj.types[i]).getValue();
                        equals = thisTag2.equals(thatTag2) && thisValue2.equals(thatValue2);
                    }
                }
            }
            if (equals) {
                if (this.nameIds == null || thatObj.nameIds == null) {
                    equals = this.nameIds == thatObj.nameIds;
                } else if (this.nameIds.length != thatObj.nameIds.length) {
                    equals = false;
                } else {
                    for (i = 0; i < this.nameIds.length && equals; ++i) {
                        thisTag2 = this.region.routeEncodingRules.get(this.nameIds[i]).getTag();
                        thisValue2 = (String)this.names.get(this.nameIds[i]);
                        thatTag2 = thatObj.region.routeEncodingRules.get(thatObj.nameIds[i]).getTag();
                        thatValue2 = (String)thatObj.names.get(thatObj.nameIds[i]);
                        equals = Algorithms.objectEquals(thisTag2, thatTag2) && Algorithms.objectEquals(thisValue2, thatValue2);
                    }
                }
            }
            if (equals) {
                if (this.pointTypes == null || thatObj.pointTypes == null) {
                    equals = this.pointTypes == thatObj.pointTypes;
                } else if (this.pointTypes.length != thatObj.pointTypes.length) {
                    equals = false;
                } else {
                    for (i = 0; i < this.pointTypes.length && equals; ++i) {
                        if (this.pointTypes[i] == null || thatObj.pointTypes[i] == null) {
                            equals = this.pointTypes[i] == thatObj.pointTypes[i];
                            continue;
                        }
                        if (this.pointTypes[i].length != thatObj.pointTypes[i].length) {
                            equals = false;
                            continue;
                        }
                        for (int j = 0; j < this.pointTypes[i].length && equals; ++j) {
                            thisTag = this.region.routeEncodingRules.get(this.pointTypes[i][j]).getTag();
                            thisValue = this.region.routeEncodingRules.get(this.pointTypes[i][j]).getValue();
                            thatTag = thatObj.region.routeEncodingRules.get(thatObj.pointTypes[i][j]).getTag();
                            thatValue = thatObj.region.routeEncodingRules.get(thatObj.pointTypes[i][j]).getValue();
                            equals = Algorithms.objectEquals(thisTag, thatTag) && Algorithms.objectEquals(thisValue, thatValue);
                        }
                    }
                }
            }
            if (equals) {
                if (this.pointNameTypes == null || thatObj.pointNameTypes == null) {
                    equals = this.pointNameTypes == thatObj.pointNameTypes;
                } else if (this.pointNameTypes.length != thatObj.pointNameTypes.length) {
                    equals = false;
                } else {
                    for (i = 0; i < this.pointNameTypes.length && equals; ++i) {
                        if (this.pointNameTypes[i] == null || thatObj.pointNameTypes[i] == null) {
                            equals = this.pointNameTypes[i] == thatObj.pointNameTypes[i];
                            continue;
                        }
                        if (this.pointNameTypes[i].length != thatObj.pointNameTypes[i].length) {
                            equals = false;
                            continue;
                        }
                        for (int j = 0; j < this.pointNameTypes[i].length && equals; ++j) {
                            thisTag = this.region.routeEncodingRules.get(this.pointNameTypes[i][j]).getTag();
                            thisValue = this.pointNames[i][j];
                            thatTag = thatObj.region.routeEncodingRules.get(thatObj.pointNameTypes[i][j]).getTag();
                            thatValue = thatObj.pointNames[i][j];
                            equals = Algorithms.objectEquals(thisTag, thatTag) && Algorithms.objectEquals(thisValue, thatValue);
                        }
                    }
                }
            }
            return equals;
        }
        return false;
    }

    public float[] calculateHeightArray() {
        return this.calculateHeightArray(null);
    }

    public float[] calculateHeightArray(LatLon currentLocation) {
        if (this.heightDistanceArray != null) {
            return this.heightDistanceArray;
        }
        int startHeight = Algorithms.parseIntSilently(this.getValue("osmand_ele_start"), HEIGHT_UNDEFINED);
        int endHeight = Algorithms.parseIntSilently(this.getValue("osmand_ele_end"), startHeight);
        if (startHeight == HEIGHT_UNDEFINED) {
            this.heightDistanceArray = new float[0];
            return this.heightDistanceArray;
        }
        this.heightDistanceArray = new float[2 * this.getPointsLength()];
        double plon = 0.0;
        double plat = 0.0;
        float prevHeight = startHeight;
        this.heightByCurrentLocation = Float.NaN;
        double prevDistance = 0.0;
        for (int k = 0; k < this.getPointsLength(); ++k) {
            double lon = MapUtils.get31LongitudeX(this.getPoint31XTile(k));
            double lat = MapUtils.get31LatitudeY(this.getPoint31YTile(k));
            if (k > 0) {
                double dd = MapUtils.getDistance(plat, plon, lat, lon);
                float height = HEIGHT_UNDEFINED;
                if (k == this.getPointsLength() - 1) {
                    height = endHeight;
                } else {
                    String asc = this.getValue(k, "osmand_ele_asc");
                    if (asc != null && asc.length() > 0) {
                        height = prevHeight + Float.parseFloat(asc);
                    } else {
                        String desc = this.getValue(k, "osmand_ele_desc");
                        if (desc != null && desc.length() > 0) {
                            height = prevHeight - Float.parseFloat(desc);
                        }
                    }
                }
                this.heightDistanceArray[2 * k] = (float)dd;
                this.heightDistanceArray[2 * k + 1] = height;
                if (currentLocation != null) {
                    double distance = MapUtils.getDistance(currentLocation, lat, lon);
                    if (height != (float)HEIGHT_UNDEFINED && distance < prevDistance) {
                        prevDistance = distance;
                        this.heightByCurrentLocation = height;
                    }
                }
                if (height != (float)HEIGHT_UNDEFINED) {
                    double totalDistance = dd;
                    int startUndefined = k;
                    while (startUndefined - 1 >= 0 && this.heightDistanceArray[2 * (startUndefined - 1) + 1] == (float)HEIGHT_UNDEFINED) {
                        totalDistance += (double)this.heightDistanceArray[2 * --startUndefined];
                    }
                    if (totalDistance > 0.0) {
                        double angle = (double)(height - prevHeight) / totalDistance;
                        for (int j = startUndefined; j < k; ++j) {
                            this.heightDistanceArray[2 * j + 1] = (float)((double)this.heightDistanceArray[2 * j] * angle + (double)this.heightDistanceArray[2 * j - 1]);
                        }
                    }
                    prevHeight = height;
                }
            } else {
                this.heightDistanceArray[0] = 0.0f;
                this.heightDistanceArray[1] = startHeight;
            }
            plat = lat;
            plon = lon;
            if (currentLocation == null) continue;
            prevDistance = MapUtils.getDistance(currentLocation, plat, plon);
        }
        return this.heightDistanceArray;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        if (this.names != null) {
            return (String)this.names.get(this.region.nameTypeRule);
        }
        return null;
    }

    public String getName(String lang) {
        return this.getName(lang, false);
    }

    public String getName(String lang, boolean transliterate) {
        if (this.names != null) {
            if (Algorithms.isEmpty(lang)) {
                return (String)this.names.get(this.region.nameTypeRule);
            }
            int[] kt = this.names.keys();
            for (int i = 0; i < kt.length; ++i) {
                int k = kt[i];
                if (this.region.routeEncodingRules.size() <= k || !("name:" + lang).equals(this.region.routeEncodingRules.get(k).getTag())) continue;
                return (String)this.names.get(k);
            }
            String nmDef = (String)this.names.get(this.region.nameTypeRule);
            if (transliterate && nmDef != null && nmDef.length() > 0) {
                return TransliterationHelper.transliterate(nmDef);
            }
            return nmDef;
        }
        return null;
    }

    public int[] getNameIds() {
        return this.nameIds;
    }

    public TIntObjectHashMap<String> getNames() {
        return this.names;
    }

    public String getRef(String lang, boolean transliterate, boolean direction) {
        if (this.names != null) {
            if (Algorithms.isEmpty(lang)) {
                return (String)this.names.get(this.region.refTypeRule);
            }
            int[] kt = this.names.keys();
            for (int i = 0; i < kt.length; ++i) {
                int k = kt[i];
                if (this.region.routeEncodingRules.size() <= k || !("ref:" + lang).equals(this.region.routeEncodingRules.get(k).getTag())) continue;
                return (String)this.names.get(k);
            }
            String refDefault = (String)this.names.get(this.region.refTypeRule);
            if (transliterate && refDefault != null && refDefault.length() > 0) {
                return TransliterationHelper.transliterate(refDefault);
            }
            return refDefault;
        }
        return null;
    }

    public String getDestinationRef(String lang, boolean transliterate, boolean direction) {
        if (this.names != null) {
            int[] kt = this.names.keys();
            String refTag = direction ? "destination:ref:forward" : "destination:ref:backward";
            String refTagDefault = "destination:ref";
            String refDefault = null;
            for (int i = 0; i < kt.length; ++i) {
                int k = kt[i];
                if (this.region.routeEncodingRules.size() <= k) continue;
                if (refTag.equals(this.region.routeEncodingRules.get(k).getTag())) {
                    return (String)this.names.get(k);
                }
                if (!refTagDefault.equals(this.region.routeEncodingRules.get(k).getTag())) continue;
                refDefault = (String)this.names.get(k);
            }
            if (refDefault != null) {
                return refDefault;
            }
        }
        return null;
    }

    public String getDestinationName(String lang, boolean transliterate, boolean direction) {
        if (this.names != null) {
            int[] nameKeys = this.names.keys();
            HashMap<Object, Integer> tagPriorities = new HashMap<Object, Integer>();
            int tagPriority = 1;
            if (!Algorithms.isEmpty(lang)) {
                tagPriorities.put("destination:lang:" + lang + (direction ? ":forward" : ":backward"), tagPriority++);
            }
            tagPriorities.put("destination:" + (direction ? "forward" : "backward"), tagPriority++);
            if (!Algorithms.isEmpty(lang)) {
                tagPriorities.put("destination:lang:" + lang, tagPriority++);
            }
            tagPriorities.put("destination", tagPriority);
            int highestPriorityNameKey = -1;
            int highestPriority = Integer.MAX_VALUE;
            for (int nameKey : nameKeys) {
                String tag;
                Integer priority;
                if (this.region.routeEncodingRules.size() <= nameKey || (priority = (Integer)tagPriorities.get(tag = this.region.routeEncodingRules.get(nameKey).getTag())) == null || priority >= highestPriority) continue;
                highestPriority = priority;
                highestPriorityNameKey = nameKey;
            }
            if (highestPriorityNameKey > 0) {
                String name = (String)this.names.get(highestPriorityNameKey);
                return transliterate ? TransliterationHelper.transliterate(name) : name;
            }
        }
        return "";
    }

    public int getPoint31XTile(int i) {
        return this.pointsX[i];
    }

    public int getPoint31XTile(int s, int e) {
        return this.pointsX[s] / 2 + this.pointsX[e] / 2;
    }

    public int getPoint31YTile(int i) {
        return this.pointsY[i];
    }

    public int getPoint31YTile(int s, int e) {
        return this.pointsY[s] / 2 + this.pointsY[e] / 2;
    }

    public int getPointsLength() {
        return this.pointsX.length;
    }

    public int getRestrictionLength() {
        return this.restrictions == null ? 0 : this.restrictions.length;
    }

    public int getRestrictionType(int i) {
        return (int)(this.restrictions[i] & 7L);
    }

    public RestrictionInfo getRestrictionInfo(int k) {
        RestrictionInfo ri = new RestrictionInfo();
        ri.toWay = this.getRestrictionId(k);
        ri.type = this.getRestrictionType(k);
        if (this.restrictionsVia != null && k < this.restrictionsVia.length) {
            ri.viaWay = this.restrictionsVia[k];
        }
        return ri;
    }

    public long getRestrictionVia(int i) {
        if (this.restrictionsVia != null && this.restrictionsVia.length > i) {
            return this.restrictionsVia[i];
        }
        return 0L;
    }

    public long getRestrictionId(int i) {
        return this.restrictions[i] >> 3;
    }

    public boolean hasPointTypes() {
        return this.pointTypes != null;
    }

    public boolean hasPointNames() {
        return this.pointNames != null;
    }

    public void insert(int pos, int x31, int y31) {
        int i;
        boolean insNames;
        int[] opointsX = this.pointsX;
        int[] opointsY = this.pointsY;
        int[][] opointTypes = this.pointTypes;
        String[][] opointNames = this.pointNames;
        int[][] opointNameTypes = this.pointNameTypes;
        this.pointsX = new int[this.pointsX.length + 1];
        this.pointsY = new int[this.pointsY.length + 1];
        boolean insTypes = this.pointTypes != null && this.pointTypes.length > pos;
        boolean bl = insNames = this.pointNames != null && this.pointNames.length > pos;
        if (insTypes) {
            this.pointTypes = new int[opointTypes.length + 1][];
        }
        if (insNames) {
            this.pointNames = new String[opointNames.length + 1][];
            this.pointNameTypes = new int[opointNameTypes.length + 1][];
        }
        for (i = 0; i < pos; ++i) {
            this.pointsX[i] = opointsX[i];
            this.pointsY[i] = opointsY[i];
            if (insTypes) {
                this.pointTypes[i] = opointTypes[i];
            }
            if (!insNames) continue;
            this.pointNames[i] = opointNames[i];
            this.pointNameTypes[i] = opointNameTypes[i];
        }
        this.pointsX[i] = x31;
        this.pointsY[i] = y31;
        if (insTypes) {
            this.pointTypes[i] = null;
        }
        if (insNames) {
            this.pointNames[i] = null;
            this.pointNameTypes[i] = null;
        }
        ++i;
        while (i < this.pointsX.length) {
            this.pointsX[i] = opointsX[i - 1];
            this.pointsY[i] = opointsY[i - 1];
            if (insTypes && i < this.pointTypes.length) {
                this.pointTypes[i] = opointTypes[i - 1];
            }
            if (insNames && i < this.pointNames.length) {
                this.pointNames[i] = opointNames[i - 1];
            }
            if (insNames && i < this.pointNameTypes.length) {
                this.pointNameTypes[i] = opointNameTypes[i - 1];
            }
            ++i;
        }
    }

    public String[] getPointNames(int ind) {
        if (this.pointNames == null || ind >= this.pointNames.length) {
            return null;
        }
        return this.pointNames[ind];
    }

    public int[] getPointNameTypes(int ind) {
        if (this.pointNameTypes == null || ind >= this.pointNameTypes.length) {
            return null;
        }
        return this.pointNameTypes[ind];
    }

    public int[] getPointTypes(int ind) {
        if (this.pointTypes == null || ind >= this.pointTypes.length) {
            return null;
        }
        return this.pointTypes[ind];
    }

    public void removePointType(int ind, int type) {
        if (this.pointTypes != null || ind < this.pointTypes.length) {
            int[] typesArr = this.pointTypes[ind];
            for (int i = 0; i < typesArr.length; ++i) {
                if (typesArr[i] != type) continue;
                int[] result = new int[typesArr.length - 1];
                System.arraycopy(typesArr, 0, result, 0, i);
                if (typesArr.length == i) continue;
                System.arraycopy(typesArr, i + 1, result, i, typesArr.length - 1 - i);
                this.pointTypes[ind] = result;
                break;
            }
        }
    }

    public int[] getTypes() {
        return this.types;
    }

    public void processConditionalTags(long conditionalTime) {
        int i;
        int sz = this.types.length;
        for (i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule toReplace;
            int ks;
            int vl;
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r == null || !r.conditional() || (vl = r.conditionalValue(conditionalTime)) == 0) continue;
            BinaryMapRouteReaderAdapter.RouteTypeRule rtr = this.region.quickGetEncodingRule(vl);
            String nonCondTag = rtr.getTag();
            for (ks = 0; !(ks >= this.types.length || (toReplace = this.region.quickGetEncodingRule(this.types[ks])) != null && toReplace.getTag().equals(nonCondTag)); ++ks) {
            }
            if (ks == this.types.length) {
                int[] ntypes = new int[this.types.length + 1];
                System.arraycopy(this.types, 0, ntypes, 0, this.types.length);
                this.types = ntypes;
            }
            this.types[ks] = vl;
        }
        if (this.pointTypes != null) {
            for (i = 0; i < this.pointTypes.length; ++i) {
                if (this.pointTypes[i] == null) continue;
                int[] pTypes = this.pointTypes[i];
                int pSz = pTypes.length;
                if (pSz > 0) {
                    for (int j = 0; j < pSz; ++j) {
                        BinaryMapRouteReaderAdapter.RouteTypeRule toReplace;
                        int ks;
                        int vl;
                        BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(pTypes[j]);
                        if (r == null || !r.conditional() || (vl = r.conditionalValue(conditionalTime)) == 0) continue;
                        BinaryMapRouteReaderAdapter.RouteTypeRule rtr = this.region.quickGetEncodingRule(vl);
                        String nonCondTag = rtr.getTag();
                        for (ks = 0; !(ks >= this.pointTypes[i].length || (toReplace = this.region.quickGetEncodingRule(this.pointTypes[i][ks])) != null && toReplace.getTag().contentEquals(nonCondTag)); ++ks) {
                        }
                        if (ks == pTypes.length) {
                            int[] ntypes = new int[pTypes.length + 1];
                            System.arraycopy(pTypes, 0, ntypes, 0, pTypes.length);
                            pTypes = ntypes;
                        }
                        pTypes[ks] = vl;
                    }
                }
                this.pointTypes[i] = pTypes;
            }
        }
    }

    public float getMaximumSpeed(boolean direction) {
        return this.getMaximumSpeed(direction, 0);
    }

    public float getMaximumSpeed(boolean direction, int profile) {
        float maxSpeed = 0.0f;
        float maxProfileSpeed = 0.0f;
        for (int type : this.types) {
            boolean forwardDirection;
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(type);
            boolean bl = forwardDirection = r.isForward() > 0;
            if (forwardDirection != direction && r.isForward() != 0) continue;
            maxSpeed = r.maxSpeed(0) > 0.0f ? r.maxSpeed(0) : maxSpeed;
            maxProfileSpeed = r.maxSpeed(profile) > 0.0f ? r.maxSpeed(profile) : maxProfileSpeed;
        }
        return maxProfileSpeed > 0.0f ? maxProfileSpeed : maxSpeed;
    }

    public static float parseSpeed(String v, float def) {
        if (v.equals("none")) {
            return 40.0f;
        }
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            float f = Float.parseFloat(v.substring(0, i));
            f = (float)((double)f / 3.6);
            if (v.contains("mph")) {
                f = (float)((double)f * 1.6);
            }
            return f;
        }
        return def;
    }

    public static float parseLength(String v, float def) {
        float f = 0.0f;
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            f += Float.parseFloat(v.substring(0, i));
            String pref = v.substring(i, v.length()).trim();
            float add = 0.0f;
            for (int ik = 0; ik < pref.length(); ++ik) {
                if (!Algorithms.isDigit(pref.charAt(ik)) && pref.charAt(ik) != '.' && pref.charAt(ik) != '-') continue;
                int first = Algorithms.findFirstNumberEndIndex(pref.substring(ik));
                if (first == -1) break;
                add = RouteDataObject.parseLength(pref.substring(ik), 0.0f);
                pref = pref.substring(0, ik);
                break;
            }
            if (pref.contains("km")) {
                f *= 1000.0f;
            }
            if (pref.contains("\"") || pref.contains("in")) {
                f = (float)((double)f * 0.0254);
            } else if (pref.contains("'") || pref.contains("ft") || pref.contains("feet")) {
                f = (float)((double)f * 0.3048);
            } else if (pref.contains("cm")) {
                f = (float)((double)f * 0.01);
            } else if (pref.contains("mile")) {
                f *= 1609.34f;
            }
            return f + add;
        }
        return def;
    }

    public static float parseWeightInTon(String v, float def) {
        int i = Algorithms.findFirstNumberEndIndex(v);
        if (i > 0) {
            float f = Float.parseFloat(v.substring(0, i));
            if (v.contains("\"") || v.contains("lbs")) {
                f = f * 0.4535f / 1000.0f;
            }
            return f;
        }
        return def;
    }

    public boolean platform() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.getTag().equals("railway") && r.getValue().equals("platform")) {
                return true;
            }
            if (!r.getTag().equals("public_transport") || !r.getValue().equals("platform")) continue;
            return true;
        }
        return false;
    }

    public boolean roundabout() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (!r.roundabout()) continue;
            return true;
        }
        return false;
    }

    public boolean tunnel() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.getTag().equals("tunnel") && r.getValue().equals("yes")) {
                return true;
            }
            if (!r.getTag().equals("layer") || !r.getValue().equals("-1")) continue;
            return true;
        }
        return false;
    }

    public boolean isExitPoint() {
        if (this.pointTypes != null) {
            for (int[] point : this.pointTypes) {
                if (point == null) continue;
                int pSz = point.length;
                for (int j = 0; j < pSz; ++j) {
                    if (!this.region.routeEncodingRules.get(point[j]).getValue().equals("motorway_junction")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean hasTrafficLightAt(int i) {
        int[] pointTypes = this.getPointTypes(i);
        if (pointTypes != null) {
            for (int pointType : pointTypes) {
                if (!this.region.routeEncodingRules.get(pointType).getValue().startsWith("traffic_signals")) continue;
                return true;
            }
        }
        return false;
    }

    public String getExitName() {
        if (this.pointNames != null && this.pointNameTypes != null) {
            int pnSz = this.pointNames.length;
            for (int i = 0; i < pnSz; ++i) {
                String[] point = this.pointNames[i];
                if (point == null) continue;
                int pSz = point.length;
                for (int j = 0; j < pSz; ++j) {
                    if (this.pointNameTypes[i][j] != this.region.nameTypeRule) continue;
                    return point[j];
                }
            }
        }
        return null;
    }

    public String getExitRef() {
        if (this.pointNames != null && this.pointNameTypes != null) {
            int pnSz = this.pointNames.length;
            for (int i = 0; i < pnSz; ++i) {
                String[] point = this.pointNames[i];
                if (point == null) continue;
                int pSz = point.length;
                for (int j = 0; j < pSz; ++j) {
                    if (this.pointNameTypes[i][j] != this.region.refTypeRule) continue;
                    return point[j];
                }
            }
        }
        return null;
    }

    public int getOneway() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (r.onewayDirection() != 0) {
                return r.onewayDirection();
            }
            if (!r.roundabout()) continue;
            return 1;
        }
        return 0;
    }

    public String getRoute() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            if (!"route".equals(r.getTag())) continue;
            return r.getValue();
        }
        return null;
    }

    public String getHighway() {
        return RouteDataObject.getHighway(this.types, this.region);
    }

    public boolean hasPrivateAccess(GeneralRouter.GeneralRouterProfile profile) {
        for (int type : this.types) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rule = this.region.quickGetEncodingRule(type);
            String tag = rule.getTag();
            if (!rule.getValue().equals("private")) continue;
            if ("vehicle".equals(tag) || "access".equals(tag)) {
                return true;
            }
            if (profile == GeneralRouter.GeneralRouterProfile.CAR) {
                return "motorcar".equals(tag) || "motor_vehicle".equals(tag);
            }
            if (profile != GeneralRouter.GeneralRouterProfile.BICYCLE) continue;
            return "bicycle".equals(tag);
        }
        return false;
    }

    public String getValue(String tag) {
        BinaryMapRouteReaderAdapter.RouteTypeRule r;
        int i;
        for (i = 0; i < this.types.length; ++i) {
            r = this.region.quickGetEncodingRule(this.types[i]);
            if (!r.getTag().equals(tag)) continue;
            return r.getValue();
        }
        if (this.nameIds != null) {
            for (i = 0; i < this.nameIds.length; ++i) {
                r = this.region.quickGetEncodingRule(this.nameIds[i]);
                if (!r.getTag().equals(tag)) continue;
                return (String)this.names.get(this.nameIds[i]);
            }
        }
        return null;
    }

    public String getValue(int pnt, String tag) {
        BinaryMapRouteReaderAdapter.RouteTypeRule r;
        int i;
        if (this.pointTypes != null && pnt < this.pointTypes.length && this.pointTypes[pnt] != null) {
            for (i = 0; i < this.pointTypes[pnt].length; ++i) {
                r = this.region.quickGetEncodingRule(this.pointTypes[pnt][i]);
                if (!r.getTag().equals(tag)) continue;
                return r.getValue();
            }
        }
        if (this.pointNameTypes != null && pnt < this.pointNameTypes.length && this.pointNameTypes[pnt] != null) {
            for (i = 0; i < this.pointNameTypes[pnt].length; ++i) {
                r = this.region.quickGetEncodingRule(this.pointNameTypes[pnt][i]);
                if (!r.getTag().equals(tag)) continue;
                return this.pointNames[pnt][i];
            }
        }
        return null;
    }

    public static String getHighway(int[] types, BinaryMapRouteReaderAdapter.RouteRegion region) {
        BinaryMapRouteReaderAdapter.RouteTypeRule r;
        String highway = null;
        int sz = types.length;
        for (int i = 0; i < sz && (highway = (r = region.quickGetEncodingRule(types[i])).highwayRoad()) == null; ++i) {
        }
        return highway;
    }

    public int getLanes() {
        int sz = this.types.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(this.types[i]);
            int ln = r.lanes();
            if (ln <= 0) continue;
            return ln;
        }
        return -1;
    }

    public double directionRoute(int startPoint, boolean plus) {
        return this.directionRoute(startPoint, plus, 5.0f);
    }

    public boolean bearingVsRouteDirection(Location loc) {
        boolean direction = true;
        if (loc != null && loc.hasBearing()) {
            double diff = MapUtils.alignAngleDifference(this.directionRoute(0, true) - (double)(loc.getBearing() / 180.0f) * Math.PI);
            direction = Math.abs(diff) < 1.5707963267948966;
        }
        return direction;
    }

    public boolean isRoadDeleted() {
        int[] pt = this.getTypes();
        int sz = pt.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(pt[i]);
            if (!"osmand_change".equals(r.getTag()) || !"delete".equals(r.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isDirectionApplicable(boolean direction, int ind, int startPointInd, int endPointInd) {
        double d2End;
        double d2Start;
        int[] pt = this.getPointTypes(ind);
        int sz = pt.length;
        for (int i = 0; i < sz; ++i) {
            BinaryMapRouteReaderAdapter.RouteTypeRule r = this.region.quickGetEncodingRule(pt[i]);
            if (!r.getTag().equals("direction")) continue;
            String dv = r.getValue();
            if (dv.equals("forward") && direction || dv.equals("backward") && !direction) {
                return true;
            }
            if ((!dv.equals("forward") || direction) && (!dv.equals("backward") || !direction)) continue;
            return false;
        }
        return startPointInd < 0 || !((d2Start = this.distance(startPointInd, ind)) < (d2End = this.distance(ind, endPointInd))) || d2Start == 0.0 || d2End == 0.0 || !(d2Start < 50.0);
    }

    public double distance(int startPoint, int endPoint) {
        if (startPoint > endPoint) {
            int k = endPoint;
            endPoint = startPoint;
            startPoint = k;
        }
        double d = 0.0;
        for (int k = startPoint; k < endPoint && k < this.getPointsLength() - 1; ++k) {
            int x = this.getPoint31XTile(k);
            int y = this.getPoint31YTile(k);
            int kx = this.getPoint31XTile(k + 1);
            int ky = this.getPoint31YTile(k + 1);
            d += this.simplifyDistance(kx, ky, x, y);
        }
        return d;
    }

    public double directionRoute(int startPoint, boolean plus, float dist) {
        int x = this.getPoint31XTile(startPoint);
        int y = this.getPoint31YTile(startPoint);
        int nx = startPoint;
        int px = x;
        int py = y;
        double total = 0.0;
        while (!(!plus ? --nx < 0 : ++nx >= this.getPointsLength()) && (total += this.simplifyDistance(x, y, px = this.getPoint31XTile(nx), py = this.getPoint31YTile(nx))) < (double)dist) {
        }
        return -Math.atan2(x - px, y - py);
    }

    private double simplifyDistance(int x, int y, int px, int py) {
        return (double)Math.abs(px - x) * 0.011 + (double)Math.abs(py - y) * 0.01863;
    }

    private static void assertTrueLength(String vl, float exp) {
        float dest = RouteDataObject.parseLength(vl, 0.0f);
        if (exp != dest) {
            System.err.println("FAIL " + vl + " " + dest);
        } else {
            System.out.println("OK " + vl);
        }
    }

    public static void main(String[] args) {
        RouteDataObject.assertTrueLength("10 km", 10000.0f);
        RouteDataObject.assertTrueLength("0.01 km", 10.0f);
        RouteDataObject.assertTrueLength("0.01 km 10 m", 20.0f);
        RouteDataObject.assertTrueLength("10 m", 10.0f);
        RouteDataObject.assertTrueLength("10m", 10.0f);
        RouteDataObject.assertTrueLength("3.4 m", 3.4f);
        RouteDataObject.assertTrueLength("3.40 m", 3.4f);
        RouteDataObject.assertTrueLength("10 m 10m", 20.0f);
        RouteDataObject.assertTrueLength("14'10\"", 4.5212f);
        RouteDataObject.assertTrueLength("14.5'", 4.4196f);
        RouteDataObject.assertTrueLength("14.5 ft", 4.4196f);
        RouteDataObject.assertTrueLength("14'0\"", 4.2672f);
        RouteDataObject.assertTrueLength("15ft", 4.572f);
        RouteDataObject.assertTrueLength("15 ft 1 in", 4.5974f);
        RouteDataObject.assertTrueLength("4.1 metres", 4.1f);
        RouteDataObject.assertTrueLength("14'0''", 4.2672f);
        RouteDataObject.assertTrueLength("14 feet", 4.2672f);
        RouteDataObject.assertTrueLength("14 mile", 22530.76f);
        RouteDataObject.assertTrueLength("14 cm", 0.14f);
    }

    public String coordinates() {
        StringBuilder b = new StringBuilder();
        b.append(" lat/lon : ");
        for (int i = 0; i < this.getPointsLength(); ++i) {
            float x = (float)MapUtils.get31LongitudeX(this.getPoint31XTile(i));
            float y = (float)MapUtils.get31LatitudeY(this.getPoint31YTile(i));
            b.append(y).append(" / ").append(x).append(" , ");
        }
        return b.toString();
    }

    public String toString() {
        String name;
        Object str = String.format("Road (%d)", this.id / 64L);
        String rf = this.getRef("", false, true);
        if (!Algorithms.isEmpty(rf)) {
            str = (String)str + ", ref ('" + rf + "')";
        }
        if (!Algorithms.isEmpty(name = this.getName())) {
            str = (String)str + ", name ('" + name + "')";
        }
        return str;
    }

    public boolean hasNameTagStartsWith(String tagStartsWith) {
        for (int nm = 0; this.nameIds != null && nm < this.nameIds.length; ++nm) {
            BinaryMapRouteReaderAdapter.RouteTypeRule rtr = this.region.quickGetEncodingRule(this.nameIds[nm]);
            if (rtr == null || !rtr.getTag().startsWith(tagStartsWith)) continue;
            return true;
        }
        return false;
    }

    public void setRestriction(int k, long to, int type, long viaWay) {
        long valto;
        if (this.restrictions == null) {
            this.restrictions = new long[k + 1];
        }
        if (this.restrictions.length <= k) {
            long[] copy = this.restrictions;
            this.restrictions = new long[k + 1];
            for (int i = 0; i < copy.length; ++i) {
                this.restrictions[i] = copy[i];
            }
        }
        this.restrictions[k] = valto = to << 3 | (long)type & 7L;
        if (viaWay != 0L) {
            this.setRestrictionVia(k, viaWay);
        }
    }

    public void setRestrictionVia(int k, long viaWay) {
        if (this.restrictionsVia != null) {
            long[] nrestrictionsVia = new long[Math.max(k + 1, this.restrictions.length)];
            System.arraycopy(this.restrictions, 0, nrestrictionsVia, 0, this.restrictions.length);
            this.restrictionsVia = nrestrictionsVia;
        } else {
            this.restrictionsVia = new long[k + 1];
        }
        this.restrictionsVia[k] = viaWay;
    }

    public void setPointNames(int pntInd, int[] array, String[] nms) {
        if (this.pointNameTypes == null || this.pointNameTypes.length <= pntInd) {
            int[][] npointTypes = new int[pntInd + 1][];
            String[][] npointNames = new String[pntInd + 1][];
            for (int k = 0; this.pointNameTypes != null && k < this.pointNameTypes.length; ++k) {
                npointTypes[k] = this.pointNameTypes[k];
                npointNames[k] = this.pointNames[k];
            }
            this.pointNameTypes = npointTypes;
            this.pointNames = npointNames;
        }
        this.pointNameTypes[pntInd] = array;
        this.pointNames[pntInd] = nms;
    }

    public void setPointTypes(int pntInd, int[] array) {
        if (this.pointTypes == null || this.pointTypes.length <= pntInd) {
            int[][] npointTypes = new int[pntInd + 1][];
            for (int k = 0; this.pointTypes != null && k < this.pointTypes.length; ++k) {
                npointTypes[k] = this.pointTypes[k];
            }
            this.pointTypes = npointTypes;
        }
        this.pointTypes[pntInd] = array;
    }

    public boolean hasPointType(int pntId, int type) {
        for (int k = 0; this.pointTypes != null && this.pointTypes[pntId] != null && k < this.pointTypes[pntId].length; ++k) {
            if (this.pointTypes[pntId][k] != type) continue;
            return true;
        }
        return false;
    }

    public boolean containsType(int cachedType) {
        if (cachedType != -1) {
            for (int i = 0; i < this.types.length; ++i) {
                if (this.types[i] != cachedType) continue;
                return true;
            }
        }
        return false;
    }

    public static class RestrictionInfo {
        public int type;
        public long toWay;
        public long viaWay;
        public RestrictionInfo next;

        public int length() {
            if (this.next == null) {
                return 1;
            }
            return this.next.length() + 1;
        }
    }
}

