/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import java.util.Locale;
import java.util.Map;
import net.osmand.NativeLibrary;
import net.osmand.data.Amenity;
import net.osmand.data.MapObject;
import net.osmand.osm.edit.Entity;
import net.osmand.util.Algorithms;

public class ObfConstants {
    public static final int SHIFT_MULTIPOLYGON_IDS = 43;
    public static final int SHIFT_NON_SPLIT_EXISTING_IDS = 41;
    public static final int SHIFT_PROPAGATED_NODE_IDS = 50;
    public static final int SHIFT_PROPAGATED_NODES_BITS = 11;
    public static final long MAX_ID_PROPAGATED_NODES = 2047L;
    public static final long RELATION_BIT = 0x40000000000L;
    public static final long PROPAGATE_NODE_BIT = 0x2000000000000L;
    public static final long SPLIT_BIT = 0x10000000000L;
    public static final int DUPLICATE_SPLIT = 5;

    public static String getOsmUrlForId(MapObject mapObject) {
        Entity.EntityType type = ObfConstants.getOsmEntityType(mapObject);
        if (type != null) {
            long osmId = ObfConstants.getOsmObjectId(mapObject);
            return "https://www.openstreetmap.org/" + type.name().toLowerCase(Locale.US) + "/" + osmId;
        }
        return "";
    }

    public static long getOsmObjectId(MapObject object) {
        long originalId = -1L;
        Long id = object.getId();
        if (id != null) {
            if (object instanceof NativeLibrary.RenderedObject) {
                id = id >> 1;
            }
            if (ObfConstants.isIdFromPropagatedNode(id)) {
                long shifted = id & 0xFFFDFFFFFFFFFFFFL;
                originalId = shifted >> 11;
            } else if (ObfConstants.isShiftedID(id)) {
                originalId = ObfConstants.getOsmId(id);
            } else {
                int shift = object instanceof Amenity ? 1 : 6;
                originalId = id >> shift;
            }
        }
        return originalId;
    }

    public static Entity.EntityType getOsmEntityType(MapObject object) {
        if (ObfConstants.isOsmUrlAvailable(object)) {
            Long id = object.getId();
            long originalId = id >> 1;
            if (object instanceof NativeLibrary.RenderedObject && ObfConstants.isIdFromPropagatedNode(originalId)) {
                return Entity.EntityType.WAY;
            }
            if (ObfConstants.isIdFromPropagatedNode(id)) {
                return Entity.EntityType.WAY;
            }
            long relationShift = 0x20000000000L;
            if (originalId > relationShift) {
                return Entity.EntityType.RELATION;
            }
            return id % 2L == 1L ? Entity.EntityType.WAY : Entity.EntityType.NODE;
        }
        return null;
    }

    public static String getPrintTags(NativeLibrary.RenderedObject renderedObject) {
        StringBuilder s = new StringBuilder();
        for (Map.Entry<String, String> entry : renderedObject.getTags().entrySet()) {
            boolean anyPresent;
            String key = entry.getKey();
            String value = entry.getValue();
            boolean keyEmpty = Algorithms.isEmpty(key);
            boolean valueEmpty = Algorithms.isEmpty(value);
            boolean bothPresent = !keyEmpty && !valueEmpty;
            boolean bl = anyPresent = !keyEmpty || !valueEmpty;
            if (!keyEmpty) {
                s.append(key);
            }
            if (bothPresent) {
                s.append(":");
            }
            if (!valueEmpty) {
                s.append(value);
            }
            if (!anyPresent) continue;
            s.append(" ");
        }
        return s.toString().trim();
    }

    public static boolean isOsmUrlAvailable(MapObject object) {
        Long id = object.getId();
        return id != null && id > 0L;
    }

    public static long getOsmId(long id) {
        long clearBits = 0x50000000000L;
        id = ObfConstants.isShiftedID(id) ? (id & (clearBits ^ 0xFFFFFFFFFFFFFFFFL)) >> 5 : id;
        return id >> 6;
    }

    public static boolean isShiftedID(long id) {
        return ObfConstants.isIdFromRelation(id) || ObfConstants.isIdFromSplit(id);
    }

    public static boolean isIdFromRelation(long id) {
        return id > 0L && (id & 0x40000000000L) == 0x40000000000L;
    }

    public static boolean isIdFromPropagatedNode(long id) {
        return id > 0L && (id & 0x2000000000000L) == 0x2000000000000L;
    }

    public static boolean isIdFromSplit(long id) {
        return id > 0L && (id & 0x10000000000L) == 0x10000000000L;
    }
}

