/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.WireFormat;
import gnu.trove.iterator.TLongObjectIterator;
import gnu.trove.list.array.TIntArrayList;
import gnu.trove.list.array.TLongArrayList;
import gnu.trove.map.hash.TIntObjectHashMap;
import gnu.trove.map.hash.TLongObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.osmand.PlatformUtil;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataBundle;
import net.osmand.binary.RouteDataObject;
import net.osmand.binary.StringExternalizable;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import net.osmand.util.OpeningHoursParser;
import org.apache.commons.logging.Log;

public class BinaryMapRouteReaderAdapter {
    protected static final Log LOG = PlatformUtil.getLog(BinaryMapRouteReaderAdapter.class);
    private static final int SHIFT_COORDINATES = 4;
    private CodedInputStream codedIS;
    private final BinaryMapIndexReader map;

    protected BinaryMapRouteReaderAdapter(BinaryMapIndexReader map) {
        this.codedIS = map.codedIS;
        this.map = map;
    }

    private void skipUnknownField(int t) throws IOException {
        this.map.skipUnknownField(t);
    }

    private long readInt() throws IOException {
        return this.map.readInt();
    }

    protected void readRouteIndex(RouteRegion region) throws IOException {
        int routeEncodingRule = 1;
        long routeEncodingRulesSize = 0L;
        block7: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    region.completeRouteEncodingRules();
                    return;
                }
                case 1: {
                    region.name = this.codedIS.readString();
                    continue block7;
                }
                case 2: {
                    int len = this.codedIS.readInt32();
                    if (routeEncodingRulesSize == 0L) {
                        routeEncodingRulesSize = this.codedIS.getTotalBytesRead();
                    }
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    this.readRouteEncodingRule(region, routeEncodingRule++);
                    this.codedIS.popLimit(oldLimit);
                    region.routeEncodingRulesBytes = (int)(this.codedIS.getTotalBytesRead() - routeEncodingRulesSize);
                    continue block7;
                }
                case 3: 
                case 4: {
                    RouteSubregion subregion = new RouteSubregion(region);
                    subregion.length = this.readInt();
                    subregion.filePointer = this.codedIS.getTotalBytesRead();
                    long oldLimit = this.codedIS.pushLimitLong(subregion.length);
                    this.readRouteTree(subregion, null, 0, true);
                    if (tag == 3) {
                        exist = false;
                        for (RouteSubregion s : region.subregions) {
                            if (s.filePointer != subregion.filePointer) continue;
                            exist = true;
                            break;
                        }
                        if (!exist) {
                            region.subregions.add(subregion);
                        }
                    } else {
                        exist = false;
                        for (RouteSubregion s : region.basesubregions) {
                            if (s.filePointer != subregion.filePointer) continue;
                            exist = true;
                            break;
                        }
                        if (!exist) {
                            region.basesubregions.add(subregion);
                        }
                    }
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    this.codedIS.popLimit(oldLimit);
                    continue block7;
                }
                case 5: {
                    this.codedIS.skipRawBytes(this.codedIS.getBytesUntilLimit());
                    continue block7;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private RouteDataObject readRouteDataObject(RouteRegion reg, int pleftx, int ptopy) throws IOException {
        RouteDataObject o = new RouteDataObject(reg);
        TIntArrayList pointsX = new TIntArrayList();
        TIntArrayList pointsY = new TIntArrayList();
        TIntArrayList types = new TIntArrayList();
        ArrayList<TIntArrayList> globalpointTypes = new ArrayList<TIntArrayList>();
        ArrayList<TIntArrayList> globalpointNames = new ArrayList<TIntArrayList>();
        block9: while (true) {
            int ts = this.codedIS.readTag();
            int tags = WireFormat.getTagFieldNumber(ts);
            switch (tags) {
                case 0: {
                    TIntArrayList l;
                    int k;
                    o.pointsX = pointsX.toArray();
                    o.pointsY = pointsY.toArray();
                    o.types = types.toArray();
                    if (globalpointTypes.size() > 0) {
                        o.pointTypes = new int[globalpointTypes.size()][];
                        for (k = 0; k < o.pointTypes.length; ++k) {
                            l = (TIntArrayList)globalpointTypes.get(k);
                            if (l == null) continue;
                            o.pointTypes[k] = l.toArray();
                        }
                    }
                    if (globalpointNames.size() > 0) {
                        o.pointNames = new String[globalpointNames.size()][];
                        o.pointNameTypes = new int[globalpointNames.size()][];
                        for (k = 0; k < o.pointNames.length; ++k) {
                            l = (TIntArrayList)globalpointNames.get(k);
                            if (l == null) continue;
                            o.pointNameTypes[k] = new int[l.size() / 2];
                            o.pointNames[k] = new String[l.size() / 2];
                            for (int ik = 0; ik < l.size(); ik += 2) {
                                o.pointNameTypes[k][ik / 2] = l.get(ik);
                                o.pointNames[k][ik / 2] = "" + (char)l.get(ik + 1);
                            }
                        }
                    }
                    return o;
                }
                case 7: {
                    int len = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        types.add(this.codedIS.readRawVarint32());
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 14: {
                    o.names = new TIntObjectHashMap();
                    int sizeL = this.codedIS.readRawVarint32();
                    long old = this.codedIS.pushLimitLong(sizeL);
                    TIntArrayList list = new TIntArrayList();
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int stag = this.codedIS.readRawVarint32();
                        int pId = this.codedIS.readRawVarint32();
                        o.names.put(stag, (Object)("" + (char)pId));
                        list.add(stag);
                    }
                    o.nameIds = list.toArray();
                    this.codedIS.popLimit(old);
                    continue block9;
                }
                case 1: {
                    int len = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    int px = pleftx >> 4;
                    int py = ptopy >> 4;
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        int x = this.codedIS.readSInt32() + px;
                        int y = this.codedIS.readSInt32() + py;
                        pointsX.add(x << 4);
                        pointsY.add(y << 4);
                        px = x;
                        py = y;
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 5: {
                    int pointInd;
                    int len = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        pointInd = this.codedIS.readRawVarint32();
                        int pointNameType = this.codedIS.readRawVarint32();
                        int nameInd = this.codedIS.readRawVarint32();
                        while (pointInd >= globalpointNames.size()) {
                            globalpointNames.add(null);
                        }
                        if (globalpointNames.get(pointInd) == null) {
                            TIntArrayList pointTypes = new TIntArrayList();
                            globalpointNames.set(pointInd, pointTypes);
                        }
                        ((TIntArrayList)globalpointNames.get(pointInd)).add(pointNameType);
                        ((TIntArrayList)globalpointNames.get(pointInd)).add(nameInd);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 4: {
                    int pointInd;
                    int len = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(len);
                    while (this.codedIS.getBytesUntilLimit() > 0L) {
                        pointInd = this.codedIS.readRawVarint32();
                        TIntArrayList pointTypes = new TIntArrayList();
                        int lens = this.codedIS.readRawVarint32();
                        long oldLimits = this.codedIS.pushLimitLong(lens);
                        while (this.codedIS.getBytesUntilLimit() > 0L) {
                            pointTypes.add(this.codedIS.readRawVarint32());
                        }
                        this.codedIS.popLimit(oldLimits);
                        while (pointInd >= globalpointTypes.size()) {
                            globalpointTypes.add(null);
                        }
                        globalpointTypes.set(pointInd, pointTypes);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block9;
                }
                case 12: {
                    o.id = this.codedIS.readInt32();
                    continue block9;
                }
            }
            this.skipUnknownField(ts);
        }
    }

    private void readRouteTreeData(RouteSubregion routeTree, TLongArrayList idTables, TLongObjectHashMap<RouteDataObject.RestrictionInfo> restrictions) throws IOException {
        routeTree.dataObjects = new ArrayList<RouteDataObject>();
        idTables.clear();
        restrictions.clear();
        List<String> stringTable = null;
        block18: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    TLongObjectIterator it = restrictions.iterator();
                    while (it.hasNext()) {
                        it.advance();
                        int from = (int)it.key();
                        RouteDataObject fromr = routeTree.dataObjects.get(from);
                        fromr.restrictions = new long[((RouteDataObject.RestrictionInfo)it.value()).length()];
                        RouteDataObject.RestrictionInfo val = (RouteDataObject.RestrictionInfo)it.value();
                        for (int k = 0; k < fromr.restrictions.length; ++k) {
                            if (val != null) {
                                long via = 0L;
                                if (val.viaWay != 0L) {
                                    via = idTables.get((int)val.viaWay);
                                }
                                fromr.setRestriction(k, idTables.get((int)val.toWay), val.type, via);
                            }
                            val = val.next;
                        }
                    }
                    for (RouteDataObject o : routeTree.dataObjects) {
                        int j;
                        if (o == null) continue;
                        if (o.id < (long)idTables.size()) {
                            o.id = idTables.get((int)o.id);
                        }
                        if (o.names != null && stringTable != null) {
                            int[] keys = o.names.keys();
                            for (j = 0; j < keys.length; ++j) {
                                o.names.put(keys[j], (Object)stringTable.get(((String)o.names.get(keys[j])).charAt(0)));
                            }
                        }
                        if (o.pointNames == null || stringTable == null) continue;
                        String[][] stringArray = o.pointNames;
                        j = stringArray.length;
                        for (int via = 0; via < j; ++via) {
                            String[] ar = stringArray[via];
                            if (ar == null) continue;
                            for (int j2 = 0; j2 < ar.length; ++j2) {
                                ar[j2] = stringTable.get(ar[j2].charAt(0));
                            }
                        }
                    }
                    return;
                }
                case 6: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    RouteDataObject obj = this.readRouteDataObject(routeTree.routeReg, routeTree.left, routeTree.top);
                    while (obj.id >= (long)routeTree.dataObjects.size()) {
                        routeTree.dataObjects.add(null);
                    }
                    routeTree.dataObjects.set((int)obj.id, obj);
                    this.codedIS.popLimit(oldLimit);
                    continue block18;
                }
                case 5: {
                    long routeId = 0L;
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    block26: while (true) {
                        int ts = this.codedIS.readTag();
                        int tags = WireFormat.getTagFieldNumber(ts);
                        switch (tags) {
                            case 0: {
                                break block26;
                            }
                            case 1: {
                                idTables.add(routeId += this.codedIS.readSInt64());
                                continue block26;
                            }
                            default: {
                                this.skipUnknownField(ts);
                                continue block26;
                            }
                        }
                        break;
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block18;
                }
                case 7: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    RouteDataObject.RestrictionInfo ri = new RouteDataObject.RestrictionInfo();
                    long from = 0L;
                    block27: while (true) {
                        int ts = this.codedIS.readTag();
                        int tags = WireFormat.getTagFieldNumber(ts);
                        switch (tags) {
                            case 0: {
                                break block27;
                            }
                            case 2: {
                                from = this.codedIS.readInt32();
                                continue block27;
                            }
                            case 3: {
                                ri.toWay = this.codedIS.readInt32();
                                continue block27;
                            }
                            case 1: {
                                ri.type = this.codedIS.readInt32();
                                continue block27;
                            }
                            case 4: {
                                ri.viaWay = this.codedIS.readInt32();
                                continue block27;
                            }
                            default: {
                                this.skipUnknownField(ts);
                                continue block27;
                            }
                        }
                        break;
                    }
                    RouteDataObject.RestrictionInfo prev = (RouteDataObject.RestrictionInfo)restrictions.get(from);
                    if (prev != null) {
                        while (prev.next != null) {
                            prev = prev.next;
                        }
                        prev.next = ri;
                    } else {
                        restrictions.put(from, (Object)ri);
                    }
                    this.codedIS.popLimit(oldLimit);
                    continue block18;
                }
                case 8: {
                    int length = this.codedIS.readRawVarint32();
                    long oldLimit = this.codedIS.pushLimitLong(length);
                    stringTable = this.map.readStringTable();
                    this.codedIS.popLimit(oldLimit);
                    continue block18;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private void readRouteEncodingRule(RouteRegion index, int id) throws IOException {
        String tags = null;
        String val = null;
        block6: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    index.initRouteEncodingRule(id, tags, val);
                    return;
                }
                case 5: {
                    val = this.codedIS.readString().intern();
                    continue block6;
                }
                case 3: {
                    tags = this.codedIS.readString().intern();
                    continue block6;
                }
                case 7: {
                    id = this.codedIS.readUInt32();
                    continue block6;
                }
            }
            this.skipUnknownField(t);
        }
    }

    private RouteSubregion readRouteTree(RouteSubregion thisTree, RouteSubregion parentTree, int depth, boolean readCoordinates) throws IOException {
        boolean readChildren;
        boolean bl = readChildren = depth != 0;
        if (readChildren) {
            thisTree.subregions = new ArrayList<RouteSubregion>();
        }
        ++thisTree.routeReg.regionsRead;
        block9: while (true) {
            int t = this.codedIS.readTag();
            int tag = WireFormat.getTagFieldNumber(t);
            switch (tag) {
                case 0: {
                    return thisTree;
                }
                case 1: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.left = i + (parentTree != null ? parentTree.left : 0);
                    continue block9;
                }
                case 2: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.right = i + (parentTree != null ? parentTree.right : 0);
                    continue block9;
                }
                case 3: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.top = i + (parentTree != null ? parentTree.top : 0);
                    continue block9;
                }
                case 4: {
                    int i = this.codedIS.readSInt32();
                    if (!readCoordinates) continue block9;
                    thisTree.bottom = i + (parentTree != null ? parentTree.bottom : 0);
                    continue block9;
                }
                case 5: {
                    thisTree.shiftToData = this.readInt();
                    if (readChildren) continue block9;
                    thisTree.subregions = new ArrayList<RouteSubregion>();
                    readChildren = true;
                    continue block9;
                }
                case 7: {
                    if (readChildren) {
                        RouteSubregion subregion = new RouteSubregion(thisTree.routeReg);
                        subregion.length = this.readInt();
                        subregion.filePointer = this.codedIS.getTotalBytesRead();
                        long oldLimit = this.codedIS.pushLimitLong(subregion.length);
                        this.readRouteTree(subregion, thisTree, depth - 1, true);
                        thisTree.subregions.add(subregion);
                        this.codedIS.popLimit(oldLimit);
                        this.codedIS.seek(subregion.filePointer + subregion.length);
                        continue block9;
                    }
                    this.codedIS.seek(thisTree.filePointer + thisTree.length);
                    continue block9;
                }
            }
            this.skipUnknownField(t);
        }
    }

    public void initRouteTypesIfNeeded(BinaryMapIndexReader.SearchRequest<?> req, List<RouteSubregion> list) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            this.initRouteRegion(rs.routeReg);
        }
    }

    public void initRouteRegion(RouteRegion routeReg) throws IOException, InvalidProtocolBufferException {
        if (routeReg.routeEncodingRules.isEmpty()) {
            this.codedIS.seek(routeReg.filePointer);
            long oldLimit = this.codedIS.pushLimitLong(routeReg.length);
            this.readRouteIndex(routeReg);
            this.codedIS.popLimit(oldLimit);
        }
    }

    public List<RouteDataObject> loadRouteRegionData(RouteSubregion rs) throws IOException {
        TLongArrayList idMap = new TLongArrayList();
        TLongObjectHashMap restrictionMap = new TLongObjectHashMap();
        if (rs.dataObjects == null) {
            this.codedIS.seek(rs.filePointer + rs.shiftToData);
            int limit = this.codedIS.readRawVarint32();
            long oldLimit = this.codedIS.pushLimitLong(limit);
            this.readRouteTreeData(rs, idMap, (TLongObjectHashMap<RouteDataObject.RestrictionInfo>)restrictionMap);
            this.codedIS.popLimit(oldLimit);
        }
        List<RouteDataObject> res = rs.dataObjects;
        rs.dataObjects = null;
        return res;
    }

    public void loadRouteRegionData(List<RouteSubregion> toLoad, ResultMatcher<RouteDataObject> matcher) throws IOException {
        Collections.sort(toLoad, new Comparator<RouteSubregion>(){

            @Override
            public int compare(RouteSubregion o1, RouteSubregion o2) {
                long p1 = o1.filePointer + o1.shiftToData;
                long p2 = o2.filePointer + o2.shiftToData;
                return p1 == p2 ? 0 : (p1 < p2 ? -1 : 1);
            }
        });
        TLongArrayList idMap = new TLongArrayList();
        TLongObjectHashMap restrictionMap = new TLongObjectHashMap();
        for (RouteSubregion rs : toLoad) {
            if (rs.dataObjects == null) {
                this.codedIS.seek(rs.filePointer + rs.shiftToData);
                int limit = this.codedIS.readRawVarint32();
                long oldLimit = this.codedIS.pushLimitLong(limit);
                this.readRouteTreeData(rs, idMap, (TLongObjectHashMap<RouteDataObject.RestrictionInfo>)restrictionMap);
                this.codedIS.popLimit(oldLimit);
            }
            for (RouteDataObject ro : rs.dataObjects) {
                if (ro != null) {
                    matcher.publish(ro);
                }
                if (!matcher.isCancelled()) continue;
                break;
            }
            rs.dataObjects = null;
            if (!matcher.isCancelled()) continue;
            break;
        }
    }

    public List<RouteSubregion> searchRouteRegionTree(BinaryMapIndexReader.SearchRequest<?> req, List<RouteSubregion> list, List<RouteSubregion> toLoad) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            if (rs.subregions == null) {
                this.codedIS.seek(rs.filePointer);
                long old = this.codedIS.pushLimitLong(rs.length);
                this.readRouteTree(rs, null, req.contains(rs.left, rs.top, rs.right, rs.bottom) ? -1 : 1, false);
                this.codedIS.popLimit(old);
            }
            this.searchRouteRegionTree(req, rs.subregions, toLoad);
            if (rs.shiftToData == 0L) continue;
            toLoad.add(rs);
        }
        return toLoad;
    }

    public List<RouteSubregion> loadInteresectedPoints(BinaryMapIndexReader.SearchRequest<RouteDataObject> req, List<RouteSubregion> list, List<RouteSubregion> toLoad) throws IOException {
        for (RouteSubregion rs : list) {
            if (!req.intersects(rs.left, rs.top, rs.right, rs.bottom)) continue;
            if (rs.subregions == null) {
                this.codedIS.seek(rs.filePointer);
                long old = this.codedIS.pushLimitLong(rs.length);
                this.readRouteTree(rs, null, req.contains(rs.left, rs.top, rs.right, rs.bottom) ? -1 : 1, false);
                this.codedIS.popLimit(old);
            }
            this.searchRouteRegionTree(req, rs.subregions, toLoad);
            if (rs.shiftToData == 0L) continue;
            toLoad.add(rs);
        }
        return toLoad;
    }

    public static class RouteRegion
    extends BinaryIndexPart {
        public int regionsRead;
        public List<RouteTypeRule> routeEncodingRules = new ArrayList<RouteTypeRule>();
        public int routeEncodingRulesBytes = 0;
        public Map<String, Integer> decodingRules = null;
        List<RouteSubregion> subregions = new ArrayList<RouteSubregion>();
        List<RouteSubregion> basesubregions = new ArrayList<RouteSubregion>();
        public int directionForward = -1;
        public int directionBackward = -1;
        public int maxheightForward = -1;
        public int maxheightBackward = -1;
        public int directionTrafficSignalsForward = -1;
        public int directionTrafficSignalsBackward = -1;
        public int trafficSignals = -1;
        public int stopSign = -1;
        public int stopMinor = -1;
        public int giveWaySign = -1;
        int nameTypeRule = -1;
        int refTypeRule = -1;
        int destinationTypeRule = -1;
        int destinationRefTypeRule = -1;
        private RouteRegion referenceRouteRegion;

        @Override
        public String getPartName() {
            return "Routing";
        }

        @Override
        public int getFieldNumber() {
            return 9;
        }

        public int searchRouteEncodingRule(String tag, String value) {
            String k;
            if (this.decodingRules == null) {
                this.decodingRules = new LinkedHashMap<String, Integer>();
                for (int i = 1; i < this.routeEncodingRules.size(); ++i) {
                    RouteTypeRule rt = this.routeEncodingRules.get(i);
                    String ks = rt.getTag() + "#" + (rt.getValue() == null ? "" : rt.getValue());
                    this.decodingRules.put(ks, i);
                }
            }
            if (this.decodingRules.containsKey(k = tag + "#" + (value == null ? "" : value))) {
                return this.decodingRules.get(k);
            }
            return -1;
        }

        public int getNameTypeRule() {
            return this.nameTypeRule;
        }

        public int getRefTypeRule() {
            return this.refTypeRule;
        }

        public RouteTypeRule quickGetEncodingRule(int id) {
            return this.routeEncodingRules.get(id);
        }

        public int quickGetEncodingRulesSize() {
            return this.routeEncodingRules.size();
        }

        public void initRouteEncodingRule(int id, String tags, String val) {
            this.decodingRules = null;
            while (this.routeEncodingRules.size() <= id) {
                this.routeEncodingRules.add(null);
            }
            this.routeEncodingRules.set(id, new RouteTypeRule(tags, val));
            if (tags.equals("name")) {
                this.nameTypeRule = id;
            } else if (tags.equals("ref")) {
                this.refTypeRule = id;
            } else if (tags.equals("destination") || tags.equals("destination:forward") || tags.equals("destination:backward") || tags.startsWith("destination:lang:")) {
                this.destinationTypeRule = id;
            } else if (tags.equals("destination:ref") || tags.equals("destination:ref:forward") || tags.equals("destination:ref:backward")) {
                this.destinationRefTypeRule = id;
            } else if (tags.equals("highway") && val.equals("traffic_signals")) {
                this.trafficSignals = id;
            } else if (tags.equals("stop") && val.equals("minor")) {
                this.stopMinor = id;
            } else if (tags.equals("highway") && val.equals("stop")) {
                this.stopSign = id;
            } else if (tags.equals("highway") && val.equals("give_way")) {
                this.giveWaySign = id;
            } else if (tags.equals("traffic_signals:direction") && val != null) {
                if (val.equals("forward")) {
                    this.directionTrafficSignalsForward = id;
                } else if (val.equals("backward")) {
                    this.directionTrafficSignalsBackward = id;
                }
            } else if (tags.equals("direction") && val != null) {
                if (val.equals("forward")) {
                    this.directionForward = id;
                } else if (val.equals("backward")) {
                    this.directionBackward = id;
                }
            } else if (tags.equals("maxheight:forward") && val != null) {
                this.maxheightForward = id;
            } else if (tags.equals("maxheight:backward") && val != null) {
                this.maxheightBackward = id;
            }
        }

        public void completeRouteEncodingRules() {
            for (int i = 0; i < this.routeEncodingRules.size(); ++i) {
                RouteTypeRule rtr = this.routeEncodingRules.get(i);
                if (rtr == null || !rtr.conditional()) continue;
                String tag = rtr.getNonConditionalTag();
                for (RouteTypeCondition c : rtr.conditions) {
                    if (tag == null || c.value == null) continue;
                    c.ruleid = this.findOrCreateRouteType(tag, c.value);
                }
            }
        }

        public List<RouteSubregion> getSubregions() {
            return this.subregions;
        }

        public List<RouteSubregion> getBaseSubregions() {
            return this.basesubregions;
        }

        public double getLeftLongitude() {
            double l = 180.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.min(l, MapUtils.get31LongitudeX(s.left));
            }
            return l;
        }

        public double getRightLongitude() {
            double l = -180.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.max(l, MapUtils.get31LongitudeX(s.right));
            }
            return l;
        }

        public double getBottomLatitude() {
            double l = 90.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.min(l, MapUtils.get31LatitudeY(s.bottom));
            }
            return l;
        }

        public double getTopLatitude() {
            double l = -90.0;
            for (RouteSubregion s : this.subregions) {
                l = Math.max(l, MapUtils.get31LatitudeY(s.top));
            }
            return l;
        }

        public boolean contains(int x31, int y31) {
            for (RouteSubregion s : this.subregions) {
                if (s.left > x31 || s.right < x31 || s.top > y31 || s.bottom < y31) continue;
                return true;
            }
            return false;
        }

        public RouteDataObject adopt(RouteDataObject o) {
            int ruleId;
            int ruleId2;
            int i;
            if (o.region == this || o.region == this.referenceRouteRegion) {
                return o;
            }
            if (this.routeEncodingRules.isEmpty()) {
                this.routeEncodingRules.addAll(o.region.routeEncodingRules);
                this.referenceRouteRegion = o.region;
                return o;
            }
            RouteDataObject rdo = new RouteDataObject(this);
            rdo.pointsX = o.pointsX;
            rdo.pointsY = o.pointsY;
            rdo.id = o.id;
            rdo.restrictions = o.restrictions;
            rdo.restrictionsVia = o.restrictionsVia;
            if (o.types != null) {
                rdo.types = new int[o.types.length];
                for (i = 0; i < o.types.length; ++i) {
                    RouteTypeRule tp = o.region.routeEncodingRules.get(o.types[i]);
                    rdo.types[i] = ruleId2 = this.findOrCreateRouteType(tp.getTag(), tp.getValue());
                }
            }
            if (o.pointTypes != null) {
                rdo.pointTypes = new int[o.pointTypes.length][];
                for (i = 0; i < o.pointTypes.length; ++i) {
                    if (o.pointTypes[i] == null) continue;
                    rdo.pointTypes[i] = new int[o.pointTypes[i].length];
                    for (int j = 0; j < o.pointTypes[i].length; ++j) {
                        RouteTypeRule tp = o.region.routeEncodingRules.get(o.pointTypes[i][j]);
                        ruleId = this.searchRouteEncodingRule(tp.getTag(), tp.getValue());
                        if (ruleId != -1) {
                            rdo.pointTypes[i][j] = ruleId;
                            continue;
                        }
                        ruleId = this.routeEncodingRules.size();
                        this.initRouteEncodingRule(ruleId, tp.getTag(), tp.getValue());
                        rdo.pointTypes[i][j] = ruleId;
                    }
                }
            }
            if (o.nameIds != null) {
                rdo.nameIds = new int[o.nameIds.length];
                rdo.names = new TIntObjectHashMap();
                for (i = 0; i < o.nameIds.length; ++i) {
                    RouteTypeRule tp = o.region.routeEncodingRules.get(o.nameIds[i]);
                    ruleId2 = this.searchRouteEncodingRule(tp.getTag(), null);
                    if (ruleId2 != -1) {
                        rdo.nameIds[i] = ruleId2;
                    } else {
                        ruleId2 = this.routeEncodingRules.size();
                        this.initRouteEncodingRule(ruleId2, tp.getTag(), null);
                        rdo.nameIds[i] = ruleId2;
                    }
                    rdo.names.put(ruleId2, (Object)((String)o.names.get(o.nameIds[i])));
                }
            }
            rdo.pointNames = o.pointNames;
            if (o.pointNameTypes != null) {
                rdo.pointNameTypes = new int[o.pointNameTypes.length][];
                for (i = 0; i < o.pointNameTypes.length; ++i) {
                    if (o.pointNameTypes[i] == null) continue;
                    rdo.pointNameTypes[i] = new int[o.pointNameTypes[i].length];
                    for (int j = 0; j < o.pointNameTypes[i].length; ++j) {
                        RouteTypeRule tp = o.region.routeEncodingRules.get(o.pointNameTypes[i][j]);
                        ruleId = this.searchRouteEncodingRule(tp.getTag(), null);
                        if (ruleId != -1) {
                            rdo.pointNameTypes[i][j] = ruleId;
                            continue;
                        }
                        ruleId = this.routeEncodingRules.size();
                        this.initRouteEncodingRule(ruleId, tp.getTag(), tp.getValue());
                        rdo.pointNameTypes[i][j] = ruleId;
                    }
                }
            }
            return rdo;
        }

        public int findOrCreateRouteType(String tag, String value) {
            int ruleId = this.searchRouteEncodingRule(tag, value);
            if (ruleId == -1) {
                ruleId = this.routeEncodingRules.size();
                this.initRouteEncodingRule(ruleId, tag, value);
            }
            return ruleId;
        }
    }

    public static class RouteSubregion {
        private static final int INT_SIZE = 4;
        public final RouteRegion routeReg;
        public long length;
        public long filePointer;
        public int left;
        public int right;
        public int top;
        public int bottom;
        public long shiftToData;
        public List<RouteSubregion> subregions = null;
        public List<RouteDataObject> dataObjects = null;

        public RouteSubregion(RouteSubregion copy) {
            this.routeReg = copy.routeReg;
            this.left = copy.left;
            this.right = copy.right;
            this.top = copy.top;
            this.bottom = copy.bottom;
            this.filePointer = copy.filePointer;
            this.length = copy.length;
        }

        public RouteSubregion(RouteRegion routeReg) {
            this.routeReg = routeReg;
        }

        public int getEstimatedSize() {
            int shallow = 40;
            if (this.subregions != null) {
                shallow += 8;
                for (RouteSubregion s : this.subregions) {
                    shallow += s.getEstimatedSize();
                }
            }
            return shallow;
        }

        public int countSubregions() {
            int cnt = 1;
            if (this.subregions != null) {
                for (RouteSubregion s : this.subregions) {
                    cnt += s.countSubregions();
                }
            }
            return cnt;
        }
    }

    public static class RouteTypeRule
    implements StringExternalizable<RouteDataBundle> {
        private static final int ACCESS = 1;
        private static final int ONEWAY = 2;
        private static final int HIGHWAY_TYPE = 3;
        private static final int MAXSPEED = 4;
        private static final int ROUNDABOUT = 5;
        public static final int TRAFFIC_SIGNALS = 6;
        public static final int RAILWAY_CROSSING = 7;
        private static final int LANES = 8;
        public static final int PROFILE_NONE = 0;
        public static final int PROFILE_TRUCK = 1000;
        public static final int PROFILE_CAR = 1001;
        private String t;
        private String v;
        private int intValue;
        private float floatValue;
        private int type;
        private List<RouteTypeCondition> conditions = null;
        private int forward;

        public RouteTypeRule() {
        }

        public RouteTypeRule(String t, String v) {
            this.t = t.intern();
            if ("true".equals(v)) {
                v = "yes";
            }
            if ("false".equals(v)) {
                v = "no";
            }
            this.v = v == null ? null : v.intern();
            try {
                this.analyze();
            }
            catch (RuntimeException e) {
                System.err.println("Error analyzing tag/value = " + t + "/" + v);
                throw e;
            }
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.t == null ? 0 : this.t.hashCode());
            result = 31 * result + (this.v == null ? 0 : this.v.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RouteTypeRule other = (RouteTypeRule)obj;
            return Algorithms.objectEquals(other.t, this.t) && Algorithms.objectEquals(other.v, this.v);
        }

        @Override
        public void writeToBundle(RouteDataBundle bundle) {
            bundle.putString("t", this.t);
            if (this.v != null) {
                bundle.putString("v", this.v);
            }
        }

        @Override
        public void readFromBundle(RouteDataBundle bundle) {
            this.t = bundle.getString("t", null);
            this.v = bundle.getString("v", null);
            try {
                this.analyze();
            }
            catch (RuntimeException e) {
                System.err.println("Error analyzing tag/value = " + this.t + "/" + this.v);
                throw e;
            }
        }

        public String toString() {
            return this.t + "=" + this.v;
        }

        public int isForward() {
            return this.forward;
        }

        public String getTag() {
            return this.t;
        }

        public String getValue() {
            return this.v;
        }

        public boolean roundabout() {
            return this.type == 5;
        }

        public int getType() {
            return this.type;
        }

        public boolean conditional() {
            return this.conditions != null;
        }

        public String getNonConditionalTag() {
            String tag = this.getTag();
            if (tag != null && tag.endsWith(":conditional")) {
                tag = tag.substring(0, tag.length() - ":conditional".length());
            }
            return tag;
        }

        public int onewayDirection() {
            if (this.type == 2) {
                return this.intValue;
            }
            return 0;
        }

        public int conditionalValue(long time) {
            if (this.conditional()) {
                Calendar i = Calendar.getInstance();
                i.setTimeInMillis(time);
                for (RouteTypeCondition c : this.conditions) {
                    if (c.hours == null || !c.hours.isOpenedForTime(i)) continue;
                    return c.ruleid;
                }
            }
            return 0;
        }

        public float maxSpeed(int profile) {
            if (this.type == 4 + profile) {
                return this.floatValue;
            }
            return -1.0f;
        }

        public int lanes() {
            if (this.type == 8) {
                return this.intValue;
            }
            return -1;
        }

        public String highwayRoad() {
            if (this.type == 3) {
                return this.v;
            }
            return null;
        }

        private void analyze() {
            if (this.t.equalsIgnoreCase("oneway")) {
                this.type = 2;
                this.intValue = "-1".equals(this.v) || "reverse".equals(this.v) ? -1 : ("1".equals(this.v) || "yes".equals(this.v) ? 1 : 0);
            } else if (this.t.equalsIgnoreCase("highway") && "traffic_signals".equals(this.v)) {
                this.type = 6;
            } else if (this.t.equalsIgnoreCase("railway") && ("crossing".equals(this.v) || "level_crossing".equals(this.v))) {
                this.type = 7;
            } else if (this.t.equalsIgnoreCase("roundabout") && this.v != null) {
                this.type = 5;
            } else if (this.t.equalsIgnoreCase("junction") && "roundabout".equalsIgnoreCase(this.v)) {
                this.type = 5;
            } else if (this.t.equalsIgnoreCase("highway") && this.v != null) {
                this.type = 3;
            } else if (this.t.endsWith(":conditional") && this.v != null) {
                String[] cts;
                this.conditions = new ArrayList<RouteTypeCondition>();
                for (String c : cts = this.v.split("\\);")) {
                    int ch = c.indexOf(64);
                    if (ch <= 0) continue;
                    RouteTypeCondition cond = new RouteTypeCondition();
                    cond.value = c.substring(0, ch).trim();
                    cond.condition = c.substring(ch + 1).trim();
                    if (cond.condition.startsWith("(")) {
                        cond.condition = cond.condition.substring(1, cond.condition.length()).trim();
                    }
                    if (cond.condition.endsWith(")")) {
                        cond.condition = cond.condition.substring(0, cond.condition.length() - 1).trim();
                    }
                    cond.hours = OpeningHoursParser.parseOpenedHours(cond.condition);
                    this.conditions.add(cond);
                }
            } else if (this.t.startsWith("access") && this.v != null) {
                this.type = 1;
            } else if (this.t.startsWith("maxspeed") && this.v != null) {
                String tg = this.t;
                if (this.t.endsWith(":forward")) {
                    tg = this.t.substring(0, this.t.length() - ":forward".length());
                    this.forward = 1;
                } else if (this.t.endsWith(":backward")) {
                    tg = this.t.substring(0, this.t.length() - ":backward".length());
                    this.forward = -1;
                } else {
                    this.forward = 0;
                }
                this.floatValue = RouteDataObject.parseSpeed(this.v, 0.0f);
                if (tg.equalsIgnoreCase("maxspeed")) {
                    this.type = 4;
                } else if (tg.equalsIgnoreCase("maxspeed:hgv")) {
                    this.type = 1004;
                } else if (tg.equalsIgnoreCase("maxspeed:motorcar")) {
                    this.type = 1005;
                }
            } else if (this.t.equalsIgnoreCase("lanes") && this.v != null) {
                int i;
                this.intValue = -1;
                this.type = 8;
                for (i = 0; i < this.v.length() && Character.isDigit(this.v.charAt(i)); ++i) {
                }
                if (i > 0) {
                    this.intValue = Integer.parseInt(this.v.substring(0, i));
                }
            }
        }
    }

    private static class RouteTypeCondition
    implements StringExternalizable<RouteDataBundle> {
        String condition = "";
        OpeningHoursParser.OpeningHours hours = null;
        String value;
        int ruleid;

        private RouteTypeCondition() {
        }

        @Override
        public void writeToBundle(RouteDataBundle bundle) {
            bundle.putString("c", this.condition);
            bundle.putString("v", this.value);
            bundle.putInt("id", this.ruleid);
        }

        @Override
        public void readFromBundle(RouteDataBundle bundle) {
        }
    }
}

