/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Period {
    private static final Pattern PATTERN = Pattern.compile("^P(?:([-+]?[0-9]+)([YMWD]))?$", 2);
    private PeriodUnit unit;
    private final int numberOfUnits;

    public static Period ofYears(int years) {
        return new Period(PeriodUnit.YEAR, years);
    }

    public static Period ofMonths(int months) {
        return new Period(PeriodUnit.MONTH, months);
    }

    public static Period ofWeeks(int weeks) {
        return new Period(PeriodUnit.WEEK, weeks);
    }

    public static Period ofDays(int days) {
        return new Period(PeriodUnit.DAY, days);
    }

    public PeriodUnit getUnit() {
        return this.unit;
    }

    public int getNumberOfUnits() {
        return this.numberOfUnits;
    }

    public static Period parse(CharSequence text) throws ParseException {
        Matcher matcher = PATTERN.matcher(text);
        if (matcher.matches()) {
            String numberOfUnitsMatch = matcher.group(1);
            String unitMatch = matcher.group(2);
            if (numberOfUnitsMatch != null && unitMatch != null) {
                try {
                    int numberOfUnits = Period.parseNumber(numberOfUnitsMatch);
                    PeriodUnit unit = PeriodUnit.parseUnit(unitMatch);
                    return new Period(unit, numberOfUnits);
                }
                catch (IllegalArgumentException ex) {
                    throw new ParseException("Text cannot be parsed to a Period: " + text, 0);
                }
            }
        }
        throw new ParseException("Text cannot be parsed to a Period: " + text, 0);
    }

    private static int parseNumber(String str) throws ParseException {
        if (str == null) {
            return 0;
        }
        return Integer.parseInt(str);
    }

    public Period(PeriodUnit unit, int numberOfUnits) {
        if (unit == null) {
            throw new IllegalArgumentException("PeriodUnit cannot be null");
        }
        this.unit = unit;
        this.numberOfUnits = numberOfUnits;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Period) {
            Period other = (Period)obj;
            return this.unit.ordinal() == other.unit.ordinal() && this.numberOfUnits == other.numberOfUnits;
        }
        return false;
    }

    public int hashCode() {
        return this.unit.ordinal() + Integer.rotateLeft(this.numberOfUnits, 8);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append('P').append(this.numberOfUnits);
        switch (this.unit) {
            case YEAR: {
                buf.append('Y');
                break;
            }
            case MONTH: {
                buf.append('M');
                break;
            }
            case WEEK: {
                buf.append('W');
                break;
            }
            case DAY: {
                buf.append('D');
            }
        }
        return buf.toString();
    }

    public static enum PeriodUnit {
        YEAR("Y", 1),
        MONTH("M", 2),
        WEEK("W", 3),
        DAY("D", 5);

        private String unitStr;
        private int calendarIdx;

        private PeriodUnit(String unitStr, int calendarIdx) {
            this.calendarIdx = calendarIdx;
            this.unitStr = unitStr;
        }

        public String getUnitStr() {
            return this.unitStr;
        }

        public int getCalendarIdx() {
            return this.calendarIdx;
        }

        public double getMonthsValue() {
            switch (this) {
                case YEAR: {
                    return 12.0;
                }
                case MONTH: {
                    return 1.0;
                }
                case WEEK: {
                    return 0.25;
                }
                case DAY: {
                    return 0.03333333333333333;
                }
            }
            return 0.0;
        }

        public static PeriodUnit parseUnit(String unitStr) {
            for (PeriodUnit unit : PeriodUnit.values()) {
                if (!unit.unitStr.equals(unitStr)) continue;
                return unit;
            }
            return null;
        }
    }
}

