/*
 * Decompiled with CFR 0.152.
 */
package net.osmand;

import java.util.ArrayList;
import java.util.List;
import net.osmand.Location;
import net.osmand.data.LatLon;
import net.osmand.gpx.GPXUtilities;
import net.osmand.util.Algorithms;

public class LocationsHolder {
    private static final int LOCATION_TYPE_UNKNOWN = -1;
    private static final int LOCATION_TYPE_LATLON = 0;
    private static final int LOCATION_TYPE_LOCATION = 1;
    private static final int LOCATION_TYPE_WPTPT = 2;
    private List<LatLon> latLonList;
    private List<Location> locationList;
    private List<GPXUtilities.WptPt> wptPtList;
    private int locationType;
    private int size;

    public LocationsHolder(List<?> locations) {
        this.locationType = this.resolveLocationType(locations);
        switch (this.locationType) {
            case 0: {
                this.latLonList = new ArrayList(locations);
                this.size = locations.size();
                break;
            }
            case 1: {
                this.locationList = new ArrayList(locations);
                this.size = locations.size();
                break;
            }
            case 2: {
                this.wptPtList = new ArrayList(locations);
                this.size = locations.size();
            }
        }
    }

    private int resolveLocationType(List<?> locations) {
        if (!Algorithms.isEmpty(locations)) {
            Object locationObj = locations.get(0);
            if (locationObj instanceof LatLon) {
                return 0;
            }
            if (locationObj instanceof GPXUtilities.WptPt) {
                return 2;
            }
            if (locationObj instanceof Location) {
                return 1;
            }
            throw new IllegalArgumentException("Unsupported location type: " + locationObj.getClass().getSimpleName());
        }
        return -1;
    }

    public double getLatitude(int index) {
        switch (this.locationType) {
            case 0: {
                return this.latLonList.get(index).getLatitude();
            }
            case 1: {
                return this.locationList.get(index).getLatitude();
            }
            case 2: {
                return this.wptPtList.get(index).getLatitude();
            }
        }
        return 0.0;
    }

    public double getLongitude(int index) {
        switch (this.locationType) {
            case 0: {
                return this.latLonList.get(index).getLongitude();
            }
            case 1: {
                return this.locationList.get(index).getLongitude();
            }
            case 2: {
                return this.wptPtList.get(index).getLongitude();
            }
        }
        return 0.0;
    }

    public int getSize() {
        return this.size;
    }

    private <T> List<T> getList(int locationType) {
        ArrayList<Object> res = new ArrayList<Object>();
        if (this.size > 0) {
            block5: for (int i = 0; i < this.size; ++i) {
                switch (locationType) {
                    case 0: {
                        res.add(this.getLatLon(i));
                        continue block5;
                    }
                    case 1: {
                        res.add(this.getLocation(i));
                        continue block5;
                    }
                    case 2: {
                        res.add(this.getWptPt(i));
                    }
                }
            }
        }
        return res;
    }

    public List<LatLon> getLatLonList() {
        if (this.locationType == 0) {
            return this.latLonList;
        }
        return this.getList(0);
    }

    public List<GPXUtilities.WptPt> getWptPtList() {
        if (this.locationType == 2) {
            return this.wptPtList;
        }
        return this.getList(2);
    }

    public List<Location> getLocationsList() {
        if (this.locationType == 1) {
            return this.locationList;
        }
        return this.getList(1);
    }

    public long getTime(int index) {
        if (this.locationType == 2) {
            return this.wptPtList.get((int)index).time;
        }
        return 0L;
    }

    public LatLon getLatLon(int index) {
        if (this.locationType == 0) {
            return this.latLonList.get(index);
        }
        return new LatLon(this.getLatitude(index), this.getLongitude(index));
    }

    public GPXUtilities.WptPt getWptPt(int index) {
        if (this.locationType == 2) {
            return this.wptPtList.get(index);
        }
        GPXUtilities.WptPt wptPt = new GPXUtilities.WptPt();
        wptPt.lat = this.getLatitude(index);
        wptPt.lon = this.getLongitude(index);
        return wptPt;
    }

    public Location getLocation(int index) {
        if (this.locationType == 1) {
            return this.locationList.get(index);
        }
        return new Location("", this.getLatitude(index), this.getLongitude(index));
    }
}

