/*
 * Decompiled with CFR 0.152.
 */
package com.wdtinc.mapbox_vector_tile.util;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.wdtinc.mapbox_vector_tile.adapt.jts.JtsAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.osmand.binary.VectorTile;

public final class JtsGeomStats {
    public Map<VectorTile.Tile.GeomType, Integer> featureCounts;
    public List<FeatureStats> featureStats;

    private JtsGeomStats() {
        VectorTile.Tile.GeomType[] geomTypes = VectorTile.Tile.GeomType.values();
        this.featureCounts = new HashMap<VectorTile.Tile.GeomType, Integer>(geomTypes.length);
        for (VectorTile.Tile.GeomType nextGeomType : geomTypes) {
            this.featureCounts.put(nextGeomType, 0);
        }
        this.featureStats = new ArrayList<FeatureStats>();
    }

    public String toString() {
        return "JtsGeomStats{featureCounts=" + this.featureCounts + ", featureStats=" + this.featureStats + "}";
    }

    public static JtsGeomStats getStats(List<Geometry> flatGeomList) {
        JtsGeomStats stats = new JtsGeomStats();
        for (Geometry nextGeom : flatGeomList) {
            VectorTile.Tile.GeomType geomType = JtsAdapter.toGeomType(nextGeom);
            Integer oldValue = stats.featureCounts.get(geomType);
            if (oldValue != null) {
                oldValue = oldValue + 1;
                stats.featureCounts.put(geomType, oldValue);
            }
            stats.featureStats.add(JtsGeomStats.getStats(nextGeom, geomType));
        }
        return stats;
    }

    private static FeatureStats getStats(Geometry geom, VectorTile.Tile.GeomType type) {
        return switch (type) {
            case VectorTile.Tile.GeomType.POINT -> JtsGeomStats.pointStats(geom);
            case VectorTile.Tile.GeomType.LINESTRING -> JtsGeomStats.lineStats(geom);
            case VectorTile.Tile.GeomType.POLYGON -> JtsGeomStats.polyStats(geom);
            default -> new FeatureStats();
        };
    }

    private static FeatureStats pointStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        HashSet<Point> pointSet = new HashSet<Point>(geom.getNumPoints());
        featureStats.totalPts = geom.getNumPoints();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Point p = (Point)geom.getGeometryN(i);
            featureStats.repeatedPts = featureStats.repeatedPts + (pointSet.add(p) ? 0 : 1);
        }
        return featureStats;
    }

    private static FeatureStats lineStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            LineString lineString = (LineString)geom.getGeometryN(i);
            featureStats.totalPts += lineString.getNumPoints();
            featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d(lineString);
        }
        return featureStats;
    }

    private static FeatureStats polyStats(Geometry geom) {
        FeatureStats featureStats = new FeatureStats();
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Polygon nextPoly = (Polygon)geom.getGeometryN(i);
            LineString exteriorRing = nextPoly.getExteriorRing();
            featureStats.totalPts += exteriorRing.getNumPoints();
            featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d(exteriorRing);
            for (int ringIndex = 0; ringIndex < nextPoly.getNumInteriorRing(); ++ringIndex) {
                LineString nextInteriorRing = nextPoly.getInteriorRingN(ringIndex);
                featureStats.totalPts += nextInteriorRing.getNumPoints();
                featureStats.repeatedPts += JtsGeomStats.checkRepeatedPoints2d(nextInteriorRing);
            }
        }
        return featureStats;
    }

    private static int checkRepeatedPoints2d(LineString lineString) {
        int repeatedPoints = 0;
        CoordinateSequence coordSeq = lineString.getCoordinateSequence();
        Coordinate nextCoord = null;
        for (int i = 0; i < coordSeq.size(); ++i) {
            Coordinate prevCoord = nextCoord;
            nextCoord = coordSeq.getCoordinate(i);
            if (!nextCoord.equals((Object)prevCoord)) continue;
            ++repeatedPoints;
        }
        return repeatedPoints;
    }

    public static final class FeatureStats {
        public int totalPts;
        public int repeatedPts;

        public String toString() {
            return "FeatureStats{totalPts=" + this.totalPts + ", repeatedPts=" + this.repeatedPts + "}";
        }
    }
}

