/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.SimpleFormatter;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.filechooser.FileFilter;
import javax.xml.stream.XMLStreamException;
import net.osmand.IProgress;
import net.osmand.MapCreatorVersion;
import net.osmand.NativeJavaRendering;
import net.osmand.SQLiteBigPlanetIndex;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.Street;
import net.osmand.map.IMapLocationListener;
import net.osmand.map.ITileSource;
import net.osmand.map.OsmandRegions;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.osm.io.IOsmStorageFilter;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmBoundsFilter;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.render.RenderingRulesTransformer;
import net.osmand.router.RoutePlannerFrontEnd;
import net.osmand.router.RouteResultPreparation;
import net.osmand.search.SearchUICore;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchCoreAPI;
import net.osmand.search.core.SearchCoreFactory;
import net.osmand.search.core.SearchResult;
import net.osmand.search.core.SearchSettings;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.ExceptionHandler;
import net.osmand.swing.JScrollPopupMenu;
import net.osmand.swing.MapInformationLayer;
import net.osmand.swing.MapPanel;
import net.osmand.swing.MapPanelSelector;
import net.osmand.swing.Messages;
import net.osmand.swing.NativePreferencesDialog;
import net.osmand.swing.NativeSwingRendering;
import net.osmand.swing.OsmExtractionPreferencesDialog;
import net.osmand.swing.ProgressDialog;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;
import org.xmlpull.v1.XmlPullParserException;
import rtree.RTree;

public class OsmExtractionUI
implements IMapLocationListener {
    private static final Log log = LogFactory.getLog(OsmExtractionUI.class);
    public static final String LOG_PATH = OsmExtractionUI.getUserLogDirectoryPath() + "/osmand.log";
    public static OsmExtractionUI MAIN_APP;
    private MapPanel mapPanel;
    private JFrame frame;
    private JLabel statusBarLabel;
    private JCheckBox buildPoiIndex;
    private JCheckBox buildAddressIndex;
    private JCheckBox buildMapIndex;
    private JCheckBox buildRoutingIndex;
    private JCheckBox buildTransportIndex;
    private JCheckBox normalizingStreets;
    private JButton showOfflineIndex;
    private String regionName;
    private SearchUICore searchUICore;
    private OsmandRegions osmandRegions;
    JScrollPopupMenu popup;
    boolean focusPopup = false;

    public static String getUserLogDirectoryPath() {
        return DataExtractionSettings.getSettings().getDefaultWorkingDir().getAbsolutePath();
    }

    public static void main(String[] args) {
        OsmExtractionUI.configLogFile();
        SearchCoreFactory.DISPLAY_DEFAULT_POI_TYPES = true;
        final Thread.UncaughtExceptionHandler defaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (!(e instanceof ThreadDeath)) {
                    ExceptionHandler.handle("Error in thread " + t.getName(), e);
                }
                if (defaultHandler != null) {
                    defaultHandler.uncaughtException(t, e);
                }
            }
        });
        RoutePlannerFrontEnd.CALCULATE_MISSING_MAPS = false;
        RouteResultPreparation.PRINT_TO_CONSOLE_ROUTE_INFORMATION_TO_TEST = false;
        RouteResultPreparation.PRINT_TO_GPX_FILE = DataExtractionSettings.getSettings().getDefaultWorkingDir().getAbsolutePath() + "/route.gpx";
        MAIN_APP = new OsmExtractionUI();
        OsmExtractionUI.MAIN_APP.frame.setBounds(DataExtractionSettings.getSettings().getWindowBounds());
        OsmExtractionUI.MAIN_APP.frame.setVisible(true);
    }

    public static void configLogFile() {
        new File(LOG_PATH).getParentFile().mkdirs();
        try {
            FileHandler fh = new FileHandler(LOG_PATH, 5000000, 1, true);
            fh.setFormatter(new SimpleFormatter());
            LogManager.getLogManager().getLogger("").addHandler(fh);
        }
        catch (SecurityException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public OsmExtractionUI() {
        this.createUI();
    }

    public void createUI() {
        this.frame = new JFrame(Messages.getString("OsmExtractionUI.OSMAND_MAP_CREATOR"));
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception e) {
            log.error((Object)"Can't set look and feel", (Throwable)e);
        }
        this.frame.addWindowListener(new ExitListener());
        Container content = this.frame.getContentPane();
        this.frame.setFocusable(true);
        this.mapPanel = new MapPanel(DataExtractionSettings.getSettings().getTilesDirectory());
        this.mapPanel.setFocusable(true);
        this.mapPanel.addMapLocationListener(this);
        this.statusBarLabel = new JLabel();
        this.osmandRegions = new OsmandRegions();
        try {
            this.osmandRegions.prepareFile();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        content.add((Component)this.statusBarLabel, "South");
        File workingDir = DataExtractionSettings.getSettings().getDefaultWorkingDir();
        this.statusBarLabel.setText((String)(workingDir == null ? Messages.getString("OsmExtractionUI.WORKING_DIR_UNSPECIFIED") : Messages.getString("OsmExtractionUI.WORKING_DIRECTORY") + workingDir.getAbsolutePath()));
        String loc = DataExtractionSettings.getSettings().getSearchLocale();
        if (loc.isEmpty()) {
            loc = null;
        }
        this.searchUICore = new SearchUICore(MapPoiTypes.getDefault(), loc, false);
        this.searchUICore.getSearchSettings().setRegions(this.osmandRegions);
        try {
            BinaryMapIndexReader[] files = DataExtractionSettings.getSettings().getObfReaders();
            this.searchUICore.getSearchSettings().setOfflineIndexes(Arrays.asList(files));
        }
        catch (IOException e) {
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        this.searchUICore.init();
        this.searchUICore.registerAPI((SearchCoreAPI)new SearchCoreFactory.SearchRegionByNameAPI());
        content.add((Component)this.mapPanel, "Center");
        JPanel bl = new JPanel();
        bl.setLayout(new BoxLayout(bl, 3));
        JPanel buttonsBar = this.createButtonsBar();
        bl.add(buttonsBar);
        JTextField statusField = new JTextField();
        this.mapPanel.setStatusField(statusField);
        bl.add(statusField);
        this.updateStatusField(statusField);
        content.add((Component)bl, "North");
        JMenuBar bar = new JMenuBar();
        this.fillMenuWithActions(bar);
        this.frame.setJMenuBar(bar);
    }

    private void updateStatusField(final JTextField statusField) {
        this.popup = new JScrollPopupMenu();
        this.popup.setMaximumVisibleRows(25);
        this.popup.setFocusable(false);
        this.searchUICore.setOnResultsComplete(new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OsmExtractionUI.this.updateSearchResult(statusField, OsmExtractionUI.this.searchUICore.getCurrentSearchResult(), true);
                    }
                });
            }
        });
        statusField.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
            }

            @Override
            public void focusGained(FocusEvent e) {
                OsmExtractionUI.this.popup.setFocusable(false);
                SearchSettings settings = OsmExtractionUI.this.searchUICore.getPhrase().getSettings().setOriginalLocation(new LatLon(OsmExtractionUI.this.mapPanel.getLatitude(), OsmExtractionUI.this.mapPanel.getLongitude()));
                settings = settings.setLang(DataExtractionSettings.getSettings().getSearchLocale(), false);
                OsmExtractionUI.this.searchUICore.updateSettings(settings);
            }
        });
        statusField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                super.keyPressed(e);
                OsmExtractionUI.this.mapPanel.setStatusField(null);
                if (e.getKeyCode() == 40 && OsmExtractionUI.this.popup.getComponentCount() > 0) {
                    OsmExtractionUI.this.popup.setVisible(false);
                    OsmExtractionUI.this.popup.setFocusable(true);
                    Point p = statusField.getLocation();
                    OsmExtractionUI.this.popup.show(e.getComponent(), p.x, p.y - 4);
                    OsmExtractionUI.this.popup.requestFocus();
                    return;
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                SearchSettings settings;
                OsmExtractionUI.this.mapPanel.setStatusField(null);
                if (e.getKeyCode() == 40) {
                    return;
                }
                Object text = statusField.getText();
                int ps = statusField.getCaretPosition();
                if (e.getKeyChar() != '\b' && e.getKeyChar() != '\uffff') {
                    text = ps >= ((String)text).length() ? (String)text + e.getKeyChar() : ((String)text).substring(0, ps) + e.getKeyChar() + ((String)text).substring(ps);
                }
                if ((settings = OsmExtractionUI.this.searchUICore.getPhrase().getSettings()).getRadiusLevel() != 1) {
                    OsmExtractionUI.this.searchUICore.updateSettings(settings.setRadiusLevel(1));
                }
                Object c = null;
                if (!((String)text).contains("#map")) {
                    OsmExtractionUI.this.searchUICore.search((String)text, true, null);
                }
            }
        });
        statusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                OsmExtractionUI.this.mapPanel.setStatusField(statusField);
                String txt = statusField.getText();
                int i = txt.indexOf("#map=");
                if (i != -1) {
                    String[] vs = txt.substring(i + "#map=".length()).split("/");
                    OsmExtractionUI.this.mapPanel.setLatLon(Float.parseFloat(vs[1]), Float.parseFloat(vs[2]));
                    OsmExtractionUI.this.mapPanel.setZoom(Integer.parseInt(vs[0]));
                }
                OsmExtractionUI.this.mapPanel.refresh();
            }
        });
    }

    private void updateSearchResult(final JTextField statusField, SearchUICore.SearchResultCollection res, boolean addMore) {
        this.popup.setVisible(false);
        this.popup.removeAll();
        List<SearchResult> resSearch = res.getCurrentSearchResults();
        if (resSearch == null) {
            resSearch = Collections.emptyList();
        }
        if (resSearch.size() > 0 || addMore) {
            int count = 30;
            if (addMore) {
                JMenuItem mi = new JMenuItem();
                mi.setText("Results " + resSearch.size() + ", radius " + res.getPhrase().getRadiusLevel() + " (show more...)");
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        SearchSettings settings = OsmExtractionUI.this.searchUICore.getPhrase().getSettings();
                        OsmExtractionUI.this.searchUICore.updateSettings(settings.setRadiusLevel(settings.getRadiusLevel() + 1));
                        OsmExtractionUI.this.searchUICore.search(statusField.getText(), true, null);
                        OsmExtractionUI.this.updateSearchResult(statusField, OsmExtractionUI.this.searchUICore.getCurrentSearchResult(), false);
                    }
                });
                this.popup.add(mi);
            }
            for (final SearchResult sr : resSearch) {
                if (--count == 0) {
                    // empty if block
                }
                JMenuItem mi = new JMenuItem();
                LatLon location = res.getPhrase().getLastTokenLocation();
                Object locationString = "";
                if (sr.location != null) {
                    locationString = (float)((int)MapUtils.getDistance((LatLon)location, (LatLon)sr.location)) / 1000.0f + " km";
                }
                if (!Algorithms.isEmpty((CharSequence)sr.localeRelatedObjectName)) {
                    locationString = (String)locationString + " " + sr.localeRelatedObjectName;
                    if (sr.distRelatedObjectName != 0.0) {
                        locationString = (String)locationString + " " + (int)(sr.distRelatedObjectName / 1000.0) + " km";
                    }
                }
                if (sr.objectType == ObjectType.HOUSE && sr.relatedObject instanceof Street) {
                    locationString = (String)locationString + " " + ((Street)sr.relatedObject).getCity().getName();
                }
                if (sr.objectType == ObjectType.LOCATION) {
                    locationString = (String)locationString + " " + this.osmandRegions.getCountryName(sr.location);
                }
                if (sr.object instanceof Amenity) {
                    locationString = (String)locationString + " " + ((Amenity)sr.object).getSubType();
                    if (((Amenity)sr.object).isClosed()) {
                        locationString = (String)locationString + " (CLOSED)";
                    }
                }
                String r = String.format("%s [%d, %s, %f] ", sr.localeName, sr.getFoundWordCount(), sr.objectType, sr.getUnknownPhraseMatchWeight()) + (String)locationString;
                mi.setText(r);
                mi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        OsmExtractionUI.this.mapPanel.setStatusField(null);
                        if (sr.location != null) {
                            OsmExtractionUI.this.mapPanel.setLatLon(sr.location.getLatitude(), sr.location.getLongitude());
                            OsmExtractionUI.this.mapPanel.setZoom(sr.preferredZoom);
                        }
                        OsmExtractionUI.this.searchUICore.selectSearchResult(sr);
                        String txt = OsmExtractionUI.this.searchUICore.getPhrase().getText(true);
                        statusField.setText(txt);
                        OsmExtractionUI.this.searchUICore.search(txt, false, null);
                        statusField.requestFocus();
                    }
                });
                this.popup.add(mi);
            }
            Point p = statusField.getLocation();
            if (this.popup.isVisible()) {
                this.popup.setVisible(true);
            } else {
                this.popup.show(statusField.getParent(), p.x, p.y + statusField.getHeight() + 4);
            }
        }
    }

    public JPanel createButtonsBar() {
        JPanel panel = new JPanel(new FlowLayout(0));
        this.buildMapIndex = new JCheckBox();
        this.buildMapIndex.setText(Messages.getString("OsmExtractionUI.BUILD_MAP"));
        panel.add(this.buildMapIndex);
        this.buildMapIndex.setSelected(true);
        this.buildRoutingIndex = new JCheckBox();
        this.buildRoutingIndex.setText(Messages.getString("OsmExtractionUI.BUILD_ROUTING"));
        panel.add(this.buildRoutingIndex);
        this.buildRoutingIndex.setSelected(true);
        this.buildPoiIndex = new JCheckBox();
        this.buildPoiIndex.setText(Messages.getString("OsmExtractionUI.BUILD_POI"));
        panel.add(this.buildPoiIndex);
        this.buildPoiIndex.setSelected(true);
        this.buildAddressIndex = new JCheckBox();
        this.buildAddressIndex.setText(Messages.getString("OsmExtractionUI.BUILD_ADDRESS"));
        panel.add(this.buildAddressIndex);
        this.buildAddressIndex.setSelected(true);
        this.normalizingStreets = new JCheckBox();
        this.normalizingStreets.setText(Messages.getString("OsmExtractionUI.NORMALIZE_STREETS"));
        this.normalizingStreets.setSelected(true);
        this.buildTransportIndex = new JCheckBox();
        this.buildTransportIndex.setText(Messages.getString("OsmExtractionUI.BUILD_TRANSPORT"));
        panel.add(this.buildTransportIndex);
        this.buildTransportIndex.setSelected(true);
        this.showOfflineIndex = new JButton();
        this.showOfflineIndex.setText("Offline Rendering");
        panel.add(this.showOfflineIndex);
        this.mapPanel.setOnlineRendering(this.showOfflineIndex);
        this.showOfflineIndex.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OsmExtractionUI.this.showOfflineIndex.getText().equals("Offline Rendering")) {
                    OsmExtractionUI.this.showOfflineIndex.setText("Online Rendering");
                    NativePreferencesDialog dlg = new NativePreferencesDialog(OsmExtractionUI.this.mapPanel);
                    dlg.showDialog();
                    if (dlg.isOkPressed()) {
                        OsmExtractionUI.this.initNativeRendering(DataExtractionSettings.getSettings().getRenderingProperties());
                    } else {
                        OsmExtractionUI.this.showOfflineIndex.setSelected(false);
                    }
                } else {
                    OsmExtractionUI.this.showOfflineIndex.setText("Offline Rendering");
                    OsmExtractionUI.this.mapPanel.setNativeLibrary(null);
                }
            }
        });
        return panel;
    }

    private void initNativeRendering(String renderingProperties) {
        String templateFile;
        String genFile = DataExtractionSettings.getSettings().getRenderGenXmlPath();
        String targetFile = templateFile = DataExtractionSettings.getSettings().getRenderXmlPath();
        if (genFile.equals("") && templateFile.contains("_template")) {
            genFile = templateFile.replace("_template", "");
        }
        if (!genFile.equals("")) {
            try {
                RenderingRulesTransformer.main((String[])new String[]{templateFile, genFile});
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
            targetFile = genFile;
        }
        try {
            NativeJavaRendering lib = NativeSwingRendering.getDefaultFromSettings();
            if (lib != null) {
                lib.closeAllFiles();
                lib.initFilesInDir(new File(DataExtractionSettings.getSettings().getBinaryFilesDir()));
                lib.loadRuleStorage(targetFile, renderingProperties);
                this.mapPanel.setNativeLibrary(lib);
            } else {
                JOptionPane.showMessageDialog(this.frame, "Native library was not configured in settings");
            }
        }
        catch (SAXException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (XmlPullParserException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public void fillMenuWithActions(final JMenuBar bar) {
        JMenu menu = new JMenu(Messages.getString("OsmExtractionUI.MENU_FILE"));
        bar.add(menu);
        JMenuItem loadFile = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_SELECT_FILE"));
        menu.add(loadFile);
        JMenuItem loadSpecifiedAreaFile = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_SELECT_OSM_FILE_AREA"));
        menu.add(loadSpecifiedAreaFile);
        JMenuItem specifyWorkingDir = new JMenuItem(Messages.getString("OsmExtractionUI.SPECIFY_WORKING_DIR"));
        menu.add(specifyWorkingDir);
        menu.addSeparator();
        JMenuItem exitMenu = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_EXIT"));
        menu.add(exitMenu);
        final JMenuItem sqliteDB = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_CREATE_SQLITE"));
        JMenu tileSource = MapPanel.getMenuToChooseSource(this.mapPanel);
        tileSource.addSeparator();
        tileSource.add(sqliteDB);
        bar.add(tileSource);
        menu = new JMenu(Messages.getString("OsmExtractionUI.MENU_WINDOW"));
        bar.add(menu);
        JMenuItem settings = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_SETTINGS"));
        menu.add(settings);
        menu.addSeparator();
        JMenuItem openLogFile = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_OPEN_LOG"));
        menu.add(openLogFile);
        menu = new JMenu(Messages.getString("OsmExtractionUI.MENU_ABOUT"));
        bar.add(menu);
        JMenuItem aboutApplication = new JMenuItem(Messages.getString("OsmExtractionUI.MENU_ABOUT_2"));
        menu.add(aboutApplication);
        aboutApplication.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JOptionPane.showMessageDialog(OsmExtractionUI.this.frame, MapCreatorVersion.APP_MAP_CREATOR_FULL_NAME);
            }
        });
        openLogFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File file = new File(LOG_PATH);
                if (file != null && file.exists()) {
                    if (System.getProperty("os.name").startsWith("Windows")) {
                        try {
                            Runtime.getRuntime().exec(new String[]{"notepad.exe", file.getAbsolutePath()});
                        }
                        catch (IOException es) {
                            ExceptionHandler.handle(Messages.getString("OsmExtractionUI.UNABLE_OPEN_FILE"), es);
                        }
                    } else {
                        JOptionPane.showMessageDialog(OsmExtractionUI.this.frame, Messages.getString("OsmExtractionUI.OPEN_LOG_FILE_MANUALLY") + LOG_PATH);
                    }
                } else {
                    ExceptionHandler.handle(Messages.getString("OsmExtractionUI.LOG_FILE_NOT_FOUND"));
                }
            }
        });
        sqliteDB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final String regionName = OsmExtractionUI.this.regionName == null ? Messages.getString("OsmExtractionUI.REGION") : OsmExtractionUI.this.regionName;
                final ITileSource map = OsmExtractionUI.this.mapPanel.getMap();
                if (map != null) {
                    try {
                        ProgressDialog dlg = new ProgressDialog((Component)OsmExtractionUI.this.frame, Messages.getString("OsmExtractionUI.CREATING_INDEX"));
                        dlg.setRunnable(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    SQLiteBigPlanetIndex.createSQLiteDatabase((SQLiteBigPlanetIndex.SQLiteParams)new SQLiteBigPlanetIndex.SQLiteParams(DataExtractionSettings.getSettings().getTilesDirectory(), regionName, map));
                                }
                                catch (SQLException e1) {
                                    throw new IllegalArgumentException(e1);
                                }
                                catch (IOException e1) {
                                    throw new IllegalArgumentException(e1);
                                }
                            }
                        });
                        dlg.run();
                    }
                    catch (InterruptedException e1) {
                        log.error((Object)"Interrupted", (Throwable)e1);
                    }
                    catch (InvocationTargetException e1) {
                        ExceptionHandler.handle("Can't create big planet sqlite index", e1.getCause());
                    }
                }
            }
        });
        exitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmExtractionUI.this.frame.setVisible(false);
                OsmExtractionUI.this.exit();
            }
        });
        settings.addActionListener(new ActionListener(){

            private void applySettings() {
                OsmExtractionUI.this.mapPanel.applySettings();
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmExtractionPreferencesDialog dlg = new OsmExtractionPreferencesDialog((Component)OsmExtractionUI.this.frame);
                dlg.showDialog();
                this.applySettings();
            }
        });
        specifyWorkingDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = new JFileChooser();
                fc.setDialogTitle(Messages.getString("OsmExtractionUI.CHOOSE_WORKING_DIR"));
                fc.setFileSelectionMode(1);
                File workingDir = DataExtractionSettings.getSettings().getDefaultWorkingDir();
                if (workingDir != null) {
                    fc.setCurrentDirectory(workingDir);
                }
                if (fc.showOpenDialog(OsmExtractionUI.this.frame) == 0 && fc.getSelectedFile() != null && fc.getSelectedFile().isDirectory()) {
                    DataExtractionSettings.getSettings().saveDefaultWorkingDir(fc.getSelectedFile());
                    OsmExtractionUI.this.mapPanel.setTilesLocation(DataExtractionSettings.getSettings().getTilesDirectory());
                    OsmExtractionUI.this.statusBarLabel.setText(Messages.getString("OsmExtractionUI.WORKING_DIR") + fc.getSelectedFile().getAbsolutePath());
                    JMenu tileSource = MapPanel.getMenuToChooseSource(OsmExtractionUI.this.mapPanel);
                    tileSource.add(sqliteDB);
                    bar.remove(1);
                    bar.add((Component)tileSource, 1);
                }
            }
        });
        loadSpecifiedAreaFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = OsmExtractionUI.this.getOsmFileChooser();
                int answer = fc.showOpenDialog(OsmExtractionUI.this.frame);
                if (answer == 0 && fc.getSelectedFile() != null) {
                    final JDialog dlg = new JDialog((Frame)OsmExtractionUI.this.frame, true);
                    dlg.setTitle(Messages.getString("OsmExtractionUI.SELECT_AREA_TO_FILTER"));
                    MapPanel panel = new MapPanel(DataExtractionSettings.getSettings().getTilesDirectory());
                    panel.setLatLon(OsmExtractionUI.this.mapPanel.getLatitude(), OsmExtractionUI.this.mapPanel.getLongitude());
                    panel.setZoom(OsmExtractionUI.this.mapPanel.getZoom());
                    final StringBuilder res = new StringBuilder();
                    panel.getLayer(MapInformationLayer.class).setAreaActionHandler(new AbstractAction(Messages.getString("OsmExtractionUI.SELECT_AREA")){
                        private static final long serialVersionUID = -3452957517341961969L;

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            res.append(true);
                            dlg.setVisible(false);
                        }
                    });
                    dlg.add(panel);
                    JMenuBar bar = new JMenuBar();
                    bar.add(MapPanel.getMenuToChooseSource(panel));
                    dlg.setJMenuBar(bar);
                    dlg.setSize(512, 512);
                    double x = OsmExtractionUI.this.frame.getBounds().getCenterX();
                    double y = OsmExtractionUI.this.frame.getBounds().getCenterY();
                    dlg.setLocation((int)x - dlg.getWidth() / 2, (int)y - dlg.getHeight() / 2);
                    dlg.setVisible(true);
                    if (res.length() > 0 && panel.getSelectionArea().isVisible()) {
                        MapPanelSelector.MapSelectionArea area = panel.getSelectionArea();
                        OsmBoundsFilter filter = new OsmBoundsFilter(area.getLat1(), area.getLon1(), area.getLat2(), area.getLon2());
                        OsmExtractionUI.this.loadCountry(fc.getSelectedFile(), (IOsmStorageFilter)filter);
                    }
                }
            }
        });
        loadFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fc = OsmExtractionUI.this.getOsmFileChooser();
                int answer = fc.showOpenDialog(OsmExtractionUI.this.frame);
                if (answer == 0 && fc.getSelectedFile() != null) {
                    OsmExtractionUI.this.loadCountry(fc.getSelectedFile(), null);
                }
            }
        });
    }

    public JFileChooser getOsmFileChooser() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(Messages.getString("OsmExtractionUI.CHOOSE_OSM_FILE"));
        fc.setFileSelectionMode(0);
        fc.setAcceptAllFileFilterUsed(true);
        fc.setCurrentDirectory(DataExtractionSettings.getSettings().getDefaultWorkingDir().getParentFile());
        fc.setFileFilter(new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.isDirectory() || f.getName().endsWith(".bz2") || f.getName().endsWith(".osm") || f.getName().endsWith(".pbf");
            }

            @Override
            public String getDescription() {
                return Messages.getString("OsmExtractionUI.OSM_FILES");
            }
        });
        return fc;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public void loadCountry(final File f, final IOsmStorageFilter filter) {
        try {
            final ProgressDialog dlg = new ProgressDialog((Component)this.frame, Messages.getString("OsmExtractionUI.LOADING_OSM_FILE"));
            dlg.setRunnable(new Runnable(){

                @Override
                public void run() {
                    File dir = DataExtractionSettings.getSettings().getDefaultWorkingDir();
                    IndexCreatorSettings settings = new IndexCreatorSettings(){

                        public String getString(String key) {
                            return Messages.getString(key);
                        }
                    };
                    settings.indexMap = OsmExtractionUI.this.buildMapIndex.isSelected();
                    settings.indexAddress = OsmExtractionUI.this.buildAddressIndex.isSelected();
                    settings.indexPOI = OsmExtractionUI.this.buildPoiIndex.isSelected();
                    settings.indexTransport = OsmExtractionUI.this.buildTransportIndex.isSelected();
                    settings.indexRouting = OsmExtractionUI.this.buildRoutingIndex.isSelected();
                    settings.suppressWarningsForDuplicateIds = DataExtractionSettings.getSettings().isSupressWarningsForDuplicatedId();
                    settings.houseNameAddAdditionalInfo = DataExtractionSettings.getSettings().isAdditionalInfo();
                    settings.houseNumberPreferredOverName = DataExtractionSettings.getSettings().isHousenumberPrefered();
                    try {
                        settings.zoomWaySmoothness = Integer.parseInt(DataExtractionSettings.getSettings().getLineSmoothness());
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    IndexCreator creator = new IndexCreator(dir, settings);
                    try {
                        String fn = DataExtractionSettings.getSettings().getMapRenderingTypesFile();
                        if (!Algorithms.isEmpty((CharSequence)DataExtractionSettings.getSettings().getPoiTypesFile())) {
                            MapPoiTypes.setDefault((MapPoiTypes)new MapPoiTypes(DataExtractionSettings.getSettings().getPoiTypesFile()));
                        }
                        MapRenderingTypesEncoder types = new MapRenderingTypesEncoder(fn, f.getName());
                        RTree.clearCache();
                        creator.generateIndexes(f, (IProgress)dlg, filter, DataExtractionSettings.getSettings().getMapZooms(), types, log);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (XmlPullParserException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (SQLException e) {
                        throw new IllegalStateException(e);
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException(e);
                    }
                    OsmExtractionUI.this.regionName = creator.getRegionName();
                    StringBuilder msg = new StringBuilder();
                    msg.append(Messages.getString("OsmExtractionUI.INDEXES_FOR")).append(OsmExtractionUI.this.regionName).append(" : ");
                    boolean comma = false;
                    if (OsmExtractionUI.this.buildMapIndex.isSelected()) {
                        if (comma) {
                            msg.append(", ");
                        }
                        comma = true;
                        msg.append(Messages.getString("OsmExtractionUI.MAP"));
                    }
                    if (OsmExtractionUI.this.buildPoiIndex.isSelected()) {
                        if (comma) {
                            msg.append(", ");
                        }
                        comma = true;
                        msg.append(Messages.getString("OsmExtractionUI.POI"));
                    }
                    if (OsmExtractionUI.this.buildAddressIndex.isSelected()) {
                        if (comma) {
                            msg.append(", ");
                        }
                        comma = true;
                        msg.append(Messages.getString("OsmExtractionUI.ADDRESS"));
                    }
                    if (OsmExtractionUI.this.buildTransportIndex.isSelected()) {
                        if (comma) {
                            msg.append(", ");
                        }
                        comma = true;
                        msg.append(Messages.getString("OsmExtractionUI.TRANSPORT"));
                    }
                    msg.append(MessageFormat.format(Messages.getString("OsmExtractionUI.WERE_SUCCESFULLY_CREATED"), dir.getAbsolutePath()));
                    JOptionPane pane = new JOptionPane(msg);
                    JDialog dialog = pane.createDialog(OsmExtractionUI.this.frame, Messages.getString("OsmExtractionUI.GENERATION_DATA"));
                    dialog.setVisible(true);
                }
            });
            dlg.run();
            this.frame.setTitle(Messages.getString("OsmExtractionUI.OSMAND_MAP_CREATOR_FILE") + f.getName());
        }
        catch (InterruptedException e1) {
            log.error((Object)"Interrupted", (Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            ExceptionHandler.handle("Exception during operation", e1.getCause());
        }
    }

    public void saveCountry(final File f, final OsmBaseStorage storage) {
        final OsmStorageWriter writer = new OsmStorageWriter();
        try {
            ProgressDialog dlg = new ProgressDialog((Component)this.frame, Messages.getString("OsmExtractionUI.SAVING_OSM_FILE"));
            dlg.setRunnable(new Runnable(){

                @Override
                public void run() {
                    try (FileOutputStream output = new FileOutputStream(f);){
                        if (f.getName().endsWith(".bz2")) {
                            output = new BZip2CompressorOutputStream((OutputStream)output);
                        }
                        writer.saveStorage((OutputStream)output, storage, null, false);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException(e);
                    }
                    catch (XMLStreamException e) {
                        throw new IllegalArgumentException(e);
                    }
                }
            });
            dlg.run();
        }
        catch (InterruptedException e1) {
            log.error((Object)"Interrupted", (Throwable)e1);
        }
        catch (InvocationTargetException e1) {
            ExceptionHandler.handle("Log file is not found", e1.getCause());
        }
    }

    public void locationChanged(double newLatitude, double newLongitude, Object source) {
    }

    public void exit() {
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        settings.saveDefaultLocation(this.mapPanel.getLatitude(), this.mapPanel.getLongitude());
        settings.saveDefaultZoom(this.mapPanel.getZoom());
        settings.saveWindowBounds(this.frame.getBounds());
        System.exit(0);
    }

    public class ExitListener
    extends WindowAdapter {
        @Override
        public void windowClosing(WindowEvent event) {
            OsmExtractionUI.this.exit();
        }
    }
}

