/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.osmand.swing.DataExtractionSettings;
import net.osmand.swing.Messages;

public class OsmExtractionPreferencesDialog
extends JDialog {
    private static final long serialVersionUID = -4862884032977071296L;
    private static final int MAX_WIDTH = 700;
    private JButton okButton;
    private JButton cancelButton;
    private JTextField mapZooms;
    private JTextField searchLocale;
    private JTextField routingMode;
    private JTextField lineSmoothness;
    private JTextField renderingTypesFile;
    private JTextField poiTypesFile;
    private JTextField nativeLibFile;
    private JTextField nativeQtLib;
    private JTextField nativeFilesDirectory;
    private JTextField renderingStyleFile;
    private JTextField routingConfigFile;
    private JCheckBox advancedRoutingUI;
    private JCheckBox useInternet;
    private JCheckBox animateRouting;
    private JCheckBox nativeRouting;
    private JCheckBox preferHousenumber;
    private JCheckBox additionalAddressinfo;

    public OsmExtractionPreferencesDialog(Component parent) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.setTitle(Messages.getString("OsmExtractionPreferencesDialog.PREFERENCES"));
        this.initDialog();
    }

    public void showDialog() {
        this.setSize(750, 600);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
        this.setVisible(true);
    }

    private void initDialog() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 1));
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 10));
        JPanel innerPane = new JPanel();
        innerPane.setLayout(new BoxLayout(innerPane, 1));
        this.createGeneralSection(innerPane);
        this.createMapCreationSection(innerPane);
        this.createSearchSection(innerPane);
        this.createAddressSection(innerPane);
        Dimension d = innerPane.getPreferredSize();
        d.width = 700;
        innerPane.setPreferredSize(d);
        JScrollPane spanel = new JScrollPane(innerPane, 20, 31);
        pane.add(spanel);
        this.add(pane);
        pane.add(Box.createVerticalGlue());
        FlowLayout l = new FlowLayout(2);
        JPanel buttonsPane = new JPanel(l);
        this.okButton = new JButton(Messages.getString("OsmExtractionPreferencesDialog.OK"));
        buttonsPane.add(this.okButton);
        this.cancelButton = new JButton(Messages.getString("OsmExtractionPreferencesDialog.CANCEL"));
        buttonsPane.add(this.cancelButton);
        pane.add(buttonsPane);
        this.addListeners();
    }

    private void createGeneralSection(JPanel root) {
        JPanel panel = new JPanel();
        int gridY = 0;
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OsmExtractionPreferencesDialog.GENERAL")));
        root.add(panel);
        this.advancedRoutingUI = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().useAdvancedRoutingUI(), Messages.getString("OsmExtractionPreferencesDialog.ADVANCED.ROUTING.UI"), l);
        this.useInternet = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().useInternetToLoadImages(), Messages.getString("OsmExtractionPreferencesDialog.INTERNET.TO.DOWNLOAD.FILES"), l);
        this.animateRouting = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().isAnimateRouting(), "Animate routing", l);
        this.nativeRouting = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().useNativeRouting(), "Native routing", l);
        JLabel label = new JLabel("Directory with obf binary files (routing, rendering): ");
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.nativeFilesDirectory = new JTextField();
        this.nativeFilesDirectory.setText(DataExtractionSettings.getSettings().getBinaryFilesDir());
        panel.add(this.nativeFilesDirectory);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = gridY++;
        l.setConstraints(this.nativeFilesDirectory, constr);
        label = new JLabel("Routing (car|bicycle|pedestrian,[short_way],[avoid_ferries]...) : ");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.routingMode = new JTextField();
        this.routingMode.setText(DataExtractionSettings.getSettings().getRouteMode());
        panel.add(this.routingMode);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = gridY++;
        l.setConstraints(this.routingMode, constr);
        label = new JLabel("Routing config file (path : ");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.routingConfigFile = new JTextField();
        this.routingConfigFile.setText(DataExtractionSettings.getSettings().getRoutingXmlPath());
        panel.add(this.routingConfigFile);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = gridY++;
        l.setConstraints(this.routingConfigFile, constr);
        label = new JLabel("Rendering style file (path) : ");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.renderingStyleFile = new JTextField();
        this.renderingStyleFile.setText(DataExtractionSettings.getSettings().getRenderXmlPath());
        panel.add(this.renderingStyleFile);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = gridY++;
        l.setConstraints(this.renderingStyleFile, constr);
        this.nativeLibFile = this.addTextField(panel, gridY++, l, "Native lib file (osmand.lib): ", DataExtractionSettings.getSettings().getNativeLibFile());
        this.nativeQtLib = this.addTextField(panel, gridY++, l, "Native lib folder (qt core): ", DataExtractionSettings.getSettings().getQtLibFolder());
        panel.setMaximumSize(new Dimension(700, panel.getPreferredSize().height));
    }

    protected JTextField addTextField(JPanel panel, int gridY, GridBagLayout l, String labelTxt, String value) {
        JLabel label = new JLabel(labelTxt);
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        JTextField textField = new JTextField();
        textField.setText(value);
        panel.add(textField);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = gridY;
        l.setConstraints(textField, constr);
        return textField;
    }

    private JCheckBox createCheckBox(JPanel panel, int gridY, boolean value, String text, GridBagLayout l) {
        JCheckBox checkBox = new JCheckBox();
        checkBox.setText(text);
        checkBox.setSelected(value);
        panel.add(checkBox);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = gridY++;
        constr.gridwidth = 2;
        constr.anchor = 17;
        l.setConstraints(checkBox, constr);
        return checkBox;
    }

    private void createSearchSection(JPanel root) {
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder("Search parameters"));
        JLabel label = new JLabel("Locale to use for search (2 characters)");
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.searchLocale = new JTextField();
        this.searchLocale.setText(DataExtractionSettings.getSettings().getSearchLocale());
        panel.add(this.searchLocale);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 2;
        l.setConstraints(this.searchLocale, constr);
        root.add(panel);
        panel.setMaximumSize(new Dimension(700, panel.getPreferredSize().height));
    }

    private void createMapCreationSection(JPanel root) {
        JPanel panel = new JPanel();
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder("Map creation parameters"));
        JLabel label = new JLabel("Map zooms (specify zoom levels in binary map):");
        panel.add(label);
        GridBagConstraints constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 2;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.mapZooms = new JTextField();
        this.mapZooms.setText(DataExtractionSettings.getSettings().getMapZoomsValue());
        panel.add(this.mapZooms);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 2;
        l.setConstraints(this.mapZooms, constr);
        label = new JLabel("Line smoothness for low zooms (value 0-3):");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 3;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.lineSmoothness = new JTextField();
        this.lineSmoothness.setText(DataExtractionSettings.getSettings().getLineSmoothness());
        panel.add(this.lineSmoothness);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 3;
        l.setConstraints(this.lineSmoothness, constr);
        label = new JLabel("Path to custom POI types (poi_types.xml):");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 4;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.poiTypesFile = new JTextField();
        this.poiTypesFile.setText(DataExtractionSettings.getSettings().getPoiTypesFile());
        panel.add(this.poiTypesFile);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 4;
        l.setConstraints(this.poiTypesFile, constr);
        label = new JLabel("Path to rendering types xml (rendering_types.xml):");
        panel.add(label);
        constr = new GridBagConstraints();
        constr.ipadx = 5;
        constr.gridx = 0;
        constr.gridy = 5;
        constr.anchor = 17;
        l.setConstraints(label, constr);
        this.renderingTypesFile = new JTextField();
        this.renderingTypesFile.setText(DataExtractionSettings.getSettings().getMapRenderingTypesFile());
        panel.add(this.renderingTypesFile);
        constr = new GridBagConstraints();
        constr.weightx = 1.0;
        constr.fill = 2;
        constr.ipadx = 5;
        constr.gridx = 1;
        constr.gridy = 5;
        l.setConstraints(this.renderingTypesFile, constr);
        root.add(panel);
        panel.setMaximumSize(new Dimension(700, panel.getPreferredSize().height));
    }

    private void createAddressSection(JPanel root) {
        JPanel panel = new JPanel();
        int gridY = 0;
        GridBagLayout l = new GridBagLayout();
        panel.setLayout(l);
        panel.setBorder(BorderFactory.createTitledBorder(Messages.getString("OsmExtractionPreferencesDialog.ADDRESS")));
        root.add(panel);
        this.preferHousenumber = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().isHousenumberPrefered(), Messages.getString("OsmExtractionPreferencesDialog.PREFER.NUMBER"), l);
        this.additionalAddressinfo = this.createCheckBox(panel, gridY++, DataExtractionSettings.getSettings().isAdditionalInfo(), Messages.getString("OsmExtractionPreferencesDialog.ADDITIONAL.INFO"), l);
        panel.setMaximumSize(new Dimension(700, panel.getPreferredSize().height));
    }

    private void addListeners() {
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmExtractionPreferencesDialog.this.saveProperties();
                OsmExtractionPreferencesDialog.this.setVisible(false);
            }
        });
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsmExtractionPreferencesDialog.this.setVisible(false);
            }
        });
    }

    public void saveProperties() {
        DataExtractionSettings settings = DataExtractionSettings.getSettings();
        if (settings.useAdvancedRoutingUI() != this.advancedRoutingUI.isSelected()) {
            settings.setUseAdvancedRoutingUI(this.advancedRoutingUI.isSelected());
        }
        if (settings.useInternetToLoadImages() != this.useInternet.isSelected()) {
            settings.setUseInterentToLoadImages(this.useInternet.isSelected());
        }
        if (settings.isAnimateRouting() != this.animateRouting.isSelected()) {
            settings.setAnimateRouting(this.animateRouting.isSelected());
        }
        if (settings.useNativeRouting() != this.nativeRouting.isSelected()) {
            settings.setNativeRouting(this.nativeRouting.isSelected());
        }
        if (!settings.getNativeLibFile().equals(this.nativeLibFile.getText())) {
            settings.setNativeLibFile(this.nativeLibFile.getText());
        }
        if (!settings.getQtLibFolder().equals(this.nativeQtLib.getText())) {
            settings.setQtLibFolder(this.nativeQtLib.getText());
        }
        if (!settings.getLineSmoothness().equals(this.lineSmoothness.getText())) {
            settings.setLineSmoothness(this.lineSmoothness.getText());
        }
        if (!settings.getMapZoomsValue().equals(this.mapZooms.getText())) {
            settings.setMapZooms(this.mapZooms.getText());
        }
        if (!settings.getSearchLocale().equals(this.searchLocale.getText())) {
            settings.setSearchLocale(this.searchLocale.getText());
        }
        if (!settings.getMapRenderingTypesFile().equals(this.renderingTypesFile.getText())) {
            settings.setMapRenderingTypesFile(this.renderingTypesFile.getText());
        }
        if (!settings.getPoiTypesFile().equals(this.poiTypesFile.getText())) {
            settings.setPoiTypesFile(this.poiTypesFile.getText());
        }
        if (!settings.getBinaryFilesDir().equals(this.nativeFilesDirectory.getText())) {
            settings.setBinaryFilesDir(this.nativeFilesDirectory.getText());
        }
        if (!settings.getRenderXmlPath().equals(this.renderingStyleFile.getText())) {
            settings.setRenderXmlPath(this.renderingStyleFile.getText());
        }
        if (!settings.getRoutingXmlPath().equals(this.routingConfigFile.getText())) {
            settings.setRoutingXmlPath(this.routingConfigFile.getText());
        }
        if (!settings.getRouteMode().equals(this.routingMode.getText())) {
            settings.setRouteMode(this.routingMode.getText());
        }
        if (settings.isHousenumberPrefered() != this.preferHousenumber.isSelected()) {
            settings.preferHousenumber(this.preferHousenumber.isSelected());
        }
        if (settings.isAdditionalInfo() != this.additionalAddressinfo.isSelected()) {
            settings.AdditionalInfo(this.additionalAddressinfo.isSelected());
        }
    }
}

