/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import io.airlift.compress.zstd.ZstdCompressor;
import it.geosolutions.imageio.plugins.tiff.TIFFCompressor;
import java.io.IOException;
import javax.imageio.ImageWriteParam;

public class TIFFZSTDCompressor
extends TIFFCompressor {
    ZstdCompressor compressor = new ZstdCompressor();
    int predictor;
    ImageWriteParam param;

    public TIFFZSTDCompressor(ImageWriteParam param, int predictor) {
        super("ZSTD", 50000, true);
        this.param = param;
        this.predictor = predictor;
    }

    @Override
    public int encode(byte[] b, int off, int width, int height, int[] bitsPerSample, int scanlineStride) throws IOException {
        int inputSize = height * scanlineStride;
        int maxOutputLenght = this.compressor.maxCompressedLength(inputSize);
        byte[] compData = new byte[maxOutputLenght];
        int numCompressedBytes = this.compressor.compress(b, off, inputSize, compData, 0, maxOutputLenght);
        this.stream.write(compData, 0, numCompressedBytes);
        return numCompressedBytes;
    }
}

