/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum CRAllocationStrategy {
    BEST_FIT("BEST_FIT"),
    BEST_FIT_PROGRESSIVE("BEST_FIT_PROGRESSIVE"),
    SPOT_CAPACITY_OPTIMIZED("SPOT_CAPACITY_OPTIMIZED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private CRAllocationStrategy(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static CRAllocationStrategy fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(CRAllocationStrategy.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<CRAllocationStrategy> knownValues() {
        return Stream.of(CRAllocationStrategy.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

