/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.template;

import info.bliki.wiki.filter.TemplateParser;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.template.AbstractTemplateFunction;
import info.bliki.wiki.template.ITemplateFunction;
import info.bliki.wiki.template.expr.eval.DoubleEvaluator;
import java.io.IOException;
import java.util.List;

public class Expr
extends AbstractTemplateFunction {
    public static final ITemplateFunction CONST = new Expr();

    @Override
    public String parseFunction(List<String> list, IWikiModel model, char[] src, int beginIndex, int endIndex, boolean isSubst) throws IOException {
        if (list.size() > 0) {
            String expression = Expr.parseTrim(list.get(0), model);
            if (expression.length() == 0) {
                return null;
            }
            if (!isSubst) {
                StringBuilder conditionBuffer = new StringBuilder(expression.length());
                TemplateParser.parse(expression, model, conditionBuffer, false);
                if (conditionBuffer.length() == 0) {
                    return null;
                }
                expression = conditionBuffer.toString();
            }
            try {
                DoubleEvaluator engine = new DoubleEvaluator();
                double d = engine.evaluate(expression);
                return Expr.getWikiNumberFormat(d, model);
            }
            catch (Exception e) {
                return "<div class=\"error\">Expression error: " + e.getMessage() + "</div>";
            }
        }
        return null;
    }

    public static String getWikiNumberFormat(double d, IWikiModel model) {
        double dInt = Math.rint(d);
        if (Math.abs(dInt - d) < DoubleEvaluator.EPSILON) {
            return Long.toString(Math.round(d));
        }
        return Double.toString(d).toUpperCase();
    }
}

