/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki;

import info.bliki.html.HTML2WikiConverter;
import info.bliki.html.wikipedia.ToWikipedia;
import info.bliki.wiki.filter.PlainTextConverter;
import info.bliki.wiki.model.Configuration;
import info.bliki.wiki.model.WikiModel;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class BlikiConverter
extends JFrame {
    private static final long serialVersionUID = 6600498097600405919L;
    private JButton wikiToHtmlButton;
    private JButton wikiToWikiPlaintext;
    private JButton htmlToWikiButton;
    private JButton clearButton;
    private JTextArea input;
    private JTextArea output;

    private static void createBlikiConverter() {
        BlikiConverter frame = new BlikiConverter("The bliki converter demo application");
        frame.setDefaultCloseOperation(3);
        frame.addComponentsToPane(frame.getContentPane());
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                BlikiConverter.createBlikiConverter();
            }
        });
    }

    public BlikiConverter(String name) {
        super(name);
    }

    private void addComponentsToPane(Container container) {
        this.wikiToHtmlButton = new JButton("Wiki text to HTML");
        this.wikiToHtmlButton.addActionListener(new Wiki2HtmlListener());
        this.wikiToWikiPlaintext = new JButton("Wiki text to plain text");
        this.wikiToWikiPlaintext.addActionListener(new Wiki2PlainListener());
        this.htmlToWikiButton = new JButton("HTML to wiki text");
        this.htmlToWikiButton.addActionListener(new Html2WikiListener());
        this.clearButton = new JButton("Clear input/output");
        this.clearButton.addActionListener(new ClearListener());
        this.input = new JTextArea(20, 80);
        JScrollPane inputSP = new JScrollPane(this.input);
        this.output = new JTextArea(20, 80);
        JScrollPane outputSP = new JScrollPane(this.output);
        container.setLayout(new BoxLayout(container, 1));
        container.add(inputSP);
        this.addButtonPanelToPane(container);
        container.add(outputSP);
    }

    private void addButtonPanelToPane(Container container) {
        JPanel horizontalButtonPanel = new JPanel();
        horizontalButtonPanel.setLayout(new FlowLayout());
        horizontalButtonPanel.setAlignmentX(0.5f);
        horizontalButtonPanel.add(this.wikiToHtmlButton);
        horizontalButtonPanel.add(this.htmlToWikiButton);
        horizontalButtonPanel.add(this.wikiToWikiPlaintext);
        horizontalButtonPanel.add(this.clearButton);
        container.add(horizontalButtonPanel);
    }

    class Wiki2PlainListener
    implements ActionListener {
        Wiki2PlainListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            String strData = BlikiConverter.this.input.getText();
            WikiModel wikiModel = new WikiModel(new Configuration(), Locale.ENGLISH, "${image}", "${title}");
            wikiModel.setUp();
            try {
                String result = wikiModel.render(new PlainTextConverter(), strData, false);
                BlikiConverter.this.output.setText(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                wikiModel.tearDown();
            }
        }
    }

    class Wiki2HtmlListener
    implements ActionListener {
        Wiki2HtmlListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent event) {
            String strData = BlikiConverter.this.input.getText();
            WikiModel wikiModel = new WikiModel(new Configuration(), Locale.ENGLISH, "${image}", "${title}");
            wikiModel.setUp();
            try {
                String result = wikiModel.render(strData, false);
                BlikiConverter.this.output.setText(result);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                wikiModel.tearDown();
            }
        }
    }

    class Html2WikiListener
    implements ActionListener {
        Html2WikiListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String strData = BlikiConverter.this.input.getText();
            HTML2WikiConverter conv = new HTML2WikiConverter(strData);
            String result = conv.toWiki(new ToWikipedia(true, true, true));
            BlikiConverter.this.output.setText(result);
        }
    }

    class ClearListener
    implements ActionListener {
        ClearListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            BlikiConverter.this.input.setText("");
            BlikiConverter.this.output.setText("");
        }
    }
}

