/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.api;

import info.bliki.htmlcleaner.util.HtmlForm;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class HtmlUtilities {
    public static final String FORM_TAG = "form";
    public static final String INPUT_TAG = "input";
    public static final String TEXTAREA_TAG = "textarea";
    private static SAXParserFactory mParserFactory = SAXParserFactory.newInstance();

    public static HtmlForm extractForm(String formID, String html) {
        int ndx2;
        String lowerCaseHtml = html.toLowerCase();
        String startTag = "<form ";
        String endTag = "</form>";
        int ndx = lowerCaseHtml.indexOf(startTag);
        while (ndx >= 0 && (ndx2 = lowerCaseHtml.indexOf(endTag, ndx + startTag.length())) > ndx) {
            String formHTML = html.substring(ndx, ndx2 + endTag.length());
            try {
                HtmlForm form = HtmlUtilities.parseForm(formID, formHTML, true);
                if (form != null) {
                    return form;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ndx = lowerCaseHtml.indexOf(startTag, ndx2 + endTag.length());
        }
        return null;
    }

    public static HtmlForm parseForm(String formID, String html, boolean trapExceptions) throws IOException {
        HtmlFormHandler handler = new HtmlFormHandler(formID);
        try {
            html = html.replaceAll("&nbsp;", " ");
            SAXParser parser = mParserFactory.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            reader.setContentHandler(handler);
            reader.parse(new InputSource(new StringReader(html)));
            return handler.getForm();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (trapExceptions) {
                return handler.getForm();
            }
            String errMsg = e.getMessage();
            String ioeMsg = null;
            ioeMsg = errMsg != null && errMsg.length() > 0 ? "invalid HTML (" + errMsg + ")" : "invalid HTML";
            throw new IOException(ioeMsg);
        }
    }

    public static class HtmlFormHandler
    extends DefaultHandler {
        private String mFormID;
        private boolean mInForm;
        private HtmlForm mForm;
        private HtmlForm.Element mCurrentElement;
        private StringBuffer mCurrentElementBuffer;

        public HtmlFormHandler(String formID) {
            if (formID == null) {
                throw new NullPointerException();
            }
            this.mFormID = formID;
        }

        public HtmlForm getForm() {
            return this.mForm;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String elementName = localName;
            if (elementName.length() == 0) {
                elementName = qName;
            }
            if (elementName.equalsIgnoreCase(HtmlUtilities.FORM_TAG)) {
                String id = null;
                String name = null;
                String action = null;
                String encType = null;
                int method = 1;
                int sz = attributes.getLength();
                for (int i = 0; i < sz; ++i) {
                    String lname = attributes.getLocalName(i);
                    if (lname.length() == 0) {
                        lname = attributes.getQName(i);
                    }
                    String value = attributes.getValue(i);
                    if (lname.equalsIgnoreCase("id")) {
                        if (!this.mFormID.equals(value)) {
                            return;
                        }
                        id = value;
                        this.mInForm = true;
                        continue;
                    }
                    if (lname.equalsIgnoreCase("name")) {
                        name = value;
                        continue;
                    }
                    if (lname.equalsIgnoreCase("method")) {
                        if (!"get".equalsIgnoreCase(value)) continue;
                        method = 0;
                        continue;
                    }
                    if (lname.equalsIgnoreCase("action")) {
                        action = value;
                        continue;
                    }
                    if (!lname.equalsIgnoreCase("enctype")) continue;
                    encType = value;
                }
                if (this.mInForm) {
                    this.mForm = new HtmlForm(id, name, method, action, encType);
                }
            } else if (this.mInForm && (elementName.equalsIgnoreCase(HtmlUtilities.INPUT_TAG) || elementName.equalsIgnoreCase(HtmlUtilities.TEXTAREA_TAG))) {
                int sz = attributes.getLength();
                HtmlForm.ElementAttribute[] elementAttributes = new HtmlForm.ElementAttribute[sz];
                for (int i = 0; i < sz; ++i) {
                    String aname = attributes.getLocalName(i);
                    if (aname.length() == 0) {
                        aname = attributes.getQName(i);
                    }
                    elementAttributes[i] = new HtmlForm.ElementAttribute(aname, attributes.getType(i), attributes.getValue(i));
                }
                this.mCurrentElement = new HtmlForm.Element(elementName, elementAttributes);
                this.mForm.addElement(this.mCurrentElement);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            String elementName = localName;
            if (elementName.length() == 0) {
                elementName = qName;
            }
            if (this.mInForm) {
                if (elementName.equalsIgnoreCase(HtmlUtilities.FORM_TAG)) {
                    this.mInForm = false;
                } else if (this.mCurrentElement != null && elementName.equalsIgnoreCase(this.mCurrentElement.getTag())) {
                    if (this.mCurrentElementBuffer != null) {
                        this.mCurrentElement.setEmbeddedText(this.mCurrentElementBuffer.toString());
                        this.mCurrentElementBuffer = null;
                    }
                    this.mCurrentElement = null;
                }
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.mCurrentElement != null && length > 0) {
                if (this.mCurrentElementBuffer == null) {
                    this.mCurrentElementBuffer = new StringBuffer();
                }
                this.mCurrentElementBuffer.append(ch, start, length);
            }
        }
    }
}

