/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.format;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.format.DayOfWeekNames;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B?\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nB\u0013\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00030\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lkotlinx/datetime/format/DayOfWeekNames;", "", "monday", "", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "names", "", "(Ljava/util/List;)V", "getNames", "()Ljava/util/List;", "equals", "", "other", "hashCode", "", "toString", "Companion", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nLocalDateFormat.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateFormat.kt\nkotlinx/datetime/format/DayOfWeekNames\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,450:1\n1#2:451\n1855#3,2:452\n*S KotlinDebug\n*F\n+ 1 LocalDateFormat.kt\nkotlinx/datetime/format/DayOfWeekNames\n*L\n125#1:452,2\n*E\n"})
public final class DayOfWeekNames {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> names;
    @NotNull
    private static final DayOfWeekNames ENGLISH_FULL;
    @NotNull
    private static final DayOfWeekNames ENGLISH_ABBREVIATED;

    public DayOfWeekNames(@NotNull List<String> names) {
        Intrinsics.checkNotNullParameter(names, (String)"names");
        this.names = names;
        if (!(this.names.size() == 7)) {
            boolean $i$a$-require-DayOfWeekNames$22 = false;
            String $i$a$-require-DayOfWeekNames$22 = "Day of week names must contain exactly 7 elements";
            throw new IllegalArgumentException($i$a$-require-DayOfWeekNames$22.toString());
        }
        Iterable $this$forEach$iv = (Iterable)CollectionsKt.getIndices((Collection)this.names);
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            int element$iv;
            int ix = element$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            if (!(((CharSequence)this.names.get(ix)).length() > 0)) {
                boolean bl2 = false;
                String string = "A day-of-week name can not be empty";
                throw new IllegalArgumentException(string.toString());
            }
            for (int ix2 = 0; ix2 < ix; ++ix2) {
                if (!Intrinsics.areEqual((Object)this.names.get(ix), (Object)this.names.get(ix2))) continue;
                boolean bl3 = false;
                String string = "Day-of-week names must be unique, but '" + this.names.get(ix) + "' was repeated";
                throw new IllegalArgumentException(string.toString());
            }
        }
    }

    @NotNull
    public final List<String> getNames() {
        return this.names;
    }

    public DayOfWeekNames(@NotNull String monday, @NotNull String tuesday, @NotNull String wednesday, @NotNull String thursday, @NotNull String friday, @NotNull String saturday, @NotNull String sunday) {
        Intrinsics.checkNotNullParameter((Object)monday, (String)"monday");
        Intrinsics.checkNotNullParameter((Object)tuesday, (String)"tuesday");
        Intrinsics.checkNotNullParameter((Object)wednesday, (String)"wednesday");
        Intrinsics.checkNotNullParameter((Object)thursday, (String)"thursday");
        Intrinsics.checkNotNullParameter((Object)friday, (String)"friday");
        Intrinsics.checkNotNullParameter((Object)saturday, (String)"saturday");
        Intrinsics.checkNotNullParameter((Object)sunday, (String)"sunday");
        Object[] objectArray = new String[]{monday, tuesday, wednesday, thursday, friday, saturday, sunday};
        this(CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default((Iterable)this.names, (CharSequence)", ", (CharSequence)"DayOfWeekNames(", (CharSequence)")", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof DayOfWeekNames && Intrinsics.areEqual(this.names, ((DayOfWeekNames)other).names);
    }

    public int hashCode() {
        return ((Object)this.names).hashCode();
    }

    static {
        Object[] objectArray = new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"};
        ENGLISH_FULL = new DayOfWeekNames(CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"Mon", "Tue", "Wed", "Thu", "Fri", "Sat", "Sun"};
        ENGLISH_ABBREVIATED = new DayOfWeekNames(CollectionsKt.listOf((Object[])objectArray));
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lkotlinx/datetime/format/DayOfWeekNames$Companion;", "", "()V", "ENGLISH_ABBREVIATED", "Lkotlinx/datetime/format/DayOfWeekNames;", "getENGLISH_ABBREVIATED", "()Lkotlinx/datetime/format/DayOfWeekNames;", "ENGLISH_FULL", "getENGLISH_FULL", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DayOfWeekNames getENGLISH_FULL() {
            return ENGLISH_FULL;
        }

        @NotNull
        public final DayOfWeekNames getENGLISH_ABBREVIATED() {
            return ENGLISH_ABBREVIATED;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

