/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.ColorARGB;
import net.osmand.core.jni.FColorARGB;
import net.osmand.core.jni.FColorRGB;
import net.osmand.core.jni.MapMarker;
import net.osmand.core.jni.MapMarkersCollection;
import net.osmand.core.jni.Model3D;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_QString_OsmAnd__FColorARGB_t;
import net.osmand.core.jni.SWIGTYPE_p_QHashT_void_const_p_sk_spT_SkImage_const_t_t;
import net.osmand.core.jni.SWIGTYPE_p_sk_spT_SkImage_const_t;
import net.osmand.core.jni.SWIGTYPE_p_void;
import net.osmand.core.jni.SingleSkImage;
import net.osmand.core.jni.TextRasterizer;

public class MapMarkerBuilder {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected MapMarkerBuilder(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(MapMarkerBuilder mapMarkerBuilder) {
        return mapMarkerBuilder == null ? 0L : mapMarkerBuilder.swigCPtr;
    }

    protected static long swigRelease(MapMarkerBuilder mapMarkerBuilder) {
        long l = 0L;
        if (mapMarkerBuilder != null) {
            if (!mapMarkerBuilder.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = mapMarkerBuilder.swigCPtr;
            mapMarkerBuilder.swigCMemOwn = false;
            mapMarkerBuilder.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_MapMarkerBuilder(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public MapMarkerBuilder() {
        this(OsmAndCoreJNI.new_MapMarkerBuilder(), true);
    }

    public boolean isHidden() {
        return OsmAndCoreJNI.MapMarkerBuilder_isHidden(this.swigCPtr, this);
    }

    public MapMarkerBuilder setIsHidden(boolean bl) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setIsHidden(this.swigCPtr, this, bl), false);
    }

    public int getMarkerId() {
        return OsmAndCoreJNI.MapMarkerBuilder_getMarkerId(this.swigCPtr, this);
    }

    public MapMarkerBuilder setMarkerId(int n) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setMarkerId(this.swigCPtr, this, n), false);
    }

    public int getBaseOrder() {
        return OsmAndCoreJNI.MapMarkerBuilder_getBaseOrder(this.swigCPtr, this);
    }

    public MapMarkerBuilder setBaseOrder(int n) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setBaseOrder(this.swigCPtr, this, n), false);
    }

    public boolean isAccuracyCircleSupported() {
        return OsmAndCoreJNI.MapMarkerBuilder_isAccuracyCircleSupported(this.swigCPtr, this);
    }

    public MapMarkerBuilder setIsAccuracyCircleSupported(boolean bl) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setIsAccuracyCircleSupported(this.swigCPtr, this, bl), false);
    }

    public boolean isAccuracyCircleVisible() {
        return OsmAndCoreJNI.MapMarkerBuilder_isAccuracyCircleVisible(this.swigCPtr, this);
    }

    public MapMarkerBuilder setIsAccuracyCircleVisible(boolean bl) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setIsAccuracyCircleVisible(this.swigCPtr, this, bl), false);
    }

    public double getAccuracyCircleRadius() {
        return OsmAndCoreJNI.MapMarkerBuilder_getAccuracyCircleRadius(this.swigCPtr, this);
    }

    public MapMarkerBuilder setAccuracyCircleRadius(double d) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setAccuracyCircleRadius(this.swigCPtr, this, d), false);
    }

    public FColorRGB getAccuracyCircleBaseColor() {
        return new FColorRGB(OsmAndCoreJNI.MapMarkerBuilder_getAccuracyCircleBaseColor(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setAccuracyCircleBaseColor(FColorRGB fColorRGB) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setAccuracyCircleBaseColor(this.swigCPtr, this, FColorRGB.getCPtr(fColorRGB), fColorRGB), false);
    }

    public PointI getPosition() {
        return new PointI(OsmAndCoreJNI.MapMarkerBuilder_getPosition(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setPosition(PointI pointI) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPosition(this.swigCPtr, this, PointI.getCPtr(pointI), pointI), false);
    }

    public float getHeight() {
        return OsmAndCoreJNI.MapMarkerBuilder_getHeight(this.swigCPtr, this);
    }

    public MapMarkerBuilder setHeight(float f) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setHeight(this.swigCPtr, this, f), false);
    }

    public float getElevationScaleFactor() {
        return OsmAndCoreJNI.MapMarkerBuilder_getElevationScaleFactor(this.swigCPtr, this);
    }

    public MapMarkerBuilder setElevationScaleFactor(float f) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setElevationScaleFactor(this.swigCPtr, this, f), false);
    }

    public SWIGTYPE_p_sk_spT_SkImage_const_t getPinIcon() {
        return new SWIGTYPE_p_sk_spT_SkImage_const_t(OsmAndCoreJNI.MapMarkerBuilder_getPinIcon(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setPinIcon(SingleSkImage singleSkImage) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPinIcon(this.swigCPtr, this, SingleSkImage.getCPtr(singleSkImage), singleSkImage), false);
    }

    public MapMarker.PinIconVerticalAlignment getPinIconVerticalAlignment() {
        return MapMarker.PinIconVerticalAlignment.swigToEnum(OsmAndCoreJNI.MapMarkerBuilder_getPinIconVerticalAlignment(this.swigCPtr, this));
    }

    public MapMarker.PinIconHorisontalAlignment getPinIconHorisontalAlignment() {
        return MapMarker.PinIconHorisontalAlignment.swigToEnum(OsmAndCoreJNI.MapMarkerBuilder_getPinIconHorisontalAlignment(this.swigCPtr, this));
    }

    public MapMarkerBuilder setPinIconVerticalAlignment(MapMarker.PinIconVerticalAlignment pinIconVerticalAlignment) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPinIconVerticalAlignment(this.swigCPtr, this, pinIconVerticalAlignment.swigValue()), false);
    }

    public MapMarkerBuilder setPinIconHorisontalAlignment(MapMarker.PinIconHorisontalAlignment pinIconHorisontalAlignment) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPinIconHorisontalAlignment(this.swigCPtr, this, pinIconHorisontalAlignment.swigValue()), false);
    }

    public PointI getPinIconOffset() {
        return new PointI(OsmAndCoreJNI.MapMarkerBuilder_getPinIconOffset(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setPinIconOffset(PointI pointI) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPinIconOffset(this.swigCPtr, this, PointI.getCPtr(pointI), pointI), false);
    }

    public ColorARGB getPinIconModulationColor() {
        return new ColorARGB(OsmAndCoreJNI.MapMarkerBuilder_getPinIconModulationColor(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setPinIconModulationColor(ColorARGB colorARGB) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setPinIconModulationColor(this.swigCPtr, this, ColorARGB.getCPtr(colorARGB), colorARGB), false);
    }

    public String getCaption() {
        return OsmAndCoreJNI.MapMarkerBuilder_getCaption(this.swigCPtr, this);
    }

    public MapMarkerBuilder setCaption(String string) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setCaption(this.swigCPtr, this, string), false);
    }

    public TextRasterizer.Style getCaptionStyle() {
        return new TextRasterizer.Style(OsmAndCoreJNI.MapMarkerBuilder_getCaptionStyle(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder setCaptionStyle(TextRasterizer.Style style) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setCaptionStyle(this.swigCPtr, this, TextRasterizer.Style.getCPtr(style), style), false);
    }

    public double getCaptionTopSpace() {
        return OsmAndCoreJNI.MapMarkerBuilder_getCaptionTopSpace(this.swigCPtr, this);
    }

    public MapMarkerBuilder setCaptionTopSpace(double d) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setCaptionTopSpace(this.swigCPtr, this, d), false);
    }

    public SWIGTYPE_p_QHashT_void_const_p_sk_spT_SkImage_const_t_t getOnMapSurfaceIcons() {
        return new SWIGTYPE_p_QHashT_void_const_p_sk_spT_SkImage_const_t_t(OsmAndCoreJNI.MapMarkerBuilder_getOnMapSurfaceIcons(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder addOnMapSurfaceIcon(SWIGTYPE_p_void sWIGTYPE_p_void, SingleSkImage singleSkImage) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_addOnMapSurfaceIcon(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void), SingleSkImage.getCPtr(singleSkImage), singleSkImage), false);
    }

    public MapMarkerBuilder removeOnMapSurfaceIcon(SWIGTYPE_p_void sWIGTYPE_p_void) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_removeOnMapSurfaceIcon(this.swigCPtr, this, SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void)), false);
    }

    public MapMarkerBuilder clearOnMapSurfaceIcons() {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_clearOnMapSurfaceIcons(this.swigCPtr, this), false);
    }

    public Model3D getModel3D() {
        long l = OsmAndCoreJNI.MapMarkerBuilder_getModel3D(this.swigCPtr, this);
        return l == 0L ? null : new Model3D(l, true);
    }

    public MapMarkerBuilder setModel3D(Model3D model3D) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setModel3D(this.swigCPtr, this, Model3D.getCPtr(model3D), model3D), false);
    }

    public SWIGTYPE_p_QHashT_QString_OsmAnd__FColorARGB_t getModel3DCustomMaterialColors() {
        return new SWIGTYPE_p_QHashT_QString_OsmAnd__FColorARGB_t(OsmAndCoreJNI.MapMarkerBuilder_getModel3DCustomMaterialColors(this.swigCPtr, this), true);
    }

    public MapMarkerBuilder addModel3DCustomMaterialColor(String string, FColorARGB fColorARGB) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_addModel3DCustomMaterialColor(this.swigCPtr, this, string, FColorARGB.getCPtr(fColorARGB), fColorARGB), false);
    }

    public MapMarkerBuilder removeModel3DCustomMaterialColor(String string) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_removeModel3DCustomMaterialColor(this.swigCPtr, this, string), false);
    }

    public MapMarkerBuilder clearModel3DCustomMaterialColors() {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_clearModel3DCustomMaterialColors(this.swigCPtr, this), false);
    }

    public int getModel3DMaxSizeInPixels() {
        return OsmAndCoreJNI.MapMarkerBuilder_getModel3DMaxSizeInPixels(this.swigCPtr, this);
    }

    public MapMarkerBuilder setModel3DMaxSizeInPixels(int n) {
        return new MapMarkerBuilder(OsmAndCoreJNI.MapMarkerBuilder_setModel3DMaxSizeInPixels(this.swigCPtr, this, n), false);
    }

    public MapMarker buildAndAddToCollection(MapMarkersCollection mapMarkersCollection) {
        long l = OsmAndCoreJNI.MapMarkerBuilder_buildAndAddToCollection(this.swigCPtr, this, MapMarkersCollection.getCPtr(mapMarkersCollection), mapMarkersCollection);
        return l == 0L ? null : new MapMarker(l, true);
    }
}

