/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.FColorRGB;
import net.osmand.core.jni.OsmAndCoreJNI;

public class FogConfiguration {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected FogConfiguration(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(FogConfiguration fogConfiguration) {
        return fogConfiguration == null ? 0L : fogConfiguration.swigCPtr;
    }

    protected static long swigRelease(FogConfiguration fogConfiguration) {
        long l = 0L;
        if (fogConfiguration != null) {
            if (!fogConfiguration.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = fogConfiguration.swigCPtr;
            fogConfiguration.swigCMemOwn = false;
            fogConfiguration.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_FogConfiguration(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public FogConfiguration() {
        this(OsmAndCoreJNI.new_FogConfiguration(), true);
    }

    public void setDistanceToFog(float f) {
        OsmAndCoreJNI.FogConfiguration_distanceToFog_set(this.swigCPtr, this, f);
    }

    public float getDistanceToFog() {
        return OsmAndCoreJNI.FogConfiguration_distanceToFog_get(this.swigCPtr, this);
    }

    public void setOriginFactor(float f) {
        OsmAndCoreJNI.FogConfiguration_originFactor_set(this.swigCPtr, this, f);
    }

    public float getOriginFactor() {
        return OsmAndCoreJNI.FogConfiguration_originFactor_get(this.swigCPtr, this);
    }

    public void setHeightOriginFactor(float f) {
        OsmAndCoreJNI.FogConfiguration_heightOriginFactor_set(this.swigCPtr, this, f);
    }

    public float getHeightOriginFactor() {
        return OsmAndCoreJNI.FogConfiguration_heightOriginFactor_get(this.swigCPtr, this);
    }

    public void setDensity(float f) {
        OsmAndCoreJNI.FogConfiguration_density_set(this.swigCPtr, this, f);
    }

    public float getDensity() {
        return OsmAndCoreJNI.FogConfiguration_density_get(this.swigCPtr, this);
    }

    public void setColor(FColorRGB fColorRGB) {
        OsmAndCoreJNI.FogConfiguration_color_set(this.swigCPtr, this, FColorRGB.getCPtr(fColorRGB), fColorRGB);
    }

    public FColorRGB getColor() {
        long l = OsmAndCoreJNI.FogConfiguration_color_get(this.swigCPtr, this);
        return l == 0L ? null : new FColorRGB(l, false);
    }

    public boolean isValid() {
        return OsmAndCoreJNI.FogConfiguration_isValid(this.swigCPtr, this);
    }

    public boolean equals(FogConfiguration fogConfiguration) {
        return OsmAndCoreJNI.FogConfiguration_equals(this.swigCPtr, this, FogConfiguration.getCPtr(fogConfiguration), fogConfiguration);
    }

    public boolean notEquals(FogConfiguration fogConfiguration) {
        return OsmAndCoreJNI.FogConfiguration_notEquals(this.swigCPtr, this, FogConfiguration.getCPtr(fogConfiguration), fogConfiguration);
    }
}

