/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.Address;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QStringStringHash;
import net.osmand.core.jni.Street;
import net.osmand.core.jni.StreetGroup;

public class Building
extends Address {
    private transient long swigCPtr;
    private transient boolean swigCMemOwnDerived;

    protected Building(long l, boolean bl) {
        super(OsmAndCoreJNI.Building_SWIGSmartPtrUpcast(l), true);
        this.swigCMemOwnDerived = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Building building) {
        return building == null ? 0L : building.swigCPtr;
    }

    @Override
    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwnDerived = bl;
        super.swigSetCMemOwn(bl);
    }

    @Override
    protected void finalize() {
        this.delete();
    }

    @Override
    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwnDerived) {
                this.swigCMemOwnDerived = false;
                OsmAndCoreJNI.delete_Building(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
        super.delete();
    }

    public Building(Street street) {
        this(OsmAndCoreJNI.new_Building__SWIG_0(Street.getCPtr(street), street), true);
    }

    public Building(StreetGroup streetGroup) {
        this(OsmAndCoreJNI.new_Building__SWIG_1(StreetGroup.getCPtr(streetGroup), streetGroup), true);
    }

    @Override
    public String toString() {
        return OsmAndCoreJNI.Building_toString(this.swigCPtr, this);
    }

    public Street getStreet() {
        long l = OsmAndCoreJNI.Building_street_get(this.swigCPtr, this);
        return l == 0L ? null : new Street(l, true);
    }

    public StreetGroup getStreetGroup() {
        long l = OsmAndCoreJNI.Building_streetGroup_get(this.swigCPtr, this);
        return l == 0L ? null : new StreetGroup(l, true);
    }

    public void setPostcode(String string) {
        OsmAndCoreJNI.Building_postcode_set(this.swigCPtr, this, string);
    }

    public String getPostcode() {
        return OsmAndCoreJNI.Building_postcode_get(this.swigCPtr, this);
    }

    public void setInterpolation(Interpolation interpolation) {
        OsmAndCoreJNI.Building_interpolation_set(this.swigCPtr, this, interpolation.swigValue());
    }

    public Interpolation getInterpolation() {
        return Interpolation.swigToEnum(OsmAndCoreJNI.Building_interpolation_get(this.swigCPtr, this));
    }

    public void setInterpolationInterval(int n) {
        OsmAndCoreJNI.Building_interpolationInterval_set(this.swigCPtr, this, n);
    }

    public int getInterpolationInterval() {
        return OsmAndCoreJNI.Building_interpolationInterval_get(this.swigCPtr, this);
    }

    public void setInterpolationNativeName(String string) {
        OsmAndCoreJNI.Building_interpolationNativeName_set(this.swigCPtr, this, string);
    }

    public String getInterpolationNativeName() {
        return OsmAndCoreJNI.Building_interpolationNativeName_get(this.swigCPtr, this);
    }

    public void setInterpolationLocalizedNames(QStringStringHash qStringStringHash) {
        OsmAndCoreJNI.Building_interpolationLocalizedNames_set(this.swigCPtr, this, QStringStringHash.getCPtr(qStringStringHash), qStringStringHash);
    }

    public QStringStringHash getInterpolationLocalizedNames() {
        long l = OsmAndCoreJNI.Building_interpolationLocalizedNames_get(this.swigCPtr, this);
        return l == 0L ? null : new QStringStringHash(l, false);
    }

    public void setInterpolationPosition31(PointI pointI) {
        OsmAndCoreJNI.Building_interpolationPosition31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getInterpolationPosition31() {
        long l = OsmAndCoreJNI.Building_interpolationPosition31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public float evaluateInterpolation(String string) {
        return OsmAndCoreJNI.Building_evaluateInterpolation(this.swigCPtr, this, string);
    }

    public boolean belongsToInterpolation(String string) {
        return OsmAndCoreJNI.Building_belongsToInterpolation(this.swigCPtr, this, string);
    }

    public String getInterpolationName(double d) {
        return OsmAndCoreJNI.Building_getInterpolationName(this.swigCPtr, this, d);
    }

    public static enum Interpolation {
        Disabled(OsmAndCoreJNI.Building_Interpolation_Disabled_get()),
        All(OsmAndCoreJNI.Building_Interpolation_All_get()),
        Even(OsmAndCoreJNI.Building_Interpolation_Even_get()),
        Odd(OsmAndCoreJNI.Building_Interpolation_Odd_get()),
        Alphabetic(OsmAndCoreJNI.Building_Interpolation_Alphabetic_get());

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static Interpolation swigToEnum(int n) {
            Interpolation[] interpolationArray = (Interpolation[])Interpolation.class.getEnumConstants();
            if (n < interpolationArray.length && n >= 0 && interpolationArray[n].swigValue == n) {
                return interpolationArray[n];
            }
            for (Interpolation interpolation : interpolationArray) {
                if (interpolation.swigValue != n) continue;
                return interpolation;
            }
            throw new IllegalArgumentException("No enum " + Interpolation.class + " with value " + n);
        }

        private Interpolation() {
            this.swigValue = SwigNext.next++;
        }

        private Interpolation(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private Interpolation(Interpolation interpolation) {
            this.swigValue = interpolation.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

