/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.AddressType;
import net.osmand.core.jni.ObfAddressSectionInfo;
import net.osmand.core.jni.ObfObjectId;
import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QStringStringHash;

public class Address {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;

    protected Address(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(Address address) {
        return address == null ? 0L : address.swigCPtr;
    }

    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwn = bl;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_Address(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public String toString() {
        return OsmAndCoreJNI.Address_toString(this.swigCPtr, this);
    }

    public String getName(String string, boolean bl) {
        return OsmAndCoreJNI.Address_getName(this.swigCPtr, this, string, bl);
    }

    public ObfAddressSectionInfo getObfSection() {
        long l = OsmAndCoreJNI.Address_obfSection_get(this.swigCPtr, this);
        return l == 0L ? null : new ObfAddressSectionInfo(l, true);
    }

    public AddressType getAddressType() {
        return AddressType.swigToEnum(OsmAndCoreJNI.Address_addressType_get(this.swigCPtr, this));
    }

    public void setId(ObfObjectId obfObjectId) {
        OsmAndCoreJNI.Address_id_set(this.swigCPtr, this, ObfObjectId.getCPtr(obfObjectId), obfObjectId);
    }

    public ObfObjectId getId() {
        long l = OsmAndCoreJNI.Address_id_get(this.swigCPtr, this);
        return l == 0L ? null : new ObfObjectId(l, false);
    }

    public void setPosition31(PointI pointI) {
        OsmAndCoreJNI.Address_position31_set(this.swigCPtr, this, PointI.getCPtr(pointI), pointI);
    }

    public PointI getPosition31() {
        long l = OsmAndCoreJNI.Address_position31_get(this.swigCPtr, this);
        return l == 0L ? null : new PointI(l, false);
    }

    public void setNativeName(String string) {
        OsmAndCoreJNI.Address_nativeName_set(this.swigCPtr, this, string);
    }

    public String getNativeName() {
        return OsmAndCoreJNI.Address_nativeName_get(this.swigCPtr, this);
    }

    public void setLocalizedNames(QStringStringHash qStringStringHash) {
        OsmAndCoreJNI.Address_localizedNames_set(this.swigCPtr, this, QStringStringHash.getCPtr(qStringStringHash), qStringStringHash);
    }

    public QStringStringHash getLocalizedNames() {
        long l = OsmAndCoreJNI.Address_localizedNames_get(this.swigCPtr, this);
        return l == 0L ? null : new QStringStringHash(l, false);
    }
}

