/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.job.internal;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.JobStatusStore;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.job.internal.JobStatusStorage;

@Component
@Singleton
public class DefaultJobStatusStorage
implements JobStatusStorage {
    @Inject
    private JobStatusStore store;

    @Override
    public JobStatus getJobStatus(String id) {
        return this.getJobStatus(id != null ? Arrays.asList(id) : (List<String>)null);
    }

    @Override
    public JobStatus getJobStatus(List<String> id) {
        return this.store.getJobStatus(id);
    }

    @Override
    public void store(JobStatus status) {
        this.store.store(status);
    }

    @Override
    public void storeAsync(JobStatus status) {
        this.store.storeAsync(status);
    }

    @Override
    public JobStatus remove(String id) {
        return this.remove(Arrays.asList(id));
    }

    @Override
    public JobStatus remove(List<String> id) {
        JobStatus status = this.store.getJobStatus(id);
        if (status != null) {
            this.store.remove(id);
        }
        return status;
    }
}

